/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupobjectlifecycle;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.backupRestore.objectLifecycle.serdes.Header;
import kafka.backupRestore.objectLifecycle.serdes.LifecycleManagerState;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupobjectlifecycle.LifecycleManager;
import kafka.tier.backupobjectlifecycle.LifecycleManagerConfig;
import kafka.tier.backupobjectlifecycle.NameAndId;
import kafka.tier.backupobjectlifecycle.StateManager;
import kafka.tier.backupobjectlifecycle.StateManagerConfig;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u000f\u001f\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004@\u0001\u0001\u0006IA\r\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u00199\u0005\u0001)A\u0005\u0005\"9\u0001\n\u0001a\u0001\n\u0003I\u0005b\u0002*\u0001\u0001\u0004%\ta\u0015\u0005\u00073\u0002\u0001\u000b\u0015\u0002&\t\u000fi\u0003\u0001\u0019!C\u00017\"9!\r\u0001a\u0001\n\u0003\u0019\u0007BB3\u0001A\u0003&A\fC\u0004g\u0001\t\u0007I\u0011A4\t\r9\u0004\u0001\u0015!\u0003i\u0011\u001dy\u0007A1A\u0005\u0002ADa\u0001\u001e\u0001!\u0002\u0013\t\bbB;\u0001\u0005\u0004%\tA\u001e\u0005\u0007{\u0002\u0001\u000b\u0011B<\t\u000fy\u0004!\u0019!C\u0001\u007f\"A\u0011\u0011\u0002\u0001!\u0002\u0013\t\t\u0001C\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002\u000e!9\u0011\u0011\u0006\u0001\u0005\u0002\u00055\u0001bBA\u0017\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003c\u0001A\u0011AA\u0007\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\n)#)Y2lkB|%M[3di2Kg-Z2zG2,W*\u00198bO\u0016\u0014XK\\5u)\u0016\u001cHo\u001d\u0006\u0003?\u0001\nQCY1dWV\u0004xN\u00196fGRd\u0017NZ3ds\u000edWM\u0003\u0002\"E\u0005!A/[3s\u0015\u0005\u0019\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001\u001f\u0003\u0011!\u0018.\\3\u0016\u0003I\u0002\"aM\u001f\u000e\u0003QR!!\u000e\u001c\u0002\u000bU$\u0018\u000e\\:\u000b\u0005]B\u0014AB2p[6|gN\u0003\u0002$s)\u0011!hO\u0001\u0007CB\f7\r[3\u000b\u0003q\n1a\u001c:h\u0013\tqDG\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012A\u0011\t\u0003\u0007\u0016k\u0011\u0001\u0012\u0006\u0003\u0001ZJ!A\u0012#\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\u0003qe>\u00048/F\u0001K!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0003vi&d'\"A(\u0002\t)\fg/Y\u0005\u0003#2\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%\u0001(o\u001c9t?\u0012*\u0017\u000f\u0006\u0002U/B\u0011q%V\u0005\u0003-\"\u0012A!\u00168ji\"9\u0001lBA\u0001\u0002\u0004Q\u0015a\u0001=%c\u00051\u0001O]8qg\u0002\naaY8oM&<W#\u0001/\u0011\u0005u\u0003W\"\u00010\u000b\u0005}\u0013\u0013AB:feZ,'/\u0003\u0002b=\nY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0003)\u0012Dq\u0001\u0017\u0006\u0002\u0002\u0003\u0007A,A\u0004d_:4\u0017n\u001a\u0011\u0002\u0013\rdWo\u001d;fe&#W#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-t\u0015\u0001\u00027b]\u001eL!!\u001c6\u0003\rM#(/\u001b8h\u0003)\u0019G.^:uKJLE\rI\u0001\u0006C\u0012l\u0017N\\\u000b\u0002cB\u0011QL]\u0005\u0003gz\u0013Q\"\u00138uKJt\u0017\r\\!e[&t\u0017AB1e[&t\u0007%A\u0006pE*,7\r^*u_J,W#A<\u0011\u0005a\\X\"A=\u000b\u0005i\u0004\u0013!B:u_J,\u0017B\u0001?z\u0005miunY6J]6+Wn\u001c:z)&,'o\u00142kK\u000e$8\u000b^8sK\u0006aqN\u00196fGR\u001cFo\u001c:fA\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\u00065\t\u0001%C\u0002\u0002\b\u0001\u0012\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002#Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007%A\u0010uKN$8\tT'NkN$hj\u001c;EK2,G/\u001a'jm\u0016|%M[3diN$\u0012\u0001\u0016\u0015\u0004)\u0005E\u0001\u0003BA\n\u0003Ci!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0004CBL'\u0002BA\u000e\u0003;\tqA[;qSR,'OC\u0002\u0002 m\nQA[;oSRLA!a\t\u0002\u0016\t!A+Z:u\u0003\u0015\"Xm\u001d;MS\u001a,7-_2mK6\u000bg.Y4feN#\u0018\r^3ESN\u001c\u0017M\u001d3DCN,7\u000fK\u0002\u0016\u0003#\t\u0011\u0006^3ti\u000ecUJU3ukJt7/\u00169eCR,Gm\u0015;bi\u0016\fe\r^3s\u0007\",7m\u001b9pS:$\bf\u0001\f\u0002\u0012\u0005YB/Z:u%\u0016$XM\u001c;j_:$vNQ1dWV\u00048i\u001c8gS\u001eD3aFA\t\u0003m!Xm\u001d;SK\u000e|gNZ5hkJ,')Y2lkB\u0004v\u000e\\5ds\"\u001a\u0001$!\u0005\u0002!1Lg-Z2zG2,W*\u00198bO\u0016\u0014H\u0003BA\u001d\u0003\u007f\u00012aLA\u001e\u0013\r\tiD\b\u0002\u0011\u0019&4WmY=dY\u0016l\u0015M\\1hKJDa!^\rA\u0002\u0005\u0005\u0003c\u0001=\u0002D%\u0019\u0011QI=\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\fq#\u001a=ue\u0006\u001cG\u000f\u0015:fM&D\u0018I\u001c3D_6\u0004\u0018M]3\u0015\u0011\u0005-\u0013\u0011KA5\u0003g\u00022aJA'\u0013\r\ty\u0005\u000b\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019F\u0007a\u0001\u0003+\n1a[3z!\u0011\t9&!\u001a\u000f\t\u0005e\u0013\u0011\r\t\u0004\u00037BSBAA/\u0015\r\ty\u0006J\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r\u0004&\u0001\u0004Qe\u0016$WMZ\u0005\u0004[\u0006\u001d$bAA2Q!9\u00111\u000e\u000eA\u0002\u00055\u0014\u0001C8cU\u0016\u001cG/\u00133\u0011\u0007-\u000by'C\u0002\u0002r1\u0013A!V+J\t\"1aP\u0007a\u0001\u0003\u0003\t\u0001DY1dWV\u0004xJ\u00196fGRd\u0015n\u001d;t!J,7/\u001a8u)\u0019\tY%!\u001f\u0002~!9\u00111P\u000eA\u0002\u0005U\u0013\u0001\u00023bi\u0016Dq!a \u001c\u0001\u0004\t\t)A\u0003oC6,7\u000f\u0005\u0004\u0002\u0004\u00065\u0015Q\u000b\b\u0005\u0003\u000b\u000bII\u0004\u0003\u0002\\\u0005\u001d\u0015\"A\u0015\n\u0007\u0005-\u0005&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0015\u0011\u0013\u0002\u0005\u0019&\u001cHOC\u0002\u0002\f\"\nA%\u001e9m_\u0006$')Y2lkB|%M[3diNd\u0015n\u001d;XSRDG)^7ns\u0012\u000bG/\u0019\u000b\u0006)\u0006]\u0015\u0011\u0014\u0005\b\u0003wb\u0002\u0019AA+\u0011\u001d\ty\b\ba\u0001\u0003\u0003\u0003")
public class BackupObjectLifecycleManagerUnitTests {
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
    private KafkaConfig config;
    private final String clusterId;
    private final InternalAdmin admin;
    private final MockInMemoryTierObjectStore objectStore;
    private final TopicIdPartition topicIdPartition;

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Properties props() {
        return this.props;
    }

    public void props_$eq(Properties x$1) {
        this.props = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public InternalAdmin admin() {
        return this.admin;
    }

    public MockInMemoryTierObjectStore objectStore() {
        return this.objectStore;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Test
    public void testCLMMustNotDeleteLiveObjects() {
        long currTimeMs = this.time().milliseconds();
        String currDateStr = StateManager.convertToDateKey((Long)Predef$.MODULE$.long2Long(currTimeMs));
        UUID obj1Id = UUID.randomUUID();
        UUID obj2Id = UUID.randomUUID();
        int obj1BaseOffset = 0;
        int obj2BaseOffset = 100;
        String obj1Prefix = "00000001";
        String obj2Prefix = "00000100";
        File obj1Log = File.createTempFile(obj1Prefix, ".log");
        File obj2Log = File.createTempFile(obj2Prefix, ".log");
        File obj1Index = File.createTempFile(obj1Prefix, ".index");
        File obj2Index = File.createTempFile(obj2Prefix, ".index");
        File obj1TimeIndex = File.createTempFile(obj1Prefix, ".timeindex");
        File obj2TimeIndex = File.createTempFile(obj2Prefix, ".timeindex");
        TierObjectStore.ObjectMetadata obj1Metadata = new TierObjectStore.ObjectMetadata(this.topicIdPartition(), obj1Id, 0, (long)obj1BaseOffset, false, false, false, TierObjectStore.OpaqueData.ZEROED);
        TierObjectStore.ObjectMetadata obj2Metadata = new TierObjectStore.ObjectMetadata(this.topicIdPartition(), obj2Id, 0, (long)obj2BaseOffset, false, false, false, TierObjectStore.OpaqueData.ZEROED);
        this.objectStore().putSegment(obj1Metadata, obj1Log, obj1Index, obj1TimeIndex, Optional.empty(), Optional.empty(), Optional.empty());
        this.objectStore().putSegment(obj2Metadata, obj2Log, obj2Index, obj2TimeIndex, Optional.empty(), Optional.empty(), Optional.empty());
        this.objectStore().deleteSegment(obj2Metadata);
        HashMap dateToDeletionLists = new HashMap();
        ArrayList<LifecycleManager.BlobMetadata> blobs = new ArrayList<LifecycleManager.BlobMetadata>();
        HashMap<TopicIdPartition, ArrayList<LifecycleManager.BlobMetadata>> tpIdToBlobs = new HashMap<TopicIdPartition, ArrayList<LifecycleManager.BlobMetadata>>();
        blobs.add(new LifecycleManager.BlobMetadata(obj1Id.toString(), Predef$.MODULE$.long2Long(currTimeMs), Predef$.MODULE$.int2Integer(0)));
        blobs.add(new LifecycleManager.BlobMetadata(obj2Id.toString(), Predef$.MODULE$.long2Long(currTimeMs), Predef$.MODULE$.int2Integer(0)));
        tpIdToBlobs.put(this.topicIdPartition(), blobs);
        dateToDeletionLists.put(currDateStr, tpIdToBlobs);
        this.time().setCurrentTimeMs(currTimeMs + 10L);
        java.util.List objectsFinalizedForDeletion = this.lifecycleManager((TierObjectStore)this.objectStore()).retrieveObjectsEligibleForDeletion(Predef$.MODULE$.long2Long(this.time().milliseconds()), dateToDeletionLists);
        Predef$.MODULE$.assert(objectsFinalizedForDeletion.size() == 3);
        objectsFinalizedForDeletion.forEach(o -> Predef$.MODULE$.assert(this.extractPrefixAndCompare(o.key(), obj2Id, this.topicIdPartition())));
        Predef$.MODULE$.assert(dateToDeletionLists.isEmpty());
    }

    @Test
    public void testLifecycleManagerStateDiscardCases() {
        LifecycleManager clm = this.lifecycleManager((TierObjectStore)this.objectStore());
        FlatBufferBuilder builder = new FlatBufferBuilder(512);
        int headerOffset = Header.createHeader((FlatBufferBuilder)builder, (int)1002);
        LifecycleManagerState.startLifecycleManagerState((FlatBufferBuilder)builder);
        LifecycleManagerState.addHeader((FlatBufferBuilder)builder, (int)headerOffset);
        int finishOffset = LifecycleManagerState.endLifecycleManagerState((FlatBufferBuilder)builder);
        builder.finishSizePrefixed(finishOffset);
        this.objectStore().putBuf(new StringBuilder(26).append("3/").append(this.clusterId()).append(".lifecycle-manager-state").toString(), new HashMap(), builder.dataBuffer().slice());
        Assertions.assertFalse((boolean)clm.lifecycleManagerState(Predef$.MODULE$.long2Long(this.time().milliseconds())).isPresent());
        long lastRunTs = this.time().milliseconds() - TimeUnit.MILLISECONDS.convert(8L, TimeUnit.DAYS);
        FlatBufferBuilder builder2 = new FlatBufferBuilder(512);
        int headerOffset2 = Header.createHeader((FlatBufferBuilder)builder2, (int)1);
        LifecycleManagerState.startLifecycleManagerState((FlatBufferBuilder)builder2);
        LifecycleManagerState.addHeader((FlatBufferBuilder)builder2, (int)headerOffset2);
        LifecycleManagerState.addLastRunTimestamp((FlatBufferBuilder)builder2, (long)lastRunTs);
        int finishOffset2 = LifecycleManagerState.endLifecycleManagerState((FlatBufferBuilder)builder2);
        builder2.finishSizePrefixed(finishOffset2);
        this.objectStore().putBuf(new StringBuilder(26).append("3/").append(this.clusterId()).append(".lifecycle-manager-state").toString(), new HashMap(), builder2.dataBuffer().slice());
        Assertions.assertFalse((boolean)clm.lifecycleManagerState(Predef$.MODULE$.long2Long(this.time().milliseconds())).isPresent());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCLMReturnsUpdatedStateAfterCheckpoint() {
        long currTimeMs = System.currentTimeMillis();
        String currDateStr = StateManager.convertToDateKey((Long)Predef$.MODULE$.long2Long(currTimeMs));
        long[] endOffsets = (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 100L, ClassTag$.MODULE$.Long());
        HashMap<NameAndId, Integer> topicToBackupRetentionInDays = new HashMap<NameAndId, Integer>();
        topicToBackupRetentionInDays.put(new NameAndId("foo"), Predef$.MODULE$.int2Integer(3));
        HashMap retentionChanges = new HashMap();
        HashMap<String, String> dateToLatestDeletionList = new HashMap<String, String>();
        dateToLatestDeletionList.put(currDateStr, "00000003");
        LifecycleManagerState state = StateManager.deserializeState((ByteBuffer)StateManager.serializeState((Long)Predef$.MODULE$.long2Long(currTimeMs), (long[])endOffsets, topicToBackupRetentionInDays, retentionChanges, dateToLatestDeletionList).duplicate());
        HashMap<String, java.util.List<Object>> deletionListsCurrentOrPastDays = new HashMap<String, java.util.List<Object>>();
        deletionListsCurrentOrPastDays.put(currDateStr, Arrays.asList((Object[])new String[]{"00000001", "00000002", "00000003"}));
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        HashMap<TopicIdPartition, java.util.List<Object>> tpIdToBlobs = new HashMap<TopicIdPartition, java.util.List<Object>>();
        LifecycleManager.BlobMetadata blob = new LifecycleManager.BlobMetadata(UUID.randomUUID().toString(), Predef$.MODULE$.long2Long(currTimeMs + 100L), Predef$.MODULE$.int2Integer(3));
        tpIdToBlobs.put(topicIdPartition, Arrays.asList((Object[])new LifecycleManager.BlobMetadata[]{blob}));
        HashMap<String, HashMap<TopicIdPartition, java.util.List<Object>>> dateToDeletableBlobs = new HashMap<String, HashMap<TopicIdPartition, java.util.List<Object>>>();
        dateToDeletableBlobs.put(currDateStr, tpIdToBlobs);
        boolean currentDayBlobsAlreadyLoaded = true;
        this.uploadBackupObjectsListWithDummyData(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.backupObjectListsPresent(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerUnitTests.$anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LifecycleManager clm = this.lifecycleManager((TierObjectStore)this.objectStore());
        LifecycleManagerState newState = clm.cleanupAndCheckpoint(Predef$.MODULE$.long2Long(currTimeMs), state, topicToBackupRetentionInDays, retentionChanges, deletionListsCurrentOrPastDays, dateToDeletableBlobs, Predef$.MODULE$.boolean2Boolean(currentDayBlobsAlreadyLoaded));
        Predef$.MODULE$.assert(newState.lastRunTimestamp() == currTimeMs);
        Predef$.MODULE$.assert(newState.latestDataFilesLength() == 1);
        String string = newState.latestDataFiles(0).date();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(currDateStr) : currDateStr != null));
        String string2 = newState.latestDataFiles(0).latestFile();
        String string3 = "00000001";
        Predef$.MODULE$.assert(string2 != null && string2.equals(string3));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 60L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerUnitTests.$anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$4(this, currDateStr)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerUnitTests.$anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 60L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!this.backupObjectListsPresent(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)Nil$.MODULE$))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerUnitTests.$anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.uploadBackupObjectsListWithDummyData(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))));
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = 60L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!this.backupObjectListsPresent(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerUnitTests.$anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        dateToDeletableBlobs.remove(currDateStr);
        newState = clm.cleanupAndCheckpoint(Predef$.MODULE$.long2Long(currTimeMs), state, topicToBackupRetentionInDays, retentionChanges, deletionListsCurrentOrPastDays, dateToDeletableBlobs, Predef$.MODULE$.boolean2Boolean(currentDayBlobsAlreadyLoaded));
        Predef$.MODULE$.assert(newState.lastRunTimestamp() == currTimeMs);
        Predef$.MODULE$.assert(newState.latestDataFilesLength() == 0);
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = 60L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerUnitTests.$anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$10(this, currDateStr)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerUnitTests.$anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testRetentionToBackupConfig() {
        TreeMap retentionToBackup = LifecycleManagerConfig.parseRetentionToBackupConfig((String)"\"0:0,3:3\"");
        Predef$.MODULE$.assert(retentionToBackup.size() == 3);
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToInteger((int)0)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)-1L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        retentionToBackup = LifecycleManagerConfig.parseRetentionToBackupConfig((String)"3:3");
        Predef$.MODULE$.assert(retentionToBackup.size() == 3);
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToInteger((int)0)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)-1L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        retentionToBackup = LifecycleManagerConfig.parseRetentionToBackupConfig((String)"3:3,-1:7");
        Predef$.MODULE$.assert(retentionToBackup.size() == 3);
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToInteger((int)0)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)-1L)), (Object)BoxesRunTime.boxToInteger((int)7)));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)""));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0033"));
        Assertions.assertThrows(NumberFormatException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"abc:abc"));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0:0,3:3,3:3"));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0:0,3:3,4:2"));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0:0,3:3,-1:2"));
    }

    @Test
    public void testReconfigureBackupPolicy() {
        NameAndId topic_1h = new NameAndId("topic_1h");
        NameAndId topic_1d = new NameAndId("topic_1d");
        NameAndId topic_2d = new NameAndId("topic_2d");
        NameAndId topic_3d = new NameAndId("topic_3d");
        NameAndId topic_4d = new NameAndId("topic_4d");
        NameAndId topic_5d = new NameAndId("topic_5d");
        NameAndId topic_6d = new NameAndId("topic_6d");
        NameAndId topic_7d = new NameAndId("topic_7d");
        NameAndId topic_8d = new NameAndId("topic_8d");
        NameAndId topic_365d = new NameAndId("topic_365d");
        NameAndId topic_infinite = new NameAndId("topic_infinite");
        HashMap<NameAndId, Long> latestRetentionConfigs = new HashMap<NameAndId, Long>(null, topic_1h, topic_1d, topic_2d, topic_3d, topic_4d, topic_5d, topic_6d, topic_7d, topic_8d, topic_365d, topic_infinite){
            {
                this.put(topic_1h$1, Predef$.MODULE$.long2Long(3600000L));
                this.put(topic_1d$1, Predef$.MODULE$.long2Long(86400000L));
                this.put(topic_2d$1, Predef$.MODULE$.long2Long(172800000L));
                this.put(topic_3d$1, Predef$.MODULE$.long2Long(259200000L));
                this.put(topic_4d$1, Predef$.MODULE$.long2Long(345600000L));
                this.put(topic_5d$1, Predef$.MODULE$.long2Long(432000000L));
                this.put(topic_6d$1, Predef$.MODULE$.long2Long(518400000L));
                this.put(topic_7d$1, Predef$.MODULE$.long2Long(604800000L));
                this.put(topic_8d$1, Predef$.MODULE$.long2Long(691200000L));
                this.put(topic_365d$1, Predef$.MODULE$.long2Long(1471228928L));
                this.put(topic_infinite$1, Predef$.MODULE$.long2Long(-1L));
            }
        };
        this.props().put(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp(), "7");
        this.props().put(KafkaConfig$.MODULE$.CLMTopicRetentionInDaysToBackupInDaysProp(), "0:0,3:3,4:4,5:5,6:6,7:7");
        this.config_$eq(new KafkaConfig((Map)this.props()));
        Map backupRetentionDays = this.lifecycleManager((TierObjectStore)this.objectStore()).getBackupRetentionInDaysForAllTopics((Map)latestRetentionConfigs);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1h), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_2d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_3d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_4d), (Object)BoxesRunTime.boxToInteger((int)4)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_5d), (Object)BoxesRunTime.boxToInteger((int)5)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_6d), (Object)BoxesRunTime.boxToInteger((int)6)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_7d), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_8d), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_infinite), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_365d), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        this.props().put(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp(), "3");
        this.props().put(KafkaConfig$.MODULE$.CLMTopicRetentionInDaysToBackupInDaysProp(), "0:0,3:3");
        this.config_$eq(new KafkaConfig((Map)this.props()));
        backupRetentionDays = this.lifecycleManager((TierObjectStore)this.objectStore()).getBackupRetentionInDaysForAllTopics((Map)latestRetentionConfigs);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1h), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_2d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_3d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_4d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_5d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_6d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_7d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_8d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_infinite), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_365d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
    }

    public LifecycleManager lifecycleManager(TierObjectStore objectStore) {
        HashMap interBrokerClientConfigs = new HashMap();
        LifecycleManagerConfig lifecycleManagerConfig = new LifecycleManagerConfig(this.config(), this.clusterId(), () -> interBrokerClientConfigs, () -> this.admin());
        return new LifecycleManager(objectStore, lifecycleManagerConfig, () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(true), (Time)this.time(), this.metrics());
    }

    private boolean extractPrefixAndCompare(String key, UUID objectId, TopicIdPartition topicIdPartition) {
        String prefix = new StringBuilder(3).append(TierObjectStore.DataTypePathPrefix.TOPIC.prefix).append("/").append(CoreUtils$.MODULE$.uuidToBase64(objectId)).append("/").append(topicIdPartition.topicIdAsBase64()).append("/").append(topicIdPartition.partition()).toString();
        int endIndex = key.lastIndexOf("/");
        Predef$.MODULE$.assert(endIndex != -1);
        String string = key.substring(0, endIndex);
        return !(string != null ? !string.equals(prefix) : prefix != null);
    }

    private boolean backupObjectListsPresent(String date, List<String> names) {
        return names.forall((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)BackupObjectLifecycleManagerUnitTests.$anonfun$backupObjectListsPresent$1(this, date, name)));
    }

    private void uploadBackupObjectsListWithDummyData(String date, List<String> names) {
        StateManagerConfig config = new StateManagerConfig((TierObjectStore)this.objectStore(), this.clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false));
        long currTimeMs = System.currentTimeMillis();
        TopicIdPartition topicIdPartition = new TopicIdPartition("bar", UUID.randomUUID(), 0);
        HashMap<TopicIdPartition, java.util.List<Object>> tpIdToBlobs = new HashMap<TopicIdPartition, java.util.List<Object>>();
        LifecycleManager.BlobMetadata blob = new LifecycleManager.BlobMetadata(UUID.randomUUID().toString(), Predef$.MODULE$.long2Long(currTimeMs + 100L), Predef$.MODULE$.int2Integer(3));
        tpIdToBlobs.put(topicIdPartition, Arrays.asList((Object[])new LifecycleManager.BlobMetadata[]{blob}));
        ByteBuffer buf = StateManager.serializeBackupObjectsList(tpIdToBlobs);
        names.foreach((Function1 & Serializable & scala.Serializable)name -> {
            BackupObjectLifecycleManagerUnitTests.$anonfun$uploadBackupObjectsListWithDummyData$3(config, buf, date, name);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$3() {
        return "Backup object files not present";
    }

    public static final /* synthetic */ boolean $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$4(BackupObjectLifecycleManagerUnitTests $this, String currDateStr$1) {
        return !$this.backupObjectListsPresent(currDateStr$1, (List<String>)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$5() {
        return "Backup object files must have been deleted";
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$7() {
        return "Backup object files must have been present";
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$9() {
        return "Backup object files not present";
    }

    public static final /* synthetic */ boolean $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$10(BackupObjectLifecycleManagerUnitTests $this, String currDateStr$1) {
        return !$this.backupObjectListsPresent(currDateStr$1, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$11() {
        return "Backup object files must have been deleted";
    }

    public static final /* synthetic */ boolean $anonfun$backupObjectListsPresent$1(BackupObjectLifecycleManagerUnitTests $this, String date$1, String name) {
        String path = new TierObjectStore.BackupObjectsListMetadata($this.clusterId(), date$1, name).toPath("", TierObjectStore.FileType.BACKUP_OBJECTS_LIST);
        Map objects = $this.objectStore().listObject(path, false);
        return objects.size() == 1 && objects.containsKey(path);
    }

    public static final /* synthetic */ void $anonfun$uploadBackupObjectsListWithDummyData$3(StateManagerConfig config$1, ByteBuffer buf$1, String date$2, String name) {
        StateManager.putBackedUpObjectsListBufToObjectStore((StateManagerConfig)config$1, (ByteBuffer)buf$1, (String)date$2, (String)name);
    }

    public BackupObjectLifecycleManagerUnitTests() {
        this.props().setProperty("confluent.tier.feature", "true");
        this.props().setProperty("node.id", "1");
        this.props().setProperty("confluent.clm.enabled", "true");
        this.config = new KafkaConfig((Map)this.props());
        this.clusterId = "testCluster";
        this.admin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        this.objectStore = new MockInMemoryTierObjectStore((Time)this.time(), new MockInMemoryTierObjectStoreConfig());
        this.topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
    }
}

