/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupobjectlifecycle;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.storage.blob.models.BlobStorageException;
import com.google.cloud.storage.StorageException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupobjectlifecycle.ObjectStoreUtils;
import kafka.tier.backupobjectlifecycle.ObjectStoreUtilsContext;
import kafka.tier.backupobjectlifecycle.RetryPolicy;
import kafka.tier.backupobjectlifecycle.TierObjectStoreBatchOperationException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u0014(\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004D\u0001\u0001\u0006Ia\u000f\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019Q\u0005\u0001)A\u0005\r\"91\n\u0001b\u0001\n\u0003a\u0005BB*\u0001A\u0003%Q\nC\u0004U\u0001\t\u0007I\u0011A+\t\r\u0011\u0004\u0001\u0015!\u0003W\u0011\u001d)\u0007A1A\u0005\u0002\u0019Da!\u001c\u0001!\u0002\u00139\u0007b\u00028\u0001\u0005\u0004%\ta\u001c\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003q\u0011%\t\u0019\u0001\u0001b\u0001\n\u0003\t)\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0004\u0011%\t\t\u0002\u0001b\u0001\n\u0003\t\u0019\u0002\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u000b\u0011%\ti\u0002\u0001b\u0001\n\u0003\ty\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0011\u0011%\tI\u0003\u0001a\u0001\n\u0003\tY\u0003C\u0005\u0002:\u0001\u0001\r\u0011\"\u0001\u0002<!A\u0011q\t\u0001!B\u0013\ti\u0003C\u0005\u0002J\u0001\u0011\r\u0011\"\u0001\u0002L!A\u0011Q\r\u0001!\u0002\u0013\ti\u0005\u0003\u0005\u0002h\u0001\u0011\r\u0011\"\u0001V\u0011\u001d\tI\u0007\u0001Q\u0001\nYC\u0011\"a\u001b\u0001\u0005\u0004%\t!!\u001c\t\u0011\u0005U\u0004\u0001)A\u0005\u0003_Bq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0016\u0002!\t!!\u001f\t\u000f\u0005e\u0005\u0001\"\u0001\u0002z!9\u0011Q\u0014\u0001\u0005\u0002\u0005e\u0004bBAQ\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003K\u0003A\u0011AA=\u0011\u001d\tI\u000b\u0001C\u0001\u0003sBq!!,\u0001\t\u0003\tI\bC\u0004\u00022\u0002!\t!!\u001f\u0003)=\u0013'.Z2u'R|'/Z+uS2\u001cH+Z:u\u0015\tA\u0013&A\u000bcC\u000e\\W\u000f]8cU\u0016\u001cG\u000f\\5gK\u000eL8\r\\3\u000b\u0005)Z\u0013\u0001\u0002;jKJT\u0011\u0001L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0006\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0002\"\u0001\u000f\u0001\u000e\u0003\u001d\nA!^;jIV\t1\b\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005!Q\u000f^5m\u0015\u0005\u0001\u0015\u0001\u00026bm\u0006L!AQ\u001f\u0003\tU+\u0016\nR\u0001\u0006kVLG\rI\u0001\u0005iBLE-F\u0001G!\t9\u0005*D\u0001*\u0013\tI\u0015F\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006)A\u000f]%eA\u0005YqN\u00196fGR\u001cFo\u001c:f+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)*\u0003\u0015\u0019Ho\u001c:f\u0013\t\u0011vJA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u00031y'M[3diN#xN]3!\u0003\u0015\u0001(o\u001c9t+\u00051\u0006\u0003\u0002\u001fX3fK!\u0001W\u001f\u0003\u000f!\u000b7\u000f['baB\u0011!,\u0019\b\u00037~\u0003\"\u0001X\u0019\u000e\u0003uS!AX\u0017\u0002\rq\u0012xn\u001c;?\u0013\t\u0001\u0017'\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u000112\u0003\u0019\u0001(o\u001c9tA\u00051!-\u001e4gKJ,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U~\n1A\\5p\u0013\ta\u0017N\u0001\u0006CsR,')\u001e4gKJ\fqAY;gM\u0016\u0014\b%\u0001\u0007lKf\u001cHk\u001c#fY\u0016$X-F\u0001q!\ra\u0014o]\u0005\u0003ev\u0012\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\u0005QlhBA;|\u001d\t1(P\u0004\u0002xs:\u0011A\f_\u0005\u0002Y%\u0011!fK\u0005\u0003!&J!\u0001`(\u0002\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016L!A`@\u0003\u001b-+\u00170\u00118e-\u0016\u00148/[8o\u0015\tax*A\u0007lKf\u001cHk\u001c#fY\u0016$X\rI\u0001\f_\nTW*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002\bA!\u0011\u0011BA\u0006\u001d\tq50C\u0002\u0002\u000e}\u00141c\u00142kK\u000e$8\u000b^8sK6+G/\u00193bi\u0006\fAb\u001c2k\u001b\u0016$\u0018\rZ1uC\u0002\n\u0001B]3ta>t7/Z\u000b\u0003\u0003+\u00012ATA\f\u0013\r\tIb\u0014\u0002\u0018)&,'o\u00142kK\u000e$8\u000b^8sKJ+7\u000f]8og\u0016\f\u0011B]3ta>t7/\u001a\u0011\u0002\u0007\r$\b0\u0006\u0002\u0002\"A\u0019\u0001(a\t\n\u0007\u0005\u0015rEA\fPE*,7\r^*u_J,W\u000b^5mg\u000e{g\u000e^3yi\u0006!1\r\u001e=!\u0003!)\u00070Z2vi>\u0014XCAA\u0017!\u0011\ty#!\u000e\u000e\u0005\u0005E\"bAA\u001a{\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005]\u0012\u0011\u0007\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'/\u0001\u0007fq\u0016\u001cW\u000f^8s?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005\r\u0003c\u0001\u0019\u0002@%\u0019\u0011\u0011I\u0019\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u000b*\u0012\u0011!a\u0001\u0003[\t1\u0001\u001f\u00132\u0003%)\u00070Z2vi>\u0014\b%\u0001\u0007iiR\u0004(+Z:q_:\u001cX-\u0006\u0002\u0002NA!\u0011qJA1\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001\u00025uiBTA!a\u0016\u0002Z\u0005!1m\u001c:f\u0015\u0011\tY&!\u0018\u0002\u000b\u0005TXO]3\u000b\u0005\u0005}\u0013aA2p[&!\u00111MA)\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u00035AG\u000f\u001e9SKN\u0004xN\\:fA\u00059\u0001.Z1eKJ\u001c\u0018\u0001\u00035fC\u0012,'o\u001d\u0011\u0002\u0017I,GO]=Q_2L7-_\u000b\u0003\u0003_\u00022\u0001OA9\u0013\r\t\u0019h\n\u0002\f%\u0016$(/\u001f)pY&\u001c\u00170\u0001\u0007sKR\u0014\u0018\u0010U8mS\u000eL\b%\u0001\u0016uKN$\u0018I_;sK\u0012+G.\u001a;j_:dun\u001c9G_J\u0014V\r\u001e:zC\ndW-\u0012=dKB$\u0018n\u001c8\u0015\u0005\u0005u\u0002fA\u000f\u0002~A!\u0011qPAI\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015aA1qS*!\u0011qQAE\u0003\u001dQW\u000f]5uKJTA!a#\u0002\u000e\u0006)!.\u001e8ji*\u0011\u0011qR\u0001\u0004_J<\u0017\u0002BAJ\u0003\u0003\u0013A\u0001V3ti\u0006\u0019C/Z:u\u0003j,(/\u001a#fY\u0016$\u0018n\u001c8M_>\u0004hi\u001c:O_\u0016C8-\u001a9uS>t\u0007f\u0001\u0010\u0002~\u0005QC/Z:u\u0003j,(/\u001a#fY\u0016$\u0018n\u001c8M_>\u0004X\t_5ug>sg)\u0019;bY\u0016C8-\u001a9uS>t\u0007fA\u0010\u0002~\u0005qC/Z:u\u0003j,(/\u001a#fY\u0016$\u0018n\u001c8M_>\u0004X\t_5ug>s'+\u001a;ss\u0006\u0014G.Z#yG\u0016\u0004H/[8oQ\r\u0001\u0013QP\u0001\u0019i\u0016\u001cH/\u0011>ve\u0016\u0014\u0015\r^2iK\u0012$U\r\\3uS>t\u0007fA\u0011\u0002~\u0005IB/Z:u\u0019&\u001cHoQ1mYJ+GO]=M_>\u0004XI\u001c3tQ\r\u0011\u0013QP\u0001$i\u0016\u001cH\u000fT5ti\u000e\u000bG\u000e\u001c*fiJLHj\\8q\u000bbLGo](o'V\u001c7-Z:tQ\r\u0019\u0013QP\u00011i\u0016\u001cHo\u00142kK\u000e$8\u000b^8sK\u000e\u000bG\u000e\u001c*fiJLHj\\8q\u000bbLGo]!gi\u0016\u0014X*\u0019=SKR\u0014\u0018.Z:)\u0007\u0011\ni(\u0001\u0016uKN$xJ\u00196fGR\u001cFo\u001c:f\u0007\u0006dGNU3uefdun\u001c9Fq&$8o\u00148Tk\u000e\u001cWm]:)\u0007\u0015\ni\b")
public class ObjectStoreUtilsTest {
    private final UUID uuid = UUID.randomUUID();
    private final TopicIdPartition tpId = new TopicIdPartition("foo", this.uuid(), 0);
    private final TierObjectStore objectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final HashMap<String, String> props;
    private final ByteBuffer buffer;
    private final ArrayList<TierObjectStore.KeyAndVersion> keysToDelete;
    private final TierObjectStore.ObjectStoreMetadata objMetadata;
    private final TierObjectStoreResponse response;
    private final ObjectStoreUtilsContext ctx;
    private ThreadPoolExecutor executor;
    private final HttpResponse httpResponse;
    private final HashMap<String, String> headers;
    private final RetryPolicy retryPolicy;

    public UUID uuid() {
        return this.uuid;
    }

    public TopicIdPartition tpId() {
        return this.tpId;
    }

    public TierObjectStore objectStore() {
        return this.objectStore;
    }

    public HashMap<String, String> props() {
        return this.props;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public ArrayList<TierObjectStore.KeyAndVersion> keysToDelete() {
        return this.keysToDelete;
    }

    public TierObjectStore.ObjectStoreMetadata objMetadata() {
        return this.objMetadata;
    }

    public TierObjectStoreResponse response() {
        return this.response;
    }

    public ObjectStoreUtilsContext ctx() {
        return this.ctx;
    }

    public ThreadPoolExecutor executor() {
        return this.executor;
    }

    public void executor_$eq(ThreadPoolExecutor x$1) {
        this.executor = x$1;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public HashMap<String, String> headers() {
        return this.headers;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    @Test
    public void testAzureDeletionLoopForRetryableException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            TierObjectStoreRetriableException retryableException = new TierObjectStoreRetriableException("blah", (Throwable)new RuntimeException("meh"));
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)(this.retryPolicy().maxRetries() * keys.size())))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureDeletionLoopForNoException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            ((TierObjectStore)Mockito.doNothing().when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)keys.size()))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureDeletionLoopExitsOnFatalException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            TierObjectStoreFatalException fatalException = new TierObjectStoreFatalException("blah-blah");
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{fatalException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), (List)keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy()));
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)keys.size()))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureDeletionLoopExitsOnRetryableException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            TierObjectStoreRetriableException retryableException = new TierObjectStoreRetriableException("meh", (Throwable)new RuntimeException("meh"));
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)(keys.size() * this.retryPolicy().maxRetries())))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureBatchedDeletion() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        keys.add(new TierObjectStore.KeyAndVersion("k3", "v3"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            this.headers().put("x-ms-error-code", "BlobNotFound");
            HttpHeaders httpHeaders = new HttpHeaders(this.headers());
            Mockito.when((Object)this.httpResponse().getHeaders()).thenReturn((Object)httpHeaders);
            BlobStorageException blobStorageException = new BlobStorageException("blah", this.httpResponse(), new Object());
            TierObjectStoreRetriableException retryableException = new TierObjectStoreRetriableException("blah", (Throwable)blobStorageException);
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersionedObjectsAsync((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor());
            this.headers().put("x-ms-error-code", "SomeError");
            httpHeaders = new HttpHeaders(this.headers());
            Mockito.when((Object)this.httpResponse().getHeaders()).thenReturn((Object)httpHeaders);
            blobStorageException = new BlobStorageException("blah", this.httpResponse(), new Object());
            retryableException = new TierObjectStoreRetriableException("blah", (Throwable)blobStorageException);
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            Assertions.assertThrows(TierObjectStoreBatchOperationException.class, () -> ObjectStoreUtils.deleteVersionedObjectsAsync((ObjectStoreUtilsContext)this.ctx(), (List)keys, (ThreadPoolExecutor)this.executor()));
            ((TierObjectStore)Mockito.doNothing().when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersionedObjectsAsync((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testListCallRetryLoopEnds() {
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.verifyObjectNotLive((ObjectStoreUtilsContext)this.ctx(), (TopicIdPartition)this.tpId(), (UUID)this.uuid(), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testListCallRetryLoopExitsOnSuccess() {
        HashMap listResponse = new HashMap();
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenReturn(listResponse);
        Assertions.assertDoesNotThrow(() -> ObjectStoreUtils.verifyObjectNotLive((ObjectStoreUtilsContext)this.ctx(), (TopicIdPartition)this.tpId(), (UUID)this.uuid(), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)3))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testObjectStoreCallRetryLoopExitsAfterMaxRetries() {
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.listObject((ObjectStoreUtilsContext)this.ctx(), (String)ArgumentMatchers.anyString(), (Boolean)Predef$.MODULE$.boolean2Boolean(ArgumentMatchers.anyBoolean()), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        this.objectStore().putBuf(ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (ByteBuffer)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new StorageException(100, "retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.putBuf((ObjectStoreUtilsContext)this.ctx(), (String)"key", this.props(), (ByteBuffer)this.buffer(), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).putBuf("key", this.props(), this.buffer());
        this.objectStore().deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), this.keysToDelete(), (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)this.objectStore().getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST)).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.getObject((ObjectStoreUtilsContext)this.ctx(), (TierObjectStore.ObjectStoreMetadata)this.objMetadata(), (TierObjectStore.FileType)TierObjectStore.FileType.BACKUP_OBJECTS_LIST, (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST);
    }

    @Test
    public void testObjectStoreCallRetryLoopExitsOnSuccess() {
        HashMap returnValue = new HashMap();
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenReturn(returnValue);
        Assertions.assertDoesNotThrow(() -> ObjectStoreUtils.listObject((ObjectStoreUtilsContext)this.ctx(), (String)ArgumentMatchers.anyString(), (Boolean)Predef$.MODULE$.boolean2Boolean(ArgumentMatchers.anyBoolean()), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        this.objectStore().putBuf(ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (ByteBuffer)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new StorageException(100, "retry")}).thenAnswer((Answer)new Answer<BoxedUnit>(null){

            public void answer(InvocationOnMock invocation) {
            }
        });
        ObjectStoreUtils.putBuf((ObjectStoreUtilsContext)this.ctx(), (String)"key", this.props(), (ByteBuffer)this.buffer(), (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).putBuf("key", this.props(), this.buffer());
        this.objectStore().deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenAnswer((Answer)new Answer<BoxedUnit>(null){

            public void answer(InvocationOnMock invocation) {
            }
        });
        ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), this.keysToDelete(), (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)this.objectStore().getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST)).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenAnswer((Answer)new Answer<TierObjectStoreResponse>(this){
            private final /* synthetic */ ObjectStoreUtilsTest $outer;

            public TierObjectStoreResponse answer(InvocationOnMock invocation) {
                return this.$outer.response();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ObjectStoreUtils.getObject((ObjectStoreUtilsContext)this.ctx(), (TierObjectStore.ObjectStoreMetadata)this.objMetadata(), (TierObjectStore.FileType)TierObjectStore.FileType.BACKUP_OBJECTS_LIST, (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST);
    }

    public ObjectStoreUtilsTest() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.GCS);
        this.props = new HashMap();
        this.buffer = (ByteBuffer)Mockito.mock(ByteBuffer.class);
        this.keysToDelete = new ArrayList();
        this.keysToDelete().add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        this.objMetadata = (TierObjectStore.ObjectStoreMetadata)Mockito.mock(TierObjectStore.ObjectStoreMetadata.class);
        this.response = (TierObjectStoreResponse)Mockito.mock(TierObjectStoreResponse.class);
        this.ctx = new ObjectStoreUtilsContext(this.objectStore(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false));
        this.executor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        this.httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.headers = new HashMap();
        this.retryPolicy = new RetryPolicy(10, 10L, 5L);
    }
}

