/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotComplete;
import kafka.tier.state.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierMetadataSnapshotCompleteTest {
    @Test
    public void testTierMetadataSnapshotCompleteSerializationDeserialization() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        OffsetAndEpoch offsetEpoch = new OffsetAndEpoch(11L, Optional.of(12));
        UUID randomId = UUID.randomUUID();
        TierMetadataSnapshotComplete actual = new TierMetadataSnapshotComplete(topicIdPartition, 5, randomId, offsetEpoch);
        TierMetadataSnapshotComplete fromSerialized = new TierMetadataSnapshotComplete(topicIdPartition, actual.metadata);
        Assertions.assertEquals((Object)actual, (Object)fromSerialized);
        Assertions.assertEquals((Object)fromSerialized.stateOffsetAndEpoch(), (Object)offsetEpoch);
        Assertions.assertEquals((int)fromSerialized.tierEpoch(), (int)5);
        Assertions.assertEquals((Object)fromSerialized.messageId(), (Object)randomId);
        Assertions.assertEquals((Object)fromSerialized.topicIdPartition(), (Object)topicIdPartition);
    }

    @Test
    public void testAbstractTierMetadataCompatibleSerializationDeserialization() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        OffsetAndEpoch offsetEpoch = new OffsetAndEpoch(11L, Optional.of(12));
        UUID randomId = UUID.randomUUID();
        TierMetadataSnapshotComplete actual = new TierMetadataSnapshotComplete(topicIdPartition, 5, randomId, offsetEpoch);
        TierMetadataSnapshotComplete derived = (TierMetadataSnapshotComplete)AbstractTierMetadata.deserialize((byte[])actual.serializeKey(), (byte[])actual.serializeValue(), (long)0L).get();
        Assertions.assertEquals((Object)actual, (Object)derived);
    }
}

