/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotComplete;
import kafka.tier.domain.TierMetadataSnapshotInitiate;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001i2Aa\u0002\u0005\u0001\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017!)A\u0006\u0001C\u0005[!)1\u0007\u0001C\u0005i!)a\u0007\u0001C\u00017!)\u0001\b\u0001C\u00017\t\u0011B+[3s)>\u0004\u0018nY*fe\u0012+G+Z:u\u0015\tI!\"\u0001\u0004e_6\f\u0017N\u001c\u0006\u0003\u00171\tA\u0001^5fe*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00021A\u0011\u0011\u0004A\u0007\u0002\u0011\u0005A2/\u001a:jC2L'0\u001a#fg\u0016\u0014\u0018.\u00197ju\u0016$Vm\u001d;\u0015\u0003q\u0001\"!E\u000f\n\u0005y\u0011\"\u0001B+oSRD#A\u0001\u0011\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013aA1qS*\u0011QEJ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\u0003&A\u0003kk:LGOC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012A\u0001V3ti\u0006I!o\\;oIR\u0013\u0018\u000e\u001d\u000b\u000399BQaL\u0002A\u0002A\n\u0011A\u001e\t\u00033EJ!A\r\u0005\u0003)\u0005\u00137\u000f\u001e:bGR$\u0016.\u001a:NKR\fG-\u0019;b\u0003%\u0019\u0018N_3DQ\u0016\u001c7\u000e\u0006\u0002\u001dk!)q\u0006\u0002a\u0001a\u0005AR.\u001a;bI\u0006$\u0018-\u00137mK\u001e\fG.\u00129pG\"$Vm\u001d;)\u0005\u0015\u0001\u0013\u0001F5oSRLE\u000e\\3hC2,\u0005o\\2i)\u0016\u001cH\u000f\u000b\u0002\u0007A\u0001")
public class TierTopicSerDeTest {
    @Test
    public void serializeDeserializeTest() {
        this.roundTrip((AbstractTierMetadata)new TierTopicInitLeader(new TopicIdPartition("8BOZItC97ECWLZAXG1twhNjHgq5uiQhMhI5TW9oDdnLsNqPQ8DL85rCWF1lMIkb0RjH37L86WWFiFXb68zEEAgnRSiNRBlfsEMOAbgRJ1J4GyiwjHmHqCEjC9tMfDZCjAnfYC2DxgFygZLacUmr0wi6yK9L8ShR7krsMlxEdTRarNFDZfnihFFmhFc0eHb0aRf4nvg2Gt9zeqSb3FDIdjrNbKtCi2V9VtXZjd014SO28Noi5CwEmuXD0crus1unE", UUID.randomUUID(), 0), 0, UUID.randomUUID(), 33, Optional.of(new OffsetAndEpoch(30L, 3))));
        this.roundTrip((AbstractTierMetadata)new TierTopicInitLeader(new TopicIdPartition("my", UUID.randomUUID(), 199999), 1, UUID.randomUUID(), 99));
        this.roundTrip((AbstractTierMetadata)new TierSegmentUploadInitiate(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID(), 0L, 33333L, 99999L, 100L, 3333, false, true, false, TierUploadType.Archive, new kafka.tier.state.OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.fromByteArray((byte[])"foo".getBytes())));
        this.roundTrip((AbstractTierMetadata)new TierSegmentUploadInitiate(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID(), 0L, 33333L, 99999L, 100L, 3333, false, true, false, TierUploadType.Archive, new kafka.tier.state.OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.fromByteArray((byte[])"".getBytes())));
        this.roundTrip((AbstractTierMetadata)new TierSegmentUploadInitiate(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID(), 0L, 33333L, 99999L, 100L, 3333, false, true, false, TierUploadType.Archive, new kafka.tier.state.OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED));
        this.roundTrip((AbstractTierMetadata)new TierSegmentUploadComplete(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID(), new kafka.tier.state.OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(3)))));
        this.roundTrip((AbstractTierMetadata)new TierSegmentDeleteInitiate(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID(), Optional.of(new kafka.tier.state.OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(3))))));
        this.roundTrip((AbstractTierMetadata)new TierSegmentDeleteComplete(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID(), Optional.of(new kafka.tier.state.OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(3))))));
        this.roundTrip((AbstractTierMetadata)new TierPartitionDeleteInitiate(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID()));
        this.roundTrip((AbstractTierMetadata)new TierPartitionDeleteComplete(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID()));
        this.roundTrip((AbstractTierMetadata)new TierPartitionForceRestore(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0L, 10000L, new kafka.tier.state.OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(3))), "8f1993e8ba666af2c9421956f9a29b6e7123768c", Predef$.MODULE$.boolean2Boolean(false)));
        this.roundTrip((AbstractTierMetadata)new TierPartitionUnfreezeLogStartOffset(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID()));
        this.roundTrip((AbstractTierMetadata)new TierPartitionFence(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), true));
        this.roundTrip((AbstractTierMetadata)new TierMetadataSnapshotInitiate(new TopicIdPartition("foo", UUID.randomUUID(), 0), 1, UUID.randomUUID(), new kafka.tier.state.OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(3)))));
        this.roundTrip((AbstractTierMetadata)new TierMetadataSnapshotComplete(new TopicIdPartition("foo", UUID.randomUUID(), 0), 1, UUID.randomUUID(), new kafka.tier.state.OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(3)))));
    }

    private void roundTrip(AbstractTierMetadata v) {
        this.sizeCheck(v);
        byte[] key = v.serializeKey();
        byte[] value = v.serializeValue();
        AbstractTierMetadata v2 = (AbstractTierMetadata)AbstractTierMetadata.deserialize((byte[])key, (byte[])value, (long)v.timestamp()).get();
        Assertions.assertEquals((Object)v, (Object)v2);
    }

    private void sizeCheck(AbstractTierMetadata v) {
        if (v instanceof TierTopicInitLeader) {
            TierTopicInitLeader tierTopicInitLeader = (TierTopicInitLeader)v;
            Assertions.assertTrue((TierTopicInitLeader.initialBufferSize() >= tierTopicInitLeader.payloadBuffer().remaining() ? 1 : 0) != 0);
            return;
        }
        if (v instanceof TierSegmentUploadInitiate) {
            TierSegmentUploadInitiate tierSegmentUploadInitiate = (TierSegmentUploadInitiate)v;
            Assertions.assertTrue((TierSegmentUploadInitiate.initialBufferSize() >= tierSegmentUploadInitiate.payloadBuffer().remaining() ? 1 : 0) != 0);
            return;
        }
        if (v instanceof TierSegmentUploadComplete) {
            TierSegmentUploadComplete tierSegmentUploadComplete = (TierSegmentUploadComplete)v;
            TierTopicSerDeTest.checkStaticSize$1(TierSegmentUploadComplete.initialBufferSize(), tierSegmentUploadComplete.payloadBuffer().remaining(), v);
            return;
        }
        if (v instanceof TierSegmentDeleteInitiate) {
            TierSegmentDeleteInitiate tierSegmentDeleteInitiate = (TierSegmentDeleteInitiate)v;
            TierTopicSerDeTest.checkStaticSize$1(TierSegmentDeleteInitiate.initialBufferSize(), tierSegmentDeleteInitiate.payloadBuffer().remaining(), v);
            return;
        }
        if (v instanceof TierSegmentDeleteComplete) {
            TierSegmentDeleteComplete tierSegmentDeleteComplete = (TierSegmentDeleteComplete)v;
            TierTopicSerDeTest.checkStaticSize$1(TierSegmentDeleteComplete.initialBufferSize(), tierSegmentDeleteComplete.payloadBuffer().remaining(), v);
            return;
        }
        if (v instanceof TierPartitionDeleteInitiate) {
            TierPartitionDeleteInitiate tierPartitionDeleteInitiate = (TierPartitionDeleteInitiate)v;
            TierTopicSerDeTest.checkStaticSize$1(TierPartitionDeleteInitiate.initialBufferSize(), tierPartitionDeleteInitiate.payloadBuffer().remaining(), v);
            return;
        }
        if (v instanceof TierPartitionDeleteComplete) {
            TierPartitionDeleteComplete tierPartitionDeleteComplete = (TierPartitionDeleteComplete)v;
            TierTopicSerDeTest.checkStaticSize$1(TierPartitionDeleteComplete.initialBufferSize(), tierPartitionDeleteComplete.payloadBuffer().remaining(), v);
            return;
        }
        if (v instanceof TierPartitionForceRestore) {
            TierPartitionForceRestore tierPartitionForceRestore = (TierPartitionForceRestore)v;
            TierTopicSerDeTest.checkStaticSize$1(TierPartitionForceRestore.initialBufferSize(), tierPartitionForceRestore.payloadBuffer().remaining(), v);
            return;
        }
        if (v instanceof TierPartitionUnfreezeLogStartOffset) {
            TierPartitionUnfreezeLogStartOffset tierPartitionUnfreezeLogStartOffset = (TierPartitionUnfreezeLogStartOffset)v;
            TierTopicSerDeTest.checkStaticSize$1(TierPartitionUnfreezeLogStartOffset.initialBufferSize(), tierPartitionUnfreezeLogStartOffset.payloadBuffer().remaining(), v);
            return;
        }
        if (v instanceof TierPartitionFence) {
            TierPartitionFence tierPartitionFence = (TierPartitionFence)v;
            TierTopicSerDeTest.checkStaticSize$1(TierPartitionFence.initialBufferSize(), tierPartitionFence.payloadBuffer().remaining(), v);
            return;
        }
        if (v instanceof TierMetadataSnapshotInitiate) {
            TierMetadataSnapshotInitiate tierMetadataSnapshotInitiate = (TierMetadataSnapshotInitiate)v;
            TierTopicSerDeTest.checkStaticSize$1(TierMetadataSnapshotInitiate.initialBufferSize(), tierMetadataSnapshotInitiate.payloadBuffer().remaining(), v);
            return;
        }
        if (v instanceof TierMetadataSnapshotComplete) {
            TierMetadataSnapshotComplete tierMetadataSnapshotComplete = (TierMetadataSnapshotComplete)v;
            TierTopicSerDeTest.checkStaticSize$1(TierMetadataSnapshotComplete.initialBufferSize(), tierMetadataSnapshotComplete.payloadBuffer().remaining(), v);
            return;
        }
        BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(41).append("unhandled AbstractTierMetadata variant '").append(v).append("'").toString());
    }

    @Test
    public void metadataIllegalEpochTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TierObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), -1, UUID.randomUUID(), 0L, 23252334L, 0L, 1000L, 102, TierObjectMetadata.State.SEGMENT_DELETE_INITIATE, true, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, 500L));
    }

    @Test
    public void initIllegalEpochTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TierTopicInitLeader(new TopicIdPartition("my-topic", UUID.randomUUID(), 0), -1, UUID.randomUUID(), 33));
    }

    private static final void checkStaticSize$1(long expected, long actual, AbstractTierMetadata v$1) {
        Assertions.assertEquals((long)expected, (long)actual, (String)new StringOps(Predef$.MODULE$.augmentString("initial allocated buffer did not match payload buffer written for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v$1.type()})));
    }
}

