/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;

class FetchRequestTestUtils {
    FetchRequestTestUtils() {
    }

    static TierObjectStore ioExceptionThrowingTierObjectStore() {
        return new TierObjectStore(){

            public TierObjectStore.Backend getBackend() {
                return TierObjectStore.Backend.Mock;
            }

            public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
                return null;
            }

            public BucketHealthResult checkBucketHealth() {
                return BucketHealthResult.HEALTHY;
            }

            public TierObjectStoreResponse getObject(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType objectFileType, Integer byteOffsetStart, Integer byteOffsetEnd) throws IOException {
                throw new IOException("");
            }

            public TierObjectStoreResponse getObject(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType fileType, Integer byteOffsetStart) throws IOException {
                throw new IOException("");
            }

            public TierObjectStoreResponse getObject(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType fileType) throws IOException {
                throw new IOException("");
            }

            public TierObjectStore.OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException {
                return TierObjectStore.OpaqueData.ZEROED;
            }

            public void putSegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws IOException {
                throw new IOException("");
            }

            public void putInMemorySegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<ByteBuffer> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws IOException {
                throw new IOException("");
            }

            public void putObject(TierObjectStore.ObjectStoreMetadata objectMetadata, File file, TierObjectStore.FileType fileType) throws IOException {
                throw new IOException("");
            }

            public void restoreObjectByCopy(TierObjectStore.ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
            }

            public void putBuf(String key, Map<String, String> metadata, ByteBuffer buf) throws IOException {
                throw new IOException("");
            }

            public void deleteSegment(TierObjectStore.ObjectMetadata objectMetadata) throws IOException {
                throw new IOException("");
            }

            public TierObjectAttribute objectExists(TierObjectStore.ObjectMetadata objectMetadata, TierObjectStore.FileType type) throws IOException, TierObjectStoreRetriableException {
                throw new IOException("");
            }

            public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
            }

            public void close() {
            }
        };
    }

    static TierObjectStore fileReturningTierObjectStore(final File offsetIndexFile, final File timestampIndexFile) {
        return new TierObjectStore(){

            public TierObjectStore.Backend getBackend() {
                return TierObjectStore.Backend.Mock;
            }

            public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
                return null;
            }

            public BucketHealthResult checkBucketHealth() {
                return BucketHealthResult.HEALTHY;
            }

            public TierObjectStoreResponse getObject(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType objectFileType, Integer byteOffsetStart, Integer byteOffsetEnd) throws IOException {
                FileInputStream inputStream = null;
                switch (objectFileType) {
                    case OFFSET_INDEX: {
                        inputStream = new FileInputStream(offsetIndexFile);
                        break;
                    }
                    case TIMESTAMP_INDEX: {
                        inputStream = new FileInputStream(timestampIndexFile);
                    }
                }
                final FileInputStream finalInputStream = inputStream;
                return new TierObjectStoreResponse(){

                    public InputStream getInputStream() {
                        return finalInputStream;
                    }

                    public void close() {
                        try {
                            finalInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
            }

            public TierObjectAttribute objectExists(TierObjectStore.ObjectMetadata objectMetadata, TierObjectStore.FileType type) throws IOException, TierObjectStoreRetriableException {
                throw new IOException("");
            }

            public TierObjectStore.OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException {
                return TierObjectStore.OpaqueData.ZEROED;
            }

            public void putObject(TierObjectStore.ObjectStoreMetadata objectMetadata, File file, TierObjectStore.FileType fileType) throws IOException {
                throw new IOException("");
            }

            public void restoreObjectByCopy(TierObjectStore.ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
            }

            public void putSegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws IOException {
                throw new IOException("");
            }

            public void putBuf(String key, Map<String, String> metadata, ByteBuffer buf) throws IOException {
                throw new IOException("");
            }

            public void putInMemorySegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<ByteBuffer> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws IOException {
                throw new IOException("");
            }

            public void deleteSegment(TierObjectStore.ObjectMetadata objectMetadata) {
            }

            public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
            }

            public void close() {
            }
        };
    }
}

