/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u000e\u001c\u0001\tBQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001C\u0002\u0013\u0005a\u0006\u0003\u0004=\u0001\u0001\u0006Ia\f\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0011\u0019Q\u0005\u0001)A\u0005\u007f!91\n\u0001b\u0001\n\u0003a\u0005BB+\u0001A\u0003%Q\nC\u0003W\u0001\u0011\u0005s\u000bC\u0003_\u0001\u0011\u0005q\fC\u0003l\u0001\u0011EA\u000eC\u0004\u0002\u0002\u0001!\t\"a\u0001\t\u000f\u0005E\u0001\u0001\"\u0005\u0002\u0014!9\u00111\u0006\u0001\u0005\u0012\u00055\u0002bBA\u001c\u0001\u0011E\u0011\u0011\b\u0005\b\u0003{\u0001A\u0011CA \u0011\u001d\t)\u0005\u0001C\t\u0003\u000fB\u0011\"!\u0016\u0001#\u0003%\t\"a\u0016\t\u000f\u00055\u0004\u0001\"\u0005\u0002p!9\u0011Q\u0010\u0001\u0005\u0012\u0005}\u0004bBAQ\u0001\u0011E\u00111\u0015\u0005\b\u0003[\u0003A\u0011CAX\u0011\u001d\t9\f\u0001C\t\u0003sC\u0011\"a2\u0001#\u0003%\t\"!3\t\u000f\u00055\u0007\u0001\"\u0005\u0002P\"I\u00111\u001d\u0001\u0012\u0002\u0013E\u0011\u0011\u001a\u0002\u0012\u0005\u0006\u001cX\rV5feN#\u0018\r^3UKN$(B\u0001\u000f\u001e\u0003\u0015\u0019H/\u0019;f\u0015\tqr$\u0001\u0003uS\u0016\u0014(\"\u0001\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\t\t\u0003I\u001dj\u0011!\n\u0006\u0003M}\taa]3sm\u0016\u0014\u0018B\u0001\u0015&\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u001c\u0003%!x\u000e]5d\u001d\u0006lW-F\u00010!\t\u0001\u0014H\u0004\u00022oA\u0011!'N\u0007\u0002g)\u0011A'I\u0001\u0007yI|w\u000e\u001e \u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qU\n!\u0002^8qS\u000et\u0015-\\3!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\u0010\t\u0003\u0001\"k\u0011!\u0011\u0006\u0003\u0005\u000e\u000baaY8n[>t'B\u0001\u0011E\u0015\t)e)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%\u000b%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005)\u0001O]8qgV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!Q\u000f^5m\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V(\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0004qe>\u00048\u000fI\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"\u0001\u0017/\u0011\u0005eSV\"A\u001b\n\u0005m+$\u0001B+oSRDQ!\u0018\u0005A\u00025\u000b!\u0002\u001d:pa\u0016\u0014H/[3t\u00039\u0001(/\u001a9be\u00164uN\u001d+fgR$\u0012\u0001\u0017\u0015\u0003\u0013\u0005\u0004\"AY5\u000e\u0003\rT!\u0001Z3\u0002\u0007\u0005\u0004\u0018N\u0003\u0002gO\u00069!.\u001e9ji\u0016\u0014(B\u00015G\u0003\u0015QWO\\5u\u0013\tQ7M\u0001\u0006CK\u001a|'/Z#bG\"\fq\u0002^5fe2{wmU3h[\u0016tGo\u001d\u000b\u0003[r\u00042A\\:w\u001d\ty\u0017O\u0004\u00023a&\ta'\u0003\u0002sk\u00059\u0001/Y2lC\u001e,\u0017B\u0001;v\u0005\u0011a\u0015n\u001d;\u000b\u0005I,\u0004CA<{\u001b\u0005A(BA= \u0003\rawnZ\u0005\u0003wb\u0014a\u0002V5fe2{wmU3h[\u0016tG\u000fC\u0003z\u0015\u0001\u0007Q\u0010\u0005\u0002x}&\u0011q\u0010\u001f\u0002\f\u0003\n\u001cHO]1di2{w-\u0001\u0010xC&$hi\u001c:I_R\u001cV\r\u001e*fi\u0016tG/[8o)>\\\u0015nY6J]R\u0019\u0001,!\u0002\t\u000f\u0005\u001d1\u00021\u0001\u0002\n\u0005A!/\u001a9mS\u000e\f7\u000f\u0005\u0003og\u0006-\u0001cA-\u0002\u000e%\u0019\u0011qB\u001b\u0003\u0007%sG/A\u000ewKJLg-\u001f+jKJ,GmU3h[\u0016tGo\u001d#fY\u0016$X\r\u001a\u000b\b1\u0006U\u0011qCA\u0014\u0011\u0015iC\u00021\u00010\u0011\u001d\tI\u0002\u0004a\u0001\u00037\t\u0001b\u001c2k'R|'/\u001a\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\u000f\u0002\u000bM$xN]3\n\t\u0005\u0015\u0012q\u0004\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\"1\u0011\u0011\u0006\u0007A\u00025\fa\u0002^5fe\u0016$7+Z4nK:$8/A\rxC&$hi\u001c:SKBd\u0017nY1U_\u001e+G/\u00138Ts:\u001cG#\u0002-\u00020\u0005M\u0002bBA\u0019\u001b\u0001\u0007\u00111B\u0001\tY\u0016\fG-\u001a:JI\"9\u0011QG\u0007A\u0002\u0005-\u0011A\u00034pY2|w/\u001a:JI\u00061\u0012\r\u001a3SKBd\u0017nY1U_\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0003\u0002\f\u0005m\u0002bBA\u0019\u001d\u0001\u0007\u00111B\u0001*CB\u0004XM\u001c3NKN\u001c\u0018mZ3t\u0003:$w+Y5u+:$\u0018\u000e\u001c+jKJ,G-\u00118e'ft7-\u001a3\u0015\u000ba\u000b\t%a\u0011\t\u000f\u0005Er\u00021\u0001\u0002\f!9\u0011QG\bA\u0002\u0005-\u0011\u0001K1qa\u0016tG-T3tg\u0006<Wm\u001d+p\u0019\u0016\fG-\u001a:B]\u0012<\u0016-\u001b;V]RLG\u000eV5fe\u0016$GCBA%\u0003\u001f\n\t\u0006E\u0002Z\u0003\u0017J1!!\u00146\u0005\u0011auN\\4\t\u000f\u0005E\u0002\u00031\u0001\u0002\f!I\u00111\u000b\t\u0011\u0002\u0003\u0007\u00111B\u0001\f]Vl7+Z4nK:$8/\u0001\u001abaB,g\u000eZ'fgN\fw-Z:U_2+\u0017\rZ3s\u0003:$w+Y5u+:$\u0018\u000e\u001c+jKJ,G\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tIF\u000b\u0003\u0002\f\u0005m3FAA/!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dT'\u0001\u0006b]:|G/\u0019;j_:LA!a\u001b\u0002b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002E\u0019,Go\u00195US\u0016\u0014X\rZ!oI2{7-\u00197ECR\f\u0017I\u001c3WC2LG-\u0019;f)\u0015A\u0016\u0011OA:\u0011\u001d\t\tD\u0005a\u0001\u0003\u0017Aq!!\u001e\u0013\u0001\u0004\t9(A\u0007g_2dwn^3s\u0013\u0012|\u0005\u000f\u001e\t\u00063\u0006e\u00141B\u0005\u0004\u0003w*$AB(qi&|g.A\u000fgKR\u001c\u0007\u000eR1uC\u0006sGMV1mS\u0012\fG/\u001a*fgB|gn]3t)5A\u0016\u0011QAB\u0003\u000b\u000bI)!$\u0002\u0012\"9\u0011\u0011G\nA\u0002\u0005-\u0001bBA;'\u0001\u0007\u0011q\u000f\u0005\b\u0003\u000f\u001b\u0002\u0019AA\u0006\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u000f\u0005-5\u00031\u0001\u0002J\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\tyi\u0005a\u0001\u0003\u0013\nAa]5{K\"9\u00111S\nA\u0002\u0005U\u0015A\u0003:fa2L7-Y#seB!\u0011qSAO\u001b\t\tIJC\u0002\u0002\u001c\u0006\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003?\u000bIJ\u0001\u0004FeJ|'o]\u0001\rg^LGo\u00195MK\u0006$WM\u001d\u000b\u00061\u0006\u0015\u0016\u0011\u0016\u0005\b\u0003O#\u0002\u0019AA\u0006\u0003=\u0019WO\u001d:f]RdU-\u00193fe&#\u0007bBAV)\u0001\u0007\u00111B\u0001\u0012GV\u0014(/\u001a8u\r>dGn\\<fe&#\u0017!G2sK\u0006$X\rV8qS\u000e\fe\u000eZ$fiJ+\u0007\u000f\\5dCN$\"!!-\u0011\u000fe\u000b\u0019,a\u0003\u0002\f%\u0019\u0011QW\u001b\u0003\rQ+\b\u000f\\33\u0003E\u0019\u0007.\u00198hKR{\u0007/[2D_:4\u0017n\u001a\u000b\b1\u0006m\u0016qXAb\u0011\u0019\tiL\u0006a\u0001_\u00059\u0001O]8q\u0017\u0016L\bBBAa-\u0001\u0007q&A\u0005qe>\u0004h+\u00197vK\"A\u0011Q\u0019\f\u0011\u0002\u0003\u0007q&A\u0003u_BL7-A\u000edQ\u0006tw-\u001a+pa&\u001c7i\u001c8gS\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0017T3aLA.\u000399W\r\u001e+pa&\u001c7i\u001c8gS\u001e$B!!5\u0002bB!\u00111[Ao\u001b\t\t)N\u0003\u0003\u0002X\u0006e\u0017!B1e[&t'bAAn\u0007\u000691\r\\5f]R\u001c\u0018\u0002BAp\u0003+\u0014aaQ8oM&<\u0007\u0002CAc1A\u0005\t\u0019A\u0018\u00021\u001d,G\u000fV8qS\u000e\u001cuN\u001c4jO\u0012\"WMZ1vYR$\u0013\u0007")
public class BaseTierStateTest
extends BaseRequestTest {
    private final String topicName;
    private final TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
    private final Properties props = new Properties();

    public String topicName() {
        return this.topicName;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    @BeforeEach
    public void prepareForTest() {
        this.props().clear();
        this.props().put("confluent.tier.enable", "true");
        this.props().put("segment.bytes", "2048");
        this.props().put("confluent.tier.local.hotset.bytes", "2048");
        this.props().put("confluent.tier.local.hotset.ms", "10");
        this.props().put("retention.bytes", "20480");
        this.props().put("min.cleanable.dirty.ratio", "0.1");
        this.props().put("file.delete.delay.ms", "10");
    }

    public List<TierLogSegment> tierLogSegments(AbstractLog log) {
        return log.tieredLogSegments().toList();
    }

    public void waitForHotSetRetentionToKickIn(List<Object> replicas) {
        replicas.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replica -> {
            AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(replica).get()).replicaManager().getLog(this.topicPartition()).get();
            long l = 200L;
            long l2 = 60000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!BaseTierStateTest.$anonfun$waitForHotSetRetentionToKickIn$2(log)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)BaseTierStateTest.$anonfun$waitForHotSetRetentionToKickIn$3());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        });
    }

    public void verifyTieredSegmentsDeleted(String topicName, TierObjectStore objStore, List<TierLogSegment> tieredSegments) {
        tieredSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            BaseTierStateTest.$anonfun$verifyTieredSegmentsDeleted$1(this, objStore, topicName, segment);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void waitForReplicaToGetInSync(int leaderId, int followerId) {
        Partition leaderPart = ((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getPartitionOrException(this.topicPartition());
        boolean loaded = false;
        IntRef numAttempts = IntRef.create((int)0);
        while (!loaded && numAttempts.elem < 25) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((KafkaBroker)this.brokerForId(followerId).get()).replicaManager().getPartitionOrException(this.topicPartition()));
            if (try_ instanceof Success) {
                loaded = true;
                continue;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Exception returned: ").append(ex).append(" while getting partition at follower. numAttempts: ").append(numAttempts$1.elem).toString());
                Thread.sleep(200L);
                ++numAttempts.elem;
                continue;
            }
            throw new MatchError((Object)try_);
        }
        Partition followerPart = ((KafkaBroker)this.brokerForId(followerId).get()).replicaManager().getPartitionOrException(this.topicPartition());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$waitForReplicaToGetInSync$3(leaderPart, followerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseTierStateTest.$anonfun$waitForReplicaToGetInSync$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)((AbstractLog)leaderPart.log().get()).logStartOffset(), (long)((AbstractLog)followerPart.log().get()).logStartOffset(), (String)"Log start offset mismatch");
        Assertions.assertEquals((Long)((Long)((AbstractLog)leaderPart.log().get()).tierPartitionState().startOffset().get()), (Long)((Long)((AbstractLog)followerPart.log().get()).tierPartitionState().startOffset().get()), (String)"First tiered offset mismatch");
        Assertions.assertEquals((long)((AbstractLog)leaderPart.log().get()).tierPartitionState().endOffset(), (long)((AbstractLog)followerPart.log().get()).tierPartitionState().endOffset(), (String)"Last tiered offset mismatch");
        Assertions.assertEquals((long)((AbstractLog)leaderPart.log().get()).logEndOffset(), (long)((AbstractLog)followerPart.log().get()).logEndOffset(), (String)"Log end offset mismatch");
    }

    /*
     * WARNING - void declaration
     */
    public int addReplicaToAssignment(int leaderId) {
        int n;
        void resource_resource;
        ConfluentAdmin confluentAdmin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var4_3 = resource_resource;
            n = BaseTierStateTest.$anonfun$addReplicaToAssignment$1(this, leaderId, (ConfluentAdmin)var4_3);
        }
        finally {
            resource_resource.close();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void appendMessagesAndWaitUntilTieredAndSynced(int leaderId, int followerId) {
        long endOffset = this.appendMessagesToLeaderAndWaitUntilTiered(leaderId, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog followerLog = (AbstractLog)((KafkaBroker)this.brokerForId(followerId).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$appendMessagesAndWaitUntilTieredAndSynced$1(endOffset, followerLog)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseTierStateTest.$anonfun$appendMessagesAndWaitUntilTieredAndSynced$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public long appendMessagesToLeaderAndWaitUntilTiered(int leaderId, int numSegments) {
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        long oldLogEndOffset = log.logEndOffset();
        int oldNumSegments = log.numberOfSegments();
        int numMessages = 100;
        IntRef totalMessages = IntRef.create((int)0);
        while (log.numberOfSegments() <= oldNumSegments + numSegments) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            totalMessages.elem += numMessages;
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$appendMessagesToLeaderAndWaitUntilTiered$1(log, totalMessages, oldLogEndOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseTierStateTest.$anonfun$appendMessagesToLeaderAndWaitUntilTiered$2(oldLogEndOffset, log, totalMessages, oldNumSegments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return log.logEndOffset();
    }

    public int appendMessagesToLeaderAndWaitUntilTiered$default$2() {
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    public void fetchTieredAndLocalDataAndValidate(int leaderId, Option<Object> followerIdOpt) {
        AbstractLog leaderLog = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$fetchTieredAndLocalDataAndValidate$1(leaderLog)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseTierStateTest.$anonfun$fetchTieredAndLocalDataAndValidate$2(leaderLog));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int leaderEpoch = ((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getPartitionOrException(this.topicPartition()).getLeaderEpoch();
        long fetchSizeBytes = leaderLog.tierPartitionState().totalSize();
        this.fetchDataAndValidateResponses(leaderId, followerIdOpt, leaderEpoch, leaderLog.logStartOffset(), fetchSizeBytes, Errors.OFFSET_TIERED);
        fetchSizeBytes = leaderLog.size() - leaderLog.tierPartitionState().totalSize();
        this.fetchDataAndValidateResponses(leaderId, followerIdOpt, leaderEpoch, leaderLog.tierPartitionState().endOffset() + 1L, fetchSizeBytes, Errors.NONE);
    }

    public void fetchDataAndValidateResponses(int leaderId, Option<Object> followerIdOpt, int leaderEpoch, long fetchOffset, long size, Errors replicaErr) {
        short ver = 11;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(this.topicPartition(), new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, 0L, (int)size, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch))));
        FetchRequest consumerFetchRequest = FetchRequest.Builder.forConsumer((short)ver, (int)0, (int)0, partitionMap).build(ver);
        FetchResponseData.PartitionData consumerResponsePartitionData = (FetchResponseData.PartitionData)((FetchResponse)this.connectAndReceive((AbstractRequest)consumerFetchRequest, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).responseData(Collections.emptyMap(), ver).get(this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)consumerResponsePartitionData.errorCode(), (String)"Unexpected error returned by consumer fetch request");
        if (followerIdOpt.isDefined()) {
            FetchRequest replicaFetchRequest = FetchRequest.Builder.forReplica((short)ver, (int)BoxesRunTime.unboxToInt((Object)followerIdOpt.get()), (int)0, (int)((int)size), partitionMap).build(ver);
            FetchResponseData.PartitionData replicaResponsePartitionData = (FetchResponseData.PartitionData)((FetchResponse)this.connectAndReceive((AbstractRequest)replicaFetchRequest, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).responseData(Collections.emptyMap(), ver).get(this.topicPartition());
            Assertions.assertEquals((short)replicaErr.code(), (short)replicaResponsePartitionData.errorCode(), (String)"Unexpected error returned by replica fetch request");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void switchLeader(int currentLeaderId, int currentFollowerId) {
        this.killBroker(currentLeaderId);
        Partition partition = ((KafkaBroker)this.brokerForId(currentFollowerId).get()).replicaManager().getPartitionOrException(this.topicPartition());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!partition.isLeader()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseTierStateTest.$anonfun$switchLeader$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.restartDeadBroker(currentLeaderId, this.restartDeadBroker$default$2());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$switchLeader$3(partition, currentLeaderId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseTierStateTest.$anonfun$switchLeader$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public Tuple2<Object, Object> createTopicAndGetReplicas() {
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topicPartition().topic(), 1, 2, this.props(), this.createTopic$default$5(), this.createTopic$default$6());
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        int replica1 = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())));
        int replica2 = TestUtils$.MODULE$.findFollowerId(this.topicPartition(), (Iterable<KafkaBroker>)this.brokers());
        return new Tuple2.mcII.sp(replica1, replica2);
    }

    /*
     * WARNING - void declaration
     */
    public void changeTopicConfig(String propKey, String propValue, String topic) {
        void resource_resource;
        ConfluentAdmin confluentAdmin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var6_5 = resource_resource;
            BaseTierStateTest.$anonfun$changeTopicConfig$1(propKey, propValue, topic, (ConfluentAdmin)var6_5);
        }
        finally {
            resource_resource.close();
        }
    }

    public String changeTopicConfig$default$3() {
        return this.topicPartition().topic();
    }

    /*
     * WARNING - void declaration
     */
    public Config getTopicConfig(String topic) {
        Config config;
        void resource_resource;
        ConfluentAdmin confluentAdmin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var4_3 = resource_resource;
            config = BaseTierStateTest.$anonfun$getTopicConfig$1(topic, (ConfluentAdmin)var4_3);
        }
        finally {
            resource_resource.close();
        }
        return config;
    }

    public String getTopicConfig$default$1() {
        return this.topicPartition().topic();
    }

    public static final /* synthetic */ boolean $anonfun$waitForHotSetRetentionToKickIn$2(AbstractLog log$1) {
        return log$1.localLogStartOffset() > log$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$waitForHotSetRetentionToKickIn$3() {
        return "Timed out waiting for hot set retention to kick in";
    }

    public static final /* synthetic */ void $anonfun$verifyTieredSegmentsDeleted$2(BaseTierStateTest $this, BooleanRef deleted$1, TierObjectStore objStore$1, TierLogSegment segment$1, String topicName$1, IntRef retries$1, TierObjectStore.FileType fileType) {
        deleted$1.elem = false;
        while (!deleted$1.elem) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> objStore$1.getObject((TierObjectStore.ObjectStoreMetadata)segment$1.metadata(), fileType));
            if (try_ instanceof Success) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("[").append(topicName$1).append("] ").append(segment$1.metadata().toString()).append(" ").append(fileType.toString()).append(" not deleted yet. Back off and retry").toString());
                ++retries$1.elem;
                Assertions.assertTrue((retries$1.elem < 100 ? 1 : 0) != 0, (String)new StringBuilder(31).append("[").append(topicName$1).append("] ").append(segment$1.metadata().toString()).append(" ").append(fileType.toString()).append(" not deleted in max retries").toString());
                Thread.sleep(200L);
                continue;
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                Assertions.assertEquals(TierObjectStoreRetriableException.class, exception.getClass(), (String)new StringBuilder(44).append("[").append(topicName$1).append("] Unexpected exception while checking for ").append(segment$1.metadata().toString()).append(" ").append(fileType.toString()).toString());
                deleted$1.elem = true;
                continue;
            }
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$verifyTieredSegmentsDeleted$1(BaseTierStateTest $this, TierObjectStore objStore$1, String topicName$1, TierLogSegment segment) {
        BooleanRef deleted = BooleanRef.create((boolean)false);
        IntRef retries = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TierObjectStore.FileType.values())).foreach((Function1 & Serializable & scala.Serializable)fileType -> {
            BaseTierStateTest.$anonfun$verifyTieredSegmentsDeleted$2($this, deleted, objStore$1, segment, topicName$1, retries, fileType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForReplicaToGetInSync$3(Partition leaderPart$1, int followerId$1) {
        return leaderPart$1.inSyncReplicaIds().contains((Object)BoxesRunTime.boxToInteger((int)followerId$1));
    }

    public static final /* synthetic */ String $anonfun$waitForReplicaToGetInSync$4() {
        return "Timed out waiting replica to get in sync";
    }

    public static final /* synthetic */ boolean $anonfun$addReplicaToAssignment$6(ObjectRef latestResult$1, ConfluentAdmin admin$1, String reassignmentJson$1, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1) {
        latestResult$1.elem = ReassignPartitionsCommand$.MODULE$.verifyAssignment((Admin)admin$1, reassignmentJson$1, false);
        return expectedResult$1.equals((Object)((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem));
    }

    public static final /* synthetic */ String $anonfun$addReplicaToAssignment$7(ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1, ObjectRef latestResult$1) {
        return new StringBuilder(70).append("Timed out waiting for verifyAssignment result ").append(expectedResult$1).append(". ").append("The latest result was ").append((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem).toString();
    }

    public static final /* synthetic */ int $anonfun$addReplicaToAssignment$1(BaseTierStateTest $this, int leaderId$1, ConfluentAdmin admin) {
        Seq currentAssignment = ((KafkaBroker)$this.brokerForId(leaderId$1).get()).replicaManager().getPartitionOrException($this.topicPartition()).inSyncReplicaIds().toSeq();
        int replicaToAdd = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)admin.describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Iterable$.MODULE$.canBuildFrom())).toSet().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x -> !currentAssignment.contains((Object)BoxesRunTime.boxToInteger((int)x))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        if (replicaToAdd == -1) {
            throw new IllegalStateException("Cannot add a replica because # of brokers == # of replicas");
        }
        Seq targetAssignment = (Seq)currentAssignment.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaToAdd), Seq$.MODULE$.canBuildFrom());
        List logDirs = (List)List$.MODULE$.fill(targetAssignment.size(), (Function0 & Serializable & scala.Serializable)() -> "\"any\"");
        String reassignmentJson = new StringBuilder(82).append("{\"version\":1,\"partitions\":").append("[{\"topic\":\"foo\",\"partition\":0,\"replicas\":").append(targetAssignment.mkString("[", ",", "]")).append(",\"log_dirs\":").append(logDirs.mkString("[", ",", "]")).append("}").append("]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)admin, false, reassignmentJson, -1L, -1L, ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7());
        ObjectRef latestResult = ObjectRef.create(null);
        ReassignPartitionsCommand.VerifyAssignmentResult expectedResult = new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment(targetAssignment, (Seq)Nil$.MODULE$), new ReassignPartitionsCommand.Assignment(targetAssignment, (Seq)Nil$.MODULE$), true))})), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.$lessinit$greater$default$2(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.$lessinit$greater$default$3(), ReassignPartitionsCommand.VerifyAssignmentResult$.MODULE$.$lessinit$greater$default$4());
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$addReplicaToAssignment$6(latestResult, admin, reassignmentJson, expectedResult)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)BaseTierStateTest.$anonfun$addReplicaToAssignment$7(expectedResult, latestResult));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
        return replicaToAdd;
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesAndWaitUntilTieredAndSynced$1(long endOffset$1, AbstractLog followerLog$1) {
        return endOffset$1 == followerLog$1.logEndOffset();
    }

    public static final /* synthetic */ String $anonfun$appendMessagesAndWaitUntilTieredAndSynced$2() {
        return "Timeout waiting for all messages to be written, synced and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesToLeaderAndWaitUntilTiered$1(AbstractLog log$2, IntRef totalMessages$1, long oldLogEndOffset$1) {
        return log$2.logEndOffset() == (long)totalMessages$1.elem + oldLogEndOffset$1 && log$2.tierPartitionState().numSegments() >= log$2.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$appendMessagesToLeaderAndWaitUntilTiered$2(long oldLogEndOffset$1, AbstractLog log$2, IntRef totalMessages$1, int oldNumSegments$1) {
        return new StringBuilder(184).append("Timeout waiting for all messages to be written, synced and tiered. oldLogEndOffset: ").append(oldLogEndOffset$1).append(", newLogEndOffset: ").append(log$2.logEndOffset()).append(", messages sent: ").append(totalMessages$1.elem).append(", ").append("old numOfSegments: ").append(oldNumSegments$1).append(", new numOfSegments: ").append(log$2.numberOfSegments()).append(", tiered numSegments: ").append(log$2.tierPartitionState().numSegments()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$fetchTieredAndLocalDataAndValidate$1(AbstractLog leaderLog$1) {
        return leaderLog$1.logStartOffset() < leaderLog$1.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$fetchTieredAndLocalDataAndValidate$2(AbstractLog leaderLog$1) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(leaderLog$1.logStartOffset()).append(" localLogStartOffset ").append(leaderLog$1.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ String $anonfun$switchLeader$2() {
        return "Timed out waiting for new leader to elect";
    }

    public static final /* synthetic */ boolean $anonfun$switchLeader$3(Partition partition$1, int currentLeaderId$1) {
        return partition$1.inSyncReplicaIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderId$1));
    }

    public static final /* synthetic */ String $anonfun$switchLeader$4() {
        return "Timed out waiting for server to start";
    }

    public static final /* synthetic */ Void $anonfun$changeTopicConfig$1(String propKey$1, String propValue$1, String topic$1, ConfluentAdmin admin) {
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(propKey$1, propValue$1), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, topic$1), Collections.singletonList(alterConfigOp));
        return (Void)admin.incrementalAlterConfigs(configs).all().get(5L, TimeUnit.SECONDS);
    }

    public static final /* synthetic */ Config $anonfun$getTopicConfig$1(String topic$2, ConfluentAdmin admin) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, topic$2);
        return (Config)((java.util.Map)admin.describeConfigs(Collections.singletonList(configResource)).all().get(5L, TimeUnit.SECONDS)).get(configResource);
    }

    public BaseTierStateTest() {
        this.topicName = "foo";
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierTopicDeleteBackoffMsProp(), "15000");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataMaxPollMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
    }

    public static final /* synthetic */ Object $anonfun$addReplicaToAssignment$1$adapted(BaseTierStateTest $this, int leaderId$1, ConfluentAdmin admin) {
        return BoxesRunTime.boxToInteger((int)BaseTierStateTest.$anonfun$addReplicaToAssignment$1($this, leaderId$1, admin));
    }
}

