/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.ChecksumMigration;
import kafka.tier.state.CompactStats;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateTest;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u000e\u001d\u0001\rBQ\u0001\u000b\u0001\u0005\u0002%BQa\u000b\u0001\u0005B1BQa\r\u0001\u0005B1BQ\u0001\u000e\u0001\u0005B1BQ!\u000e\u0001\u0005\nYBQA\u0016\u0001\u0005\u0002]CQ!\u001a\u0001\u0005\u0002]CQa\u001a\u0001\u0005\n!DQA \u0001\u0005\u0002]Ca!!\u0001\u0001\t\u00039\u0006BBA\u0003\u0001\u0011\u0005q\u000b\u0003\u0004\u0002\n\u0001!\ta\u0016\u0005\u0007\u0003\u001b\u0001A\u0011A,\t\r\u0005E\u0001\u0001\"\u0001X\u0011\u0019\t)\u0002\u0001C\u0001/\"1\u0011\u0011\u0004\u0001\u0005\u0002]Ca!!\b\u0001\t\u00039\u0006BBA\u0011\u0001\u0011\u0005q\u000b\u0003\u0004\u0002&\u0001!\ta\u0016\u0005\u0007\u0003S\u0001A\u0011A,\t\r\u00055\u0002\u0001\"\u0001X\u0011\u0019\t\t\u0004\u0001C\u0001/\"1\u0011Q\u0007\u0001\u0005\u0002]Ca!!\u000f\u0001\t\u00039\u0006BBA\u001f\u0001\u0011\u0005q\u000bC\u0004\u0002B\u0001!\t!a\u0011\u0003Q\u0019KG.\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cu.\u001c9bGR,e.\u00192mK\u0012$Vm\u001d;\u000b\u0005uq\u0012!B:uCR,'BA\u0010!\u0003\u0011!\u0018.\u001a:\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001IA\u0011QEJ\u0007\u00029%\u0011q\u0005\b\u0002\u001b\r&dW\rV5feB\u000b'\u000f^5uS>t7\u000b^1uKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"!\n\u0001\u0002\u001f\rDWmY6tk6,e.\u00192mK\u0012,\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\b\u0005>|G.Z1o\u00039\u0019w.\u001c9bGR,e.\u00192mK\u0012\fab\u00197fC:,\b/\u00128bE2,G-A\u000ed_6\u0004\u0018M]3US\u0016\u00148\u000b^1uK\u001aKG.Z:IK2\u0004XM\u001d\u000b\toi\"\u0015J\u0014)S)B\u0011a\u0006O\u0005\u0003s=\u0012A!\u00168ji\")1(\u0002a\u0001y\u0005aq\u000e\u001c3BY\u001e|'/\u001b;i[B\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\tG\",7m[:v[*\u0011\u0011\tI\u0001\u0006kRLGn]\u0005\u0003\u0007z\u0012\u0011\"\u00117h_JLG\u000f[7\t\u000b\u0015+\u0001\u0019\u0001$\u0002\u0019=dG\rV5fe\u0016\u0003xn\u00195\u0011\u00059:\u0015B\u0001%0\u0005\rIe\u000e\u001e\u0005\u0006\u0015\u0016\u0001\raS\u0001\r_2$WI\u001c3PM\u001a\u001cX\r\u001e\t\u0003]1K!!T\u0018\u0003\t1{gn\u001a\u0005\u0006\u001f\u0016\u0001\r\u0001P\u0001\r]\u0016<\u0018\t\\4pe&$\b.\u001c\u0005\u0006#\u0016\u0001\rAR\u0001\r]\u0016<H+[3s\u000bB|7\r\u001b\u0005\u0006'\u0016\u0001\raS\u0001\r]\u0016<XI\u001c3PM\u001a\u001cX\r\u001e\u0005\u0006+\u0016\u0001\r!L\u0001\u0007e\u0016\u001cX\u000f\u001c;\u00023Q,7\u000f^\"p[B\f'/\u001a+jKJ\u001cF/\u0019;f\r&dWm\u001d\u000b\u0002o!\u0012a!\u0017\t\u00035\u000el\u0011a\u0017\u0006\u00039v\u000b1!\u00199j\u0015\tqv,A\u0004kkBLG/\u001a:\u000b\u0005\u0001\f\u0017!\u00026v]&$(\"\u00012\u0002\u0007=\u0014x-\u0003\u0002e7\n!A+Z:u\u00039!Xm\u001d;Qe>\u0004XM\u001d;jKND#aB-\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0006\u0002jcB\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0005kRLGNC\u0001o\u0003\u0011Q\u0017M^1\n\u0005A\\'A\u0003)s_B,'\u000f^5fg\")!\u000f\u0003a\u0001g\u0006q1\r[3dWN,XnQ8oM&<\u0007C\u0001;|\u001d\t)\u0018\u0010\u0005\u0002w_5\tqO\u0003\u0002yE\u00051AH]8pizJ!A_\u0018\u0002\rA\u0013X\rZ3g\u0013\taXP\u0001\u0004TiJLgn\u001a\u0006\u0003u>\n\u0001E]3bI^\u0013\u0018\u000e^3IK\u0006$WM](oYf<\u0016\u000e\u001e5NS\u001e\u0014\u0018\r^5p]\"\u0012\u0011\"W\u0001\u0015i\u0016\u001cHOV1mS\u0012\fG/Z\"iK\u000e\\7/^7)\u0005)I\u0016!\u0004;fgR\u001cu.\u001c9bGR,G\r\u000b\u0002\f3\u0006)B/Z:u\u0007>l\u0007/Y2uS>tg)\u001a8dS:<\u0007F\u0001\u0007Z\u0003\u0005\"Xm\u001d;D_6\u0004\u0018m\u0019;j_:\u001cuN\\2veJ,g\u000e\u001e#fY\u0016$\u0018n\u001c8tQ\ti\u0011,A\u0015uKN$h)\u001a8dKB\u0013\u0018n\u001c:D_6\u0004\u0018m\u0019;fI&s\u0017\u000e^5bi\u0016<\u0016\u000e\u001e5D_6l\u0017\u000e\u001e\u0015\u0003\u001de\u000b1\u0006^3ti\u000e{W\u000e]1di&|g.\u00169m_\u0006$\u0017J\\5uS\u0006$Xm\u00115bS:LgnZ*vG\u000e,7o\u001d\u0015\u0003\u001fe\u000bq\b^3ti\u000e{W\u000e]1di&|g.\u00169m_\u0006$\u0017J\\5uS\u0006$Xm\u00115bS:Lgn\u001a)sKZLw.^:PE*,7\r^%e\u001d>$X\t\u001f9fGR,G\r\u000b\u0002\u00113\u0006yD/Z:u\u0007>l\u0007/Y2uS>tW\u000b\u001d7pC\u0012Le.\u001b;jCR,7\t[1j]&tw\r\u0015:fm&|Wo](cU\u0016\u001cG/\u00133O_Rl\u0015\r^2iS:<\u0007FA\tZ\u0003=\"Xm\u001d;Va2|\u0017\rZ%oSRL\u0017\r^3DQ\u0006Lg.\u001b8h+Bdw.\u00193UsB,gj\u001c;NCR\u001c\u0007.\u001b8hQ\t\u0011\u0012,\u0001\u001cuKN$8i\\7qC\u000e$\u0018n\u001c8Va2|\u0017\rZ\"p[6LG/\u00118e'^\f\u0007OR3oG&tw-\u00169m_\u0006$\u0017J\\5uS\u0006$X\r\u000b\u0002\u00143\u0006iD/Z:u\u0007>l\u0007/Y2uS>tW\u000b\u001d7pC\u0012\u001cu.\\7ji\u0006sGmU<ba^KG\u000f\u001b(p]\u0016C\u0018n\u001d;j]\u001e\u001cv.\u001e:dK>\u0013'.Z2ug\"\u0012A#W\u0001@i\u0016\u001cHoQ8na\u0006\u001cG/[8o+Bdw.\u00193D_6l\u0017\u000e^!oIN;\u0018\r],ji\"tuN\\\"p]RLw-^8vgN{WO]2f\u001f\nTWm\u0019;tQ\t)\u0012,\u0001\u001cuKN$8i\\7qC\u000e$\u0018n\u001c8Va2|\u0017\rZ\"p[6LG/\u00118e'^\f\u0007oV5uQ&k\u0007o\\:tS\ndWm\u00144gg\u0016$8\u000f\u000b\u0002\u00173\u0006yC/Z:u\u0007>l\u0007/Y2uS>t7i\\7nSR\fe\u000eZ*xCB<\u0016\u000e\u001e5T[\u0006dG.\u001a:F]\u0012|eMZ:fi\"\u0012q#W\u0001+i\u0016\u001cHOU3m_\u0006$\u0017N\\4G)B\u001bv+\u001b;i+:\\gn\\<o-&\u0014H/^1m\u001f\u001a47/\u001a;tQ\tA\u0012,A\fuKN$8\u000b^1uK\n+gm\u001c:f\t\u0016dW\r^5p]\"\u0012\u0011$W\u0001\u0010G\",7m[%om\u0006\u0014\u0018.\u00198ugR\u0019q'!\u0012\t\ruQ\u0002\u0019AA$!\r)\u0013\u0011J\u0005\u0004\u0003\u0017b\"A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u0004")
public class FileTierPartitionStateCompactEnabledTest
extends FileTierPartitionStateTest {
    @Override
    public boolean checksumEnabled() {
        return true;
    }

    @Override
    public boolean compactEnabled() {
        return true;
    }

    @Override
    public boolean cleanupEnabled() {
        return true;
    }

    private void compareTierStateFilesHelper(Algorithm oldAlgorithm, int oldTierEpoch, long oldEndOffset, Algorithm newAlgorithm, int newTierEpoch, long newEndOffset, boolean result) {
        Path oldPath = new File(new StringBuilder(8).append("testFile").append(oldAlgorithm.suffix).toString()).toPath();
        Path newPath = new File(new StringBuilder(8).append("testFile").append(newAlgorithm.suffix).toString()).toPath();
        this.writeHeader$1(oldPath, oldAlgorithm, oldTierEpoch, oldEndOffset);
        this.writeHeader$1(newPath, newAlgorithm, newTierEpoch, newEndOffset);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)result), (Object)BoxesRunTime.boxToBoolean((boolean)ChecksumMigration.compareTierStateFiles((Path)oldPath, (Path)newPath)));
        Files.delete(oldPath);
        Files.delete(newPath);
    }

    @Test
    public void testCompareTierStateFiles() {
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 5, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 3, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(5, 30L, 3, 20L, false);
    }

    @Test
    public void testProperties() {
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("none, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, none")));
        java.util.List checksumFiles = KafkaConfig$.MODULE$.fromProps(this.properties("tierstate")).confluentConfig().checksumEnabledFiles();
        Assertions.assertEquals((int)1, (int)checksumFiles.size());
        Assertions.assertTrue((boolean)checksumFiles.contains("tierstate"));
    }

    /*
     * WARNING - void declaration
     */
    private Properties properties(String checksumConfig) {
        void var2_2;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "somewhere", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("confluent.checksum.enabled.files", checksumConfig);
        return var2_2;
    }

    @Test
    public void readWriteHeaderOnlyWithMigration() {
        Path flushedPath = Paths.get(this.state().flushedPath(), new String[0]);
        Path adlerChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.ADLER, (Path)flushedPath);
        Path nonChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.NO_CHECKSUM, (Path)flushedPath);
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 9, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)9, (int)this.state().tierEpoch());
        this.state().close();
        FileTierPartitionState reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(true), (Time)this.time());
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(false), (Time)this.time());
        Assertions.assertTrue((boolean)Files.notExists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(true), (Time)this.time());
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
    }

    @Test
    public void testValidateChecksum() {
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        int numSegments = 200;
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef size = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(epoch, UUID.randomUUID(), i * 2, i * 2 + 1, 100);
            size$1.elem += i;
        });
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
    }

    @Test
    public void testCompacted() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        File parentDir = TestUtils$.MODULE$.tempDir();
        File dir = TestUtils$.MODULE$.randomPartitionLogDir(parentDir);
        TopicPartition tp = MergedLog$.MODULE$.parseTopicPartitionName(dir);
        TopicIdPartition tpid = new TopicIdPartition(tp.topic(), UUID.randomUUID(), tp.partition());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        FileTierPartitionState state = new FileTierPartitionState(dir, logDirFailureChannel, tp, true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig());
        state.setTopicId(tpid.topicId());
        state.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(FileTierPartitionStateCompactEnabledTest.$anonfun$testCompacted$2(op, state)));
                return;
            }
        });
        state.beginCatchup();
        state.onCatchUpComplete();
        ListBuffer rawObjectIds = new ListBuffer();
        state.append((AbstractTierMetadata)new TierTopicInitLeader(tpid, epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(tpid, epoch, (UUID)rawObjectIds.last(), (long)offset$1.elem, (long)(offset$1.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadComplete(tpid, epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$1.elem += 2;
        });
        this.checkInvariants((TierPartitionState)state);
        int numSegmentsToCompact = 3;
        List segmentsToClean = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)20, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).size());
        java.util.Set compactedObjectIds = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.metadata().objectId(), List$.MODULE$.canBuildFrom())).toSet()).asJava();
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.maxTimestamp()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)state.compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(tpid, epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)-1L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        UUID completeMessageId = UUID.randomUUID();
        TierCompactionCommitAndSwap compactComplete = new TierCompactionCommitAndSwap(compactInitiate, completeMessageId, compactedObjectIds, newEndOffset, new CompactStats((long)newSize, (long)newSize, (long)newSize));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)6L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        int numSegmentsAfter = numSegments - numSegmentsToCompact + 1;
        Assertions.assertEquals((int)numSegmentsAfter, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).size());
        Assertions.assertEquals((long)50L, (long)((TierLogSegment)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).next()).firstBatchTimestamp());
        Assertions.assertEquals((Object)compactInitiate.objectId(), (Object)((TierLogSegment)state.metadata(0L).get()).objectId());
        Assertions.assertEquals((Object)compactInitiate.objectId(), (Object)((TierLogSegment)state.metadata(3L).get()).objectId());
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(compactedObjectIds).asScala()).toSet(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(state.compactedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet());
        this.checkInvariants((TierPartitionState)state);
        ((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(state.compactedSegments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)deletableSegment -> {
            FileTierPartitionStateCompactEnabledTest.$anonfun$testCompacted$8(this, state, tpid, epoch, deletableSegment);
            return BoxedUnit.UNIT;
        });
        List segmentsToClean2 = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).slice(numSegmentsToCompact, numSegmentsToCompact + 2).toList();
        long firstBatchTimestamp2 = 50L;
        UUID newObjectId2 = UUID.randomUUID();
        long newBaseOffset2 = ((TierLogSegment)segmentsToClean2.head()).baseOffset();
        long newEndOffset2 = ((TierLogSegment)segmentsToClean2.last()).endOffset();
        long newMaxTimestamp2 = BoxesRunTime.unboxToLong((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.maxTimestamp()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize2 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segmentsToClean2.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset2 = state.lastLocalMaterializedSrcOffsetAndEpoch();
        TierSegmentUploadInitiate compactInitiate2 = new TierSegmentUploadInitiate(tpid, epoch, newObjectId2, newBaseOffset2, newEndOffset2, newMaxTimestamp2, firstBatchTimestamp2, newSize2, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset2, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactInitiate2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)6L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        TierTestUtils$.MODULE$.verifyFtpsEntries(state, null, null, this.cleanupEnabled(), this.time().milliseconds());
        List segments = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).toList();
        scala.collection.immutable.Set segmentsDeleted = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(TierTestUtils$.MODULE$.deletedSegments(state, TierTestUtils$.MODULE$.deletedSegments$default$2())).asScala()).toSet();
        state.close();
        TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, (List<TierLogSegment>)segments, (scala.collection.immutable.Set<UUID>)segmentsDeleted, this.cleanupEnabled(), this.time().milliseconds());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(dir, logDirFailureChannel, tp, true, (Scheduler)this.time().scheduler(), false, this.compactEnabled(), (Time)this.time(), this.cleanupConfig());){
            reopenedState.checkInvariants();
            Assertions.assertEquals((int)numSegmentsAfter, (int)reopenedState.numSegments());
            Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(reopenedState.segments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)reopenedState.totalSize());
            Assertions.assertEquals((long)50L, (long)((TierLogSegment)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(reopenedState.segments()).asScala()).next()).firstBatchTimestamp());
            Assertions.assertEquals((long)6L, (long)reopenedState.compactDirtyStartOffset());
            java.util.Set compactedObjectIds2 = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)segmentsToClean2.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.metadata().objectId(), List$.MODULE$.canBuildFrom())).toSet()).asJava();
            UUID completeMessageId2 = UUID.randomUUID();
            TierCompactionCommitAndSwap compactComplete2 = new TierCompactionCommitAndSwap(compactInitiate2, completeMessageId2, compactedObjectIds2, newEndOffset2, new CompactStats((long)newSize2, (long)newSize2, (long)newSize2));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState.append((AbstractTierMetadata)compactComplete2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, null, null, this.cleanupEnabled(), this.time().milliseconds());
            reopenedState.checkInvariants();
            Assertions.assertEquals((long)14L, (long)reopenedState.compactDirtyStartOffset());
            Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(compactedObjectIds2).asScala()).toSet(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(reopenedState.compactedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet());
        }
        state.close();
        dir.delete();
        parentDir.delete();
    }

    @Test
    public void testCompactionFencing() {
        int numSegments = 5;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer rawObjectIds = new ListBuffer();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, (UUID)rawObjectIds.last(), (long)offset$2.elem, (long)(offset$2.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$2.elem += 2;
        });
        this.checkInvariants((TierPartitionState)this.state());
        int numSegmentsToCompact = 3;
        List segmentsToClean = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)numSegments, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.maxTimestamp()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.size()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(this.tpid(), epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch + 1, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertTrue((boolean)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet().contains((Object)compactInitiate.objectId()), (String)"compact initial segment should have been fenced");
        Assertions.assertEquals((int)numSegments, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
    }

    @Test
    public void testCompactionConcurrentDeletions() {
        int numSegments = 5;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer rawObjectIds = new ListBuffer();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, (UUID)rawObjectIds.last(), (long)offset$3.elem, (long)(offset$3.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$3.elem += 2;
        });
        this.checkInvariants((TierPartitionState)this.state());
        int numSegmentsToCompact = 3;
        List segmentsToClean = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)numSegments, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.maxTimestamp()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.size()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(this.tpid(), epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        TierLogSegment deletableSegment = (TierLogSegment)segmentsToClean.head();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, deletableSegment.objectId(), this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, deletableSegment.objectId(), this.state().lastLocalMaterializedSrcOffsetAndEpoch(), this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.checkInvariants((TierPartitionState)this.state());
        UUID completeMessageId = UUID.randomUUID();
        TierCompactionCommitAndSwap compactComplete = new TierCompactionCommitAndSwap(compactInitiate, completeMessageId, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)segmentsToClean.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.objectId(), List$.MODULE$.canBuildFrom())).toSet()).asJava(), newEndOffset, new CompactStats((long)newSize, (long)newSize, (long)newSize));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierTestUtils$.MODULE$.verifyFtpsEntries(this.state(), null, null, this.cleanupEnabled(), this.time().milliseconds());
    }

    @Test
    public void testFencePriorCompactedInitiateWithCommit() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 50L, 10);
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId2, 25L, 150L, 20);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)30L, (long)this.state().totalSize());
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        HashSet<UUID> compactedObjects = new HashSet<UUID>();
        compactedObjects.add(objectId1);
        compactedObjects.add(objectId2);
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        UUID objectIdCompacted = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectIdCompacted, 0L, 50L, 100L, 100L, 10, false, false, false, TierUploadType.Compaction, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, stateOffset, UUID.randomUUID(), compactedObjects, new HashSet(), 150L, new CompactStats(30L, 10L, 30L)), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)objectIdCompacted, (Object)((TierLogSegment)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).head()).objectId());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)151L, (long)this.state().compactDirtyStartOffset());
        Assertions.assertEquals((long)0L, (long)this.state().totalSize());
        this.deleteInitiateAndComplete(0, objectId1, this.time().milliseconds());
        this.deleteInitiateAndComplete(0, objectId2, this.time().milliseconds());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)0L, (long)this.state().totalSize());
        TierTestUtils$.MODULE$.verifyFtpsEntries(this.state(), null, null, this.cleanupEnabled(), this.time().milliseconds());
    }

    @Test
    public void testCompactionUploadInitiateChainingSuccess() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId4);
        destObjects.add(objectId5);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 9L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.of(objectId4), 6L, 10L, 100L, 100L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)4, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadInitiateChainingPreviousObjectIdNotExpected() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 300L, 500);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.of(objectId1), 11L, 20L, 200L, 200L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)1, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadInitiateChainingPreviousObjectIdNotMatching() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 300L, 500);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.empty(), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, Optional.of(objectId4), 11L, 20L, 200L, 200L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)1, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testUploadInitiateChainingUploadTypeNotMatching() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, Optional.empty(), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.of(objectId1), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)0, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapFencingUploadInitiate() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        new HashSet<UUID>().add(objectId4);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 10L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        HashSet<UUID> destObjects2 = new HashSet<UUID>();
        destObjects2.add(objectId5);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.empty(), 0L, 10L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects2, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)3, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithNonExistingSourceObjects() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        UUID objectId4 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId4);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 20L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().appendUnhandled((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)2, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)2, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithNonContiguousSourceObjects() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        this.uploadInitateAndComplete(0, objectId4, 31L, 40L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        sourceObjects.add(objectId4);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId5);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.empty(), 0L, 40L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)4, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithImpossibleOffsets() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        this.uploadInitateAndComplete(0, objectId4, 31L, 40L, 100);
        this.uploadInitateAndComplete(0, objectId5, 41L, 50L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)5, (int)this.state().numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        sourceObjects.add(objectId3);
        sourceObjects.add(objectId4);
        UUID objectId6 = UUID.randomUUID();
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId6);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId6, Optional.empty(), 0L, 41L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)5, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)5, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionCommitAndSwapWithSmallerEndOffset() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        UUID objectId3 = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, Optional.empty(), 0L, 15L, 100L, 100L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().flush();
        this.state().close();
        FileTierPartitionState reopenedState1 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertEquals((int)2, (int)reopenedState1.numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId3);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState1.append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects, 100L, CompactStats.EMPTY), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        SegmentState segment3 = (SegmentState)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(reopenedState1.segmentInMemoryMetadataRange(0L, 250L)).asScala()).last();
        Assertions.assertEquals((Object)objectId3, (Object)segment3.objectId());
        Assertions.assertEquals((long)15L, (long)segment3.endOffset());
        ((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(reopenedState1.compactedSegments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)deletableSegment -> {
            FileTierPartitionStateCompactEnabledTest.$anonfun$testCompactionCommitAndSwapWithSmallerEndOffset$1(this, reopenedState1, deletableSegment);
            return BoxedUnit.UNIT;
        });
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(reopenedState1, 0, objectId4, 18L, 30L, 100, this.compactEnabled());
        reopenedState1.flush();
        reopenedState1.close();
        FileTierPartitionState reopenedState2 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertEquals((int)2, (int)reopenedState2.numSegments());
        Assertions.assertEquals((long)30L, (long)reopenedState2.endOffset());
        Assertions.assertEquals((long)30L, (long)reopenedState2.dataEndOffset());
        SegmentState segment4 = (SegmentState)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(reopenedState2.segmentInMemoryMetadataRange(0L, 30L)).asScala()).last();
        Assertions.assertEquals((Object)objectId4, (Object)segment4.objectId());
        Assertions.assertEquals((long)21L, (long)segment4.baseOffset());
        Assertions.assertEquals((long)18L, (long)segment4.keyBaseOffset());
        Assertions.assertEquals((long)30L, (long)segment4.endOffset());
        HashSet<UUID> sourceObjects2 = new HashSet<UUID>();
        sourceObjects2.add(objectId3);
        sourceObjects2.add(objectId4);
        UUID objectId5 = UUID.randomUUID();
        this.compactionInitiateCommitAndSwap(reopenedState2, 0, UUID.randomUUID(), objectId5, sourceObjects2, 0L, 30L, 60, CompactStats.EMPTY);
        Assertions.assertTrue((boolean)reopenedState2.flush());
        Assertions.assertEquals((int)1, (int)reopenedState2.numSegments());
        reopenedState2.close();
        FileTierPartitionState reopenedState3 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig());
        Assertions.assertEquals((int)1, (int)reopenedState3.numSegments());
        reopenedState3.close();
    }

    @Test
    public void testReloadingFTPSWithUnknownVirtualOffsets() {
        File dir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
        TopicPartition tp2 = MergedLog$.MODULE$.parseTopicPartitionName(dir2);
        TopicIdPartition tpid2 = new TopicIdPartition(tp2.topic(), UUID.randomUUID(), tp2.partition());
        byte fileVersion = 8;
        FileTierPartitionState ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, fileVersion, (Scheduler)this.time().scheduler(), this.checksumEnabled(), false, (Time)this.time(), this.cleanupConfig());
        ftps.setTopicId(tpid2.topicId());
        ftps.beginCatchup();
        ftps.onCatchUpComplete();
        ftps.append((AbstractTierMetadata)new TierTopicInitLeader(tpid2, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 0L, 10L, 100, false);
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 11L, 20L, 100, false);
        ftps.flush();
        Optional header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        FileTierPartitionIterator iterator = new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size());
        TierObjectMetadata metadata1 = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)0L, (long)metadata1.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata1.endOffset());
        Assertions.assertFalse((boolean)metadata1.hasVirtualOffset());
        TierObjectMetadata metadata2 = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)11L, (long)metadata2.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata2.endOffset());
        Assertions.assertFalse((boolean)metadata2.hasVirtualOffset());
        ftps.close();
        FileTierPartitionState ftps2 = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig());
        ftps2.flush();
        Optional header2 = FileTierPartitionState.readHeader((CheckedFileIO)ftps2.checkedFileIO());
        FileTierPartitionIterator iterator2 = new FileTierPartitionIterator(tpid2, ftps2.checkedFileIO(), ((Header)header2.get()).size());
        TierObjectMetadata metadata3 = (TierObjectMetadata)iterator2.next();
        Assertions.assertEquals((long)0L, (long)metadata3.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata3.endOffset());
        Assertions.assertTrue((boolean)metadata3.hasVirtualOffset());
        TierObjectMetadata metadata4 = (TierObjectMetadata)iterator2.next();
        Assertions.assertEquals((long)11L, (long)metadata4.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata4.endOffset());
        Assertions.assertTrue((boolean)metadata4.hasVirtualOffset());
        ftps2.close();
    }

    @Test
    public void testStateBeforeDeletion() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        int tierEpoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), tierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectUploadComplete = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), tierEpoch, objectUploadComplete, 0L, 1L, 100L, 10L, 10, false, false, false, TierUploadType.Archive, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), tierEpoch, objectUploadComplete, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Optional segmentState = this.state().previousMetadataBeforeOffset(100L);
        Assertions.assertEquals((Object)TierObjectMetadata.State.INVALID, (Object)((SegmentState)segmentState.get()).stateBeforeDeletion());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), tierEpoch, objectUploadComplete, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        segmentState = this.state().previousMetadataBeforeOffset(100L);
        Assertions.assertEquals((Object)objectUploadComplete, (Object)((SegmentState)segmentState.get()).objectId());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, (Object)((SegmentState)segmentState.get()).stateBeforeDeletion());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), tierEpoch, objectUploadComplete, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), 100L), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        UUID objectFenced = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), tierEpoch, objectFenced, 2L, 3L, 100L, 10L, 10, false, false, false, TierUploadType.Archive, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), ++tierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), tierEpoch, objectFenced, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        segmentState = this.state().previousMetadataBeforeOffset(100L);
        Assertions.assertEquals((Object)objectFenced, (Object)((SegmentState)segmentState.get()).objectId());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_FENCED, (Object)((SegmentState)segmentState.get()).stateBeforeDeletion());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), tierEpoch, objectFenced, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), 100L), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    public void checkInvariants(TierPartitionState state) {
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)state.totalSize());
        List objectIds = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(state.segments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.objectId()).toList();
        Assertions.assertTrue((boolean)((SetLike)objectIds.toSet().intersect((GenSet)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(state.compactedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet())).isEmpty(), (String)"No compacted segment should be in segments list");
        Assertions.assertEquals((int)objectIds.size(), (int)objectIds.toSet().size(), (String)"segments should not be contained in log view twice");
    }

    private static final short superBlockLen$1(Algorithm algorithm) {
        Algorithm algorithm2 = algorithm;
        Algorithm algorithm3 = Algorithm.ADLER;
        if (!(algorithm2 != null ? !algorithm2.equals(algorithm3) : algorithm3 != null)) {
            return 512;
        }
        return 0;
    }

    private final Header header$1(int tierEpoch, long endOffset) {
        return new Header(this.tpid().topicId(), this.state().version(), tierEpoch, TierPartitionStatus.INIT, -1L, endOffset, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, this.cleanupEnabled());
    }

    private final void writeHeader$1(Path path, Algorithm algorithm, int tierEpoch, long endOffset) {
        short superBlockLength = FileTierPartitionStateCompactEnabledTest.superBlockLen$1(algorithm);
        Files.deleteIfExists(path);
        CheckedFileIO.create((Path)path, (Algorithm)algorithm, (short)superBlockLength);
        CheckedFileIO channel = CheckedFileIO.open((Path)path, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        FileTierPartitionState.writeHeader((CheckedFileIO)channel, (Header)this.header$1(tierEpoch, endOffset));
        channel.flush();
        Assertions.assertEquals((int)tierEpoch, (int)((Header)FileTierPartitionState.readHeader((CheckedFileIO)channel).get()).tierEpoch());
        channel.close();
    }

    private final void checkDifferentAlgorithmCombinations$1(int oldTierEpoch, long oldEndOffset, int newTierEpoch, long newEndOffset, boolean result) {
        new .colon.colon((Object)new Tuple2((Object)Algorithm.ADLER, (Object)Algorithm.NO_CHECKSUM), (List)new .colon.colon((Object)new Tuple2((Object)Algorithm.NO_CHECKSUM, (Object)Algorithm.ADLER), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)algo -> {
            this.compareTierStateFilesHelper((Algorithm)algo._1(), oldTierEpoch, oldEndOffset, (Algorithm)algo._2(), newTierEpoch, newEndOffset, result);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCompacted$2(TierPartitionState.RecoveryOperation op$1, FileTierPartitionState state$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append(state$1.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testCompacted$8(FileTierPartitionStateCompactEnabledTest $this, FileTierPartitionState state$1, TopicIdPartition tpid$1, int epoch$2, TierLogSegment deletableSegment) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append((AbstractTierMetadata)new TierSegmentDeleteInitiate(tpid$1, epoch$2, deletableSegment.objectId(), state$1.lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)state$1);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append((AbstractTierMetadata)new TierSegmentDeleteComplete(tpid$1, epoch$2, deletableSegment.objectId(), state$1.lastLocalMaterializedSrcOffsetAndEpoch(), $this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)state$1);
    }

    public static final /* synthetic */ void $anonfun$testCompactionCommitAndSwapWithSmallerEndOffset$1(FileTierPartitionStateCompactEnabledTest $this, FileTierPartitionState reopenedState1$1, TierLogSegment deletableSegment) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState1$1.append((AbstractTierMetadata)new TierSegmentDeleteInitiate($this.tpid(), 0, deletableSegment.objectId(), reopenedState1$1.lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)reopenedState1$1);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState1$1.append((AbstractTierMetadata)new TierSegmentDeleteComplete($this.tpid(), 0, deletableSegment.objectId(), reopenedState1$1.lastLocalMaterializedSrcOffsetAndEpoch(), $this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)reopenedState1$1);
    }
}

