/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.serdes.MaterializationTrackingInfo;
import kafka.tier.serdes.TierPartitionStateHeader;
import kafka.tier.state.CompactStats;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-2A\u0001B\u0003\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011\tQ\u0001*Z1eKJ$Vm\u001d;\u000b\u0005\u00199\u0011!B:uCR,'B\u0001\u0005\n\u0003\u0011!\u0018.\u001a:\u000b\u0003)\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"A\u0003\u0002-Q,7\u000f\u001e*fC\u0012DU-\u00193feZ+'o]5p]N$\u0012!\u0007\t\u0003\u001diI!aG\b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005u\u0001\"AH\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018N\u0003\u0002#G\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0013&\u0003\u0015QWO\\5u\u0015\u00051\u0013aA8sO&\u0011\u0001f\b\u0002\u0005)\u0016\u001cH/A\u000euKN$(+Z1e)N\u001bu.\u001c9bGRLwN\u001c%fC\u0012,'o\u001d\u0015\u0003\u0007u\u0001")
public class HeaderTest {
    @Test
    public void testReadHeaderVersions() {
        if (9 != 9) {
            throw new Exception("FileTierPartitionState version has been bumped.Please ensure the readability of all versions, including any new fields, and then bump testedVersion.");
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 9).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            UUID topicId = UUID.randomUUID();
            int epoch = 0;
            TierPartitionStatus status = TierPartitionStatus.INIT;
            int endOffset = 100;
            OffsetAndEpoch localMaterializedOffsetAndEpoch = new OffsetAndEpoch(50L, Optional.of(Predef$.MODULE$.int2Integer(5)));
            OffsetAndEpoch globalMaterializedOffset = new OffsetAndEpoch(20L, Optional.of(Predef$.MODULE$.int2Integer(2)));
            OffsetAndEpoch errorOffsetAndEpoch = new OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(2)));
            OffsetAndEpoch restoreOffsetAndEpoch = new OffsetAndEpoch(35L, Optional.of(Predef$.MODULE$.int2Integer(3)));
            int compactDirtyStartOffset = 10;
            CompactStats lastCompactStats = new CompactStats(500L, 500L, 200L);
            CompactStats accumulatedCompactStats = new CompactStats(900L, 900L, 500L);
            boolean hasStateChangeTimestamp = true;
            FlatBufferBuilder builder = new FlatBufferBuilder(100).forceDefaults(true);
            int materializedInfo = MaterializationTrackingInfo.createMaterializationTrackingInfo((FlatBufferBuilder)builder, (long)globalMaterializedOffset.offset(), (long)localMaterializedOffsetAndEpoch.offset(), (int)Predef$.MODULE$.Integer2int((Integer)globalMaterializedOffset.epoch().get()), (int)Predef$.MODULE$.Integer2int((Integer)localMaterializedOffsetAndEpoch.epoch().get()));
            TierPartitionStateHeader.startTierPartitionStateHeader((FlatBufferBuilder)builder);
            if (version >= 0) {
                int topicIdOffset = kafka.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)topicId.getMostSignificantBits(), (long)topicId.getLeastSignificantBits());
                TierPartitionStateHeader.addTopicId((FlatBufferBuilder)builder, (int)topicIdOffset);
                TierPartitionStateHeader.addTierEpoch((FlatBufferBuilder)builder, (int)epoch);
                TierPartitionStateHeader.addVersion((FlatBufferBuilder)builder, (byte)((byte)version));
                TierPartitionStateHeader.addStatus((FlatBufferBuilder)builder, (byte)TierPartitionStatus.toByte((TierPartitionStatus)status));
            }
            if (version >= 1) {
                TierPartitionStateHeader.addEndOffset((FlatBufferBuilder)builder, (long)endOffset);
            }
            if (version >= 2) {
                TierPartitionStateHeader.addMaterializationInfo((FlatBufferBuilder)builder, (int)materializedInfo);
            }
            if (version >= 5) {
                int errorOffsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)errorOffsetAndEpoch.offset(), (int)Predef$.MODULE$.Integer2int(errorOffsetAndEpoch.epoch().orElse(Predef$.MODULE$.int2Integer(-1))));
                TierPartitionStateHeader.addErrorOffsetAndEpoch((FlatBufferBuilder)builder, (int)errorOffsetAndEpochId);
            }
            if (version >= 6) {
                int restoreOffsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)restoreOffsetAndEpoch.offset(), (int)Predef$.MODULE$.Integer2int(restoreOffsetAndEpoch.epoch().orElse(Predef$.MODULE$.int2Integer(-1))));
                TierPartitionStateHeader.addRestoreOffsetAndEpoch((FlatBufferBuilder)builder, (int)restoreOffsetAndEpochId);
            }
            if (version >= 7) {
                TierPartitionStateHeader.addCompactDirtyStartOffset((FlatBufferBuilder)builder, (long)compactDirtyStartOffset);
                int lastCompactStatsOffset = kafka.tier.serdes.CompactStats.createCompactStats((FlatBufferBuilder)builder, (long)lastCompactStats.bytesRead(), (long)lastCompactStats.bytesWritten(), (long)lastCompactStats.dirtyBytesRead());
                TierPartitionStateHeader.addLastCompactStats((FlatBufferBuilder)builder, (int)lastCompactStatsOffset);
                int accumulatedCompactStatsOffset = kafka.tier.serdes.CompactStats.createCompactStats((FlatBufferBuilder)builder, (long)accumulatedCompactStats.bytesRead(), (long)accumulatedCompactStats.bytesWritten(), (long)accumulatedCompactStats.dirtyBytesRead());
                TierPartitionStateHeader.addAccumulatedCompactStats((FlatBufferBuilder)builder, (int)accumulatedCompactStatsOffset);
            }
            if (version >= 8) {
                TierPartitionStateHeader.addHasStateChangeTimestamp((FlatBufferBuilder)builder, (boolean)hasStateChangeTimestamp);
            }
            int entryId = TierPartitionStateHeader.endTierPartitionStateHeader((FlatBufferBuilder)builder);
            builder.finish(entryId);
            Header header = new Header(TierPartitionStateHeader.getRootAsTierPartitionStateHeader((ByteBuffer)builder.dataBuffer()));
            Assertions.assertEquals((int)version, (int)header.version());
            Assertions.assertEquals((Object)topicId, (Object)header.topicId());
            Assertions.assertEquals((int)epoch, (int)header.tierEpoch());
            Assertions.assertEquals((Object)status, (Object)header.status());
            if (version >= 2) {
                Assertions.assertEquals((Object)localMaterializedOffsetAndEpoch, (Object)header.localMaterializedOffsetAndEpoch());
                Assertions.assertEquals((Object)globalMaterializedOffset, (Object)header.globalMaterializedOffsetAndEpoch());
            } else {
                Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)header.localMaterializedOffsetAndEpoch());
                Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)header.globalMaterializedOffsetAndEpoch());
            }
            if (version >= 5) {
                Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)header.errorOffsetAndEpoch());
            } else {
                Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)header.errorOffsetAndEpoch());
            }
            if (version >= 6) {
                Assertions.assertEquals((Object)restoreOffsetAndEpoch, (Object)header.restoreOffsetAndEpoch());
            } else {
                Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)header.restoreOffsetAndEpoch());
            }
            if (version >= 7) {
                Assertions.assertEquals((long)compactDirtyStartOffset, (long)header.compactDirtyStartOffset());
                Assertions.assertEquals((Object)lastCompactStats, (Object)header.lastCompactStats());
                Assertions.assertEquals((Object)accumulatedCompactStats, (Object)header.accumulatedCompactStats());
            }
            if (version >= 8) {
                Assertions.assertTrue((boolean)header.hasStateChangeTimestamp());
                return;
            }
            Assertions.assertFalse((boolean)header.hasStateChangeTimestamp());
        });
    }

    @Test
    public void testReadTSCompactionHeaders() {
        UUID topicId = UUID.randomUUID();
        int version = 8;
        int epoch = 0;
        TierPartitionStatus status = TierPartitionStatus.INIT;
        long endOffset = 100L;
        OffsetAndEpoch globalMaterializedOffset = new OffsetAndEpoch(20L, Optional.of(Predef$.MODULE$.int2Integer(2)));
        OffsetAndEpoch localMaterializedOffsetAndEpoch = new OffsetAndEpoch(50L, Optional.of(Predef$.MODULE$.int2Integer(5)));
        OffsetAndEpoch errorOffsetAndEpoch = new OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(2)));
        OffsetAndEpoch restoreOffsetAndEpoch = new OffsetAndEpoch(35L, Optional.of(Predef$.MODULE$.int2Integer(3)));
        int compactDirtyStartOffset = 10;
        CompactStats lastCompactStats = new CompactStats(500L, 500L, 200L);
        CompactStats accumulatedCompactStats = new CompactStats(900L, 900L, 500L);
        boolean hasStateChangeTimestamp = true;
        Header header1 = new Header(topicId, (byte)version, epoch, status, 0L, endOffset, globalMaterializedOffset, localMaterializedOffsetAndEpoch, errorOffsetAndEpoch, restoreOffsetAndEpoch, true, (long)compactDirtyStartOffset, lastCompactStats, accumulatedCompactStats, hasStateChangeTimestamp);
        Assertions.assertEquals((int)version, (int)header1.version());
        Assertions.assertEquals((Object)topicId, (Object)header1.topicId());
        Assertions.assertEquals((int)epoch, (int)header1.tierEpoch());
        Assertions.assertEquals((Object)status, (Object)header1.status());
        Assertions.assertEquals((Object)localMaterializedOffsetAndEpoch, (Object)header1.localMaterializedOffsetAndEpoch());
        Assertions.assertEquals((Object)globalMaterializedOffset, (Object)header1.globalMaterializedOffsetAndEpoch());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)header1.errorOffsetAndEpoch());
        Assertions.assertEquals((Object)restoreOffsetAndEpoch, (Object)header1.restoreOffsetAndEpoch());
        Assertions.assertEquals((long)compactDirtyStartOffset, (long)header1.compactDirtyStartOffset());
        Assertions.assertEquals((Object)lastCompactStats, (Object)header1.lastCompactStats());
        Assertions.assertEquals((Object)accumulatedCompactStats, (Object)header1.accumulatedCompactStats());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)hasStateChangeTimestamp), (Object)BoxesRunTime.boxToBoolean((boolean)header1.hasStateChangeTimestamp()));
        Header header2 = new Header(topicId, (byte)version, epoch, status, 0L, endOffset, globalMaterializedOffset, localMaterializedOffsetAndEpoch, errorOffsetAndEpoch, restoreOffsetAndEpoch, false, (long)compactDirtyStartOffset, lastCompactStats, accumulatedCompactStats, hasStateChangeTimestamp);
        Assertions.assertEquals((int)version, (int)header2.version());
        Assertions.assertEquals((Object)topicId, (Object)header2.topicId());
        Assertions.assertEquals((int)epoch, (int)header2.tierEpoch());
        Assertions.assertEquals((Object)status, (Object)header2.status());
        Assertions.assertEquals((Object)localMaterializedOffsetAndEpoch, (Object)header2.localMaterializedOffsetAndEpoch());
        Assertions.assertEquals((Object)globalMaterializedOffset, (Object)header2.globalMaterializedOffsetAndEpoch());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)header2.errorOffsetAndEpoch());
        Assertions.assertEquals((Object)restoreOffsetAndEpoch, (Object)header2.restoreOffsetAndEpoch());
        Assertions.assertEquals((long)-1L, (long)header2.compactDirtyStartOffset());
        Assertions.assertEquals((Object)CompactStats.EMPTY, (Object)header2.lastCompactStats());
        Assertions.assertEquals((Object)CompactStats.EMPTY, (Object)header2.accumulatedCompactStats());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)hasStateChangeTimestamp), (Object)BoxesRunTime.boxToBoolean((boolean)header2.hasStateChangeTimestamp()));
    }
}

