/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.serdes.Header;
import kafka.tier.serdes.TierPartitionStateEntry;
import kafka.tier.serdes.TierPartitionStateHeader;
import kafka.tier.serdes.TierPartitionStateMetadataSnapshot;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.TierObjectStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-2A\u0001B\u0003\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011\t\tC+[3s!\u0006\u0014H/\u001b;j_:lU\r^1eCR\f7K\\1qg\"|G\u000fV3ti*\u0011aaB\u0001\u0006gR|'/\u001a\u0006\u0003\u0011%\tA\u0001^5fe*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u000b\u0005aB/Z:u)&,'/T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;QCRDG#A\r\u0011\u00059Q\u0012BA\u000e\u0010\u0005\u0011)f.\u001b;)\u0005\ti\u0002C\u0001\u0010(\u001b\u0005y\"B\u0001\u0011\"\u0003\r\t\u0007/\u001b\u0006\u0003E\r\nqA[;qSR,'O\u0003\u0002%K\u0005)!.\u001e8ji*\ta%A\u0002pe\u001eL!\u0001K\u0010\u0003\tQ+7\u000f^\u0001\"i\u0016\u001cH\u000fV5fe6+G/\u00193bi\u0006\u001cf.\u00199tQ>$8+\u001a:jC2L'0\u001a\u0015\u0003\u0007u\u0001")
public class TierPartitionMetadataSnapshotTest {
    @Test
    public void testTierMetadataSnapshotPath() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierObjectStore.TierPartitionStateSnapshotMetadata metadata = new TierObjectStore.TierPartitionStateSnapshotMetadata(topicIdPartition, 123L, new OffsetAndEpoch(45L, Optional.of(Predef$.MODULE$.int2Integer(6))), 7);
        String keyPrefix = "bar";
        TierObjectStore.FileType fileType = TierObjectStore.FileType.TIER_PARTITION_STATE_METADATA_SNAPSHOT;
        String expectedPath = new StringBuilder(9).append(keyPrefix).append(TierObjectStore.DataTypePathPrefix.TIER_PARTITION_STATE_METADATA_SNAPSHOT.prefix).append("/").append(topicIdPartition.topicIdAsBase64()).append("/").append(topicIdPartition.partition()).append("/").append(metadata.lastMaterializedEventTimestamp()).append("_").append(metadata.lastMaterializedEventOffsetAndEpoch().offset()).append("_").append(metadata.lastMaterializedEventOffsetAndEpoch().epoch().orElse(Predef$.MODULE$.int2Integer(-1))).append("_").append(metadata.tierEpoch()).append("_v").append(metadata.version()).append(".").append(fileType.suffix()).toString();
        Assertions.assertEquals((int)0, (int)metadata.version());
        Assertions.assertEquals((Object)expectedPath, (Object)metadata.toPath(keyPrefix, fileType));
    }

    @Test
    public void testTierMetadataSnapshotSerialize() {
        int version = 0;
        UUID uuid = UUID.randomUUID();
        int[] tierEpochEntries = new int[]{3, 6};
        int[] ftpsEntryOffsets = new int[2];
        FlatBufferBuilder builder = new FlatBufferBuilder().forceDefaults(true);
        int headerOffset = Header.createHeader((FlatBufferBuilder)builder, (int)version);
        TierPartitionStateHeader.startTierPartitionStateHeader((FlatBufferBuilder)builder);
        int topicIdOffset = kafka.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)uuid.getMostSignificantBits(), (long)uuid.getLeastSignificantBits());
        TierPartitionStateHeader.addTopicId((FlatBufferBuilder)builder, (int)topicIdOffset);
        int ftpsHeaderOffset = TierPartitionStateHeader.endTierPartitionStateHeader((FlatBufferBuilder)builder);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            TierPartitionStateEntry.startTierPartitionStateEntry((FlatBufferBuilder)builder);
            TierPartitionStateEntry.addTierEpoch((FlatBufferBuilder)builder, (int)tierEpochEntries[i]);
            ftpsEntryOffsets$1[i] = TierPartitionStateEntry.endTierPartitionStateEntry((FlatBufferBuilder)builder);
        });
        int ftpsEntriesVectorOffset = TierPartitionStateMetadataSnapshot.createTierPartitionStateEntriesVector((FlatBufferBuilder)builder, (int[])ftpsEntryOffsets);
        int endOffset = TierPartitionStateMetadataSnapshot.createTierPartitionStateMetadataSnapshot((FlatBufferBuilder)builder, (int)headerOffset, (int)ftpsHeaderOffset, (int)ftpsEntriesVectorOffset);
        TierPartitionStateMetadataSnapshot.finishTierPartitionStateMetadataSnapshotBuffer((FlatBufferBuilder)builder, (int)endOffset);
        TierPartitionStateMetadataSnapshot ftpsSnapshot = TierPartitionStateMetadataSnapshot.getRootAsTierPartitionStateMetadataSnapshot((ByteBuffer)builder.dataBuffer());
        Assertions.assertEquals((int)version, (int)ftpsSnapshot.header().version());
        kafka.tier.serdes.UUID topicId = ftpsSnapshot.tierPartitionStateHeader().topicId();
        Assertions.assertEquals((Object)uuid, (Object)new UUID(topicId.mostSignificantBits(), topicId.leastSignificantBits()));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((int)tierEpochEntries[i], (int)ftpsSnapshot.tierPartitionStateEntries(i).tierEpoch()));
    }
}

