/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.SegmentDeletion$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\tEh\u0001\u0002\u001b6\u0001yBQ!\u0012\u0001\u0005\u0002\u0019C\u0011\"\u0013\u0001A\u0002\u0003\u0007I\u0011\u0001&\t\u0013U\u0003\u0001\u0019!a\u0001\n\u00031\u0006\"\u0003/\u0001\u0001\u0004\u0005\t\u0015)\u0003L\u0011\u001di\u0006\u00011A\u0005\u0004yCq\u0001\u001a\u0001A\u0002\u0013\u0005Q\r\u0003\u0004h\u0001\u0001\u0006Ka\u0018\u0005\nQ\u0002\u0001\r\u00111A\u0005\u0002%D\u0011B\u001c\u0001A\u0002\u0003\u0007I\u0011A8\t\u0013E\u0004\u0001\u0019!A!B\u0013Q\u0007b\u0002:\u0001\u0005\u0004%\ta\u001d\u0005\u0007u\u0002\u0001\u000b\u0011\u0002;\t\u000fm\u0004\u0001\u0019!C\u0001y\"I\u0011q\u0001\u0001A\u0002\u0013\u0005\u0011\u0011\u0002\u0005\b\u0003\u001b\u0001\u0001\u0015)\u0003~\u0011%\ty\u0001\u0001b\u0001\n\u0003\t\t\u0002\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\n\u0011-\tY\u0002\u0001a\u0001\u0002\u0004%\t!!\b\t\u0017\u0005-\u0002\u00011AA\u0002\u0013\u0005\u0011Q\u0006\u0005\f\u0003c\u0001\u0001\u0019!A!B\u0013\ty\u0002C\u0006\u00024\u0001\u0001\r\u00111A\u0005\u0002\u0005u\u0001bCA\u001b\u0001\u0001\u0007\t\u0019!C\u0001\u0003oA1\"a\u000f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002 !I\u0011Q\b\u0001C\u0002\u0013\u0005\u0011q\b\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002B!I\u0011q\n\u0001C\u0002\u0013\u0005\u0011\u0011\u000b\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002T!I\u0011\u0011\r\u0001C\u0002\u0013\u0005\u00111\r\u0005\t\u0003c\u0002\u0001\u0015!\u0003\u0002f!I\u00111\u000f\u0001C\u0002\u0013\u0005\u0011Q\u000f\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002x!I\u0011Q\u0011\u0001C\u0002\u0013\u0005\u0011q\u0011\u0005\t\u0003+\u0003\u0001\u0015!\u0003\u0002\n\"I\u0011q\u0013\u0001C\u0002\u0013\u0005\u0011\u0011\u0014\u0005\t\u0003G\u0003\u0001\u0015!\u0003\u0002\u001c\"I\u0011Q\u0015\u0001C\u0002\u0013\u0005\u0011q\u0015\u0005\t\u0003_\u0003\u0001\u0015!\u0003\u0002*\"I\u0011\u0011\u0017\u0001C\u0002\u0013\u0005\u00111\u0017\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u00026\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0006bBAn\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\tY\u0010\u0001C\u0005\u0003{4aA!\b\u0001\u0001\t}\u0001BB#-\t\u0003\u0011I\u0004C\u0004\u0003@1\"\tE!\u0011\t\u000f\t\u001dD\u0006\"\u0011\u0003j!9!1\u000e\u0001\u0005\u0002\t5\u0004b\u0002B[\u0001\u0011\u0005!q\u0017\u0005\b\u0005\u000b\u0004A\u0011\u0001Bd\u0011\u001d\u0011)\u000e\u0001C\u0001\u0005/\u0014!$\u0011:dQ&4X\rV1tW&sG/Z4sCRLwN\u001c+fgRT!AN\u001c\u0002\u000f\u0005\u00148\r[5wK*\u0011\u0001(O\u0001\u0006i\u0006\u001c8n\u001d\u0006\u0003um\nA\u0001^5fe*\tA(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0004C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u000fB\u0011\u0001\nA\u0007\u0002k\u0005AQ\r_3dkR|'/F\u0001L!\ta5+D\u0001N\u0015\tqu*\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001U)\u0002\tU$\u0018\u000e\u001c\u0006\u0002%\u0006!!.\u0019<b\u0013\t!VJA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00031)\u00070Z2vi>\u0014x\fJ3r)\t9&\f\u0005\u0002A1&\u0011\u0011,\u0011\u0002\u0005+:LG\u000fC\u0004\\\u0007\u0005\u0005\t\u0019A&\u0002\u0007a$\u0013'A\u0005fq\u0016\u001cW\u000f^8sA\u0005\u0011QmY\u000b\u0002?B\u0011\u0001MY\u0007\u0002C*\u0011a*Q\u0005\u0003G\u0006\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\r\u0015\u001cw\fJ3r)\t9f\rC\u0004\\\r\u0005\u0005\t\u0019A0\u0002\u0007\u0015\u001c\u0007%\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]V\t!\u000e\u0005\u0002lY6\t\u0011(\u0003\u0002ns\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0015i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:|F%Z9\u0015\u0005]\u0003\bbB.\n\u0003\u0003\u0005\rA[\u0001\u0012i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\u0013!\u00039beRLG/[8o+\u0005!\bCA;y\u001b\u00051(BA<<\u0003\u001d\u0019G.^:uKJL!!\u001f<\u0003\u0013A\u000b'\u000f^5uS>t\u0017A\u00039beRLG/[8oA\u000511m\u001c8gS\u001e,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u00051(\u0001\u0004tKJ4XM]\u0005\u0004\u0003\u000by(aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\r9\u00161\u0002\u0005\b7:\t\t\u00111\u0001~\u0003\u001d\u0019wN\u001c4jO\u0002\n\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0005\u0005M\u0001c\u0001@\u0002\u0016%\u0019\u0011qC@\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA\u00051A/\u001c9ESJ,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nR\u0003\tIw.\u0003\u0003\u0002*\u0005\r\"\u0001\u0002$jY\u0016\f!\u0002^7q\t&\u0014x\fJ3r)\r9\u0016q\u0006\u0005\t7N\t\t\u00111\u0001\u0002 \u00059A/\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/\u0001\u0006m_\u001e$\u0015N]0%KF$2aVA\u001d\u0011!Yf#!AA\u0002\u0005}\u0011a\u00027pO\u0012K'\u000fI\u0001\t[>\u001c7\u000eV5nKV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011qI\u001e\u0002\u000bU$\u0018\u000e\\:\n\t\u0005-\u0013Q\t\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u0001\u001ai&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR1di>\u0014\u00180\u0006\u0002\u0002TA!\u0011QKA.\u001b\t\t9FC\u0002\u0002Ze\nQa\u001d;bi\u0016LA!!\u0018\u0002X\tIB+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r\u0006\u001cGo\u001c:z\u0003i!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GC\u000e$xN]=!\u0003E!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u000b\u0003\u0003K\u0002B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003WZ\u0014a\u00017pO&!\u0011qNA5\u0005E!\u0016.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u0001\u0013i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\b%\u0001\nue\u0006t7/\u001b;j_:<\u0016-\u001b;US6,WCAA<!\u0011\tI(a \u000e\u0005\u0005m$bAA?C\u0006AA-\u001e:bi&|g.\u0003\u0003\u0002\u0002\u0006m$A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0014iJ\fgn]5uS>tw+Y5u)&lW\rI\u0001\u0014i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0003\u0003\u0013\u0003b\u0001TAFU\u0006=\u0015bAAG\u001b\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\t\u0005U\u0013\u0011S\u0005\u0005\u0003'\u000b9F\u0001\nUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0017\u0001\u0006;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\b%A\buS\u0016\u0014H+Y:lg\u000e{gNZ5h+\t\tY\n\u0005\u0003\u0002\u001e\u0006}U\"A\u001c\n\u0007\u0005\u0005vGA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0003A!\u0018.\u001a:UCN\\7oQ8oM&<\u0007%\u0001\bdY\u0016\fg.\u001e9EK2\f\u00170T:\u0016\u0005\u0005%\u0006c\u0001!\u0002,&\u0019\u0011QV!\u0003\t1{gnZ\u0001\u0010G2,\u0017M\\;q\t\u0016d\u0017-_'tA\u0005\t2\r\\3b]V\u0004\u0018J\u001c;feZ\fG.T:\u0016\u0005\u0005U\u0006c\u0001!\u00028&\u0019\u0011\u0011X!\u0003\u0007%sG/\u0001\ndY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0013!B:fiV\u0004H#A,)\u0007!\n\u0019\r\u0005\u0003\u0002F\u0006]WBAAd\u0015\u0011\tI-a3\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002N\u0006=\u0017a\u00026va&$XM\u001d\u0006\u0005\u0003#\f\u0019.A\u0003kk:LGO\u0003\u0002\u0002V\u0006\u0019qN]4\n\t\u0005e\u0017q\u0019\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$wn\u001e8)\u0007%\ny\u000e\u0005\u0003\u0002F\u0006\u0005\u0018\u0002BAr\u0003\u000f\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u000251|w\r\u0015:pm&$\u0017N\\4SKBd\u0017nY1NC:\fw-\u001a:\u0015\r\u0005%\u0018q^Ay!\rq\u00181^\u0005\u0004\u0003[|(A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0006Q*\u0002\rA\u001b\u0005\b\u0003gT\u0003\u0019AA{\u0003-\t'm\u001d;sC\u000e$Hj\\4\u0011\t\u0005\u001d\u0014q_\u0005\u0005\u0003s\fIGA\u0006BEN$(/Y2u\u0019><\u0017\u0001G2sK\u0006$X\rV5feB\u000b'\u000f^5uS>t7\u000b^1uKRa\u0011qRA\u0000\u0005\u0003\u0011YA!\u0006\u0003\u001a!)\u0001n\u000ba\u0001U\"9!1A\u0016A\u0002\t\u0015\u0011\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000eE\u0002\u007f\u0005\u000fI1A!\u0003\u0000\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\"9!QB\u0016A\u0002\t=\u0011aD2iK\u000e\\7/^7F]\u0006\u0014G.\u001a3\u0011\u0007\u0001\u0013\t\"C\u0002\u0003\u0014\u0005\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0003\u0018-\u0002\rAa\u0004\u0002\u001d\r|W\u000e]1di\u0016s\u0017M\u00197fI\"9!1D\u0016A\u0002\t=\u0011AD2mK\u0006tW\u000f]#oC\ndW\r\u001a\u0002\u0015\u001b>\u001c7\u000eV5feR{\u0007/[2NC:\fw-\u001a:\u0014\u000b1\u0012\tC!\f\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQ1Aa\nR\u0003\u0011a\u0017M\\4\n\t\t-\"Q\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\t\t=\"QG\u0007\u0003\u0005cQ1Aa\r:\u0003\u0015!x\u000e]5d\u0013\u0011\u00119D!\r\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000f\u0006\u0002\u0003<A\u0019!Q\b\u0017\u000e\u0003\u0001\t1\"\u00193e\u001b\u0016$\u0018\rZ1uCR!!1\tB,!\u0015a%Q\tB%\u0013\r\u00119%\u0014\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003\u0002B&\u0005#rA!!\u0016\u0003N%!!qJA,\u0003I!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\n\t\tM#Q\u000b\u0002\r\u0003B\u0004XM\u001c3SKN,H\u000e\u001e\u0006\u0005\u0005\u001f\n9\u0006C\u0004\u0003Z9\u0002\rAa\u0017\u0002\u000b\u0015tGO]=\u0011\t\tu#1M\u0007\u0003\u0005?R1A!\u0019:\u0003\u0019!w.\\1j]&!!Q\rB0\u0005Q\t%m\u001d;sC\u000e$H+[3s\u001b\u0016$\u0018\rZ1uC\u00069\u0011n\u001d*fC\u0012LHC\u0001B\b\u0003]!Xm\u001d;Be\u000eD\u0017N^3UCN\\W)\u001c9us2{w\rF\u0004X\u0005_\u0012\tHa\u001d\t\u000f\t5\u0001\u00071\u0001\u0003\u0010!9!q\u0003\u0019A\u0002\t=\u0001b\u0002B\u000ea\u0001\u0007!q\u0002\u0015\ba\t]$q\u0011BE!\u0011\u0011IHa!\u000e\u0005\tm$\u0002\u0002B?\u0005\u007f\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0005\u0003\u000bY-\u0001\u0004qCJ\fWn]\u0005\u0005\u0005\u000b\u0013YHA\u0005DgZ\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0002\"1\u0012BH\u0005'\u00139Ja'\u0003 \n\r&qU\u0011\u0003\u0005\u001b\u000b\u0011CZ1mg\u0016dc-\u00197tK22\u0017\r\\:fC\t\u0011\t*\u0001\tgC2\u001cX\r\f;sk\u0016dc-\u00197tK\u0006\u0012!QS\u0001\u0011iJ,X\r\f4bYN,GFZ1mg\u0016\f#A!'\u0002\u001fQ\u0014X/\u001a\u0017ueV,GFZ1mg\u0016\f#A!(\u0002!\u0019\fGn]3-M\u0006d7/\u001a\u0017ueV,\u0017E\u0001BQ\u0003=1\u0017\r\\:fYQ\u0014X/\u001a\u0017ueV,\u0017E\u0001BS\u0003=!(/^3-M\u0006d7/\u001a\u0017ueV,\u0017E\u0001BU\u00039!(/^3-iJ,X\r\f;sk\u0016D3\u0001\rBW!\u0011\u0011yK!-\u000e\u0005\t}\u0014\u0002\u0002BZ\u0005\u007f\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\r\"Xm\u001d;Be\u000eD\u0017N^3UCN\\W\u000b\u001d7pC\u0012\u001c\bK]8ek\u000e,'o\u0015;bi\u0016$ra\u0016B]\u0005w\u0013i\fC\u0004\u0003\u000eE\u0002\rAa\u0004\t\u000f\t]\u0011\u00071\u0001\u0003\u0010!9!1D\u0019A\u0002\t=\u0001fB\u0019\u0003x\t\u001d%\u0011\u0019\u0017\u0011\u0005\u0017\u0013yIa%\u0003\u0018\nm%q\u0014BR\u0005OC3!\rBW\u00031\"Xm\u001d;Be\u000eD\u0017N^3s%\u0016$(/[3t\u001f:\u001cuN\\2veJ,g\u000e\u001e#fY\u0016$XMU3d_J$7\u000fF\u0004X\u0005\u0013\u0014YM!4\t\u000f\t5!\u00071\u0001\u0003\u0010!9!q\u0003\u001aA\u0002\t=\u0001b\u0002B\u000ee\u0001\u0007!q\u0002\u0015\be\t]$q\u0011BiYA\u0011YIa$\u0003\u0014\n]%1\u0014BP\u0005G\u00139\u000bK\u00023\u0005[\u000b\u0001\u0006^3ti\u0006\u00138\r[5wKJ,\u0005pY3qi&|gn\u00148QCJ$\u0018\u000e^5p]\u0012+G.\u001a;j_:$ra\u0016Bm\u00057\u0014i\u000eC\u0004\u0003\u000eM\u0002\rAa\u0004\t\u000f\t]1\u00071\u0001\u0003\u0010!9!1D\u001aA\u0002\t=\u0001fB\u001a\u0003x\t\u001d%\u0011\u001d\u0017\u0011\u0005\u0017\u0013yIa%\u0003\u0018\nm%q\u0014BR\u0005OC3a\rBWQ\u001d\u0001!q\u001dBD\u0005[\u0004B!!2\u0003j&!!1^Ad\u0005\r!\u0016mZ\u0011\u0003\u0005_\f1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class ArchiveTaskIntegrationTest {
    private ExecutorService executor;
    private ExecutionContext ec = ExecutionContext$.MODULE$.fromExecutorService(this.executor());
    private TopicIdPartition topicIdPartition;
    private final Partition partition = (Partition)Mockito.mock(Partition.class);
    private KafkaConfig config = null;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private File tmpDir;
    private File logDir;
    private final MockTime mockTime = new MockTime();
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, this.tierPartitionStateFactory(), (Option)None$.MODULE$);
    private final FiniteDuration transitionWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private final ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates = new ConcurrentHashMap();
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, TierTasksConfig$.MODULE$.$lessinit$greater$default$4(), TierTasksConfig$.MODULE$.$lessinit$greater$default$5(), TierTasksConfig$.MODULE$.$lessinit$greater$default$6(), TierTasksConfig$.MODULE$.$lessinit$greater$default$7(), TierTasksConfig$.MODULE$.$lessinit$greater$default$8(), TierTasksConfig$.MODULE$.$lessinit$greater$default$9());
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public void ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public void topicIdPartition_$eq(TopicIdPartition x$1) {
        this.topicIdPartition = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public FiniteDuration transitionWaitTime() {
        return this.transitionWaitTime;
    }

    public ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates() {
        return this.tierPartitionStates;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    @BeforeEach
    public void setup() {
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.executor_$eq(Executors.newFixedThreadPool(1));
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        TopicPartition topicPartition = MergedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        this.topicIdPartition_$eq(new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition()));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.executor().shutdownNow();
        this.brokerTopicStats().close();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.tierPartitionStates().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)tierPartitionState -> {
            ArchiveTaskIntegrationTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        this.tierPartitionStates().clear();
        Utils.delete((File)this.tmpDir());
        Utils.delete((File)this.logDir());
    }

    private ReplicaManager logProvidingReplicaManager(TopicIdPartition topicIdPartition, AbstractLog abstractLog) {
        return (ReplicaManager)Mockito.when((Object)((ReplicaManager)Mockito.mock(ReplicaManager.class)).getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)abstractLog)).getMock();
    }

    private TierPartitionState createTierPartitionState(TopicIdPartition topicIdPartition, LogDirFailureChannel logDirFailureChannel, boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(TestUtils$.MODULE$.tempDir(), logDirFailureChannel, topicIdPartition.topicPartition(), true, (Scheduler)this.mockTime().scheduler(), checksumEnabled, compactEnabled, (Time)this.mockTime(), new TierPartitionStateCleanupConfig(cleanupEnabled, this.cleanupDelayMs(), (long)this.cleanupIntervalMs()));
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates().put(topicIdPartition, (TierPartitionState)tierPartitionState);
        return tierPartitionState;
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "false,true,false", "true,false,false", "true,true,false", "false,false,true", "false,true,true", "true,false,true", "true,true,true"})
    public void testArchiveTaskEmptyLog(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        int x$1 = 0x500000;
        boolean x$2 = true;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$2, x$13, x$14, x$15, x$16, x$17);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        File x$18 = this.logDir();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        MockScheduler x$21 = this.mockTime().scheduler();
        MockTime x$22 = this.mockTime();
        TierLogComponents x$23 = this.tierLogComponents();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$26 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$28 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$29 = LogTestUtils$.MODULE$.createLog$default$10();
        LogOffsetsListener x$30 = LogTestUtils$.MODULE$.createLog$default$13();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$14();
        Option<Uuid> x$32 = LogTestUtils$.MODULE$.createLog$default$15();
        boolean x$33 = LogTestUtils$.MODULE$.createLog$default$16();
        ConcurrentMap<String, Object> x$34 = LogTestUtils$.MODULE$.createLog$default$17();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$18, logConfig, x$20, x$21, (Time)x$22, x$25, x$26, x$27, x$28, x$29, x$23, logDirFailureChannel, x$30, x$31, x$32, x$33, x$34);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        ArchiveTask nextState = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertTrue((boolean)(nextState.state() instanceof BeforeUpload), (String)"expected to be in BeforeUpload");
        Assertions.assertFalse((boolean)nextState.ctx().isCancelled(), (String)"expected task to not be cancelled");
        Assertions.assertEquals((Integer)tierObjectStore.getObjectCounts().getOrDefault(TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0)), (int)0, (String)"expected zero segments to be uploaded");
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "false,true,false", "true,false,false", "true,true,false", "false,false,true", "false,true,true", "true,false,true", "true,true,true"})
    public void testArchiveTaskUploadsProducerState(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        int x$12 = 1024;
        long x$22 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$122 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$22, x$12, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        File x$18 = this.logDir();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        MockScheduler x$21 = this.mockTime().scheduler();
        MockTime x$222 = this.mockTime();
        TierLogComponents x$23 = this.tierLogComponents();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$26 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$28 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$29 = LogTestUtils$.MODULE$.createLog$default$10();
        LogOffsetsListener x$30 = LogTestUtils$.MODULE$.createLog$default$13();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$14();
        Option<Uuid> x$32 = LogTestUtils$.MODULE$.createLog$default$15();
        boolean x$33 = LogTestUtils$.MODULE$.createLog$default$16();
        ConcurrentMap<String, Object> x$34 = LogTestUtils$.MODULE$.createLog$default$17();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$18, logConfig, x$20, x$21, (Time)x$222, x$25, x$26, x$27, x$28, x$29, x$23, logDirFailureChannel, x$30, x$31, x$32, x$33, x$34);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        long pid1 = 1L;
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            .colon.colon x$35 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            short x$37 = 0;
            byte x$39 = TestUtils$.MODULE$.records$default$2();
            CompressionType x$40 = TestUtils$.MODULE$.records$default$3();
            long x$41 = TestUtils$.MODULE$.records$default$7();
            int x$42 = TestUtils$.MODULE$.records$default$8();
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$35, x$39, x$40, pid1, x$37, i, x$41, x$42), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$1.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size(), (String)"expected 5 local log segments");
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size(), (String)"expected 4 tierable segments");
        List snapshotFiles = (List)((TraversableOnce)log.localLogSegments().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toList().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(log.producerStateManager().snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)x$2))), List$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)4, (int)snapshotFiles.size(), (String)"expected to be able to use segment base offset to get snapshot files for 4 segments");
        ArchiveTask maybeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload.state().getClass(), (String)"expected successful transition to Upload");
        ArchiveTask maybeAfterUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(AfterUpload.class, maybeAfterUpload.state().getClass(), (String)"expected successful transition to afterUpload");
        ConcurrentHashMap objectCounts = tierObjectStore.getObjectCounts();
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(TierObjectStore.FileType.SEGMENT)), (String)"expected 1 segment file");
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(TierObjectStore.FileType.PRODUCER_STATE)), (String)"expected 1 producer state");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)maybeAfterUpload.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime())).state() instanceof BeforeUpload), (String)"expected successful transition to beforeUpload");
        Assertions.assertEquals((int)tierPartitionState.numSegments(), (int)1, (String)"expected 1 segment to be materialized");
        Assertions.assertTrue((boolean)((TierLogSegment)tierPartitionState.metadata(0L).get()).metadata().hasProducerState(), (String)"expected hasProducerState metadata flag to be set");
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "false,true,false", "true,false,false", "true,true,false", "false,false,true", "false,true,true", "true,false,true", "true,true,true"})
    public void testArchiverRetriesOnConcurrentDeleteRecords(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        int x$1 = 1024;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$18 = this.logDir();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        MockScheduler x$21 = this.mockTime().scheduler();
        MockTime x$22 = this.mockTime();
        TierLogComponents x$23 = this.tierLogComponents();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$26 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$28 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$29 = LogTestUtils$.MODULE$.createLog$default$10();
        LogOffsetsListener x$30 = LogTestUtils$.MODULE$.createLog$default$13();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$14();
        Option<Uuid> x$32 = LogTestUtils$.MODULE$.createLog$default$15();
        boolean x$33 = LogTestUtils$.MODULE$.createLog$default$16();
        ConcurrentMap<String, Object> x$34 = LogTestUtils$.MODULE$.createLog$default$17();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$18, logConfig, x$20, x$21, (Time)x$22, x$25, x$26, x$27, x$28, x$29, x$23, logDirFailureChannel, x$30, x$31, x$32, x$33, x$34);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            .colon.colon x$35 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            short x$37 = 0;
            byte x$39 = TestUtils$.MODULE$.records$default$2();
            CompressionType x$40 = TestUtils$.MODULE$.records$default$3();
            long x$41 = TestUtils$.MODULE$.records$default$7();
            int x$42 = TestUtils$.MODULE$.records$default$8();
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$35, x$39, x$40, pid1, x$37, i, x$41, x$42), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$2.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        ArchiveTask maybeUpload_1 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        File segmentFileBeingUploaded = ((Upload)maybeUpload_1.state()).uploadableSegment().logSegmentFile();
        Assertions.assertEquals(Upload.class, maybeUpload_1.state().getClass());
        Assertions.assertEquals((Object)segmentFileBeingUploaded, (Object)((LogSegment)log.localLogSegments().head()).log().file());
        LogSegment newFirstSegment = (LogSegment)log.localLogSegments().toList().apply(3);
        File newFirstSegmentFile = newFirstSegment.log().file();
        log.maybeIncrementLogStartOffset(newFirstSegment.baseOffset() + 3L, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        log.deleteOldSegments();
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        ArchiveTask maybeUpload_2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload_2.state().getClass());
        Assertions.assertEquals((Object)newFirstSegmentFile, (Object)((Upload)maybeUpload_2.state()).uploadableSegment().logSegmentFile());
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "false,true,false", "true,false,false", "true,true,false", "false,false,true", "false,true,true", "true,false,true", "true,true,true"})
    public void testArchiverExceptionOnPartitionDeletion(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        int x$1 = 1024;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$18 = this.logDir();
        BrokerTopicStats x$20 = this.brokerTopicStats();
        MockScheduler x$21 = this.mockTime().scheduler();
        MockTime x$22 = this.mockTime();
        TierLogComponents x$23 = this.tierLogComponents();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$26 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$28 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$29 = LogTestUtils$.MODULE$.createLog$default$10();
        LogOffsetsListener x$30 = LogTestUtils$.MODULE$.createLog$default$13();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$14();
        Option<Uuid> x$32 = LogTestUtils$.MODULE$.createLog$default$15();
        boolean x$33 = LogTestUtils$.MODULE$.createLog$default$16();
        ConcurrentMap<String, Object> x$34 = LogTestUtils$.MODULE$.createLog$default$17();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$18, logConfig, x$20, x$21, (Time)x$22, x$25, x$26, x$27, x$28, x$29, x$23, logDirFailureChannel, x$30, x$31, x$32, x$33, x$34);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            .colon.colon x$35 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            short x$37 = 0;
            byte x$39 = TestUtils$.MODULE$.records$default$2();
            CompressionType x$40 = TestUtils$.MODULE$.records$default$3();
            long x$41 = TestUtils$.MODULE$.records$default$7();
            int x$42 = TestUtils$.MODULE$.records$default$8();
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$35, x$39, x$40, pid1, x$37, i, x$41, x$42), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$3.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        log.renameDir(MergedLog$.MODULE$.logDeleteDirName(this.topicIdPartition().topicPartition()), true);
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        Predef$.MODULE$.assert(ctx.isCancelled());
        tierPartitionState.delete();
    }

    public static final /* synthetic */ void $anonfun$teardown$1(TierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public ArchiveTaskIntegrationTest() {
        this.cleanupIntervalMs = 0;
    }

    public class MockTierTopicManager
    implements TierTopicAppender {
        public CompletableFuture<TierPartitionState.AppendResult> addMetadata(AbstractTierMetadata entry) {
            TierPartitionState tierPartitionState = this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().tierPartitionStates().get(this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().topicIdPartition());
            return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(Future$.MODULE$.successful((Object)tierPartitionState.append(entry, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch())))).toCompletableFuture();
        }

        public boolean isReady() {
            return true;
        }

        public /* synthetic */ ArchiveTaskIntegrationTest kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer() {
            return ArchiveTaskIntegrationTest.this;
        }

        public MockTierTopicManager() {
            if (ArchiveTaskIntegrationTest.this == null) {
                throw null;
            }
        }
    }
}

