/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.Serializable;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.StopLeadership;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\r\u001b\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u00047\u0001\u0001\u0006I\u0001\r\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u0019y\u0004\u0001)A\u0005s!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002+\u0001A\u0003%!\tC\u0004V\u0001\t\u0007I\u0011\u0002,\t\ri\u0003\u0001\u0015!\u0003X\u0011\u001dY\u0006A1A\u0005\nqCa\u0001\u0019\u0001!\u0002\u0013i\u0006\"B1\u0001\t\u0003\u0011\u0007\"B:\u0001\t\u0003\u0011\u0007\"B;\u0001\t\u0003\u0011\u0007\"B<\u0001\t\u0003\u0011\u0007\"B=\u0001\t\u0003\u0011\u0007\"B>\u0001\t\u0003\u0011\u0007\"B?\u0001\t\u0003\u0011\u0007BB@\u0001\t\u0013\t\t\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c!9\u0011Q\u0007\u0001\u0005\n\u0005]\u0002bBA \u0001\u0011%\u0011\u0011\t\u0005\b\u0003\u000b\u0002A\u0011BA$\u0005U\t%o\u00195jm\u0016\u0014H+Y:l#V,W/\u001a+fgRT!a\u0007\u000f\u0002\u000f\u0005\u00148\r[5wK*\u0011QDH\u0001\u0006i\u0006\u001c8n\u001d\u0006\u0003?\u0001\nA\u0001^5fe*\t\u0011%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002YA\u0011Q\u0006A\u0007\u00025\u0005\u00191\r\u001e=\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0010\u0002\u000f\u0019,Go\u00195fe&\u0011QG\r\u0002\u0014\u0007\u0006t7-\u001a7mCRLwN\\\"p]R,\u0007\u0010^\u0001\u0005GRD\b%\u0001\u0003uS6,W#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0002\u0013!B;uS2\u001c\u0018B\u0001 <\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u00027bO6\u000b\u0007/F\u0001C!\u0011\u0019\u0005J\u0013(\u000e\u0003\u0011S!!\u0012$\u0002\u000f5,H/\u00192mK*\u0011qIJ\u0001\u000bG>dG.Z2uS>t\u0017BA%E\u0005\ri\u0015\r\u001d\t\u0003\u00172k\u0011AH\u0005\u0003\u001bz\u0011\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\u0007\u0015z\u0015+\u0003\u0002QM\t1q\n\u001d;j_:\u0004\"!\n*\n\u0005M3#\u0001\u0002'p]\u001e\fq\u0001\\1h\u001b\u0006\u0004\b%\u0001\u0005nCb$\u0016m]6t+\u00059\u0006CA\u0013Y\u0013\tIfEA\u0002J]R\f\u0011\"\\1y)\u0006\u001c8n\u001d\u0011\u0002#\u0005\u00148\r[5wKJ$\u0016m]6Rk\u0016,X-F\u0001^!\tic,\u0003\u0002`5\t\t\u0012I]2iSZ,'\u000fV1tWF+X-^3\u0002%\u0005\u00148\r[5wKJ$\u0016m]6Rk\u0016,X\rI\u0001\u000fi\u0016\u001cHOU3n_Z,G+Y:l)\u0005\u0019\u0007CA\u0013e\u0013\t)gE\u0001\u0003V]&$\bF\u0001\u0007h!\tA\u0017/D\u0001j\u0015\tQ7.A\u0002ba&T!\u0001\\7\u0002\u000f),\b/\u001b;fe*\u0011an\\\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002a\u0006\u0019qN]4\n\u0005IL'\u0001\u0002+fgR\fA\u0003^3tiB{G\u000e\u001c+bg.|%\u000fZ3sS:<\u0007FA\u0007h\u0003a!Xm\u001d;Q_2dG+Y:lg2+7o\u001d+iC:l\u0015\r\u001f\u0015\u0003\u001d\u001d\f1\u0002^3tij+'o\u001c'bO\"\u0012qbZ\u0001\u001ci\u0016\u001cH/\u00113e%\u0016\u0004H.Y2fg\u0016C\u0018n\u001d;j]\u001e$\u0016m]6)\u0005A9\u0017!\u0004;fgR,%O]8s)\u0006\u001c8\u000e\u000b\u0002\u0012O\u00061B/Z:u%\u0016lwN^3B]\u0012,%O]8s)\u0006\u001c8\u000e\u000b\u0002\u0013O\u0006)A.Y4G]R\u0019a*a\u0001\t\u000f\u0005\u00151\u00031\u0001\u0002\b\u0005!A/Y:l!\ri\u0013\u0011B\u0005\u0004\u0003\u0017Q\"aC!sG\"Lg/\u001a+bg.\f\u0011\"\u001e9eCR,G*Y4\u0015\u000b\r\f\t\"!\u0006\t\r\u0005MA\u00031\u0001K\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002\u0018Q\u0001\r!U\u0001\u0004Y\u0006<\u0017A\u00067bON{'\u000f^3e\u000b2Lw-\u001b2mKR\u000b7o[:\u0016\u0005\u0005u\u0001#BA\u0010\u0003_Qe\u0002BA\u0011\u0003WqA!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O\u0011\u0013A\u0002\u001fs_>$h(C\u0001(\u0013\r\tiCJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t$a\r\u0003\t1K7\u000f\u001e\u0006\u0004\u0003[1\u0013aB1eIR\u000b7o\u001b\u000b\u0006G\u0006e\u00121\b\u0005\u0007\u0003'1\u0002\u0019\u0001&\t\r\u0005ub\u00031\u0001X\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0002\u0015I,Wn\u001c<f)\u0006\u001c8\u000eF\u0002d\u0003\u0007Ba!a\u0005\u0018\u0001\u0004Q\u0015\u0001\u00034j]\u0012$\u0016m]6\u0015\t\u0005%\u00131\n\t\u0005K=\u000b9\u0001\u0003\u0004\u0002\u0014a\u0001\rA\u0013")
public class ArchiverTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final MockTime time = new MockTime();
    private final Map<TopicIdPartition, Option<Object>> lagMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final int maxTasks;
    private final ArchiverTaskQueue archiverTaskQueue = new ArchiverTaskQueue(this.ctx(), this.maxTasks(), (Time)this.time(), (Function1 & Serializable & scala.Serializable)task -> this.lagFn((ArchiveTask)task), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);

    private CancellationContext ctx() {
        return this.ctx;
    }

    private MockTime time() {
        return this.time;
    }

    private Map<TopicIdPartition, Option<Object>> lagMap() {
        return this.lagMap;
    }

    private int maxTasks() {
        return this.maxTasks;
    }

    private ArchiverTaskQueue archiverTaskQueue() {
        return this.archiverTaskQueue;
    }

    @Test
    public void testRemoveTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        this.removeTask(partition_1);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testRemoveTask$1(partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
        this.removeTask(partition_3);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testRemoveTask$3(partition_2, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPollTaskOrdering() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 5L);
        this.updateLag(partition_2, 10L);
        this.updateLag(partition_3, 1L);
        this.updateLag(partition_4, 15L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        List tasks = (List)this.archiverTaskQueue().poll().get();
        Assertions.assertEquals((Object)this.lagSortedEligibleTasks().take(this.maxTasks()), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topicIdPartition(), List$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testPollTasksLessThanMax() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 5L);
        this.updateLag(partition_2, 0L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_1})), (Object)((TraversableOnce)((List)this.archiverTaskQueue().poll().get()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.topicIdPartition(), List$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testZeroLag() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 0L);
        this.updateLag(partition_2, 0L);
        this.updateLag(partition_3, 0L);
        this.updateLag(partition_4, 0L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.archiverTaskQueue().poll());
    }

    @Test
    public void testAddReplacesExistingTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        this.addTask(partition_1, 1);
        this.addTask(partition_3, 2);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$1(partition_1, partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testErrorTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        ArchiveTask task1 = (ArchiveTask)this.findTask(partition_1).get();
        task1.cancelAndSetErrorState((Throwable)new Exception("test"));
        this.archiverTaskQueue().done((TierTask)task1);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testErrorTask$1(partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)this.archiverTaskQueue().errorPartitionCount());
    }

    @Test
    public void testRemoveAndErrorTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        ArchiveTask task1 = (ArchiveTask)this.findTask(partition_1).get();
        this.removeTask(partition_1);
        task1.cancelAndSetErrorState((Throwable)new Exception("test"));
        this.archiverTaskQueue().done((TierTask)task1);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testRemoveAndErrorTask$1(partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.archiverTaskQueue().errorPartitionCount());
    }

    private Option<Object> lagFn(ArchiveTask task) {
        return (Option)this.lagMap().apply((Object)task.topicIdPartition());
    }

    private void updateLag(TopicIdPartition topicIdPartition, long lag) {
        this.lagMap().update((Object)topicIdPartition, (Object)new Some((Object)BoxesRunTime.boxToLong((long)lag)));
    }

    private List<TopicIdPartition> lagSortedEligibleTasks() {
        return (List)((List)((SeqLike)((TraversableLike)this.lagMap().toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition topicPartition = (TopicIdPartition)x0$1._1();
            Option lag = (Option)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, lag.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return tuple2;
        }, List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$lagSortedEligibleTasks$3(x0$2)))).sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToLong((long)ArchiverTaskQueueTest.$anonfun$lagSortedEligibleTasks$4(x0$3)), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            void var1_1;
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition topicIdPartition = (TopicIdPartition)x0$4._1();
            return var1_1;
        }, List$.MODULE$.canBuildFrom());
    }

    private void addTask(TopicIdPartition topicIdPartition, int leaderEpoch) {
        this.archiverTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(topicIdPartition, leaderEpoch));
    }

    private void removeTask(TopicIdPartition topicIdPartition) {
        this.archiverTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(topicIdPartition));
    }

    private Option<ArchiveTask> findTask(TopicIdPartition topicIdPartition) {
        return (Option)this.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> tasks.find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$findTask$2(topicIdPartition, x$11))));
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$1(TopicIdPartition partition_2$1, TopicIdPartition partition_3$1, TopicIdPartition partition_4$1, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$1, partition_3$1, partition_4$1})), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topicIdPartition(), Set$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$3(TopicIdPartition partition_2$1, TopicIdPartition partition_4$1, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$1, partition_4$1})), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicIdPartition(), Set$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$2(TopicIdPartition partition_1$1, ArchiveTask x$5) {
        TopicIdPartition topicIdPartition = x$5.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_1$1) : partition_1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$3(TopicIdPartition partition_2$2, ArchiveTask x$6) {
        TopicIdPartition topicIdPartition = x$6.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_2$2) : partition_2$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$4(TopicIdPartition partition_3$2, ArchiveTask x$7) {
        TopicIdPartition topicIdPartition = x$7.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_3$2) : partition_3$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$5(TopicIdPartition partition_4$2, ArchiveTask x$8) {
        TopicIdPartition topicIdPartition = x$8.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_4$2) : partition_4$2 != null);
    }

    public static final /* synthetic */ void $anonfun$testAddReplacesExistingTask$1(TopicIdPartition partition_1$1, TopicIdPartition partition_2$2, TopicIdPartition partition_3$2, TopicIdPartition partition_4$2, Set tasks) {
        Assertions.assertEquals((int)1, (int)((ArchiveTask)tasks.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$2(partition_1$1, x$5))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((ArchiveTask)tasks.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$3(partition_2$2, x$6))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)2, (int)((ArchiveTask)tasks.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$4(partition_3$2, x$7))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((ArchiveTask)tasks.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$5(partition_4$2, x$8))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)4, (int)tasks.size());
    }

    public static final /* synthetic */ void $anonfun$testErrorTask$1(TopicIdPartition partition_2$3, TopicIdPartition partition_3$3, TopicIdPartition partition_4$3, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$3, partition_3$3, partition_4$3})), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.topicIdPartition(), Set$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndErrorTask$1(TopicIdPartition partition_2$4, TopicIdPartition partition_3$4, TopicIdPartition partition_4$4, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$4, partition_3$4, partition_4$4})), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.topicIdPartition(), Set$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$lagSortedEligibleTasks$3(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$2._2$mcJ$sp() != 0L;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$lagSortedEligibleTasks$4(Tuple2 x0$3) {
        void var1_1;
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        long lag = x0$3._2$mcJ$sp();
        return (long)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$findTask$2(TopicIdPartition topicIdPartition$1, ArchiveTask x$11) {
        TopicIdPartition topicIdPartition = x$11.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition$1) : topicIdPartition$1 != null);
    }

    public ArchiverTaskQueueTest() {
        this.maxTasks = 3;
    }
}

