/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.MergedLog;
import kafka.log.TierLogSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.delete.DeletionMetrics;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.tasks.delete.DeletionTaskQueue;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Queue;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\f\u0019\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00045\u0001\u0001\u0006IA\f\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019!\u0005\u0001)A\u0005o!9Q\t\u0001b\u0001\n\u00131\u0005B\u0002&\u0001A\u0003%q\tC\u0004L\u0001\t\u0007I\u0011\u0001'\t\rM\u0003\u0001\u0015!\u0003N\u0011\u001d!\u0006A1A\u0005\u0002\u0019Ca!\u0016\u0001!\u0002\u00139\u0005b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u00079\u0002\u0001\u000b\u0011\u0002-\t\u000fu\u0003!\u0019!C\u0005=\"1!\r\u0001Q\u0001\n}CQa\u0019\u0001\u0005\u0002\u0011DQa\u001d\u0001\u0005\u0002\u0011DQ!\u001e\u0001\u0005\u0002\u0011DQa\u001e\u0001\u0005\u0002\u0011DQ!\u001f\u0001\u0005\niDq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002*\u0001!I!a\u000b\u0003+\u0011+G.\u001a;j_:$\u0016m]6Rk\u0016,X\rV3ti*\u0011\u0011DG\u0001\u0007I\u0016dW\r^3\u000b\u0005ma\u0012!\u0002;bg.\u001c(BA\u000f\u001f\u0003\u0011!\u0018.\u001a:\u000b\u0003}\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\r\u0002\u0007\r$\b0F\u0001/!\ty#'D\u00011\u0015\t\tD$A\u0004gKR\u001c\u0007.\u001a:\n\u0005M\u0002$aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018\u0001B2uq\u0002\nA\u0001^5nKV\tq\u0007\u0005\u00029\u00056\t\u0011H\u0003\u0002;w\u0005)Q\u000f^5mg*\u0011A(P\u0001\u0007G>lWn\u001c8\u000b\u0005}q$BA A\u0003\u0019\t\u0007/Y2iK*\t\u0011)A\u0002pe\u001eL!aQ\u001d\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\t[\u0006DH+Y:lgV\tq\t\u0005\u0002$\u0011&\u0011\u0011\n\n\u0002\u0004\u0013:$\u0018!C7bqR\u000b7o[:!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!z\taa]3sm\u0016\u0014\u0018B\u0001*P\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0016M\u0016t7-\u001a3TK\u001elWM\u001c;t\t\u0016d\u0017-_'t\u0003Y1WM\\2fIN+w-\\3oiN$U\r\\1z\u001bN\u0004\u0013a\u0004;jKJ$\u0016m]6t\u0007>tg-[4\u0016\u0003a\u0003\"!\u0017.\u000e\u0003iI!a\u0017\u000e\u0003\u001fQKWM\u001d+bg.\u001c8i\u001c8gS\u001e\f\u0001\u0003^5feR\u000b7o[:D_:4\u0017n\u001a\u0011\u0002#\u0011,G.\u001a;j_:$\u0016m]6Rk\u0016,X-F\u0001`!\tY\u0003-\u0003\u0002b1\t\tB)\u001a7fi&|g\u000eV1tWF+X-^3\u0002%\u0011,G.\u001a;j_:$\u0016m]6Rk\u0016,X\rI\u0001\u0015i\u0016\u001cH\u000fU8mYR\u000b7o[(sI\u0016\u0014\u0018N\\4\u0015\u0003\u0015\u0004\"a\t4\n\u0005\u001d$#\u0001B+oSRD#\u0001E5\u0011\u0005)\fX\"A6\u000b\u00051l\u0017aA1qS*\u0011an\\\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001\b)A\u0003kk:LG/\u0003\u0002sW\n!A+Z:u\u00035!Xm\u001d;T_J$H+Y:lg\"\u0012\u0011#[\u0001\u001fi\u0016\u001cHo\u0015;bi\u0016$&/\u00198tSRLwN\\:XSRDg)\u001a8dK\u0012D#AE5\u0002)Q,7\u000f^*uCR,GK]1og&$\u0018n\u001c8tQ\t\u0019\u0012.A\u0006t_J$X\r\u001a+bg.\u001cX#A>\u0011\u000bq\fI!a\u0004\u000f\u0007u\f)AD\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003\u0001\u0013A\u0002\u001fs_>$h(C\u0001&\u0013\r\t9\u0001J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY!!\u0004\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u000f!\u0003\u0003BA\t\u0003'i\u0011\u0001H\u0005\u0004\u0003+a\"\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003U)\b\u000fZ1uK2\u000b7\u000f\u001e)s_\u000e,7o]3e\u001bN$R!ZA\u000e\u0003?Aq!!\b\u0016\u0001\u0004\ty!\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011\u0011E\u000bA\u0002\u0005\r\u0012a\u00047bgR\u0004&o\\2fgN,G-T:\u0011\u0007\r\n)#C\u0002\u0002(\u0011\u0012A\u0001T8oO\u0006\t\"/\u001a;f]RLwN\\'fi\u0006$\u0017\r^1\u0015\t\u00055\u00121\n\t\u0005\u0003_\t)E\u0004\u0003\u00022\u0005\u0005c\u0002BA\u001a\u0003\u007fqA!!\u000e\u0002>9!\u0011qGA\u001e\u001d\rq\u0018\u0011H\u0005\u0002?%\u0011QDH\u0005\u00037qI!!\u0007\u000e\n\u0007\u0005\r\u0003$\u0001\u0007EK2,G/[8o)\u0006\u001c8.\u0003\u0003\u0002H\u0005%#A\u0006#fY\u0016$X-Q:MK\u0006$WM]'fi\u0006$\u0017\r^1\u000b\u0007\u0005\r\u0003\u0004\u0003\u0004\u0002NY\u0001\raR\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000e")
public class DeletionTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final Time time = new MockTime();
    private final int maxTasks;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final int fencedSegmentsDelayMs;
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(this.maxTasks(), this.maxTasks(), 1, (long)this.fencedSegmentsDelayMs(), 5L, TierTasksConfig$.MODULE$.$lessinit$greater$default$6(), TierTasksConfig$.MODULE$.$lessinit$greater$default$7(), TierTasksConfig$.MODULE$.$lessinit$greater$default$8(), TierTasksConfig$.MODULE$.$lessinit$greater$default$9());
    private final DeletionTaskQueue deletionTaskQueue = new DeletionTaskQueue(this.ctx(), this.maxTasks(), this.time(), this.replicaManager(), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));

    private CancellationContext ctx() {
        return this.ctx;
    }

    private Time time() {
        return this.time;
    }

    private int maxTasks() {
        return this.maxTasks;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public int fencedSegmentsDelayMs() {
        return this.fencedSegmentsDelayMs;
    }

    private TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    private DeletionTaskQueue deletionTaskQueue() {
        return this.deletionTaskQueue;
    }

    @Test
    public void testPollTaskOrdering() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.updateLastProcessedMs(partition_1, 5L);
        this.updateLastProcessedMs(partition_2, 10L);
        this.updateLastProcessedMs(partition_3, 1L);
        this.updateLastProcessedMs(partition_4, 15L);
        List tasks = (List)this.deletionTaskQueue().poll().get();
        Assertions.assertEquals((Object)this.sortedTasks().take(this.maxTasks()), (Object)((List)tasks.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topicIdPartition(), List$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testSortTasks() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TopicIdPartition partition_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        DeletionTask task_1 = new DeletionTask(this.ctx().subContext(), partition_1, (DeletionTask.State)new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)this.retentionMetadata(0)), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        DeletionTask task_2 = new DeletionTask(this.ctx().subContext(), partition_2, (DeletionTask.State)new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)this.retentionMetadata(1)), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        DeletionTask task_3 = new DeletionTask(this.ctx().subContext(), partition_3, (DeletionTask.State)new DeletionTask.Delete((DeletionTask.StateMetadata)this.retentionMetadata(0), Optional.of(new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1)))), (Queue)Mockito.mock(Queue.class)), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        DeletionTask task_4 = new DeletionTask(this.ctx().subContext(), partition_4, (DeletionTask.State)new DeletionTask.CompleteDelete((DeletionTask.StateMetadata)this.retentionMetadata(0), Optional.of(new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1)))), (Queue)Mockito.mock(Queue.class)), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        DeletionTask task_5 = new DeletionTask(this.ctx().subContext(), partition_5, (DeletionTask.State)new DeletionTask.InitiateDelete((DeletionTask.StateMetadata)this.retentionMetadata(0), Optional.of(new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(1)))), (Queue)Mockito.mock(Queue.class), 0L), new DeletionMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        task_1.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() - 100L))));
        task_2.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() - 300L))));
        task_3.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() + 100L))));
        task_4.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() - 200L))));
        task_5.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() + 200L))));
        .colon.colon taskList = new .colon.colon((Object)task_1, (List)new .colon.colon((Object)task_2, (List)new .colon.colon((Object)task_3, (List)new .colon.colon((Object)task_4, (List)new .colon.colon((Object)task_5, (List)Nil$.MODULE$)))));
        List sortedTasks = this.deletionTaskQueue().sortTasks((List)taskList);
        Assertions.assertEquals((int)taskList.size(), (int)sortedTasks.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeletionTask[]{task_3, task_4, task_5})), (Object)sortedTasks.take(3).toSet());
        Assertions.assertEquals((Object)task_2, (Object)sortedTasks.apply(3));
        Assertions.assertEquals((Object)task_1, (Object)sortedTasks.apply(4));
    }

    @Test
    public void testStateTransitionsWithFenced() {
        TierTopicAppender tierTopicAppender = (TierTopicAppender)Mockito.mock(TierTopicAppender.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        TierObjectStore.ObjectMetadata tierObjectMetadata = (TierObjectStore.ObjectMetadata)Mockito.mock(TierObjectStore.ObjectMetadata.class);
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        MergedLog log = (MergedLog)Mockito.mock(MergedLog.class);
        TierLogSegment tieredLogSegment = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        UUID objectId = UUID.randomUUID();
        long fileDeleteDelayMs = 19000L;
        Properties properties = new Properties();
        properties.put(LogConfig$.MODULE$.RetentionMsProp(), "1");
        properties.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Long.toString(fileDeleteDelayMs));
        LogConfig logConfig = new LogConfig((Map)properties, LogConfig$.MODULE$.apply$default$2());
        Mockito.when((Object)tierTopicAppender.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.replicaManager().getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tieredLogSegments()).thenAnswer((Answer)new Answer<Iterator<TierLogSegment>>(null, tieredLogSegment){
            private final TierLogSegment tieredLogSegment$1;

            public Iterator<TierLogSegment> answer(InvocationOnMock invocation) {
                return new .colon.colon((Object)this.tieredLogSegment$1, (List)Nil$.MODULE$).iterator();
            }
            {
                this.tieredLogSegment$1 = tieredLogSegment$1;
            }
        });
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.firstNotDeletableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        Mockito.when((Object)tierPartitionState.topicIdPartition()).thenReturn(Optional.of(topicIdPartition));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment.maxTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.time().hiResClockMs()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tieredLogSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)100));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)50L));
        Mockito.when((Object)tieredLogSegment.metadata()).thenReturn((Object)tierObjectMetadata);
        Mockito.when((Object)tieredLogSegment.objectId()).thenReturn((Object)objectId);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.fencedSegments()).thenReturn(CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TierLogSegment(topicIdPartition, new SegmentState(0, UUID.randomUUID(), 100L, 100L, 3252334L, 1000L, 1000L, 102, TierObjectMetadata.State.SEGMENT_FENCED, true, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 0L)), (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)tierObjectMetadata.topicIdPartition()).thenReturn((Object)topicIdPartition);
        Mockito.when((Object)tierObjectMetadata.objectId()).thenReturn((Object)objectId);
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(topicIdPartition, 0));
        long nowMs = this.time().hiResClockMs();
        DeletionTask task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        Assertions.assertEquals(DeletionTask.CollectDeletableSegments.class, task.state().getClass());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)task.pausedUntil());
        Future future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assertions.assertEquals((Object)new Some((Object)Instant.ofEpochMilli(nowMs + (long)this.fencedSegmentsDelayMs())), (Object)task.pausedUntil());
        this.deletionTaskQueue().done((TierTask)task);
        Assertions.assertTrue((boolean)this.deletionTaskQueue().poll().isEmpty());
        Assertions.assertEquals((int)1, (int)this.deletionTaskQueue().taskCount());
        this.time().sleep((long)(this.fencedSegmentsDelayMs() + 1));
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assertions.assertFalse((boolean)task.pausedUntil().isDefined());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
    }

    @Test
    public void testStateTransitions() {
        TierTopicAppender tierTopicAppender = (TierTopicAppender)Mockito.mock(TierTopicAppender.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        TierObjectStore.ObjectMetadata tierObjectMetadata1 = (TierObjectStore.ObjectMetadata)Mockito.mock(TierObjectStore.ObjectMetadata.class);
        TierObjectStore.ObjectMetadata tierObjectMetadata2 = (TierObjectStore.ObjectMetadata)Mockito.mock(TierObjectStore.ObjectMetadata.class);
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        MergedLog log = (MergedLog)Mockito.mock(MergedLog.class);
        TierLogSegment tieredLogSegment1 = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        TierLogSegment tieredLogSegment2 = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        long fileDeleteDelayMs = 19000L;
        Properties properties = new Properties();
        properties.put(LogConfig$.MODULE$.RetentionMsProp(), "1");
        properties.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Long.toString(fileDeleteDelayMs));
        LogConfig logConfig = new LogConfig((Map)properties, LogConfig$.MODULE$.apply$default$2());
        Mockito.when((Object)tierTopicAppender.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.replicaManager().getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tieredLogSegments()).thenAnswer((Answer)new Answer<Iterator<TierLogSegment>>(null, tieredLogSegment1, tieredLogSegment2){
            private final TierLogSegment tieredLogSegment1$1;
            private final TierLogSegment tieredLogSegment2$1;

            public Iterator<TierLogSegment> answer(InvocationOnMock invocation) {
                return new .colon.colon((Object)this.tieredLogSegment1$1, (List)new .colon.colon((Object)this.tieredLogSegment2$1, (List)Nil$.MODULE$)).iterator();
            }
            {
                this.tieredLogSegment1$1 = tieredLogSegment1$1;
                this.tieredLogSegment2$1 = tieredLogSegment2$1;
            }
        });
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.firstNotDeletableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        Mockito.when((Object)tierPartitionState.topicIdPartition()).thenReturn(Optional.of(topicIdPartition));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment1.maxTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.time().hiResClockMs()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tieredLogSegment1.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)100));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment1.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)50L));
        Mockito.when((Object)tieredLogSegment1.metadata()).thenReturn((Object)tierObjectMetadata1);
        Mockito.when((Object)tieredLogSegment1.objectId()).thenReturn((Object)objectId1);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment2.maxTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.time().hiResClockMs()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tieredLogSegment2.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)100));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment2.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)99L));
        Mockito.when((Object)tieredLogSegment2.metadata()).thenReturn((Object)tierObjectMetadata2);
        Mockito.when((Object)tieredLogSegment2.objectId()).thenReturn((Object)objectId2);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.fencedSegments()).thenReturn(CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Mockito.when((Object)tierObjectMetadata1.topicIdPartition()).thenReturn((Object)topicIdPartition);
        Mockito.when((Object)tierObjectMetadata1.objectId()).thenReturn((Object)objectId1);
        Mockito.when((Object)tierObjectMetadata2.topicIdPartition()).thenReturn((Object)topicIdPartition);
        Mockito.when((Object)tierObjectMetadata2.objectId()).thenReturn((Object)objectId2);
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(topicIdPartition, 0));
        long nowMs = this.time().hiResClockMs();
        DeletionTask task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        Assertions.assertEquals(DeletionTask.CollectDeletableSegments.class, task.state().getClass());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)task.pausedUntil());
        Future future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assertions.assertEquals((Object)new Some((Object)Instant.ofEpochMilli(nowMs + fileDeleteDelayMs)), (Object)task.pausedUntil());
        this.deletionTaskQueue().done((TierTask)task);
        Assertions.assertTrue((boolean)this.deletionTaskQueue().poll().isEmpty());
        Assertions.assertEquals((int)1, (int)this.deletionTaskQueue().taskCount());
        this.time().sleep(fileDeleteDelayMs + 1L);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assertions.assertFalse((boolean)task.pausedUntil().isDefined());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().hiResClockMs();
        task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        future = task.transition(this.time(), tierTopicAppender, tierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assertions.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
    }

    private List<TopicIdPartition> sortedTasks() {
        return (List)this.deletionTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> (List)((List)tasks.toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastProcessedMs(), Ordering$.MODULE$.Option((Ordering)Ordering.Long$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topicIdPartition(), List$.MODULE$.canBuildFrom()));
    }

    private void updateLastProcessedMs(TopicIdPartition topicIdPartition, long lastProcessedMs) {
        this.deletionTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            DeletionTaskQueueTest.$anonfun$updateLastProcessedMs$1(topicIdPartition, lastProcessedMs, tasks);
            return BoxedUnit.UNIT;
        });
    }

    private DeletionTask.DeleteAsLeaderMetadata retentionMetadata(int leaderEpoch) {
        return new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), leaderEpoch);
    }

    public static final /* synthetic */ boolean $anonfun$updateLastProcessedMs$2(TopicIdPartition topicIdPartition$1, DeletionTask x$4) {
        TopicIdPartition topicIdPartition = x$4.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition$1) : topicIdPartition$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateLastProcessedMs$1(TopicIdPartition topicIdPartition$1, long lastProcessedMs$1, Set tasks) {
        ((DeletionTask)tasks.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeletionTaskQueueTest.$anonfun$updateLastProcessedMs$2(topicIdPartition$1, x$4))).get()).lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)lastProcessedMs$1)));
    }

    public DeletionTaskQueueTest() {
        this.maxTasks = 3;
        this.fencedSegmentsDelayMs = 61000;
    }
}

