/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import kafka.api.IntegrationTestHarness;
import kafka.log.MergedLog$;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicConsumerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierRecordType;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.tools.RecoveryTestUtils$;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierPartitionStateFencingTrigger;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001\u0002\u000f\u001e\u0001\u0011BQa\u000b\u0001\u0005\u00021BQa\f\u0001\u0005RABqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004@\u0001\u0001\u0006I!\u000f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u0019Q\u0005\u0001)A\u0005\u0005\"91\n\u0001a\u0001\n\u0013a\u0005b\u0002,\u0001\u0001\u0004%Ia\u0016\u0005\u0007;\u0002\u0001\u000b\u0015B'\t\u000fy\u0003!\u0019!C\u0005?\"1q\u000e\u0001Q\u0001\n\u0001D\u0011\u0002\u001d\u0001A\u0002\u0003\u0007I\u0011B9\t\u0013a\u0004\u0001\u0019!a\u0001\n\u0013I\b\"C>\u0001\u0001\u0004\u0005\t\u0015)\u0003s\u0011%a\b\u00011AA\u0002\u0013%\u0011\u000fC\u0005~\u0001\u0001\u0007\t\u0019!C\u0005}\"Q\u0011\u0011\u0001\u0001A\u0002\u0003\u0005\u000b\u0015\u0002:\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0001\u0002CA\n\u0001\u0001\u0006I!a\u0002\t\u0013\u0005U\u0001A1A\u0005\n\u0005]\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0007\t\u0011\u0005\u0005\u0002A1A\u0005\nABq!a\t\u0001A\u0003%\u0011\u0007C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u00020)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR3oG&tw-\u00138uK\u001e\u0014\u0018\r^5p]R\u0013\u0018nZ4feR+7\u000f\u001e\u0006\u0003=}\tQ\u0001^8pYNT!\u0001I\u0011\u0002\tQLWM\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001&!\t1\u0013&D\u0001(\u0015\tA\u0013%A\u0002ba&L!AK\u0014\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\u000f\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002cA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t\u0019\u0011J\u001c;\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\u0005I\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\"\u0003\u0019\u0019XM\u001d<fe&\u0011ah\u000f\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mA\u00051An\\4ESJ,\u0012A\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bA\u0001\\1oO*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005\u0019\u0019FO]5oO\u00069An\\4ESJ\u0004\u0013a\u0006;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015\u000e\\3t+\u0005i\u0005c\u0001\u001aO!&\u0011qj\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003#Rk\u0011A\u0015\u0006\u0003'~\tQa\u001d;bi\u0016L!!\u0016*\u0003-\u0019KG.\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\f1\u0004^5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001aKG.Z:`I\u0015\fHC\u0001-\\!\t\u0011\u0014,\u0003\u0002[g\t!QK\\5u\u0011\u001da\u0006\"!AA\u00025\u000b1\u0001\u001f\u00132\u0003a!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GS2,7\u000fI\u0001\u0010iBLGm\u001d+p\u0005\u00164UM\\2fIV\t\u0001\r\u0005\u0003bM\"dW\"\u00012\u000b\u0005\r$\u0017!C5n[V$\u0018M\u00197f\u0015\t)7'\u0001\u0006d_2dWm\u0019;j_:L!a\u001a2\u0003\u00075\u000b\u0007\u000f\u0005\u0002jU6\tq$\u0003\u0002l?\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0003e5L!A\\\u001a\u0003\u000f\t{w\u000e\\3b]\u0006\u0001B\u000f]5egR{')\u001a$f]\u000e,G\rI\u0001\u0016i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u001ch)\u001b7f+\u0005\u0011\bCA:w\u001b\u0005!(BA;G\u0003\tIw.\u0003\u0002xi\n!a)\u001b7f\u0003e!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|gn\u001d$jY\u0016|F%Z9\u0015\u0005aS\bb\u0002/\u000e\u0003\u0003\u0005\rA]\u0001\u0017i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u001ch)\u001b7fA\u0005\u0011\u0002O]8qKJ$\u0018.Z:D_:4g)\u001b7f\u0003Y\u0001(o\u001c9feRLWm]\"p]\u001a4\u0015\u000e\\3`I\u0015\fHC\u0001-\u0000\u0011\u001da\u0006#!AA\u0002I\f1\u0003\u001d:pa\u0016\u0014H/[3t\u0007>tgMR5mK\u0002\n\u0001\"\\8dWRKW.Z\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b\t\u0013!B;uS2\u001c\u0018\u0002BA\t\u0003\u0017\u0011\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\nab\u00197fC:,\b\u000fR3mCfl5/\u0006\u0002\u0002\u001aA\u0019!'a\u0007\n\u0007\u0005u1G\u0001\u0003M_:<\u0017aD2mK\u0006tW\u000f\u001d#fY\u0006LXj\u001d\u0011\u0002#\rdW-\u00198va&sG/\u001a:wC2l5/\u0001\ndY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0013AC1eIJ+\u0007\u000f\\5dCRY\u0001,!\u000b\u0002.\u0005u\u0012\u0011IA#\u0011\u0019\tY\u0003\u0007a\u0001Q\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003_A\u0002\u0019AA\u0019\u0003E!\u0018.\u001a:U_BL7mQ8ogVlWM\u001d\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011qG\u0010\u0002\u000bQ|\u0007/[2\n\t\u0005m\u0012Q\u0007\u0002\u0012)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\bBBA 1\u0001\u0007A.A\bdQ\u0016\u001c7n];n\u000b:\f'\r\\3e\u0011\u0019\t\u0019\u0005\u0007a\u0001Y\u0006q1m\\7qC\u000e$XI\\1cY\u0016$\u0007BBA$1\u0001\u0007A.\u0001\bdY\u0016\fg.\u001e9F]\u0006\u0014G.\u001a3\u0002\u000bM,G/\u00169\u0015\u0007a\u000bi\u0005C\u0004\u0002Pe\u0001\r!!\u0015\u0002\u0011Q,7\u000f^%oM>\u0004B!a\u0015\u0002d5\u0011\u0011Q\u000b\u0006\u0004Q\u0005]#\u0002BA-\u00037\nqA[;qSR,'O\u0003\u0003\u0002^\u0005}\u0013!\u00026v]&$(BAA1\u0003\ry'oZ\u0005\u0005\u0003K\n)F\u0001\u0005UKN$\u0018J\u001c4pQ\rI\u0012\u0011\u000e\t\u0005\u0003'\nY'\u0003\u0003\u0002n\u0005U#A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001YQ\rQ\u0012Q\u000f\t\u0005\u0003'\n9(\u0003\u0003\u0002z\u0005U#!C!gi\u0016\u0014X)Y2i\u0003)\"Xm\u001d;QCJ$\u0018\u000e^5p]\u001a+gnY3Fm\u0016tG/\u00138kK\u000e$\u0018n\u001c8B]\u00124UM\\2j]\u001e$\u0012\u0002WA@\u0003\u0003\u000b\u0019)!\"\t\r\u0005}2\u00041\u0001m\u0011\u0019\t\u0019e\u0007a\u0001Y\"1\u0011qI\u000eA\u00021Dq!a\"\u001c\u0001\u0004\tI)\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003\u0017\u000bIJ\u0004\u0003\u0002\u000e\u0006U\u0005cAAHg5\u0011\u0011\u0011\u0013\u0006\u0004\u0003'\u001b\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0018N\na\u0001\u0015:fI\u00164\u0017bA%\u0002\u001c*\u0019\u0011qS\u001a)\u000fm\ty*a,\u00022B!\u0011\u0011UAV\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016\u0001\u00039s_ZLG-\u001a:\u000b\t\u0005%\u0016qK\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u00055\u00161\u0015\u0002\n\u0007N48k\\;sG\u0016\fQA^1mk\u0016d\u0003%a-\u00028\u0006m\u0016qXAb\u0003\u000f\fY-a4\u0002T\u0006]\u00171\\Ap\u0003G\f9/a;\u0002p\u0006\u0012\u0011QW\u0001\u0015M\u0006d7/\u001a\u0017gC2\u001cX\r\f4bYN,GF_6\"\u0005\u0005e\u0016a\u00054bYN,G\u0006\u001e:vK22\u0017\r\\:fYi\\\u0017EAA_\u0003M!(/^3-M\u0006d7/\u001a\u0017gC2\u001cX\r\f>lC\t\t\t-\u0001\nueV,G\u0006\u001e:vK22\u0017\r\\:fYi\\\u0017EAAc\u0003]1\u0017\r\\:fY\u0019\fGn]3-M\u0006d7/\u001a\u0017le\u00064G/\t\u0002\u0002J\u00061b-\u00197tK2\"(/^3-M\u0006d7/\u001a\u0017le\u00064G/\t\u0002\u0002N\u00061BO];fY\u0019\fGn]3-M\u0006d7/\u001a\u0017le\u00064G/\t\u0002\u0002R\u0006)BO];fYQ\u0014X/\u001a\u0017gC2\u001cX\rL6sC\u001a$\u0018EAAk\u0003M1\u0017\r\\:fY\u0019\fGn]3-iJ,X\r\f>lC\t\tI.\u0001\ngC2\u001cX\r\f;sk\u0016dCO];fYi\\\u0017EAAo\u0003I!(/^3-M\u0006d7/\u001a\u0017ueV,GF_6\"\u0005\u0005\u0005\u0018!\u0005;sk\u0016dCO];fYQ\u0014X/\u001a\u0017{W\u0006\u0012\u0011Q]\u0001\u0017M\u0006d7/\u001a\u0017gC2\u001cX\r\f;sk\u0016d3N]1gi\u0006\u0012\u0011\u0011^\u0001\u0016M\u0006d7/\u001a\u0017ueV,G\u0006\u001e:vK2Z'/\u00194uC\t\ti/A\u000bueV,GFZ1mg\u0016dCO];fY-\u0014\u0018M\u001a;\"\u0005\u0005E\u0018\u0001\u0006;sk\u0016dCO];fYQ\u0014X/\u001a\u0017le\u00064G\u000fK\u0002\u001c\u0003k\u0004B!a>\u0002z6\u0011\u0011qU\u0005\u0005\u0003w\f9KA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\u0004")
public class TierPartitionStateFencingIntegrationTriggerTest
extends IntegrationTestHarness {
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final String logDir = TestUtils$.MODULE$.tempDir().getAbsolutePath();
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));
    private final scala.collection.immutable.Map<TopicIdPartition, Object> tpidsToBeFenced = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("the_dark_knight", UUID.randomUUID(), 2)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("mummy_returns", UUID.randomUUID(), 3)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("mission_impossible", UUID.randomUUID(), 5)), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
    private File topicIdPartitionsFile;
    private File propertiesConfFile;
    private final kafka.utils.MockTime mockTime = new kafka.utils.MockTime();
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;

    @Override
    public int brokerCount() {
        return 3;
    }

    private LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    private String logDir() {
        return this.logDir;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    private scala.collection.immutable.Map<TopicIdPartition, Object> tpidsToBeFenced() {
        return this.tpidsToBeFenced;
    }

    private File topicIdPartitionsFile() {
        return this.topicIdPartitionsFile;
    }

    private void topicIdPartitionsFile_$eq(File x$1) {
        this.topicIdPartitionsFile = x$1;
    }

    private File propertiesConfFile() {
        return this.propertiesConfFile;
    }

    private void propertiesConfFile_$eq(File x$1) {
        this.propertiesConfFile = x$1;
    }

    private kafka.utils.MockTime mockTime() {
        return this.mockTime;
    }

    private long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    private int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer, boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled) {
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(MergedLog$.MODULE$.logDirName(topicIdPartition.topicPartition())).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, this.logDirFailureChannel(), topicIdPartition.topicPartition(), true, (Scheduler)this.mockTime().scheduler(), checksumEnabled, compactEnabled, (Time)this.mockTime(), new TierPartitionStateCleanupConfig(cleanupEnabled, this.cleanupDelayMs(), (long)this.cleanupIntervalMs()));
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        tierPartitionState.setTieredPartitionRecoveryWorkflowCb(op -> System.out.println(new StringBuilder(14).append("Received ").append(op.toString()).append(" for ").append(topicIdPartition).toString()));
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).$colon$plus((Object)tierPartitionState, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;

            public String id() {
                return new StringBuilder(48).append("TierPartitionStateFencingIntegrationTriggerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus targetStatus, OffsetAndEpoch sourceOffsetAndEpoch, Optional<ByteBuffer> targetStateOpt) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, targetStateOpt, targetStatus, sourceOffsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.topicIdPartitionsFile_$eq(TestUtils$.MODULE$.tempFile());
        this.tpidsToBeFenced().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            if (x$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition tpid = (TopicIdPartition)x$1._1();
            scala.collection.immutable.Map<Object, Object> map = this.createTopic(tpid.topic(), 10, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
            return map;
        });
        RecoveryTestUtils$.MODULE$.writeFencingFile(this.topicIdPartitionsFile(), this.tpidsToBeFenced());
        this.propertiesConfFile_$eq(TestUtils$.MODULE$.tempFile());
    }

    @Override
    @AfterEach
    public void tearDown() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).foreach((Function1 & Serializable & scala.Serializable)tierPartitionState -> {
            TierPartitionStateFencingIntegrationTriggerTest.$anonfun$tearDown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @CsvSource(value={"false,false,false,zk", "false,true,false,zk", "true,false,false,zk", "true,true,false,zk", "false,false,false,kraft", "false,true,false,kraft", "true,false,false,kraft", "true,true,false,kraft", "false,false,true,zk", "false,true,true,zk", "true,false,true,zk", "true,true,true,zk", "false,false,true,kraft", "false,true,true,kraft", "true,false,true,kraft", "true,true,true,kraft"})
    public void testPartitionFenceEventInjectionAndFencing(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, String quorum) {
        String tierTopicNamespace = "";
        short numTierTopicPartitions = 19;
        int tierTopicReplicationFactor = 3;
        this.createTopic(TierTopic.topicName((String)tierTopicNamespace), numTierTopicPartitions, tierTopicReplicationFactor, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        TierTopic tierTopic = new TierTopic(tierTopicNamespace);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)ArgumentMatchers.eq((Object)tierTopic.topicName()), ArgumentMatchers.eq((int)numTierTopicPartitions), ArgumentMatchers.eq((short)Defaults$.MODULE$.TierMetadataReplicationFactor()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)numTierTopicPartitions));
        tierTopic.initialize(internalAdmin, (int)numTierTopicPartitions, Defaults$.MODULE$.TierMetadataReplicationFactor());
        File workingDir = TestUtils$.MODULE$.tempDir();
        Utils.mkProperties((Map)new HashMap<String, String>(this, workingDir){
            {
                this.put("bootstrap.servers", $outer.bootstrapServers($outer.bootstrapServers$default$1()));
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
            }
        }).store(new PrintWriter(this.propertiesConfFile()), "");
        String tempFileName = "working-file";
        Path tempFilePath = Paths.get(workingDir.getAbsolutePath(), tempFileName);
        Files.createFile(tempFilePath, new FileAttribute[0]);
        File tempFile = new File(tempFilePath.toFile().getAbsolutePath());
        Assertions.assertTrue((tempFile.exists() && tempFile.isFile() ? 1 : 0) != 0);
        File outputDir = TestUtils$.MODULE$.tempDir();
        String fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        TierPartitionStateFencingTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), this.topicIdPartitionsFile().getPath(), RecoveryUtils.makeArgument((String)"output.json"), fenceOutFile})));
        Assertions.assertTrue((!tempFile.exists() ? 1 : 0) != 0);
        Buffer fenceEvents = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]))).asScala();
        Assertions.assertEquals((int)this.tpidsToBeFenced().size(), (int)fenceEvents.size());
        scala.collection.mutable.Map partitionToFenceEventInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        fenceEvents.foreach((Function1 & Serializable & scala.Serializable)output -> {
            TopicIdPartition outputTpid = new TopicIdPartition(output.topic, CoreUtils$.MODULE$.uuidFromBase64(output.topicIdBase64), output.partition);
            Assertions.assertTrue((boolean)this.tpidsToBeFenced().contains((Object)outputTpid));
            Assertions.assertTrue((BoxesRunTime.equals((Object)this.tpidsToBeFenced().apply((Object)outputTpid), (Object)output.freezeMergedLogStartOffset) ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordOffset >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordTimestamp >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordPartition >= 0 ? 1 : 0) != 0);
            CoreUtils$.MODULE$.uuidFromBase64(output.recordMessageIdBase64);
            return (scala.collection.mutable.Map)partitionToFenceEventInfoMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)output.partition)), output));
        });
        TierTopicManagerConfig config = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1())), tierTopicNamespace, numTierTopicPartitions, Defaults$.MODULE$.TierMetadataReplicationFactor(), -1, "unknown", Predef$.MODULE$.long2Long(Defaults$.MODULE$.TierMetadataMaxPollMs()), Predef$.MODULE$.int2Integer(Defaults$.MODULE$.TierMetadataRequestTimeoutMs()), Defaults$.MODULE$.TierPartitionStateCommitInterval(), Collections.singletonList(this.logDir()));
        TierTopicConsumerSupplier primaryConsumerSupplier = new TierTopicConsumerSupplier(config, "primary");
        Consumer verificationConsumer = primaryConsumerSupplier.get();
        Set tierTopicPartitions = TierTopicManager.partitions((String)tierTopic.topicName(), (int)tierTopic.numPartitions().getAsInt());
        verificationConsumer.assign((Collection)tierTopicPartitions);
        tierTopicPartitions.forEach(tp -> verificationConsumer.seekToBeginning(Collections.singletonList(tp)));
        ListBuffer records = new ListBuffer();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$4(this, verificationConsumer, config, records)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.mutable.Set allFencedTpids = ((SetLike)Set$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)this.tpidsToBeFenced().keySet());
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()), (long)record.timestamp());
            Assertions.assertTrue((boolean)eventOpt.isPresent());
            Assertions.assertEquals((Object)TierRecordType.PartitionFence, (Object)((AbstractTierMetadata)eventOpt.get()).type());
            TierPartitionFence fenceEvent = (TierPartitionFence)eventOpt.get();
            Assertions.assertTrue((boolean)allFencedTpids.contains((Object)fenceEvent.topicIdPartition()));
            Assertions.assertTrue((fenceEvent.freezeLogStartOffset() == BoxesRunTime.unboxToBoolean((Object)this.tpidsToBeFenced().apply((Object)fenceEvent.topicIdPartition())) ? 1 : 0) != 0);
            allFencedTpids.remove((Object)fenceEvent.topicIdPartition());
            int userPartition = fenceEvent.topicIdPartition().partition();
            Assertions.assertTrue((boolean)partitionToFenceEventInfoMap.contains((Object)BoxesRunTime.boxToInteger((int)userPartition)));
            FenceEventInfo fenceEventInfo = (FenceEventInfo)partitionToFenceEventInfoMap.apply((Object)BoxesRunTime.boxToInteger((int)userPartition));
            Assertions.assertEquals((Object)fenceEvent.messageId(), (Object)CoreUtils$.MODULE$.uuidFromBase64(fenceEventInfo.recordMessageIdBase64));
            Assertions.assertEquals((long)record.offset(), (long)fenceEventInfo.recordOffset);
            return (scala.collection.mutable.Map)partitionToFenceEventInfoMap.$minus$eq((Object)BoxesRunTime.boxToInteger((int)userPartition));
        });
        Assertions.assertTrue((boolean)allFencedTpids.isEmpty());
        verificationConsumer.close();
        TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(config, (Supplier)primaryConsumerSupplier, (Supplier)new TierTopicConsumerSupplier(config, "catchup"), new TierTopicManagerCommitter(config, this.logDirFailureChannel()), tierStateFetcher, Optional.empty(), (Time)new MockTime());
        this.tpidsToBeFenced().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$7(this, tierTopicConsumer, checksumEnabled, compactEnabled, cleanupEnabled, x0$1);
            return BoxedUnit.UNIT;
        });
        tierTopicConsumer.initialize((InitializedTierTopic)tierTopic);
        tierTopicConsumer.start();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$8(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        tierTopicConsumer.shutdown();
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(FileTierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$4(TierPartitionStateFencingIntegrationTriggerTest $this, Consumer verificationConsumer$1, TierTopicManagerConfig config$1, ListBuffer records$1) {
        Iterator batchIterator = verificationConsumer$1.poll(config$1.pollDuration).iterator();
        while (batchIterator.hasNext()) {
            records$1.$plus$eq(batchIterator.next());
        }
        return records$1.size() == $this.tpidsToBeFenced().size();
    }

    public static final /* synthetic */ String $anonfun$testPartitionFenceEventInjectionAndFencing$5() {
        return "Timed out trying to fetch TierTopic records";
    }

    public static final /* synthetic */ void $anonfun$testPartitionFenceEventInjectionAndFencing$7(TierPartitionStateFencingIntegrationTriggerTest $this, TierTopicConsumer tierTopicConsumer$1, boolean checksumEnabled$1, boolean compactEnabled$1, boolean cleanupEnabled$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition tpid = (TopicIdPartition)x0$1._1();
            $this.addReplica(tpid, tierTopicConsumer$1, checksumEnabled$1, compactEnabled$1, cleanupEnabled$1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$9(TierPartitionStateFencingIntegrationTriggerTest $this, FileTierPartitionState state) {
        if (BoxesRunTime.unboxToBoolean((Object)$this.tpidsToBeFenced().apply(state.topicIdPartition().get()))) {
            TierPartitionStatus tierPartitionStatus = state.status();
            TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
            return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
        }
        TierPartitionStatus tierPartitionStatus = state.status();
        TierPartitionStatus tierPartitionStatus3 = TierPartitionStatus.ERROR;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus3) : tierPartitionStatus3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$8(TierPartitionStateFencingIntegrationTriggerTest $this) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.tierPartitionStateFiles())).forall((Function1 & Serializable & scala.Serializable)state -> BoxesRunTime.boxToBoolean((boolean)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$9($this, state)));
    }

    public static final /* synthetic */ String $anonfun$testPartitionFenceEventInjectionAndFencing$10() {
        return "Timed out waiting for fencing";
    }

    public TierPartitionStateFencingIntegrationTriggerTest() {
        this.cleanupIntervalMs = 0;
    }
}

