/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001\u0002 @\u0001\u0019CQ!\u0014\u0001\u0005\u00029+A!\u0015\u0001\u0001%\u0016!a\f\u0001\u0001`\u0011\u001d\u0011\u0007A1A\u0005\n\rDa\u0001\u001c\u0001!\u0002\u0013!\u0007bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007k\u0002\u0001\u000b\u0011B8\t\u000fY\u0004!\u0019!C\u0005G\"1q\u000f\u0001Q\u0001\n\u0011Dq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002>\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0001\u0002CA\n\u0001\u0001\u0006I!a\u0002\t\u0013\u0005U\u0001A1A\u0005\n\u0005]\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0007\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0002\u0002CA\u0016\u0001\u0001\u0006I!!\n\t\u0011\u00055\u0002A1A\u0005\n\rDq!a\f\u0001A\u0003%A\rC\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024!A\u0011\u0011\u000b\u0001!\u0002\u0013\t)\u0004C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V!9\u0011q\u000b\u0001!\u0002\u0013y\u0006\"CA-\u0001\t\u0007I\u0011BA.\u0011\u001d\ti\u0006\u0001Q\u0001\nIC\u0011\"a\u0018\u0001\u0005\u0004%I!a\u0017\t\u000f\u0005\u0005\u0004\u0001)A\u0005%\"I\u00111\r\u0001C\u0002\u0013%\u0011Q\r\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002h!I\u0011Q\u000f\u0001A\u0002\u0013%\u0011q\u000f\u0005\n\u0003\u000f\u0003\u0001\u0019!C\u0005\u0003\u0013C\u0001\"!&\u0001A\u0003&\u0011\u0011\u0010\u0005\n\u0003/\u0003!\u0019!C\u0005\u00033C\u0001\"a*\u0001A\u0003%\u00111\u0014\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003WC\u0001\"a-\u0001A\u0003%\u0011Q\u0016\u0005\n\u0003k\u0003!\u0019!C\u0005\u0003oC\u0001\"a0\u0001A\u0003%\u0011\u0011\u0018\u0005\b\u0003\u0003\u0004A\u0011AAb\u0011\u001d\tY\r\u0001C\u0001\u0003\u0007Dq!!4\u0001\t\u0003\t\u0019\rC\u0004\u0002P\u0002!\t!!5\t\u000f\u0005%\b\u0001\"\u0001\u0002R\"9\u00111\u001f\u0001\u0005\u0002\u0005E\u0007bBA|\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003w\u0004A\u0011AAi\u0011\u001d\ty\u0010\u0001C\u0001\u0003#DqAa\u0001\u0001\t\u0003\t\t\u000eC\u0004\u0003\b\u0001!\t!!5\t\u000f\t-\u0001\u0001\"\u0001\u0002R\"9!q\u0002\u0001\u0005\u0002\u0005E\u0007b\u0002B\n\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u0005/\u0001A\u0011AAi\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0003#DqAa\b\u0001\t\u0003\t\t\u000eC\u0004\u0003$\u0001!IA!\n\t\u000f\tu\u0002\u0001\"\u0003\u0003@!I!\u0011\f\u0001\u0012\u0002\u0013%!1\f\u0005\b\u0005c\u0002A\u0011BAi\u0011\u001d\u0011\u0019\b\u0001C\u0005\u0003#DqA!\u001e\u0001\t\u0013\u00119H\u0001\u000bUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0001\u0006\u000bQ\u0001^8qS\u000eT!AQ\"\u0002\tQLWM\u001d\u0006\u0002\t\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001H!\tA5*D\u0001J\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0014\t\u0003!\u0002i\u0011a\u0010\u0002\u0011\u0007>t7/^7feN+\b\u000f\u001d7jKJ\u0004Ba\u0015,Y16\tAK\u0003\u0002V\u0003\u000611\r\\5f]RL!a\u0016+\u0003)5{7m[\"p]N,X.\u001a:TkB\u0004H.[3s!\rA\u0015lW\u0005\u00035&\u0013Q!\u0011:sCf\u0004\"\u0001\u0013/\n\u0005uK%\u0001\u0002\"zi\u0016\u0014\u0001\u0003\u0015:pIV\u001cWM]*vaBd\u0017.\u001a:\u0011\tM\u0003\u0007\fW\u0005\u0003CR\u0013A#T8dWB\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\u0018!C2mkN$XM]%e+\u0005!\u0007CA3k\u001b\u00051'BA4i\u0003\u0011a\u0017M\\4\u000b\u0003%\fAA[1wC&\u00111N\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015\rdWo\u001d;fe&#\u0007%A\u0004uK6\u0004H)\u001b:\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A\u001d5\u0002\u0005%|\u0017B\u0001;r\u0005\u00111\u0015\u000e\\3\u0002\u0011Q,W\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\bY><G)\u001b:t+\u0005Q\bcA>\u007fI6\tAP\u0003\u0002~Q\u0006!Q\u000f^5m\u0013\tyHPA\u0005BeJ\f\u0017\u0010T5ti\u0006AAn\\4ESJ\u001c\b%\u0001\tuS\u0016\u00148\u000b^1uK\u001a+Go\u00195feV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB!\u0002\u000f\u0019,Go\u00195fe&!\u0011\u0011CA\u0006\u0005A!\u0016.\u001a:Ti\u0006$XMR3uG\",'/A\tuS\u0016\u00148\u000b^1uK\u001a+Go\u00195fe\u0002\na\u0003^5feR{\u0007/[2Ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u00033\u00012\u0001SA\u000e\u0013\r\ti\"\u0013\u0002\u0006'\"|'\u000f^\u0001\u0018i&,'\u000fV8qS\u000etU/\u001c)beRLG/[8og\u0002\na\u0003^5feR{\u0007/[2NC:\fw-\u001a:D_:4\u0017nZ\u000b\u0003\u0003K\u00012\u0001UA\u0014\u0013\r\tIc\u0010\u0002\u0017)&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cuN\u001c4jO\u00069B/[3s)>\u0004\u0018nY'b]\u0006<WM]\"p]\u001aLw\rI\u0001\u000ei&,'\u000fV8qS\u000et\u0015-\\3\u0002\u001dQLWM\u001d+pa&\u001cg*Y7fA\u0005\u0019B/[3s)>\u0004\u0018n\u0019)beRLG/[8ogV\u0011\u0011Q\u0007\t\u0006w\u0006]\u00121H\u0005\u0004\u0003sa(aA*fiB!\u0011QHA'\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013AB2p[6|gNC\u0002E\u0003\u000bRA!a\u0012\u0002J\u00051\u0011\r]1dQ\u0016T!!a\u0013\u0002\u0007=\u0014x-\u0003\u0003\u0002P\u0005}\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0015i&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002!A\u0014x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014X#A0\u0002#A\u0014x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\b%A\fqe&l\u0017M]=D_:\u001cX/\\3s'V\u0004\b\u000f\\5feV\t!+\u0001\rqe&l\u0017M]=D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0002\nqcY1uG\",\boQ8ogVlWM]*vaBd\u0017.\u001a:\u00021\r\fGo\u00195va\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b%A\u0007j]R,'O\\1m\u0003\u0012l\u0017N\\\u000b\u0003\u0003O\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[\u001a\u0015AB:feZ,'/\u0003\u0003\u0002r\u0005-$!D%oi\u0016\u0014h.\u00197BI6Lg.\u0001\bj]R,'O\\1m\u0003\u0012l\u0017N\u001c\u0011\u0002/QLWM\u001d)beRLG/[8o'R\fG/\u001a$jY\u0016\u001cXCAA=!\u0011A\u0015,a\u001f\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!B\u0003\u0015\u0019H/\u0019;f\u0013\u0011\t))a \u0003-\u0019KG.\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\f1\u0004^5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001aKG.Z:`I\u0015\fH\u0003BAF\u0003#\u00032\u0001SAG\u0013\r\ty)\u0013\u0002\u0005+:LG\u000fC\u0005\u0002\u0014~\t\t\u00111\u0001\u0002z\u0005\u0019\u0001\u0010J\u0019\u00021QLWM\u001d)beRLG/[8o'R\fG/\u001a$jY\u0016\u001c\b%\u0001\u0003uS6,WCAAN!\u0011\ti*a)\u000e\u0005\u0005}%bAAQ\u0007\u0006)Q\u000f^5mg&!\u0011QUAP\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013AD2mK\u0006tW\u000f\u001d#fY\u0006LXj]\u000b\u0003\u0003[\u00032\u0001SAX\u0013\r\t\t,\u0013\u0002\u0005\u0019>tw-A\bdY\u0016\fg.\u001e9EK2\f\u00170T:!\u0003E\u0019G.Z1okBLe\u000e^3sm\u0006dWj]\u000b\u0003\u0003s\u00032\u0001SA^\u0013\r\ti,\u0013\u0002\u0004\u0013:$\u0018AE2mK\u0006tW\u000f]%oi\u0016\u0014h/\u00197Ng\u0002\nqb\u00195fG.\u001cX/\\#oC\ndW\rZ\u000b\u0003\u0003\u000b\u00042\u0001SAd\u0013\r\tI-\u0013\u0002\b\u0005>|G.Z1o\u00039\u0019w.\u001c9bGR,e.\u00192mK\u0012\fab\u00197fC:,\b/\u00128bE2,G-\u0001\u0005uK\u0006\u0014Hm\\<o)\t\tY\tK\u0002+\u0003+\u0004B!a6\u0002f6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.A\u0002ba&TA!a8\u0002b\u00069!.\u001e9ji\u0016\u0014(\u0002BAr\u0003\u0013\nQA[;oSRLA!a:\u0002Z\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001bi\u0016\u001cH/\u00113e\u001b\u0016$\u0018\rZ1uC\n+gm\u001c:f%\u0016\fG-\u001f\u0015\u0004W\u00055\b\u0003BAl\u0003_LA!!=\u0002Z\n!A+Z:u\u0003}!Xm\u001d;EkBd\u0017nY1uKJ+\u0017/^3ti\n+gm\u001c:f%\u0016\fG-\u001f\u0015\u0004Y\u00055\u0018A\f;fgR\u0014V\r\u001e:z\u001f:,fn\u001b8po:,\u0005pY3qi&|g\u000eR;sS:<Gk\u001c9jG\u000e\u0013X-\u0019;j_:D3!LAw\u0003\r\"Xm\u001d;QCJ$\u0018\u000e^5p]\u0016\u00148+\u001a;va^CWM\u001c+pa&\u001cW\t_5tiND3ALAw\u0003M!Xm\u001d;SKR\u0014\u0018.\u001a3NKN\u001c\u0018mZ3tQ\ry\u0013Q^\u0001;i\u0016\u001cHOR3oG&twMV5b!\u0006\u0014H/\u001b;j_:4UM\\2f\u000bZ,g\u000e^(o\u000b6\u0004H/\u001f+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016D3\u0001MAw\u0003u\"Xm\u001d;GK:\u001c\u0017N\\4WS\u0006\u0004\u0016M\u001d;ji&|gNR3oG\u0016,e/\u001a8u\u001f:tuN\\#naRLH+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fQ\r\t\u0014Q^\u00017i\u0016\u001cHOR;ukJ,W*Z:tC\u001e,g)\u001a8dK\u0012\fe\r^3s!\u0006\u0014H/\u001b;j_:$U\r\\3uKB\u0013X-\u00138ji&\fG/\u001a\u0015\u0004e\u00055\u0018a\t;fgR\u001cV\r^#se>\u0014\b+\u0019:uSRLwN\\:EkJLgn\u001a$f]\u000eLgn\u001a\u0015\u0004g\u00055\u0018a\b;fgR\u0014VmY8wKJ<\u0006.\u001b7f\u0007\u0006$8\r[;q\u0007>t7/^7fe\"\u001aA'!<\u0002MQ,7\u000f\u001e%b]\u0012d\u0017N\\4G_J\u0014Vm\u001d;pe\u0016|eNT8o\u000bJ\u0014xN]*uCR,8\u000fK\u00026\u0003[\fA\u0007^3tiB\u0013xnY3tg6+7o]1hKN\u0004vn\u001d;Ti\u0006$XMR3oG&tw\rR;sS:<wJ\u001c7j]\u0016\u001cF/\u0019;fQ\r1\u0014Q^\u0001Ki\u0016\u001cH\u000f\u0016:b]NLG/[8o\rJ|WnQ1uG\",\boQ8ogVlWM\u001d+p!JLW.\u0019:z\u0007>t7/^7fe&sWI\u001d:peN#\u0018\r^3UQ\u0016t'+Z2pm\u0016\u0014\u0018\u0010K\u00028\u0003[\f!\"\u00193e%\u0016\u0004H.[2b)\u0019\tYIa\n\u00034!9!\u0011\u0006\u001dA\u0002\t-\u0012\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o!\u0011\u0011iCa\f\u000e\u0003\u0005K1A!\rB\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u00036a\u0002\rAa\u000e\u0002#QLWM\u001d+pa&\u001c7i\u001c8tk6,'\u000fE\u0002Q\u0005sI1Aa\u000f@\u0005E!\u0016.\u001a:U_BL7mQ8ogVlWM]\u0001\u0014g\u0016$X\u000f\u001d+jKJ\u001cu.\u001c9p]\u0016tGo\u001d\u000b\u0007\u0005\u0003\u0012\u0019F!\u0016\u0011\u0013!\u0013\u0019Ea\u000e\u0003H\t5\u0013b\u0001B#\u0013\n1A+\u001e9mKN\u0002BA!\f\u0003J%\u0019!1J!\u0003%QKWM\u001d*fa2L7-Y'b]\u0006<WM\u001d\t\u0004!\n=\u0013b\u0001B)\u007f\t\u0001B+[3s)>\u0004\u0018nY'b]\u0006<WM\u001d\u0005\n\u0003CI\u0004\u0013!a\u0001\u0003KAqAa\u0016:\u0001\u0004\t)-A\u0006cK\u000e|W.\u001a*fC\u0012L\u0018!H:fiV\u0004H+[3s\u0007>l\u0007o\u001c8f]R\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tu#\u0006BA\u0013\u0005?Z#A!\u0019\u0011\t\t\r$QN\u0007\u0003\u0005KRAAa\u001a\u0003j\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005WJ\u0015AC1o]>$\u0018\r^5p]&!!q\u000eB3\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001a[>4XMU3d_J$7\u000fV8BY2\u001cuN\\:v[\u0016\u00148/\u0001\u000fsKN,g\u000e\u001a)sKZLw.^:Qe>$WoY3SKF,Xm\u001d;\u0002\u001d\t,7m\\7f\u0003J\u001c\u0007.\u001b<feRQ\u00111\u0012B=\u0005w\u0012yHa!\t\u000f\t%R\b1\u0001\u0003,!9!QP\u001fA\u0002\u0005e\u0016a\u00037fC\u0012,'/\u00129pG\"DqA!!>\u0001\u0004\u0011i%\u0001\tuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\"9!QG\u001fA\u0002\t]\u0002")
public class TierTopicManagerTest {
    private final String clusterId;
    private final File tempDir = TestUtils$.MODULE$.tempDir();
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private final short tierTopicNumPartitions = (short)7;
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private final String tierTopicName = TierTopic.topicName((String)"");
    private final Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.tierTopicName(), (int)this.tierTopicNumPartitions());
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));
    private final kafka.utils.MockTime time = new kafka.utils.MockTime();
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    private InternalAdmin internalAdmin() {
        return this.internalAdmin;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    private kafka.utils.MockTime time() {
        return this.time;
    }

    private long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    private int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean compactEnabled() {
        return false;
    }

    public boolean cleanupEnabled() {
        return false;
    }

    @AfterEach
    public void teardown() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).foreach((Function1 & Serializable & scala.Serializable)tierPartitionState -> {
            TierTopicManagerTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        Mockito.framework().clearInlineMocks();
        Utils.delete((File)new File(this.logDir()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddMetadataBeforeReady() {
        void var6_6;
        void var5_5;
        int epoch = 0;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var5_5;
        void tierTopicManager2 = var6_6;
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo_1", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_1 = new TierTopicInitLeader(topicIdPartition_1, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_1.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_1), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        tierTopicConsumer2.register(topicIdPartition_1, clientCtx_1);
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.immigratingPartitions().size());
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("foo_2", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_2 = new TierTopicInitLeader(topicIdPartition_2, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_2.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_2), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        tierTopicConsumer2.register(topicIdPartition_2, clientCtx_2);
        Assertions.assertEquals((int)2, (int)tierTopicConsumer2.immigratingPartitions().size());
        CompletableFuture future_1 = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader_1);
        CompletableFuture future_2 = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader_2);
        Assertions.assertTrue((boolean)tierTopicManager2.tryBecomeReady(false));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testAddMetadataBeforeReady$1(this, (TierTopicConsumer)tierTopicConsumer2, future_1, future_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testAddMetadataBeforeReady$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_1.get());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_2.get());
        Assertions.assertEquals((int)2, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDuplicateRequestBeforeReady() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int epoch = 0;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        UUID objectId = UUID.randomUUID();
        TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, epoch, objectId, 0);
        CompletableFuture oldInitLeaderResult = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader);
        CompletableFuture newInitLeaderResult = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (TierPartitionState.AppendResult)oldInitLeaderResult.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TierTopicManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154))).getCause() instanceof TierMetadataFatalException));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        Assertions.assertTrue((boolean)tierTopicManager2.tryBecomeReady(false));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testDuplicateRequestBeforeReady$2(this, (TierTopicConsumer)tierTopicConsumer2, newInitLeaderResult)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testDuplicateRequestBeforeReady$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, newInitLeaderResult.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryOnUnknownExceptionDuringTopicCreation() {
        void var5_5;
        void var4_4;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var4_4;
        void tierTopicManager2 = var5_5;
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new TimeoutException("timeout when creating topic")}).thenThrow(new Throwable[]{new AdminOperationException("admin operation exception")}).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)1))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)2))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertTrue((boolean)tierTopicManager2.isReady());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)3))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        Assertions.assertEquals((int)this.tierTopicNumPartitions(), (int)tierTopicConsumer2.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionerSetupWhenTopicExists() {
        void var6_6;
        void var5_5;
        int existingPartitions = this.tierTopicNumPartitions() - 2;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var5_5;
        void tierTopicManager2 = var6_6;
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)existingPartitions));
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertTrue((boolean)tierTopicManager2.isReady());
        Assertions.assertEquals((int)existingPartitions, (int)tierTopicConsumer2.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetriedMessages() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture initiateResult = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, initiateResult.get());
        this.resendPreviousProduceRequest();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
        CompletableFuture completeResult = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
        tierTopicConsumer2.doWork();
        Assertions.assertFalse((boolean)completeResult.isDone(), (String)"Upload complete result should not have been completed by materialization of UploadInitiate");
        Assertions.assertEquals((long)1L, (long)tierTopicConsumer2.numListeners());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnEmptyTierPartitionState() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        CompletableFuture partitionFenceFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)partitionFence);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(this, (TierTopicConsumer)tierTopicConsumer2, partitionFenceFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnNonEmptyTierPartitionState() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        int leaderEpoch = 31;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var7_7;
        void tierTopicManager2 = var8_8;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((int)leaderEpoch, (int)this.tierPartitionStateFiles()[0].tierEpoch());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInitiate));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadCompleteFuture.get());
        Assertions.assertEquals((Object)uploadInitiate.objectId(), (Object)((TierLogSegment)this.tierPartitionStateFiles()[0].metadata(100L).get()).objectId());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture partitionFenceFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)partitionFence);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)partitionFenceFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFutureMessageFencedAfterPartitionDeletePreInitiate() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 31;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((int)leaderEpoch, (int)this.tierPartitionStateFiles()[0].tierEpoch());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        TierPartitionDeletePreInitiate partitionDeletePreInitiate = new TierPartitionDeletePreInitiate(topicIdPartition, UUID.randomUUID());
        CompletableFuture partitionDeletePreInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)partitionDeletePreInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)partitionDeletePreInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, partitionDeletePreInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        TierSegmentUploadInitiate newUploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 101L, 200L, 200L, 200L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture newUploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)newUploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)newUploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, newUploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInitiate));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, uploadCompleteFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID());
        CompletableFuture deleteInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)deleteInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)deleteInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, deleteInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSetErrorPartitionsDuringFencing() {
        void var6_6;
        void var5_5;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var5_5;
        void tierTopicManager2 = var6_6;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture initiateResultFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testSetErrorPartitionsDuringFencing$1(this, (TierTopicConsumer)tierTopicConsumer2, initiateResultFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testSetErrorPartitionsDuringFencing$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, initiateResultFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverWhileCatchupConsumer() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        state.flush();
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, state.lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, state.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        TierObjectStore.TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenThrow(new Throwable[]{new IOException("couldn't fetch")}).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.catchUpConsumerPartitions().size());
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testRecoverWhileCatchupConsumer$1(this, (TierTopicConsumer)tierTopicConsumer2, uploadCompleteFuture, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testRecoverWhileCatchupConsumer$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)2))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlingForRestoreOnNonErrorStatus() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
        state.flush();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
        ByteBuffer restoreBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)restoreBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testHandlingForRestoreOnNonErrorStatus$1(this, (TierTopicConsumer)tierTopicConsumer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testHandlingForRestoreOnNonErrorStatus$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProcessMessagesPostStateFencingDuringOnlineState() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadCompleteFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        state.flush();
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        TierObjectStore.TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(this, (TierTopicConsumer)tierTopicConsumer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testProcessMessagesPostStateFencingDuringOnlineState$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)1))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.tierTopicNumPartitions()));
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        state.flush();
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, state.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(this, (TierTopicConsumer)tierTopicConsumer2, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerPartitions().size());
        CompletableFuture becomeArchiverFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, becomeArchiverFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(this, (TierTopicConsumer)tierTopicConsumer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer) {
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(MergedLog$.MODULE$.logDirName(topicIdPartition.topicPartition())).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, new LogDirFailureChannel(5), topicIdPartition.topicPartition(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), new TierPartitionStateCleanupConfig(this.cleanupEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs()));
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).$colon$plus((Object)tierPartitionState, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;

            public String id() {
                return new StringBuilder(21).append("TierTopicManagerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus status, OffsetAndEpoch offsetAndEpoch, Optional<ByteBuffer> buffer) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, buffer, status, offsetAndEpoch);
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    private Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> setupTierComponents(TierTopicManagerConfig tierTopicManagerConfig, boolean becomeReady) {
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(tierTopicManagerConfig, this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), new TierTopicManagerCommitter(tierTopicManagerConfig, new LogDirFailureChannel(1)), this.tierStateFetcher(), Optional.empty(), (Time)new MockTime());
        TierReplicaManager tierReplicaManager = new TierReplicaManager();
        TierTopicManager tierTopicManager = new TierTopicManager(tierTopicManagerConfig, tierTopicConsumer, this.producerSupplier(), () -> this.internalAdmin());
        if (becomeReady) {
            Assertions.assertTrue((boolean)tierTopicManager.tryBecomeReady(false));
        }
        return new Tuple3((Object)tierTopicConsumer, (Object)tierReplicaManager, (Object)tierTopicManager);
    }

    private TierTopicManagerConfig setupTierComponents$default$1() {
        return this.tierTopicManagerConfig();
    }

    private void moveRecordsToAllConsumers() {
        this.primaryConsumerSupplier().moveRecordsFromProducer();
        this.catchupConsumerSupplier().moveRecordsFromProducer();
    }

    private void resendPreviousProduceRequest() {
        MockProducer<byte[], byte[]> mockProducer = this.producerSupplier().producer();
        ProducerRecord lastSentRecord = (ProducerRecord)mockProducer.history().get(mockProducer.history().size() - 1);
        this.producerSupplier().producer().send(lastSentRecord);
        this.moveRecordsToAllConsumers();
    }

    /*
     * WARNING - void declaration
     */
    private void becomeArchiver(TopicIdPartition topicIdPartition, int leaderEpoch, TierTopicManager tierTopicManager, TierTopicConsumer tierTopicConsumer) {
        CompletableFuture becomeArchiverFuture = tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$becomeArchiver$1(this, tierTopicConsumer, becomeArchiverFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$becomeArchiver$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFuture.get());
    }

    public static final /* synthetic */ void $anonfun$teardown$1(FileTierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public static final /* synthetic */ boolean $anonfun$testAddMetadataBeforeReady$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$1, CompletableFuture future_1$1, CompletableFuture future_2$1) {
        $this.primaryConsumerSupplier().moveRecordsFromProducer();
        tierTopicConsumer$1.doWork();
        return future_1$1.isDone() && future_2$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testAddMetadataBeforeReady$2() {
        return "Timed out waiting for futures to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testDuplicateRequestBeforeReady$2(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$2, CompletableFuture newInitLeaderResult$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$2.doWork();
        return newInitLeaderResult$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testDuplicateRequestBeforeReady$3() {
        return "Timed out waiting to become archiver";
    }

    public static final /* synthetic */ boolean $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$3, CompletableFuture partitionFenceFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$3.doWork();
        return partitionFenceFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$2() {
        return "Timed out trying to finish TierPartitionFence";
    }

    public static final /* synthetic */ boolean $anonfun$testSetErrorPartitionsDuringFencing$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$4, CompletableFuture initiateResultFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$4.doWork();
        return initiateResultFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testSetErrorPartitionsDuringFencing$2() {
        return "Timed out trying to finish TierSegmentUploadInitiate";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoverWhileCatchupConsumer$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$5, CompletableFuture uploadCompleteFuture$1, CompletableFuture uploadInitiateFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$5.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
            if (uploadCompleteFuture$1.isDone() && uploadInitiateFuture$1.isDone()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testRecoverWhileCatchupConsumer$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testHandlingForRestoreOnNonErrorStatus$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$6) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$6.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testHandlingForRestoreOnNonErrorStatus$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$7) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$7.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8, CompletableFuture uploadInitiateFuture$2) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        return uploadInitiateFuture$2.isDone();
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$2() {
        return "Timed out waiting for upload initiate future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$4() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$becomeArchiver$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$9, CompletableFuture becomeArchiverFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$9.doWork();
        return becomeArchiverFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$becomeArchiver$2() {
        return "Timed out waiting to become archiver";
    }

    public TierTopicManagerTest() {
        this.clusterId = "mycluster";
        this.cleanupIntervalMs = 0;
    }
}

