/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.AbstractLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001\u0002\r\u001a\u0001\u0001BQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005B1Bqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u0004A\u0001\u0001\u0006I!\u000e\u0005\b\u0003\u0002\u0011\r\u0011\"\u00015\u0011\u0019\u0011\u0005\u0001)A\u0005k!91\t\u0001b\u0001\n\u0003!\u0005B\u0002'\u0001A\u0003%Q\tC\u0004N\u0001\t\u0007I\u0011\u0001(\t\rU\u0003\u0001\u0015!\u0003P\u0011\u00151\u0006\u0001\"\u0011X\u0011\u001di\u0006A1A\u0005\u0002yCaa\u001a\u0001!\u0002\u0013y\u0006\"\u00025\u0001\t\u0003J\u0007\"\u0002?\u0001\t\u0003j\bBBA\u0003\u0001\u0011\u0005Q\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003;\u0003A\u0011BAP\u0011%\ti\u000bAI\u0001\n\u0013\ty\u000bC\u0004\u0002F\u0002!I!a2\u0003;QKWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\(gM2Lg.\u001a+fgRT!AG\u000e\u0002\u000bQ|\u0007/[2\u000b\u0005qi\u0012\u0001\u0002;jKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%;\u000511/\u001a:wKJL!AJ\u0012\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\r\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002[A\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t\u0019\u0011J\u001c;\u0002\rQ|\u0007/[22+\u0005)\u0004C\u0001\u001c>\u001d\t94\b\u0005\u00029_5\t\u0011H\u0003\u0002;?\u00051AH]8pizJ!\u0001P\u0018\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003y=\nq\u0001^8qS\u000e\f\u0004%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u0003%!\u0018.\u001a:U_BL7-F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003}\u001d\u000b!\u0002^5feR{\u0007/[2!\u0003\u0015\u0001(o\u001c9t+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*J\u0003\u0011)H/\u001b7\n\u0005Q\u000b&A\u0003)s_B,'\u000f^5fg\u00061\u0001O]8qg\u0002\nqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0005a[\u0006C\u0001\u0018Z\u0013\tQvF\u0001\u0003V]&$\b\"\u0002/\f\u0001\u0004y\u0015A\u00039s_B,'\u000f^5fg\u00061Q\r_5uK\u0012,\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fa!\u0019;p[&\u001c'B\u00013R\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003M\u0006\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00031*DQa\u001b\bA\u00021\f\u0001\u0002^3ti&sgm\u001c\t\u0003[Zl\u0011A\u001c\u0006\u0003_B\f1!\u00199j\u0015\t\t(/A\u0004kkBLG/\u001a:\u000b\u0005M$\u0018!\u00026v]&$(\"A;\u0002\u0007=\u0014x-\u0003\u0002x]\nAA+Z:u\u0013:4w\u000e\u000b\u0002\u000fsB\u0011QN_\u0005\u0003w:\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u0001-)\u0005=y\bcA7\u0002\u0002%\u0019\u00111\u00018\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u00049sKB\f'/\u001a$peR+7\u000f^\u0001'i\u0016\u001cH/\u0011:dQ&4XM],iK:$\u0016.\u001a:QCJ$\u0018\u000e^5p]&\u001bxJ\u001a4mS:,Gc\u0001-\u0002\f!1\u0011QB\tA\u0002U\na!];peVl\u0007fB\t\u0002\u0012\u0005\u0005\u00121\u0005\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003!\u0001(o\u001c<jI\u0016\u0014(bAA\u000ea\u00061\u0001/\u0019:b[NLA!a\b\u0002\u0016\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!!\n\u0002*\u0005\u0012\u0011qE\u0001\u0003u.\f#!a\u000b\u0002\u000b-\u0014\u0018M\u001a;)\u000fE\ty#a\u000e\u0002:A!\u0011\u0011GA\u001a\u001b\t\tI\"\u0003\u0003\u00026\u0005e!!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\tY$\u0001\r|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|au\f\u0001D^3sS\u001aLX*\u0019;fe&\fG.\u001b>bi&|g\u000eT1h)\rA\u0016\u0011\t\u0005\u0007\u0003\u0007\u0012\u0002\u0019A\u0017\u0002\u0011\t\u0014xn[3s\u0013\u0012\fqc\u0019:fCR,7+Z2p]\u0012$\u0016.\u001a:fIR{\u0007/[2\u0015\u0011\u0005%\u0013\u0011MA:\u0003o\u0002bALA&[\u0005=\u0013bAA'_\t1A+\u001e9mKJ\u0002B!!\u0015\u0002^5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&\u0001\u0004d_6lwN\u001c\u0006\u0004=\u0005e#bAA.i\u00061\u0011\r]1dQ\u0016LA!a\u0018\u0002T\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA2'\u0001\u0007\u0011QM\u0001\u0006C\u0012l\u0017N\u001c\t\u0005\u0003O\ny'\u0004\u0002\u0002j)!\u00111MA6\u0015\u0011\ti'a\u0016\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011OA5\u0005\u0015\tE-\\5o\u0011\u0019\t)h\u0005a\u0001[\u0005)R\r\u001f9fGR,G\rV5feB\u000b'\u000f^5uS>t\u0007bBA='\u0001\u0007\u00111P\u0001\u000bCN\u001c\u0018n\u001a8nK:$\b#BA?\u0003\u000fkc\u0002BA@\u0003\u0007s1\u0001OAA\u0013\u0005\u0001\u0014bAAC_\u00059\u0001/Y2lC\u001e,\u0017\u0002BAE\u0003\u0017\u0013A\u0001T5ti*\u0019\u0011QQ\u0018\u0002+\u001d,G\u000fV5feR{\u0007/[2QCJ$\u0018\u000e^5p]R\u0019Q&!%\t\u000f\u0005ME\u00031\u0001\u0002\u0016\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003/\u000bI*D\u0001\u001c\u0013\r\tYj\u0007\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f1$\u00199qK:$W*Z:tC\u001e,7/\u00118e-\u0016\u0014\u0018NZ=US\u0016\u0014Hc\u0002-\u0002\"\u0006\u0015\u0016\u0011\u0016\u0005\u0007\u0003G+\u0002\u0019A\u0017\u0002\u00111,\u0017\rZ3s\u0013\u0012Dq!a*\u0016\u0001\u0004\ty%\u0001\u0002ua\"A\u00111V\u000b\u0011\u0002\u0003\u0007Q&A\u0006ok6\u001cVmZ7f]R\u001c\u0018!J1qa\u0016tG-T3tg\u0006<Wm]!oIZ+'/\u001b4z)&,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tLK\u0002.\u0003g[#!!.\u0011\t\u0005]\u0016\u0011Y\u0007\u0003\u0003sSA!a/\u0002>\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007f{\u0013AC1o]>$\u0018\r^5p]&!\u00111YA]\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016e\u0016\f7o]5h]RKWM\u001d)beRLG/[8o)\u0011\tI-a3\u0011\u000f9\nY%a\u001f\u0002|!9\u00111M\fA\u0002\u0005\u0015\u0004")
public class TierTopicPartitionOfflineTest
extends BaseRequestTest {
    private final String topic1;
    private final String topic2;
    private final String tierTopic;
    private final Properties props = new Properties();
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 6;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public String tierTopic() {
        return this.tierTopic;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.prepareForTest();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    public void prepareForTest() {
        this.props().clear();
        this.props().put("confluent.tier.enable", "true");
        this.props().put("segment.bytes", "2048");
        this.props().put("confluent.tier.local.hotset.bytes", "1");
        this.props().put("confluent.tier.local.hotset.ms", "-1");
        this.props().put("retention.bytes", "-1");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiverWhenTierPartitionIsOffline(String quorum) {
        void var5_5;
        void var13_13;
        void var12_12;
        void var4_4;
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        ConfluentAdmin admin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        Tuple2<List<Object>, List<Object>> tuple2 = this.reassignTierPartition((Admin)admin);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List replicasTierStatePartition0 = (List)tuple2._1();
        List replicasTierStatePartition1 = (List)tuple2._2();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        int leader1 = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)var4_4)}))), this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(tp1);
        AbstractLog log1 = (AbstractLog)((KafkaBroker)this.brokerForId(leader1).get()).replicaManager().getLog(tp1).get();
        int tierStatePartitionForTopic1 = this.getTierTopicPartition((TopicIdPartition)log1.topicIdPartition().get());
        int tierStatePartitionForTopic2 = tierStatePartitionForTopic1 == 0 ? 1 : 0;
        Tuple2<Object, TopicPartition> tuple22 = this.createSecondTieredTopic((Admin)admin, tierStatePartitionForTopic2, (List<Object>)var4_4);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int leader2 = tuple22._1$mcI$sp();
        TopicPartition tp2 = (TopicPartition)tuple22._2();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$1(log1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$2(tp1, leader1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AbstractLog log2 = (AbstractLog)((KafkaBroker)this.brokerForId((int)var12_12).get()).replicaManager().getLog((TopicPartition)var13_13).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$3(log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$4((TopicPartition)var13_13, (int)var12_12));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        var5_5.foreach((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> TierTopicPartitionOfflineTest.$anonfun$testArchiverWhenTierPartitionIsOffline$5(this, (List)var4_4, arg_0)));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "tier topic partition 1 is now offline");
        if (tierStatePartitionForTopic1 == 0) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), tp1.topic(), 100, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), var13_13.topic(), 100, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            this.verifyMaterializationLag((int)var12_12);
            this.appendMessagesAndVerifyTier(leader1, tp1, this.appendMessagesAndVerifyTier$default$3());
            return;
        }
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), tp1.topic(), 100, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), var13_13.topic(), 100, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        this.verifyMaterializationLag(leader1);
        this.appendMessagesAndVerifyTier((int)var12_12, (TopicPartition)var13_13, this.appendMessagesAndVerifyTier$default$3());
    }

    private void verifyMaterializationLag(int brokerId) {
        MetricName maxListeningMs = ((TierTopicConsumer)((KafkaBroker)this.brokerForId((int)brokerId).get()).replicaManager().tierReplicaComponents().logComponents().topicConsumerOpt().get()).maxListeningMsMetricName;
        DoubleRef curr = DoubleRef.create((double)0.0);
        DoubleRef prev = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> {
            Thread.sleep(5000L);
            prev$1.elem = curr$1.elem;
            curr$1.elem = BoxesRunTime.unboxToDouble((Object)((KafkaBroker)this.brokerForId(brokerId).get()).metrics().metric(maxListeningMs).metricValue());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("curr: ").append(curr$1.elem).append(" prev ").append(prev$1.elem).toString());
            Predef$.MODULE$.assert(curr$1.elem >= prev$1.elem);
        });
    }

    private Tuple2<Object, TopicPartition> createSecondTieredTopic(Admin admin, int expectedTierPartition, List<Object> assignment) {
        boolean done = false;
        int idx = -1;
        int leader = 0;
        ObjectRef name = ObjectRef.create((Object)"");
        while (!done) {
            name.elem = new StringBuilder(1).append(this.topic2()).append("-").append(Integer.toString(++idx)).toString();
            leader = BoxesRunTime.unboxToInt((Object)this.createTopic((String)name.elem, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), assignment)}))), this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
            TopicPartition tp = new TopicPartition((String)name.elem, 0);
            this.waitUntilLogCreatedOnBrokers(tp);
            AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(leader).get()).replicaManager().getLog(tp).get();
            int toTierPart = this.getTierTopicPartition((TopicIdPartition)log.topicIdPartition().get());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("Created TopicPartition ").append((String)name$1.elem).append(" that will append metadata to tier partition ").append(toTierPart).append(". Expected tier partition: ").append(expectedTierPartition).toString());
            if (toTierPart != expectedTierPartition) {
                admin.deleteTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)((String)name.elem), (List)Nil$.MODULE$)).asJavaCollection()).all().get(500L, TimeUnit.MILLISECONDS);
                continue;
            }
            done = true;
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)leader), (Object)new TopicPartition((String)name.elem, 0));
    }

    private int getTierTopicPartition(TopicIdPartition topicIdPartition) {
        return new TierTopicPartitioner(2).partitionId(topicIdPartition);
    }

    /*
     * WARNING - void declaration
     */
    private void appendMessagesAndVerifyTier(int leaderId, TopicPartition tp, int numSegments) {
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(tp).get();
        int numMessages = 50;
        IntRef totalMessages = IntRef.create((int)0);
        long oldLogEndOffset = log.logEndOffset();
        int initTotalSegments = log.numberOfSegments();
        while (log.numberOfSegments() <= initTotalSegments + numSegments) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), tp.topic(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            totalMessages.elem += numMessages;
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 90000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$appendMessagesAndVerifyTier$1(log, oldLogEndOffset, totalMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$appendMessagesAndVerifyTier$2(tp, leaderId, oldLogEndOffset, log, initTotalSegments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private int appendMessagesAndVerifyTier$default$3() {
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<List<Object>, List<Object>> reassignTierPartition(Admin admin) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$1(this, admin)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.Map tierTopicDesc = (java.util.Map)admin.describeTopics(Collections.singletonList(this.tierTopic())).allTopicNames().get(500L, TimeUnit.MILLISECONDS);
        List replicasForTierStatePartition0 = (List)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)((TopicDescription)tierTopicDesc.get(this.tierTopic())).partitions().get(0)).replicas()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToInteger((int)node.id()), List$.MODULE$.canBuildFrom());
        ListBuffer replicasForTierStatePartition1 = (ListBuffer)new ListBuffer().$plus$plus((GenTraversableOnce)((TraversableOnce)this.brokers().map((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToInteger((int)TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$4(broker)), Buffer$.MODULE$.canBuildFrom())).toList().filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)id -> replicasForTierStatePartition0.contains((Object)BoxesRunTime.boxToInteger((int)id))));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("replicasForTierStatePartition0 ").append(replicasForTierStatePartition0).append(" replicasForTierStatePartition1 ").append(replicasForTierStatePartition1).toString());
        TopicPartition tierPartition1 = new TopicPartition(this.tierTopic(), 1);
        java.util.Map reassignments = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierPartition1), Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicasForTierStatePartition1.toList().map((Function1 & Serializable & scala.Serializable)id -> TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$7(BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom())).asJava())))}))).asJava();
        admin.alterPartitionReassignments(reassignments).all().get(500L, TimeUnit.MILLISECONDS);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$8(admin)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$10(this, admin, replicasForTierStatePartition1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicPartitionOfflineTest.$anonfun$reassignTierPartition$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return new Tuple2((Object)replicasForTierStatePartition0, (Object)replicasForTierStatePartition1.toList());
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverWhenTierPartitionIsOffline$1(AbstractLog log1$1) {
        TierPartitionStatus tierPartitionStatus = log1$1.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testArchiverWhenTierPartitionIsOffline$2(TopicPartition tp1$1, int leader1$1) {
        return new StringBuilder(62).append("Timeout waiting for tier partition status of ").append(tp1$1).append(" to be ONLINE on ").append(leader1$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverWhenTierPartitionIsOffline$3(AbstractLog log2$1) {
        TierPartitionStatus tierPartitionStatus = log2$1.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testArchiverWhenTierPartitionIsOffline$4(TopicPartition tp2$1, int leader2$1) {
        return new StringBuilder(62).append("Timeout waiting for tier partition status of ").append(tp2$1).append(" to be ONLINE on ").append(leader2$1).toString();
    }

    public static final /* synthetic */ void $anonfun$testArchiverWhenTierPartitionIsOffline$5(TierTopicPartitionOfflineTest $this, List replicasTierStatePartition0$1, int id) {
        if (!replicasTierStatePartition0$1.contains((Object)BoxesRunTime.boxToInteger((int)id))) {
            ((KafkaBroker)$this.brokerForId(id).get()).shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesAndVerifyTier$1(AbstractLog log$1, long oldLogEndOffset$1, IntRef totalMessages$1) {
        return log$1.logEndOffset() == oldLogEndOffset$1 + (long)totalMessages$1.elem && log$1.tierPartitionState().numSegments() >= log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$appendMessagesAndVerifyTier$2(TopicPartition tp$1, int leaderId$1, long oldLogEndOffset$1, AbstractLog log$1, int initTotalSegments$1) {
        return new StringBuilder(177).append("Timeout waiting for all messages to be written and tiered for ").append(tp$1).append(". LeaderId=").append(leaderId$1).append(", old logEndOffset: ").append(oldLogEndOffset$1).append(", new logEndOffset: ").append(log$1.logEndOffset()).append(", ").append("old numOfSegments: ").append(initTotalSegments$1).append(", new numOfSegments: ").append(log$1.numberOfSegments()).append(", tiered numSegments: ").append(log$1.tierPartitionState().numSegments()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$reassignTierPartition$1(TierTopicPartitionOfflineTest $this, Admin admin$1) {
        try {
            admin$1.describeTopics(Collections.singletonList($this.tierTopic())).allTopicNames().get(500L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$reassignTierPartition$2() {
        return "Tier topic was not created within timeout";
    }

    public static final /* synthetic */ int $anonfun$reassignTierPartition$4(KafkaBroker broker) {
        return broker.config().brokerId();
    }

    public static final /* synthetic */ Integer $anonfun$reassignTierPartition$7(int id) {
        return BoxesRunTime.boxToInteger((int)id);
    }

    public static final /* synthetic */ boolean $anonfun$reassignTierPartition$8(Admin admin$1) {
        return ((java.util.Map)admin$1.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$reassignTierPartition$9() {
        return "Timed out waiting for reassignment to complete";
    }

    public static final /* synthetic */ boolean $anonfun$reassignTierPartition$10(TierTopicPartitionOfflineTest $this, Admin admin$1, ListBuffer replicasForTierStatePartition1$1) {
        java.util.Map tierTopicDesc = (java.util.Map)admin$1.describeTopics(Collections.singletonList($this.tierTopic())).allTopicNames().get(500L, TimeUnit.MILLISECONDS);
        List list = replicasForTierStatePartition1$1.toList();
        Object object = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)((TopicDescription)tierTopicDesc.get($this.tierTopic())).partitions().get(1)).replicas()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToInteger((int)node.id()), List$.MODULE$.canBuildFrom());
        return !(list != null ? !list.equals(object) : object != null);
    }

    public static final /* synthetic */ String $anonfun$reassignTierPartition$12() {
        return "Unexpected assignment";
    }

    public TierTopicPartitionOfflineTest() {
        this.topic1 = "foo";
        this.topic2 = "bar";
        this.tierTopic = "_confluent-tier-state";
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataMaxPollMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierArchiverNumThreadsProp(), "1");
        this.exited = new AtomicBoolean(false);
    }
}

