/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaRaftServer$;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004L\u0001\u0001\u0006Ia\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001C\u0011\u0019i\u0005\u0001)A\u0005\u0007\"9a\n\u0001b\u0001\n\u0003y\u0005B\u0002,\u0001A\u0003%\u0001\u000bC\u0004X\u0001\t\u0007I\u0011\u0001-\t\r\r\u0004\u0001\u0015!\u0003Z\u0011\u001d!\u0007A1A\u0005\u0002aCa!\u001a\u0001!\u0002\u0013I\u0006b\u00024\u0001\u0005\u0004%\t\u0001\u0017\u0005\u0007O\u0002\u0001\u000b\u0011B-\t\u000f!\u0004!\u0019!C\u00011\"1\u0011\u000e\u0001Q\u0001\neCqA\u001b\u0001C\u0002\u0013\u00051\u000e\u0003\u0004s\u0001\u0001\u0006I\u0001\u001c\u0005\bg\u0002\u0011\r\u0011\"\u0001u\u0011\u0019A\b\u0001)A\u0005k\"9\u0011\u0010\u0001b\u0001\n\u0003Q\bB\u0002@\u0001A\u0003%1\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u0011!\tI\u0002\u0001Q\u0001\n\u0005\r\u0001bCA\u000e\u0001\u0001\u0007\t\u0019!C\u0001\u0003;A1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002,!Y\u0011q\u0007\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0010\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!a\u0011\u0001\t\u0003\tY\u0004C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002H!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0003bBA8\u0001\u0011\u0005\u0011q\t\u0005\b\u0003s\u0002A\u0011AA$\u0011\u001d\ti\b\u0001C\u0001\u0003\u000fBq!!!\u0001\t\u0003\t9\u0005C\u0004\u0002\u0006\u0002!\t!a\u0012\t\u000f\u0005%\u0005\u0001\"\u0001\u0002H!9\u0011Q\u0012\u0001\u0005\u0002\u0005\u001d\u0003bBAI\u0001\u0011\u0005\u0011q\t\u0005\b\u0003+\u0003A\u0011BAL\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003\u000fBq!a*\u0001\t\u0013\tI\u000bC\u0004\u0002B\u0002!I!a1\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0007bBAp\u0001\u0011%\u0011\u0011\u001d\u0005\b\u0003[\u0004A\u0011BA$\u0005M!U/\u001c9M_\u001e\u001cVmZ7f]R\u001cH+Z:u\u0015\t\u00114'A\u0003u_>d7OC\u00015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\b\u0005\u0002A\u00015\t\u0011'\u0001\u0004u[B$\u0015N]\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0003S>T\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\n!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\fg\u0016<W.\u001a8u\u001d\u0006lW-F\u0001Q!\t\tF+D\u0001S\u0015\t\u0019v)\u0001\u0003mC:<\u0017BA+S\u0005\u0019\u0019FO]5oO\u0006a1/Z4nK:$h*Y7fA\u0005YAn\\4GS2,\u0007+\u0019;i+\u0005I\u0006C\u0001.b\u001d\tYv\f\u0005\u0002]s5\tQL\u0003\u0002_k\u00051AH]8pizJ!\u0001Y\u001d\u0002\rA\u0013X\rZ3g\u0013\t)&M\u0003\u0002as\u0005aAn\\4GS2,\u0007+\u0019;iA\u0005a1O\\1qg\"|G\u000fU1uQ\u0006i1O\\1qg\"|G\u000fU1uQ\u0002\nQ\"\u001b8eKb4\u0015\u000e\\3QCRD\u0017AD5oI\u0016Dh)\u001b7f!\u0006$\b\u000eI\u0001\u0012i&lW-\u00138eKb4\u0015\u000e\\3QCRD\u0017A\u0005;j[\u0016Le\u000eZ3y\r&dW\rU1uQ\u0002\nA\u0001^5nKV\tA\u000e\u0005\u0002na6\taN\u0003\u0002pg\u0005)Q\u000f^5mg&\u0011\u0011O\u001c\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005q1\r\\3b]V\u0004H)\u001a7bs6\u001bX#A;\u0011\u0005a2\u0018BA<:\u0005\u0011auN\\4\u0002\u001f\rdW-\u00198va\u0012+G.Y=Ng\u0002\n\u0011c\u00197fC:,\b/\u00138uKJ4\u0018\r\\'t+\u0005Y\bC\u0001\u001d}\u0013\ti\u0018HA\u0002J]R\f!c\u00197fC:,\b/\u00138uKJ4\u0018\r\\'tA\u00059!-\u0019;dQ\u0016\u001cXCAA\u0002!\u0019\t)!a\u0004\u0002\u00145\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0004nkR\f'\r\\3\u000b\u0007\u00055\u0011(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0005\u0002\b\tY\u0011I\u001d:bs\n+hMZ3s!\r\u0001\u0015QC\u0005\u0004\u0003/\t$!\u0003\"bi\u000eD\u0017J\u001c4p\u0003!\u0011\u0017\r^2iKN\u0004\u0013a\u00017pOV\u0011\u0011q\u0004\t\u0005\u0003C\t)#\u0004\u0002\u0002$)\u0019\u00111D\u001a\n\t\u0005\u001d\u00121\u0005\u0002\f\u0003\n\u001cHO]1di2{w-A\u0004m_\u001e|F%Z9\u0015\t\u00055\u00121\u0007\t\u0004q\u0005=\u0012bAA\u0019s\t!QK\\5u\u0011%\t)$GA\u0001\u0002\u0004\ty\"A\u0002yIE\nA\u0001\\8hA\u0005y1\r[3dWN,X.\u00128bE2,G-\u0006\u0002\u0002>A\u0019\u0001(a\u0010\n\u0007\u0005\u0005\u0013HA\u0004C_>dW-\u00198\u0002%\u0019$\bo]\"mK\u0006tW\u000f]#oC\ndW\rZ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003[A3!HA&!\u0011\ti%a\u0018\u000e\u0005\u0005=#\u0002BA)\u0003'\n1!\u00199j\u0015\u0011\t)&a\u0016\u0002\u000f),\b/\u001b;fe*!\u0011\u0011LA.\u0003\u0015QWO\\5u\u0015\t\ti&A\u0002pe\u001eLA!!\u0019\u0002P\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002!\u0005$GmU5na2,'+Z2pe\u0012\u001c\u0018\u0001\u0003;fCJ$un\u001e8)\u0007}\tI\u0007\u0005\u0003\u0002N\u0005-\u0014\u0002BA7\u0003\u001f\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002AQ,7\u000f\u001e\"bi\u000eD\u0017I\u001c3SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1PkR\u0004X\u000f\u001e\u0015\u0004A\u0005M\u0004\u0003BA'\u0003kJA!a\u001e\u0002P\t!A+Z:u\u0003A!Xm\u001d;Qe&tG\u000fR1uC2{w\rK\u0002\"\u0003g\nq\u0003^3ti\u0012+X\u000e]%oI\u0016DX*[:nCR\u001c\u0007.Z:)\u0007\t\n\u0019(A\fuKN$H)^7q)&lW-\u00138eKb,%O]8sg\"\u001a1%a\u001d\u00025Q,7\u000f\u001e#v[B$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3)\u0007\u0011\n\u0019(A\fuKN$H)^7q\u001b\u0016$\u0018\rZ1uCJ+7m\u001c:eg\"\u001aQ%a\u001d\u00021Q,7\u000f\u001e#v[BlU\r^1eCR\f7K\\1qg\"|G\u000fK\u0002'\u0003g\n!\u0003^3ti\u0012+X\u000e]#naRL\u0018J\u001c3fq\"\u001aq%a\u001d\u0002%I,h\u000eR;na2{wmU3h[\u0016tGo\u001d\u000b\u00043\u0006e\u0005bBANQ\u0001\u0007\u0011QT\u0001\u0005CJ<7\u000f\u0005\u00039\u0003?K\u0016bAAQs\t)\u0011I\u001d:bs\u0006qB/Z:u!JLg\u000e\u001e#bi\u0006dun\u001a)beRL\u0017\r\u001c\"bi\u000eDWm\u001d\u0015\u0004S\u0005M\u0014!\u0005:fC\u0012\u0014\u0015\r^2i\u001b\u0016$\u0018\rZ1uCR!\u00111VAY!\u0011A\u0014QV-\n\u0007\u0005=\u0016H\u0001\u0004PaRLwN\u001c\u0005\b\u0003gS\u0003\u0019AA[\u0003\u0015a\u0017N\\3t!\u0015\t9,!0Z\u001b\t\tILC\u0002\u0002<\u001e\u000bA!\u001e;jY&!\u0011qXA]\u00051a\u0015n\u001d;Ji\u0016\u0014\u0018\r^8s\u0003]\u0011X-\u00193QCJ$\u0018.\u00197CCR\u001c\u0007.Z:CsR,7\u000fF\u0003|\u0003\u000b\f9\rC\u0004\u00024.\u0002\r!!.\t\r\u0005%7\u00061\u0001|\u0003\u0015a\u0017.\\5u\u00031\u0019w.\u001e8u\u0005\u0006$8\r[3t)\rY\u0018q\u001a\u0005\b\u0003gc\u0003\u0019AA[\u0003A\u0011X-\u00193CCR\u001c\u0007NU3d_J$7\u000f\u0006\u0003\u0002V\u0006u\u0007#BAl\u00033LVBAA\u0006\u0013\u0011\tY.a\u0003\u0003\u0007M+\u0017\u000fC\u0004\u000246\u0002\r!!.\u0002'A\f'o]3NKR\fG-\u0019;b\r&,G\u000eZ:\u0015\t\u0005\r\u0018\u0011\u001e\t\u00065\u0006\u0015\u0018,W\u0005\u0004\u0003O\u0014'aA'ba\"1\u00111\u001e\u0018A\u0002e\u000bA\u0001\\5oK\u0006Y\u0012m]:feR$U/\u001c9M_\u001e\u0014VmY8sI6+G/\u00193bi\u0006\u0004")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private AbstractLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean ftpsCleanupEnabled() {
        return false;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.IndexIntervalBytesProp(), "128");
        props.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some(Mockito.mock(TierTopicConsumer.class)), (Option)new Some(Mockito.mock(TierObjectStore.class)), new TierPartitionStateFactory(true, this.checksumEnabled(), true, new TierPartitionStateCleanupConfig(this.ftpsCleanupEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs())), (Option)None$.MODULE$);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        int x$9 = 300000;
        int x$10 = 3600000;
        int x$11 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        boolean x$14 = true;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = true;
        None$ x$17 = None$.MODULE$;
        ConcurrentHashMap x$18 = new ConcurrentHashMap();
        LogOffsetsListener x$19 = MergedLog$.MODULE$.apply$default$17();
        this.log_$eq((AbstractLog)MergedLog$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, x$8, (Time)x$6, x$9, x$10, x$11, x$12, tierLogComponents, x$14, (Option)x$15, x$16, x$19, (Option)x$17, x$18));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable & scala.Serializable)batchInfo -> {
            AbstractLog qual$1 = this.log();
            MemoryRecords x$1 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])batchInfo.records().toSeq().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            int x$2 = 0;
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            return qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        });
        this.log().flush(false);
    }

    @AfterEach
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBatchAndRecordMetadataOutput() {
        AbstractLog qual$1 = this.log();
        MemoryRecords x$1 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())});
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        AbstractLog qual$2 = this.log();
        MemoryRecords x$6 = MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())});
        int x$7 = 3;
        AppendOrigin x$8 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, x$8, x$9, x$10);
        AbstractLog qual$3 = this.log();
        MemoryRecords x$11 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())});
        int x$12 = 3;
        AppendOrigin x$13 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
        AbstractLog qual$4 = this.log();
        MemoryRecords x$16 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)29342342L, (short)((short)15), (int)234123, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("h".getBytes())});
        int x$17 = 3;
        AppendOrigin x$18 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$4.appendAsLeader$default$4();
        RequestLocal x$20 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
        AbstractLog qual$5 = this.log();
        MemoryRecords x$21 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.GZIP, (long)98323L, (short)((short)99), (int)266, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())});
        int x$22 = 5;
        AppendOrigin x$23 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$24 = qual$5.appendAsLeader$default$4();
        RequestLocal x$25 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$21, x$22, x$23, x$24, x$25);
        AbstractLog qual$6 = this.log();
        MemoryRecords x$26 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        AppendOrigin.Coordinator$ x$27 = AppendOrigin.Coordinator$.MODULE$;
        int x$28 = 7;
        MetadataVersion x$29 = qual$6.appendAsLeader$default$4();
        RequestLocal x$30 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$26, x$28, (AppendOrigin)x$27, x$29, x$30);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(false, (String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    @Test
    public void testDumpTierPartitionState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(this.log().topicPartition().topic(), UUID.randomUUID(), this.log().topicPartition().partition());
        AbstractLog qual$1 = this.log();
        Uuid x$1 = topicIdPartition.kafkaTopicId();
        int x$2 = qual$1.assignTopicId$default$2();
        qual$1.assignTopicId(x$1, x$2);
        this.log().tierPartitionState().beginCatchup();
        this.log().tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), new OffsetAndEpoch(0L, Optional.empty()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.log().tierPartitionState().append((AbstractTierMetadata)new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 1L, 1500L, 100L, 100, true, false, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), TierObjectStore.OpaqueData.ZEROED), new OffsetAndEpoch(1L, Optional.empty())));
        this.log().tierPartitionState().flush();
        String suffix = this.checksumEnabled() ? Algorithm.ADLER.suffix : Algorithm.NO_CHECKSUM.suffix;
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments((String[])((Object[])new String[]{"--files", new StringBuilder(0).append(MergedLog$.MODULE$.tierStateFile(this.log().dir(), 0L, MergedLog$.MODULE$.tierStateFile$default$3()).getAbsolutePath()).append(suffix).toString()})), topicIdPartition);
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments((String[])((Object[])new String[]{"--files", new StringBuilder(8).append(MergedLog$.MODULE$.tierStateFile(this.log().dir(), 0L, MergedLog$.MODULE$.tierStateFile$default$3()).getAbsolutePath()).append(".mutable").append(suffix).toString()})), topicIdPartition);
    }

    @Test
    public void testDumpMetadataRecords() {
        MockTime mockTime = new MockTime();
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        boolean x$17 = LogTestUtils$.MODULE$.createLogConfig$default$17();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        MergedLog log = LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), mockTime.scheduler(), (Time)mockTime, LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17());
        SimpleRecord[] records = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)message -> {
            MetadataRecordSerde serde = new MetadataRecordSerde();
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.flush(false);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(null, buf.array())}), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataSnapshot() {
        void resource_resource;
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), new Metrics(), (Scheduler)this.time().scheduler(), new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, kafka.log.Defaults$.MODULE$.FileDeleteDelayMs(), 1));
        int lastContainedLogTimestamp = 10000;
        AutoCloseable autoCloseable = (AutoCloseable)RecordsSnapshotWriter.createWithHeader(() -> metadataLog.createNewSnapshot(new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)), (int)1024, (MemoryPool)MemoryPool.NONE, (Time)new MockTime(), (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)new MetadataRecordSerde()).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            SnapshotWriter snapshotWriter = (SnapshotWriter)resource_resource;
            DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2((Seq)metadataRecords, snapshotWriter);
        }
        finally {
            resource_resource.close();
        }
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()}));
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"));
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()));
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()}));
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"));
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        System.setOut(System.out);
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.addSimpleRecords();
        int partialBatches = this.batches().size() / 2;
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--files", this.logFilePath()})).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<Object> partialLines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()})).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = new StringOps(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+")).r();
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOptimized)option.get()).apply(0);
                batchesBytes += new StringOps(Predef$.MODULE$.augmentString(size)).toInt();
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    /*
     * WARNING - void declaration
     */
    private int countBatches(ListIterator<String> lines) {
        void var2_2;
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return (int)var2_2;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = Map$.MODULE$.empty();
        Iterator tokens = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+"))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$parseMetadataFields$2(x$6))))).iterator();
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap(Predef$.MODULE$.$conforms());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = (FetchDataInfo)this.log().read(0L, Integer.MAX_VALUE, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()})).split("\n")).listIterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(logReadInfo.records().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)this.batches().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$2) {
        return x$2.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.batches().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$2)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    private static final void validate$1(String output, TopicIdPartition topicIdPartition$1) {
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("Header"))).get()).contains(topicIdPartition$1.topicIdAsBase64()));
        Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains("SEGMENT_UPLOAD_INITIATE"))));
    }

    public static final /* synthetic */ void $anonfun$testDumpMetadataSnapshot$2(Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        snapshotWriter.append((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(metadataRecords$1).asJava());
        snapshotWriter.freeze();
    }

    public static final /* synthetic */ boolean $anonfun$parseMetadataFields$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$2(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$3(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$4(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$5(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$6(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$7(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$8(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toLong();
    }

    public static final /* synthetic */ short $anonfun$assertDumpLogRecordMetadata$9(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toShort();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$10(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$12(String x$16) {
        return new StringOps(Predef$.MODULE$.augmentString(x$16)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$13(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).toInt();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$14(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$18)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$15(String x$19) {
        return new StringOps(Predef$.MODULE$.augmentString(x$19)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$16(String x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$20)).toInt();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$12(x$16))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$13(x$17))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$14(x$18))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$15(x$19))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$16(x$20))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$2(x$7))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$3(x$8))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$4(x$9))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$5(x$10))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$6(x$11))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$7(x$12))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$8(x$13))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToShort((short)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$9(x$14))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$10(x$15))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
        this.cleanupIntervalMs = 0;
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter);
        return BoxedUnit.UNIT;
    }
}

