/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.admin.balancer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import kafka.admin.balancer.BalancerCommandOptions;
import kafka.admin.balancer.BrokerAdditionCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerAdditionDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerAdditionsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.BalancerOperationOverriddenException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.SystemTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\f\u0018\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00046\u0001\u0001\u0006I!\f\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0011\u0019Y\u0004\u0001)A\u0005q!9A\b\u0001b\u0001\n\u00039\u0004BB\u001f\u0001A\u0003%\u0001\bC\u0004?\u0001\t\u0007I\u0011A\u001c\t\r}\u0002\u0001\u0015!\u00039\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005Ca!\u0012\u0001!\u0002\u0013\u0011\u0005b\u0002$\u0001\u0005\u0004%\t!\u0011\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002\"\t\u000b!\u0003A\u0011B%\t\u000b\u001d\u0004A\u0011\u00015\t\u000b]\u0004A\u0011\u00015\t\u000be\u0004A\u0011\u00015\t\u000bm\u0004A\u0011\u00015\t\u000bu\u0004A\u0011\u00015\t\r}\u0004A\u0011BA\u0001\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013\u0011\u0011D\u0011:pW\u0016\u0014\u0018\t\u001a3ji&|gnQ8n[\u0006tG\rV3ti*\u0011\u0001$G\u0001\tE\u0006d\u0017M\\2fe*\u0011!dG\u0001\u0006C\u0012l\u0017N\u001c\u0006\u00039u\tQa[1gW\u0006T\u0011AH\u0001\u0005k:LGo\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u0002/\u0005y!m\\8ugR\u0014\u0018\r]*feZ,'/F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0003mC:<'\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003i=\u0012aa\u0015;sS:<\u0017\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:!\u0003\u001d\u0011'o\\6feB*\u0012\u0001\u000f\t\u0003EeJ!AO\u0012\u0003\u0007%sG/\u0001\u0005ce>\\WM\u001d\u0019!\u0003\u001d\u0011'o\\6feF\n\u0001B\u0019:pW\u0016\u0014\u0018\u0007I\u0001\bEJ|7.\u001a:3\u0003!\u0011'o\\6feJ\u0002\u0013aC:uCJ$H+[7f\u001bN,\u0012A\u0011\t\u0003E\rK!\u0001R\u0012\u0003\t1{gnZ\u0001\rgR\f'\u000f\u001e+j[\u0016l5\u000fI\u0001\u0011Y\u0006\u001cH/\u00169eCR,G+[7f\u001bN\f\u0011\u0003\\1tiV\u0003H-\u0019;f)&lW-T:!\u0003)\u0011XO\\\"p[6\fg\u000e\u001a\u000b\u0004\u0015RK\u0006CA&S\u001d\ta\u0005\u000b\u0005\u0002NG5\taJ\u0003\u0002P?\u00051AH]8pizJ!!U\u0012\u0002\rA\u0013X\rZ3g\u0013\t!4K\u0003\u0002RG!)QK\u0004a\u0001-\u0006!\u0011M]4t!\r\u0011sKS\u0005\u00031\u000e\u0012Q!\u0011:sCfDQA\u0017\bA\u0002m\u000bq\"\\8dW\u0006#W.\u001b8DY&,g\u000e\u001e\t\u00039\u0016l\u0011!\u0018\u0006\u00035yS!a\u00181\u0002\u000f\rd\u0017.\u001a8ug*\u0011A$\u0019\u0006\u0003E\u000e\fa!\u00199bG\",'\"\u00013\u0002\u0007=\u0014x-\u0003\u0002g;\nyQj\\2l\u0003\u0012l\u0017N\\\"mS\u0016tG/A\u0016uKN$H)Z:de&\u0014WM\u0011:pW\u0016\u0014\u0018\t\u001a3ji&|gn\u00155poN,U\u000e\u001d;z\u001b\u0016\u001c8/Y4f)\u0005I\u0007C\u0001\u0012k\u0013\tY7E\u0001\u0003V]&$\bFA\bn!\tqW/D\u0001p\u0015\t\u0001\u0018/A\u0002ba&T!A]:\u0002\u000f),\b/\u001b;fe*\u0011AoY\u0001\u0006UVt\u0017\u000e^\u0005\u0003m>\u0014A\u0001V3ti\u0006QB/Z:u\t\u0016\u001c8M]5cK\n\u0013xn[3s\u0003\u0012$\u0017\u000e^5p]\"\u0012\u0001#\\\u00018i\u0016\u001cH\u000fR3tGJL'-\u001a\"s_.,'/\u00113eSRLwN\\(oYf\u001c\u0006n\\<t)\",7\u000b]3dS\u001aLW\r\u001a\"s_.,'/\u00133)\u0005Ei\u0017A\u000b;fgR$Um]2sS\n,'I]8lKJ\fE\rZ5uS>t7\u000f\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0003%5\fq\u0003^3ti6K7o]5oOJ+\u0017/^5sK\u0012\f%oZ:)\u0005Mi\u0017a\u00042s_.,'oU;cgR\u0014\u0018N\\4\u0015\u0007)\u000b\u0019\u0001\u0003\u0004\u0002\u0006Q\u0001\r\u0001O\u0001\tEJ|7.\u001a:JI\u0006q1m\\;oiN+(m\u001d;sS:<G#\u0002\u001d\u0002\f\u0005=\u0001BBA\u0007+\u0001\u0007!*A\u0002tiJDa!!\u0005\u0016\u0001\u0004Q\u0015AB:vEN$(\u000f")
public class BrokerAdditionCommandTest {
    private final String bootstrapServer;
    private final int broker0;
    private final int broker1;
    private final int broker2;
    private final long startTimeMs = new SystemTime().hiResClockMs();
    private final long lastUpdateTimeMs = this.startTimeMs() + new package.DurationInt(package$.MODULE$.DurationInt(30)).second().toMillis();

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public int broker0() {
        return this.broker0;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    public long lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    /*
     * WARNING - void declaration
     */
    private String runCommand(String[] args, MockAdminClient mockAdminClient) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> BrokerAdditionCommand$.MODULE$.runAddition(new BalancerCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), (ConfluentAdmin)mockAdminClient);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    @Test
    public void testDescribeBrokerAdditionShowsEmptyMessage() {
        MockAdminClient admin = (MockAdminClient)Mockito.mock(MockAdminClient.class);
        DescribeBrokerAdditionsResult describeBrokerAdditionsResult = (DescribeBrokerAdditionsResult)Mockito.mock(DescribeBrokerAdditionsResult.class);
        KafkaFutureImpl brokerAdditionDescriptionsMapFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerAdditionsResult.descriptions()).thenReturn((Object)brokerAdditionDescriptionsMapFutureMock);
        HashMap additionMap = new HashMap();
        Mockito.when((Object)brokerAdditionDescriptionsMapFutureMock.get()).thenReturn(additionMap);
        Mockito.when((Object)admin.describeBrokerAdditions()).thenReturn((Object)describeBrokerAdditionsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerAdditions();
        Assertions.assertTrue((boolean)output.contains("No broker additions in progress"), (String)"Empty results message should be shown");
    }

    @Test
    public void testDescribeBrokerAddition() {
        MockAdminClient admin = (MockAdminClient)Mockito.mock(MockAdminClient.class);
        DescribeBrokerAdditionsResult describeBrokerAdditionsResult = (DescribeBrokerAdditionsResult)Mockito.mock(DescribeBrokerAdditionsResult.class);
        KafkaFutureImpl brokerAdditionDescriptionsMapFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerAdditionsResult.descriptions()).thenReturn((Object)brokerAdditionDescriptionsMapFutureMock);
        BalancerOperationError opError = new BalancerOperationError(Errors.BALANCER_OPERATION_OVERRIDDEN, "SBK is offline!");
        HashMap<Integer, BrokerAdditionDescription> additionMap = new HashMap<Integer, BrokerAdditionDescription>();
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker0()), new BrokerAdditionDescription(this.broker0(), BalancerOperationStatus.SUCCESS, PartitionReassignmentsStatus.COMPLETED, Optional.empty(), this.startTimeMs(), this.lastUpdateTimeMs()));
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker1()), new BrokerAdditionDescription(this.broker1(), BalancerOperationStatus.FAILED, PartitionReassignmentsStatus.ERROR, Optional.of(opError), this.startTimeMs(), this.lastUpdateTimeMs()));
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker2()), new BrokerAdditionDescription(this.broker2(), BalancerOperationStatus.FAILED, PartitionReassignmentsStatus.ERROR, Optional.of(opError), this.startTimeMs(), this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerAdditionDescriptionsMapFutureMock.get()).thenReturn(additionMap);
        Mockito.when((Object)admin.describeBrokerAdditions()).thenReturn((Object)describeBrokerAdditionsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerAdditions();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.broker0())), (String)new StringBuilder(22).append("Output should contain ").append(this.broker0()).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.broker1())), (String)new StringBuilder(22).append("Output should contain ").append(this.broker1()).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.broker2())), (String)new StringBuilder(22).append("Output should contain ").append(this.broker2()).toString());
        Assertions.assertEquals((int)1, (int)this.countSubstring(output, PartitionReassignmentsStatus.COMPLETED.name()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, PartitionReassignmentsStatus.ERROR.name()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, BalancerOperationOverriddenException.class.getName()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, opError.errorMessage()));
        Assertions.assertEquals((int)3, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.startTimeMs())), (String)output);
        Assertions.assertEquals((int)3, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.lastUpdateTimeMs())), (String)output);
    }

    @Test
    public void testDescribeBrokerAdditionOnlyShowsTheSpecifiedBrokerId() {
        MockAdminClient admin = (MockAdminClient)Mockito.mock(MockAdminClient.class);
        DescribeBrokerAdditionsResult describeBrokerAdditionsResult = (DescribeBrokerAdditionsResult)Mockito.mock(DescribeBrokerAdditionsResult.class);
        KafkaFutureImpl singleAdditionFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        KafkaFutureImpl brokerAdditionDescriptionsMapFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerAdditionsResult.description(this.broker0())).thenReturn((Object)singleAdditionFutureMock);
        Mockito.when((Object)describeBrokerAdditionsResult.descriptions()).thenReturn((Object)brokerAdditionDescriptionsMapFutureMock);
        BalancerOperationError opError = new BalancerOperationError(Errors.BALANCER_OPERATION_OVERRIDDEN, "Removal request came in!");
        HashMap<Integer, BrokerAdditionDescription> additionMap = new HashMap<Integer, BrokerAdditionDescription>();
        BrokerAdditionDescription b0Addition = new BrokerAdditionDescription(this.broker0(), BalancerOperationStatus.SUCCESS, PartitionReassignmentsStatus.COMPLETED, Optional.empty(), this.startTimeMs(), this.lastUpdateTimeMs());
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker0()), b0Addition);
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker1()), new BrokerAdditionDescription(this.broker1(), BalancerOperationStatus.FAILED, PartitionReassignmentsStatus.ERROR, Optional.of(opError), this.startTimeMs(), this.lastUpdateTimeMs()));
        additionMap.put(Predef$.MODULE$.int2Integer(this.broker2()), new BrokerAdditionDescription(this.broker2(), BalancerOperationStatus.FAILED, PartitionReassignmentsStatus.ERROR, Optional.of(opError), this.startTimeMs(), this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerAdditionDescriptionsMapFutureMock.get()).thenReturn(additionMap);
        Mockito.when((Object)singleAdditionFutureMock.get()).thenReturn(Optional.of(b0Addition));
        Mockito.when((Object)admin.describeBrokerAdditions()).thenReturn((Object)describeBrokerAdditionsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe", "--broker-id", Integer.toString(this.broker0())}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerAdditions();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.broker0())), (String)new StringBuilder(45).append("Output should contain broker id ").append(this.broker0()).append(". Output was ").append(output).toString());
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.broker1())), (String)new StringBuilder(49).append("Output should not contain broker id ").append(this.broker1()).append(". Output was ").append(output).toString());
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.broker2())), (String)new StringBuilder(49).append("Output should not contain broker id ").append(this.broker2()).append(". Output was ").append(output).toString());
        Assertions.assertEquals((int)1, (int)this.countSubstring(output, PartitionReassignmentsStatus.COMPLETED.name()));
        Assertions.assertEquals((int)0, (int)this.countSubstring(output, PartitionReassignmentsStatus.ERROR.name()));
        Assertions.assertEquals((int)0, (int)this.countSubstring(output, BalancerOperationOverriddenException.class.getName()));
        Assertions.assertEquals((int)1, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.startTimeMs())), (String)output);
        Assertions.assertEquals((int)1, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.lastUpdateTimeMs())), (String)output);
    }

    @Test
    public void testDescribeBrokerAdditionsThrowsException() {
        MockAdminClient admin = (MockAdminClient)Mockito.mock(MockAdminClient.class);
        DescribeBrokerAdditionsResult describeBrokerAdditionsResult = (DescribeBrokerAdditionsResult)Mockito.mock(DescribeBrokerAdditionsResult.class);
        KafkaFutureImpl brokerAdditionDescriptionsMapFutureMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerAdditionsResult.descriptions()).thenReturn((Object)brokerAdditionDescriptionsMapFutureMock);
        Mockito.when((Object)brokerAdditionDescriptionsMapFutureMock.get()).thenThrow(new Throwable[]{new BalancerOfflineException("SBK is offline!")});
        Mockito.when((Object)admin.describeBrokerAdditions()).thenReturn((Object)describeBrokerAdditionsResult);
        AdminCommandFailedException receivedException = (AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> this.runCommand((String[])((Object[])new String[]{"--describe"}), admin));
        Assertions.assertNotNull((Object)receivedException.getCause(), (String)"Expected the exception to have a cause");
        Assertions.assertEquals(BalancerOfflineException.class, receivedException.getCause().getClass());
    }

    @Test
    public void testMissingRequiredArgs() {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BalancerCommandOptions((String[])((Object[])new String[]{"--broker-id", Integer.toString(this.broker1()), "--describe"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerAdditionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
    }

    private String brokerSubstring(int brokerId) {
        return new StringBuilder(7).append("Broker ").append(brokerId).toString();
    }

    private int countSubstring(String str, String substr) {
        return new StringOps(Predef$.MODULE$.augmentString(substr)).r().findAllMatchIn((CharSequence)str).length();
    }

    public BrokerAdditionCommandTest() {
        this.bootstrapServer = "localhost:9092";
        this.broker0 = 0;
        this.broker1 = 1;
        this.broker2 = 2;
    }
}

