/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.durability.audit;

import java.util.List;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.SegmentOffsetMap;
import kafka.durability.audit.SegmentRange;
import kafka.durability.audit.SegmentRange$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001\u0002\u000f\u001e\u0001\u0019BQ!\f\u0001\u0005\u00029B\u0011\"\r\u0001A\u0002\u0003\u0007I\u0011\u0002\u001a\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0013\u0001\u0005\"\u0003$\u0001\u0001\u0004\u0005\t\u0015)\u00034\u0011%9\u0005\u00011AA\u0002\u0013%\u0001\nC\u0005Q\u0001\u0001\u0007\t\u0019!C\u0005#\"I1\u000b\u0001a\u0001\u0002\u0003\u0006K!\u0013\u0005\n)\u0002\u0001\r\u00111A\u0005\nUC\u0011B\u0017\u0001A\u0002\u0003\u0007I\u0011B.\t\u0013u\u0003\u0001\u0019!A!B\u00131\u0006\"\u00030\u0001\u0001\u0004\u0005\r\u0011\"\u0003`\u0011%1\u0007\u00011AA\u0002\u0013%q\rC\u0005j\u0001\u0001\u0007\t\u0011)Q\u0005A\"9!\u000e\u0001b\u0001\n\u0003Y\u0007B\u00029\u0001A\u0003%A\u000eC\u0003r\u0001\u0011\u0005!\u000fC\u0003\u007f\u0001\u0011\u0005!\u000f\u0003\u0004\u0002\b\u0001!\tA\u001d\u0005\u0007\u0003\u0017\u0001A\u0011\u0001:\t\r\u0005=\u0001\u0001\"\u0001s\u0011\u0019\t\u0019\u0002\u0001C\u0001e\"1\u0011q\u0003\u0001\u0005\u0002IDa!a\u0007\u0001\t\u0003\u0011\bBBA\u0010\u0001\u0011\u0005!\u000f\u0003\u0004\u0002$\u0001!\tA\u001d\u0005\u0007\u0003O\u0001A\u0011\u0001:\t\r\u0005-\u0002\u0001\"\u0001s\u0005E\tU\u000fZ5u%\u0016\u0004xN\u001d;feR+7\u000f\u001e\u0006\u0003=}\tQ!Y;eSRT!\u0001I\u0011\u0002\u0015\u0011,(/\u00192jY&$\u0018P\u0003\u0002#G\u0005)1.\u00194lC*\tA%\u0001\u0003v]&$8\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00010!\t\u0001\u0004!D\u0001\u001e\u0003\u001diW\r\u001e:jGN,\u0012a\r\t\u0003iuj\u0011!\u000e\u0006\u0003cYR!a\u000e\u001d\u0002\r\r|W.\\8o\u0015\t\u0011\u0013H\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<\u0017B\u0001 6\u0005\u001diU\r\u001e:jGN\f1\"\\3ue&\u001c7o\u0018\u0013fcR\u0011\u0011\t\u0012\t\u0003Q\tK!aQ\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u000b\u000e\t\t\u00111\u00014\u0003\rAH%M\u0001\t[\u0016$(/[2tA\u0005A!/\u001a9peR,'/F\u0001J!\tQe*D\u0001L\u0015\tqBJ\u0003\u0002!\u001b*\t!%\u0003\u0002P\u0017\ni\u0011)\u001e3jiJ+\u0007o\u001c:uKJ\fAB]3q_J$XM]0%KF$\"!\u0011*\t\u000f\u00153\u0011\u0011!a\u0001\u0013\u0006I!/\u001a9peR,'\u000fI\u0001\t[6\u000bg.Y4feV\ta\u000b\u0005\u0002X16\tA*\u0003\u0002Z\u0019\nAB)\u001e:bE&d\u0017\u000e^=NKR\u0014\u0018nY:NC:\fw-\u001a:\u0002\u00195l\u0015M\\1hKJ|F%Z9\u0015\u0005\u0005c\u0006bB#\n\u0003\u0003\u0005\rAV\u0001\n[6\u000bg.Y4fe\u0002\nA\u0001^5nKV\t\u0001\r\u0005\u0002bI6\t!M\u0003\u0002dm\u0005)Q\u000f^5mg&\u0011QM\u0019\u0002\u0005)&lW-\u0001\u0005uS6,w\fJ3r)\t\t\u0005\u000eC\u0004F\u0019\u0005\u0005\t\u0019\u00011\u0002\u000bQLW.\u001a\u0011\u0002\tQ\u0004\u0018\nZ\u000b\u0002YB\u0011QN\\\u0007\u0002m%\u0011qN\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0015!\b/\u00133!\u0003\u0015\u0019X\r^+q)\u0005\t\u0005F\u0001\tu!\t)H0D\u0001w\u0015\t9\b0A\u0002ba&T!!\u001f>\u0002\u000f),\b/\u001b;fe*\u00111pO\u0001\u0006UVt\u0017\u000e^\u0005\u0003{Z\u0014!BQ3g_J,W)Y2i\u0003q!Xm\u001d;TK\u001elWM\u001c;NCB$\u0015n\u001d;j]\u000e$Hk\u001c9jGND3!EA\u0001!\r)\u00181A\u0005\u0004\u0003\u000b1(\u0001\u0002+fgR\f\u0001\u0005^3tiN+w-\\3oi6\u000b\u0007oV5uQ:{\u0017J\u001c;feN,7\r^5p]\"\u001a!#!\u0001\u0002SQ,7\u000f^*fO6,g\u000e^'ba^KG\u000f\u001b'fMRLe\u000e^3sg\u0016\u001cG/[8o'\u0006lWMU;oQ\r\u0019\u0012\u0011A\u0001/i\u0016\u001cHoU3h[\u0016tG/T1q/&$\b\u000eT3gi&sG/\u001a:tK\u000e$\u0018n\u001c8ES\u001a4WM]3oiJ+h\u000eK\u0002\u0015\u0003\u0003\t1\u0005^3tiN+w-\\3oi6\u000b\u0007oV5uQJKw\r\u001b;J]R,'o]3di&|g\u000eK\u0002\u0016\u0003\u0003\ta\u0004^3tiN+w-\\3oi6\u000b\u0007oV5uQ&sG/\u001a:tK\u000e$\u0018n\u001c8)\u0007Y\t\t!A\u0016uKN$8+Z4nK:$X*\u00199XSRD7+\u001e2tKRLe\u000e^3sg\u0016\u001cG/[8o'\u0006lWMU;oQ\r9\u0012\u0011A\u00011i\u0016\u001cHoU3h[\u0016tG/T1q/&$\bnU;cg\u0016$\u0018J\u001c;feN,7\r^5p]\u0012KgMZ3sK:$(+\u001e8)\u0007a\t\t!\u0001\u001buKN$(+\u001a9peR$UO]1cS2LG/\u001f'baN,w+\u001b;i_V$\u0018J\u001c;feN,7\r^5oON+w-\\3oiND3!GA\u0001\u0003E\"Xm\u001d;SKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3XSRD\u0017J\u001c;feN,7\r^5oON+w-\\3oiND3AGA\u0001\u0003]\"Xm\u001d;SKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3XSRD\u0017J\u001c;feN,7\r^5oON+(m]3u'\u0016<W.\u001a8ug\"\u001a1$!\u0001")
public class AuditReporterTest {
    private Metrics metrics;
    private AuditReporter reporter;
    private DurabilityMetricsManager mManager;
    private Time time;
    private final TopicPartition tpId = new TopicPartition("t", 1);

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private AuditReporter reporter() {
        return this.reporter;
    }

    private void reporter_$eq(AuditReporter x$1) {
        this.reporter = x$1;
    }

    private DurabilityMetricsManager mManager() {
        return this.mManager;
    }

    private void mManager_$eq(DurabilityMetricsManager x$1) {
        this.mManager = x$1;
    }

    private Time time() {
        return this.time;
    }

    private void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public TopicPartition tpId() {
        return this.tpId;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.metrics_$eq(new Metrics(new MetricConfig(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), this.time()));
        this.mManager_$eq(new DurabilityMetricsManager("0", this.metrics(), this.time(), DurabilityMetricsManager$.MODULE$.$lessinit$greater$default$4()));
        this.reporter_$eq(AuditReporter$.MODULE$.apply(this.mManager()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapDistinctTopics() {
        void var9_9;
        void var8_8;
        void var6_6;
        void var5_5;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        TopicPartition tpId2 = new TopicPartition("t2", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var5_5);
        Assertions.assertTrue((boolean)var6_6);
        Tuple2 tuple22 = segmentMap.insert(tpId2, new SegmentRange(15L, 25L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var8_8);
        Assertions.assertTrue((boolean)var9_9);
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SegmentRange[]{new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4())}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId2), (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SegmentRange[]{new SegmentRange(15L, 25L, 0, SegmentRange$.MODULE$.apply$default$4())})))}));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithNoIntersection() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(30L, 40L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SegmentRange[]{new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4()), new SegmentRange(30L, 40L, 0, SegmentRange$.MODULE$.apply$default$4())})))}));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithLeftIntersectionSameRun() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(15L, 25L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SegmentRange[]{new SegmentRange(10L, 25L, 0, SegmentRange$.MODULE$.apply$default$4())})))}));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithLeftIntersectionDifferentRun() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(15L, 25L, 1, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SegmentRange[]{new SegmentRange(10L, 25L, 1, SegmentRange$.MODULE$.apply$default$4())})))}));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithRightIntersection() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(5L, 15L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SegmentRange[]{new SegmentRange(5L, 20L, 0, SegmentRange$.MODULE$.apply$default$4())})))}));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithIntersection() {
        void var17_17;
        void var16_16;
        void var14_14;
        void var13_13;
        void var11_11;
        void var10_10;
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(25L, 30L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        Tuple2 tuple23 = segmentMap.insert(tpId1, new SegmentRange(18L, 24L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        boolean alert3 = tuple23._1$mcZ$sp();
        boolean lapse3 = tuple23._2$mcZ$sp();
        Assertions.assertTrue((boolean)var10_10);
        Assertions.assertTrue((boolean)var11_11);
        Tuple2 tuple24 = segmentMap.insert(tpId1, new SegmentRange(5L, 8L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        boolean alert4 = tuple24._1$mcZ$sp();
        boolean lapse4 = tuple24._2$mcZ$sp();
        Assertions.assertTrue((boolean)var13_13);
        Assertions.assertTrue((boolean)var14_14);
        Tuple2 tuple25 = segmentMap.insert(tpId1, new SegmentRange(2L, 50L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        boolean alert5 = tuple25._1$mcZ$sp();
        boolean lapse5 = tuple25._2$mcZ$sp();
        Assertions.assertTrue((boolean)var16_16);
        Assertions.assertTrue((boolean)var17_17);
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SegmentRange[]{new SegmentRange(2L, 50L, 0, SegmentRange$.MODULE$.apply$default$4())})))}));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithSubsetIntersectionSameRun() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(15L, 18L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertFalse((boolean)var7_7);
        Assertions.assertFalse((boolean)var8_8);
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SegmentRange[]{new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4())})))}));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentMapWithSubsetIntersectionDifferentRun() {
        void var8_8;
        void var7_7;
        void var5_5;
        void var4_4;
        SegmentOffsetMap segmentMap = new SegmentOffsetMap();
        TopicPartition tpId1 = new TopicPartition("t1", 1);
        Tuple2 tuple2 = segmentMap.insert(tpId1, new SegmentRange(10L, 20L, 0, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean alert1 = tuple2._1$mcZ$sp();
        boolean lapse1 = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)var4_4);
        Assertions.assertTrue((boolean)var5_5);
        Tuple2 tuple22 = segmentMap.insert(tpId1, new SegmentRange(15L, 18L, 1, SegmentRange$.MODULE$.apply$default$4()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean alert2 = tuple22._1$mcZ$sp();
        boolean lapse2 = tuple22._2$mcZ$sp();
        Assertions.assertFalse((boolean)var7_7);
        Assertions.assertTrue((boolean)var8_8);
        HashMap expectedMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tpId1), (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SegmentRange[]{new SegmentRange(10L, 20L, 1, SegmentRange$.MODULE$.apply$default$4())})))}));
        Assertions.assertTrue((boolean)segmentMap.getSegmentOffsetMap().equals((Object)expectedMap));
    }

    @Test
    public void testReportDurabilityLapseWithoutIntersectingSegments() {
        this.reporter().resetJob(1);
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        this.reporter().reportDurabilityLapse(this.tpId(), 10L, 5L, DurabilityLapseType$.MODULE$.StartOffset(), "", false);
        Assertions.assertEquals((long)5L, (long)this.mManager().totalLostMessages());
        this.reporter().reportDurabilityLapse(this.tpId(), 20L, 10L, DurabilityLapseType$.MODULE$.StartOffset(), "", false);
        Assertions.assertEquals((long)15L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testReportDurabilityLapseWithIntersectingSegments() {
        this.reporter().resetJob(1);
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        this.reporter().reportDurabilityLapse(this.tpId(), 10L, 5L, DurabilityLapseType$.MODULE$.StartOffset(), "", false);
        Assertions.assertEquals((long)5L, (long)this.mManager().totalLostMessages());
        this.reporter().reportDurabilityLapse(this.tpId(), 12L, 10L, DurabilityLapseType$.MODULE$.StartOffset(), "", false);
        Assertions.assertEquals((long)15L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testReportDurabilityLapseWithIntersectingSubsetSegments() {
        this.reporter().resetJob(1);
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        this.reporter().reportDurabilityLapse(this.tpId(), 10L, 5L, DurabilityLapseType$.MODULE$.StartOffset(), "", false);
        Assertions.assertEquals((long)5L, (long)this.mManager().totalLostMessages());
        this.reporter().reportDurabilityLapse(this.tpId(), 12L, 2L, DurabilityLapseType$.MODULE$.StartOffset(), "", false);
        Assertions.assertEquals((long)5L, (long)this.mManager().totalLostMessages());
    }
}

