/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.util.Properties;
import kafka.server.BrokerConfigHandler;
import kafka.server.ConfigEntityName$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\f\u0019\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00040\u0001\u0001\u0006I\u0001\f\u0005\ba\u0001\u0011\r\u0011\"\u0001,\u0011\u0019\t\u0004\u0001)A\u0005Y!9!\u0007\u0001b\u0001\n\u0003\u0019\u0004BB \u0001A\u0003%A\u0007C\u0005A\u0001\u0001\u0007\t\u0019!C\u0001\u0003\"I\u0001\n\u0001a\u0001\u0002\u0004%\t!\u0013\u0005\n\u001f\u0002\u0001\r\u0011!Q!\n\tC\u0011\u0002\u0015\u0001A\u0002\u0003\u0007I\u0011A)\t\u0013\u0001\u0004\u0001\u0019!a\u0001\n\u0003\t\u0007\"C2\u0001\u0001\u0004\u0005\t\u0015)\u0003S\u0011%!\u0007\u00011AA\u0002\u0013%Q\rC\u0005l\u0001\u0001\u0007\t\u0019!C\u0005Y\"Ia\u000e\u0001a\u0001\u0002\u0003\u0006KA\u001a\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006y\u0002!\t\u0001\u001d\u0005\u0007\u0003\u0007\u0001A\u0011\u00019\t\r\u00055\u0001\u0001\"\u0001q\u0011\u0019\t\t\u0002\u0001C\u0001a\"1\u0011Q\u0003\u0001\u0005\u0002A\u0014qC\u0011:pW\u0016\u00148i\u001c8gS\u001eD\u0015M\u001c3mKJ$Vm\u001d;\u000b\u0005eQ\u0012AB:feZ,'O\u0003\u0002\u001c9\u0005)1.\u00194lC*\tQ$\u0001\u0003v]&$8\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u0019\u0003Q\u0019H/\u0019;jG2+\u0017\rZ3s)\"\u0014x\u000e\u001e;mKV\tA\u0006\u0005\u0002\"[%\u0011aF\t\u0002\u0005\u0019>tw-A\u000bti\u0006$\u0018n\u0019'fC\u0012,'\u000f\u00165s_R$H.\u001a\u0011\u0002-M$\u0018\r^5d\r>dGn\\<feRC'o\u001c;uY\u0016\fqc\u001d;bi&\u001cgi\u001c7m_^,'\u000f\u00165s_R$H.\u001a\u0011\u0002\u0005Q\u0004X#\u0001\u001b\u0011\u0005UjT\"\u0001\u001c\u000b\u0005]B\u0014AB2p[6|gN\u0003\u0002\u001cs)\u0011!hO\u0001\u0007CB\f7\r[3\u000b\u0003q\n1a\u001c:h\u0013\tqdG\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007Q\u0004\b%A\u0007d_:4\u0017n\u001a%b]\u0012dWM]\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011\u0011$\u0012\u0006\u00027%\u0011q\t\u0012\u0002\u0014\u0005J|7.\u001a:D_:4\u0017n\u001a%b]\u0012dWM]\u0001\u0012G>tg-[4IC:$G.\u001a:`I\u0015\fHC\u0001&N!\t\t3*\u0003\u0002ME\t!QK\\5u\u0011\u001dq\u0015\"!AA\u0002\t\u000b1\u0001\u001f\u00132\u00039\u0019wN\u001c4jO\"\u000bg\u000e\u001a7fe\u0002\nQ\"];pi\u0006l\u0015M\\1hKJ\u001cX#\u0001*\u0011\u0005MkfB\u0001+\\\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002Y=\u00051AH]8pizJ\u0011aG\u0005\u00033\u0015K!\u0001\u0018#\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u0005y{&!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u0002]\t\u0006\t\u0012/^8uC6\u000bg.Y4feN|F%Z9\u0015\u0005)\u0013\u0007b\u0002(\r\u0003\u0003\u0005\rAU\u0001\u000fcV|G/Y'b]\u0006<WM]:!\u0003\u001diW\r\u001e:jGN,\u0012A\u001a\t\u0003O&l\u0011\u0001\u001b\u0006\u0003IZJ!A\u001b5\u0003\u000f5+GO]5dg\u0006YQ.\u001a;sS\u000e\u001cx\fJ3r)\tQU\u000eC\u0004O\u001f\u0005\u0005\t\u0019\u00014\u0002\u00115,GO]5dg\u0002\nQa]3u+B$\u0012A\u0013\u0015\u0003#I\u0004\"a\u001d>\u000e\u0003QT!!\u001e<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002xq\u00069!.\u001e9ji\u0016\u0014(BA=<\u0003\u0015QWO\\5u\u0013\tYHO\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003%y\u0004\"a]@\n\u0007\u0005\u0005AOA\u0005BMR,'/R1dQ\u0006\tC/Z:u\u001fZ,'O]5eKN\u0014V\r\u001d7jG\u0006$\u0018n\u001c8UQJ|G\u000f\u001e7fg\"\u001a1#a\u0002\u0011\u0007M\fI!C\u0002\u0002\fQ\u0014A\u0001V3ti\u0006IC/Z:u\u001fZ,'O]5eKN\u0014V\r\u001d7jG\u0006$\u0018n\u001c8UQJ|G\u000f\u001e7fIJ+\u0007\u000f\\5dCND3\u0001FA\u0004\u0003I\"Xm\u001d;SKZ,'\u000f^:CC\u000e\\Gk\\*uCRL7-\u00197msN+GOU3qY&\u001c\u0017\r^5p]RC'o\u001c;uY\u0016\u001c\bfA\u000b\u0002\b\u0005QD/Z:u%\u00164XM\u001d;t\u0005\u0006\u001c7\u000eV8Ti\u0006$\u0018nY1mYf\u001cV\r\u001e*fa2L7-\u0019;j_:$\u0006N]8ui2,GMU3qY&\u001c\u0017m\u001d\u0015\u0004-\u0005\u001d\u0001")
public class BrokerConfigHandlerTest {
    private final long staticLeaderThrottle;
    private final long staticFollowerThrottle;
    private final TopicPartition tp = new TopicPartition("tp", 0);
    private BrokerConfigHandler configHandler;
    private QuotaFactory.QuotaManagers quotaManagers;
    private Metrics metrics;

    public long staticLeaderThrottle() {
        return this.staticLeaderThrottle;
    }

    public long staticFollowerThrottle() {
        return this.staticFollowerThrottle;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public BrokerConfigHandler configHandler() {
        return this.configHandler;
    }

    public void configHandler_$eq(BrokerConfigHandler x$1) {
        this.configHandler = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, "127.0.0.1:9999", TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).head();
        props.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(this.staticLeaderThrottle()));
        props.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), Long.toString(this.staticFollowerThrottle()));
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue());
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.metrics_$eq(new Metrics());
        this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)new MockTime(), "", QuotaFactory$.MODULE$.instantiate$default$5()));
        this.configHandler_$eq(new BrokerConfigHandler(config, this.quotaManagers()));
    }

    @AfterEach
    public void teardown() {
        this.metrics().close();
        this.quotaManagers().shutdown();
    }

    @Test
    public void testOverridesReplicationThrottles() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "333");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "444");
        Assertions.assertEquals((long)Defaults$.MODULE$.QuotaBytesPerSecond(), (long)this.quotaManagers().alterLogDirs().upperBound());
        this.configHandler().processConfigChanges("0", props);
        Assertions.assertEquals((long)333L, (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)444L, (long)this.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)Defaults$.MODULE$.QuotaBytesPerSecond(), (long)this.quotaManagers().alterLogDirs().upperBound());
        Properties propsDefault = new Properties();
        propsDefault.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "555");
        this.configHandler().processConfigChanges(ConfigEntityName$.MODULE$.Default(), propsDefault);
        Assertions.assertEquals((long)333L, (long)this.quotaManagers().leader().upperBound());
        this.configHandler().processConfigChanges("0", new Properties());
        Assertions.assertEquals((long)555L, (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)this.staticFollowerThrottle(), (long)this.quotaManagers().follower().upperBound());
        Properties props2 = new Properties();
        props2.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "666");
        this.configHandler().processConfigChanges("1", props2);
        Assertions.assertEquals((long)555L, (long)this.quotaManagers().leader().upperBound());
        this.configHandler().processConfigChanges(ConfigEntityName$.MODULE$.Default(), new Properties());
        Assertions.assertEquals((long)this.staticLeaderThrottle(), (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)this.staticFollowerThrottle(), (long)this.quotaManagers().follower().upperBound());
    }

    @Test
    public void testOverridesReplicationThrottledReplicas() {
        Properties props = new Properties();
        Assertions.assertTrue((boolean)this.quotaManagers().leader().isThrottled(this.tp()));
        Assertions.assertFalse((boolean)this.quotaManagers().follower().isThrottled(this.tp()));
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue());
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue());
        this.configHandler().processConfigChanges("0", props);
        Assertions.assertFalse((boolean)this.quotaManagers().leader().isThrottled(this.tp()), (String)"expected leader throttle to be disabled after dynamic reconfiguration");
        Assertions.assertTrue((boolean)this.quotaManagers().follower().isThrottled(this.tp()), (String)"expected follower throttle to be enabled after dynamic reconfiguration");
    }

    @Test
    public void testRevertsBackToStaticallySetReplicationThrottles() {
        Properties props = new Properties();
        Assertions.assertTrue((boolean)this.quotaManagers().leader().isThrottled(this.tp()));
        Assertions.assertFalse((boolean)this.quotaManagers().follower().isThrottled(this.tp()));
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue());
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue());
        this.configHandler().processConfigChanges("0", props);
        Assertions.assertFalse((boolean)this.quotaManagers().leader().isThrottled(this.tp()), (String)"Dynamic broker throttle setting should override the static one");
        Assertions.assertTrue((boolean)this.quotaManagers().follower().isThrottled(this.tp()));
        this.configHandler().processConfigChanges("0", new Properties());
        Assertions.assertTrue((boolean)this.quotaManagers().leader().isThrottled(this.tp()), (String)"expected leader throttle to be enabled after resetting to static config");
        Assertions.assertFalse((boolean)this.quotaManagers().follower().isThrottled(this.tp()), (String)"expected follower throttle to be disabled after resetting to static config");
    }

    @Test
    public void testRevertsBackToStaticallySetReplicationThrottledReplicas() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "333");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "444");
        this.configHandler().processConfigChanges("0", props);
        Assertions.assertEquals((long)333L, (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)444L, (long)this.quotaManagers().follower().upperBound());
        this.configHandler().processConfigChanges("0", new Properties());
        Assertions.assertEquals((long)this.staticLeaderThrottle(), (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)this.staticFollowerThrottle(), (long)this.quotaManagers().follower().upperBound());
    }

    public BrokerConfigHandlerTest() {
        this.staticLeaderThrottle = 111L;
        this.staticFollowerThrottle = 222L;
    }
}

