/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import kafka.log.LogConfig;
import kafka.log.MergedLog$;
import kafka.restore.operators.FtpsSegmentView;
import kafka.restore.operators.RestorePartitionOperator;
import kafka.server.Defaults$;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001\u0002\u0016,\u0001IBQ!\u000f\u0001\u0005\u0002iBQ!\u0010\u0001\u0005\u0002yBQA\u0011\u0001\u0005\u0002yBQa\u0011\u0001\u0005\u0002yBQ\u0001\u0012\u0001\u0005\u0002\u0015Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004U\u0001\u0001\u0006I!\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0011\u0019Q\u0006\u0001)A\u0005/\"91\f\u0001b\u0001\n\u0003a\u0006BB3\u0001A\u0003%Q\fC\u0004g\u0001\t\u0007I\u0011A4\t\r-\u0004\u0001\u0015!\u0003i\u0011\u001da\u0007A1A\u0005\u00025Da!\u001d\u0001!\u0002\u0013q\u0007b\u0002:\u0001\u0005\u0004%\ta\u001d\u0005\u0007y\u0002\u0001\u000b\u0011\u0002;\t\u000fu\u0004!\u0019!C\u0001g\"1a\u0010\u0001Q\u0001\nQD\u0001b \u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0004!I\u00111\u0004\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002 !I\u0011\u0011\u0006\u0001C\u0002\u0013\u0005\u00111\u0006\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002.!I\u00111\b\u0001C\u0002\u0013\u0005\u0011Q\b\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002@!A\u0011\n\u0001b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA&\u0011%\t\u0019\u0006\u0001b\u0001\n\u0003\t)\u0006\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA,\u0011%\t)\u0007\u0001b\u0001\n\u0003\t9\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA5\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!!&\u0001\t\u0003\t9\bC\u0004\u0002 \u0002!\t!a\u001e\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0007bBAo\u0001\u0011%\u0011q\u001c\u0005\t\u0003s\u0004!\u0019!C\u0005!\"9\u00111 \u0001!\u0002\u0013\t&!\b*fgR|'/\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$Vm\u001d;\u000b\u00051j\u0013!\u0002;p_2\u001c(B\u0001\u00180\u0003\u0015Y\u0017MZ6b\u0015\u0005\u0001\u0014\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001e\u0011\u0005q\u0002Q\"A\u0016\u0002\u001f\rDWmY6tk6,e.\u00192mK\u0012,\u0012a\u0010\t\u0003i\u0001K!!Q\u001b\u0003\u000f\t{w\u000e\\3b]\u0006IB/[3s\u00072,\u0017M\\3s\r\u0016\fG/\u001e:f\u000b:\f'\r\\3e\u0003\u001d\"\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3DY\u0016\fg.\u001e9GK\u0006$XO]3F]\u0006\u0014G.\u001a3\u0002\u001b\rdW-\u00198va\u000e{gNZ5h+\u00051\u0005CA$N\u001b\u0005A%BA%K\u0003\u0015\u0019H/\u0019;f\u0015\tYE*\u0001\u0003uS\u0016\u0014(\"\u0001\u0018\n\u00059C%a\b+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cE.Z1okB\u001cuN\u001c4jO\u0006q1\r\\3b]V\u0004H)\u001a7bs6\u001bX#A)\u0011\u0005Q\u0012\u0016BA*6\u0005\u0011auN\\4\u0002\u001f\rdW-\u00198va\u0012+G.Y=Ng\u0002\n\u0011c\u00197fC:,\b/\u00138uKJ4\u0018\r\\'t+\u00059\u0006C\u0001\u001bY\u0013\tIVGA\u0002J]R\f!c\u00197fC:,\b/\u00138uKJ4\u0018\r\\'tA\u0005\t2\r[3dWN,X.\u00117h_JLG\u000f[7\u0016\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\u0011\rDWmY6tk6T!A\u0019'\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0011|&!C!mO>\u0014\u0018\u000e\u001e5n\u0003I\u0019\u0007.Z2lgVl\u0017\t\\4pe&$\b.\u001c\u0011\u0002!M,\b/\u001a:CY>\u001c7\u000eT3oORDW#\u00015\u0011\u0005QJ\u0017B\u000166\u0005\u0015\u0019\u0006n\u001c:u\u0003E\u0019X\u000f]3s\u00052|7m\u001b'f]\u001e$\b\u000eI\u0001\bM\u0006\u001cGo\u001c:z+\u0005q\u0007CA$p\u0013\t\u0001\bJA\rUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)Y2u_JL\u0018\u0001\u00034bGR|'/\u001f\u0011\u0002\u0013A\f'/\u001a8u\t&\u0014X#\u0001;\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018AA5p\u0015\u0005I\u0018\u0001\u00026bm\u0006L!a\u001f<\u0003\t\u0019KG.Z\u0001\u000ba\u0006\u0014XM\u001c;ESJ\u0004\u0013a\u00013je\u0006!A-\u001b:!\u0003\t!\b/\u0006\u0002\u0002\u0004A!\u0011QAA\u000b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011AB2p[6|gNC\u0002/\u0003\u001bQA!a\u0004\u0002\u0012\u00051\u0011\r]1dQ\u0016T!!a\u0005\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0018\u0005\u001d!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013\u0001\u0002;qS\u0012,\"!a\b\u0011\t\u0005\u0005\u00121E\u0007\u0002\u0015&\u0019\u0011Q\u0005&\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017!\u0002;qS\u0012\u0004\u0013\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0006\u0002\u0002.A!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u000241\u000baa]3sm\u0016\u0014\u0018\u0002BA\u001c\u0003c\u0011A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017!\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000eI\u0001\u0005i&lW-\u0006\u0002\u0002@A!\u0011\u0011IA\"\u001b\u0005\t\u0017bAA#C\nAQj\\2l)&lW-A\u0003uS6,\u0007%\u0006\u0002\u0002LA\u0019q)!\u0014\n\u0007\u0005=\u0003J\u0001\fGS2,G+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0003\u0019\u0019H/\u0019;fA\u0005IAn\\4D_:4\u0017nZ\u000b\u0003\u0003/\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;b\u0015a\u00017pO&!\u0011\u0011MA.\u0005%aunZ\"p]\u001aLw-\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\n!cY8oM2,XM\u001c;M_\u001e\u001cuN\u001c4jOV\u0011\u0011\u0011\u000e\t\u0005\u0003W\nyGD\u0002\u0002nyi\u0011\u0001A\u0005\u0005\u0003c\nyF\u0001\nD_:4G.^3oi2{wmQ8oM&<\u0017aE2p]\u001adW/\u001a8u\u0019><7i\u001c8gS\u001e\u0004\u0013!B:fiV\u0004HCAA=!\r!\u00141P\u0005\u0004\u0003{*$\u0001B+oSRD3AIAA!\u0011\t\u0019)!%\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b1!\u00199j\u0015\u0011\tY)!$\u0002\u000f),\b/\u001b;fe*!\u0011qRA\t\u0003\u0015QWO\\5u\u0013\u0011\t\u0019*!\"\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hm\\<oQ\r\u0019\u0013\u0011\u0014\t\u0005\u0003\u0007\u000bY*\u0003\u0003\u0002\u001e\u0006\u0015%!C!gi\u0016\u0014X)Y2i\u0003Y!Xm\u001d;Va\u0012\fG/Z*fO6,g\u000e^*uCR,\u0007f\u0001\u0013\u0002$B!\u00111QAS\u0013\u0011\t9+!\"\u0003\tQ+7\u000f^\u0001\u0019kBdw.\u00193J]&$\u0018\r^3B]\u0012\u001cu.\u001c9mKR,GCDA=\u0003[\u000b\t,!1\u0002F\u0006%\u0017Q\u001a\u0005\u0007\u0003_+\u0003\u0019A,\u0002\u000b\u0015\u0004xn\u00195\t\u000f\u0005MV\u00051\u0001\u00026\u0006AqN\u00196fGRLE\r\u0005\u0003\u00028\u0006uVBAA]\u0015\r\tY\f_\u0001\u0005kRLG.\u0003\u0003\u0002@\u0006e&\u0001B+V\u0013\u0012Ca!a1&\u0001\u0004\t\u0016aC:uCJ$xJ\u001a4tKRDa!a2&\u0001\u0004\t\u0016!C3oI>3gm]3u\u0011\u0019\tY-\na\u0001/\u0006!1/\u001b>f\u0011\u0019\ty-\na\u0001#\u0006aQ.\u0019=US6,7\u000f^1na\u0006IB-\u001a7fi\u0016Le.\u001b;jCR,\u0017I\u001c3D_6\u0004H.\u001a;f)!\tI(!6\u0002X\u0006e\u0007BBAXM\u0001\u0007q\u000bC\u0004\u00024\u001a\u0002\r!!.\t\r\u0005mg\u00051\u0001R\u0003A!W\r\\3uK\u000e{W\u000e\u001d7fi\u0016$6/\u0001\thKR$\u0016.\u001a:Ti\u0006$XMR5mKR!\u0011\u0011]A|!\u0011\t\u0019/!=\u000f\t\u0005\u0015\u0018Q\u001e\t\u0004\u0003O,TBAAu\u0015\r\tY/M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=X'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\f)P\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_,\u0004\"B?(\u0001\u0004!\u0018!E8oK6Kg.\u001e;f\u0013:l\u0015\u000e\u001c7jg\u0006\u0011rN\\3NS:,H/Z%o\u001b&dG.[:!\u0001")
public class RestoreTierPartitionStateTest {
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final Algorithm checksumAlgorithm = this.checksumEnabled() ? Algorithm.ADLER : Algorithm.NO_CHECKSUM;
    private final short superBlockLength = (short)(this.checksumEnabled() ? 512 : 0);
    private final TierPartitionStateFactory factory = new TierPartitionStateFactory(true, this.checksumEnabled(), this.tierCleanerFeatureEnabled(), this.cleanupConfig());
    private final File parentDir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
    private final TopicPartition tp = MergedLog$.MODULE$.parseTopicPartitionName(this.dir());
    private final TopicIdPartition tpid = new TopicIdPartition(this.tp().topic(), UUID.randomUUID(), this.tp().partition());
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
    private final MockTime time = new MockTime();
    private final FileTierPartitionState state = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.tierCleanerFeatureEnabled(), (Time)this.time(), this.cleanupConfig());
    private final LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
    private final LogConfig.ConfluentLogConfig confluentLogConfig = (LogConfig.ConfluentLogConfig)Mockito.mock(LogConfig.ConfluentLogConfig.class);
    private final long oneMinuteInMillis;

    public boolean checksumEnabled() {
        return false;
    }

    public boolean tierCleanerFeatureEnabled() {
        return false;
    }

    public boolean tierPartitionStateCleanupFeatureEnabled() {
        return false;
    }

    public TierPartitionStateCleanupConfig cleanupConfig() {
        return new TierPartitionStateCleanupConfig(this.tierPartitionStateCleanupFeatureEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs());
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public short superBlockLength() {
        return this.superBlockLength;
    }

    public TierPartitionStateFactory factory() {
        return this.factory;
    }

    public File parentDir() {
        return this.parentDir;
    }

    public File dir() {
        return this.dir;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime time() {
        return this.time;
    }

    public FileTierPartitionState state() {
        return this.state;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public LogConfig.ConfluentLogConfig confluentLogConfig() {
        return this.confluentLogConfig;
    }

    @BeforeEach
    public void setup() {
        this.state().setTopicId(this.tpid().topicId());
        this.state().setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(RestoreTierPartitionStateTest.$anonfun$setup$2(this, op)));
                return;
            }
        });
        this.state().beginCatchup();
        this.state().onCatchUpComplete();
        Mockito.when((Object)this.logConfig().confluentLogConfig()).thenReturn((Object)this.confluentLogConfig());
        Mockito.when((Object)this.confluentLogConfig().tierEnable()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(true));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.state().close();
        this.dir().delete();
        this.parentDir().delete();
    }

    @Test
    public void testUpdateSegmentState() {
        int epoch = 3;
        int numOffsetsInSegment = 49;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef baseOffset = IntRef.create((int)0);
        long start = System.currentTimeMillis();
        LongRef timestamp = LongRef.create((long)start);
        ArrayBuffer objectIds = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            int endOffset = baseOffset$1.elem + numOffsetsInSegment;
            UUID objectId = UUID.randomUUID();
            objectIds.$plus$eq((Object)objectId);
            this.uploadInitateAndComplete(epoch, objectId, baseOffset$1.elem, endOffset, 100, timestamp$1.elem);
            timestamp$1.elem += this.oneMinuteInMillis();
            baseOffset$1.elem = endOffset + 1;
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.deleteInitiateAndComplete(epoch, (UUID)objectIds.apply(i), start));
        this.state().close();
        RestorePartitionOperator restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis());
        FtpsSegmentView operatorContext = restoreOperator.operatorContext();
        long headerSize = operatorContext.header().size();
        Assertions.assertEquals((long)150L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((int)3, (int)operatorContext.segmentStateMap().size());
        Assertions.assertEquals((int)2, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)1, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        Map pathmap = (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(restoreOperator.restore()).asScala();
        Assertions.assertEquals((long)50L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((long)headerSize, (long)operatorContext.header().size());
        Assertions.assertEquals((int)2, (int)pathmap.size());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> Assertions.assertTrue((boolean)pathmap.keySet().contains(objectIds.apply(index))));
        restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis());
        operatorContext = restoreOperator.operatorContext();
        Assertions.assertEquals((long)50L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((long)headerSize, (long)operatorContext.header().size());
        Assertions.assertEquals((int)0, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)3, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.tierCleanerFeatureEnabled(), (Time)this.time(), this.cleanupConfig());
        TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, null, null, this.tierPartitionStateCleanupFeatureEnabled(), start);
        reopenedState.close();
    }

    private void uploadInitateAndComplete(int epoch, UUID objectId, long startOffset, long endOffset, int size, long maxTimestamp) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, startOffset, endOffset, maxTimestamp, -1L, size, false, false, false, TierUploadType.Archive, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private void deleteInitiateAndComplete(int epoch, UUID objectId, long deleteCompleteTs) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId, stateOffset, deleteCompleteTs), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private String getTierStateFile(File dir) {
        Object object = new Object();
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
                RestoreTierPartitionStateTest.$anonfun$getTierStateFile$1(object, file);
                return BoxedUnit.UNIT;
            });
            return null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (String)ex.value();
            }
            throw ex;
        }
    }

    private long oneMinuteInMillis() {
        return this.oneMinuteInMillis;
    }

    public static final /* synthetic */ String $anonfun$setup$2(RestoreTierPartitionStateTest $this, TierPartitionState.RecoveryOperation op$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append($this.state().topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$getTierStateFile$1(Object nonLocalReturnKey1$1, File file) {
        if (file.isFile() && MergedLog$.MODULE$.isTierStateFile(file)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)file.getAbsolutePath());
        }
    }

    public RestoreTierPartitionStateTest() {
        this.cleanupIntervalMs = 0;
        this.oneMinuteInMillis = 60000L;
    }
}

