/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.availability;

import io.confluent.kafka.availability.NetworkAvailabilityManager$;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mr!\u0002\f\u0018\u0011\u0003\u0001c!\u0002\u0012\u0018\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0005\u0004%\t!\f\u0005\u0007m\u0005\u0001\u000b\u0011\u0002\u0018\t\u000f]\n!\u0019!C\u0001[!1\u0001(\u0001Q\u0001\n92AAI\f\u0001s!)!f\u0002C\u0001\u0015\"9Aj\u0002b\u0001\n\u001bi\u0005B\u0002-\bA\u00035a\nC\u0004Z\u000f\t\u0007IQB'\t\ri;\u0001\u0015!\u0004O\u0011\u001dYvA1A\u0005\u000e5Ca\u0001X\u0004!\u0002\u001bq\u0005bB/\b\u0005\u0004%iA\u0018\u0005\u0007S\u001e\u0001\u000bQB0\t\u000b)<A\u0011I6\t\u000f\u0005\u0005r\u0001\"\u0003\u0002$!9\u0011QF\u0004\u0005\u0002\u0005=\u0002bBA\u001c\u000f\u0011\u0005\u0011q\u0006\u0005\b\u0003s9A\u0011AA\u0018\u0003iqU\r^<pe.\fe/Y5mC\nLG.\u001b;z\u001b\u0006t\u0017mZ3s\u0015\tA\u0012$\u0001\u0007bm\u0006LG.\u00192jY&$\u0018P\u0003\u0002\u001b7\u0005)1.\u00194lC*\u0011A$H\u0001\nG>tg\r\\;f]RT\u0011AH\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002\"\u00035\tqC\u0001\u000eOKR<xN]6Bm\u0006LG.\u00192jY&$\u00180T1oC\u001e,'o\u0005\u0002\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0011\u0002K\r{eJT#D)&{ej\u0018)J\u001d\u001e\u001bvl\u0011'J\u000b:#vlU(G)^\u000b%+R0O\u00036+U#\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001\u00027b]\u001eT\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\t11\u000b\u001e:j]\u001e\faeQ(O\u001d\u0016\u001bE+S(O?BKejR*`\u00072KUI\u0014+`'>3EkV!S\u000b~s\u0015)T#!\u0003YAU)\u0011'U\u0011~\u001b\u0005*R\"L?\u000ec\u0015*\u0012(U?&#\u0015a\u0006%F\u00032#\u0006jX\"I\u000b\u000e[ul\u0011'J\u000b:#v,\u0013#!'\r9!(\u0010\t\u0003_mJ!\u0001\u0010\u0019\u0003\r=\u0013'.Z2u!\tq\u0004*D\u0001@\u0015\t\u0001\u0015)A\u0004oKR<xN]6\u000b\u0005\t\u001b\u0015AB2p[6|gN\u0003\u0002\u001b\t*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tIuHA\bSKF,Xm\u001d;DC2d'-Y2l)\u0005Y\u0005CA\u0011\b\u0003Y\u0019wN\u001c8fGRLwN\u001c)j]\u001e\u001c8i\\;oi\u0016\u0014X#\u0001(\u0011\u0005=3V\"\u0001)\u000b\u0005E\u0013\u0016AB1u_6L7M\u0003\u0002T)\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U\u0013\u0014\u0001B;uS2L!a\u0016)\u0003\u0015\u0005#x.\\5d\u0019>tw-A\fd_:tWm\u0019;j_:\u0004\u0016N\\4t\u0007>,h\u000e^3sA\u00059R\r\u001f;fe:\fGNU3rk\u0016\u001cHo]\"pk:$XM]\u0001\u0019Kb$XM\u001d8bYJ+\u0017/^3tiN\u001cu.\u001e8uKJ\u0004\u0013A\u00075fC2$\bn\u00115fG.\u0014V-];fgR\u001c8i\\;oi\u0016\u0014\u0018a\u00075fC2$\bn\u00115fG.\u0014V-];fgR\u001c8i\\;oi\u0016\u0014\b%\u0001\nce>\\WM\u001d#je\u0016\u001cG/\u001a3Ba&\u001cX#A0\u0011\u0007\u0001\f7-D\u0001U\u0013\t\u0011GKA\u0004F]Vl7+\u001a;\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\f\u0015\u0001\u00039s_R|7m\u001c7\n\u0005!,'aB!qS.+\u0017p]\u0001\u0014EJ|7.\u001a:ESJ,7\r^3e\u0003BL7\u000fI\u0001\n_:\u0014V-];fgR$R\u0001\\8z\u0003\u0007\u0001\"!J7\n\u000594#\u0001B+oSRDQ\u0001]\tA\u0002E\f\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001B1vi\"T!A^!\u0002\u0011M,7-\u001e:jifL!\u0001_:\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\")!0\u0005a\u0001w\u00069!/Z9vKN$\bC\u0001?\u0000\u001b\u0005i(B\u0001@B\u0003!\u0011X-];fgR\u001c\u0018bAA\u0001{\ny\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0004\u0002\u0006E\u0001\r!a\u0002\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u0003R\u0001YA\u0005\u0003\u001bI1!a\u0003U\u0005!y\u0005\u000f^5p]\u0006d\u0007\u0003BA\b\u0003;qA!!\u0005\u0002\u001aA\u0019\u00111\u0003\u0014\u000e\u0005\u0005U!bAA\f?\u00051AH]8pizJ1!a\u0007'\u0003\u0019\u0001&/\u001a3fM&\u0019Q'a\b\u000b\u0007\u0005ma%A\njg\"+\u0017\r\u001c;i\u0007\",7m[\"mS\u0016tG\u000f\u0006\u0003\u0002&\u0005-\u0002cA\u0013\u0002(%\u0019\u0011\u0011\u0006\u0014\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0001\nA\u0002\u0005\u001d\u0011aD2p]:,7\r^5p]BKgnZ:\u0016\u0005\u0005E\u0002cA\u0013\u00024%\u0019\u0011Q\u0007\u0014\u0003\t1{gnZ\u0001\u0011Kb$XM\u001d8bYJ+\u0017/^3tiN\f1\u0003[3bYRD7\t[3dWJ+\u0017/^3tiN\u0004")
public class NetworkAvailabilityManager
implements RequestCallback {
    private final AtomicLong connectionPingsCounter = new AtomicLong();
    private final AtomicLong externalRequestsCounter = new AtomicLong();
    private final AtomicLong healthCheckRequestsCounter = new AtomicLong();
    private final EnumSet<ApiKeys> brokerDirectedApis = EnumSet.of(ApiKeys.PRODUCE, (Enum[])new ApiKeys[]{ApiKeys.FETCH, ApiKeys.DELETE_RECORDS, ApiKeys.LIST_OFFSETS, ApiKeys.OFFSET_FOR_LEADER_EPOCH, ApiKeys.OFFSET_COMMIT, ApiKeys.OFFSET_FETCH, ApiKeys.JOIN_GROUP, ApiKeys.HEARTBEAT, ApiKeys.LEAVE_GROUP, ApiKeys.SYNC_GROUP, ApiKeys.DESCRIBE_GROUPS, ApiKeys.LIST_GROUPS, ApiKeys.TXN_OFFSET_COMMIT, ApiKeys.ADD_PARTITIONS_TO_TXN, ApiKeys.ADD_OFFSETS_TO_TXN, ApiKeys.END_TXN, ApiKeys.DESCRIBE_PRODUCERS, ApiKeys.DESCRIBE_TRANSACTIONS, ApiKeys.LIST_TRANSACTIONS});

    public static String HEALTH_CHECK_CLIENT_ID() {
        return NetworkAvailabilityManager$.MODULE$.HEALTH_CHECK_CLIENT_ID();
    }

    public static String CONNECTION_PINGS_CLIENT_SOFTWARE_NAME() {
        return NetworkAvailabilityManager$.MODULE$.CONNECTION_PINGS_CLIENT_SOFTWARE_NAME();
    }

    private final AtomicLong connectionPingsCounter() {
        return this.connectionPingsCounter;
    }

    private final AtomicLong externalRequestsCounter() {
        return this.externalRequestsCounter;
    }

    private final AtomicLong healthCheckRequestsCounter() {
        return this.healthCheckRequestsCounter;
    }

    private final EnumSet<ApiKeys> brokerDirectedApis() {
        return this.brokerDirectedApis;
    }

    public void onRequest(KafkaPrincipal principal, AbstractRequest request, Optional<String> clientID) {
        if (request.apiKey() == ApiKeys.API_VERSIONS) {
            String string = ((ApiVersionsRequest)request).data().clientSoftwareName();
            String string2 = NetworkAvailabilityManager$.MODULE$.CONNECTION_PINGS_CLIENT_SOFTWARE_NAME();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.connectionPingsCounter().getAndIncrement();
            }
        }
        boolean bl = false;
        MultiTenantPrincipal multiTenantPrincipal = null;
        if (principal instanceof MultiTenantPrincipal) {
            bl = true;
            multiTenantPrincipal = (MultiTenantPrincipal)principal;
            if (!multiTenantPrincipal.tenantMetadata().isHealthcheckTenant && this.brokerDirectedApis().contains(request.apiKey())) {
                this.externalRequestsCounter().getAndIncrement();
                return;
            }
        }
        if (bl && multiTenantPrincipal.tenantMetadata().isHealthcheckTenant && this.isHealthCheckClient(clientID)) {
            this.healthCheckRequestsCounter().getAndIncrement();
            return;
        }
    }

    private boolean isHealthCheckClient(Optional<String> clientID) {
        if (clientID.isPresent()) {
            String string = clientID.get();
            String string2 = NetworkAvailabilityManager$.MODULE$.HEALTH_CHECK_CLIENT_ID();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
        }
        return false;
    }

    public long connectionPings() {
        return this.connectionPingsCounter().get();
    }

    public long externalRequests() {
        return this.externalRequestsCounter().get();
    }

    public long healthCheckRequests() {
        return this.healthCheckRequestsCounter().get();
    }
}

