/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.clients.CloudAdmin;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerHealthCommandOptions;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.BrokerHealthStatusResult;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.clients.admin.DescribeBrokerHealthOptions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class BrokerHealthCommand$
implements Logging {
    public static BrokerHealthCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new BrokerHealthCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                exitCode = 1;
                this.printException(e);
            }
        }
        catch (Throwable throwable) {
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
        throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
    }

    public void run(String[] args, Option<CloudAdmin> clientOption) {
        BrokerHealthCommandOptions opts = (BrokerHealthCommandOptions)((Object)new Some((Object)new BrokerHealthCommandOptions(args)).get());
        try (CloudAdmin client = (CloudAdmin)clientOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.createAdminClient(opts));){
            try {
                if (opts.options.has((OptionSpec)opts.describeOpt())) {
                    this.describeBrokerHealth(client);
                } else {
                    this.alterBrokerHealth(client, opts);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
    }

    public Option<CloudAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void printException(Throwable e) {
        Predef$.MODULE$.println((Object)new StringBuilder(44).append("Error while running broker health command : ").append(e.getMessage()).toString());
    }

    private void describeBrokerHealth(CloudAdmin client) {
        ((Collection)client.describeBrokerHealth(new DescribeBrokerHealthOptions()).future().get()).forEach(result -> {
            Predef$.MODULE$.println((Object)new StringBuilder(18).append("\tDegraded Broker: ").append(result.brokerId()).toString());
            MODULE$.printDegradedBrokerComponents(result.degradedBrokerComponents());
            Predef$.MODULE$.println();
            Predef$.MODULE$.println();
        });
    }

    private void printDegradedBrokerComponents(Set<DegradedBrokerComponent> degradedBrokerComponents) {
        degradedBrokerComponents.forEach(degradedBrokerComponent -> {
            Predef$.MODULE$.println((Object)new StringBuilder(22).append("\t\tDegraded Component: ").append(degradedBrokerComponent.brokerComponent()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(10).append("\t\tReason: ").append(degradedBrokerComponent.reason()).toString());
        });
    }

    private void alterBrokerHealth(CloudAdmin client, BrokerHealthCommandOptions opts) {
        int controllerId;
        ComponentHealthStatus componentHealthStatus = this.parseHealthStatus(((String)opts.options.valueOf(opts.healthStatusOpt())).toUpperCase());
        BrokerComponent brokerComponent = this.parseBrokerComponent(((String)opts.options.valueOf(opts.componentOpt())).toUpperCase());
        scala.collection.immutable.Set<Integer> brokerIds = this.parseBrokerIds((String)opts.options.valueOf(opts.brokerIdsOpt()));
        if (brokerIds.contains((Object)(controllerId = ((Node)client.describeCluster().controller().get()).id()))) {
            ComponentHealthStatus componentHealthStatus2 = componentHealthStatus;
            ComponentHealthStatus componentHealthStatus3 = ComponentHealthStatus.DEGRADED;
            if (!(componentHealthStatus2 != null ? !componentHealthStatus2.equals(componentHealthStatus3) : componentHealthStatus3 != null)) {
                Predef$.MODULE$.println((Object)new StringBuilder(73).append("The controller:(").append(controllerId).append(")'s ").append(brokerComponent.name()).append(" component health status is being marked as DEGRADED.").toString());
            }
        }
        AlterBrokerHealthSpec requestData = new AlterBrokerHealthSpec((Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.parseBrokerIds((String)opts.options.valueOf(opts.brokerIdsOpt()))).asJava(), brokerComponent, componentHealthStatus, (String)opts.options.valueOf(opts.reasonOpt()), opts.options.has((OptionSpec)opts.forceOpt()));
        client.alterBrokerHealth(requestData, new AlterBrokerHealthOptions()).values().forEach((x0$1, x1$1) -> {
            Integer brokerId = x0$1;
            try {
                BrokerHealthStatusResult result = (BrokerHealthStatusResult)x1$1.get();
                Predef$.MODULE$.print((Object)new StringBuilder(9).append("\tBroker: ").append(result.brokerId()).toString());
                Predef$.MODULE$.print((Object)new StringBuilder(13).append("\t\tComponent: ").append(result.brokerComponent()).toString());
                Predef$.MODULE$.print((Object)new StringBuilder(9).append("\t\tState: ").append(result.componentHealthStatus()).toString());
                Predef$.MODULE$.println();
                return;
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    MODULE$.printBrokerFailedMessage(e.getCause(), brokerId);
                    return;
                }
                MODULE$.printBrokerFailedMessage(e, brokerId);
                return;
            }
            catch (InterruptedException e) {
                MODULE$.printBrokerFailedMessage(e, brokerId);
                return;
            }
        });
    }

    private void printBrokerFailedMessage(Throwable throwable, Integer brokerId) {
        Predef$.MODULE$.print((Object)new StringBuilder(19).append("\tBroker: ").append(brokerId).append("\tFailed: ").append(throwable.getMessage()).append("\n").toString());
    }

    private CloudAdmin createAdminClient(BrokerHealthCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options.valueOf(opts.bootstrapServer()));
        return CloudAdmin.create((Properties)props);
    }

    private scala.collection.immutable.Set<Integer> parseBrokerIds(String brokerIdsString) {
        new StringOps(Predef$.MODULE$.augmentString(brokerIdsString)).foreach((Function1 & Serializable & scala.Serializable)ch -> {
            BrokerHealthCommand$.$anonfun$parseBrokerIds$1(brokerIdsString, BoxesRunTime.unboxToChar((Object)ch));
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokerIdsString.split(","))).map((Function1 & Serializable & scala.Serializable)brokerId -> Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(brokerId)).toInt()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    private ComponentHealthStatus parseHealthStatus(String healthStatusString) {
        void var2_2;
        ComponentHealthStatus healthStatus = ComponentHealthStatus.forString((String)healthStatusString);
        if (healthStatus.equals((Object)ComponentHealthStatus.UNKNOWN)) {
            throw new AdminOperationException(new StringBuilder(68).append("Broker component: ").append(healthStatusString).append(" is not valid. Must be one of HEALTHY or DEGRADED.").toString());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private BrokerComponent parseBrokerComponent(String brokerComponentString) {
        void var2_2;
        BrokerComponent brokerComponent = BrokerComponent.forString((String)brokerComponentString);
        if (brokerComponent.equals((Object)BrokerComponent.UNKNOWN)) {
            throw new AdminOperationException(new StringBuilder(71).append("Broker component: ").append(brokerComponentString).append(" is not valid. Must be one of UNSPECIFIED or STORAGE.").toString());
        }
        if (brokerComponent.equals((Object)BrokerComponent.NETWORK)) {
            throw new UnsupportedOperationException(new StringBuilder(113).append("Broker component: ").append(brokerComponent).append(" is not currently supported. Please use component UNSPECIFIED if you wish to demote the broker.").toString());
        }
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$parseBrokerIds$1(String brokerIdsString$1, char ch) {
        if (!((Object)BoxesRunTime.boxToCharacter((char)ch)).equals(BoxesRunTime.boxToCharacter((char)',')) && !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(ch))) {
            throw new AdminOperationException(new StringBuilder(54).append("Broker ids: ").append(brokerIdsString$1).append(", must not include invalid character - '").append(ch).append("'.").toString());
        }
    }

    private BrokerHealthCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

