/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtils$;
import kafka.admin.ClusterLinkCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.TopicFilterJson;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkCommand$
implements Logging {
    public static ClusterLinkCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ClusterLinkCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(44).append("Error while executing cluster link command: ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(ClusterLinkCommand$.$anonfun$main$1(e)));
                }
                exitCode = 1;
            }
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    private ConfluentAdmin createAdminClient(ClusterLinkCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options.valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)AdminClient.create((Properties)props);
    }

    /*
     * WARNING - void declaration
     */
    private String verifyPropertyAndFilters(ClusterLinkCommandOptions opts, Properties props, String propName, ArgumentAcceptingOptionSpec<String> jsonFileOpt, ArgumentAcceptingOptionSpec<String> filterJsonOpt) {
        void var8_9;
        boolean bl;
        String string;
        boolean isSourceLink = Option$.MODULE$.apply((Object)props.getProperty(ClusterLinkConfig$.MODULE$.LinkModeProp())).contains((Object)ClusterLinkConfig.LinkMode.SOURCE.name());
        boolean propValue = props.getProperty(propName, "false").equals("true");
        if (opts.options.has(jsonFileOpt)) {
            string = Utils.readFileAsString((String)opts.valueOf(jsonFileOpt));
            bl = false;
        } else if (opts.options.has(filterJsonOpt)) {
            string = opts.valueOf(filterJsonOpt);
            bl = true;
        } else {
            string = "";
            bl = false;
        }
        boolean bl2 = bl;
        String jsonString = string;
        if (isSourceLink) {
            if (propValue) {
                Predef$.MODULE$.println((Object)new StringBuilder(42).append("Ignoring ").append(propName).append(" for source cluster link creation").toString());
                props.remove(propName);
            }
            if (new StringOps(Predef$.MODULE$.augmentString((String)var8_9)).nonEmpty()) {
                String optionName = bl2 ? (String)filterJsonOpt.options().get(0) : (String)jsonFileOpt.options().get(0);
                Predef$.MODULE$.println((Object)new StringBuilder(42).append("Ignoring ").append(optionName).append(" for source cluster link creation").toString());
            }
            return "";
        }
        if (propValue && var8_9.trim().isEmpty()) {
            opts.printMessageAndExit(new StringBuilder(151).append(propName).append(" is set to true but the JSON filters are not passed in. Please pass").append(" in the path to the JSON file using the --").append(jsonFileOpt.options().get(0)).append(" option and rerun the create link command.").toString());
        }
        if (!propValue && new StringOps(Predef$.MODULE$.augmentString(var8_9.trim())).nonEmpty()) {
            opts.printMessageAndExit(new StringBuilder(161).append(propName).append(" is set to false but JSON filters are passed in. Please set").append(" ").append(propName).append(" to true in the link configuration and rerun the create link command with the passed in JSON filters.").toString());
        }
        return var8_9;
    }

    private scala.collection.immutable.Map<String, String> loadConfigs(ClusterLinkCommandOptions opts) {
        Properties properties;
        if (opts.options.has(opts.configOpt())) {
            properties = AdminUtils$.MODULE$.parseConfigs(opts.valueOf(opts.configOpt()));
        } else {
            Predef$.MODULE$.require(opts.options.has(opts.configFileOpt()));
            properties = Utils.loadProps((String)((String)opts.options.valueOf(opts.configFileOpt())));
        }
        Properties props = properties;
        String aclFilterJsonString = this.verifyPropertyAndFilters(opts, props, ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), opts.aclFiltersJsonFileOpt(), opts.aclFiltersJsonOpt());
        String consumerOffsetFilterJsonString = this.verifyPropertyAndFilters(opts, props, ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), opts.consumerGroupFiltersJsonFileOpt(), opts.consumerGroupFiltersJsonOpt());
        String topicFilterJsonString = this.verifyPropertyAndFilters(opts, props, ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), opts.topicFiltersJsonFileOpt(), opts.topicFiltersJsonOpt());
        if (new StringOps(Predef$.MODULE$.augmentString(aclFilterJsonString)).nonEmpty()) {
            Option<AclFiltersJson> aclJson = AclJson$.MODULE$.parse(aclFilterJsonString);
            if (aclJson instanceof Some) {
                props.put(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclFilterJsonString);
            } else if (None$.MODULE$.equals(aclJson)) {
                opts.printMessageAndExit(new StringBuilder(136).append(ClusterLinkConfig$.MODULE$.AclSyncEnableProp()).append(" is set to true but the JSON file").append(" passed has invalid values. Please put valid values in the JSON file and rerun the create link command.").toString());
            } else {
                throw new MatchError(aclJson);
            }
        }
        if (new StringOps(Predef$.MODULE$.augmentString(consumerOffsetFilterJsonString)).nonEmpty()) {
            Option<GroupFilterJson> offsetJson = ClusterLinkFilterJson$.MODULE$.parseGroup(consumerOffsetFilterJsonString);
            if (offsetJson instanceof Some) {
                props.put(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), consumerOffsetFilterJsonString);
            } else if (None$.MODULE$.equals(offsetJson)) {
                opts.printMessageAndExit(new StringBuilder(136).append(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).append(" is set to true but the").append(" JSON file passed has invalid values. Please put valid values in the JSON file and rerun the create link").append(" command.").toString());
            } else {
                throw new MatchError(offsetJson);
            }
        }
        if (new StringOps(Predef$.MODULE$.augmentString(topicFilterJsonString)).nonEmpty()) {
            Option<TopicFilterJson> topicsJson = ClusterLinkFilterJson$.MODULE$.parseTopic(topicFilterJsonString);
            if (topicsJson instanceof Some) {
                props.put(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), topicFilterJsonString);
            } else if (None$.MODULE$.equals(topicsJson)) {
                opts.printMessageAndExit(new StringBuilder(136).append(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()).append(" is set to true but the JSON").append(" file passed has invalid values. Please put valid values in the JSON file and rerun the create link").append(" command.").toString());
            } else {
                throw new MatchError(topicsJson);
            }
        }
        return ((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        block15: {
            ClusterLinkCommandOptions opts = new ClusterLinkCommandOptions(args);
            opts.checkArgs();
            try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.createAdminClient(opts));){
                try {
                    if (opts.options.has((OptionSpec)opts.createOpt())) {
                        this.createClusterLink(opts, client);
                    } else if (opts.options.has((OptionSpec)opts.listOpt())) {
                        this.listClusterLinks(opts, client);
                    } else if (opts.options.has((OptionSpec)opts.deleteOpt())) {
                        this.deleteClusterLink(opts, client);
                    } else if (opts.options.has((OptionSpec)opts.describeOpt())) {
                        this.describeClusterLinks(opts, client);
                    }
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof TimeoutException) {
                        ClusterLinkCommand$.throwAdminCommandFailedException$1("Timed out waiting for results", e);
                        break block15;
                    }
                    if (throwable instanceof ClusterAuthorizationException) {
                        ClusterLinkCommand$.throwAdminCommandFailedException$1(((ClusterAuthorizationException)throwable).getMessage(), e);
                        break block15;
                    }
                    throw e;
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println((Object)"Error while issuing request");
                    throw e;
                }
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void createClusterLink(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        String linkName = opts.valueOf(opts.linkNameOpt());
        Option<String> clusterId = opts.valueAsOption(opts.clusterIdOpt());
        boolean validateOnly = opts.options.has((OptionSpec)opts.validateOnlyOpt());
        boolean excludeValidateLink = opts.options.has((OptionSpec)opts.excludeValidateLinkOpt());
        NewClusterLink clusterLink = new NewClusterLink(linkName, (String)clusterId.orNull(Predef$.MODULE$.$conforms()), (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.loadConfigs(opts)).asJava());
        CreateClusterLinksOptions options = new CreateClusterLinksOptions().validateOnly(validateOnly).validateLink(!excludeValidateLink);
        try {
            client.createClusterLinks((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)clusterLink, (List)Nil$.MODULE$)).asJava(), options).all().get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof InvalidClusterLinkException) {
                InvalidClusterLinkException invalidClusterLinkException = (InvalidClusterLinkException)throwable;
                if (!invalidClusterLinkException.clusterLinkError().equals((Object)ClusterLinkError.NO_ERROR)) {
                    Predef$.MODULE$.println((Object)new StringBuilder(55).append("Error creating link. Link error: ").append(invalidClusterLinkException.clusterLinkError()).append(". Link error message: ").append(invalidClusterLinkException.linkErrorMessage()).toString());
                }
                throw e;
            }
            throw e;
        }
        String action = validateOnly ? "validated" : "completed";
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Cluster link '").append(linkName).append("' creation successfully ").append(action).append(".").toString());
    }

    private void listClusterLinks(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        Option<String> linkName = opts.valueAsOption(opts.linkNameOpt());
        boolean includeTopics = opts.options.has((OptionSpec)opts.includeTopicsOpt());
        ListClusterLinksOptions options = new ListClusterLinksOptions().includeTopics(includeTopics);
        linkName.foreach((Function1 & Serializable & scala.Serializable)ln -> options.linkNames(Optional.of(Collections.singletonList(ln))));
        Iterable result = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)client.listClusterLinks(options).result().get()).asScala();
        if (result.nonEmpty()) {
            result.foreach((Function1 & Serializable & scala.Serializable)cl -> {
                ClusterLinkCommand$.$anonfun$listClusterLinks$2(cl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (linkName instanceof Some) {
            String ln2 = (String)((Some)linkName).value();
            Predef$.MODULE$.println((Object)new StringBuilder(23).append("Link name '").append(ln2).append("' not found.").toString());
            return;
        }
        if (None$.MODULE$.equals(linkName)) {
            Predef$.MODULE$.println((Object)"No cluster links found.");
            return;
        }
        throw new MatchError(linkName);
    }

    private void describeClusterLinks(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        Seq<String> linkNames = this.resolveLinks(opts, client);
        Iterable linkDescriptions = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)client.describeClusterLinks(new DescribeClusterLinksOptions().linkNames(CollectionConverters$.MODULE$.asJavaCollectionConverter(linkNames).asJavaCollection()).includeTopics(true)).result().get()).asScala();
        ArrayList configResources = new ArrayList();
        linkNames.foreach((Function1 & Serializable & scala.Serializable)linkName -> BoxesRunTime.boxToBoolean((boolean)configResources.add(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName))));
        Map linkConfigs = (Map)client.describeConfigs(configResources).all().get();
        if (linkDescriptions.nonEmpty() && !linkConfigs.isEmpty()) {
            linkDescriptions.foreach((Function1 & Serializable & scala.Serializable)cl -> {
                ClusterLinkCommand$.$anonfun$describeClusterLinks$2(linkConfigs, cl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (linkNames.isEmpty()) {
            Predef$.MODULE$.println((Object)"No cluster links found.");
            return;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Link name '").append(linkNames.head()).append("' not found.").toString());
    }

    private Seq<String> resolveLinks(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        .colon.colon colon2;
        Option<String> option = opts.valueAsOption(opts.linkNameOpt());
        if (option instanceof Some) {
            String linkName = (String)((Some)option).value();
            colon2 = new .colon.colon((Object)linkName, (List)Nil$.MODULE$);
        } else if (None$.MODULE$.equals(option)) {
            colon2 = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)client.listClusterLinks(new ListClusterLinksOptions()).result().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.linkName(), Iterable$.MODULE$.canBuildFrom())).toSeq();
        } else {
            throw new MatchError(option);
        }
        return colon2;
    }

    private void deleteClusterLink(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        String linkName = opts.valueOf(opts.linkNameOpt());
        boolean validateOnly = opts.options.has((OptionSpec)opts.validateOnlyOpt());
        boolean force = opts.options.has((OptionSpec)opts.forceOpt());
        DeleteClusterLinksOptions options = new DeleteClusterLinksOptions().validateOnly(validateOnly).force(force);
        client.deleteClusterLinks((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)linkName, (List)Nil$.MODULE$)).asJava(), options).all().get();
        String action = validateOnly ? "validated" : "completed";
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Cluster link '").append(linkName).append("' deletion successfully ").append(action).append(".").toString());
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    private static final void throwAdminCommandFailedException$1(String message, Throwable cause) {
        Predef$.MODULE$.println((Object)message);
        throw new AdminCommandFailedException(message, cause);
    }

    public static final /* synthetic */ void $anonfun$listClusterLinks$2(ClusterLinkListing cl) {
        String localClusterId = cl.localClusterId() != null && new StringOps(Predef$.MODULE$.augmentString(cl.localClusterId())).nonEmpty() ? new StringBuilder(22).append(", local cluster ID: '").append(cl.localClusterId()).append("'").toString() : "";
        String unavailableLinkReason = cl.clusterLinkError() != null && !cl.clusterLinkError().equals((Object)ClusterLinkError.NO_ERROR) ? new StringBuilder(16).append(", link error: '").append(cl.clusterLinkError().name()).append("'").toString() : "";
        String unavailableLinkErrMsg = cl.linkErrorMessage() != null && new StringOps(Predef$.MODULE$.augmentString(cl.linkErrorMessage())).nonEmpty() ? new StringBuilder(24).append(", link error message: '").append(cl.linkErrorMessage()).append("'").toString() : "";
        String linkState = cl.linkState() != null && !cl.linkState().equals((Object)ClusterLinkDescription.LinkState.UNKNOWN) ? new StringBuilder(16).append(", link state: '").append(cl.linkState()).append("'").toString() : "";
        Predef$.MODULE$.print((Object)new StringBuilder(79).append("Link name: '").append(cl.linkName()).append("', link ID: '").append(cl.clusterLinkId()).append("', remote cluster ID: '").append(cl.remoteClusterId()).append("'").append(localClusterId).append(", remote cluster available: '").append(cl.available()).append("'").append(unavailableLinkReason).append(unavailableLinkErrMsg).append(linkState).toString());
        if (cl.topics().isPresent()) {
            Predef$.MODULE$.print((Object)new StringBuilder(10).append(", topics: ").append(cl.topics().get()).toString());
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ boolean $anonfun$describeClusterLinks$3(ConfigEntry x$2) {
        return !x$2.isDefault();
    }

    public static final /* synthetic */ void $anonfun$describeClusterLinks$2(Map linkConfigs$1, ClusterLinkDescription cl) {
        String localClusterId = cl.localClusterId() != null && new StringOps(Predef$.MODULE$.augmentString(cl.localClusterId())).nonEmpty() ? new StringBuilder(22).append(", local cluster ID: '").append(cl.localClusterId()).append("'").toString() : "";
        String linkMode = cl.linkMode() != null ? new StringBuilder(15).append(", link mode: '").append(cl.linkMode().toString()).append("'").toString() : "";
        String connectionMode = cl.connectionMode() != null ? new StringBuilder(21).append(", connection mode: '").append(cl.connectionMode().toString()).append("'").toString() : "";
        String clusterLinkError = cl.clusterLinkError() != null && !cl.clusterLinkError().equals((Object)ClusterLinkError.NO_ERROR) ? new StringBuilder(16).append(", link error: '").append(cl.clusterLinkError().name()).append("'").toString() : "";
        String clusterLinkErrorMsg = cl.linkErrorMessage() != null && new StringOps(Predef$.MODULE$.augmentString(cl.linkErrorMessage())).nonEmpty() ? new StringBuilder(24).append(", link error message: '").append(cl.linkErrorMessage()).append("'").toString() : "";
        String linkState = cl.linkState() != null && !cl.linkState().equals((Object)ClusterLinkDescription.LinkState.UNKNOWN) ? new StringBuilder(16).append(", link state: '").append(cl.linkState().toString()).append("'").toString() : "";
        String linkCoordinator = new StringBuilder(52).append(", link coordinator id: '").append(cl.linkCoordinatorId()).append("', link coordinator host: '").append(cl.linkCoordinatorHost()).append("'").toString();
        ClusterLinkDescription.LinkState linkState2 = cl.linkState();
        ClusterLinkDescription.LinkState linkState3 = ClusterLinkDescription.LinkState.UNMANAGED_SOURCE;
        String unmanagedSource = !(linkState2 != null ? !linkState2.equals(linkState3) : linkState3 != null) ? " (Source-side of a destination-initiated cluster link)" : "";
        Predef$.MODULE$.print((Object)new StringBuilder(49).append("Link name: '").append(cl.linkName()).append("', link ID: '").append(cl.clusterLinkId()).append("', remote cluster ID: '").append(cl.remoteClusterId()).append("'").append(localClusterId).append(linkMode).append(connectionMode).append(clusterLinkError).append(clusterLinkErrorMsg).append(linkState).append(linkCoordinator).append(unmanagedSource).toString());
        if (cl.topics().isPresent()) {
            Predef$.MODULE$.print((Object)new StringBuilder(10).append(", topics: ").append(cl.topics().get()).toString());
        }
        Predef$.MODULE$.println();
        if (unmanagedSource.isEmpty()) {
            Config cfg = (Config)linkConfigs$1.get(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, cl.linkName()));
            String configsAsString = cfg == null ? "Null config" : ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(cfg.entries()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCommand$.$anonfun$describeClusterLinks$3(x$2)))).map((Function1 & Serializable & scala.Serializable)ce -> new StringBuilder(1).append(ce.name()).append("=").append(ce.value()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(",");
            Predef$.MODULE$.println((Object)new StringBuilder(9).append("Configs: ").append(configsAsString).toString());
            Predef$.MODULE$.println();
        }
    }

    private ClusterLinkCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

