/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.UUID;
import joptsimple.OptionException;
import kafka.admin.MutateTopicIdCommand;
import kafka.admin.ZkSecurityMigrator$;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class MutateTopicIdCommand$
implements Logging {
    public static MutateTopicIdCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new MutateTopicIdCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        try {
            this.unhandled(args);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalArgumentException ? true : (throwable instanceof InvalidConfigurationException ? true : throwable instanceof OptionException);
            if (bl) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(34).append("Failed config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(throwable.getMessage());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (throwable != null) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString());
                throwable.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            throw null;
        }
    }

    public void unhandled(String[] args) {
        MutateTopicIdCommand.ConfigCommandOptions opts = new MutateTopicIdCommand.ConfigCommandOptions(args);
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to mutate topic ids. Note that this operation is dangerous and for EXCEPTIONAL USE ONLY.");
        if (opts.options.has(opts.zkConnectOpt())) {
            this.processTopicMutationWithZk((String)opts.options.valueOf(opts.zkConnectOpt()), opts);
            return;
        }
        Predef$.MODULE$.println((Object)"--zookeeper must be used with this command as state is modified directly.");
    }

    private void processTopicMutationWithZk(String zkConnectString, MutateTopicIdCommand.ConfigCommandOptions opts) {
        ZKClientConfig zkClientConfig = (ZKClientConfig)ZkSecurityMigrator$.MODULE$.createZkClientConfigFromOption(opts.options, opts.zkTlsConfigFile()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ZKClientConfig());
        boolean x$2 = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
        int x$3 = 30000;
        int x$4 = 30000;
        int x$5 = Integer.MAX_VALUE;
        Time x$6 = Time.SYSTEM;
        String x$8 = "ConfigCommand";
        String x$9 = KafkaZkClient$.MODULE$.apply$default$9();
        String x$10 = KafkaZkClient$.MODULE$.apply$default$10();
        boolean x$11 = KafkaZkClient$.MODULE$.apply$default$11();
        try (KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, x$2, x$3, x$4, x$5, x$6, x$8, zkClientConfig, x$9, x$10, x$11);){
            Uuid uuid;
            boolean bl;
            String topic = (String)opts.options.valueOf(opts.topic());
            String topicId = (String)opts.options.valueOf(opts.topicId());
            String string = (String)opts.options.valueOf(opts.typeOpt());
            if ("legacy".equals(string)) {
                bl = true;
            } else if ("modern".equals(string)) {
                bl = false;
            } else {
                throw new IllegalArgumentException("Only supported type options are legacy and modern.");
            }
            try {
                uuid = Uuid.fromString((String)topicId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(new StringBuilder(51).append("Base64 topic id was not found, trying ").append(topicId).append(" as hex UUID.").toString());
                uuid = CoreUtils$.MODULE$.toKafkaUUID(UUID.fromString(topicId));
            }
            Uuid resolvedTopicId = uuid;
            zkClient.dangerouslyMutateTopicId(topic, resolvedTopicId, bl, BoxesRunTime.unboxToBoolean((Object)opts.options.valueOf(opts.dryrunOpt())));
        }
    }

    private MutateTopicIdCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

