/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSpec;
import kafka.admin.ReplicaExclusionCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOpResult;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.common.errors.BrokerReplicaExclusionNotFoundException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ReplicaExclusionCommand$
implements Logging {
    public static ReplicaExclusionCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicaExclusionCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ConfluentAdmin createAdminClient(ReplicaExclusionCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options.valueOf(opts.bootstrapServer()));
        return ConfluentAdmin.create((Properties)props);
    }

    public String flagName(OptionSpec<?> option) {
        return new StringBuilder(2).append("--").append(option.options().get(0)).toString();
    }

    public Option<String> reasonOpt(ReplicaExclusionCommandOptions opts) {
        if (opts.options.has(opts.reason())) {
            return new Some((Object)opts.valueOf(opts.reason()));
        }
        return None$.MODULE$;
    }

    public List<Object> brokerIds(ReplicaExclusionCommandOptions opts) {
        if (opts.options.has(opts.brokerIdsOpt())) {
            String idString = opts.valueOf(opts.brokerIdsOpt());
            try {
                return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(idString)).split(','))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ReplicaExclusionCommand$.$anonfun$brokerIds$1(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toList();
            }
            catch (Exception e) {
                throw new AdminCommandFailedException(new StringBuilder(27).append("Error parsing broker ids - ").append(e.getMessage()).toString(), e);
            }
        }
        return Nil$.MODULE$;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(41).append("Error while executing replica exclusion: ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(ReplicaExclusionCommand$.$anonfun$main$1(e)));
                }
                exitCode = 1;
            }
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        block17: {
            ReplicaExclusionCommandOptions opts = new ReplicaExclusionCommandOptions(args);
            opts.checkArgs();
            try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.createAdminClient(opts));){
                try {
                    if (opts.options.has((OptionSpec)opts.addOpt())) {
                        java.util.Map<Integer, ExclusionOp> exclusions = this.exclusionsMap(ExclusionOp.OpType.SET, this.brokerIds(opts), this.reasonOpt(opts));
                        this.alterExclusions(ExclusionOp.OpType.SET, exclusions, client);
                    } else if (opts.options.has((OptionSpec)opts.deleteOpt())) {
                        java.util.Map<Integer, ExclusionOp> exclusions = this.exclusionsMap(ExclusionOp.OpType.DELETE, this.brokerIds(opts), this.reasonOpt(opts));
                        this.alterExclusions(ExclusionOp.OpType.DELETE, exclusions, client);
                    } else if (opts.options.has((OptionSpec)opts.describeOpt())) {
                        this.describeExclusions(client, this.brokerIds(opts));
                    }
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof TimeoutException) {
                        ReplicaExclusionCommand$.throwAdminCommandFailedException$1("Timed out waiting for results", e);
                        break block17;
                    }
                    if (throwable instanceof ClusterAuthorizationException) {
                        ReplicaExclusionCommand$.throwAdminCommandFailedException$1(((ClusterAuthorizationException)throwable).getMessage(), e);
                        break block17;
                    }
                    if (throwable instanceof InvalidRequestException) {
                        InvalidRequestException invalidRequestException = (InvalidRequestException)throwable;
                        throw new AdminCommandFailedException(invalidRequestException.getMessage(), e);
                    }
                    if (throwable instanceof BrokerReplicaExclusionNotFoundException) {
                        BrokerReplicaExclusionNotFoundException brokerReplicaExclusionNotFoundException = (BrokerReplicaExclusionNotFoundException)throwable;
                        throw new AdminCommandFailedException(brokerReplicaExclusionNotFoundException.getMessage(), e);
                    }
                    if (throwable instanceof InvalidBrokerReplicaExclusionException) {
                        InvalidBrokerReplicaExclusionException invalidBrokerReplicaExclusionException = (InvalidBrokerReplicaExclusionException)throwable;
                        throw new AdminCommandFailedException(invalidBrokerReplicaExclusionException.getMessage(), e);
                    }
                    throw e;
                }
                catch (AdminCommandFailedException adminCommandFailedException) {
                    throw adminCommandFailedException;
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println((Object)"Error while issuing request");
                    throw e;
                }
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    public void alterExclusions(ExclusionOp.OpType opType, java.util.Map<Integer, ExclusionOp> exclusions, ConfluentAdmin client) {
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)client.alterBrokerReplicaExclusions(exclusions).result().get();
        if (result.isSuccessful()) {
            ExclusionOp.OpType opType2 = opType;
            ExclusionOp.OpType opType3 = ExclusionOp.OpType.SET;
            String operationStr = !(opType2 != null ? !opType2.equals(opType3) : opType3 != null) ? "applied" : "removed";
            Predef$.MODULE$.println((Object)new StringBuilder(56).append("Broker replica exclusion was successfully ").append(operationStr).append(" for brokers ").append(result.exclusionResultByBroker().keySet()).append(".").toString());
            return;
        }
        Set exclusionBrokerIds = result.exclusionResultByBroker().keySet();
        String indent = "   ";
        scala.collection.immutable.Map failedExclusions = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result.exclusionResultByBroker()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionCommand$.$anonfun$alterExclusions$1(x0$1)))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map brokerErrors = (scala.collection.immutable.Map)failedExclusions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Integer k = (Integer)x0$2._1();
            ExclusionOpResult v = (ExclusionOpResult)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.errorOpt().get());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        List brokerErrorsStr = ((TraversableOnce)brokerErrors.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            Integer k = (Integer)x0$3._1();
            ExclusionOperationError v = (ExclusionOperationError)x0$3._2();
            String string = new StringBuilder(11).append(indent).append("Broker ").append(k).append(" => ").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        Iterable failedBrokerIds = failedExclusions.keys();
        ExclusionOp.OpType opType4 = opType;
        ExclusionOp.OpType opType5 = ExclusionOp.OpType.SET;
        String operationStr = !(opType4 != null ? !opType4.equals(opType5) : opType5 != null) ? "remove replica exclusions from" : "set replica exclusions for";
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("Failed to ").append(operationStr).append(" all brokers ").append(exclusionBrokerIds).append(".").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(7).append("Errors:").append(System.lineSeparator()).append(brokerErrorsStr.mkString(System.lineSeparator())).toString());
        throw new AdminCommandFailedException(new StringBuilder(59).append("Failed to ").append(operationStr).append(" all brokers ").append(exclusionBrokerIds).append(" due to failures with of brokers ").append(failedBrokerIds).append(" (").append(brokerErrors).append(")").toString());
    }

    public java.util.Map<Integer, ExclusionOp> exclusionsMap(ExclusionOp.OpType exclusionOpType, List<Object> brokerIds, Option<String> reasonOpt) {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)brokerIds.map((Function1 & Serializable & scala.Serializable)id -> ReplicaExclusionCommand$.$anonfun$exclusionsMap$1(reasonOpt, exclusionOpType, BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    private void describeExclusions(ConfluentAdmin client, List<Object> brokerIds) {
        Buffer describedExclusions = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)client.describeBrokerReplicaExclusions().descriptions().get()).asScala();
        Buffer filteredExclusions = (Buffer)describedExclusions.filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionCommand$.$anonfun$describeExclusions$1(brokerIds, e)));
        List filteredExclusionIds = ((TraversableOnce)filteredExclusions.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToInteger((int)e.brokerId()), Buffer$.MODULE$.canBuildFrom())).toList();
        if (describedExclusions.isEmpty()) {
            Predef$.MODULE$.println((Object)"No broker replica exclusions are present");
            return;
        }
        if (filteredExclusions.isEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(51).append("There are no broker replica exclusions present for ").append(brokerIds).toString());
            return;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(45).append("Brokers ").append(filteredExclusionIds).append(" are excluded for replica placements.").toString());
        String indent = "    ";
        filteredExclusions.foreach((Function1 & Serializable & scala.Serializable)desc -> {
            Predef$.MODULE$.println((Object)new StringBuilder(17).append(indent).append("Broker ").append(desc.brokerId()).append("; Reason: ").append(desc.reason()).toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$brokerIds$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.trim())).toInt();
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    private static final void throwAdminCommandFailedException$1(String message, Throwable cause) {
        Predef$.MODULE$.println((Object)message);
        throw new AdminCommandFailedException(message, cause);
    }

    public static final /* synthetic */ boolean $anonfun$alterExclusions$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((ExclusionOpResult)x0$1._2()).errorOpt().isPresent();
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$exclusionsMap$1(Option reasonOpt$1, ExclusionOp.OpType exclusionOpType$1, int id) {
        ExclusionOp exclusionOp;
        if (reasonOpt$1 instanceof Some) {
            String reason = (String)((Some)reasonOpt$1).value();
            exclusionOp = new ExclusionOp(exclusionOpType$1, reason);
        } else if (None$.MODULE$.equals(reasonOpt$1)) {
            exclusionOp = new ExclusionOp(exclusionOpType$1);
        } else {
            throw new MatchError((Object)reasonOpt$1);
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id), (Object)exclusionOp);
    }

    public static final /* synthetic */ boolean $anonfun$describeExclusions$1(List brokerIds$1, DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription e) {
        return brokerIds$1.isEmpty() || brokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)e.brokerId()));
    }

    private ReplicaExclusionCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

