/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ReplicaExclusionCommand$;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u000b\u0017\u0005mA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006w\u0001!\t\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u0019A\u0005\u0001)A\u0005\u0005\"9\u0011\n\u0001b\u0001\n\u0003\t\u0005B\u0002&\u0001A\u0003%!\tC\u0004L\u0001\t\u0007I\u0011\u0001'\t\rA\u0003\u0001\u0015!\u0003N\u0011\u001d\t\u0006A1A\u0005\u00021CaA\u0015\u0001!\u0002\u0013i\u0005bB*\u0001\u0005\u0004%\t\u0001\u0014\u0005\u0007)\u0002\u0001\u000b\u0011B'\t\u000fU\u0003!\u0019!C\u0001\u0003\"1a\u000b\u0001Q\u0001\n\tCqa\u0016\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004Y\u0001\u0001\u0006IA\u0011\u0005\u00063\u0002!\tA\u0017\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006c\u0002!\t!\u001c\u0005\u0006e\u0002!Ia\u001d\u0002\u001f%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001cu.\\7b]\u0012|\u0005\u000f^5p]NT!a\u0006\r\u0002\u000b\u0005$W.\u001b8\u000b\u0003e\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00019A\u0011QdJ\u0007\u0002=)\u0011q\u0004I\u0001\u0005kRLGN\u0003\u0002\"E\u000511/\u001a:wKJT!!G\u0012\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0005\u0003Qy\u0011QcQ8n[\u0006tG\rR3gCVdGo\u00149uS>t7/\u0001\u0003be\u001e\u001c\bcA\u0016/a5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCFA\u0003BeJ\f\u0017\u0010\u0005\u00022q9\u0011!G\u000e\t\u0003g1j\u0011\u0001\u000e\u0006\u0003ki\ta\u0001\u0010:p_Rt\u0014BA\u001c-\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]b\u0013A\u0002\u001fj]&$h\b\u0006\u0002>\u007fA\u0011a\bA\u0007\u0002-!)\u0011F\u0001a\u0001U\u0005y!m\\8ugR\u0014\u0018\r]*feZ,'/F\u0001C!\r\u0019e\tM\u0007\u0002\t*\tQ)\u0001\u0006k_B$8/[7qY\u0016L!a\u0012#\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0003A\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014\b%\u0001\td_6l\u0017M\u001c3D_:4\u0017nZ(qi\u0006\t2m\\7nC:$7i\u001c8gS\u001e|\u0005\u000f\u001e\u0011\u0002\u0013\u0011,G.\u001a;f\u001fB$X#A'\u0011\u0005\rs\u0015BA(E\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM]\u0001\u000bI\u0016dW\r^3PaR\u0004\u0013AB1eI>\u0003H/A\u0004bI\u0012|\u0005\u000f\u001e\u0011\u0002\u0017\u0011,7o\u0019:jE\u0016|\u0005\u000f^\u0001\rI\u0016\u001c8M]5cK>\u0003H\u000fI\u0001\rEJ|7.\u001a:JIN|\u0005\u000f^\u0001\u000eEJ|7.\u001a:JIN|\u0005\u000f\u001e\u0011\u0002\rI,\u0017m]8o\u0003\u001d\u0011X-Y:p]\u0002\nqA^1mk\u0016|e-\u0006\u0002\\=R\u0011Al\u001a\t\u0003;zc\u0001\u0001B\u0003`#\t\u0007\u0001MA\u0001U#\t\tG\r\u0005\u0002,E&\u00111\r\f\u0002\b\u001d>$\b.\u001b8h!\tYS-\u0003\u0002gY\t\u0019\u0011I\\=\t\u000b!\f\u0002\u0019A5\u0002\u0007=\u0004H\u000fE\u0002DUrK!a\u001b#\u0003\u0015=\u0003H/[8o'B,7-\u0001\u0006wKJLg-_!sON$\u0012A\u001c\t\u0003W=L!\u0001\u001d\u0017\u0003\tUs\u0017\u000e^\u0001\nG\",7m[!sON\f!C^3sS\u001aL(+Z9vSJ,G-\u0011:hgR\u0019a\u000e^=\t\u000bU$\u0002\u0019\u0001<\u0002\u000f=\u0004H/[8ogB\u00111i^\u0005\u0003q\u0012\u0013\u0011b\u00149uS>t7+\u001a;\t\u000bi$\u0002\u0019A>\u0002\u0011I,\u0017/^5sK\u0012\u00042a\u000b?\u007f\u0013\tiHF\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u00024a`A\u0002!\u0011\u0019%.!\u0001\u0011\u0007u\u000b\u0019\u0001\u0002\u0006\u0002\u0006e\f\t\u0011!A\u0003\u0002\u0001\u00141a\u0018\u00133\u0001")
public final class ReplicaExclusionCommandOptions
extends CommandDefaultOptions {
    private final String[] args;
    private final ArgumentAcceptingOptionSpec<String> bootstrapServer;
    private final ArgumentAcceptingOptionSpec<String> commandConfigOpt;
    private final OptionSpecBuilder deleteOpt;
    private final OptionSpecBuilder addOpt;
    private final OptionSpecBuilder describeOpt;
    private final ArgumentAcceptingOptionSpec<String> brokerIdsOpt;
    private final ArgumentAcceptingOptionSpec<String> reason;

    public ArgumentAcceptingOptionSpec<String> bootstrapServer() {
        return this.bootstrapServer;
    }

    public ArgumentAcceptingOptionSpec<String> commandConfigOpt() {
        return this.commandConfigOpt;
    }

    public OptionSpecBuilder deleteOpt() {
        return this.deleteOpt;
    }

    public OptionSpecBuilder addOpt() {
        return this.addOpt;
    }

    public OptionSpecBuilder describeOpt() {
        return this.describeOpt;
    }

    public ArgumentAcceptingOptionSpec<String> brokerIdsOpt() {
        return this.brokerIdsOpt;
    }

    public ArgumentAcceptingOptionSpec<String> reason() {
        return this.reason;
    }

    public <T> T valueOf(OptionSpec<T> opt) {
        return (T)this.options.valueOf(opt);
    }

    public void verifyArgs() {
        this.verifyRequiredArgs(this.options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServer()}));
        if (new .colon.colon((Object)this.deleteOpt(), (List)new .colon.colon((Object)this.addOpt(), (List)new .colon.colon((Object)this.describeOpt(), (List)Nil$.MODULE$))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.options.has(x$1))) != 1) {
            throw new IllegalArgumentException(new StringBuilder(48).append("Command must include exactly one action: ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.deleteOpt())).append(", ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.addOpt())).append(" or ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.describeOpt())).append(".").toString());
        }
        if (!this.options.has((OptionSpec)this.describeOpt())) {
            if (!this.options.has(this.brokerIdsOpt())) {
                throw new IllegalArgumentException(new StringBuilder(31).append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.brokerIdsOpt())).append(" must be supplied ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.deleteOpt())).append(" or ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.addOpt())).append(" is used.").toString());
            }
            String brokerIds = (String)this.options.valueOf(this.brokerIdsOpt());
            if (brokerIds.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(34).append("No broker ids were supplied with ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.brokerIdsOpt())).append(".").toString());
            }
            if (new StringOps(Predef$.MODULE$.augmentString(brokerIds)).exists((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionCommandOptions.$anonfun$verifyArgs$2(BoxesRunTime.unboxToChar((Object)id))))) {
                throw new IllegalArgumentException(new StringBuilder(42).append("Broker ids contain unrepresentable IDs - ").append(brokerIds).append(".").toString());
            }
        }
    }

    public void checkArgs() {
        if (this.args.length == 0) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Set, remove and describe broker replica placement exclusion.");
        }
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool allows for setting, removing and describing the status of broker replica placement exclusions.");
        try {
            this.verifyArgs();
            return;
        }
        catch (Throwable e) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)e.getMessage());
            return;
        }
    }

    private void verifyRequiredArgs(OptionSet options, Seq<OptionSpec<?>> required) {
        required.foreach((Function1 & Serializable & scala.Serializable)arg -> {
            ReplicaExclusionCommandOptions.$anonfun$verifyRequiredArgs$1(options, arg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$verifyArgs$2(char id) {
        return id < '\u0000';
    }

    public static final /* synthetic */ void $anonfun$verifyRequiredArgs$1(OptionSet options$1, OptionSpec arg) {
        if (!options$1.has(arg)) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Missing required argument '").append(arg).append("'").toString());
        }
    }

    public ReplicaExclusionCommandOptions(String[] args) {
        this.args = args;
        super(args);
        this.bootstrapServer = this.parser.accepts("bootstrap-server", "A hostname and port for the broker to connect to, in the form host:port. Multiple comma separated URLs can be given. REQUIRED.").withRequiredArg().describedAs("host:port").ofType(String.class);
        this.commandConfigOpt = this.parser.accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("file").ofType(String.class);
        this.deleteOpt = this.parser.accepts("delete", "Delete a replica exclusion.");
        this.addOpt = this.parser.accepts("add", "Add a replica placement exclusion on brokers in from the cluster.");
        this.describeOpt = this.parser.accepts("describe", "Describe the status of the broker removal operation.");
        this.brokerIdsOpt = this.parser.accepts("broker-ids", "The comma-separated list of ids of the Kafka brokers for which the exclusions will apply.").withRequiredArg().describedAs("broker ids").ofType(String.class);
        this.reason = this.parser.accepts("reason", "The reason given for excluding the set of brokers.").withRequiredArg().describedAs("reason").ofType(String.class);
        this.options = this.parser.parse(args);
    }
}

