/*
 * Decompiled with CFR 0.152.
 */
package kafka.assignor;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kafka.assignor.TopicReplicaAssignor;
import kafka.assignor.TopicReplicaAssignorBuilder;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.TopicAssignment;
import org.apache.kafka.metadata.placement.TopicPlacementReplicaPlacer;
import org.slf4j.Logger;

public class ConfluentReplicaPlacer
implements ReplicaPlacer {
    private final ReplicaPlacer defaultPlacer;
    private final Optional<TopicReplicaAssignorBuilder> assignorBuilder;
    private final TopicPlacementReplicaPlacer topicPlacementReplicaPlacer;
    private Logger log;

    public ConfluentReplicaPlacer(LogContext logContext, ReplicaPlacer defaultPlacer, Optional<TopicReplicaAssignorBuilder> assignorBuilder, TopicPlacementReplicaPlacer topicPlacementReplicaPlacer) {
        this.log = logContext.logger(ConfluentReplicaPlacer.class);
        this.defaultPlacer = defaultPlacer;
        this.assignorBuilder = assignorBuilder;
        this.topicPlacementReplicaPlacer = topicPlacementReplicaPlacer;
    }

    public TopicAssignment place(PlacementSpec placement, ClusterDescriber cluster) throws InvalidReplicationFactorException {
        this.log.debug("Handling place request with placement spec {}.", (Object)placement);
        Optional assignor = this.assignorBuilder.flatMap(builder -> {
            builder.updateClusterDescriber(cluster);
            return builder.maybeBuildAssignor(Optional.ofNullable(placement.principal()), placement.partitionPlacementStrategy());
        });
        if (assignor.isPresent()) {
            this.log.debug("Using a {} instance to make the assignment for topic {}.", (Object)((TopicReplicaAssignor)assignor.get()).getClass().getSimpleName(), (Object)placement.topicName());
            TopicReplicaAssignor.NewPartitions newPartitions = new TopicReplicaAssignor.NewPartitions(placement.topicName(), placement.startPartition() + placement.numPartitions(), placement.startPartition(), placement.numReplicas());
            Optional<List<List<Integer>>> result = placement.startPartition() == 0 ? ((TopicReplicaAssignor)assignor.get()).computeAssignmentForNewTopic(newPartitions, Optional.empty(), placement.excludedBrokerIds()) : ((TopicReplicaAssignor)assignor.get()).computeAssignmentForExistingTopic(newPartitions, Optional.empty(), placement.excludedBrokerIds());
            if (result.isPresent()) {
                return new TopicAssignment(result.get().stream().map(PartitionAssignment::new).collect(Collectors.toList()));
            }
        } else if (placement.topicPlacement().isPresent()) {
            this.log.debug("Using a {} instance to make the assignment for topic {} with topic placement {}.", new Object[]{this.topicPlacementReplicaPlacer.getClass().getSimpleName(), placement.topicName(), placement.topicPlacement()});
            return this.topicPlacementReplicaPlacer.place(new TopicPlacementReplicaPlacer.PlacementSpec((TopicPlacement)placement.topicPlacement().get(), placement.excludedBrokerIds(), placement.startPartition(), placement.numPartitions()), cluster.usableBrokers());
        }
        this.log.debug("Using the default placer, {}, to make the assignment for topic {}.", (Object)this.defaultPlacer.getClass().getSimpleName(), (Object)placement.topicName());
        return this.defaultPlacer.place(placement, cluster);
    }
}

