/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import kafka.catalog.event.MetadataCollectorEvent;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;

@ThreadSafe
public class MetadataCollectorEventQueue
implements AutoCloseable {
    private final EventQueue eventQueue;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public MetadataCollectorEventQueue(Time time) {
        String identifierPrefix = MetadataCollectorEventQueue.class.getSimpleName();
        this.eventQueue = new KafkaEventQueue(time, new LogContext(identifierPrefix), identifierPrefix);
    }

    @Override
    public void close() throws InterruptedException {
        this.shutdown.set(true);
        this.eventQueue.close();
    }

    public void scheduleDeferred(String tag, Function<OptionalLong, OptionalLong> deadlineNsCalculator, MetadataCollectorEvent event) {
        this.checkIfQueueClose(event);
        this.eventQueue.scheduleDeferred(tag, deadlineNsCalculator, (EventQueue.Event)event);
    }

    public void append(MetadataCollectorEvent event) {
        this.checkIfQueueClose(event);
        this.eventQueue.append((EventQueue.Event)event);
    }

    public void appendWithTag(String tag, MetadataCollectorEvent event) {
        this.checkIfQueueClose(event);
        this.eventQueue.enqueue(EventQueue.EventInsertionType.APPEND, tag, (Function)new EventQueue.NoDeadlineFunction(), (EventQueue.Event)event);
    }

    public void cancel(String tag) {
        this.eventQueue.cancelDeferred(tag);
    }

    private void checkIfQueueClose(MetadataCollectorEvent event) {
        if (this.shutdown.get()) {
            throw new IllegalStateException(String.format("Attempting to enqueue event %s to closed MetadataCollectorEventQueue", event));
        }
    }
}

