/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.telemetry.api.events.Event;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;
import kafka.catalog.CatalogTopicConfig;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.exceptions.CollectorContextNotInitializedException;
import kafka.server.ConfigType;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkTopicState;
import kafka.zk.AdminZkClient;
import kafka.zk.ClusterLinkData;
import kafka.zk.TopicZNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;

public abstract class MetadataCollectorEvent
implements EventQueue.Event {
    protected static final Logger LOG = LoggerFactory.getLogger(MetadataCollectorEvent.class);
    protected ZKMetadataCollector collector;
    protected long eventObservedTimeMillis;
    protected final Time time;
    public static final String SNAPSHOT_EVENT_TAG = "SNAPSHOT_EVENT";
    public static final String CACHE_BUILD_EVENT_TAG = "CACHE_BUILD_EVENT";

    public MetadataCollectorEvent(ZKMetadataCollector collector, Time time) {
        this.collector = collector;
        this.time = time;
        this.eventObservedTimeMillis = time.milliseconds();
    }

    public void handleException(Throwable e) {
        if (e instanceof RejectedExecutionException) {
            LOG.info("Not processing {} because the event queue is closed.", (Object)this, (Object)e);
        } else {
            LOG.error("Unexpected error handling {}", (Object)this, (Object)e);
        }
        this.recordEventHandleError();
    }

    protected void recordEventHandleError() {
        try {
            this.context().catalogMetrics().collectorEventHandleErrorSensor.record();
        }
        catch (CollectorContextNotInitializedException ex) {
            LOG.warn("Ignore error in metrics due to ", (Throwable)ex);
        }
    }

    protected ZKMetadataCollectorContext context() throws CollectorContextNotInitializedException {
        if (this.collector.collectorContext().isPresent()) {
            return this.collector.collectorContext().get();
        }
        throw new CollectorContextNotInitializedException("CollectorContext is not initialized yet.");
    }

    protected LogConfig getLogConfigsForTopic(ZKMetadataCollectorContext context, String topic) {
        context.throttler().maybeThrottle(1.0);
        Properties configOverrides = new AdminZkClient(context.zkClient()).fetchEntityConfig(ConfigType.Topic(), topic);
        return LogConfig.fromProps(context.originalConfig().extractLogConfigMap(), (Properties)configOverrides);
    }

    protected ClusterLinkConfig getClusterLinkConfigForClusterLink(ZKMetadataCollectorContext context, Uuid linkId) {
        context.throttler().maybeThrottle(1.0);
        AdminZkClient adminZkClient = new AdminZkClient(context.zkClient());
        Properties props = adminZkClient.fetchClusterLinkConfig(linkId);
        if (props.isEmpty()) {
            return null;
        }
        return ClusterLinkConfig.create(props, false);
    }

    protected TopicZNode.TopicIdReplicaAssignment getTopicIdReplicaAssignmentFromZk(ZKMetadataCollectorContext context, String topic) {
        context.throttler().maybeThrottle(1.0);
        return (TopicZNode.TopicIdReplicaAssignment)context.zkClient().getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)JavaConverters.asScalaSet(Collections.singleton(topic)).toSet()).head();
    }

    protected Optional<ClusterLinkTopicState> getMirrorTopicState(ZKMetadataCollectorContext context, String topic) {
        context.throttler().maybeThrottle(1.0);
        return Optional.ofNullable(context.zkClient().getClusterLinkForTopic(topic).getOrElse(() -> null));
    }

    private Optional<ClusterLinkData> getClusterLinkData(ZKMetadataCollectorContext context, Uuid linkId) {
        context.throttler().maybeThrottle(1.0);
        AdminZkClient adminZkClient = new AdminZkClient(context.zkClient());
        return Optional.ofNullable(adminZkClient.getClusterLink(linkId).getOrElse(() -> null));
    }

    protected String getRemoteClusterId(ZKMetadataCollectorContext context, Uuid linkId) {
        Optional<ClusterLinkData> clusterLinkData = this.getClusterLinkData(context, linkId);
        String remoteClusterId = "";
        if (clusterLinkData.isPresent()) {
            remoteClusterId = (String)clusterLinkData.get().clusterId().get();
        }
        return remoteClusterId;
    }

    protected Set<String> filterCatalogConfigOverride(Set<String> updatedConfigKeys) {
        if (updatedConfigKeys == null || updatedConfigKeys.isEmpty()) {
            return Collections.emptySet();
        }
        return updatedConfigKeys.stream().map(Object::toString).filter(CatalogTopicConfig.CATALOG_TOPIC_CONFIGS::contains).collect(Collectors.toSet());
    }

    protected void emitTopicDeltaEvent(ZKMetadataCollectorContext context, MetadataChange metadataChange) {
        Event toEmit = MetadataEventUtils.topicMetadataDeltaCloudEvent(metadataChange, context.epoch(), context.config().destTopic);
        MetadataEventUtils.emitAndLogError(context.eventEmitter(), toEmit, context.catalogMetrics(), LOG);
    }

    protected void emitClusterLinkDeltaEvent(ZKMetadataCollectorContext context, MetadataChange metadataChange) {
        Event toEmit = MetadataEventUtils.clusterLinkMetadataDeltaCloudEvent(metadataChange, context.epoch(), context.config().destTopic);
        MetadataEventUtils.emitAndLogError(context.eventEmitter(), toEmit, context.catalogMetrics(), LOG);
    }

    protected void emitSnapshotEvent(ZKMetadataCollectorContext context, MetadataChange metadataChange, int page, int total) {
        Event toEmit = MetadataEventUtils.metadataSnapshotCloudEvent(metadataChange, context.epoch(), context.config().destTopic, page, total);
        MetadataEventUtils.emitAndLogError(context.eventEmitter(), toEmit, context.catalogMetrics(), LOG);
    }
}

