/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.metadata.MirrorTopicInfo;
import kafka.catalog.metadata.TopicInfo;
import kafka.common.TenantHelpers;
import kafka.controller.ReplicaAssignment;
import kafka.server.link.ClusterLinkTopicState;
import kafka.zk.TopicZNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Tuple2;

public class TopicPartitionChangeEvent
extends MetadataCollectorEvent {
    private final String topic;
    private final String logicalClusterId;
    private final int newPartition;

    public TopicPartitionChangeEvent(ZKMetadataCollector collector, String logicalClusterId, String topic, int newPartition, Time time) {
        super(collector, time);
        this.logicalClusterId = logicalClusterId;
        this.topic = topic;
        this.newPartition = newPartition;
    }

    public void run() throws Exception {
        ZKMetadataCollectorContext context = this.context();
        LOG.debug("Updating Topic partitions for topic {} with new partitions {}", (Object)this.topic, (Object)this.newPartition);
        MetadataEvent metadataEvent = context.localStore().topicMetadataEvent(this.topic);
        Timestamp eventTimestamp = Timestamps.fromMillis((long)this.eventObservedTimeMillis);
        HashSet<String> topicConfigOverrides = new HashSet<String>();
        if (metadataEvent != null) {
            TopicMetadata topicMetadata = TopicMetadata.newBuilder().mergeFrom(metadataEvent.getTopicMetadata()).setPartitionsCount(this.newPartition).setUpdateTime(eventTimestamp).build();
            metadataEvent = MetadataEvent.newBuilder().setTopicMetadata(topicMetadata).build();
        } else {
            int replicas;
            LogConfig logConfig = this.getLogConfigsForTopic(context, this.topic);
            Uuid id = null;
            Optional<Object> mirrorTopicInfo = Optional.empty();
            if (!context.cacheInitialized() && context.topicInfo(this.topic) != null) {
                TopicInfo topicInfo = context.removeTopicFromInitialSnapshot(this.topic);
                id = topicInfo.topicId();
                replicas = topicInfo.replicationFactors();
                if (topicInfo.mirrorTopicInfo().isPresent()) {
                    mirrorTopicInfo = topicInfo.mirrorTopicInfo();
                }
            } else {
                TopicZNode.TopicIdReplicaAssignment topicIdReplicaAssignment = this.getTopicIdReplicaAssignmentFromZk(context, this.topic);
                if (topicIdReplicaAssignment.topicId().isEmpty() || topicIdReplicaAssignment.assignment().isEmpty()) {
                    LOG.debug("Ignoring Event {} due to topic doesn't exist in zk", (Object)this);
                    return;
                }
                id = (Uuid)topicIdReplicaAssignment.topicId().get();
                ReplicaAssignment partitionAssignment = (ReplicaAssignment)((Tuple2)topicIdReplicaAssignment.assignment().head())._2;
                replicas = partitionAssignment.targetReplicaAssignment().replicas().size();
                Optional<ClusterLinkTopicState> mirrorTopicState = this.getMirrorTopicState(context, this.topic);
                if (mirrorTopicState.isPresent()) {
                    ClusterLinkTopicState mirrorState = mirrorTopicState.get();
                    Uuid linkId = mirrorState.linkId();
                    String remoteClusterId = this.getRemoteClusterId(context, linkId);
                    MirrorTopicInfo mirrorInfo = new MirrorTopicInfo(mirrorState.linkName(), linkId, this.topic, mirrorState.sourceTopicId(), mirrorState.state().name(), remoteClusterId);
                    mirrorTopicInfo = Optional.of(mirrorInfo);
                }
            }
            MirrorTopicMetadata mirrorTopicMetadata = null;
            if (mirrorTopicInfo.isPresent()) {
                MirrorTopicInfo mirrorInfo = (MirrorTopicInfo)mirrorTopicInfo.get();
                mirrorTopicMetadata = MetadataEventUtils.mirrorTopicMetadata(mirrorInfo.linkId(), mirrorInfo.linkName(), mirrorInfo.sourceTopicId(), mirrorInfo.sourceTopicName(), mirrorInfo.mirrorTopicState(), mirrorInfo.remoteClusterId(), null);
            }
            metadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(logConfig, TenantHelpers.extractLogicalName(this.topic), id, this.newPartition, replicas, mirrorTopicMetadata, eventTimestamp, null);
            topicConfigOverrides.addAll(this.filterCatalogConfigOverride(logConfig.overriddenConfigs));
        }
        context.localStore().addTopicMetadataEvent(this.logicalClusterId, this.topic, metadataEvent, topicConfigOverrides, Collections.emptySet());
        MetadataChange topicMetadataChange = MetadataEventUtils.entityUpdateEvent(this.logicalClusterId, metadataEvent);
        this.emitTopicDeltaEvent(context, topicMetadataChange);
    }

    public String toString() {
        return "TopicPartitionChangeEvent(topic=" + this.topic + ", newPartitions=" + this.newPartition + ')';
    }
}

