/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015q!B-[\u0011\u0003yf!B1[\u0011\u0003\u0011\u0007\"\u00027\u0002\t\u0003ig!\u00028\u0002\u0001r{\u0007BCA\u000b\u0007\tU\r\u0011\"\u0001\u0002\u0018!Q\u0011QE\u0002\u0003\u0012\u0003\u0006I!!\u0007\t\u0015\u0005\u001d2A!f\u0001\n\u0003\tI\u0003\u0003\u0006\u00022\r\u0011\t\u0012)A\u0005\u0003WA!\"a\r\u0004\u0005+\u0007I\u0011AA\u001b\u0011)\tIe\u0001B\tB\u0003%\u0011q\u0007\u0005\u000b\u0003\u0017\u001a!Q3A\u0005\u0002\u00055\u0003BCA(\u0007\tE\t\u0015!\u0003\u0002D!Q\u0011\u0011K\u0002\u0003\u0016\u0004%\t!a\u0015\t\u0015\u0005E4A!E!\u0002\u0013\t)\u0006\u0003\u0006\u0002t\r\u0011)\u001a!C!\u0003kB!\"a$\u0004\u0005#\u0005\u000b\u0011BA<\u0011)\t\tj\u0001BK\u0002\u0013\u0005\u00131\u0013\u0005\u000b\u0003C\u001b!\u0011#Q\u0001\n\u0005U\u0005BCAR\u0007\tU\r\u0011\"\u0011\u0002&\"Q\u0011\u0011W\u0002\u0003\u0012\u0003\u0006I!a*\t\r1\u001cA\u0011AAZ\u0011%\tImAA\u0001\n\u0003\tY\rC\u0005\u0002^\u000e\t\n\u0011\"\u0001\u0002`\"I\u0011Q_\u0002\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0003w\u001c\u0011\u0013!C\u0001\u0003{D\u0011B!\u0001\u0004#\u0003%\tAa\u0001\t\u0013\t\u001d1!%A\u0005\u0002\t%\u0001\"\u0003B\u0007\u0007E\u0005I\u0011\u0001B\b\u0011%\u0011\u0019bAI\u0001\n\u0003\u0011)\u0002C\u0005\u0003\u001a\r\t\n\u0011\"\u0001\u0003\u001c!I!qD\u0002\u0002\u0002\u0013\u0005#\u0011\u0005\u0005\n\u0005O\u0019\u0011\u0011!C\u0001\u0003SA\u0011B!\u000b\u0004\u0003\u0003%\tAa\u000b\t\u0013\t]2!!A\u0005B\te\u0002\"\u0003B$\u0007\u0005\u0005I\u0011\u0001B%\u0011%\u0011\u0019fAA\u0001\n\u0003\u0012)\u0006C\u0005\u0003X\r\t\t\u0011\"\u0011\u0003Z!I!1L\u0002\u0002\u0002\u0013\u0005#QL\u0004\u000b\u0005C\n\u0011\u0011!E\u00019\n\rd!\u00038\u0002\u0003\u0003E\t\u0001\u0018B3\u0011\u0019aw\u0005\"\u0001\u0003t!I!qK\u0014\u0002\u0002\u0013\u0015#\u0011\f\u0005\n\u0005k:\u0013\u0011!CA\u0005oB\u0011B!#(\u0003\u0003%\tIa#\t\u0013\tuu%!A\u0005\n\t}\u0005b\u0002B;\u0003\u0011\u0005!\u0011\u0015\u0005\b\u0005k\nA\u0011ABZ\u0011\u001d\u0011)(\u0001C\u0001\u0007{Cqaa2\u0002\t\u0013\u0019I\rC\u0004\u0004`\u0006!\ta!9\t\u0013\tU\u0014!!A\u0005\u0002\u000e5\b\"\u0003BE\u0003\u0005\u0005I\u0011QB}\u0011%\u0011i*AA\u0001\n\u0013\u0011yJB\u0003b5\u0002\u0013)\u000b\u0003\u0006\u0003(V\u0012)\u001a!C\u0001\u0003SA!B!+6\u0005#\u0005\u000b\u0011BA\u0016\u0011)\u0011Y+\u000eBK\u0002\u0013\u0005!Q\u0016\u0005\u000b\u0005w+$\u0011#Q\u0001\n\t=\u0006B\u0003B_k\tU\r\u0011\"\u0001\u0003@\"Q!1Y\u001b\u0003\u0012\u0003\u0006IA!1\t\u0015\t\u0015WG!f\u0001\n\u0003\u00119\r\u0003\u0006\u0003\\V\u0012\t\u0012)A\u0005\u0005\u0013D!B!86\u0005+\u0007I\u0011\u0001Bp\u0011)\u00119/\u000eB\tB\u0003%!\u0011\u001d\u0005\u0007YV\"\tA!;\t\u0013\tUXG1A\u0005\n\t]\b\u0002CB\bk\u0001\u0006IA!?\t\u000f\t]S\u0007\"\u0011\u0004\u0012!1A.\u000eC\u0001\u0007'Aa\u0001\\\u001b\u0005\u0002\r]\u0002bBB$k\u0011\u00051\u0011\n\u0005\b\u0007'*D\u0011AB+\u0011\u001d\u0019Y&\u000eC\u0001\u0007;Bqa!\u00196\t\u0003\u0019\u0019\u0007C\u0004\u0004hU\"\ta!\u001b\t\u0013\r\rU'%A\u0005\u0002\tU\u0001\"CAek\u0005\u0005I\u0011ABC\u0011%\ti.NI\u0001\n\u0003\t9\u0010C\u0005\u0002vV\n\n\u0011\"\u0001\u0004\u0012\"I\u00111`\u001b\u0012\u0002\u0013\u00051Q\u0013\u0005\n\u0005\u0003)\u0014\u0013!C\u0001\u00073C\u0011Ba\u00026#\u0003%\ta!(\t\u0013\t}Q'!A\u0005B\t\u0005\u0002\"\u0003B\u0014k\u0005\u0005I\u0011AA\u0015\u0011%\u0011I#NA\u0001\n\u0003\u0019\t\u000bC\u0005\u00038U\n\t\u0011\"\u0011\u0003:!I!qI\u001b\u0002\u0002\u0013\u00051Q\u0015\u0005\n\u0005'*\u0014\u0011!C!\u0005+B\u0011Ba\u00176\u0003\u0003%\te!+\u0002\r\t\u0013xn[3s\u0015\tYF,A\u0004dYV\u001cH/\u001a:\u000b\u0003u\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002a\u00035\t!L\u0001\u0004Ce>\\WM]\n\u0004\u0003\rL\u0007C\u00013h\u001b\u0005)'\"\u00014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!,'AB!osJ+g\r\u0005\u0002eU&\u00111.\u001a\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0013!bU3sm\u0016\u0014\u0018J\u001c4p'\u0019\u0019\u0001\u000f_A\bSB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0005Y\u0006twMC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]\u0014(AB(cU\u0016\u001cG\u000fE\u0002z\u0003\u0017i\u0011A\u001f\u0006\u0003wr\f\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005ut\u0018AC1vi\"|'/\u001b>fe*\u0019q0!\u0001\u0002\rM,'O^3s\u0015\ri\u00161\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0013\t1a\u001c:h\u0013\r\tiA\u001f\u0002\u001e\u0007>tg\r\\;f]R\fU\u000f\u001e5pe&TXM]*feZ,'/\u00138g_B\u0019A-!\u0005\n\u0007\u0005MQMA\u0004Qe>$Wo\u0019;\u0002\u001f\rdWo\u001d;feJ+7o\\;sG\u0016,\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;QA!a\b\u0002\u0002\u000511m\\7n_:LA!a\t\u0002\u001e\ty1\t\\;ti\u0016\u0014(+Z:pkJ\u001cW-\u0001\tdYV\u001cH/\u001a:SKN|WO]2fA\u0005A!M]8lKJLE-\u0006\u0002\u0002,A\u0019A-!\f\n\u0007\u0005=RMA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0013\u0015tG\r]8j]R\u001cXCAA\u001c!\u0019\tI$a\u0010\u0002D5\u0011\u00111\b\u0006\u0004\u0003{!\u0018\u0001B;uS2LA!!\u0011\u0002<\t!A*[:u!\u0011\tY\"!\u0012\n\t\u0005\u001d\u0013Q\u0004\u0002\t\u000b:$\u0007o\\5oi\u0006QQM\u001c3q_&tGo\u001d\u0011\u0002'%tG/\u001a:Ce>\\WM]#oIB|\u0017N\u001c;\u0016\u0005\u0005\r\u0013\u0001F5oi\u0016\u0014(I]8lKJ,e\u000e\u001a9pS:$\b%A\nfCJd\u0017p\u0015;beRd\u0015n\u001d;f]\u0016\u00148/\u0006\u0002\u0002VA1\u0011\u0011HA,\u00037JA!!\u0017\u0002<\t\u00191+\u001a;\u0011\t\u0005u\u00131\u000e\b\u0005\u0003?\n9\u0007E\u0002\u0002b\u0015l!!a\u0019\u000b\u0007\u0005\u0015d,\u0001\u0004=e>|GOP\u0005\u0004\u0003S*\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002n\u0005=$AB*ue&twMC\u0002\u0002j\u0015\fA#Z1sYf\u001cF/\u0019:u\u0019&\u001cH/\u001a8feN\u0004\u0013\u0001\u00055uiB\u001cVM\u001d<fe\nKg\u000eZ3s+\t\t9\b\u0005\u0003\u0002z\u0005-UBAA>\u0015\ry\u0018Q\u0010\u0006\u0005\u0003\u007f\n\t)\u0001\u0003iiR\u0004(bA/\u0002\u0004*!\u0011QQAD\u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\u0002\n\u0006\u0011\u0011n\\\u0005\u0005\u0003\u001b\u000bYHA\u000bLC\u001a\\\u0017\r\u0013;uaN+'O^3s\u0005&tG-\u001a:\u0002#!$H\u000f]*feZ,'OQ5oI\u0016\u0014\b%\u0001\tbk\u0012LG\u000fT8h!J|g/\u001b3feV\u0011\u0011Q\u0013\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014@\u0002\u000b\u0005,H-\u001b;\n\t\u0005}\u0015\u0011\u0014\u0002\u0011\u0003V$\u0017\u000e\u001e'pOB\u0013xN^5eKJ\f\u0011#Y;eSRdun\u001a)s_ZLG-\u001a:!\u0003\u001diW\r\u001e:jGN,\"!a*\u0011\t\u0005%\u0016QV\u0007\u0003\u0003WSA!a)\u0002\u001e%!\u0011qVAV\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000f\t\u000b\u0013\u0003k\u000bI,a/\u0002>\u0006}\u0016\u0011YAb\u0003\u000b\f9\rE\u0002\u00028\u000ei\u0011!\u0001\u0005\b\u0003+!\u0002\u0019AA\r\u0011\u001d\t9\u0003\u0006a\u0001\u0003WAq!a\r\u0015\u0001\u0004\t9\u0004C\u0004\u0002LQ\u0001\r!a\u0011\t\u000f\u0005EC\u00031\u0001\u0002V!9\u00111\u000f\u000bA\u0002\u0005]\u0004bBAI)\u0001\u0007\u0011Q\u0013\u0005\b\u0003G#\u0002\u0019AAT\u0003\u0011\u0019w\u000e]=\u0015%\u0005U\u0016QZAh\u0003#\f\u0019.!6\u0002X\u0006e\u00171\u001c\u0005\n\u0003+)\u0002\u0013!a\u0001\u00033A\u0011\"a\n\u0016!\u0003\u0005\r!a\u000b\t\u0013\u0005MR\u0003%AA\u0002\u0005]\u0002\"CA&+A\u0005\t\u0019AA\"\u0011%\t\t&\u0006I\u0001\u0002\u0004\t)\u0006C\u0005\u0002tU\u0001\n\u00111\u0001\u0002x!I\u0011\u0011S\u000b\u0011\u0002\u0003\u0007\u0011Q\u0013\u0005\n\u0003G+\u0002\u0013!a\u0001\u0003O\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002b*\"\u0011\u0011DArW\t\t)\u000f\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\u0013Ut7\r[3dW\u0016$'bAAxK\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0018\u0011\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003sTC!a\u000b\u0002d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u0000U\u0011\t9$a9\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0001\u0016\u0005\u0003\u0007\n\u0019/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t-!\u0006BA+\u0003G\fabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\u0012)\"\u0011qOAr\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]*\"Aa\u0006+\t\u0005U\u00151]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139+\t\u0011iB\u000b\u0003\u0002(\u0006\r\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003$A\u0019\u0011O!\n\n\u0007\u00055$/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t5\"1\u0007\t\u0004I\n=\u0012b\u0001B\u0019K\n\u0019\u0011I\\=\t\u0013\tU\u0002%!AA\u0002\u0005-\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003<A1!Q\bB\"\u0005[i!Aa\u0010\u000b\u0007\t\u0005S-\u0001\u0006d_2dWm\u0019;j_:LAA!\u0012\u0003@\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011YE!\u0015\u0011\u0007\u0011\u0014i%C\u0002\u0003P\u0015\u0014qAQ8pY\u0016\fg\u000eC\u0005\u00036\t\n\t\u00111\u0001\u0003.\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002,\u0005AAo\\*ue&tw\r\u0006\u0002\u0003$\u00051Q-];bYN$BAa\u0013\u0003`!I!QG\u0013\u0002\u0002\u0003\u0007!QF\u0001\u000b'\u0016\u0014h/\u001a:J]\u001a|\u0007cAA\\OM!qEa\u001aj!Y\u0011IGa\u001c\u0002\u001a\u0005-\u0012qGA\"\u0003+\n9(!&\u0002(\u0006UVB\u0001B6\u0015\r\u0011i'Z\u0001\beVtG/[7f\u0013\u0011\u0011\tHa\u001b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\b\u0006\u0002\u0003d\u0005)\u0011\r\u001d9msR\u0011\u0012Q\u0017B=\u0005w\u0012iHa \u0003\u0002\n\r%Q\u0011BD\u0011\u001d\t)B\u000ba\u0001\u00033Aq!a\n+\u0001\u0004\tY\u0003C\u0004\u00024)\u0002\r!a\u000e\t\u000f\u0005-#\u00061\u0001\u0002D!9\u0011\u0011\u000b\u0016A\u0002\u0005U\u0003bBA:U\u0001\u0007\u0011q\u000f\u0005\b\u0003#S\u0003\u0019AAK\u0011\u001d\t\u0019K\u000ba\u0001\u0003O\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u000e\ne\u0005#\u00023\u0003\u0010\nM\u0015b\u0001BIK\n1q\n\u001d;j_:\u00042\u0003\u001aBK\u00033\tY#a\u000e\u0002D\u0005U\u0013qOAK\u0003OK1Aa&f\u0005\u0019!V\u000f\u001d7fq!I!1T\u0016\u0002\u0002\u0003\u0007\u0011QW\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012\u0001\u001d\u000b\t\u0005G\u001bika,\u00042B\u0011\u0001-N\n\u0006k\r\fy![\u0001\u0003S\u0012\f1!\u001b3!\u0003%)g\u000e\u001a)pS:$8/\u0006\u0002\u00030B1!Q\bBY\u0005kKAAa-\u0003@\t\u00191+Z9\u0011\u0007\u0001\u00149,C\u0002\u0003:j\u0013\u0001\"\u00128e!>Lg\u000e^\u0001\u000bK:$\u0007k\\5oiN\u0004\u0013\u0001\u0002:bG.,\"A!1\u0011\u000b\u0011\u0014y)a\u0017\u0002\u000bI\f7m\u001b\u0011\u0002\u0011\u0019,\u0017\r^;sKN,\"A!3\u0011\r\t-'\u0011\u001bBk\u001b\t\u0011iM\u0003\u0003\u0003P\u0006u\u0011a\u00024fCR,(/Z\u0005\u0005\u0005'\u0014iM\u0001\u0005GK\u0006$XO]3t!\u0011\u0011YMa6\n\t\te'Q\u001a\u0002\u0016'V\u0004\bo\u001c:uK\u00124VM]:j_:\u0014\u0016M\\4f\u0003%1W-\u0019;ve\u0016\u001c\b%\u0001\u0003uC\u001e\u001cXC\u0001Bq!!\tiFa9\u0002\\\u0005m\u0013\u0002\u0002Bs\u0003_\u00121!T1q\u0003\u0015!\u0018mZ:!)1\u0011\u0019Ka;\u0003n\n=(\u0011\u001fBz\u0011\u001d\u00119\u000b\u0011a\u0001\u0003WAqAa+A\u0001\u0004\u0011y\u000bC\u0004\u0003>\u0002\u0003\rA!1\t\u000f\t\u0015\u0007\t1\u0001\u0003J\"9!Q\u001c!A\u0002\t\u0005\u0018\u0001D3oIB{\u0017N\u001c;t\u001b\u0006\u0004XC\u0001B}!!\u0011Yp!\u0001\u0004\u0004\tUVB\u0001B\u007f\u0015\u0011\u0011yPa\u0010\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002Bs\u0005{\u0004Ba!\u0002\u0004\f5\u00111q\u0001\u0006\u0005\u0007\u0013\ti\"A\u0004oKR<xN]6\n\t\r51q\u0001\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u000eK:$\u0007k\\5oiNl\u0015\r\u001d\u0011\u0015\u0005\u0005mC\u0003\u0004BR\u0007+\u00199ba\u0007\u0004 \r\r\u0002b\u0002BT\t\u0002\u0007\u00111\u0006\u0005\b\u00073!\u0005\u0019AA.\u0003\u0011Awn\u001d;\t\u000f\ruA\t1\u0001\u0002,\u0005!\u0001o\u001c:u\u0011\u001d\u0019\t\u0003\u0012a\u0001\u0007\u0007\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016Dqa!\nE\u0001\u0004\u00199#\u0001\u0005qe>$xnY8m!\u0011\u0019Ica\r\u000e\u0005\r-\"\u0002BB\u0017\u0007_\tA!Y;uQ*!1\u0011GA\u000f\u0003!\u0019XmY;sSRL\u0018\u0002BB\u001b\u0007W\u0011\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0015\u0011\t\r6\u0011HB\"\u0007\u000bBqaa\u000fF\u0001\u0004\u0019i$A\u0002cKB\u00042\u0001YB \u0013\r\u0019\tE\u0017\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0011\u001d\u0019\t#\u0012a\u0001\u0007\u0007Aqa!\nF\u0001\u0004\u00199#\u0001\u0003o_\u0012,G\u0003BB&\u0007#\u0002B!a\u0007\u0004N%!1qJA\u000f\u0005\u0011qu\u000eZ3\t\u000f\r\u0005b\t1\u0001\u0004\u0004\u00059q-\u001a;O_\u0012,G\u0003BB,\u00073\u0002R\u0001\u001aBH\u0007\u0017Bqa!\tH\u0001\u0004\u0019\u0019!\u0001\bce>\\WM]#oIB{\u0017N\u001c;\u0015\t\ru2q\f\u0005\b\u0007CA\u0005\u0019AB\u0002\u0003!)g\u000e\u001a)pS:$H\u0003\u0002B[\u0007KBqa!\tJ\u0001\u0004\u0019\u0019!\u0001\u0007u_N+'O^3s\u0013:4w\u000eF\u0006y\u0007W\u001ayg! \u0004\u0000\r\u0005\u0005bBB7\u0015\u0002\u0007\u00111L\u0001\nG2,8\u000f^3s\u0013\u0012Dqa!\u001dK\u0001\u0004\u0019\u0019(\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0007k\u001aI(\u0004\u0002\u0004x)\u0011q\u0010X\u0005\u0005\u0007w\u001a9HA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bBA:\u0015\u0002\u0007\u0011q\u000f\u0005\n\u0003#S\u0005\u0013!a\u0001\u0003+Cq!a)K\u0001\u0004\t9+\u0001\fu_N+'O^3s\u0013:4w\u000e\n3fM\u0006,H\u000e\u001e\u00135)1\u0011\u0019ka\"\u0004\n\u000e-5QRBH\u0011%\u00119\u000b\u0014I\u0001\u0002\u0004\tY\u0003C\u0005\u0003,2\u0003\n\u00111\u0001\u00030\"I!Q\u0018'\u0011\u0002\u0003\u0007!\u0011\u0019\u0005\n\u0005\u000bd\u0005\u0013!a\u0001\u0005\u0013D\u0011B!8M!\u0003\u0005\rA!9\u0016\u0005\rM%\u0006\u0002BX\u0003G,\"aa&+\t\t\u0005\u00171]\u000b\u0003\u00077SCA!3\u0002dV\u00111q\u0014\u0016\u0005\u0005C\f\u0019\u000f\u0006\u0003\u0003.\r\r\u0006\"\u0003B\u001b)\u0006\u0005\t\u0019AA\u0016)\u0011\u0011Yea*\t\u0013\tUb+!AA\u0002\t5B\u0003\u0002B&\u0007WC\u0011B!\u000eY\u0003\u0003\u0005\rA!\f\t\u000f\t\u001dV\u00061\u0001\u0002,!9!1V\u0017A\u0002\t=\u0006b\u0002B_[\u0001\u0007!\u0011\u0019\u000b\u000b\u0005G\u001b)la.\u0004:\u000em\u0006b\u0002BT]\u0001\u0007\u00111\u0006\u0005\b\u0005Ws\u0003\u0019\u0001BX\u0011\u001d\u0011iL\fa\u0001\u0005\u0003DqA!2/\u0001\u0004\u0011I\r\u0006\u0006\u0003$\u000e}6\u0011YBb\u0007\u000bDqAa*0\u0001\u0004\tY\u0003C\u0004\u0003,>\u0002\rAa,\t\u000f\tuv\u00061\u0001\u0003B\"9!Q\\\u0018A\u0002\t\u0005\u0018!E:vaB|'\u000f^3e\r\u0016\fG/\u001e:fgR!11ZBh!!\tId!4\u0002\\\tU\u0017\u0002\u0002Bs\u0003wAqA!21\u0001\u0004\u0019\t\u000e\u0005\u0005\u0002:\r5\u00171LBj!\u0011\u0019)na7\u000e\u0005\r]'\u0002BBm\u0003\u0003\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0007;\u001c9N\u0001\u0007WKJ\u001c\u0018n\u001c8SC:<W-\u0001\fge>l'I]8lKJ\u0014VmZ5tiJ\fG/[8o)\u0011\u0011\u0019ka9\t\u000f\r\u0015\u0018\u00071\u0001\u0004h\u0006a!/Z4jgR\u0014\u0018\r^5p]B!1Q[Bu\u0013\u0011\u0019Yoa6\u0003%\t\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u000b\r\u0005G\u001byo!=\u0004t\u000eU8q\u001f\u0005\b\u0005O\u0013\u0004\u0019AA\u0016\u0011\u001d\u0011YK\ra\u0001\u0005_CqA!03\u0001\u0004\u0011\t\rC\u0004\u0003FJ\u0002\rA!3\t\u000f\tu'\u00071\u0001\u0003bR!11 C\u0002!\u0015!'qRB\u007f!5!7q`A\u0016\u0005_\u0013\tM!3\u0003b&\u0019A\u0011A3\u0003\rQ+\b\u000f\\36\u0011%\u0011YjMA\u0001\u0002\u0004\u0011\u0019\u000b")
public class Broker
implements Product,
scala.Serializable {
    private final int id;
    private final Seq<EndPoint> endPoints;
    private final Option<String> rack;
    private final Features<SupportedVersionRange> features;
    private final scala.collection.immutable.Map<String, String> tags;
    private final scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap;

    public static Option<Tuple5<Object, Seq<EndPoint>, Option<String>, Features<SupportedVersionRange>, scala.collection.immutable.Map<String, String>>> unapply(Broker broker) {
        return Broker$.MODULE$.unapply(broker);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> map) {
        return Broker$.MODULE$.apply(n, seq, option, features, map);
    }

    public static Broker fromBrokerRegistration(BrokerRegistration brokerRegistration) {
        return Broker$.MODULE$.fromBrokerRegistration(brokerRegistration);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, scala.collection.immutable.Map<String, String> map) {
        return Broker$.MODULE$.apply(n, seq, option, map);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, Features<SupportedVersionRange> features) {
        return Broker$.MODULE$.apply(n, seq, option, features);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option) {
        return Broker$.MODULE$.apply(n, seq, option);
    }

    public int id() {
        return this.id;
    }

    public Seq<EndPoint> endPoints() {
        return this.endPoints;
    }

    public Option<String> rack() {
        return this.rack;
    }

    public Features<SupportedVersionRange> features() {
        return this.features;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap() {
        return this.endPointsMap;
    }

    public String toString() {
        return new StringBuilder(9).append(this.id()).append(" : ").append(this.endPointsMap().values().mkString("(", ",", ")")).append(" : ").append(this.rack().orNull(Predef$.MODULE$.$conforms())).append(" : ").append(this.features()).toString();
    }

    public Node node(ListenerName listenerName) {
        return (Node)this.getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found ").append("for broker ").append(this.id()).toString());
        });
    }

    public Option<Node> getNode(ListenerName listenerName) {
        return this.endPointsMap().get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)endpoint -> new ConfluentNode(this.id(), endpoint.host(), endpoint.port(), (String)this.rack().orNull(Predef$.MODULE$.$conforms()), (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava()));
    }

    public BrokerEndPoint brokerEndPoint(ListenerName listenerName) {
        EndPoint endpoint = this.endPoint(listenerName);
        return new BrokerEndPoint(this.id(), endpoint.host(), endpoint.port());
    }

    public EndPoint endPoint(ListenerName listenerName) {
        return (EndPoint)this.endPointsMap().getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found for broker ").append(this.id()).toString());
        });
    }

    public ConfluentAuthorizerServerInfo toServerInfo(String clusterId, KafkaConfig config, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
        ClusterResource clusterResource = new ClusterResource(clusterId);
        Endpoint interBrokerEndpoint = this.endPoint(config.interBrokerListenerName()).toJava();
        java.util.List brokerEndpoints = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.endPoints().toList().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJava(), List$.MODULE$.canBuildFrom())).asJava();
        return new ServerInfo(clusterResource, this.id(), brokerEndpoints, interBrokerEndpoint, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)config.earlyStartListeners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value(), Set$.MODULE$.canBuildFrom())).asJava(), httpServerBinder, auditLogProvider, metrics);
    }

    public AuditLogProvider toServerInfo$default$4() {
        return NoOpAuditLogProvider.INSTANCE;
    }

    public Broker copy(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        return new Broker(id, endPoints, rack, features, tags);
    }

    public int copy$default$1() {
        return this.id();
    }

    public Seq<EndPoint> copy$default$2() {
        return this.endPoints();
    }

    public Option<String> copy$default$3() {
        return this.rack();
    }

    public Features<SupportedVersionRange> copy$default$4() {
        return this.features();
    }

    public scala.collection.immutable.Map<String, String> copy$default$5() {
        return this.tags();
    }

    public String productPrefix() {
        return "Broker";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.id());
            }
            case 1: {
                return this.endPoints();
            }
            case 2: {
                return this.rack();
            }
            case 3: {
                return this.features();
            }
            case 4: {
                return this.tags();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Broker;
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.id()), (int)Statics.anyHash(this.endPoints())), (int)Statics.anyHash(this.rack())), (int)Statics.anyHash(this.features())), (int)Statics.anyHash(this.tags())), (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof Broker)) return false;
        boolean bl = true;
        if (!bl) return false;
        Broker broker = (Broker)x$1;
        if (this.id() != broker.id()) return false;
        Seq<EndPoint> seq = this.endPoints();
        Seq<EndPoint> seq2 = broker.endPoints();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<String> option = this.rack();
        Option<String> option2 = broker.rack();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Features<SupportedVersionRange> features = this.features();
        Features<SupportedVersionRange> features2 = broker.features();
        if (features == null) {
            if (features2 != null) {
                return false;
            }
        } else if (!features.equals(features2)) return false;
        scala.collection.immutable.Map<String, String> map = this.tags();
        scala.collection.immutable.Map<String, String> map2 = broker.tags();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!broker.canEqual(this)) return false;
        return true;
    }

    public Broker(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        this.id = id;
        this.endPoints = endPoints;
        this.rack = rack;
        this.features = features;
        this.tags = tags;
        Product.$init$((Product)this);
        this.endPointsMap = ((TraversableOnce)endPoints.map((Function1 & Serializable & scala.Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName()), endPoint), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (this.endPointsMap().size() != endPoints.size()) {
            throw new IllegalArgumentException(new StringBuilder(62).append("There is more than one end point with the same listener name: ").append(endPoints.mkString(",")).toString());
        }
    }

    public Broker(int id, String host, int port, ListenerName listenerName, SecurityProtocol protocol) {
        this(id, (Seq<EndPoint>)new .colon.colon((Object)new EndPoint(host, port, listenerName, protocol), (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, (Features<SupportedVersionRange>)Features.emptySupportedFeatures(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public Broker(BrokerEndPoint bep, ListenerName listenerName, SecurityProtocol protocol) {
        this(bep.id(), bep.host(), bep.port(), listenerName, protocol);
    }

    public static class ServerInfo
    implements ConfluentAuthorizerServerInfo,
    Product,
    scala.Serializable {
        private final ClusterResource clusterResource;
        private final int brokerId;
        private final java.util.List<Endpoint> endpoints;
        private final Endpoint interBrokerEndpoint;
        private final java.util.Set<String> earlyStartListeners;
        private final KafkaHttpServerBinder httpServerBinder;
        private final AuditLogProvider auditLogProvider;
        private final Metrics metrics;

        public java.util.List<String> additionalRoleDefFiles() {
            return super.additionalRoleDefFiles();
        }

        public ClusterResource clusterResource() {
            return this.clusterResource;
        }

        public int brokerId() {
            return this.brokerId;
        }

        public java.util.List<Endpoint> endpoints() {
            return this.endpoints;
        }

        public Endpoint interBrokerEndpoint() {
            return this.interBrokerEndpoint;
        }

        public java.util.Set<String> earlyStartListeners() {
            return this.earlyStartListeners;
        }

        public KafkaHttpServerBinder httpServerBinder() {
            return this.httpServerBinder;
        }

        public AuditLogProvider auditLogProvider() {
            return this.auditLogProvider;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public ServerInfo copy(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, java.util.Set<String> earlyStartListeners, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
            return new ServerInfo(clusterResource, brokerId, endpoints, interBrokerEndpoint, earlyStartListeners, httpServerBinder, auditLogProvider, metrics);
        }

        public ClusterResource copy$default$1() {
            return this.clusterResource();
        }

        public int copy$default$2() {
            return this.brokerId();
        }

        public java.util.List<Endpoint> copy$default$3() {
            return this.endpoints();
        }

        public Endpoint copy$default$4() {
            return this.interBrokerEndpoint();
        }

        public java.util.Set<String> copy$default$5() {
            return this.earlyStartListeners();
        }

        public KafkaHttpServerBinder copy$default$6() {
            return this.httpServerBinder();
        }

        public AuditLogProvider copy$default$7() {
            return this.auditLogProvider();
        }

        public Metrics copy$default$8() {
            return this.metrics();
        }

        public String productPrefix() {
            return "ServerInfo";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.clusterResource();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.brokerId());
                }
                case 2: {
                    return this.endpoints();
                }
                case 3: {
                    return this.interBrokerEndpoint();
                }
                case 4: {
                    return this.earlyStartListeners();
                }
                case 5: {
                    return this.httpServerBinder();
                }
                case 6: {
                    return this.auditLogProvider();
                }
                case 7: {
                    return this.metrics();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServerInfo;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.clusterResource())), (int)this.brokerId()), (int)Statics.anyHash((Object)this.endpoints())), (int)Statics.anyHash((Object)this.interBrokerEndpoint())), (int)Statics.anyHash((Object)this.earlyStartListeners())), (int)Statics.anyHash((Object)this.httpServerBinder())), (int)Statics.anyHash((Object)this.auditLogProvider())), (int)Statics.anyHash((Object)this.metrics())), (int)8);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ServerInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            ServerInfo serverInfo = (ServerInfo)x$1;
            ClusterResource clusterResource = this.clusterResource();
            ClusterResource clusterResource2 = serverInfo.clusterResource();
            if (clusterResource == null) {
                if (clusterResource2 != null) {
                    return false;
                }
            } else if (!clusterResource.equals(clusterResource2)) return false;
            if (this.brokerId() != serverInfo.brokerId()) return false;
            Collection collection = this.endpoints();
            Collection collection2 = serverInfo.endpoints();
            if (collection == null) {
                if (collection2 != null) {
                    return false;
                }
            } else if (!((Object)collection).equals(collection2)) return false;
            Endpoint endpoint = this.interBrokerEndpoint();
            Endpoint endpoint2 = serverInfo.interBrokerEndpoint();
            if (endpoint == null) {
                if (endpoint2 != null) {
                    return false;
                }
            } else if (!endpoint.equals(endpoint2)) return false;
            Collection collection3 = this.earlyStartListeners();
            Collection collection4 = serverInfo.earlyStartListeners();
            if (collection3 == null) {
                if (collection4 != null) {
                    return false;
                }
            } else if (!((Object)collection3).equals(collection4)) return false;
            KafkaHttpServerBinder kafkaHttpServerBinder = this.httpServerBinder();
            KafkaHttpServerBinder kafkaHttpServerBinder2 = serverInfo.httpServerBinder();
            if (kafkaHttpServerBinder == null) {
                if (kafkaHttpServerBinder2 != null) {
                    return false;
                }
            } else if (!kafkaHttpServerBinder.equals(kafkaHttpServerBinder2)) return false;
            AuditLogProvider auditLogProvider = this.auditLogProvider();
            AuditLogProvider auditLogProvider2 = serverInfo.auditLogProvider();
            if (auditLogProvider == null) {
                if (auditLogProvider2 != null) {
                    return false;
                }
            } else if (!auditLogProvider.equals(auditLogProvider2)) return false;
            Metrics metrics = this.metrics();
            Metrics metrics2 = serverInfo.metrics();
            if (metrics == null) {
                if (metrics2 != null) {
                    return false;
                }
            } else if (!metrics.equals(metrics2)) return false;
            if (!serverInfo.canEqual(this)) return false;
            return true;
        }

        public ServerInfo(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, java.util.Set<String> earlyStartListeners, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
            this.clusterResource = clusterResource;
            this.brokerId = brokerId;
            this.endpoints = endpoints;
            this.interBrokerEndpoint = interBrokerEndpoint;
            this.earlyStartListeners = earlyStartListeners;
            this.httpServerBinder = httpServerBinder;
            this.auditLogProvider = auditLogProvider;
            this.metrics = metrics;
            Product.$init$((Product)this);
        }
    }
}

