/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.Optional;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.cluster.RackAndRequiredReplicaCountsAndEligibleBrokers;
import kafka.cluster.RackIndexAndAssignment;
import kafka.cluster.RackIndexAndReplicasCount;
import kafka.cluster.RequiredReplicaCountsAndEligibleBrokers;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.metadata.TopicPlacement;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class Observer$ {
    public static Observer$ MODULE$;
    private final String RackConstraintKey;

    static {
        new Observer$();
    }

    public String RackConstraintKey() {
        return this.RackConstraintKey;
    }

    public Map<Object, ReplicaAssignment> getReplicaAssignment(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement, int numPartitions, int replicationFactor, boolean topicPlacementRackMixingSupportedEnabled, int fixedStartIndex, int startPartitionId) {
        if (topicPlacementRackMixingSupportedEnabled) {
            return this.getReplicaAssignmentWithRackMixingSupport(brokers, topicPlacement, numPartitions, replicationFactor, fixedStartIndex, startPartitionId);
        }
        return this.getReplicaAssignmentWithoutRackMixingSupport(brokers, topicPlacement, numPartitions, replicationFactor, fixedStartIndex, startPartitionId);
    }

    public int getReplicaAssignment$default$6() {
        return -1;
    }

    public int getReplicaAssignment$default$7() {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Object, ReplicaAssignment> getReplicaAssignmentWithoutRackMixingSupport(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement2, int numPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        void var9_9;
        void var8_8;
        Tuple2 tuple2 = (Tuple2)topicPlacement2.map((Function1 & Serializable & scala.Serializable)topicPlacement -> new Tuple2(MODULE$.partitionBrokersByConstraint(brokers, (Seq<TopicPlacement.ConstraintCount>)((Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala())), MODULE$.partitionBrokersByConstraint(brokers, (Seq<TopicPlacement.ConstraintCount>)((Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicationFactor)), (Object)brokers), (List)Nil$.MODULE$), (Object)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq replicationAndSyncEligible = (Seq)tuple2._1();
        Seq replicationAndObserverEligible = (Seq)tuple2._2();
        void replicationAndSyncEligible2 = var8_8;
        void replicationAndObserverEligible2 = var9_9;
        this.validatePartitioning((Seq<Seq<BrokerMetadata>>)((Seq)((TraversableLike)replicationAndSyncEligible2.$plus$plus((GenTraversableOnce)replicationAndObserverEligible2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)x$2._2(), Seq$.MODULE$.canBuildFrom())));
        return this.partitionReplicaAssignment((Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)replicationAndSyncEligible2, numPartitions, fixedStartIndex, startPartitionId), (Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)replicationAndObserverEligible2, numPartitions, fixedStartIndex, startPartitionId));
    }

    /*
     * WARNING - void declaration
     */
    private Map<Object, ReplicaAssignment> getReplicaAssignmentWithRackMixingSupport(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement2, int numPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        void var10_10;
        void var9_9;
        Seq requiredReplicaCountsAndEligibleBrokers = (Seq)topicPlacement2.map((Function1 & Serializable & scala.Serializable)topicPlacement -> MODULE$.buildRequiredReplicaCountsAndEligibleBrokers((TopicPlacement)topicPlacement, brokers)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new .colon.colon((Object)new RequiredReplicaCountsAndEligibleBrokers(replicationFactor, 0, brokers, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$));
        this.validatePartitioning((Seq<Seq<BrokerMetadata>>)((Seq)requiredReplicaCountsAndEligibleBrokers.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.eligibleBrokers(), Seq$.MODULE$.canBuildFrom())));
        Tuple2<scala.collection.mutable.Map<Object, Seq<Object>>, scala.collection.mutable.Map<Object, Seq<Object>>> tuple2 = this.assignReplicasToPartitionsWithRackMixingSupport((Seq<RequiredReplicaCountsAndEligibleBrokers>)requiredReplicaCountsAndEligibleBrokers, numPartitions, fixedStartIndex, startPartitionId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map syncReplicaAssignments = (scala.collection.mutable.Map)tuple2._1();
        scala.collection.mutable.Map observerAssignments = (scala.collection.mutable.Map)tuple2._2();
        void syncReplicaAssignments2 = var9_9;
        void observerAssignments2 = var10_10;
        return this.partitionReplicaAssignment((Map<Object, Seq<Object>>)syncReplicaAssignments2, (Map<Object, Seq<Object>>)observerAssignments2);
    }

    public void validateTopicPlacementUpdate(TopicPlacement topicPlacement, Seq<BrokerMetadata> brokers) {
        this.validatePartitioning((Seq<Seq<BrokerMetadata>>)((Seq)this.buildRequiredReplicaCountsAndEligibleBrokers(topicPlacement, brokers).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.eligibleBrokers(), Seq$.MODULE$.canBuildFrom())));
    }

    public Seq<RequiredReplicaCountsAndEligibleBrokers> buildRequiredReplicaCountsAndEligibleBrokers(TopicPlacement topicPlacement, Seq<BrokerMetadata> brokers) {
        Map syncReplicasKeyedByRack = (Map)((TraversableOnce)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foldLeft((Object)Map$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(map, constraintCountAndIndex) -> MODULE$.keyByRackFunc("Replicas contains duplicate constraint", (scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount>)map, (Tuple2<TopicPlacement.ConstraintCount, Object>)constraintCountAndIndex));
        Map observersKeyedByRack = (Map)((TraversableOnce)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foldLeft((Object)Map$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(map, constraintCountAndIndex) -> MODULE$.keyByRackFunc("Observers contains duplicate constraint", (scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount>)map, (Tuple2<TopicPlacement.ConstraintCount, Object>)constraintCountAndIndex));
        Seq requiredReplicaCountsAndEligibleBrokers = ((SetLike)syncReplicasKeyedByRack.keySet().$plus$plus((GenTraversableOnce)observersKeyedByRack.keySet()).map((Function1 & Serializable & scala.Serializable)rack -> {
            void var9_13;
            void var6_8;
            int n;
            None$ none$;
            int n2;
            None$ none$2;
            Option option = syncReplicasKeyedByRack.get(rack);
            if (option instanceof Some) {
                RackIndexAndReplicasCount x = (RackIndexAndReplicasCount)((Some)option).value();
                none$2 = new Some((Object)BoxesRunTime.boxToInteger((int)x.rackIndex()));
                n2 = x.replicaCount();
            } else if (None$.MODULE$.equals(option)) {
                none$2 = None$.MODULE$;
                n2 = 0;
            } else {
                throw new MatchError((Object)option);
            }
            Option syncReplicaIndex = (Option)none$2;
            Option option2 = observersKeyedByRack.get(rack);
            if (option2 instanceof Some) {
                RackIndexAndReplicasCount x = (RackIndexAndReplicasCount)((Some)option2).value();
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)x.rackIndex()));
                n = x.replicaCount();
            } else if (None$.MODULE$.equals(option2)) {
                none$ = None$.MODULE$;
                n = 0;
            } else {
                throw new MatchError((Object)option2);
            }
            Option observersIndex = (Option)none$;
            Seq matchedBrokers = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (Map<String, String>)rack)));
            return new RackAndRequiredReplicaCountsAndEligibleBrokers((Map<String, String>)rack, new RequiredReplicaCountsAndEligibleBrokers(n2, n, (Seq<BrokerMetadata>)matchedBrokers, (Option<Object>)var6_8, (Option<Object>)var9_13));
        }, Set$.MODULE$.canBuildFrom())).toSeq();
        Seq invalidRacks = (Seq)requiredReplicaCountsAndEligibleBrokers.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Observer$.$anonfun$buildRequiredReplicaCountsAndEligibleBrokers$5(x)));
        if (invalidRacks.size() > 0) {
            String detailedErrMsg = ((Seq)invalidRacks.map((Function1 & Serializable & scala.Serializable)x0$1 -> new StringBuilder(106).append("for constraint ").append(x0$1.rack()).append(" there are ").append(x0$1.countsAndEligibleBrokers().eligibleBrokers().size()).append(" ").append("matching brokers but the topic placement requires ").append(x0$1.countsAndEligibleBrokers().syncReplicas()).append(" sync replicas and ").append(x0$1.countsAndEligibleBrokers().observers()).append(" observers").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            throw new InvalidConfigurationException(new StringBuilder(39).append("Failed to satisfy the topic placement: ").append(detailedErrMsg).toString());
        }
        return (Seq)requiredReplicaCountsAndEligibleBrokers.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.countsAndEligibleBrokers(), Seq$.MODULE$.canBuildFrom());
    }

    private scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount> keyByRackFunc(String errorMsg, scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount> map, Tuple2<TopicPlacement.ConstraintCount, Object> constraintCountAndIndex) {
        Option option = map.get(CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)constraintCountAndIndex._1()).constraints()).asScala());
        if (option instanceof Some) {
            throw new InvalidConfigurationException(errorMsg);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        map.put(CollectionConverters$.MODULE$.mapAsScalaMapConverter(((TopicPlacement.ConstraintCount)constraintCountAndIndex._1()).constraints()).asScala(), (Object)new RackIndexAndReplicasCount(constraintCountAndIndex._2$mcI$sp(), ((TopicPlacement.ConstraintCount)constraintCountAndIndex._1()).count()));
        return map;
    }

    private scala.collection.mutable.Map<Object, Seq<Object>> assignReplicasToPartitions(Seq<Tuple2<Object, Seq<BrokerMetadata>>> replicationAndBrokers, int partitions, int fixedStartIndex, int startPartitionId) {
        return (scala.collection.mutable.Map)((TraversableOnce)replicationAndBrokers.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int replication = x0$1._1$mcI$sp();
            Seq brokerList = (Seq)x0$1._2();
            Map<Object, Seq<Object>> map = AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)brokerList, partitions, replication, fixedStartIndex, startPartitionId);
            return map;
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Map$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment));
    }

    private Tuple2<scala.collection.mutable.Map<Object, Seq<Object>>, scala.collection.mutable.Map<Object, Seq<Object>>> assignReplicasToPartitionsWithRackMixingSupport(Seq<RequiredReplicaCountsAndEligibleBrokers> requiredReplicaCountsAndEligibleBrokers, int numPartitions, int fixedStartIndex, int startPartitionId) {
        Seq syncReplicaAndObserverAssignments = (Seq)requiredReplicaCountsAndEligibleBrokers.map((Function1 & Serializable & scala.Serializable)countsAndBrokers -> {
            int numSyncReplicas = countsAndBrokers.syncReplicas();
            int numObservers = countsAndBrokers.observers();
            int replicationFactor = numSyncReplicas + numObservers;
            return (Map)AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)countsAndBrokers.eligibleBrokers(), numPartitions, replicationFactor, fixedStartIndex, startPartitionId).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void var7_6;
                void var6_5;
                int partition;
                if (x0$1 != null) {
                    partition = x0$1._1$mcI$sp();
                    Tuple2 tuple2 = ((Seq)x0$1._2()).splitAt(numSyncReplicas);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    Seq syncReplicaAssignment = (Seq)tuple2._1();
                    Seq observerAssignment = (Seq)tuple2._2();
                } else {
                    throw new MatchError(null);
                }
                void syncReplicaAssignment = var6_5;
                void observerAssignment = var7_6;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)new Tuple2((Object)new RackIndexAndAssignment(countsAndBrokers.syncReplicasRackIndex(), (Seq<Object>)syncReplicaAssignment), (Object)new RackIndexAndAssignment(countsAndBrokers.observersRackIndex(), (Seq<Object>)observerAssignment)));
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom());
        }, Seq$.MODULE$.canBuildFrom());
        Seq syncReplicaOrderedAssignments = (Seq)((TraversableLike)((TraversableLike)((SeqLike)((TraversableLike)((Seq)syncReplicaAndObserverAssignments.map((Function1 & Serializable & scala.Serializable)assignment -> (Map)assignment.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            int partition;
            block3: {
                block2: {
                    if (x0$2 == null) break block2;
                    partition = x0$2._1$mcI$sp();
                    tuple2 = (Tuple2)x0$2._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError(x0$2);
            }
            RackIndexAndAssignment indexAndAssignment = (RackIndexAndAssignment)tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)indexAndAssignment);
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x -> x.toSeq(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Observer$.$anonfun$assignReplicasToPartitionsWithRackMixingSupport$6(x)))).sortWith((Function2 & Serializable & scala.Serializable)(t1, t2) -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.sortWithPartitionAndRackIndex((Tuple2<Object, RackIndexAndAssignment>)t1, (Tuple2<Object, RackIndexAndAssignment>)t2)))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), ((RackIndexAndAssignment)x._2()).assignment()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())), x._2())})), Seq$.MODULE$.canBuildFrom());
        Seq observerOrderedAssignments = (Seq)((TraversableLike)((TraversableLike)((SeqLike)((TraversableLike)((Seq)syncReplicaAndObserverAssignments.map((Function1 & Serializable & scala.Serializable)assignment -> (Map)assignment.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2;
            int partition;
            block3: {
                block2: {
                    if (x0$3 == null) break block2;
                    partition = x0$3._1$mcI$sp();
                    tuple2 = (Tuple2)x0$3._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError(x0$3);
            }
            RackIndexAndAssignment observerAssignment = (RackIndexAndAssignment)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)observerAssignment);
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x -> x.toSeq(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Observer$.$anonfun$assignReplicasToPartitionsWithRackMixingSupport$13(x)))).sortWith((Function2 & Serializable & scala.Serializable)(t1, t2) -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.sortWithPartitionAndRackIndex((Tuple2<Object, RackIndexAndAssignment>)t1, (Tuple2<Object, RackIndexAndAssignment>)t2)))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), ((RackIndexAndAssignment)x._2()).assignment()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())), x._2())})), Seq$.MODULE$.canBuildFrom());
        return new Tuple2(syncReplicaOrderedAssignments.foldLeft((Object)Map$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment)), observerOrderedAssignments.foldLeft((Object)Map$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment)));
    }

    /*
     * WARNING - void declaration
     */
    public boolean sortWithPartitionAndRackIndex(Tuple2<Object, RackIndexAndAssignment> t1, Tuple2<Object, RackIndexAndAssignment> t2) {
        void var6_6;
        void var4_4;
        Option<Object> option = ((RackIndexAndAssignment)t1._2()).rackIndex();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("The rack index of t1 is None which is not sortable.");
            }
            throw new MatchError(option);
        }
        int v = BoxesRunTime.unboxToInt((Object)((Some)option).value());
        Option<Object> option2 = ((RackIndexAndAssignment)t2._2()).rackIndex();
        if (!(option2 instanceof Some)) {
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalStateException("The rack index of t2 is None which is not sortable.");
            }
            throw new MatchError(option2);
        }
        int v2 = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
        if (t1._1$mcI$sp() < t2._1$mcI$sp()) {
            return true;
        }
        if (t1._1$mcI$sp() > t2._1$mcI$sp()) {
            return false;
        }
        return var4_4 < var6_6;
    }

    private Map<Object, ReplicaAssignment> partitionReplicaAssignment(Map<Object, Seq<Object>> syncReplicas, Map<Object, Seq<Object>> observerReplicas) {
        if (observerReplicas.nonEmpty()) {
            Set set = syncReplicas.keySet();
            Set set2 = observerReplicas.keySet();
            if (set == null ? set2 != null : !set.equals(set2)) {
                int syncSize = syncReplicas.keySet().size();
                int observerSize = observerReplicas.keySet().size();
                throw new InvalidConfigurationException(new StringBuilder(115).append("Must assign observers to all or none of the partitions. ").append(syncSize).append(" partitions with sync replicas. ").append(observerSize).append(" partitions with observers.").toString());
            }
        }
        return (Map)syncReplicas.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Seq observerAssignment = (Seq)observerReplicas.getOrElse((Object)BoxesRunTime.boxToInteger((int)partition), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)((Seq)replicas.$plus$plus((GenTraversableOnce)observerAssignment, Seq$.MODULE$.canBuildFrom())), (Seq<Object>)observerAssignment));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Object, Seq<BrokerMetadata>>> partitionBrokersByConstraint(Seq<BrokerMetadata> brokers, Seq<TopicPlacement.ConstraintCount> constraints) {
        return (Seq)constraints.map((Function1 & Serializable & scala.Serializable)constraint -> {
            Seq matchedBrokers = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, constraint)));
            if (matchedBrokers.size() < constraint.count()) {
                throw new InvalidConfigurationException(new StringBuilder(75).append("Number of broker found (").append(matchedBrokers.size()).append(") matching ").append("constraint ").append(constraint).append(" is less than required count ").append(constraint.count()).toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)constraint.count()), (Object)matchedBrokers);
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public void validatePartitioning(Seq<Seq<BrokerMetadata>> partitionedBrokers) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = (Tuple2)partitionedBrokers.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable & scala.Serializable)(acc, brokers) -> {
            void var3_3;
            void var2_2;
            if (acc == null) {
                throw new MatchError(null);
            }
            int count = acc._1$mcI$sp();
            scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)acc._2();
            if (brokers.toSet().size() != brokers.size()) {
                throw new InvalidConfigurationException(new StringBuilder(58).append("Duplicate eligible brokers ").append(brokers).append(" match a placement constraints.").toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(var2_2 + brokers.size())), (Object)var3_3.$plus$plus((GenTraversableOnce)brokers));
        });
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int count = tuple2._1$mcI$sp();
        scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)tuple2._2();
        if (var3_3 != var4_4.size()) {
            throw new InvalidConfigurationException(new StringBuilder(58).append("Some brokers satisfy more than one placement constraints: ").append(partitionedBrokers).toString());
        }
    }

    public scala.collection.mutable.Map<Object, Seq<Object>> mergeAssignmentMap(scala.collection.mutable.Map<Object, Seq<Object>> mergedAssignment, Map<Object, Seq<Object>> currentAssignment) {
        return mergedAssignment.$plus$plus((GenTraversableOnce)currentAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partitionId = x0$1._1$mcI$sp();
            Seq replicaIds = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), MODULE$.mergeReplicaLists((Seq<Object>)((Seq)mergedAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), (Seq<Object>)replicaIds));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
    }

    public Seq<Object> mergeReplicaLists(Seq<Object> brokerList1, Seq<Object> brokerList2) {
        Seq commonReplicas = (Seq)brokerList1.intersect(brokerList2);
        if (commonReplicas.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(64).append("Replica with ids (").append(commonReplicas).append(") satisfy more than one placement constraints.").toString());
        }
        return (Seq)brokerList1.$plus$plus(brokerList2, Seq$.MODULE$.canBuildFrom());
    }

    public boolean brokerMatchesPlacementConstraint(BrokerMetadata broker, TopicPlacement.ConstraintCount constraint) {
        return this.brokerMatchesPlacementConstraint(broker, (Map<String, String>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(constraint.constraints()).asScala()));
    }

    public boolean brokerMatchesPlacementConstraint(BrokerMetadata broker, Map<String, String> rack2) {
        scala.collection.immutable.Map properties = Option$.MODULE$.option2Iterable(broker.rack().map((Function1 & Serializable & scala.Serializable)rack -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.RackConstraintKey()), rack))).toMap(Predef$.MODULE$.$conforms());
        return TopicPlacement.ConstraintCount.isSubset((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(rack2).asJava()), (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)properties).asJava()));
    }

    public Option<ApiError> validateAssignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment.Assignment assignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return this.validateAssignmentStructure(assignment).orElse((Function0 & Serializable & scala.Serializable)() -> topicPlacement.flatMap((Function1 & Serializable & scala.Serializable)placementConstraint -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment((TopicPlacement)placementConstraint, (java.util.List)((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment.syncReplicas().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateAssignment$3(liveBrokerAttributes, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava()), (java.util.List)((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment.observers().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateAssignment$5(liveBrokerAttributes, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava())))).map((Function1 & Serializable & scala.Serializable)message -> new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message))));
    }

    public Option<ApiError> validateAssignmentStructure(ReplicaAssignment.Assignment assignment) {
        Seq<Object> replicas = assignment.replicas();
        scala.collection.immutable.Set replicaSet = replicas.toSet();
        if (replicas.isEmpty() || replicas.size() != replicaSet.size()) {
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(57).append("Duplicate replicas not allowed in partition assignment: ").append(replicas.mkString(", ")).append(".").toString()));
        }
        if (replicas.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$12 -> x$12 < 0)) {
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(44).append("Invalid replica id in partition assignment: ").append(replicas.mkString(", ")).toString()));
        }
        if (!assignment.replicas().endsWith(assignment.observers())) {
            String observerMsg = assignment.observers().mkString(", ");
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(85).append("Assignment contains observers (").append(observerMsg).append(") and the replicas' (").append(replicas.mkString(", ")).append(") ").append("suffix doesn't match observers.").toString()));
        }
        return None$.MODULE$;
    }

    public Option<ApiError> validateReassignment(Optional<TopicPlacement> topicPlacement, ReplicaAssignment reassignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return reassignment.targetAssignment().flatMap((Function1 & Serializable & scala.Serializable)assignment -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(topicPlacement)).flatMap((Function1 & Serializable & scala.Serializable)placementConstraint -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment((TopicPlacement)placementConstraint, (java.util.List)((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment.syncReplicas().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateReassignment$3(liveBrokerAttributes, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava()), (java.util.List)((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment.observers().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateReassignment$5(liveBrokerAttributes, reassignment, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava())))).map((Function1 & Serializable & scala.Serializable)message -> new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message))));
    }

    public static final /* synthetic */ boolean $anonfun$buildRequiredReplicaCountsAndEligibleBrokers$5(RackAndRequiredReplicaCountsAndEligibleBrokers x) {
        return x.countsAndEligibleBrokers().eligibleBrokers().size() < x.countsAndEligibleBrokers().syncReplicas() + x.countsAndEligibleBrokers().observers();
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToPartitionsWithRackMixingSupport$6(Tuple2 x) {
        return ((RackIndexAndAssignment)x._2()).assignment().length() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToPartitionsWithRackMixingSupport$13(Tuple2 x) {
        return ((RackIndexAndAssignment)x._2()).assignment().length() > 0;
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$3(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of((int)id, Optional.of(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$5(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of((int)id, Optional.of(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$3(Map liveBrokerAttributes$2, int id) {
        return TopicPlacement.Replica.of((int)id, Optional.of(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)liveBrokerAttributes$2.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$5(Map liveBrokerAttributes$2, ReplicaAssignment reassignment$1, int id) {
        Option attributes = liveBrokerAttributes$2.get((Object)BoxesRunTime.boxToInteger((int)id));
        Option attributes2 = reassignment$1.originAssignment().replicas().contains((Object)BoxesRunTime.boxToInteger((int)id)) ? attributes : attributes.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)scala.collection.Map$.MODULE$.empty()));
        return TopicPlacement.Replica.of((int)id, (Optional)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(attributes2.map((Function1 & Serializable & scala.Serializable)x$13 -> (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(x$13).asJava()))));
    }

    private Observer$() {
        MODULE$ = this;
        this.RackConstraintKey = "rack";
    }
}

