/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchResult;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEvent;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.LeaderAndIsrResponseReceived;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaBatch;
import kafka.controller.TopicDeletionStopReplicaResponseReceived;
import kafka.controller.UpdateMetadataBatch;
import kafka.controller.UpdateMetadataResponseReceived;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlResponse;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-g!B\u0010!\u0003\u0003)\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011e\u0002!\u0011!Q\u0001\niB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001J\u0011\u0019i\u0005\u0001)A\u0005\u0015\"9a\n\u0001b\u0001\n\u0003y\u0005BB.\u0001A\u0003%\u0001\u000bC\u0004]\u0001\t\u0007I\u0011A/\t\r\t\u0004\u0001\u0015!\u0003_\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011Da!\u001b\u0001!\u0002\u0013)\u0007\"\u00026\u0001\r\u0003Y\u0007\"\u0002;\u0001\r\u0003)\b\"CA\u0006\u0001E\u0005I\u0011AA\u0007\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\n\u0001\t\u0003\tI\u0003C\u0004\u00022\u0001!\t!!\n\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA \u0001\u0011%\u0011\u0011\t\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!a%\u0001\t\u0003\t)\nC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0006bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\t)\r\u0001C\u0001\u0003\u000f\u0014A%\u00112tiJ\f7\r^\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0006\u0003C\t\n!bY8oiJ|G\u000e\\3s\u0015\u0005\u0019\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002.a5\taF\u0003\u00020E\u0005)Q\u000f^5mg&\u0011\u0011G\f\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011AgN\u0007\u0002k)\u0011aGI\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005a*$aC&bM.\f7i\u001c8gS\u001e\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\tYD(D\u0001!\u0013\ti\u0004EA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s!\tY\u0004)\u0003\u0002BA\t\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0002\rqJg.\u001b;?)\u0011!UIR$\u0011\u0005m\u0002\u0001\"\u0002\u001a\u0005\u0001\u0004\u0019\u0004\"B\u001d\u0005\u0001\u0004Q\u0004\"\u0002 \u0005\u0001\u0004y\u0014\u0001D2p]R\u0014x\u000e\u001c7fe&#W#\u0001&\u0011\u0005\u001dZ\u0015B\u0001')\u0005\rIe\u000e^\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002)1,\u0017\rZ3s\u0003:$\u0017j\u001d:CCR\u001c\u0007.T1q+\u0005\u0001\u0006\u0003B)W\u0015bk\u0011A\u0015\u0006\u0003'R\u000bq!\\;uC\ndWM\u0003\u0002VQ\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]\u0013&aA'baB\u00111(W\u0005\u00035\u0002\u0012\u0011\u0003T3bI\u0016\u0014\u0018I\u001c3JgJ\u0014\u0015\r^2i\u0003UaW-\u00193fe\u0006sG-S:s\u0005\u0006$8\r['ba\u0002\n1c\u001d;paJ+\u0007\u000f\\5dC\n\u000bGo\u00195NCB,\u0012A\u0018\t\u0005#ZSu\f\u0005\u0002<A&\u0011\u0011\r\t\u0002\u0011'R|\u0007OU3qY&\u001c\u0017MQ1uG\"\fAc\u001d;paJ+\u0007\u000f\\5dC\n\u000bGo\u00195NCB\u0004\u0013AF;qI\u0006$X-T3uC\u0012\fG/\u0019\"bi\u000eDW*\u00199\u0016\u0003\u0015\u0004B!\u0015,KMB\u00111hZ\u0005\u0003Q\u0002\u00121#\u00169eCR,W*\u001a;bI\u0006$\u0018MQ1uG\"\fq#\u001e9eCR,W*\u001a;bI\u0006$\u0018MQ1uG\"l\u0015\r\u001d\u0011\u0002\u0013M,g\u000eZ#wK:$HC\u00017p!\t9S.\u0003\u0002oQ\t!QK\\5u\u0011\u0015\u0001X\u00021\u0001r\u0003\u0015)g/\u001a8u!\tY$/\u0003\u0002tA\ty1i\u001c8ue>dG.\u001a:Fm\u0016tG/A\u0005tK:$')\u0019;dQR!AN\u001e=~\u0011\u00159h\u00021\u0001K\u0003!\u0011'o\\6fe&#\u0007\"B=\u000f\u0001\u0004Q\u0018!\u00022bi\u000eD\u0007CA\u001e|\u0013\ta\bE\u0001\u000bD_:$(o\u001c7NKR\fG-\u0019;b\u0005\u0006$8\r\u001b\u0005\b}:\u0001\n\u00111\u0001\u0000\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007cB\u0014\u0002\u0002i\f)\u0001\\\u0005\u0004\u0003\u0007A#!\u0003$v]\u000e$\u0018n\u001c83!\rY\u0014qA\u0005\u0004\u0003\u0013\u0001#AG\"p]R\u0014x\u000e\\'fi\u0006$\u0017\r^1CCR\u001c\u0007NU3tk2$\u0018aE:f]\u0012\u0014\u0015\r^2iI\u0011,g-Y;mi\u0012\u001aTCAA\bU\ry\u0018\u0011C\u0016\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0004\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\"\u0005]!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Aa.Z<CCR\u001c\u0007\u000eF\u0001m\u0003!qwN\\#naRLXCAA\u0016!\r9\u0013QF\u0005\u0004\u0003_A#a\u0002\"p_2,\u0017M\\\u0001\u0006G2,\u0017M]\u0001\u001dO\u0016$xJ]\"sK\u0006$X\rT3bI\u0016\u0014\u0018I\u001c3JgJ\u0014\u0015\r^2i)\rA\u0016q\u0007\u0005\u0006oN\u0001\rAS\u0001\u001cO\u0016$xJ]\"sK\u0006$Xm\u0015;paJ+\u0007\u000f\\5dC\n\u000bGo\u00195\u0015\u0007}\u000bi\u0004C\u0003x)\u0001\u0007!*\u0001\u0010hKR|%o\u0011:fCR,W\u000b\u001d3bi\u0016lU\r^1eCR\f')\u0019;dQR\u0019a-a\u0011\t\u000b],\u0002\u0019\u0001&\u0002-M,GoQ8oi\u0006Lgn]!mYJ+\u0007\u000f\\5dCN$2\u0001\\A%\u0011\u001d\tYE\u0006a\u0001\u0003\u001b\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\u000b\u0005=\u0013\u0011\u000b&\u000e\u0003QK1!a\u0015U\u0005\r\u0019V\r^\u0001!C\u0012$G*Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti\u001a{'O\u0011:pW\u0016\u00148\u000fF\u0006m\u00033\n\t'a\u001f\u0002\u0006\u0006=\u0005bBA&/\u0001\u0007\u00111\f\t\u0006\u0003\u001f\niFS\u0005\u0004\u0003?\"&aA*fc\"9\u00111M\fA\u0002\u0005\u0015\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003O\n9(\u0004\u0002\u0002j)!\u00111NA7\u0003\u0019\u0019w.\\7p]*\u00191%a\u001c\u000b\t\u0005E\u00141O\u0001\u0007CB\f7\r[3\u000b\u0005\u0005U\u0014aA8sO&!\u0011\u0011PA5\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!! \u0018\u0001\u0004\ty(A\u000emK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\t\u0004w\u0005\u0005\u0015bAABA\tYB*Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"Dq!a\"\u0018\u0001\u0004\tI)A\tsKBd\u0017nY1BgNLwM\\7f]R\u00042aOAF\u0013\r\ti\t\t\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bbBAI/\u0001\u0007\u00111F\u0001\u0006SNtUm^\u0001 C\u0012$7\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u\r>\u0014(I]8lKJ\u001cHc\u00027\u0002\u0018\u0006e\u00151\u0014\u0005\b\u0003\u0017B\u0002\u0019AA.\u0011\u001d\t\u0019\u0007\u0007a\u0001\u0003KBq!!(\u0019\u0001\u0004\tY#A\beK2,G/\u001a)beRLG/[8o\u0003A\u0019X\r\u001e%bg:+wO\u0011:pW\u0016\u00148\u000fF\u0002m\u0003GCq!a\u0013\u001a\u0001\u0004\tY&\u0001\u0012bI\u0012,\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR4uN\u001d\"s_.,'o\u001d\u000b\u0006Y\u0006%\u00161\u0016\u0005\b\u0003\u0017R\u0002\u0019AA.\u0011\u001d\tiK\u0007a\u0001\u0003_\u000b!\u0002]1si&$\u0018n\u001c8t!\u0019\ty%!\u0015\u0002f\u000592/\u001a8e\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e\u000b\u0004Y\u0006U\u0006BBA\\7\u0001\u0007!*A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0003i\u0019XM\u001c3Va\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;t)\ra\u0017Q\u0018\u0005\u0007\u0003oc\u0002\u0019\u0001&\u0002/M,g\u000eZ*u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgR\u001cHc\u00017\u0002D\"1\u0011qW\u000fA\u0002)\u000bQc]3oIJ+\u0017/^3tiN$vN\u0011:pW\u0016\u00148\u000fF\u0002m\u0003\u0013Da!a.\u001f\u0001\u0004Q\u0005")
public abstract class AbstractControllerBrokerRequestBatch
implements Logging {
    private final KafkaConfig config;
    private final ControllerContext controllerContext;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, LeaderAndIsrBatch> leaderAndIsrBatchMap;
    private final scala.collection.mutable.Map<Object, StopReplicaBatch> stopReplicaBatchMap;
    private final scala.collection.mutable.Map<Object, UpdateMetadataBatch> updateMetadataBatchMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, LeaderAndIsrBatch> leaderAndIsrBatchMap() {
        return this.leaderAndIsrBatchMap;
    }

    public scala.collection.mutable.Map<Object, StopReplicaBatch> stopReplicaBatchMap() {
        return this.stopReplicaBatchMap;
    }

    public scala.collection.mutable.Map<Object, UpdateMetadataBatch> updateMetadataBatchMap() {
        return this.updateMetadataBatchMap;
    }

    public abstract void sendEvent(ControllerEvent var1);

    public abstract void sendBatch(int var1, ControlMetadataBatch var2, Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit> var3);

    public Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit> sendBatch$default$3() {
        return null;
    }

    public void newBatch() {
        if (this.leaderAndIsrBatchMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(130).append("Controller to broker state change requests batch is not empty while creating ").append("a new one. LeaderAndIsr state changes ").append(this.leaderAndIsrBatchMap().mkString("[", ",", "]")).append(" might be lost.").toString());
        }
        if (this.stopReplicaBatchMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(129).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. StopReplica state changes ").append(this.stopReplicaBatchMap().mkString("[", ",", "]")).append(" might be lost.").toString());
        }
        if (this.updateMetadataBatchMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(132).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. UpdateMetadata state changes ").append(this.updateMetadataBatchMap().mkString("[", ",", "]")).append(" might be lost.").toString());
        }
    }

    public boolean nonEmpty() {
        return this.leaderAndIsrBatchMap().nonEmpty() || this.stopReplicaBatchMap().nonEmpty() || this.updateMetadataBatchMap().nonEmpty();
    }

    public void clear() {
        this.leaderAndIsrBatchMap().clear();
        this.stopReplicaBatchMap().clear();
        this.updateMetadataBatchMap().clear();
    }

    private LeaderAndIsrBatch getOrCreateLeaderAndIsrBatch(int brokerId) {
        return (LeaderAndIsrBatch)this.leaderAndIsrBatchMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> new LeaderAndIsrBatch(brokerId));
    }

    private StopReplicaBatch getOrCreateStopReplicaBatch(int brokerId) {
        return (StopReplicaBatch)this.stopReplicaBatchMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> new StopReplicaBatch(brokerId));
    }

    private UpdateMetadataBatch getOrCreateUpdateMetadataBatch(int brokerId) {
        return (UpdateMetadataBatch)this.updateMetadataBatchMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> new UpdateMetadataBatch(brokerId));
    }

    public void setContainsAllReplicas(Set<Object> brokerIds) {
        brokerIds.foreach((Function1 & Serializable & scala.Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$setContainsAllReplicas$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ReplicaAssignment replicaAssignment, boolean isNew) {
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, leaderIsrAndControllerEpoch, topicPartition, replicaAssignment, isNew, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition) {
        int leaderEpoch = this.controllerContext.isTopicQueuedUpForDeletion(topicPartition.topic()) ? LeaderAndIsr$.MODULE$.EpochDuringDelete() : BoxesRunTime.unboxToInt((Object)this.controllerContext.partitionLeadershipInfo(topicPartition).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)AbstractControllerBrokerRequestBatch.$anonfun$addStopReplicaRequestForBrokers$1(x$8))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> LeaderAndIsr$.MODULE$.NoEpoch()));
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addStopReplicaRequestForBrokers$4(this, topicPartition, leaderEpoch, deletePartition, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public void setHasNewBrokers(Seq<Object> brokerIds) {
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$setHasNewBrokers$2(this, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        scala.collection.mutable.Map partitionStates = Map$.MODULE$.empty();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            BoxedUnit boxedUnit;
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
            Option<LeaderIsrAndControllerEpoch> option = $this.controllerContext.partitionLeadershipInfo((TopicPartition)partition);
            if (option instanceof Some && (leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value()) != null) {
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
                int controllerEpoch = leaderIsrAndControllerEpoch.controllerEpoch();
                boolean beingDeleted = $this.controllerContext.topicsToBeDeleted().contains((Object)partition.topic());
                ReplicaAssignment replicaAssignment = $this.controllerContext.partitionFullReplicaAssignment((TopicPartition)partition);
                Seq<Object> replicas = replicaAssignment.replicas();
                Seq offlineReplicas = (Seq)replicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$11 -> $this.controllerContext.isReplicaOnline(x$11, (TopicPartition)partition));
                LeaderAndIsr updatedLeaderAndIsr = beingDeleted ? LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr()) : leaderAndIsr;
                boxedUnit = partitionStates.put(partition, (Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(partition.topic()).setPartitionIndex(partition.partition()).setControllerEpoch(controllerEpoch).setLeader(updatedLeaderAndIsr.leader()).setLeaderEpoch(updatedLeaderAndIsr.leaderEpoch()).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)updatedLeaderAndIsr.isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setZkVersion(updatedLeaderAndIsr.partitionEpoch()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setOfflineReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)offlineReplicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setObservers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment.effectiveObservers().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()));
            } else if (None$.MODULE$.equals(option)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            return boxedUnit;
        });
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$12 -> x$12 >= 0)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            UpdateMetadataBatch batch = this.getOrCreateUpdateMetadataBatch(brokerId);
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> batch.addPartitionState((TopicPartition)topicPartition, (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionState).addTopicId(topicPartition.topic(), $this.controllerContext.topicId(topicPartition.topic())).setMirrorTopicMetadata(topicPartition.topic(), (Option<ClusterLinkTopicState>)$this.controllerContext.linkedTopics().get((Object)topicPartition.topic()));
            Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        });
    }

    /*
     * WARNING - void declaration
     */
    private void sendLeaderAndIsrRequest(int controllerEpoch) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        int leaderAndIsrRequestVersion = this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_3_4_IV0) ? 7 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_3_2_IV0) ? 6 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_8_IV1) ? 5 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_4_IV1) ? 4 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_4_IV0) ? 3 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_2_IV0) ? 2 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_1_0_IV0) ? 1 : 0))))));
        Function2 & Serializable & scala.Serializable intersect = (arg_0, arg_1) -> AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1$adapted(this, (short)leaderAndIsrRequestVersion, controllerEpoch, arg_0, arg_1);
        Map<Object, LeaderAndIsrBatch> map = Implicits$.MODULE$.MapExtensionMethods(this.leaderAndIsrBatchMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.leaderAndIsrBatchMap().clear();
    }

    /*
     * WARNING - void declaration
     */
    private void sendUpdateMetadataRequests(int controllerEpoch) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        int updateMetadataRequestVersion = this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_3_4_IV0) ? 8 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_8_IV1) ? 7 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_4_IV1) ? 6 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_2_IV0) ? 5 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_1_0_IV0) ? 4 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_0_10_2_IV0) ? 3 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_0_10_0_IV1) ? 2 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_0_9_0) ? 1 : 0)))))));
        List updatedBrokerHealthStates = ((TraversableOnce)this.controllerContext.degradedBrokers().map((Function1 & Serializable & scala.Serializable)broker -> new UpdateMetadataRequestData.UpdateMetadataBrokerHealthState().setBrokerId(broker.brokerId()).setDegradedComponents((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(broker.degradedBrokerComponents()).asScala()).map((Function1 & Serializable & scala.Serializable)degradedBrokerComponent -> degradedBrokerComponent.brokerComponent().id(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toList()).asJava()), Set$.MODULE$.canBuildFrom())).toList();
        Function2 & Serializable & scala.Serializable intersect = (arg_0, arg_1) -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$3$adapted(this, (short)updateMetadataRequestVersion, controllerEpoch, updatedBrokerHealthStates, arg_0, arg_1);
        Map<Object, UpdateMetadataBatch> map = Implicits$.MODULE$.MapExtensionMethods(this.updateMetadataBatchMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.updateMetadataBatchMap().clear();
    }

    /*
     * WARNING - void declaration
     */
    private void sendStopReplicaRequests(int controllerEpoch) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        int stopReplicaRequestVersion = this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_3_4_IV0) ? 4 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_6_IV0) ? 3 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_4_IV1) ? 2 : (this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_2_IV0) ? 1 : 0)));
        Function2 & Serializable & scala.Serializable intersect = (arg_0, arg_1) -> AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$4$adapted(this, (short)stopReplicaRequestVersion, controllerEpoch, arg_0, arg_1);
        Map<Object, StopReplicaBatch> map = Implicits$.MODULE$.MapExtensionMethods(this.stopReplicaBatchMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.stopReplicaBatchMap().clear();
    }

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            this.sendLeaderAndIsrRequest(controllerEpoch);
            this.sendStopReplicaRequests(controllerEpoch);
            this.sendUpdateMetadataRequests(controllerEpoch);
            return;
        }
        catch (Throwable e) {
            if (this.leaderAndIsrBatchMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Haven't been able to send leader and isr requests, current state of ").append("the map is ").append(this.leaderAndIsrBatchMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.updateMetadataBatchMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Haven't been able to send metadata update requests, current state of ").append("the map is ").append(this.updateMetadataBatchMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.stopReplicaBatchMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Haven't been able to send stop replica requests, current state of ").append("the map is ").append(this.stopReplicaBatchMap()).append(". Exception message: ").append(e).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ LeaderAndIsrBatch $anonfun$setContainsAllReplicas$1(AbstractControllerBrokerRequestBatch $this, int brokerId) {
        return $this.getOrCreateLeaderAndIsrBatch(brokerId).setContainsAllReplicas();
    }

    public static final /* synthetic */ LeaderAndIsrBatch $anonfun$addLeaderAndIsrRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, TopicPartition topicPartition$1, ReplicaAssignment replicaAssignment$1, boolean isNew$1, int brokerId) {
        LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch$1.leaderAndIsr();
        Option clusterLink = $this.controllerContext.linkedTopics().get((Object)topicPartition$1.topic());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topicPartition$1.topic()).setPartitionIndex(topicPartition$1.partition()).setControllerEpoch(leaderIsrAndControllerEpoch$1.controllerEpoch()).setLeader(leaderAndIsr.leader()).setLeaderEpoch(leaderAndIsr.leaderEpoch()).setClusterLinkId((String)clusterLink.map((Function1 & Serializable & scala.Serializable)cl -> CoreUtils$.MODULE$.toJavaUUID(cl.linkId()).toString()).orNull(Predef$.MODULE$.$conforms())).setClusterLinkSourceTopicId((Uuid)clusterLink.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.sourceTopicId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setClusterLinkTopicState((String)clusterLink.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.state().name()).orNull(Predef$.MODULE$.$conforms())).setLinkedLeaderEpoch(BoxesRunTime.unboxToInt((Object)leaderAndIsr.clusterLinkState().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.linkedLeaderEpoch())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderAndIsr.isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setPartitionEpoch(leaderAndIsr.partitionEpoch()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.replicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setAddingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.addingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setRemovingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.removingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(isNew$1).setObservers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.effectiveObservers().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava());
        clusterLink.foreach((Function1 & Serializable & scala.Serializable)link -> {
            if (link.mirrorStartOffsets() != null && link.mirrorStartOffsets().size() > topicPartition$1.partition()) {
                return partitionState.setMirrorStartOffset(BoxesRunTime.unboxToLong((Object)link.mirrorStartOffsets().apply(topicPartition$1.partition())));
            }
            return BoxedUnit.UNIT;
        });
        if ($this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_4_IV1)) {
            LeaderRecoveryState leaderRecoveryState = leaderAndIsr.leaderRecoveryState();
            LeaderRecoveryState leaderRecoveryState2 = LeaderRecoveryState.RECOVERING;
            partitionState.setConfluentIsUncleanLeader(!(leaderRecoveryState != null ? !leaderRecoveryState.equals(leaderRecoveryState2) : leaderRecoveryState2 != null));
        }
        if ($this.config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_3_2_IV0)) {
            partitionState.setLeaderRecoveryState(leaderAndIsr.leaderRecoveryState().value());
        }
        return $this.getOrCreateLeaderAndIsrBatch(brokerId).addPartitionState(topicPartition$1, partitionState).addTopicId(topicPartition$1.topic(), $this.controllerContext.topicId(topicPartition$1.topic()));
    }

    public static final /* synthetic */ int $anonfun$addStopReplicaRequestForBrokers$1(LeaderIsrAndControllerEpoch x$8) {
        return x$8.leaderAndIsr().leaderEpoch();
    }

    public static final /* synthetic */ StopReplicaBatch $anonfun$addStopReplicaRequestForBrokers$4(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$2, int leaderEpoch$1, boolean deletePartition$1, int brokerId) {
        return $this.getOrCreateStopReplicaBatch(brokerId).addPartitionState(topicPartition$2, new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(topicPartition$2.partition()).setLeaderEpoch(leaderEpoch$1).setDeletePartition(deletePartition$1)).addTopicId(topicPartition$2.topic(), $this.controllerContext.topicId(topicPartition$2.topic()));
    }

    public static final /* synthetic */ UpdateMetadataBatch $anonfun$setHasNewBrokers$2(AbstractControllerBrokerRequestBatch $this, int brokerId) {
        return $this.getOrCreateUpdateMetadataBatch(brokerId).setHasNewBrokers();
    }

    public static final /* synthetic */ int $anonfun$sendLeaderAndIsrRequest$2(Tuple2 x$13) {
        return ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)x$13._2()).leader();
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$4(AbstractControllerBrokerRequestBatch $this, int brokerId$5, ControlMetadataBatch x$14, ControlMetadataBatchResult result) {
        result.responses().foreach((Function1 & Serializable & scala.Serializable)response -> {
            $this.sendEvent(new LeaderAndIsrResponseReceived((LeaderAndIsrResponse)response, brokerId$5));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$1(AbstractControllerBrokerRequestBatch $this, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, int brokerId, LeaderAndIsrBatch leaderAndIsrBatch) {
        if ($this.controllerContext.liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            leaderAndIsrBatch.setVersion(leaderAndIsrRequestVersion$1).setControllerId($this.controllerId()).setControllerEpoch(controllerEpoch$1).setBrokerEpoch(BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))));
            scala.collection.immutable.Set leaderIds = ((TraversableOnce)leaderAndIsrBatch.partitions().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$2(x$13)), Iterable$.MODULE$.canBuildFrom())).toSet();
            $this.controllerContext.liveOrShuttingDownBrokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                if (leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)broker.id()))) {
                    return leaderAndIsrBatch.addLiveLeader(broker.node($this.config.interBrokerListenerName()));
                }
                return BoxedUnit.UNIT;
            });
            $this.sendBatch(brokerId, leaderAndIsrBatch, (Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$14, result) -> {
                AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$4($this, brokerId, x$14, result);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$4(AbstractControllerBrokerRequestBatch $this, int brokerId$6, ControlMetadataBatch x$15, ControlMetadataBatchResult result) {
        result.responses().foreach((Function1 & Serializable & scala.Serializable)response -> {
            $this.sendEvent(new UpdateMetadataResponseReceived(response.error(), brokerId$6));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$3(AbstractControllerBrokerRequestBatch $this, short updateMetadataRequestVersion$1, int controllerEpoch$2, List updatedBrokerHealthStates$1, int brokerId, UpdateMetadataBatch updateMetadataBatch) {
        if ($this.controllerContext.liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            updateMetadataBatch.setVersion(updateMetadataRequestVersion$1).setControllerId($this.controllerId()).setControllerEpoch(controllerEpoch$2).setDegradedBrokerHealthStates((List<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState>)updatedBrokerHealthStates$1).setBrokerEpoch(BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)))).setLiveBrokers((scala.collection.immutable.Set<Broker>)$this.controllerContext.liveOrShuttingDownBrokers().toSet()).setCells((Seq<Cell>)$this.controllerContext.cellIdToCell().values().toSeq());
            boolean enableLinkCoordinator = $this.config.interBrokerProtocolVersion().isLinkCoordinatorSupported() && Predef$.MODULE$.Boolean2boolean($this.config.clusterLinkMetadataTopicEnable());
            updateMetadataBatch.setLinkCoordinatorEnabled(enableLinkCoordinator);
            if (!enableLinkCoordinator) {
                updateMetadataBatch.mirrorTopicsMetadata().clear();
            }
            $this.sendBatch(brokerId, updateMetadataBatch, (Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$15, result) -> {
                AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$4($this, brokerId, x$15, result);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$1(AbstractControllerBrokerRequestBatch $this, ObjectRef error$1, StopReplicaBatch stopReplicaBatch$1, scala.collection.mutable.Map partitionErrorsForDeletingTopics$1, AbstractControlResponse response) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        error$1.elem = response.error();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionError) -> {
            if ($this.controllerContext.isTopicDeletionInProgress(topicPartition.topic()) && stopReplicaBatch$1.partitions().get(topicPartition).exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.deletePartition()))) {
                return partitionErrorsForDeletingTopics$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), partitionError));
            }
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.partitionErrors(Collections.emptyMap())).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    private final void callback$1(int brokerId, ControlMetadataBatch batch, ControlMetadataBatchResult result) {
        StopReplicaBatch stopReplicaBatch = (StopReplicaBatch)batch;
        scala.collection.mutable.Map partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        ObjectRef error = ObjectRef.create((Object)Errors.NONE);
        result.responses().foreach((Function1 & Serializable & scala.Serializable)response -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$1(this, error, stopReplicaBatch, partitionErrorsForDeletingTopics, response);
            return BoxedUnit.UNIT;
        });
        if (partitionErrorsForDeletingTopics.nonEmpty()) {
            this.sendEvent(new TopicDeletionStopReplicaResponseReceived(brokerId, (Errors)error.elem, (Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics));
        }
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$4(AbstractControllerBrokerRequestBatch $this, short stopReplicaRequestVersion$1, int controllerEpoch$3, int brokerId, StopReplicaBatch stopReplicaBatch) {
        if ($this.controllerContext.liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            stopReplicaBatch.setVersion(stopReplicaRequestVersion$1).setControllerId($this.controllerId()).setControllerEpoch(controllerEpoch$3).setBrokerEpoch(BoxesRunTime.unboxToLong((Object)$this.controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))));
            $this.sendBatch(brokerId, stopReplicaBatch, (Function2<ControlMetadataBatch, ControlMetadataBatchResult, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(batch, result) -> {
                $this.callback$1(brokerId, batch, result);
                return BoxedUnit.UNIT;
            });
        }
    }

    public AbstractControllerBrokerRequestBatch(KafkaConfig config, ControllerContext controllerContext, StateChangeLogger stateChangeLogger) {
        this.config = config;
        this.controllerContext = controllerContext;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.leaderAndIsrBatchMap = Map$.MODULE$.empty();
        this.stopReplicaBatchMap = Map$.MODULE$.empty();
        this.updateMetadataBatchMap = Map$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$sendLeaderAndIsrRequest$1$adapted(AbstractControllerBrokerRequestBatch $this, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Object brokerId, LeaderAndIsrBatch leaderAndIsrBatch) {
        AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1($this, leaderAndIsrRequestVersion$1, controllerEpoch$1, BoxesRunTime.unboxToInt((Object)brokerId), leaderAndIsrBatch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$sendUpdateMetadataRequests$3$adapted(AbstractControllerBrokerRequestBatch $this, short updateMetadataRequestVersion$1, int controllerEpoch$2, List updatedBrokerHealthStates$1, Object brokerId, UpdateMetadataBatch updateMetadataBatch) {
        AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$3($this, updateMetadataRequestVersion$1, controllerEpoch$2, updatedBrokerHealthStates$1, BoxesRunTime.unboxToInt((Object)brokerId), updateMetadataBatch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$sendStopReplicaRequests$4$adapted(AbstractControllerBrokerRequestBatch $this, short stopReplicaRequestVersion$1, int controllerEpoch$3, Object brokerId, StopReplicaBatch stopReplicaBatch) {
        AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$4($this, stopReplicaRequestVersion$1, controllerEpoch$3, BoxesRunTime.unboxToInt((Object)brokerId), stopReplicaBatch);
        return BoxedUnit.UNIT;
    }
}

