/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.controller.CompleteTopicDeletion;
import kafka.controller.DeletionClient;
import kafka.controller.KafkaController;
import kafka.controller.TopicDeletion$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000114AAC\u0006\u0001!!AA\u0002\u0001B\u0001B\u0003%1\u0004\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0011\u0015)\u0003\u0001\"\u0001'\u0011\u0015Q\u0003\u0001\"\u0011,\u0011\u0015\t\u0005\u0001\"\u0011C\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015Q\u0007\u0001\"\u0011l\u0005a\u0019uN\u001c;s_2dWM\u001d#fY\u0016$\u0018n\u001c8DY&,g\u000e\u001e\u0006\u0003\u00195\t!bY8oiJ|G\u000e\\3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u001935\t1\"\u0003\u0002\u001b\u0017\tqA)\u001a7fi&|gn\u00117jK:$\bC\u0001\r\u001d\u0013\ti2BA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0003!Q8n\u00117jK:$\bC\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u000e\u0003\tQ8.\u0003\u0002%C\ti1*\u00194lCj[7\t\\5f]R\fa\u0001P5oSRtDcA\u0014)SA\u0011\u0001\u0004\u0001\u0005\u0006\u0019\r\u0001\ra\u0007\u0005\u0006=\r\u0001\raH\u0001\fI\u0016dW\r^3U_BL7\rF\u0002-_q\u0002\"AE\u0017\n\u00059\u001a\"\u0001B+oSRDQ\u0001\r\u0003A\u0002E\nQ\u0001^8qS\u000e\u0004\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b\u0014\u001b\u0005)$B\u0001\u001c\u0010\u0003\u0019a$o\\8u}%\u0011\u0001hE\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029'!)Q\b\u0002a\u0001}\u0005qQ\r]8dQj[g+\u001a:tS>t\u0007C\u0001\n@\u0013\t\u00015CA\u0002J]R\fA\u0003Z3mKR,Gk\u001c9jG\u0012+G.\u001a;j_:\u001cHc\u0001\u0017D\u001d\")A)\u0002a\u0001\u000b\u00061Ao\u001c9jGN\u00042AR&2\u001d\t9\u0015J\u0004\u00025\u0011&\tA#\u0003\u0002K'\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u0005\r\u0019V-\u001d\u0006\u0003\u0015NAQ!P\u0003A\u0002y\n!$\\;uKB\u000b'\u000f^5uS>tWj\u001c3jM&\u001c\u0017\r^5p]N$\"\u0001L)\t\u000bA2\u0001\u0019A\u0019\u0002%M,g\u000eZ'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a\u000b\u0003YQCQ!V\u0004A\u0002Y\u000b!\u0002]1si&$\u0018n\u001c8t!\r9&\fX\u0007\u00021*\u0011\u0011lE\u0001\u000bG>dG.Z2uS>t\u0017BA.Y\u0005\r\u0019V\r\u001e\t\u0003;\u0016l\u0011A\u0018\u0006\u0003?\u0002\faaY8n[>t'B\u0001\bb\u0015\t\u00117-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0006\u0019qN]4\n\u0005\u0019t&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0014G>l\u0007\u000f\\3uK\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u000b\u0003Y%DQ\u0001\r\u0005A\u0002E\nQB]3uef$U\r\\3uS>tG#\u0001\u0017")
public class ControllerDeletionClient
implements DeletionClient {
    private final KafkaController controller;
    private final KafkaZkClient zkClient;

    @Override
    public void deleteTopic(String topic, int epochZkVersion) {
        this.zkClient.deleteTopicZNode(topic, epochZkVersion);
        this.zkClient.deleteTopicConfigs((Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), epochZkVersion);
        this.zkClient.deleteTopicDeletions((Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), epochZkVersion);
    }

    @Override
    public void deleteTopicDeletions(Seq<String> topics, int epochZkVersion) {
        this.zkClient.deleteTopicDeletions(topics, epochZkVersion);
    }

    @Override
    public void mutePartitionModifications(String topic) {
        this.controller.unregisterPartitionModificationsHandlers((Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
    }

    @Override
    public void sendMetadataUpdate(Set<TopicPartition> partitions) {
        this.controller.sendUpdateMetadataRequest((Seq<Object>)this.controller.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), partitions, this.controller.sendUpdateMetadataRequest$default$3());
    }

    @Override
    public void completeDeleteTopic(String topic) {
        if (this.controller.isActive()) {
            this.controller.eventManager().put(new CompleteTopicDeletion(topic));
        }
    }

    @Override
    public void retryDeletion() {
        this.controller.kafkaScheduler().scheduleOnce("delete-topic-retry", () -> {
            if ($this.controller.isActive()) {
                $this.controller.eventManager().put(TopicDeletion$.MODULE$);
            }
        }, 1000L);
    }

    public ControllerDeletionClient(KafkaController controller, KafkaZkClient zkClient) {
        this.controller = controller;
        this.zkClient = zkClient;
    }
}

