/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControllerChannelContext;
import kafka.controller.KRaftAbstractControllerBrokerRequestBatch$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}g!\u0002\u0015*\u0003\u0003q\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t1\u0002\u0011\t\u0011)A\u00053\"AA\f\u0001B\u0001B\u0003%Q\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0004i\u0001\t\u0007I\u0011A5\t\r5\u0004\u0001\u0015!\u0003k\u0011\u001dq\u0007A1A\u0005\u0002=Dq!!\u000b\u0001A\u0003%\u0001\u000fC\u0005\u0002,\u0001\u0011\r\u0011\"\u0001\u0002.!A\u0011\u0011\t\u0001!\u0002\u0013\ty\u0003C\u0005\u0002D\u0001\u0011\r\u0011\"\u0001\u0002F!A\u0011Q\n\u0001!\u0002\u0013\t9\u0005C\u0005\u0002P\u0001\u0011\r\u0011\"\u0001\u0002R!A\u00111\r\u0001!\u0002\u0013\t\u0019\u0006C\u0006\u0002f\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0004bCA5\u0001\u0001\u0007\t\u0019!C\u0005\u0003WB!\"a\u001e\u0001\u0001\u0004\u0005\t\u0015)\u0003G\u0011\u001d\tI\b\u0001D\u0001\u0003wB\u0011\"!1\u0001#\u0003%\t!a1\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011Q\u001c\u0001\u0005\u0002\u0005m\u0007bBAp\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u00119\u0002\u0001C\u0001\u00053AqAa\u0006\u0001\t\u0003\u0011)\u0003C\u0004\u0003\u0018\u0001!\tA!\u000b\t\u000f\t\r\u0004\u0001\"\u0003\u0003f!9!Q\u000e\u0001\u0007\u0002\t=\u0004b\u0002B@\u0001\u0011%!\u0011\u0011\u0005\b\u0005\u000f\u0003a\u0011\u0001BE\u0011\u001d\u0011)\n\u0001C\u0005\u0005/CqA!(\u0001\r\u0003\u0011y\nC\u0004\u0003L\u0002!\tA!4\b\u0013\tE\u0017&!A\t\u0002\tMg\u0001\u0003\u0015*\u0003\u0003E\tA!6\t\r\u0001,C\u0011\u0001Bl\u0011%\u0011I.JI\u0001\n\u0003\u0011YNA\u0015L%\u00064G/\u00112tiJ\f7\r^\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0006\u0003U-\n!bY8oiJ|G\u000e\\3s\u0015\u0005a\u0013!B6bM.\f7\u0001A\n\u0004\u0001=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00027s5\tqG\u0003\u00029W\u0005)Q\u000f^5mg&\u0011!h\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011Q\bQ\u0007\u0002})\u0011qhK\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0005s$aC&bM.\f7i\u001c8gS\u001e\f\u0001#\\3uC\u0012\fG/\u0019)s_ZLG-\u001a:\u0011\u0007A\"e)\u0003\u0002Fc\tIa)\u001e8di&|g\u000e\r\t\u0003\u000f\"k\u0011!K\u0005\u0003\u0013&\u0012\u0001dQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u0007>tG/\u001a=u\u0003]iW\r^1eCR\fg+\u001a:tS>t\u0007K]8wS\u0012,'\u000fE\u00021\t2\u0003\"!\u0014,\u000e\u00039S!a\u0014)\u0002\r\r|W.\\8o\u0015\ty\u0014K\u0003\u0002-%*\u00111\u000bV\u0001\u0007CB\f7\r[3\u000b\u0003U\u000b1a\u001c:h\u0013\t9fJA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\t\u0003\u000fjK!aW\u0015\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/A\ble\u00064GoQ8oiJ|G\u000e\\3s!\t\u0001d,\u0003\u0002`c\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0004cG\u0012,gm\u001a\t\u0003\u000f\u0002AQa\u000f\u0004A\u0002qBQA\u0011\u0004A\u0002\rCQA\u0013\u0004A\u0002-CQ\u0001\u0017\u0004A\u0002eCq\u0001\u0018\u0004\u0011\u0002\u0003\u0007Q,\u0001\u0007d_:$(o\u001c7mKJLE-F\u0001k!\t\u00014.\u0003\u0002mc\t\u0019\u0011J\u001c;\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u0003YaW-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u\u001b\u0006\u0004X#\u00019\u0011\tE4(\u000e_\u0007\u0002e*\u00111\u000f^\u0001\b[V$\u0018M\u00197f\u0015\t)\u0018'\u0001\u0006d_2dWm\u0019;j_:L!a\u001e:\u0003\u00075\u000b\u0007\u000f\u0005\u0003rmft\bC\u0001>}\u001b\u0005Y(BA(R\u0013\ti8P\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0007}\f\u0019C\u0004\u0003\u0002\u0002\u0005ua\u0002BA\u0002\u00033qA!!\u0002\u0002\u00189!\u0011qAA\u000b\u001d\u0011\tI!a\u0005\u000f\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004.\u0003\u0019a$o\\8u}%\tQ+\u0003\u0002T)&\u0011AFU\u0005\u0003\u001fFK1!a\u0007|\u0003\u001diWm]:bO\u0016LA!a\b\u0002\"\u00059B*Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u00037Y\u0018\u0002BA\u0013\u0003O\u0011!\u0004T3bI\u0016\u0014\u0018I\u001c3JgJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016TA!a\b\u0002\"\u00059B.Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti6\u000b\u0007\u000fI\u0001\u0016gR|\u0007OU3qY&\u001c\u0017MU3rk\u0016\u001cH/T1q+\t\ty\u0003E\u0003rm*\f\t\u0004E\u0003rmf\f\u0019\u0004\u0005\u0003\u00026\u0005mb\u0002BA\u0001\u0003oIA!!\u000f\u0002\"\u000512\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002>\u0005}\"!G*u_B\u0014V\r\u001d7jG\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016TA!!\u000f\u0002\"\u000512\u000f^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u\u001b\u0006\u0004\b%\u0001\u0010va\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;Ce>\\WM]*fiV\u0011\u0011q\t\t\u0005c\u0006%#.C\u0002\u0002LI\u00141aU3u\u0003})\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0014%o\\6feN+G\u000fI\u0001&kB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u!\u0006\u0014H/\u001b;j_:LeNZ8NCB,\"!a\u0015\u0011\u000bE4\u00180!\u0016\u0011\t\u0005]\u0013Q\f\b\u0005\u0003\u0003\tI&\u0003\u0003\u0002\\\u0005\u0005\u0012!G+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e#bi\u0006LA!a\u0018\u0002b\taR\u000b\u001d3bi\u0016lU\r^1eCR\f\u0007+\u0019:uSRLwN\\*uCR,'\u0002BA.\u0003C\ta%\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fU1si&$\u0018n\u001c8J]\u001a|W*\u00199!\u0003AiW\r^1eCR\f\u0017J\\:uC:\u001cW-F\u0001G\u0003QiW\r^1eCR\f\u0017J\\:uC:\u001cWm\u0018\u0013fcR!\u0011QNA:!\r\u0001\u0014qN\u0005\u0004\u0003c\n$\u0001B+oSRD\u0001\"!\u001e\u0013\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\n\u0014!E7fi\u0006$\u0017\r^1J]N$\u0018M\\2fA\u0005Y1/\u001a8e%\u0016\fX/Z:u)!\ti'! \u0002\u0002\u0006E\u0006BBA@)\u0001\u0007!.\u0001\u0005ce>\\WM]%e\u0011\u001d\t\u0019\t\u0006a\u0001\u0003\u000b\u000bqA]3rk\u0016\u001cH\u000f\r\u0003\u0002\b\u0006}\u0005CBAE\u0003+\u000bYJ\u0004\u0003\u0002\f\u0006EUBAAG\u0015\r\tyi_\u0001\te\u0016\fX/Z:ug&!\u00111SAG\u0003Y\t%m\u001d;sC\u000e$8i\u001c8ue>d'+Z9vKN$\u0018\u0002BAL\u00033\u0013qAQ;jY\u0012,'O\u0003\u0003\u0002\u0014\u00065\u0005\u0003BAO\u0003?c\u0001\u0001\u0002\u0007\u0002\"\u0006\u0005\u0015\u0011!A\u0001\u0006\u0003\t\u0019KA\u0002`IQ\nB!!*\u0002,B\u0019\u0001'a*\n\u0007\u0005%\u0016GA\u0004O_RD\u0017N\\4\u0011\t\u0005-\u0015QV\u0005\u0005\u0003_\u000biI\u0001\fBEN$(/Y2u\u0007>tGO]8m%\u0016\fX/Z:u\u0011%\t\u0019\f\u0006I\u0001\u0002\u0004\t),\u0001\u0005dC2d'-Y2l!\u001d\u0001\u0014qWA^\u0003[J1!!/2\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\f\u0006u\u0016\u0002BA`\u0003\u001b\u0013\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u0002+M,g\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0019\u0016\u0005\u0003k\u000b9m\u000b\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!C;oG\",7m[3e\u0015\r\t\u0019.M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAl\u0003\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003!qWm\u001e\"bi\u000eDGCAA7\u0003\u0015\u0019G.Z1s\u0003\u0001\nG\r\u001a'fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$hi\u001c:Ce>\\WM]:\u0015\u0019\u00055\u00141]Ax\u0003g\fiPa\u0002\t\u000f\u0005\u0015\b\u00041\u0001\u0002h\u0006I!M]8lKJLEm\u001d\t\u0006\u0003S\fYO[\u0007\u0002i&\u0019\u0011Q\u001e;\u0003\u0007M+\u0017\u000f\u0003\u0004\u0002rb\u0001\r!_\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t)\u0010\u0007a\u0001\u0003o\f1\u0004\\3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007cA$\u0002z&\u0019\u00111`\u0015\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u001d\ty\u0010\u0007a\u0001\u0005\u0003\t\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\r9%1A\u0005\u0004\u0005\u000bI#!\u0005*fa2L7-Y!tg&<g.\\3oi\"1!\u0011\u0002\rA\u0002u\u000bQ![:OK^\fq$\u00193e'R|\u0007OU3qY&\u001c\u0017MU3rk\u0016\u001cHOR8s\u0005J|7.\u001a:t)!\tiGa\u0004\u0003\u0012\tM\u0001bBAs3\u0001\u0007\u0011q\u001d\u0005\u0007\u0003cL\u0002\u0019A=\t\r\tU\u0011\u00041\u0001^\u0003=!W\r\\3uKB\u000b'\u000f^5uS>t\u0017AI1eIV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u001a{'O\u0011:pW\u0016\u00148\u000f\u0006\u0004\u0002n\tm!Q\u0004\u0005\b\u0003KT\u0002\u0019AAt\u0011\u001d\u0011yB\u0007a\u0001\u0005C\t!\u0002]1si&$\u0018n\u001c8t!\u0015\tIOa\tz\u0013\r\tY\u0005\u001e\u000b\u0005\u0003[\u00129\u0003C\u0004\u0002fn\u0001\r!a:\u0015-\u00055$1\u0006B\u0017\u0005c\u0011)D!\u000f\u0003>\t\u0005#q\u000bB.\u0005?Bq!!:\u001d\u0001\u0004\t9\u000f\u0003\u0004\u00030q\u0001\rA[\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\"1!1\u0007\u000fA\u0002e\f\u0011\u0002]1si&$\u0018n\u001c8\t\r\t]B\u00041\u0001k\u0003\u0019aW-\u00193fe\"1!1\b\u000fA\u0002)\f1\u0002\\3bI\u0016\u0014X\t]8dQ\"1!q\b\u000fA\u0002)\fa\u0002]1si&$\u0018n\u001c8Fa>\u001c\u0007\u000eC\u0004\u0003Dq\u0001\rA!\u0012\u0002\t%\u001c(o\u001d\t\u0006\u0005\u000f\u0012\tF\u001b\b\u0005\u0005\u0013\u0012iE\u0004\u0003\u0002\f\t-\u0013\"\u0001\u001a\n\u0007\t=\u0013'A\u0004qC\u000e\\\u0017mZ3\n\t\tM#Q\u000b\u0002\u0005\u0019&\u001cHOC\u0002\u0003PEBqA!\u0017\u001d\u0001\u0004\t9/\u0001\u0005sKBd\u0017nY1t\u0011\u001d\u0011i\u0006\ba\u0001\u0003O\f!#\u001a4gK\u000e$\u0018N^3PEN,'O^3sg\"9!\u0011\r\u000fA\u0002\u0005\u001d\u0018aD8gM2Lg.\u001a*fa2L7-Y:\u0002/M,g\u000e\u001a'fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$HCBA7\u0005O\u0012I\u0007\u0003\u0004\u00030u\u0001\rA\u001b\u0005\u0007\u0005Wj\u0002\u0019A-\u0002\u001dM$\u0018\r^3DQ\u0006tw-\u001a'pO\u0006Q\u0002.\u00198eY\u0016dU-\u00193fe\u0006sG-S:s%\u0016\u001c\bo\u001c8tKR1\u0011Q\u000eB9\u0005wBqAa\u001d\u001f\u0001\u0004\u0011)(\u0001\u0005sKN\u0004xN\\:f!\u0011\tYIa\u001e\n\t\te\u0014Q\u0012\u0002\u0015\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fgB|gn]3\t\r\tud\u00041\u0001k\u0003\u0019\u0011'o\\6fe\u0006Q2/\u001a8e+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:ugR1\u0011Q\u000eBB\u0005\u000bCaAa\f \u0001\u0004Q\u0007B\u0002B6?\u0001\u0007\u0011,\u0001\u000fiC:$G.Z+qI\u0006$X-T3uC\u0012\fG/\u0019*fgB|gn]3\u0015\r\u00055$1\u0012BJ\u0011\u001d\u0011\u0019\b\ta\u0001\u0005\u001b\u0003B!a#\u0003\u0010&!!\u0011SAG\u0005Y)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007B\u0002B?A\u0001\u0007!.A\ftK:$7\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:ugR1\u0011Q\u000eBM\u00057CaAa\f\"\u0001\u0004Q\u0007B\u0002B6C\u0001\u0007\u0011,A\riC:$G.Z*u_B\u0014V\r\u001d7jG\u0006\u0014Vm\u001d9p]N,G\u0003CA7\u0005C\u0013YK!,\t\u000f\t\r&\u00051\u0001\u0003&\u0006\u00192\u000f^8q%\u0016\u0004H.[2b%\u0016\u001c\bo\u001c8tKB!\u00111\u0012BT\u0013\u0011\u0011I+!$\u0003'M#x\u000e\u001d*fa2L7-\u0019*fgB|gn]3\t\r\u0005}$\u00051\u0001k\u0011\u001d\u0011yK\ta\u0001\u0005c\u000b\u0001\u0005]1si&$\u0018n\u001c8FeJ|'o\u001d$pe\u0012+G.\u001a;j]\u001e$v\u000e]5dgB9!1\u0017B^s\n}f\u0002\u0002B[\u0005o\u00032!a\u00032\u0013\r\u0011I,M\u0001\u0007!J,G-\u001a4\n\u0007]\u0014iLC\u0002\u0003:F\u0002BA!1\u0003H6\u0011!1\u0019\u0006\u0004\u0005\u000b\\\u0018\u0001\u00039s_R|7m\u001c7\n\t\t%'1\u0019\u0002\u0007\u000bJ\u0014xN]:\u0002+M,g\u000e\u001a*fcV,7\u000f^:U_\n\u0013xn[3sgR!\u0011Q\u000eBh\u0011\u0019\u0011yc\ta\u0001U\u0006I3JU1gi\u0006\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\"aR\u0013\u0014\u0005\u0015zCC\u0001Bj\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u001c\u0016\u0004;\u0006\u001d\u0007")
public abstract class KRaftAbstractControllerBrokerRequestBatch
implements Logging {
    private final KafkaConfig config;
    private final Function0<ControllerChannelContext> metadataProvider;
    private final Function0<MetadataVersion> metadataVersionProvider;
    private final StateChangeLogger stateChangeLogger;
    private final boolean kraftController;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap;
    private ControllerChannelContext metadataInstance;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return KRaftAbstractControllerBrokerRequestBatch$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    private ControllerChannelContext metadataInstance() {
        return this.metadataInstance;
    }

    private void metadataInstance_$eq(ControllerChannelContext x$1) {
        this.metadataInstance = x$1;
    }

    public abstract void sendRequest(int var1, AbstractControlRequest.Builder<? extends AbstractControlRequest> var2, Function1<AbstractResponse, BoxedUnit> var3);

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(135).append("Controller to broker state change requests batch is not empty while creating ").append("a new one. Some LeaderAndIsr state changes ").append(this.leaderAndIsrRequestMap()).append(" might be lost ").toString());
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(134).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some StopReplica state changes ").append(this.stopReplicaRequestMap()).append(" might be lost ").toString());
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(169).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some UpdateMetadata state changes to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" with partition info ").append(this.updateMetadataRequestPartitionInfoMap()).append(" might be lost ").toString());
        }
        this.metadataInstance_$eq((ControllerChannelContext)this.metadataProvider.apply());
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
        this.metadataInstance_$eq(null);
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ReplicaAssignment replicaAssignment, boolean isNew) {
        Option<ClusterLinkTopicState> mirrorState = this.metadataInstance().mirrorTopicState(topicPartition.topic());
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> KRaftAbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, topicPartition, leaderIsrAndControllerEpoch, replicaAssignment, isNew, mirrorState, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.metadataInstance().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition) {
        int leaderEpoch = this.metadataInstance().leaderEpoch(topicPartition);
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> KRaftAbstractControllerBrokerRequestBatch.$anonfun$addStopReplicaRequestForBrokers$2(this, topicPartition, leaderEpoch, deletePartition, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$12 -> x$12 >= 0));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            KRaftAbstractControllerBrokerRequestBatch.$anonfun$addUpdateMetadataRequestForBrokers$2(this, brokerIds, partition);
            return BoxedUnit.UNIT;
        });
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$14 -> x$14 >= 0));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, int controllerEpoch, TopicPartition partition, int leader, int leaderEpoch, int partitionEpoch, List<Object> isrs, Seq<Object> replicas, Seq<Object> effectiveObservers, Seq<Object> offlineReplicas) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$15 -> x$15 >= 0));
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(partition.topic()).setPartitionIndex(partition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)isrs.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setZkVersion(partitionEpoch).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setObservers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)effectiveObservers.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setOfflineReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)offlineReplicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava());
        this.updateMetadataRequestPartitionInfoMap().put((Object)partition, (Object)partitionStateInfo);
    }

    /*
     * WARNING - void declaration
     */
    private void sendLeaderAndIsrRequest(int controllerEpoch, StateChangeLogger stateChangeLog) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        int leaderAndIsrRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? 7 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? 6 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV1) ? 5 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? 4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV0) ? 3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? 2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_1_0_IV0) ? 1 : 0))))));
        Function2 & Serializable & scala.Serializable intersect = (arg_0, arg_1) -> KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1$adapted(this, stateChangeLog, (short)leaderAndIsrRequestVersion, controllerEpoch, arg_0, arg_1);
        Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods(this.leaderAndIsrRequestMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.leaderAndIsrRequestMap().clear();
    }

    public abstract void handleLeaderAndIsrResponse(LeaderAndIsrResponse var1, int var2);

    private void sendUpdateMetadataRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        stateChangeLog.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Sending UpdateMetadata request to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" ").append("for ").append(this.updateMetadataRequestPartitionInfoMap().size()).append(" partitions").toString());
        Buffer partitionStates = this.updateMetadataRequestPartitionInfoMap().values().toBuffer();
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        short updateMetadataRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)8 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV1) ? (short)7 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? (short)6 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? (short)5 : (metadataVersion.isAtLeast(MetadataVersion.IBP_1_0_IV0) ? (short)4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_2_IV0) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_0_IV1) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_9_0) ? (short)1 : 0)))))));
        Buffer liveBrokers = this.metadataInstance().liveOrShuttingDownBrokers().iterator().map((Function1 & Serializable & scala.Serializable)broker -> {
            Seq seq;
            if (updateMetadataRequestVersion == 0) {
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                Node node = broker.node(listenerName);
                seq = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$);
            } else {
                seq = (Seq)broker.endPoints().map((Function1 & Serializable & scala.Serializable)endpoint -> new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id).setListener(endpoint.listenerName().value()), Seq$.MODULE$.canBuildFrom());
            }
            Seq endpoints = seq;
            return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(endpoints).asJava()).setRack((String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
        }).toBuffer();
        ObjectRef mirrorTopicMetadata = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        partitionStates.foreach((Function1 & Serializable & scala.Serializable)partitionState -> {
            KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$4(this, mirrorTopicMetadata, partitionState);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)this.updateMetadataRequestBrokerSet().intersect(this.metadataInstance().liveOrShuttingDownBrokerIds())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> {
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
            scala.collection.immutable.Map topicIds = ((TraversableOnce)((TraversableLike)((TraversableLike)((SeqLike)partitionStates.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.topicName(), Buffer$.MODULE$.canBuildFrom())).distinct()).filter(arg_0 -> KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$9$adapted(this.metadataInstance().topicIds(), arg_0))).map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, this.metadataInstance().topicIds().apply(topic)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List brokerHealthStates = ((TraversableOnce)liveBrokers.map((Function1 & Serializable & scala.Serializable)x0$1 -> new UpdateMetadataRequestData.UpdateMetadataBrokerHealthState().setBrokerId(x0$1.id()), Buffer$.MODULE$.canBuildFrom())).toList();
            Nil$ cells = Nil$.MODULE$;
            UpdateMetadataRequest.Builder updateMetadataRequestBuilder = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion, this.controllerId(), controllerEpoch, brokerEpoch, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokerHealthStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(liveBrokers).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicIds).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((scala.collection.immutable.Map)mirrorTopicMetadata$1.elem)).asJava(), metadataVersion.isLinkCoordinatorSupported(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)cells).asJava(), $this.kraftController);
            this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)updateMetadataRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
                KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$12(this, broker, r);
                return BoxedUnit.UNIT;
            });
        });
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public abstract void handleUpdateMetadataResponse(UpdateMetadataResponse var1, int var2);

    /*
     * WARNING - void declaration
     */
    private void sendStopReplicaRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        boolean traceEnabled = stateChangeLog.isTraceEnabled();
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        short stopReplicaRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_6_IV0) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? (short)1 : 0)));
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(brokerId, partitionStates) -> {
            KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$2(this, traceEnabled, stateChangeLog, stopReplicaRequestVersion, controllerEpoch, BoxesRunTime.unboxToInt((Object)brokerId), partitionStates);
            return BoxedUnit.UNIT;
        };
        Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods(this.stopReplicaRequestMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.stopReplicaRequestMap().clear();
    }

    public abstract void handleStopReplicaResponse(StopReplicaResponse var1, int var2, scala.collection.immutable.Map<TopicPartition, Errors> var3);

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            this.sendLeaderAndIsrRequest(controllerEpoch, stateChangeLog);
            this.sendUpdateMetadataRequests(controllerEpoch, stateChangeLog);
            this.sendStopReplicaRequests(controllerEpoch, stateChangeLog);
            return;
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Haven't been able to send leader and isr requests, current state of ").append("the map is ").append(this.leaderAndIsrRequestMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Haven't been able to send metadata update requests to brokers ").append(this.updateMetadataRequestBrokerSet()).append(", ").append("current state of the partition info is ").append(this.updateMetadataRequestPartitionInfoMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Haven't been able to send stop replica requests, current state of ").append("the map is ").append(this.stopReplicaRequestMap()).append(". Exception message: ").append(e).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$2(KRaftAbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, ReplicaAssignment replicaAssignment$1, boolean isNew$1, Option mirrorState$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.leaderAndIsrRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        boolean alreadyNew = result.get((Object)topicPartition$1).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isNew()));
        LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch$1.leaderAndIsr();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topicPartition$1.topic()).setPartitionIndex(topicPartition$1.partition()).setControllerEpoch(leaderIsrAndControllerEpoch$1.controllerEpoch()).setLeader(leaderAndIsr.leader()).setLeaderEpoch(leaderAndIsr.leaderEpoch()).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderAndIsr.isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setPartitionEpoch(leaderAndIsr.partitionEpoch()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.replicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setAddingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.addingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setRemovingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.removingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setObservers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.effectiveObservers().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(isNew$1 || alreadyNew).setClusterLinkId((String)mirrorState$1.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.linkId().toString()).orNull(Predef$.MODULE$.$conforms())).setClusterLinkSourceTopicId((Uuid)mirrorState$1.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.sourceTopicId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setClusterLinkTopicState((String)mirrorState$1.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.state().name()).orNull(Predef$.MODULE$.$conforms())).setLinkedLeaderEpoch(BoxesRunTime.unboxToInt((Object)leaderAndIsr.clusterLinkState().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.linkedLeaderEpoch())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)));
        if (((MetadataVersion)$this.metadataVersionProvider.apply()).isAtLeast(MetadataVersion.IBP_3_2_IV0)) {
            partitionState.setLeaderRecoveryState(leaderAndIsr.leaderRecoveryState().value());
        }
        return result.put((Object)topicPartition$1, (Object)partitionState);
    }

    public static final /* synthetic */ Option $anonfun$addStopReplicaRequestForBrokers$2(KRaftAbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$2, int leaderEpoch$1, boolean deletePartition$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.stopReplicaRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        boolean alreadyDelete = result.get((Object)topicPartition$2).exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.deletePartition()));
        return result.put((Object)topicPartition$2, (Object)new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(topicPartition$2.partition()).setLeaderEpoch(leaderEpoch$1).setDeletePartition(alreadyDelete || deletePartition$1));
    }

    public static final /* synthetic */ void $anonfun$addUpdateMetadataRequestForBrokers$2(KRaftAbstractControllerBrokerRequestBatch $this, Seq brokerIds$1, TopicPartition partition) {
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
        boolean beingDeleted = $this.metadataInstance().isTopicQueuedUpForDeletion(partition.topic());
        Option<LeaderIsrAndControllerEpoch> option = $this.metadataInstance().partitionLeadershipInfo(partition);
        if (option instanceof Some && (leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value()) != null) {
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            int controllerEpoch = leaderIsrAndControllerEpoch.controllerEpoch();
            Seq<Object> replicas = $this.metadataInstance().partitionReplicaAssignment(partition);
            Seq<Object> effectiveObservers = $this.metadataInstance().partitionEffectiveObservers(partition);
            Seq offlineReplicas = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$13 -> !$this.metadataInstance().isReplicaOnline(x$13, partition));
            LeaderAndIsr updatedLeaderAndIsr = beingDeleted ? LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr()) : leaderAndIsr;
            $this.addUpdateMetadataRequestForBrokers((Seq<Object>)brokerIds$1, controllerEpoch, partition, updatedLeaderAndIsr.leader(), updatedLeaderAndIsr.leaderEpoch(), updatedLeaderAndIsr.partitionEpoch(), updatedLeaderAndIsr.isr(), replicas, effectiveObservers, (Seq<Object>)offlineReplicas);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$2(scala.collection.mutable.Set leaderIds$1, int broker$2, IntRef numBecomeLeaders$1, StateChangeLogger stateChangeLog$1, TopicPartition topicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState state) {
        String typeOfRequest;
        String string;
        leaderIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)state.leader()));
        if (broker$2 == state.leader()) {
            ++numBecomeLeaders$1.elem;
            string = "become-leader";
        } else {
            string = typeOfRequest = "become-follower";
        }
        if (stateChangeLog$1.isTraceEnabled()) {
            stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Sending ").append(typeOfRequest).append(" LeaderAndIsr request ").append(state).append(" to broker ").append(broker$2).append(" for partition ").append(topicPartition).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$10(KRaftAbstractControllerBrokerRequestBatch $this, int broker$2, AbstractResponse r) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)r;
        $this.handleLeaderAndIsrResponse(leaderAndIsrResponse, broker$2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$1(KRaftAbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, int broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        if ($this.metadataInstance().liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)broker))) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            scala.collection.mutable.Set leaderIds = scala.collection.mutable.Set$.MODULE$.empty();
            IntRef numBecomeLeaders = IntRef.create((int)0);
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, state) -> {
                KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$2(leaderIds, broker, numBecomeLeaders, stateChangeLog$1, topicPartition, state);
                return BoxedUnit.UNIT;
            };
            Map map = Implicits$.MODULE$.MapExtensionMethods(leaderAndIsrPartitionStates);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            stateChangeLog$1.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Sending LeaderAndIsr request to broker ").append(broker).append(" with ").append(numBecomeLeaders$1.elem).append(" become-leader ").append("and ").append(leaderAndIsrPartitionStates.size() - numBecomeLeaders$1.elem).append(" become-follower partitions").toString());
            Set leaders = (Set)((SetLike)$this.metadataInstance().liveOrShuttingDownBrokers().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.node($this.config.interBrokerListenerName()), Set$.MODULE$.canBuildFrom());
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
            scala.collection.immutable.Map topicIds = ((TraversableOnce)((TraversableOnce)leaderAndIsrPartitionStates.keys().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.topic(), Iterable$.MODULE$.canBuildFrom())).toSet().map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, $this.metadataInstance().topicIds().getOrElse(topic, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = new LeaderAndIsrRequest.Builder(leaderAndIsrRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(leaderAndIsrPartitionStates.values().toBuffer()).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicIds).asJava(), false, (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(leaders).asJava(), $this.kraftController);
            $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
                KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$10($this, broker, r);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$4(KRaftAbstractControllerBrokerRequestBatch $this, ObjectRef mirrorTopicMetadata$1, UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState) {
        if (!((scala.collection.immutable.Map)mirrorTopicMetadata$1.elem).contains((Object)partitionState.topicName())) {
            $this.metadataInstance().mirrorTopicState(partitionState.topicName()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.toMirrorTopicState()).foreach((Function1 & Serializable & scala.Serializable)mirrorState -> {
                mirrorTopicMetadata$1.elem = ((scala.collection.immutable.Map)mirrorTopicMetadata$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionState.topicName()), (Object)mirrorState));
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$12(KRaftAbstractControllerBrokerRequestBatch $this, int broker$3, AbstractResponse r) {
        UpdateMetadataResponse updateMetadataResponse = (UpdateMetadataResponse)r;
        $this.handleUpdateMetadataResponse(updateMetadataResponse, broker$3);
    }

    private final void responseCallback$1(int brokerId, Function1 isPartitionDeleted, AbstractResponse response) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
            TopicPartition pe = (TopicPartition)e.getKey();
            TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
            }
        });
        if (partitionErrorsForDeletingTopics.nonEmpty()) {
            this.handleStopReplicaResponse(stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$5(scala.collection.mutable.Map stopReplicaTopicState$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        return ((StopReplicaRequestData.StopReplicaTopicState)stopReplicaTopicState$1.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$8(scala.collection.mutable.Map partitionStates$2, TopicPartition tp) {
        return partitionStates$2.get((Object)tp).exists((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.deletePartition()));
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$10(KRaftAbstractControllerBrokerRequestBatch $this, int brokerId$2, Function1 eta$0$1$2, AbstractResponse response) {
        StopReplicaResponse responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        responseCallback$1_stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
            TopicPartition pe = (TopicPartition)e.getKey();
            TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
            }
        });
        if (responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
            $this.handleStopReplicaResponse(responseCallback$1_stopReplicaResponse, brokerId$2, (scala.collection.immutable.Map<TopicPartition, Errors>)responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$11(IntRef numPartitionStateWithDelete$1, scala.collection.mutable.Map topicStatesWithDelete$1, IntRef numPartitionStateWithoutDelete$1, scala.collection.mutable.Map topicStatesWithoutDelete$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        scala.collection.mutable.Map map;
        if (partitionState.deletePartition()) {
            ++numPartitionStateWithDelete$1.elem;
            map = topicStatesWithDelete$1;
        } else {
            ++numPartitionStateWithoutDelete$1.elem;
            map = topicStatesWithoutDelete$1;
        }
        return ((StopReplicaRequestData.StopReplicaTopicState)map.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$14(TopicPartition x$21) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$15(KRaftAbstractControllerBrokerRequestBatch $this, int brokerId$2, Function1 eta$0$2$1, AbstractResponse response) {
        StopReplicaResponse responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        responseCallback$1_stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
            TopicPartition pe = (TopicPartition)e.getKey();
            TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
            }
        });
        if (responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
            $this.handleStopReplicaResponse(responseCallback$1_stopReplicaResponse, brokerId$2, (scala.collection.immutable.Map<TopicPartition, Errors>)responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$2(KRaftAbstractControllerBrokerRequestBatch $this, boolean traceEnabled$1, StateChangeLogger stateChangeLog$2, short stopReplicaRequestVersion$1, int controllerEpoch$3, int brokerId, scala.collection.mutable.Map partitionStates) {
        if ($this.metadataInstance().liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            if (traceEnabled$1) {
                void forKeyValue$extension_f2;
                void forKeyValue$extension_$this2;
                Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> {
                    stateChangeLog$2.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Sending StopReplica request ").append(partitionState).append(" to ").append("broker ").append(brokerId$2).append(" for partition ").append(topicPartition).toString());
                    return BoxedUnit.UNIT;
                };
                Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this2), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f2, arg_0, arg_1));
            }
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            if (stopReplicaRequestVersion$1 >= 3) {
                void forKeyValue$extension_f3;
                void forKeyValue$extension_$this3;
                scala.collection.mutable.Map stopReplicaTopicState = Map$.MODULE$.empty();
                Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$5(stopReplicaTopicState, topicPartition, partitionState));
                Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this3), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f3, arg_0, arg_1));
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Sending StopReplica request for ").append(partitionStates.size()).append(" ").append("replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(stopReplicaTopicState.values().toBuffer()).asJava(), $this.kraftController);
                Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$8(partitionStates, tp));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                    StopReplicaResponse $anonfun$sendStopReplicaRequests$10_responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
                    scala.collection.mutable.Map $anonfun$sendStopReplicaRequests$10_responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
                    $anonfun$sendStopReplicaRequests$10_responseCallback$1_stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
                        TopicPartition pe = (TopicPartition)e.getKey();
                        TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
                        if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                            responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
                        }
                    });
                    if ($anonfun$sendStopReplicaRequests$10_responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
                        $this.handleStopReplicaResponse($anonfun$sendStopReplicaRequests$10_responseCallback$1_stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)$anonfun$sendStopReplicaRequests$10_responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
            IntRef numPartitionStateWithDelete = IntRef.create((int)0);
            IntRef numPartitionStateWithoutDelete = IntRef.create((int)0);
            scala.collection.mutable.Map topicStatesWithDelete = Map$.MODULE$.empty();
            scala.collection.mutable.Map topicStatesWithoutDelete = Map$.MODULE$.empty();
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$11(numPartitionStateWithDelete, topicStatesWithDelete, numPartitionStateWithoutDelete, topicStatesWithoutDelete, topicPartition, partitionState));
            Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            if (topicStatesWithDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Sending StopReplica request (delete = true) for ").append(numPartitionStateWithDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, true, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(topicStatesWithDelete.values().toBuffer()).asJava(), $this.kraftController);
                Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$14(x$21));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                    StopReplicaResponse $anonfun$sendStopReplicaRequests$15_responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
                    scala.collection.mutable.Map $anonfun$sendStopReplicaRequests$15_responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
                    $anonfun$sendStopReplicaRequests$15_responseCallback$1_stopReplicaResponse.partitionErrors(null).entrySet().forEach(e -> {
                        TopicPartition pe = (TopicPartition)e.getKey();
                        TopicPartition tp = new TopicPartition(pe.topic(), pe.partition());
                        if (this.metadataInstance().isTopicDeletionInProgress(pe.topic()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                            responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), e.getValue()));
                        }
                    });
                    if ($anonfun$sendStopReplicaRequests$15_responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
                        $this.handleStopReplicaResponse($anonfun$sendStopReplicaRequests$15_responseCallback$1_stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)$anonfun$sendStopReplicaRequests$15_responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
                    }
                    return BoxedUnit.UNIT;
                });
            }
            if (topicStatesWithoutDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Sending StopReplica request (delete = false) for ").append(numPartitionStateWithoutDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(topicStatesWithoutDelete.values().toBuffer()).asJava(), $this.kraftController);
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, $this.sendRequest$default$3());
                return;
            }
        }
    }

    public KRaftAbstractControllerBrokerRequestBatch(KafkaConfig config, Function0<ControllerChannelContext> metadataProvider, Function0<MetadataVersion> metadataVersionProvider, StateChangeLogger stateChangeLogger, boolean kraftController) {
        this.config = config;
        this.metadataProvider = metadataProvider;
        this.metadataVersionProvider = metadataVersionProvider;
        this.stateChangeLogger = stateChangeLogger;
        this.kraftController = kraftController;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.leaderAndIsrRequestMap = Map$.MODULE$.empty();
        this.stopReplicaRequestMap = Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = scala.collection.mutable.Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = Map$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$sendLeaderAndIsrRequest$1$adapted(KRaftAbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Object broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        KRaftAbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1($this, stateChangeLog$1, leaderAndIsrRequestVersion$1, controllerEpoch$1, BoxesRunTime.unboxToInt((Object)broker), leaderAndIsrPartitionStates);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$sendUpdateMetadataRequests$9$adapted(Map eta$0$1$1, String key) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains((Object)key));
    }
}

