/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.KRaftControllerBrokerStateInfo;
import kafka.controller.KRaftControllerChannelManager$;
import kafka.controller.KRaftQueueItem;
import kafka.controller.KRaftRequestSendThread;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ux!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007y\u0005\u0001\u000b\u0011\u0002\u001b\t\u000fu\n!\u0019!C\u0001g!1a(\u0001Q\u0001\nQBqaP\u0001\u0012\u0002\u0013\u0005\u0001I\u0002\u0003)C\u0001A\u0006\u0002C0\t\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\u0019D!\u0011!Q\u0001\n\u001dD\u0001\"\u001c\u0005\u0003\u0002\u0003\u0006IA\u001c\u0005\tu\"\u0011\t\u0011)A\u0005w\"Q\u0011\u0011\u0001\u0005\u0003\u0002\u0003\u0006I!a\u0001\t\u0013\u0005%\u0001B!A!\u0002\u0013\u0011\u0005B\u0002\u0019\t\t\u0003\tY\u0001C\u0005\u0002\u001c!\u0011\r\u0011\"\u0003\u0002\u001e!A\u00111\u0006\u0005!\u0002\u0013\ty\u0002C\u0005\u0002.!\u0011\r\u0011\"\u0005\u00020!A\u0011q\t\u0005!\u0002\u0013\t\t\u0004C\u0005\u0002J!\u0011\r\u0011\"\u0003\u0002L!A\u00111\u000b\u0005!\u0002\u0013\ti\u0005C\u0004\u0002V!!\t!a\u0016\t\u000f\u0005]\u0004\u0002\"\u0001\u0002z!9\u00111\u0010\u0005\u0005\u0002\u0005u\u0004\"CAb\u0011E\u0005I\u0011AAc\u0011\u001d\tI\r\u0003C\u0001\u0003\u0017Dq!!5\t\t\u0003\t\u0019\u000eC\u0004\u0002X\"!I!!7\t\u000f\u0005u\u0007\u0002\"\u0003\u0002`\"9\u0011q\u001e\u0005\u0005\n\u0005E\bbBA|\u0011\u0011E\u0011\u0011`\u0001\u001e\u0017J\u000bg\r^\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe*\u0011!eI\u0001\u000bG>tGO]8mY\u0016\u0014(\"\u0001\u0013\u0002\u000b-\fgm[1\u0004\u0001A\u0011q%A\u0007\u0002C\ti2JU1gi\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'o\u0005\u0002\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0014\u0002'E+X-^3TSj,W*\u001a;sS\u000et\u0015-\\3\u0016\u0003Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\t1\fgn\u001a\u0006\u0002s\u0005!!.\u0019<b\u0013\tYdG\u0001\u0004TiJLgnZ\u0001\u0015#V,W/Z*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002CI+\u0017/^3tiJ\u000bG/Z!oIF+X-^3US6,W*\u001a;sS\u000et\u0015-\\3\u0002EI+\u0017/^3tiJ\u000bG/Z!oIF+X-^3US6,W*\u001a;sS\u000et\u0015-\\3!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\t\u0011I\u000b\u0002C\u001fB\u00191fQ#\n\u0005\u0011c#AB(qi&|g\u000e\u0005\u0002G\u001b:\u0011qi\u0013\t\u0003\u00112j\u0011!\u0013\u0006\u0003\u0015\u0016\na\u0001\u0010:p_Rt\u0014B\u0001'-\u0003\u0019\u0001&/\u001a3fM&\u00111H\u0014\u0006\u0003\u00192Z\u0013\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Uc\u0013AC1o]>$\u0018\r^5p]&\u0011qK\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,7c\u0001\u0005+3B\u0011!,X\u0007\u00027*\u0011AlI\u0001\u0006kRLGn]\u0005\u0003=n\u0013q\u0001T8hO&tw-A\bd_:$(o\u001c7mKJ,\u0005o\\2i!\rY\u0013mY\u0005\u0003E2\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005-\"\u0017BA3-\u0005\rIe\u000e^\u0001\u0007G>tg-[4\u0011\u0005!\\W\"A5\u000b\u0005)\u001c\u0013AB:feZ,'/\u0003\u0002mS\nY1*\u00194lC\u000e{gNZ5h\u0003\u0011!\u0018.\\3\u0011\u0005=DX\"\u00019\u000b\u0005q\u000b(B\u0001:t\u0003\u0019\u0019w.\\7p]*\u0011A\u0005\u001e\u0006\u0003kZ\fa!\u00199bG\",'\"A<\u0002\u0007=\u0014x-\u0003\u0002za\n!A+[7f\u0003\u001diW\r\u001e:jGN\u0004\"\u0001 @\u000e\u0003uT!A_9\n\u0005}l(aB'fiJL7m]\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bcA\u0014\u0002\u0006%\u0019\u0011qA\u0011\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqRq\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001CA\u0014\t\u0011\u0015yv\u00021\u0001a\u0011\u00151w\u00021\u0001h\u0011\u0015iw\u00021\u0001o\u0011\u0015Qx\u00021\u0001|\u0011\u001d\t\ta\u0004a\u0001\u0003\u0007A\u0001\"!\u0003\u0010!\u0003\u0005\rAQ\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003?\u0001B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004u\u0006\u0015\"B\u00016t\u0013\u0011\tI#a\t\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0010EJ|7.\u001a:Ti\u0006$X-\u00138g_V\u0011\u0011\u0011\u0007\t\b\u0003g\tidYA!\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003wa\u0013AC2pY2,7\r^5p]&!\u0011qHA\u001b\u0005\u001dA\u0015m\u001d5NCB\u00042aJA\"\u0013\r\t)%\t\u0002\u001f\u0017J\u000bg\r^\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s'R\fG/Z%oM>\f\u0001C\u0019:pW\u0016\u00148\u000b^1uK&sgm\u001c\u0011\u0002\u0015\t\u0014xn[3s\u0019>\u001c7.\u0006\u0002\u0002NA\u0019Q'a\u0014\n\u0007\u0005EcG\u0001\u0004PE*,7\r^\u0001\fEJ|7.\u001a:M_\u000e\\\u0007%A\u0004ti\u0006\u0014H/\u001e9\u0015\t\u0005e\u0013q\f\t\u0004W\u0005m\u0013bAA/Y\t!QK\\5u\u0011\u001d\t\tG\u0006a\u0001\u0003G\na\"\u001b8ji&\fGN\u0011:pW\u0016\u00148\u000f\u0005\u0004\u0002f\u0005\u001d\u00141N\u0007\u0003\u0003sIA!!\u001b\u0002:\t\u00191+\u001a;\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d$\u0003\u001d\u0019G.^:uKJLA!!\u001e\u0002p\t1!I]8lKJ\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u00033\n1b]3oIJ+\u0017/^3tiRA\u0011\u0011LA@\u0003\u0007\u000b\u0019\f\u0003\u0004\u0002\u0002b\u0001\raY\u0001\tEJ|7.\u001a:JI\"9\u0011Q\u0011\rA\u0002\u0005\u001d\u0015a\u0002:fcV,7\u000f\u001e\u0019\u0005\u0003\u0013\u000b\t\u000b\u0005\u0004\u0002\f\u0006]\u0015Q\u0014\b\u0005\u0003\u001b\u000b\u0019*\u0004\u0002\u0002\u0010*\u0019\u0011\u0011S9\u0002\u0011I,\u0017/^3tiNLA!!&\u0002\u0010\u00061\u0012IY:ue\u0006\u001cGoQ8oiJ|GNU3rk\u0016\u001cH/\u0003\u0003\u0002\u001a\u0006m%a\u0002\"vS2$WM\u001d\u0006\u0005\u0003+\u000by\t\u0005\u0003\u0002 \u0006\u0005F\u0002\u0001\u0003\r\u0003G\u000b\u0019)!A\u0001\u0002\u000b\u0005\u0011Q\u0015\u0002\u0004?\u0012\n\u0014\u0003BAT\u0003[\u00032aKAU\u0013\r\tY\u000b\f\u0002\b\u001d>$\b.\u001b8h!\u0011\ti)a,\n\t\u0005E\u0016q\u0012\u0002\u0017\u0003\n\u001cHO]1di\u000e{g\u000e\u001e:pYJ+\u0017/^3ti\"I\u0011Q\u0017\r\u0011\u0002\u0003\u0007\u0011qW\u0001\tG\u0006dGNY1dWB91&!/\u0002>\u0006e\u0013bAA^Y\tIa)\u001e8di&|g.\r\t\u0005\u0003\u001b\u000by,\u0003\u0003\u0002B\u0006=%\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0003U\u0019XM\u001c3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM*\"!a2+\u0007\u0005]v*A\u0005bI\u0012\u0014%o\\6feR!\u0011\u0011LAg\u0011\u001d\tyM\u0007a\u0001\u0003W\naA\u0019:pW\u0016\u0014\u0018\u0001\u0004:f[>4XM\u0011:pW\u0016\u0014H\u0003BA-\u0003+Da!!!\u001c\u0001\u0004\u0019\u0017\u0001D1eI:+wO\u0011:pW\u0016\u0014H\u0003BA-\u00037Dq!a4\u001d\u0001\u0004\tY'\u0001\tce>\\WM]'fiJL7\rV1hgR!\u0011\u0011]Aw!\u0019\t\u0019/!;5i5\u0011\u0011Q\u001d\u0006\u0005\u0003O\fI$A\u0005j[6,H/\u00192mK&!\u00111^As\u0005\ri\u0015\r\u001d\u0005\u0007\u0003\u0003k\u0002\u0019A2\u0002)I,Wn\u001c<f\u000bbL7\u000f^5oO\n\u0013xn[3s)\u0011\tI&a=\t\u000f\u0005Uh\u00041\u0001\u0002B\u0005Y!M]8lKJ\u001cF/\u0019;f\u0003Y\u0019H/\u0019:u%\u0016\fX/Z:u'\u0016tG\r\u00165sK\u0006$G\u0003BA-\u0003wDa!!! \u0001\u0004\u0019\u0007")
public class KRaftControllerChannelManager
implements Logging {
    private final Function0<Object> controllerEpoch;
    private final KafkaConfig config;
    private final Time time;
    private final Metrics metrics;
    private final StateChangeLogger stateChangeLogger;
    private final Option<String> threadNamePrefix;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<Object, KRaftControllerBrokerStateInfo> brokerStateInfo;
    private final Object brokerLock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$6() {
        return KRaftControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static String RequestRateAndQueueTimeMetricName() {
        return KRaftControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName();
    }

    public static String QueueSizeMetricName() {
        return KRaftControllerChannelManager$.MODULE$.QueueSizeMetricName();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<Object, KRaftControllerBrokerStateInfo> brokerStateInfo() {
        return this.brokerStateInfo;
    }

    private Object brokerLock() {
        return this.brokerLock;
    }

    public void startup(Set<Broker> initialBrokers) {
        initialBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            this.addNewBroker(broker);
            return BoxedUnit.UNIT;
        });
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.startRequestSendThread(brokerState._1$mcI$sp());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void shutdown() {
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().values().toList().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.removeExistingBroker(brokerState);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void sendRequest(int brokerId, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
        Object object = this.brokerLock();
        synchronized (object) {
            Option stateInfoOpt = this.brokerStateInfo().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (stateInfoOpt instanceof Some) {
                ((KRaftControllerBrokerStateInfo)((Some)stateInfoOpt).value()).messageQueue().put(new KRaftQueueItem(request.apiKey(), request, callback, this.time.milliseconds()));
            } else if (None$.MODULE$.equals(stateInfoOpt)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("Not sending request ").append(request$1.apiKey().name).append(" with controllerId=").append(request.controllerId()).append(", ").append("controllerEpoch=").append(request.controllerEpoch()).append(", brokerEpoch=").append(request.brokerEpoch()).append(" ").append("to broker ").append(brokerId).append(", since it is offline.").toString());
            } else {
                throw new MatchError((Object)stateInfoOpt);
            }
            return;
        }
    }

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void addBroker(Broker broker) {
        Object object = this.brokerLock();
        synchronized (object) {
            if (!this.brokerStateInfo().contains((Object)BoxesRunTime.boxToInteger((int)broker.id()))) {
                this.addNewBroker(broker);
                this.startRequestSendThread(broker.id());
            }
            return;
        }
    }

    public void removeBroker(int brokerId) {
        Object object = this.brokerLock();
        synchronized (object) {
            this.removeExistingBroker((KRaftControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addNewBroker(Broker broker) {
        String string;
        void var12_11;
        void var11_10;
        None$ none$;
        LinkedBlockingQueue<KRaftQueueItem> messageQueue = new LinkedBlockingQueue<KRaftQueueItem>();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Controller ").append($this.config.brokerId()).append(" trying to connect to broker ").append(broker.id()).toString());
        ListenerName controllerToBrokerListenerName = (ListenerName)this.config.controlPlaneListenerName().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.config.interBrokerListenerName());
        SecurityProtocol controllerToBrokerSecurityProtocol = (SecurityProtocol)this.config.controlPlaneSecurityProtocol().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.config.interBrokerSecurityProtocol());
        Node brokerNode = broker.node(controllerToBrokerListenerName);
        LogContext logContext = new LogContext(new StringBuilder(34).append("[Controller id=").append(this.config.brokerId()).append(", targetBrokerId=").append(brokerNode.idString()).append("] ").toString());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerToBrokerSecurityProtocol, (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerToBrokerListenerName, (String)this.config.saslMechanismInterBrokerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)logContext);
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
            none$ = new Some((Object)channelBuilder);
        } else {
            none$ = None$.MODULE$;
        }
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, "controller-channel", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)brokerNode.idString())}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)brokerNode, (List)Nil$.MODULE$)).asJava()), Integer.toString(this.config.brokerId()), 1, 0L, 0L, -1, -1, Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, false, new ApiVersions(), logContext);
        Option reconfigurableChannelBuilder = (Option)none$;
        void networkClient2 = var11_10;
        void reconfigurableChannelBuilder2 = var12_11;
        Option<String> option = this.threadNamePrefix;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(34).append("Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else if (option instanceof Some) {
            String name = (String)((Some)option).value();
            string = new StringBuilder(35).append(name).append(":Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else {
            throw new MatchError(option);
        }
        Timer requestRateAndQueueTimeMetrics = this.metricsGroup().newTimer(KRaftControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), TimeUnit.MILLISECONDS, TimeUnit.SECONDS, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.brokerMetricTags(broker.id())).asJava());
        KRaftRequestSendThread requestThread = new KRaftRequestSendThread(this.config.brokerId(), this.controllerEpoch, messageQueue, (NetworkClient)networkClient2, brokerNode, this.config, this.time, requestRateAndQueueTimeMetrics, this.stateChangeLogger, string);
        requestThread.setDaemon(false);
        Gauge queueSizeGauge = this.metricsGroup().newGauge(KRaftControllerChannelManager$.MODULE$.QueueSizeMetricName(), (Gauge)new Gauge<Object>(this, messageQueue){
            private final /* synthetic */ KRaftControllerChannelManager $outer;
            private final LinkedBlockingQueue messageQueue$1;

            public final int value() {
                return KRaftControllerChannelManager.kafka$controller$KRaftControllerChannelManager$$$anonfun$addNewBroker$4(this.messageQueue$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messageQueue$1 = messageQueue$1;
            }
        }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.brokerMetricTags(broker.id())).asJava());
        this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new KRaftControllerBrokerStateInfo((NetworkClient)networkClient2, brokerNode, messageQueue, requestThread, (Gauge<Object>)queueSizeGauge, requestRateAndQueueTimeMetrics, (Option<Reconfigurable>)reconfigurableChannelBuilder2));
    }

    private scala.collection.immutable.Map<String, String> brokerMetricTags(int brokerId) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(brokerId))}));
    }

    private void removeExistingBroker(KRaftControllerBrokerStateInfo brokerState) {
        try {
            brokerState.reconfigurableChannelBuilder().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                this.config.removeReconfigurable(reconfigurable);
                return BoxedUnit.UNIT;
            });
            brokerState.requestSendThread().shutdown();
            brokerState.networkClient().close();
            brokerState.messageQueue().clear();
            this.metricsGroup().removeMetric(KRaftControllerChannelManager$.MODULE$.QueueSizeMetricName(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.brokerMetricTags(brokerState.brokerNode().id())).asJava());
            this.metricsGroup().removeMetric(KRaftControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.brokerMetricTags(brokerState.brokerNode().id())).asJava());
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerState.brokerNode().id()));
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while removing broker by the controller", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void startRequestSendThread(int brokerId) {
        block7: {
            KRaftRequestSendThread requestThread;
            block6: {
                Thread.State state;
                Thread.State state2;
                block5: {
                    requestThread = ((KRaftControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).requestSendThread();
                    state2 = requestThread.getState();
                    state = Thread.State.NEW;
                    if (state2 != null) break block5;
                    if (state != null) {
                        return;
                    }
                    break block6;
                }
                if (!((Object)((Object)state2)).equals((Object)state)) break block7;
            }
            requestThread.start();
        }
    }

    public static final /* synthetic */ int $anonfun$new$2(KRaftControllerBrokerStateInfo x$1) {
        return x$1.messageQueue().size();
    }

    public final /* synthetic */ int kafka$controller$KRaftControllerChannelManager$$$anonfun$new$1() {
        Object object = this.brokerLock();
        synchronized (object) {
            int n = BoxesRunTime.unboxToInt((Object)this.brokerStateInfo().values().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)KRaftControllerChannelManager.$anonfun$new$2(x$1))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            return n;
        }
    }

    public static final /* synthetic */ int kafka$controller$KRaftControllerChannelManager$$$anonfun$addNewBroker$4(LinkedBlockingQueue messageQueue$1) {
        return messageQueue$1.size();
    }

    public KRaftControllerChannelManager(Function0<Object> controllerEpoch, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
        this.controllerEpoch = controllerEpoch;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.stateChangeLogger = stateChangeLogger;
        this.threadNamePrefix = threadNamePrefix;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.brokerStateInfo = new HashMap();
        this.brokerLock = new Object();
        this.logIdent_$eq(new StringBuilder(34).append("[Channel manager on controller ").append(config.brokerId()).append("]: ").toString());
        this.metricsGroup().newGauge("TotalQueueSize", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ KRaftControllerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$controller$KRaftControllerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

