/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.BrokerReconfigurable;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMt!B\u0014)\u0011\u0003yc!B\u0019)\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%\t\u0001\u0010\u0005\u0007\u001d\u0006\u0001\u000b\u0011B\u001f\t\u000b=\u000bA\u0011\u0001)\t\u000f\t5\u0014\u0001\"\u0003\u0003p\u0019!\u0011\u0007\u000b\u0001S\u0011!yvA!b\u0001\n\u0003\u0001\u0007\u0002\u00033\b\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0015<!Q1A\u0005\u0002\u0019D\u0001B[\u0004\u0003\u0002\u0003\u0006Ia\u001a\u0005\tW\u001e\u0011)\u0019!C\u0001Y\"A\u0001o\u0002B\u0001B\u0003%Q\u000e\u0003\u0005r\u000f\t\u0015\r\u0011\"\u0001s\u0011!yxA!A!\u0002\u0013\u0019\bBCA\u0001\u000f\t\u0015\r\u0011\"\u0001\u0002\u0004!Q\u0011QD\u0004\u0003\u0002\u0003\u0006I!!\u0002\t\u0015\u0005}qA!b\u0001\n\u0003\t\t\u0003\u0003\u0006\u0002.\u001d\u0011\t\u0011)A\u0005\u0003GA!\"a\f\b\u0005\u000b\u0007I\u0011AA\u0019\u0011)\t\te\u0002B\u0001B\u0003%\u00111\u0007\u0005\u0007s\u001d!\t!a\u0011\t\u0013\u0005MsA1A\u0005\u0002\u0005U\u0003\u0002CA4\u000f\u0001\u0006I!a\u0016\t\u000f\u0005%t\u0001\"\u0001\u0002l!9\u0011QP\u0004\u0005\u0002\u0005}\u0004bBAI\u000f\u0011\u0005\u00111\u0013\u0005\b\u0003\u0007<A\u0011AAc\u0011\u001d\tIo\u0002C\u0001\u0003WDq!!>\b\t\u0003\t9\u0010C\u0004\u0002|\u001e!\t!!@\t\u000f\t\u001dq\u0001\"\u0001\u0003\n!9!1C\u0004\u0005\u0002\tU\u0001b\u0002B\u000f\u000f\u0011\u0005!q\u0004\u0005\b\u0005W9A\u0011\u0001B\u0017\u0011\u0019\u0011yc\u0002C!y!9!\u0011G\u0004\u0005B\tM\u0002b\u0002B \u000f\u0011\u0005!\u0011I\u0001\u0011#V|G/Y\"p_J$\u0017N\\1u_JT!!\u000b\u0016\u0002\u000bE,x\u000e^1\u000b\u0005-b\u0013aC2p_J$\u0017N\\1u_JT\u0011!L\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0001\u0014!D\u0001)\u0005A\tVo\u001c;b\u0007>|'\u000fZ5oCR|'o\u0005\u0002\u0002gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0018\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\tQ\bE\u0002?\u0003\u000ek\u0011a\u0010\u0006\u0003\u0001V\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011uHA\u0002TKR\u0004\"\u0001R&\u000f\u0005\u0015K\u0005C\u0001$6\u001b\u00059%B\u0001%/\u0003\u0019a$o\\8u}%\u0011!*N\u0001\u0007!J,G-\u001a4\n\u00051k%AB*ue&twM\u0003\u0002Kk\u00051\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\b%A\u0003baBd\u0017\u0010F\bR\u0005\u0013\u0012iEa\u0014\u0003Z\tm#Q\fB6!\t\u0001ta\u0005\u0003\bgMK\u0006C\u0001+X\u001b\u0005)&B\u0001,-\u0003\u0015)H/\u001b7t\u0013\tAVKA\u0004M_\u001e<\u0017N\\4\u0011\u0005ikV\"A.\u000b\u0005qc\u0013AB:feZ,'/\u0003\u0002_7\n!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002CB\u0011AGY\u0005\u0003GV\u00121!\u00138u\u0003%\u0011'o\\6fe&#\u0007%A\u0006rk>$\u0018mQ8oM&<W#A4\u0011\u0005AB\u0017BA5)\u0005Y\tVo\u001c;b\u0007>|'\u000fZ5oCR|'oQ8oM&<\u0017\u0001D9v_R\f7i\u001c8gS\u001e\u0004\u0013!E9v_R\f7\u000b^1uK6\u000bg.Y4feV\tQ\u000e\u0005\u00021]&\u0011q\u000e\u000b\u0002\u0012#V|G/Y*uCR,W*\u00198bO\u0016\u0014\u0018AE9v_R\f7\u000b^1uK6\u000bg.Y4fe\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0003M\u0004\"\u0001^?\u000e\u0003UT!A^<\u0002\tU$\u0018\u000e\u001c\u0006\u00039bT!!L=\u000b\u0005i\\\u0018AB1qC\u000eDWMC\u0001}\u0003\ry'oZ\u0005\u0003}V\u0014\u0011bU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%A\u000bj]R,'O\\1m\u0003\u0012l\u0017N\\*vaBd\u0017.\u001a:\u0016\u0005\u0005\u0015\u0001CBA\u0004\u0003'\t9\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003!1WO\\2uS>t'b\u0001<\u0002\u0010)\u0011\u0011\u0011C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0016\u0005%!\u0001C*vaBd\u0017.\u001a:\u0011\u0007i\u000bI\"C\u0002\u0002\u001cm\u0013Q\"\u00138uKJt\u0017\r\\!e[&t\u0017AF5oi\u0016\u0014h.\u00197BI6LgnU;qa2LWM\u001d\u0011\u00023\rdWo\u001d;fe2+g/\u001a7Rk>$\u0018mQ1mY\n\f7m[\u000b\u0003\u0003G\u0001B!!\n\u0002*5\u0011\u0011q\u0005\u0006\u0003S]LA!a\u000b\u0002(\tI2\t\\;ti\u0016\u0014H*\u001a<fYF+x\u000e^1DC2d'-Y2l\u0003i\u0019G.^:uKJdUM^3m#V|G/Y\"bY2\u0014\u0017mY6!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003{i!!a\u000e\u000b\u0007Y\u000bIDC\u0002\u0002<a\faaY8n[>t\u0017\u0002BA \u0003o\u0011A\u0001V5nK\u0006)A/[7fAQy\u0011+!\u0012\u0002H\u0005%\u00131JA'\u0003\u001f\n\t\u0006C\u0003`-\u0001\u0007\u0011\rC\u0003f-\u0001\u0007q\rC\u0003l-\u0001\u0007Q\u000eC\u0003r-\u0001\u00071\u000fC\u0004\u0002\u0002Y\u0001\r!!\u0002\t\u000f\u0005}a\u00031\u0001\u0002$!9\u0011q\u0006\fA\u0002\u0005M\u0012\u0001C5t\u0003\u000e$\u0018N^3\u0016\u0005\u0005]\u0003\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0007CR|W.[2\u000b\t\u0005\u0005\u0014QB\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA3\u00037\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!C5t\u0003\u000e$\u0018N^3!\u0003%\u0019X\r^!di&4X\r\u0006\u0003\u0002n\u0005M\u0004c\u0001\u001b\u0002p%\u0019\u0011\u0011O\u001b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003kJ\u0002\u0019AA<\u0003\u0019\t7\r^5wKB\u0019A'!\u001f\n\u0007\u0005mTGA\u0004C_>dW-\u00198\u0002'\u001d,GO\u0011:pW\u0016\u0014\u0018+^8uC2KW.\u001b;\u0015\t\u0005\u0005\u0015q\u0011\t\u0004i\u0005\r\u0015bAACk\t1Ai\\;cY\u0016Dq!!#\u001b\u0001\u0004\tY)A\u0005rk>$\u0018\rV=qKB!\u0011QEAG\u0013\u0011\ty)a\n\u0003\u001f\rc\u0017.\u001a8u#V|G/\u0019+za\u0016\fQbY8naV$X-U;pi\u0006\u001cH\u0003CA7\u0003+\u000b9*a-\t\u000b}[\u0002\u0019A1\t\u000f\u0005e5\u00041\u0001\u0002\u001c\u0006a\u0011/^8uC\u0016sGO]5fgB1\u0011QTAT\u0003[sA!a(\u0002$:\u0019a)!)\n\u0003YJ1!!*6\u0003\u001d\u0001\u0018mY6bO\u0016LA!!+\u0002,\nA\u0011\n^3sC\ndWMC\u0002\u0002&V\u00022\u0001MAX\u0013\r\t\t\f\u000b\u0002\u001b#V|G/Y#oi&$\u00180\u00118e\u0007>t7/^7qi&|gn\u001d\u0005\b\u0003k[\u0002\u0019AA\\\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u00045\u0003s\u000bi,!\u001c\n\u0007\u0005mVGA\u0005Gk:\u001cG/[8ocA\u0019\u0001'a0\n\u0007\u0005\u0005\u0007FA\tSKB|'\u000f^)v_R\f'+Z:vYR\fQ\u0002Z3tGJL'-Z)v_R\fG\u0003BAd\u0003?\u0004r\u0001NAe\u0003\u001b\fI.C\u0002\u0002LV\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BAh\u0003+l!!!5\u000b\t\u0005M\u0017\u0011H\u0001\taJ|Go\\2pY&!\u0011q[Ai\u0005\u0019)%O]8sgB\u0019\u0001'a7\n\u0007\u0005u\u0007F\u0001\tRk>$\u0018\rR3tGJL\u0007\u000f^5p]\"9\u0011\u0011\u001d\u000fA\u0002\u0005\r\u0018aC9v_R\fWI\u001c;jif\u00042\u0001MAs\u0013\r\t9\u000f\u000b\u0002\f#V|G/Y#oi&$\u00180\u0001\nrk>$\u0018m\u001d+pa&\u001c7i\u001c8gS\u001e\u001cXCAAw!\u0011\ty/!=\u000e\u0005\u00055\u0011\u0002BAz\u0003\u001b\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u00031\u0001\u0018M\u001d;ji&|gNR8s)\r\t\u0017\u0011 \u0005\b\u0003Ct\u0002\u0019AAr\u0003M1\u0018\r\\5eCR,\u0017+^8uC\u0016sG/\u001b;z)\u0011\tyP!\u0002\u0011\u000bQ\u0012\t!!4\n\u0007\t\rQG\u0001\u0004PaRLwN\u001c\u0005\b\u0003C|\u0002\u0019AAr\u0003)yg.\u00127fGRLwN\u001c\u000b\u0007\u0003[\u0012YAa\u0004\t\r\t5\u0001\u00051\u0001b\u0003U\tXo\u001c;b)>\u0004\u0018n\u0019)beRLG/[8o\u0013\u0012DaA!\u0005!\u0001\u0004\t\u0017\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u00035ygNU3tS\u001et\u0017\r^5p]R1\u0011Q\u000eB\f\u00053AaA!\u0004\"\u0001\u0004\t\u0007b\u0002B\tC\u0001\u0007!1\u0004\t\u0005i\t\u0005\u0011-A\u0004ti\u0006\u0014H/\u001e9\u0015\t\u00055$\u0011\u0005\u0005\b\u0005G\u0011\u0003\u0019\u0001B\u0013\u0003\u0001\u0012X\r\u001e:jKZ,\u0017+^8uCR{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0011\tQ\u00129#Y\u0005\u0004\u0005S)$!\u0003$v]\u000e$\u0018n\u001c81\u0003!\u0019\b.\u001e;e_^tGCAA7\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\fqC^1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u00055$Q\u0007\u0005\b\u0005o)\u0003\u0019\u0001B\u001d\u0003%qWm^\"p]\u001aLw\rE\u0002[\u0005wI1A!\u0010\\\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0007\u0003[\u0012\u0019Ea\u0012\t\u000f\t\u0015c\u00051\u0001\u0003:\u0005Iq\u000e\\2D_:4\u0017n\u001a\u0005\b\u0005o1\u0003\u0019\u0001B\u001d\u0011\u001d\u0011Y%\u0002a\u0001\u0005s\taaY8oM&<\u0007\"B9\u0006\u0001\u0004\u0019\bb\u0002B)\u000b\u0001\u0007!1K\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\rQ&QK\u0005\u0004\u0005/Z&A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\b\u0003\u0003)\u0001\u0019AA\u0003\u0011\u001d\ty\"\u0002a\u0001\u0003GAqAa\u0018\u0006\u0001\u0004\u0011\t'A\u0004nKR\u0014\u0018nY:\u0011\t\t\r$qM\u0007\u0003\u0005KRAAa\u0018\u0002:%!!\u0011\u000eB3\u0005\u001diU\r\u001e:jGNDq!a\f\u0006\u0001\u0004\t\u0019$\u0001\frk>$\u0018mQ8pe\u0012Lg.\u0019;pe\u000e{gNZ5h)\r9'\u0011\u000f\u0005\b\u0005\u00172\u0001\u0019\u0001B\u001d\u0001")
public class QuotaCoordinator
implements Logging,
BrokerReconfigurable {
    private final int brokerId;
    private final QuotaCoordinatorConfig quotaConfig;
    private final QuotaStateManager quotaStateManager;
    private final Scheduler scheduler;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private final Time time;
    private final AtomicBoolean isActive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static QuotaCoordinator apply(KafkaConfig kafkaConfig, Scheduler scheduler, ReplicaManager replicaManager, Supplier<InternalAdmin> supplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Metrics metrics, Time time) {
        QuotaCoordinator$ quotaCoordinator$ = QuotaCoordinator$.MODULE$;
        if (quotaCoordinator$ == null) {
            throw null;
        }
        QuotaCoordinatorConfig apply_quotaConfig = quotaCoordinator$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(kafkaConfig);
        QuotaStateManager apply_quotaStateManager = new QuotaStateManager(apply_quotaConfig, scheduler, replicaManager, metrics, time);
        return new QuotaCoordinator(kafkaConfig.brokerId(), apply_quotaConfig, apply_quotaStateManager, scheduler, supplier, clusterLevelQuotaCallback, time);
    }

    public static Set<String> ReconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public Time time() {
        return this.time;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive().set(active);
    }

    public double getBrokerQuotaLimit(ClientQuotaType quotaType) {
        double d;
        if (ClientQuotaType.FETCH.equals(quotaType)) {
            d = this.quotaConfig().quotasBrokerLimitConsumer();
        } else if (ClientQuotaType.PRODUCE.equals(quotaType)) {
            d = this.quotaConfig().quotasBrokerLimitProducer();
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Not a client quota type: ").append(quotaType).toString());
        }
        return d;
    }

    public void computeQuotas(int brokerId, Iterable<QuotaEntityAndConsumptions> quotaEntries, Function1<ReportQuotaResult, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)((TraversableOnce)quotaEntries.map((Function1 & Serializable & scala.Serializable)quotaEntityAndConsumptions -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)Errors.COORDINATOR_NOT_AVAILABLE), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
            return;
        }
        scala.collection.mutable.Map invalidQuotaEntries = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer validQuotaEntries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntries.foreach((Function1 & Serializable & scala.Serializable)quotaEntityAndConsumptions -> {
            this.processQuotaEntry$1(quotaEntityAndConsumptions, invalidQuotaEntries, brokerId, validQuotaEntries);
            return BoxedUnit.UNIT;
        });
        if (invalidQuotaEntries.nonEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Skipping quota computation for ").append(invalidQuotaEntries.size()).append(" quota entries because they failed validation").toString());
        }
        scala.collection.immutable.Map quotaEntriesPerPartition = validQuotaEntries.groupBy((Function1 & Serializable & scala.Serializable)quotaEntry -> new TopicPartition("_confluent-quotas", this.partitionFor(quotaEntry.quotaEntity())));
        this.quotaStateManager().storeQuotas((Map<TopicPartition, Iterable<QuotaEntry>>)quotaEntriesPerPartition, (Function1<Map<Object, Errors>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseStatus -> {
            scala.collection.immutable.Map $anonfun$computeQuotas$9_storeQuotaCallback$1_entityResults = ((TraversableOnce)quotaEntries.map((Function1 & Serializable & scala.Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable & scala.Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)$anonfun$computeQuotas$9_storeQuotaCallback$1_entityResults.$plus$plus((GenTraversableOnce)invalidQuotaEntries)));
            return BoxedUnit.UNIT;
        }, this.quotaStateManager().storeQuotas$default$3());
    }

    public Tuple2<Errors, QuotaDescription> describeQuota(QuotaEntity quotaEntity) {
        Tuple2 tuple2;
        if (!this.isActive().get()) {
            return new Tuple2((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
        }
        Option<Errors> option = this.validateQuotaEntity(quotaEntity);
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            tuple2 = new Tuple2((Object)error, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
        } else if (None$.MODULE$.equals(option)) {
            Tuple2 tuple22;
            Option<QuotaEntry> option2 = this.quotaStateManager().getQuota(quotaEntity);
            if (option2 instanceof Some) {
                QuotaEntry quotaEntry = (QuotaEntry)((Some)option2).value();
                tuple22 = new Tuple2((Object)Errors.NONE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((TraversableOnce)((TraversableLike)quotaEntry.computedQuotas().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    int brokerId = x0$1._1$mcI$sp();
                    scala.collection.mutable.Map perBrokerQuotas = (scala.collection.mutable.Map)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)((TraversableOnce)perBrokerQuotas.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        if (x0$2 == null) {
                            throw new MatchError(null);
                        }
                        String quotaType = (String)x0$2._1();
                        QuotaValue quotaValue = (QuotaValue)x0$2._2();
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaType), (Object)BoxesRunTime.boxToDouble((double)quotaValue.quota()));
                        return tuple2;
                    }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                    return tuple2;
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
            } else if (None$.MODULE$.equals(option2)) {
                tuple22 = new Tuple2((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)scala.collection.Map$.MODULE$.empty()));
            } else {
                throw new MatchError(option2);
            }
            tuple2 = tuple22;
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties quotasTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put("cleanup.policy", "compact");
        props.put("segment.bytes", Integer.toString(this.quotaConfig().quotasTopicSegmentBytes()));
        props.put("compression.type", BrokerCompressionType.PRODUCER.name);
        props.put("confluent.placement.constraints", this.quotaConfig().quotasTopicPlacementConstraints());
        return var1_1;
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return this.quotaStateManager().partitionFor(quotaEntity);
    }

    public Option<Errors> validateQuotaEntity(QuotaEntity quotaEntity) {
        if (this.quotaStateManager().isLoadingQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        if (!this.quotaStateManager().ownsQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.NOT_COORDINATOR);
        }
        return None$.MODULE$;
    }

    public void onElection(int quotaTopicPartitionId, int coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Elected as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().loadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void onResignation(int quotaTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Resigned as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().unloadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler().startup();
        this.quotaStateManager().startup(retrieveQuotaTopicPartitionCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.maybeCreateQuotaTopic$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.quotaStateManager().shutdown();
        this.scheduler().shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig olcConfig, KafkaConfig newConfig) {
        this.quotaStateManager().reconfigure(QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(newConfig));
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$3(QuotaCoordinator $this, QuotaEntry quotaEntry$1, int brokerId$1, QuotaConsumption quotaConsumption) {
        ClientQuotaType clientQuotaType = ClientQuotaType.valueOf((String)quotaConsumption.quotaType());
        Double clusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(clientQuotaType, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaEntry$1.quotaEntity().entityTypes()).asJava());
        quotaEntry$1.updateConsumptionAndRecomputeQuotas(brokerId$1, quotaConsumption, Predef$.MODULE$.Double2double(clusterQuotaLimit), $this.getBrokerQuotaLimit(clientQuotaType), $this.time().milliseconds(), $this.quotaConfig().quotasConsumptionExpirationTimeMs(), $this.quotaConfig().quotasRecomputeIntervalMs(), $this.quotaConfig().quotasLazyEvaluationThreshold());
    }

    private final void processQuotaEntry$1(QuotaEntityAndConsumptions quotaEntityAndConsumptions, scala.collection.mutable.Map invalidQuotaEntries$1, int brokerId$1, Buffer validQuotaEntries$1) {
        Option<Errors> option = this.validateQuotaEntity(quotaEntityAndConsumptions.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            invalidQuotaEntries$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)error));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            QuotaEntry quotaEntry = this.quotaStateManager().getAndMaybePutQuota(quotaEntityAndConsumptions.entity());
            quotaEntry.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> quotaEntityAndConsumptions.consumptions().foreach((Function1 & Serializable & scala.Serializable)quotaConsumption -> {
                QuotaCoordinator.$anonfun$computeQuotas$3(this, quotaEntry, brokerId$1, quotaConsumption);
                return BoxedUnit.UNIT;
            }));
            validQuotaEntries$1.$plus$eq((Object)quotaEntry);
            return;
        }
        throw new MatchError(option);
    }

    private final void storeQuotaCallback$1(Map responseStatus, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1) {
        scala.collection.immutable.Map entityResults = ((TraversableOnce)quotaEntries$1.map((Function1 & Serializable & scala.Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable & scala.Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        responseCallback$1.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)entityResults.$plus$plus((GenTraversableOnce)invalidQuotaEntries$1)));
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$9(QuotaCoordinator $this, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1, Map responseStatus) {
        scala.collection.immutable.Map storeQuotaCallback$1_entityResults = ((TraversableOnce)quotaEntries$1.map((Function1 & Serializable & scala.Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable & scala.Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        responseCallback$1.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)storeQuotaCallback$1_entityResults.$plus$plus((GenTraversableOnce)invalidQuotaEntries$1)));
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$1(Tuple2 x$1) {
        return ((TraversableOnce)x$1._2()).nonEmpty();
    }

    private final void maybeCreateQuotaTopic$1() {
        boolean topicCreated = false;
        while (!topicCreated) {
            try {
                this.internalAdminSupplier().get().ensureTopic("_confluent-quotas", this.quotaConfig().quotasTopicPartitions(), this.quotaConfig().quotasTopicReplicationFactor(), this.quotasTopicConfigs());
                topicCreated = true;
                this.isActive().set(true);
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Failed to create topic ").append("_confluent-quotas").append(" with error ").append(t).append(", retrying after 5 seconds").toString());
                Thread.sleep(5000L);
            }
        }
    }

    public QuotaCoordinator(int brokerId, QuotaCoordinatorConfig quotaConfig, QuotaStateManager quotaStateManager, Scheduler scheduler, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Time time) {
        this.brokerId = brokerId;
        this.quotaConfig = quotaConfig;
        this.quotaStateManager = quotaStateManager;
        this.scheduler = scheduler;
        this.internalAdminSupplier = internalAdminSupplier;
        this.clusterLevelQuotaCallback = clusterLevelQuotaCallback;
        this.time = time;
        Logging.$init$(this);
        this.isActive = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder(30).append("[QuotaCoordinator brokerId=").append(brokerId).append("]: ").toString());
    }
}

