/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Off$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r=x!B\u001b7\u0011\u0003id!B 7\u0011\u0003\u0001\u0005\"B$\u0002\t\u0003A\u0005\"B%\u0002\t\u0003Q\u0005bBBr\u0003\u0011%1Q\u001d\u0005\b\u0007S\fA\u0011BBv\r\u0011yd\u0007\u0001'\t\u0011M3!\u0011!Q\u0001\nQC\u0001b\u0016\u0004\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\tK\u001a\u0011\t\u0011)A\u0005M\"AAN\u0002B\u0001B\u0003%Q\u000e\u0003\u0005q\r\t\u0005\t\u0015!\u0003r\u0011!!hA!A!\u0002\u0013)\b\u0002\u0003?\u0007\u0005\u0003\u0005\u000b\u0011B?\t\r\u001d3A\u0011AA\u0001\u000b\u0019\t\tB\u0002\u0001\u0002\u0014\u00151\u0011Q\u0005\u0004\u0001\u0003O)a!!\u000e\u0007\u0001\u0005]RABA3\r\u0001\t9#\u0002\u0004\u0002h\u0019\u0001\u0011\u0011\u000e\u0005\n\u0003'3!\u0019!C\u0005\u0003+C\u0001\"!,\u0007A\u0003%\u0011q\u0013\u0005\n\u0003_3!\u0019!C\u0001\u0003cCq!a-\u0007A\u0003%\u0011\u000eC\u0005\u00026\u001a\u0001\r\u0011\"\u0003\u00028\"I\u0011q\u0018\u0004A\u0002\u0013%\u0011\u0011\u0019\u0005\t\u0003\u000f4\u0001\u0015)\u0003\u0002:\"9\u0011\u0011\u001b\u0004\u0005\u0002\u0005M\u0007bBAp\r\u0011\u0005\u0011\u0011\u001d\u0005\n\u0005C1\u0011\u0013!C\u0001\u0005GAqA!\u000f\u0007\t\u0013\u0011Y\u0004C\u0004\u0003`\u0019!\tA!\u0019\t\u000f\t\u0005e\u0001\"\u0001\u0003\u0004\"9!Q\u0013\u0004\u0005\u0002\t]\u0005b\u0002Bb\r\u0011\u0005!Q\u0019\u0005\n\u0005+4\u0011\u0013!C\u0001\u0005GAqAa6\u0007\t\u0003\u0011I\u000eC\u0004\u0003b\u001a!\tAa9\t\u000f\t-h\u0001\"\u0003\u0003n\"911\u0003\u0004\u0005\u0002\rU\u0001\"CB\u0014\rE\u0005I\u0011\u0001B\u0012\u0011\u001d\u0019IC\u0002C\u0005\u0007WAqaa\r\u0007\t\u0013\u0019)\u0004C\u0004\u0004J\u0019!Iaa\u0013\t\u000f\rEc\u0001\"\u0003\u0004T!911\r\u0004\u0005\u0002\r\u0015\u0004bBB8\r\u0011\u00051\u0011\u000f\u0005\b\u0007g2A\u0011AB;\u0011\u001d\u0019IH\u0002C\u0005\u0007wB\u0001b!$\u0007\t\u000314q\u0012\u0005\b\u0007/3A\u0011ABM\u0011%\u0019)KBI\u0001\n\u0003\u00199\u000bC\u0004\u0004,\u001a!\ta!,\u0002-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_JT!a\u000e\u001d\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003si\n1bY8pe\u0012Lg.\u0019;pe*\t1(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005y\nQ\"\u0001\u001c\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\u001c\"!A!\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ(A\u0003baBd\u0017\u0010F\bL\u0007_\u001bIla1\u0004F\u000e%7q[Bq!\tqdaE\u0002\u0007\u00036\u0003\"AT)\u000e\u0003=S!\u0001\u0015\u001e\u0002\u000bU$\u0018\u000e\\:\n\u0005I{%a\u0002'pO\u001eLgnZ\u0001\nibt7i\u001c8gS\u001e\u0004\"AP+\n\u0005Y3$!\u0005+sC:\u001c\u0018m\u0019;j_:\u001cuN\u001c4jO\u0006I1o\u00195fIVdWM\u001d\t\u00033\u000el\u0011A\u0017\u0006\u00037r\u000bA!\u001e;jY*\u0011QLX\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005mz&B\u00011b\u0003\u0019\t\u0007/Y2iK*\t!-A\u0002pe\u001eL!\u0001\u001a.\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018aF2sK\u0006$X\r\u0015:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3s!\r\u0011u-[\u0005\u0003Q\u000e\u0013\u0011BR;oGRLwN\u001c\u0019\u0011\u0005yR\u0017BA67\u0005E\u0001&o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM]\u0001\u000bibtW*\u00198bO\u0016\u0014\bC\u0001 o\u0013\tygGA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe\u00069B\u000f\u001f8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003}IL!a\u001d\u001c\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'/\u0001\u0003uS6,\u0007C\u0001<{\u001b\u00059(B\u0001)y\u0015\tIh,\u0001\u0004d_6lwN\\\u0005\u0003w^\u0014A\u0001V5nK\u0006QAn\\4D_:$X\r\u001f;\u0011\u0005Yt\u0018BA@x\u0005)aunZ\"p]R,\u0007\u0010\u001e\u000b\u0010\u0017\u0006\r\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0002\u0010!)1K\u0004a\u0001)\")qK\u0004a\u00011\")QM\u0004a\u0001M\")AN\u0004a\u0001[\")\u0001O\u0004a\u0001c\")AO\u0004a\u0001k\")AP\u0004a\u0001{\n1\u0012J\\5u!J|G-^2fe&#7)\u00197mE\u0006\u001c7\u000eE\u0004C\u0003+\tI\"a\b\n\u0007\u0005]1IA\u0005Gk:\u001cG/[8ocA\u0019a(a\u0007\n\u0007\u0005uaG\u0001\u000bJ]&$\bK]8ek\u000e,'/\u00133SKN,H\u000e\u001e\t\u0004\u0005\u0006\u0005\u0012bAA\u0012\u0007\n!QK\\5u\u0005U\tE\r\u001a)beRLG/[8og\u000e\u000bG\u000e\u001c2bG.\u0004rAQA\u000b\u0003S\ty\u0002\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty\u0003_\u0001\taJ|Go\\2pY&!\u00111GA\u0017\u0005\u0019)%O]8sg\nAb+\u001a:jMf\u0004\u0016M\u001d;ji&|gn]\"bY2\u0014\u0017mY6\u0011\u000f\t\u000b)\"!\u000f\u0002 A!\u00111HA0\u001d\u0011\ti$!\u0017\u000f\t\u0005}\u0012Q\u000b\b\u0005\u0003\u0003\n\u0019F\u0004\u0003\u0002D\u0005Ec\u0002BA#\u0003\u001frA!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017b\u0014A\u0002\u001fs_>$h(C\u0001c\u0013\t\u0001\u0017-\u0003\u0002<?&\u0011\u0011PX\u0005\u0004\u0003/B\u0018aB7fgN\fw-Z\u0005\u0005\u00037\ni&\u0001\u0010BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)bt'+Z:q_:\u001cX\rR1uC*\u0019\u0011q\u000b=\n\t\u0005\u0005\u00141\r\u0002\u0019\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_RChNU3tk2$(\u0002BA.\u0003;\u0012a\"\u00128e)bt7)\u00197mE\u0006\u001c7NA\u0005Ba&\u0014Vm];miV!\u00111NAA!!\ti'a\u001e\u0002*\u0005ud\u0002BA8\u0003grA!a\u0012\u0002r%\tA)C\u0002\u0002v\r\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002z\u0005m$AB#ji\",'OC\u0002\u0002v\r\u0003B!a \u0002\u00022\u0001AaBAB'\t\u0007\u0011Q\u0011\u0002\u0002)F!\u0011qQAG!\r\u0011\u0015\u0011R\u0005\u0004\u0003\u0017\u001b%a\u0002(pi\"Lgn\u001a\t\u0004\u0005\u0006=\u0015bAAI\u0007\n\u0019\u0011I\\=\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\"!a&\u0011\t\u0005e\u0015\u0011V\u0007\u0003\u00037SA!!(\u0002 \u00061\u0011\r^8nS\u000eTA!!)\u0002$\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007m\u000b)K\u0003\u0002\u0002(\u0006!!.\u0019<b\u0013\u0011\tY+a'\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003%I7/Q2uSZ,\u0007%A\tqe>$WoY3s\u0013\u0012l\u0015M\\1hKJ,\u0012![\u0001\u0013aJ|G-^2fe&#W*\u00198bO\u0016\u0014\b%\u0001\u0007m_\u001e4VM\u001d2pg&$\u00180\u0006\u0002\u0002:B\u0019a(a/\n\u0007\u0005ufGA\u000eUe\u0006t7/Y2uS>tGj\\4hS:<g+\u001a:c_NLG/_\u0001\u0011Y><g+\u001a:c_NLG/_0%KF$B!a\b\u0002D\"I\u0011QY\r\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\u0004q\u0012\n\u0014!\u00047pOZ+'OY8tSRL\b\u0005K\u0002\u001b\u0003\u0017\u00042AQAg\u0013\r\tym\u0011\u0002\tm>d\u0017\r^5mK\u0006\u00192/\u001a;M_\u001e<\u0017N\\4WKJ\u0014wn]5usR!\u0011qDAk\u0011\u001d\t9n\u0007a\u0001\u00033\fQ\u0001\\3wK2\u00042AQAn\u0013\r\tin\u0011\u0002\u0004\u0013:$\u0018\u0001\u00065b]\u0012dW-\u00138jiB\u0013x\u000eZ;dKJLE\r\u0006\u0007\u0002 \u0005\r\u0018q_A~\u0005\u0017\u0011\u0019\u0002C\u0004\u0002fr\u0001\r!a:\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0004B!!;\u0002r:!\u00111^Aw!\r\t9eQ\u0005\u0004\u0003_\u001c\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002t\u0006U(AB*ue&twMC\u0002\u0002p\u000eCq!!?\u001d\u0001\u0004\tI.\u0001\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0005\b\u0003{d\u0002\u0019AA\u0000\u0003i)\u0007\u0010]3di\u0016$\u0007K]8ek\u000e,'/\u00133B]\u0012,\u0005o\\2i!\u0015\u0011%\u0011\u0001B\u0003\u0013\r\u0011\u0019a\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007Y\u00149!C\u0002\u0003\n]\u0014!\u0003\u0015:pIV\u001cWM]%e\u0003:$W\t]8dQ\"9!Q\u0002\u000fA\u0002\t=\u0011\u0001\u0005:fgB|gn]3DC2d'-Y2l!\r\u0011\tbD\u0007\u0002\r!I!Q\u0003\u000f\u0011\u0002\u0003\u0007!qC\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\t\u0005\u00053\u0011i\"\u0004\u0002\u0003\u001c)\u0011QLO\u0005\u0005\u0005?\u0011YB\u0001\u0007SKF,Xm\u001d;M_\u000e\fG.\u0001\u0010iC:$G.Z%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u0005\u0016\u0005\u0005/\u00119c\u000b\u0002\u0003*A!!1\u0006B\u001b\u001b\t\u0011iC\u0003\u0003\u00030\tE\u0012!C;oG\",7m[3e\u0015\r\u0011\u0019dQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u001c\u0005[\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q\u0001(/\u001a9be\u0016Le.\u001b;Qe>$WoY3s\u0013\u0012$&/\u00198tSR$BB!\u0010\u0003L\t5#q\nB*\u0005;\u0002RA!\u0005\u0014\u0005\u007f\u0001rA\u0011B!\u00033\u0014)%C\u0002\u0003D\r\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001 \u0003H%\u0019!\u0011\n\u001c\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/\u0019\u0005\b\u0003Kt\u0002\u0019AAt\u0011\u001d\tIP\ba\u0001\u00033DqA!\u0015\u001f\u0001\u0004\tI.\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\"9!Q\u000b\u0010A\u0002\t]\u0013a\u0003;y]6+G/\u00193bi\u0006\u00042A\u0010B-\u0013\r\u0011YF\u000e\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0005\b\u0003{t\u0002\u0019AA\u0000\u0003YA\u0017M\u001c3mK2K7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001cHC\u0002B2\u0005W\u0012Y\b\u0005\u0003\u0003f\t\u001dTBAA/\u0013\u0011\u0011I'!\u0018\u000391K7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001c(+Z:q_:\u001cX\rR1uC\"9!QN\u0010A\u0002\t=\u0014a\u00054jYR,'/\u001a3Qe>$WoY3s\u0013\u0012\u001c\bCBAu\u0005c\u0012)(\u0003\u0003\u0003t\u0005U(aA*fiB\u0019!Ia\u001e\n\u0007\te4I\u0001\u0003M_:<\u0007b\u0002B??\u0001\u0007!qP\u0001\u000fM&dG/\u001a:fIN#\u0018\r^3t!\u0019\tIO!\u001d\u0002h\u0006Q\u0002.\u00198eY\u0016$Um]2sS\n,GK]1og\u0006\u001cG/[8ogR!!Q\u0011BJ!\u0011\u00119I!$\u000f\t\t\u0015$\u0011R\u0005\u0005\u0005\u0017\u000bi&\u0001\u0011EKN\u001c'/\u001b2f)J\fgn]1di&|gn\u001d*fgB|gn]3ECR\f\u0017\u0002\u0002BH\u0005#\u0013\u0001\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3\u000b\t\t-\u0015Q\f\u0005\b\u0003K\u0004\u0003\u0019AAt\u0003\rB\u0017M\u001c3mKZ+'/\u001b4z!\u0006\u0014H/\u001b;j_:\u001c\u0018J\u001c+sC:\u001c\u0018m\u0019;j_:$B\"a\b\u0003\u001a\nm%q\u0014BU\u0005\u007fCq!!:\"\u0001\u0004\t9\u000fC\u0004\u0003\u001e\u0006\u0002\rA!\u001e\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0004\u0003\"\u0006\u0002\rAa)\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\r\u0011%QU\u0005\u0004\u0005O\u001b%!B*i_J$\bb\u0002BVC\u0001\u0007!QV\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bC\u0002BX\u0005k\u00139,\u0004\u0002\u00032*\u0019!1W\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003t\tE\u0006\u0003\u0002B]\u0005wk\u0011\u0001_\u0005\u0004\u0005{C(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005\u001b\t\u0003\u0019\u0001Ba!\r\u0011\t\"E\u0001!Q\u0006tG\r\\3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)J\fgn]1di&|g\u000e\u0006\b\u0002 \t\u001d'\u0011\u001aBf\u0005\u001b\u0014yMa5\t\u000f\u0005\u0015(\u00051\u0001\u0002h\"9!Q\u0014\u0012A\u0002\tU\u0004b\u0002BQE\u0001\u0007!1\u0015\u0005\b\u0005W\u0013\u0003\u0019\u0001BW\u0011\u001d\u0011iA\ta\u0001\u0005#\u00042A!\u0005\u0011\u0011%\u0011)B\tI\u0001\u0002\u0004\u00119\"\u0001\u0016iC:$G.Z!eIB\u000b'\u000f^5uS>t7\u000fV8Ue\u0006t7/Y2uS>tG\u0005Z3gCVdG\u000f\n\u001c\u0002\u0015=tW\t\\3di&|g\u000e\u0006\u0004\u0002 \tm'q\u001c\u0005\b\u0005;$\u0003\u0019AAm\u0003M!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\%e\u0011\u001d\u0011\t\u0006\na\u0001\u00033\fQb\u001c8SKNLwM\\1uS>tGCBA\u0010\u0005K\u00149\u000fC\u0004\u0003^\u0016\u0002\r!!7\t\u000f\tES\u00051\u0001\u0003jB)!I!\u0001\u0002Z\u00069Cn\\4J]Z\fG.\u001b3Ti\u0006$X\r\u0016:b]NLG/[8o\u0003:$'+\u001a;ve:,%O]8s)!\u0011yO!?\u0003|\u000e\r\u0001\u0003\u0003By\u0005k\fI#a\"\u000e\u0005\tM(BA.D\u0013\u0011\u00119Pa=\u0003\t1+g\r\u001e\u0005\b\u0003K4\u0003\u0019AAt\u0011\u001d\u0011iP\na\u0001\u0005\u007f\f\u0001\u0003\u001e:b]N\f7\r^5p]N#\u0018\r^3\u0011\u0007y\u001a\t!C\u0002\u0003\u0010ZBqa!\u0002'\u0001\u0004\u00199!A\tue\u0006t7/Y2uS>t'+Z:vYR\u0004Ba!\u0003\u0004\u00105\u001111\u0002\u0006\u0004\u0007\u001bA\u0018\u0001\u0003:fcV,7\u000f^:\n\t\rE11\u0002\u0002\u0012)J\fgn]1di&|gNU3tk2$\u0018\u0001\u00065b]\u0012dW-\u00128e)J\fgn]1di&|g\u000e\u0006\b\u0002 \r]1\u0011DB\u000e\u0007;\u0019\tc!\n\t\u000f\u0005\u0015x\u00051\u0001\u0002h\"9!QT\u0014A\u0002\tU\u0004b\u0002BQO\u0001\u0007!1\u0015\u0005\b\u0007?9\u0003\u0019AB\u0004\u0003=!\bP\\'be.,'OU3tk2$\bb\u0002B\u0007O\u0001\u000711\u0005\t\u0004\u0005#\u0011\u0002\"\u0003B\u000bOA\u0005\t\u0019\u0001B\f\u0003yA\u0017M\u001c3mK\u0016sG\r\u0016:b]N\f7\r^5p]\u0012\"WMZ1vYR$c'\u0001\fnCf\u0014W\rT8h-\u0016\u0014(m\\:f\u001b\u0016\u001c8/Y4f)\u0011\tyb!\f\t\u000f\r=\u0012\u00061\u0001\u00042\u0005a!-^5mI6+7o]1hKB9!)!\u0006\u0002:\u0006\u001d\u0018a\u00067pORCh\u000e\u0015:fa\u0006\u0014XmQ8na2,G/[8o)!\tyba\u000e\u0004<\r}\u0002bBB\u001dU\u0001\u0007!qK\u0001\t[\u0016$\u0018\rZ1uC\"91Q\b\u0016A\u0002\r\u001d\u0011A\u0002:fgVdG\u000fC\u0004\u0004B)\u0002\raa\u0011\u0002\u0019%\u001chI]8n\u00072LWM\u001c;\u0011\u0007\t\u001b)%C\u0002\u0004H\r\u0013qAQ8pY\u0016\fg.\u0001\tm_\u001e$\u0006P\\\"p[BdW\r^5p]R1\u0011qDB'\u0007\u001fBqa!\u000f,\u0001\u0004\u00119\u0006C\u0004\u0004>-\u0002\raa\u0002\u0002\u001d\u0015tG\r\u0016:b]N\f7\r^5p]R\u0001\u0012qDB+\u0007/\u001aIfa\u0017\u0004^\r}3\u0011\r\u0005\b\u0003Kd\u0003\u0019AAt\u0011\u001d\u0011i\n\fa\u0001\u0005kBqA!)-\u0001\u0004\u0011\u0019\u000bC\u0004\u0004 1\u0002\raa\u0002\t\u000f\r\u0005C\u00061\u0001\u0004D!9!Q\u0002\u0017A\u0002\r\r\u0002b\u0002B\u000bY\u0001\u0007!qC\u0001\u0018iJ\fgn]1di&|g\u000eV8qS\u000e\u001cuN\u001c4jON,\"aa\u001a\u0011\t\r%41N\u0007\u0003\u0003GKAa!\u001c\u0002$\nQ\u0001K]8qKJ$\u0018.Z:\u0002)Ad\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;t+\t\t9/\u0001\u0007qCJ$\u0018\u000e^5p]\u001a{'\u000f\u0006\u0003\u0002Z\u000e]\u0004bBAs_\u0001\u0007\u0011q]\u0001\u0019_:,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\u001cu.\u001c9mKR,G\u0003BB?\u0007\u0007#B!a\b\u0004\u0000!91\u0011\u0011\u0019A\u0002\u0005%\u0012!B3se>\u0014\bbBBCa\u0001\u00071qQ\u0001\u0011ibt\u0017\nZ!oIBKG-\u00129pG\"\u00042APBE\u0013\r\u0019YI\u000e\u0002\")J\fgn]1di&|g.\u00197JI\u0006sG\r\u0015:pIV\u001cWM]%e\u000bB|7\r[\u0001\u001aC\n|'\u000f\u001e+j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u0002 \rE\u0005bBBJc\u0001\u00071QS\u0001\u000b_:\u001cu.\u001c9mKR,\u0007c\u0002\"\u0002\u0016\r\u001d51E\u0001\bgR\f'\u000f^;q)\u0019\tyba'\u0004\"\"91Q\u0014\u001aA\u0002\r}\u0015A\n:fiJLWM^3Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oiB!!iZAm\u0011%\u0019\u0019K\rI\u0001\u0002\u0004\u0019\u0019%A\u0010f]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:\f\u0011c\u001d;beR,\b\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019IK\u000b\u0003\u0004D\t\u001d\u0012\u0001C:ikR$wn\u001e8\u0015\u0005\u0005}\u0001bBBY\u0007\u0001\u000711W\u0001\u0007G>tg-[4\u0011\t\te1QW\u0005\u0005\u0007o\u0013YBA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bBB^\u0007\u0001\u00071QX\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\u0011\u0011Iba0\n\t\r\u0005'1\u0004\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u001596\u00011\u0001Y\u0011\u0019\u00199m\u0001a\u0001M\u0006I2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ$f]\u0016\u0014\u0018\r^8s\u0011\u001d\u0019Ym\u0001a\u0001\u0007\u001b\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0004P\u000eMWBABi\u0015\r\u0019Y\r_\u0005\u0005\u0007+\u001c\tNA\u0004NKR\u0014\u0018nY:\t\u000f\re7\u00011\u0001\u0004\\\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004BA!\u0007\u0004^&!1q\u001cB\u000e\u00055iU\r^1eCR\f7)Y2iK\")Ao\u0001a\u0001k\u0006!\u0012N\\5u)J\fgn]1di&|g.\u0012:s_J$B!!\u0007\u0004h\"91\u0011\u0011\u0003A\u0002\u0005%\u0012aF5oSR$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b)\u0011\tIb!<\t\u000f\tUS\u00011\u0001\u0003F\u0001")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final ProducerIdManager producerIdManager;
    private volatile TransactionLoggingVerbosity logVerbosity;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, Function0<ProducerIdManager> function0, Metrics metrics, MetadataCache metadataCache, Time time) {
        if (TransactionCoordinator$.MODULE$ == null) {
            throw null;
        }
        TransactionConfig apply_txnConfig = new TransactionConfig(Predef$.MODULE$.Integer2int(kafkaConfig.transactionalIdExpirationMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionMaxTimeoutMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicPartitions()), Predef$.MODULE$.Short2short(kafkaConfig.transactionTopicReplicationFactor()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicSegmentBytes()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionsLoadBufferSize()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicMinISR()), (String)kafkaConfig.transactionTopicPlacementConstraints().map(TransactionCoordinator$::$anonfun$apply$1).getOrElse(TransactionCoordinator$::$anonfun$apply$2), Predef$.MODULE$.Integer2int(kafkaConfig.transactionAbortTimedOutTransactionCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionRemoveExpiredTransactionalIdCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.requestTimeoutMs()), TransactionLoggingVerbosity$.MODULE$.fromLevel(kafkaConfig.confluentConfig().transactionLoggingVerbosity()));
        TransactionStateManager apply_txnStateManager = new TransactionStateManager(kafkaConfig.brokerId(), scheduler, replicaManager, apply_txnConfig, time, metrics);
        LogContext apply_logContext = new LogContext(new StringBuilder(29).append("[TransactionCoordinator id=").append(kafkaConfig.brokerId()).append("] ").toString());
        TransactionMarkerChannelManager apply_txnMarkerChannelManager = TransactionMarkerChannelManager$.MODULE$.apply(kafkaConfig, metrics, metadataCache, apply_txnStateManager, time, apply_logContext);
        return new TransactionCoordinator(apply_txnConfig, scheduler, function0, apply_txnStateManager, apply_txnMarkerChannelManager, time, apply_logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public ProducerIdManager producerIdManager() {
        return this.producerIdManager;
    }

    private TransactionLoggingVerbosity logVerbosity() {
        return this.logVerbosity;
    }

    private void logVerbosity_$eq(TransactionLoggingVerbosity x$1) {
        this.logVerbosity = x$1;
    }

    public void setLoggingVerbosity(int level) {
        this.logVerbosity_$eq(TransactionLoggingVerbosity$.MODULE$.fromLevel(level));
    }

    /*
     * WARNING - void declaration
     */
    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null) {
            long producerId = this.producerIdManager().generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
            return;
        }
        if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either<Errors, CoordinatorEpochAndTxnMetadata> either;
            if (None$.MODULE$.equals(x0$1)) {
                long producerId = this.producerIdManager().generateProducerId();
                long x$3 = -1L;
                short x$4 = -1;
                short x$5 = -1;
                Empty$ x$7 = Empty$.MODULE$;
                scala.collection.mutable.Set x$8 = scala.collection.mutable.Set$.MODULE$.empty();
                long x$9 = $this.time.milliseconds();
                long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
                TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId, producerId, x$3, x$4, x$5, transactionTimeoutMs, x$7, (scala.collection.mutable.Set<TopicPartition>)x$8, x$10, x$9);
                either = $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
            } else {
                throw new MatchError(x0$1);
            }
            return either;
        }).flatMap((Function1 & Serializable & scala.Serializable)existingEpochAndMetadata -> {
            int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
            return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> this.prepareInitProducerIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata, expectedProducerIdAndEpoch));
        });
        if (result instanceof Left) {
            Errors error2 = (Errors)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                Tuple2 tuple22;
                void endTransaction_txnMarkerResult;
                void endTransaction_producerEpoch;
                void endTransaction_isFromClient;
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)error -> {
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                    } else {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    }
                    return BoxedUnit.UNIT;
                };
                boolean bl = false;
                TransactionResult transactionResult = TransactionResult.ABORT;
                short s = newMetadata.producerEpoch();
                long endTransaction_producerId = newMetadata.producerId();
                BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
                if (transactionalId.isEmpty()) {
                    Errors errors;
                    Errors errors2 = errors = Errors.INVALID_REQUEST;
                    Errors errors3 = Errors.NONE;
                    if (errors2 == null ? errors3 != null : !errors2.equals(errors3)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap(arg_0 -> TransactionCoordinator.$anonfun$endTransaction$1(this, endTransaction_producerId, (boolean)endTransaction_isFromClient, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, endTransaction_isEpochFence, transactionalId, arg_0));
                if (endTransaction_preAppendResult instanceof Left) {
                    Errors errors;
                    Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
                    this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TransactionCoordinator.$anonfun$endTransaction$4((TransactionResult)endTransaction_txnMarkerResult, endTransaction_err, transactionalId)));
                    Errors errors4 = errors = endTransaction_err;
                    Errors errors5 = Errors.NONE;
                    if (errors4 == null ? errors5 != null : !errors4.equals(errors5)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                if (endTransaction_preAppendResult instanceof Right && (tuple22 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
                    void endTransaction_responseCallback;
                    int endTransaction_coordinatorEpoch = tuple22._1$mcI$sp();
                    TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple22._2();
                    Function1 & Serializable & scala.Serializable endTransaction_x$4 = arg_0 -> TransactionCoordinator.$anonfun$endTransaction$15$adapted(this, transactionalId, endTransaction_coordinatorEpoch, endTransaction_producerId, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, (Function1)endTransaction_responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence, arg_0);
                    Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
                    this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
                    return;
                }
                throw new MatchError((Object)endTransaction_preAppendResult);
            }
            Function1 & Serializable & scala.Serializable x$14 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata));
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$16 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$14, x$16, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleInitProducerId$default$5() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (!expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)producerIdAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata)))) {
            return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
        }
        TransactionState transactionState = txnMetadata.state();
        boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
        if (bl) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
            if (bl2) {
                Left left2;
                Right transitMetadataResult;
                Right right;
                if (txnMetadata.isProducerEpochExhausted() && expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, x$2)))) {
                    long newProducerId = this.producerIdManager().generateProducerId();
                    right = package$.MODULE$.Right().apply((Object)txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                } else {
                    right = transitMetadataResult = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, (Option<Object>)expectedProducerIdAndEpoch.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToShort((short)x$3.epoch)), this.time.milliseconds());
                }
                if (transitMetadataResult instanceof Right) {
                    TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)transitMetadataResult).value();
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (transitMetadataResult instanceof Left) {
                    Errors err = (Errors)((Left)transitMetadataResult).value();
                    left2 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(transitMetadataResult);
                }
                left = left2;
            } else if (Ongoing$.MODULE$.equals(transactionState)) {
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
            } else {
                boolean bl3 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                if (bl3) {
                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                throw new MatchError((Object)transactionState);
            }
        }
        return left;
    }

    public ListTransactionsResponseData handleListTransactions(scala.collection.immutable.Set<Object> filteredProducerIds, scala.collection.immutable.Set<String> filteredStates) {
        if (!this.isActive().get()) {
            return new ListTransactionsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        return this.txnManager.listTransactionStates(filteredProducerIds, filteredStates);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DescribeTransactionsResponseData.TransactionState handleDescribeTransactions(String transactionalId) {
        if (transactionalId == null) {
            throw new IllegalArgumentException("Invalid null transactionalId");
        }
        DescribeTransactionsResponseData.TransactionState transactionState = new DescribeTransactionsResponseData.TransactionState().setTransactionalId(transactionalId);
        if (!this.isActive().get()) {
            return transactionState.setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        if (transactionalId.isEmpty()) {
            return transactionState.setErrorCode(Errors.INVALID_REQUEST.code());
        }
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            Errors error = (Errors)((Left)either).value();
            return transactionState.setErrorCode(error.code());
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (None$.MODULE$.equals(option)) {
                return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
            }
        }
        if (!bl) throw new MatchError(either);
        Option option = (Option)right.value();
        if (!(option instanceof Some)) throw new MatchError(either);
        TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
        return (DescribeTransactionsResponseData.TransactionState)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
            TransactionState transactionState = txnMetadata.state();
            Dead$ dead$ = Dead$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(dead$) : dead$ != null)) {
                return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
            }
            txnMetadata.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$handleDescribeTransactions$2(transactionState, topicPartition)));
            return transactionState.setErrorCode(Errors.NONE.code()).setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionState(txnMetadata.state().name()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStartTimeMs(txnMetadata.txnStartTimestamp());
        });
    }

    public void handleVerifyPartitionsInTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<AddPartitionsToTxnResponseData.AddPartitionsToTxnResult, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request for verification").toString());
            responseCallback.apply((Object)AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)Errors.INVALID_REQUEST), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    block6: {
                        block5: {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block5;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block6;
                        }
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    return package$.MODULE$.Right().apply((Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)part -> {
                        if (txnMetadata.topicPartitions().contains(part)) {
                            return new Tuple2(part, (Object)Errors.NONE);
                        }
                        return new Tuple2(part, (Object)Errors.INVALID_TXN_STATE);
                    }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request for verification").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)err), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())));
            return;
        }
        if (result instanceof Right) {
            scala.collection.immutable.Map errors = (scala.collection.immutable.Map)((Right)result).value();
            BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback.apply((Object)AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)errors).asJava())));
            return;
        }
        throw new MatchError((Object)result);
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    block8: {
                        block7: {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                        }
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    Ongoing$ ongoing$ = Ongoing$.MODULE$;
                    if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                        return package$.MODULE$.Left().apply((Object)Errors.NONE);
                    }
                    return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleAddPartitionsToTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Elected as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch2).toString());
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Resigned as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        if (coordinatorEpoch instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)coordinatorEpoch).value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(coordinatorEpoch)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(coordinatorEpoch);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").append("marker result to send: ").append(transactionResult).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        boolean endTransaction_isFromClient = true;
        BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        this.logTxnPrepareCompletion(txnMetadata, txnMarkerResult, endTransaction_isFromClient);
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        Right right2;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.COMMIT);
                            right2 = package$.MODULE$.Left().apply((Object)Errors.NONE);
                        } else {
                            right2 = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        }
                        right = right2;
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        Right right3;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.ABORT);
                            right3 = package$.MODULE$.Left().apply((Object)Errors.NONE);
                        } else {
                            right3 = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        }
                        right = right3;
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (endTransaction_preAppendResult instanceof Left) {
            Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)endTransaction_err);
            return;
        }
        if (endTransaction_preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
            int endTransaction_coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable & scala.Serializable endTransaction_x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Left left;
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    Left<Errors, Nothing$> left;
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                    if (bl) {
                                        left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else {
                                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                        if (bl2) {
                                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                            throw new IllegalStateException(errorMsg);
                                        }
                                        throw new MatchError((Object)transactionState);
                                    }
                                    return left;
                                });
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                            }
                        } else {
                            throw new MatchError(x0$1);
                        }
                        Left left2 = left;
                        return left2;
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)endTransaction_preAppendResult);
    }

    public RequestLocal handleEndTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private void maybeLogVerboseMessage(Function1<TransactionLoggingVerbosity, String> buildMessage) {
        TransactionLoggingVerbosity verbosity;
        TransactionLoggingVerbosity transactionLoggingVerbosity = verbosity = this.logVerbosity();
        TransactionLoggingVerbosity$Off$ transactionLoggingVerbosity$Off$ = TransactionLoggingVerbosity$Off$.MODULE$;
        if (!(transactionLoggingVerbosity != null ? !transactionLoggingVerbosity.equals(transactionLoggingVerbosity$Off$) : transactionLoggingVerbosity$Off$ != null)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)buildMessage.apply((Object)verbosity));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)buildMessage.apply((Object)verbosity));
    }

    private void logTxnPrepareCompletion(TransactionMetadata metadata, TransactionResult result, boolean isFromClient) {
        TransactionLoggingVerbosity maybeLogVerboseMessage_verbosity;
        Function1 & Serializable & scala.Serializable maybeLogVerboseMessage_buildMessage = (Function1 & Serializable & scala.Serializable)verbosity -> {
            String reason = isFromClient ? "client EndTxn request" : "transaction timeout";
            return new StringBuilder(33).append("Prepare ").append(result).append(" of transaction due to ").append(reason).append(": ").append(metadata.toString((TransactionLoggingVerbosity)verbosity)).toString();
        };
        TransactionLoggingVerbosity transactionLoggingVerbosity = maybeLogVerboseMessage_verbosity = this.logVerbosity();
        TransactionLoggingVerbosity$Off$ transactionLoggingVerbosity$Off$ = TransactionLoggingVerbosity$Off$.MODULE$;
        if (!(transactionLoggingVerbosity != null ? !transactionLoggingVerbosity.equals(transactionLoggingVerbosity$Off$) : transactionLoggingVerbosity$Off$ != null)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)buildMessage.apply((Object)verbosity));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)buildMessage.apply((Object)verbosity));
    }

    private void logTxnCompletion(TransactionMetadata metadata, TransactionResult result) {
        TransactionLoggingVerbosity maybeLogVerboseMessage_verbosity;
        Function1 & Serializable & scala.Serializable maybeLogVerboseMessage_buildMessage = (Function1 & Serializable & scala.Serializable)verbosity -> new StringBuilder(26).append("Complete ").append(result).append(" of transaction: ").append(metadata.toString((TransactionLoggingVerbosity)verbosity)).toString();
        TransactionLoggingVerbosity transactionLoggingVerbosity = maybeLogVerboseMessage_verbosity = this.logVerbosity();
        TransactionLoggingVerbosity$Off$ transactionLoggingVerbosity$Off$ = TransactionLoggingVerbosity$Off$.MODULE$;
        if (!(transactionLoggingVerbosity != null ? !transactionLoggingVerbosity.equals(transactionLoggingVerbosity$Off$) : transactionLoggingVerbosity$Off$ != null)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)buildMessage.apply((Object)verbosity));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)buildMessage.apply((Object)verbosity));
    }

    private void endTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        BooleanRef isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        this.logTxnPrepareCompletion(txnMetadata, txnMarkerResult, endTransaction_isFromClient);
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        Right right2;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.COMMIT);
                            right2 = package$.MODULE$.Left().apply((Object)Errors.NONE);
                        } else {
                            right2 = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        }
                        right = right2;
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        Right right3;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.ABORT);
                            right3 = package$.MODULE$.Left().apply((Object)Errors.NONE);
                        } else {
                            right3 = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        }
                        right = right3;
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (preAppendResult instanceof Left) {
            Errors err = (Errors)((Left)preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)preAppendResult).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Left left;
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    Left<Errors, Nothing$> left;
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                    if (bl) {
                                        left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else {
                                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                        if (bl2) {
                                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                            throw new IllegalStateException(errorMsg);
                                        }
                                        throw new MatchError((Object)transactionState);
                                    }
                                    return left;
                                });
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                            }
                        } else {
                            throw new MatchError(x0$1);
                        }
                        Left left2 = left;
                        return left2;
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$4, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)preAppendResult);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public String placementConstraints() {
        return this.txnManager.placementConstraints();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void onEndTransactionComplete(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        if (Errors.NONE.equals(error)) {
            this.txnManager.transactionTimeoutSensor().record();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Completed rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString());
            return;
        }
        boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(error) ? true : (Errors.PRODUCER_FENCED.equals(error) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(error));
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("has been cancelled due to error ").append(error).toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("failed due to error ").append(error).toString());
    }

    public void abortTimedOutTransactions(Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>> onComplete) {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> {
            $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (None$.MODULE$.equals(x0$1)) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
                } else if (x0$1 instanceof Some) {
                    TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                    ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                            return None$.MODULE$;
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                            return None$.MODULE$;
                        }
                        return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                    })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                        this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), RequestLocal$.MODULE$.NoCaching());
                        return BoxedUnit.UNIT;
                    });
                } else {
                    throw new MatchError(x0$1);
                }
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", () -> this.abortTimedOutTransactions((Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> (Function1 & Serializable & scala.Serializable)error -> {
            this.onEndTransactionComplete(txnIdAndPidEpoch, error);
            return BoxedUnit.UNIT;
        }), (long)this.txnConfig.abortTimedOutTransactionsIntervalMs(), (long)this.txnConfig.abortTimedOutTransactionsIntervalMs());
        this.txnManager.startup(retrieveTransactionTopicPartitionCount, enableTransactionalIdExpiration);
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$2() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager().shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$4(Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$7(TransactionCoordinator $this, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.lastProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$2) {
        return x$2.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeTransactions$2(DescribeTransactionsResponseData.TransactionState transactionState$1, TopicPartition topicPartition) {
        DescribeTransactionsResponseData.TopicData topicData = transactionState$1.topics().find(topicPartition.topic());
        if (topicData == null) {
            topicData = new DescribeTransactionsResponseData.TopicData().setTopic(topicPartition.topic());
            transactionState$1.topics().add((ImplicitLinkedHashCollection.Element)topicData);
        }
        return topicData.partitions().add(Predef$.MODULE$.int2Integer(topicPartition.partition()));
    }

    public static final /* synthetic */ void $anonfun$endTransaction$12(TransactionCoordinator $this, String transactionalId$5, int coordinatorEpoch$6, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        if (None$.MODULE$.equals(x0$2)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$5).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            return;
        }
        if (x0$2 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$2).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                epochAndMetadata.transactionMetadata().hasFailedEpochFence_$eq(true);
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(166).append("The coordinator failed to write an epoch fence transition for producer ").append(transactionalId$5).append(" to the transaction log ").append("with error ").append(error$2).append(". The epoch was increased to ").append(newMetadata$2.producerEpoch()).append(" but not returned to the client").toString());
                return;
            }
        } else {
            throw new MatchError((Object)x0$2);
        }
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$5, int coordinatorEpoch$6, long producerId$3, short producerEpoch$3, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$5).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Left left;
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                            if (bl) {
                                left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else {
                                boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                if (bl2) {
                                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError(x0$1);
                }
                Left left2 = left;
                return left2;
            });
            if (preSendResult instanceof Left) {
                Errors err = (Errors)((Left)preSendResult).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)preSendResult).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)preSendResult);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            this.txnManager.getTransactionState(transactionalId$5).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$endTransaction$15(TransactionCoordinator $this, String transactionalId$5, int coordinatorEpoch$6, long producerId$3, short producerEpoch$3, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId$5).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Left left;
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                            if (bl) {
                                left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else {
                                boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                if (bl2) {
                                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError(x0$1);
                }
                Left left2 = left;
                return left2;
            });
            if (sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                Errors sendTxnMarkersCallback$1_err = (Errors)((Left)sendTxnMarkersCallback$1_preSendResult).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)sendTxnMarkersCallback$1_err);
                return;
            }
            if (sendTxnMarkersCallback$1_preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)sendTxnMarkersCallback$1_preSendResult).value()) != null) {
                TransactionMetadata sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                $this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, sendTxnMarkersCallback$1_txnMetadata, sendTxnMarkersCallback$1_newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)sendTxnMarkersCallback$1_preSendResult);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            $this.txnManager.getTransactionState(transactionalId$5).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$7(TransactionCoordinator $this, TransactionMetadata txnMetadata$8, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, TxnTransitMetadata txnTransitMetadata) {
        $this.endTransaction(txnMetadata$8.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)), RequestLocal$.MODULE$.NoCaching());
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            return;
        }
        if (x0$1 instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            ((Option)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                    return None$.MODULE$;
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), RequestLocal$.MODULE$.NoCaching());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$1(TransactionCoordinator $this, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            } else if (x0$1 instanceof Some) {
                TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                        return None$.MODULE$;
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                        return None$.MODULE$;
                    }
                    return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), RequestLocal$.MODULE$.NoCaching());
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return BoxedUnit.UNIT;
        });
    }

    public TransactionCoordinator(TransactionConfig txnConfig, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
        this.producerIdManager = (ProducerIdManager)createProducerIdManager.apply();
        this.logVerbosity = txnConfig.transactionLoggingVerbosity();
    }
}

