/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$All$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Off$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Sample$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r-sA\u0002$H\u0011\u00039UJ\u0002\u0004P\u000f\"\u0005q\t\u0015\u0005\u0006/\u0006!\t!\u0017\u0005\u00065\u0006!\ta\u0017\u0005\u00075\u0006!\ta!\u0004\t\ri\u000bA\u0011AB\u000e\u0011\u001d\u0019i#\u0001C\u0001\u0007_A\u0011ba\r\u0002#\u0003%\ta!\u000e\u0007\u000b=;\u0005aR/\t\u0011\u0011D!Q1A\u0005\u0002\u0015D\u0001\"\u001d\u0005\u0003\u0002\u0003\u0006IA\u001a\u0005\te\"\u0011\t\u0019!C\u0001g\"Aq\u000f\u0003BA\u0002\u0013\u0005\u0001\u0010\u0003\u0005\u007f\u0011\t\u0005\t\u0015)\u0003u\u0011!y\bB!a\u0001\n\u0003\u0019\bBCA\u0001\u0011\t\u0005\r\u0011\"\u0001\u0002\u0004!I\u0011q\u0001\u0005\u0003\u0002\u0003\u0006K\u0001\u001e\u0005\u000b\u0003\u0013A!\u00111A\u0005\u0002\u0005-\u0001BCA\n\u0011\t\u0005\r\u0011\"\u0001\u0002\u0016!Q\u0011\u0011\u0004\u0005\u0003\u0002\u0003\u0006K!!\u0004\t\u0015\u0005m\u0001B!a\u0001\n\u0003\tY\u0001\u0003\u0006\u0002\u001e!\u0011\t\u0019!C\u0001\u0003?A!\"a\t\t\u0005\u0003\u0005\u000b\u0015BA\u0007\u0011)\t)\u0003\u0003BA\u0002\u0013\u0005\u0011q\u0005\u0005\u000b\u0003_A!\u00111A\u0005\u0002\u0005E\u0002BCA\u001b\u0011\t\u0005\t\u0015)\u0003\u0002*!Q\u0011q\u0007\u0005\u0003\u0002\u0004%\t!!\u000f\t\u0015\u0005\u0005\u0003B!a\u0001\n\u0003\t\u0019\u0005\u0003\u0006\u0002H!\u0011\t\u0011)Q\u0005\u0003wA!\"!\u0015\t\u0005\u000b\u0007I\u0011AA*\u0011)\tY\b\u0003B\u0001B\u0003%\u0011Q\u000b\u0005\n\u0003{B!\u00111A\u0005\u0002MD!\"a \t\u0005\u0003\u0007I\u0011AAA\u0011%\t)\t\u0003B\u0001B\u0003&A\u000fC\u0005\u0002\n\"\u0011\t\u0019!C\u0001g\"Q\u00111\u0012\u0005\u0003\u0002\u0004%\t!!$\t\u0013\u0005E\u0005B!A!B\u0013!\bBB,\t\t\u0003\t)\nC\u0005\u0002,\"\u0001\r\u0011\"\u0001\u0002.\"I\u0011Q\u0017\u0005A\u0002\u0013\u0005\u0011q\u0017\u0005\t\u0003wC\u0001\u0015)\u0003\u00020\"I\u0011q\u0018\u0005A\u0002\u0013\u0005\u0011\u0011\u0019\u0005\n\u0003\u0013D\u0001\u0019!C\u0001\u0003\u0017D\u0001\"a4\tA\u0003&\u00111\u0019\u0005\u000b\u0003#D!\u0019!C\u0001\u000f\u0006M\u0007\u0002CAw\u0011\u0001\u0006I!!6\t\u000f\u0005=\b\u0002\"\u0001\u0002r\"9!Q\u0003\u0005\u0005\u0002\t]\u0001b\u0002B\u0012\u0011\u0011\u0005!Q\u0005\u0005\b\u0005WAA\u0011\u0001B\u0017\u0011\u001d\u0011)\u0004\u0003C\u0001\u0005[AqAa\u000e\t\t\u0003\u0011I\u0004C\u0004\u0003h!!\tA!\u001b\t\u000f\t]\u0004\u0002\"\u0001\u0003z!9!1\u0012\u0005\u0005\u0002\t5\u0005b\u0002BK\u0011\u0011\u0005!q\u0013\u0005\b\u00057CA\u0011\u0001B\u0017\u0011\u001d\u0011i\n\u0003C\u0001\u0003\u0003DqAa(\t\t\u0013\t\t\rC\u0004\u0003\"\"!IAa)\t\u000f\tu\u0006\u0002\"\u0001\u0003@\"9!Q\u0019\u0005\u0005\n\t\u001d\u0007b\u0002Bf\u0011\u0011%!Q\u001a\u0005\b\u0005#DA\u0011\u0002Bj\u0011\u001d\u0011I\u000e\u0003C\u0001\u0003\u0003DqAa7\t\t\u0013\t\t\rC\u0004\u0003^\"!\tAa8\t\u000f\tu\u0007\u0002\"\u0011\u0003l\"9!Q\u001e\u0005\u0005B\t=\bb\u0002B{\u0011\u0011\u0005#q_\u0001\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0006\u0003\u0011&\u000b1\u0002\u001e:b]N\f7\r^5p]*\u0011!jS\u0001\fG>|'\u000fZ5oCR|'OC\u0001M\u0003\u0015Y\u0017MZ6b!\tq\u0015!D\u0001H\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b'\t\t\u0011\u000b\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16K\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tQ*A\u0003baBd\u0017\u0010F\u0006]\u0007\u0003\u0019\u0019a!\u0002\u0004\b\r%\u0001C\u0001(\t'\rA\u0011K\u0018\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C.\u000bQ!\u001e;jYNL!a\u00191\u0003\u000f1{wmZ5oO\u0006yAO]1og\u0006\u001cG/[8oC2LE-F\u0001g!\t9gN\u0004\u0002iYB\u0011\u0011nU\u0007\u0002U*\u00111\u000eW\u0001\u0007yI|w\u000e\u001e \n\u00055\u001c\u0016A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\*\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0004\u0013A\u00039s_\u0012,8-\u001a:JIV\tA\u000f\u0005\u0002Sk&\u0011ao\u0015\u0002\u0005\u0019>tw-\u0001\bqe>$WoY3s\u0013\u0012|F%Z9\u0015\u0005ed\bC\u0001*{\u0013\tY8K\u0001\u0003V]&$\bbB?\r\u0003\u0003\u0005\r\u0001^\u0001\u0004q\u0012\n\u0014a\u00039s_\u0012,8-\u001a:JI\u0002\na\u0002\\1tiB\u0013x\u000eZ;dKJLE-\u0001\nmCN$\bK]8ek\u000e,'/\u00133`I\u0015\fHcA=\u0002\u0006!9QpDA\u0001\u0002\u0004!\u0018a\u00047bgR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i+\t\ti\u0001E\u0002S\u0003\u001fI1!!\u0005T\u0005\u0015\u0019\u0006n\u001c:u\u0003E\u0001(o\u001c3vG\u0016\u0014X\t]8dQ~#S-\u001d\u000b\u0004s\u0006]\u0001\u0002C?\u0013\u0003\u0003\u0005\r!!\u0004\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA\u0005\tB.Y:u!J|G-^2fe\u0016\u0003xn\u00195\u0002+1\f7\u000f\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007n\u0018\u0013fcR\u0019\u00110!\t\t\u0011u,\u0012\u0011!a\u0001\u0003\u001b\t!\u0003\\1tiB\u0013x\u000eZ;dKJ,\u0005o\\2iA\u0005aA\u000f\u001f8US6,w.\u001e;NgV\u0011\u0011\u0011\u0006\t\u0004%\u0006-\u0012bAA\u0017'\n\u0019\u0011J\u001c;\u0002!QDh\u000eV5nK>,H/T:`I\u0015\fHcA=\u00024!AQ\u0010GA\u0001\u0002\u0004\tI#A\u0007uq:$\u0016.\\3pkRl5\u000fI\u0001\u0006gR\fG/Z\u000b\u0003\u0003w\u00012ATA\u001f\u0013\r\tyd\u0012\u0002\u0011)J\fgn]1di&|gn\u0015;bi\u0016\f\u0011b\u001d;bi\u0016|F%Z9\u0015\u0007e\f)\u0005\u0003\u0005~7\u0005\u0005\t\u0019AA\u001e\u0003\u0019\u0019H/\u0019;fA!\u001aA$a\u0013\u0011\u0007I\u000bi%C\u0002\u0002PM\u0013\u0001B^8mCRLG.Z\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogV\u0011\u0011Q\u000b\t\u0007\u0003/\n\t'!\u001a\u000e\u0005\u0005e#\u0002BA.\u0003;\nq!\\;uC\ndWMC\u0002\u0002`M\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019'!\u0017\u0003\u0007M+G\u000f\u0005\u0003\u0002h\u0005]TBAA5\u0015\u0011\tY'!\u001c\u0002\r\r|W.\\8o\u0015\ra\u0015q\u000e\u0006\u0005\u0003c\n\u0019(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003k\n1a\u001c:h\u0013\u0011\tI(!\u001b\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\u0012ibt7\u000b^1siRKW.Z:uC6\u0004\u0018!\u0006;y]N#\u0018M\u001d;US6,7\u000f^1na~#S-\u001d\u000b\u0004s\u0006\r\u0005bB?!\u0003\u0003\u0005\r\u0001^\u0001\u0013ibt7\u000b^1siRKW.Z:uC6\u0004\b\u0005K\u0002\"\u0003\u0017\na\u0003\u001e=o\u0019\u0006\u001cH/\u00169eCR,G+[7fgR\fW\u000e]\u0001\u001bibtG*Y:u+B$\u0017\r^3US6,7\u000f^1na~#S-\u001d\u000b\u0004s\u0006=\u0005bB?$\u0003\u0003\u0005\r\u0001^\u0001\u0018ibtG*Y:u+B$\u0017\r^3US6,7\u000f^1na\u0002B3\u0001JA&)Ua\u0016qSAM\u00037\u000bi*a(\u0002\"\u0006\r\u0016QUAT\u0003SCQ\u0001Z\u0013A\u0002\u0019DQA]\u0013A\u0002QDQa`\u0013A\u0002QDq!!\u0003&\u0001\u0004\ti\u0001C\u0004\u0002\u001c\u0015\u0002\r!!\u0004\t\u000f\u0005\u0015R\u00051\u0001\u0002*!9\u0011qG\u0013A\u0002\u0005m\u0002bBA)K\u0001\u0007\u0011Q\u000b\u0005\t\u0003{*\u0003\u0013!a\u0001i\"1\u0011\u0011R\u0013A\u0002Q\fA\u0002]3oI&twm\u0015;bi\u0016,\"!a,\u0011\u000bI\u000b\t,a\u000f\n\u0007\u0005M6K\u0001\u0004PaRLwN\\\u0001\u0011a\u0016tG-\u001b8h'R\fG/Z0%KF$2!_A]\u0011!ix%!AA\u0002\u0005=\u0016!\u00049f]\u0012LgnZ*uCR,\u0007\u0005K\u0002)\u0003\u0017\n1\u0003[1t\r\u0006LG.\u001a3Fa>\u001c\u0007NR3oG\u0016,\"!a1\u0011\u0007I\u000b)-C\u0002\u0002HN\u0013qAQ8pY\u0016\fg.A\fiCN4\u0015-\u001b7fI\u0016\u0003xn\u00195GK:\u001cWm\u0018\u0013fcR\u0019\u00110!4\t\u0011uT\u0013\u0011!a\u0001\u0003\u0007\fA\u0003[1t\r\u0006LG.\u001a3Fa>\u001c\u0007NR3oG\u0016\u0004\u0013\u0001\u00027pG.,\"!!6\u0011\t\u0005]\u0017\u0011^\u0007\u0003\u00033TA!a7\u0002^\u0006)An\\2lg*!\u0011q\\Aq\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003G\f)/\u0001\u0003vi&d'BAAt\u0003\u0011Q\u0017M^1\n\t\u0005-\u0018\u0011\u001c\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002\r%tGj\\2l+\u0011\t\u00190!?\u0015\t\u0005U(1\u0002\t\u0005\u0003o\fI\u0010\u0004\u0001\u0005\u000f\u0005mhF1\u0001\u0002~\n\tA+\u0005\u0003\u0002\u0000\n\u0015\u0001c\u0001*\u0003\u0002%\u0019!1A*\u0003\u000f9{G\u000f[5oOB\u0019!Ka\u0002\n\u0007\t%1KA\u0002B]fD\u0001B!\u0004/\t\u0003\u0007!qB\u0001\u0004MVt\u0007#\u0002*\u0003\u0012\u0005U\u0018b\u0001B\n'\nAAHY=oC6,g(A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004s\ne\u0001b\u0002B\u000e_\u0001\u0007!QD\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B\u0010\u0005C\t)'\u0004\u0002\u0002^%!\u00111MA/\u0003=\u0011X-\\8wKB\u000b'\u000f^5uS>tGcA=\u0003(!9!\u0011\u0006\u0019A\u0002\u0005\u0015\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0011aJ,\u0007/\u0019:f\u001d>$&/\u00198tSR$\"Aa\f\u0011\u00079\u0013\t$C\u0002\u00034\u001d\u0013!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\u0006I\u0002O]3qCJ,g)\u001a8dKB\u0013x\u000eZ;dKJ,\u0005o\\2i\u0003u\u0001(/\u001a9be\u0016Len\u0019:f[\u0016tG\u000f\u0015:pIV\u001cWM]#q_\u000eDG\u0003\u0003B\u001e\u00053\u0012iFa\u0019\u0011\u0011\tu\"q\tB'\u0005_qAAa\u0010\u0003D9\u0019\u0011N!\u0011\n\u0003QK1A!\u0012T\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0013\u0003L\t1Q)\u001b;iKJT1A!\u0012T!\u0011\u0011yE!\u0016\u000e\u0005\tE#\u0002\u0002B*\u0003S\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005/\u0012\tF\u0001\u0004FeJ|'o\u001d\u0005\b\u00057\u001a\u0004\u0019AA\u0015\u0003=qWm\u001e+y]RKW.Z8vi6\u001b\bb\u0002B0g\u0001\u0007!\u0011M\u0001\u0016Kb\u0004Xm\u0019;fIB\u0013x\u000eZ;dKJ,\u0005o\\2i!\u0015\u0011\u0016\u0011WA\u0007\u0011\u0019\u0011)g\ra\u0001i\u0006yQ\u000f\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007/A\rqe\u0016\u0004\u0018M]3Qe>$WoY3s\u0013\u0012\u0014v\u000e^1uS>tGC\u0003B\u0018\u0005W\u0012yG!\u001d\u0003t!1!Q\u000e\u001bA\u0002Q\fQB\\3x!J|G-^2fe&#\u0007b\u0002B.i\u0001\u0007\u0011\u0011\u0006\u0005\u0007\u0005K\"\u0004\u0019\u0001;\t\u000f\tUD\u00071\u0001\u0002D\u0006y!/Z2pe\u0012d\u0015m\u001d;Fa>\u001c\u0007.\u0001\u000bqe\u0016\u0004\u0018M]3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0005_\u0011YH!#\t\u000f\tuT\u00071\u0001\u0003\u0000\u0005!\u0012\r\u001a3fIR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004bA!!\u0003\b\u0006\u0015TB\u0001BB\u0015\u0011\u0011))!\u0018\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA2\u0005\u0007CaA!\u001a6\u0001\u0004!\u0018\u0001\u00069sKB\f'/Z!c_J$xJ]\"p[6LG\u000f\u0006\u0004\u00030\t=%1\u0013\u0005\b\u0005#3\u0004\u0019AA\u001e\u0003!qWm^*uCR,\u0007B\u0002B3m\u0001\u0007A/A\bqe\u0016\u0004\u0018M]3D_6\u0004H.\u001a;f)\u0011\u0011yC!'\t\r\t\u0015t\u00071\u0001u\u0003-\u0001(/\u001a9be\u0016$U-\u00193\u00021%\u001c\bK]8ek\u000e,'/\u00129pG\",\u0005\u0010[1vgR,G-A\u000biCN\u0004VM\u001c3j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8\u0002'A\u0014X\r]1sKR\u0013\u0018M\\:ji&|g\u000eV8\u0015%\t=\"Q\u0015BT\u0005S\u0013iK!-\u00034\n]&1\u0018\u0005\b\u0005#[\u0004\u0019AA\u001e\u0011\u0019\u0011ig\u000fa\u0001i\"9!1V\u001eA\u0002\u00055\u0011\u0001\u00038fo\u0016\u0003xn\u00195\t\u000f\t=6\b1\u0001\u0002\u000e\u0005aa.Z<MCN$X\t]8dQ\"9!1L\u001eA\u0002\u0005%\u0002b\u0002B[w\u0001\u0007!qP\u0001\u0013]\u0016<Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0003\u0004\u0003:n\u0002\r\u0001^\u0001\u0015]\u0016<H\u000b\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9\t\r\t\u00154\b1\u0001u\u0003Q\u0019w.\u001c9mKR,GK]1og&$\u0018n\u001c8U_R\u0019\u0011P!1\t\u000f\t\rG\b1\u0001\u00030\u0005yAO]1og&$X*\u001a;bI\u0006$\u0018-\u0001\nwC2LG\r\u0015:pIV\u001cWM]#q_\u000eDG\u0003BAb\u0005\u0013DqAa1>\u0001\u0004\u0011y#\u0001\fwC2LG\r\u0015:pIV\u001cWM]#q_\u000eD')^7q)\u0011\t\u0019Ma4\t\u000f\t\rg\b1\u0001\u00030\u0005YB\u000f\u001b:poN#\u0018\r^3Ue\u0006t7/\u001b;j_:4\u0015-\u001b7ve\u0016$2!\u001fBk\u0011\u001d\u00119n\u0010a\u0001\u0005_\t!\u0003\u001e=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\u0006Y\u0002/\u001a8eS:<GK]1og&$\u0018n\u001c8J]B\u0013xn\u001a:fgN\fq\"\u001b8dYV$Wm](gMN,Go]\u0001\ti>\u001cFO]5oOR\u0019aM!9\t\u000f\t\r(\t1\u0001\u0003f\u0006Ia/\u001a:c_NLG/\u001f\t\u0004\u001d\n\u001d\u0018b\u0001Bu\u000f\nYBK]1og\u0006\u001cG/[8o\u0019><w-\u001b8h-\u0016\u0014(m\\:jif$\u0012AZ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r'\u0011\u001f\u0005\b\u0005g$\u0005\u0019\u0001B\u0003\u0003\u0011!\b.\u0019;\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u000b)\u0007!\u0011Y\u0010E\u0002`\u0005{L1Aa@a\u00055qwN\u001c;ie\u0016\fGm]1gK\")Am\u0001a\u0001M\")!o\u0001a\u0001i\"9\u0011\u0011B\u0002A\u0002\u00055\u0001bBA\u0013\u0007\u0001\u0007\u0011\u0011\u0006\u0005\u0007\u0007\u0017\u0019\u0001\u0019\u0001;\u0002\u0013QLW.Z:uC6\u0004H#\u0004/\u0004\u0010\rE11CB\u000b\u0007/\u0019I\u0002C\u0003e\t\u0001\u0007a\rC\u0003s\t\u0001\u0007A\u000fC\u0004\u0002\n\u0011\u0001\r!!\u0004\t\u000f\u0005\u0015B\u00011\u0001\u0002*!9\u0011q\u0007\u0003A\u0002\u0005m\u0002BBB\u0006\t\u0001\u0007A\u000fF\t]\u0007;\u0019yb!\t\u0004$\r\u00152qEB\u0015\u0007WAQ\u0001Z\u0003A\u0002\u0019DQA]\u0003A\u0002QDQa`\u0003A\u0002QDq!!\u0003\u0006\u0001\u0004\ti\u0001C\u0004\u0002\u001c\u0015\u0001\r!!\u0004\t\u000f\u0005\u0015R\u00011\u0001\u0002*!9\u0011qG\u0003A\u0002\u0005m\u0002BBB\u0006\u000b\u0001\u0007A/\u0001\tjg\u0016\u0003xn\u00195Fq\"\fWo\u001d;fIR!\u00111YB\u0019\u0011\u001d\tIA\u0002a\u0001\u0003\u001b\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012JTCAB\u001cU\r!8\u0011H\u0016\u0003\u0007w\u0001Ba!\u0010\u0004H5\u00111q\b\u0006\u0005\u0007\u0003\u001a\u0019%A\u0005v]\u000eDWmY6fI*\u00191QI*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004J\r}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long lastProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private volatile TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private volatile Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$9() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
    }

    public static boolean isEpochExhausted(short s) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(s);
    }

    public static TransactionMetadata apply(String string, long l, long l2, short s, short s2, int n, TransactionState transactionState, long l3) {
        return TransactionMetadata$.MODULE$.apply(string, l, l2, s, s2, n, transactionState, l3);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, l2);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long lastProducerId() {
        return this.lastProducerId;
    }

    public void lastProducerId_$eq(long x$1) {
        this.lastProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null ? prepareAbort$ != null : !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new java.lang.StringBuilder(154).append("Transaction metadata's current state is ").append(this.state()).append(", and its pending state is ").append(this.pendingState()).append(" ").append("while trying to remove partitions whose txn marker has been sent, this is not expected").toString());
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.lastProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), bumpedEpoch, (short)-1, this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Left left;
        Tuple2 tuple2;
        Right right;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new java.lang.StringBuilder(56).append("Cannot allocate any more producer epochs for producerId ").append(this.producerId()).toString());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        if (None$.MODULE$.equals(expectedProducerEpoch)) {
            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)-1)));
        } else if (expectedProducerEpoch instanceof Some) {
            Right right2;
            short expectedEpoch = BoxesRunTime.unboxToShort((Object)((Some)expectedProducerEpoch).value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)this.producerEpoch()), (Object)BoxesRunTime.boxToShort((short)this.lastProducerEpoch())));
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(91).append("Expected producer epoch ").append(expectedEpoch).append(" does not match current ").append("producer epoch ").append(this.producerEpoch()).append(" or previous producer epoch ").append(this.lastProducerEpoch()).toString());
                right2 = package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
            }
            right = right2;
        } else {
            throw new MatchError(expectedProducerEpoch);
        }
        if (right instanceof Right && (tuple2 = (Tuple2)right.value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort((Object)tuple2._2());
            left = package$.MODULE$.Right().apply((Object)this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), nextEpoch, lastEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp));
        } else if (right instanceof Left) {
            Errors err = (Errors)((Left)right).value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)right);
        }
        return left;
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, recordLastEpoch ? (short)this.producerEpoch() : (short)-1, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), l, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Product newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        this.hasFailedEpochFence_$eq(false);
        return this.prepareTransitionTo((TransactionState)newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, short newLastEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new java.lang.StringBuilder(78).append("Preparing transaction state transition to ").append(newState).append(" ").append("while it already has pending state ").append(this.pendingState().get()).toString());
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(24).append("Illegal new producer id ").append(newProducerId).toString());
        }
        TransactionState transactionState = newState;
        Dead$ dead$ = Dead$.MODULE$;
        if ((transactionState == null ? dead$ != null : !transactionState.equals(dead$)) && newEpoch < 0) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(27).append("Illegal new producer epoch ").append(newEpoch).toString());
        }
        if (newState.validPreviousStates().contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, this.producerId(), newEpoch, newLastEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" prepare transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
            return transitMetadata;
        }
        throw new IllegalStateException(new java.lang.StringBuilder(125).append("Preparing transaction state transition to ").append(newState).append(" failed since the target state").append(" ").append(newState).append(" is not a valid previous state of the current state ").append(this.state()).toString());
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        TransactionState transactionState = toState = (TransactionState)this.pendingState().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(82).append(this).append("'s transition to ").append(transitMetadata).append(" failed since pendingState is not defined: this should not happen").toString());
            throw new IllegalStateException(new java.lang.StringBuilder(95).append("TransactionalId ").append(this.transactionalId()).append(" ").append("completing transaction state transition while it does not have a pending state").toString());
        });
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
            return;
        }
        if (Empty$.MODULE$.equals(toState)) {
            if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                this.producerEpoch_$eq(transitMetadata.producerEpoch());
                this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                this.producerId_$eq(transitMetadata.producerId());
                this.lastProducerId_$eq(transitMetadata.lastProducerId());
            }
        } else if (Ongoing$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
            }
        } else {
            boolean bl = PrepareAbort$.MODULE$.equals(toState) ? true : PrepareCommit$.MODULE$.equals(toState);
            if (bl) {
                if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(toState) ? true : CompleteCommit$.MODULE$.equals(toState);
                if (bl2) {
                    if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                        this.throwStateTransitionFailure(transitMetadata);
                    } else {
                        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                        this.topicPartitions().clear();
                    }
                } else if (PrepareEpochFence$.MODULE$.equals(toState)) {
                    this.throwStateTransitionFailure(transitMetadata);
                } else {
                    if (Dead$.MODULE$.equals(toState)) {
                        throw new IllegalStateException(new java.lang.StringBuilder(250).append("TransactionalId ").append(this.transactionalId()).append(" is trying to complete a transition to ").append(toState).append(". This means that the transactionalId was being expired, and the only acceptable completion of ").append("this operation is to remove the transaction metadata from the cache, not to persist the ").append(toState).append(" in the log.").toString());
                    }
                    throw new MatchError((Object)toState);
                }
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(46).append("TransactionalId ").append(this.transactionalId()).append(" complete transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(48).append(this.toString()).append("'s transition to ").append(txnTransitMetadata).append(" failed: this should not happen").toString());
        throw new IllegalStateException(new java.lang.StringBuilder(71).append("TransactionalId ").append(this.transactionalId()).append(" failed transition to state ").append(txnTransitMetadata).append(" ").append("due to unexpected metadata").toString());
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    private boolean includesOffsets() {
        return this.topicPartitions().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMetadata.$anonfun$includesOffsets$1(x$2)));
    }

    public String toString(TransactionLoggingVerbosity verbosity) {
        StringBuilder res = new StringBuilder("TransactionMetadata(");
        res.append("transactionalId=").append(this.transactionalId());
        res.append(", producerId").append(this.producerId());
        res.append(", producerEpoch=").append(this.producerEpoch());
        res.append(", txnTimeoutMs=").append(this.txnTimeoutMs());
        res.append(", state=").append((Object)this.state());
        res.append(", pendingState=").append(this.pendingState());
        res.append(", txnStartTimestamp=").append(this.txnStartTimestamp());
        res.append(", txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp());
        if (TransactionLoggingVerbosity$All$.MODULE$.equals(verbosity)) {
            res.append(", partitions=").append(TransactionMetadata.partitionsToString$1(this.topicPartitions()));
        } else if (TransactionLoggingVerbosity$Sample$.MODULE$.equals(verbosity)) {
            if (this.topicPartitions().size() > 20) {
                scala.collection.mutable.Set partitionsSample = (scala.collection.mutable.Set)this.topicPartitions().take(20);
                res.append(", samplePartitions=").append(TransactionMetadata.partitionsToString$1((Iterable)partitionsSample));
                res.append(", includesOffsets=").append(this.includesOffsets());
            } else {
                res.append(", partitions=").append(TransactionMetadata.partitionsToString$1(this.topicPartitions()));
            }
        } else if (TransactionLoggingVerbosity$Off$.MODULE$.equals(verbosity)) {
            res.append(", numPartitions=").append(this.topicPartitions().size());
            res.append(", includesOffsets=").append(this.includesOffsets());
        } else {
            throw new MatchError((Object)verbosity);
        }
        return res.append(")").toString();
    }

    public String toString() {
        return this.toString(TransactionLoggingVerbosity$Sample$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)that;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.lastProducerEpoch() != transactionMetadata.lastProducerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ boolean $anonfun$includesOffsets$1(TopicPartition x$2) {
        String string = x$2.topic();
        String string2 = "__consumer_offsets";
        return string != null && string.equals(string2);
    }

    private static final String partitionsToString$1(Iterable topicPartitions) {
        return topicPartitions.mkString("[", ",", "]");
    }

    public TransactionMetadata(String transactionalId, long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.lastProducerId = lastProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

