/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import kafka.Kafka$;
import kafka.cluster.Partition;
import kafka.durability.Utils;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.events.DurabilityEventType$;
import kafka.log.AbstractLog;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.tier.state.SegmentState;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public Option<Tuple4<Object, Object, Object, Set<Object>>> getLiveOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        None$ none$;
        Option<AbstractLog> log = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (log instanceof Some) {
            None$ none$2;
            AbstractLog l = (AbstractLog)((Some)log).value();
            Option<Set<Object>> option = this.getIsrIfLeaderPartition(replicaManager, topicPartition);
            if (option instanceof Some) {
                Set isr = (Set)((Some)option).value();
                none$2 = new Some((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)l.highWatermark()), (Object)BoxesRunTime.boxToLong((long)l.logStartOffset()), l.latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1), (Object)isr));
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else if (None$.MODULE$.equals(log)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(log);
        }
        return none$;
    }

    public Option<Set<Object>> getIsrIfLeaderPartition(ReplicaManager replicaManager, TopicPartition topicPartition) {
        None$ none$;
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            Partition partition = ((HostedPartition.Online)hostedPartition).partition();
            Object object = partition.leaderLogIfLocal() instanceof Some ? Option$.MODULE$.apply(partition.inSyncReplicaIds()) : None$.MODULE$;
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public int getLocalReplicaEpochIfLeader(ReplicaManager replicaManager, TopicPartition topicPartition) {
        int n;
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            Partition partition = ((HostedPartition.Online)hostedPartition).partition();
            int n2 = partition.leaderLogIfLocal() instanceof Some ? partition.getLeaderEpoch() : -1;
            n = n2;
        } else {
            n = -1;
        }
        return n;
    }

    public boolean getMirrorState(ReplicaManager replicaManager, TopicPartition topicPartition) {
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        boolean bl = hostedPartition instanceof HostedPartition.Online ? ((HostedPartition.Online)hostedPartition).partition().isActiveLinkDestinationLeader() : false;
        return bl;
    }

    public Option<Object> getLogEndOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        return replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset()));
    }

    public Option<Object> getLatestEpoch(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Option<Object> option2 = option instanceof Some ? ((AbstractLog)((Some)option).value()).latestEpoch() : None$.MODULE$;
        return option2;
    }

    public boolean isTieredLog(AbstractLog log) {
        return log.config().confluentLogConfig().tierEnable() && !log.config().compact() && !Topic.isInternal((String)log.topicPartition().topic());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Utils.MaxTimestampWithSize> getPreviousTierSegmentInfo(ReplicaManager replicaManager, TopicIdPartition topicIdPartition, long offset) {
        Object object;
        boolean bl = false;
        Some some = null;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicIdPartition.topicPartition(), replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            if (!this.isTieredLog(log)) {
                return None$.MODULE$;
            }
        }
        if (!bl) return None$.MODULE$;
        AbstractLog log = (AbstractLog)some.value();
        if (this.isValidTopicId(log.topicId(), topicIdPartition.topicId())) {
            Optional<SegmentState> state = log.tierPartitionState().previousMetadataBeforeOffset(offset);
            object = state.isPresent() ? new Some((Object)new Utils.MaxTimestampWithSize(state.get().maxTimestamp(), state.get().size())) : None$.MODULE$;
            return object;
        } else {
            Kafka$ kafka$ = Kafka$.MODULE$;
            if (kafka$ == null) {
                throw null;
            }
            Kafka$ warn_this = kafka$;
            if (warn_this.logger().underlying().isWarnEnabled()) {
                warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(Utils$.$anonfun$getPreviousTierSegmentInfo$1(topicIdPartition, log)));
            }
            object = None$.MODULE$;
        }
        return object;
    }

    public Option<Utils.MaxTimestampWithSize> getTierSegmentInfoForRange(ReplicaManager replicaManager, TopicPartition topicPartition, long start, long end) {
        Buffer states;
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Object object = option instanceof Some && this.isTieredLog(log = (AbstractLog)((Some)option).value()) ? ((states = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(log.tierPartitionState().segmentInMemoryMetadataRange(start, end)).asScala()).isEmpty() ? None$.MODULE$ : new Some((Object)new Utils.MaxTimestampWithSize(BoxesRunTime.unboxToLong((Object)((TraversableOnce)states.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.maxTimestamp()), Buffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)), BoxesRunTime.unboxToInt((Object)((TraversableOnce)states.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$))))) : None$.MODULE$;
        return object;
    }

    public Option<Object> getEstimatedLogRangeSize(ReplicaManager replicaManager, TopicIdPartition topicIdPartition, long startOffset) {
        None$ none$;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicIdPartition.topicPartition(), replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            None$ none$2;
            AbstractLog log = (AbstractLog)((Some)option).value();
            if (this.isValidTopicId(log.topicId(), topicIdPartition.topicId())) {
                None$ none$3;
                Option<Utils.MaxTimestampWithSize> option2 = this.getPreviousTierSegmentInfo(replicaManager, topicIdPartition, startOffset);
                AbstractLog log2 = log;
                Option<Utils.MaxTimestampWithSize> option3 = option2;
                if (option3 instanceof Some) {
                    Option<Utils.MaxTimestampWithSize> extraSize;
                    Option<Utils.MaxTimestampWithSize> gapSize;
                    Utils.MaxTimestampWithSize prev = (Utils.MaxTimestampWithSize)((Some)option3).value();
                    Object object = log2.logStartOffset() == startOffset ? new Some((Object)BoxesRunTime.boxToLong((long)(log2.size() + prev.size()))) : (log2.logStartOffset() > startOffset ? ((gapSize = this.getTierSegmentInfoForRange(replicaManager, topicIdPartition.topicPartition(), startOffset, log2.logStartOffset() - 1L)).isDefined() ? new Some((Object)BoxesRunTime.boxToLong((long)(log2.size() + prev.size() + ((Utils.MaxTimestampWithSize)gapSize.get()).size()))) : None$.MODULE$) : ((extraSize = this.getTierSegmentInfoForRange(replicaManager, topicIdPartition.topicPartition(), log2.logStartOffset(), startOffset - 1L)).isDefined() ? new Some((Object)BoxesRunTime.boxToLong((long)(log2.size() - ((Utils.MaxTimestampWithSize)extraSize.get()).size() + prev.size()))) : None$.MODULE$));
                    none$3 = object;
                } else {
                    none$3 = None$.MODULE$;
                }
                none$2 = none$3;
            } else {
                Kafka$ kafka$ = Kafka$.MODULE$;
                if (kafka$ == null) {
                    throw null;
                }
                Kafka$ warn_this = kafka$;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(Utils$.$anonfun$getEstimatedLogRangeSize$1(topicIdPartition, log)));
                }
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public int getBrokerId(ReplicaManager replicaManager) {
        return replicaManager.config().brokerId();
    }

    public Option<Object> getLocalLogRetentionSize(ReplicaManager replicaManager, TopicPartition topicPartition) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Object object = option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null ? new Some((Object)BoxesRunTime.boxToLong((long)log.config().retentionSize)) : None$.MODULE$;
        return object;
    }

    public Option<Object> getLocalLogRetentionMs(ReplicaManager replicaManager, TopicPartition topicPartition) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Object object = option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null ? new Some((Object)BoxesRunTime.boxToLong((long)log.config().retentionMs)) : None$.MODULE$;
        return object;
    }

    public Option<Object> getLocalStartOffsetForEpoch(ReplicaManager replicaManager, TopicPartition topicPartition, int epoch) {
        None$ none$;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            None$ none$2;
            Option<LeaderEpochFileCache> option2 = ((AbstractLog)((Some)option).value()).leaderEpochCache();
            if (option2 instanceof Some) {
                LeaderEpochFileCache cache = (LeaderEpochFileCache)((Some)option2).value();
                none$2 = new Some((Object)BoxesRunTime.boxToLong((long)cache.offsetForEpoch(epoch)));
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean isCompacted(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        boolean bl = option instanceof Some ? ((AbstractLog)((Some)option).value()).config().compact() : false;
        return bl;
    }

    public String consumerRecordMetadata(ConsumerRecord<byte[], byte[]> record) {
        Date date = new Date(record.timestamp());
        return new StringBuilder(34).append("Partition: ").append(record.partition()).append(", Offset: ").append(record.offset()).append(", Timestamp: ").append(date).toString();
    }

    public Set<Enumeration.Value> parseDurabilityEventCsvLists(String events) {
        return ((TraversableOnce)CoreUtils$.MODULE$.parseCsvList(events).flatMap((Function1 & Serializable & scala.Serializable)evt -> Option$.MODULE$.option2Iterable(DurabilityEventType$.MODULE$.withNameOpt((String)evt)), Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public Set<Enumeration.Value> parseDurabilityAuditsCsvLists(String audits) {
        return ((TraversableOnce)CoreUtils$.MODULE$.parseCsvList(audits).flatMap((Function1 & Serializable & scala.Serializable)evt -> Option$.MODULE$.option2Iterable(DurabilityAuditCheck$.MODULE$.withNameOpt((String)evt)), Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public int toPartition(TopicPartition topicPartition, int numPartitions) {
        return Math.abs(topicPartition.hashCode()) % numPartitions;
    }

    public int getDayOfYear(Time time) {
        return GregorianCalendar.from(Instant.ofEpochMilli(time.milliseconds()).atZone(ZoneOffset.UTC)).get(6);
    }

    private boolean isValidTopicId(Option<Uuid> currTopicId, Uuid oldTopicId) {
        block3: {
            block2: {
                if (currTopicId.isEmpty()) break block2;
                Object object = currTopicId.getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
                if (object != null ? !object.equals(oldTopicId) : oldTopicId != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$getPreviousTierSegmentInfo$1(TopicIdPartition topicIdPartition$1, AbstractLog log$1) {
        return new StringBuilder(205).append("Not returning prev tier segment info, since the topic has changed from topicId: ").append(topicIdPartition$1.topicId()).append(" ").append("to topicId: ").append(log$1.topicId()).append("This can happen if the topic has been recreated and Durability Audit is processing an event from the older topic").toString();
    }

    public static final /* synthetic */ String $anonfun$getEstimatedLogRangeSize$1(TopicIdPartition topicIdPartition$2, AbstractLog log$2) {
        return new StringBuilder(201).append("Not returning estimated log size, since the topic has changed from topicId: ").append(topicIdPartition$2.topicId()).append(" ").append("to topicId: ").append(log$2.topicId()).append("This can happen if the topic has been recreated and Durability Audit is processing an event from the older topic").toString();
    }

    private Utils$() {
        MODULE$ = this;
    }
}

