/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.Serializable;
import java.time.Instant;
import kafka.Kafka$;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityStats;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.OffsetCount;
import kafka.durability.audit.SegmentOffsetMap;
import kafka.durability.audit.SegmentRange;
import kafka.durability.audit.SegmentRange$;
import kafka.durability.materialization.DurabilityLapseType$;
import org.apache.kafka.common.TopicPartition;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001\u0002\u0013&\u00011B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006q\u0001!I!\u000f\u0005\b{\u0001\u0001\r\u0011\"\u0003?\u0011\u001d\u0011\u0005\u00011A\u0005\n\rCa!\u0013\u0001!B\u0013y\u0004b\u0002&\u0001\u0005\u0004%Ia\u0013\u0005\u0007E\u0002\u0001\u000b\u0011\u0002'\t\u000f\r\u0004!\u0019!C\u0005I\"1\u0001\u000e\u0001Q\u0001\n\u0015DQ!\u001b\u0001\u0005\u0002-CQA\u001b\u0001\u0005\u0002-DQA\u001c\u0001\u0005\u0002=D\u0011\"!\u0010\u0001#\u0003%\t!a\u0010\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u00111\f\u0001\u0005\u0002\u0005u\u0003\"CA6\u0001E\u0005I\u0011AA7\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!! \u0001\t\u0003\ty\bC\u0004\u0002\u0012\u0002!\t!a \t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!a-\u0001\t\u0003\t)\fC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005}\u0006\u0001\"\u0001\u0002B\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\t9\u000e\u0001C\u0001\u00033<q!a8&\u0011\u0003\t\tO\u0002\u0004%K!\u0005\u00111\u001d\u0005\u0007q\u0005\"\t!!:\t\u000f\u0005\u001d\u0018\u0005\"\u0001\u0002j\ni\u0011)\u001e3jiJ+\u0007o\u001c:uKJT!AJ\u0014\u0002\u000b\u0005,H-\u001b;\u000b\u0005!J\u0013A\u00033ve\u0006\u0014\u0017\u000e\\5us*\t!&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g-A\u0007nKR\u0014\u0018nY'b]\u0006<WM\u001d\t\u0003kYj\u0011aJ\u0005\u0003o\u001d\u0012\u0001\u0004R;sC\nLG.\u001b;z\u001b\u0016$(/[2t\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q\u0011!\b\u0010\t\u0003w\u0001i\u0011!\n\u0005\u0006g\t\u0001\r\u0001N\u0001\u0006U>\u0014\u0017\nZ\u000b\u0002\u007fA\u0011a\u0006Q\u0005\u0003\u0003>\u00121!\u00138u\u0003%QwNY%e?\u0012*\u0017\u000f\u0006\u0002E\u000fB\u0011a&R\u0005\u0003\r>\u0012A!\u00168ji\"9\u0001\nBA\u0001\u0002\u0004y\u0014a\u0001=%c\u00051!n\u001c2JI\u0002\n!b]2pe&tw-T1q+\u0005a\u0005\u0003B'S)~k\u0011A\u0014\u0006\u0003\u001fB\u000bq!\\;uC\ndWM\u0003\u0002R_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ms%a\u0002%bg\"l\u0015\r\u001d\t\u0003+vk\u0011A\u0016\u0006\u0003/b\u000baaY8n[>t'B\u0001\u0016Z\u0015\tQ6,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0006\u0019qN]4\n\u0005y3&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003w\u0001L!!Y\u0013\u0003\u0017=3gm]3u\u0007>,h\u000e^\u0001\fg\u000e|'/\u001b8h\u001b\u0006\u0004\b%\u0001\ttK\u001elWM\u001c;PM\u001a\u001cX\r^'baV\tQ\r\u0005\u0002<M&\u0011q-\n\u0002\u0011'\u0016<W.\u001a8u\u001f\u001a47/\u001a;NCB\f\u0011c]3h[\u0016tGo\u00144gg\u0016$X*\u00199!\u000359W\r^*d_JLgnZ'ba\u0006)r-\u001a;EkJ\f'-\u001b7jif\u001cu.\u001e8uKJ\u001cHCA0m\u0011\u0015i7\u00021\u0001U\u0003\tIG-A\u000bsKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3\u0015\u0017\u0011\u0003(o^=\u0002\u001c\u0005=\u0012\u0011\b\u0005\u0006c2\u0001\r\u0001V\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015\u0019H\u00021\u0001u\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\u0011\u00059*\u0018B\u0001<0\u0005\u0011auN\\4\t\u000bad\u0001\u0019\u0001;\u0002\u00131|7o]\"pk:$\b\"\u0002>\r\u0001\u0004Y\u0018!\u00037baN,G+\u001f9f!\ra\u0018Q\u0003\b\u0004{\u0006=ab\u0001@\u0002\f9\u0019q0!\u0003\u000f\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002,\u0003\u0019a$o\\8u}%\t!&\u0003\u0002)S%\u0019\u0011QB\u0014\u0002\u001f5\fG/\u001a:jC2L'0\u0019;j_:LA!!\u0005\u0002\u0014\u0005\u0019B)\u001e:bE&d\u0017\u000e^=MCB\u001cX\rV=qK*\u0019\u0011QB\u0014\n\t\u0005]\u0011\u0011\u0004\u0002\u0014\tV\u0014\u0018MY5mSRLH*\u00199tKRK\b/\u001a\u0006\u0005\u0003#\t\u0019\u0002C\u0004\u0002\u001e1\u0001\r!a\b\u0002\u00075\u001cx\r\u0005\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003K\u00012!!\u00010\u0013\r\t9cL\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001dr\u0006C\u0004\u000221\u0001\r!a\r\u0002\u000bM\u001cwN]3\u0011\u00079\n)$C\u0002\u00028=\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002<1\u0001\n\u00111\u0001\u00024\u0005y\u0011n](o\t\u0016l\u0017M\u001c3Bk\u0012LG/A\u0010sKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3%I\u00164\u0017-\u001e7uI]*\"!!\u0011+\t\u0005M\u00121I\u0016\u0003\u0003\u000b\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%A\u0005v]\u000eDWmY6fI*\u0019\u0011qJ\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002T\u0005%#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0019\"/Z:fiR{\u0007/[2QCJ$\u0018\u000e^5p]R\u0019A)!\u0017\t\u000bEt\u0001\u0019\u0001+\u0002+I,\u0007o\u001c:u\tV\u0014\u0018MY5mSRL\u0018)\u001e3jiRIA)a\u0018\u0002b\u0005\r\u0014q\r\u0005\u0006{=\u0001\ra\u0010\u0005\u0006c>\u0001\r\u0001\u0016\u0005\u0007\u0003Kz\u0001\u0019\u0001;\u0002\u0011Q|G/\u00197Ng\u001eD\u0001\"!\u001b\u0010!\u0003\u0005\r\u0001^\u0001\u000bi>$\u0018\r\u001c'baN,\u0017a\b:fa>\u0014H\u000fR;sC\nLG.\u001b;z\u0003V$\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u000e\u0016\u0004i\u0006\r\u0013!E;qI\u0006$X\rS3bYRD7\t[3dWR)A)!\u001e\u0002z!9\u0011qO\tA\u0002\u0005}\u0011!\u00032s_.,'o\u0015:d\u0011\u0019\tY(\u0005a\u0001i\u0006IA/[7f'R\fW\u000e]\u0001\u000egR\f'\u000f^!vI&$(j\u001c2\u0015\u0005\u0005\u0005\u0005\u0003BAB\u0003\u001bk!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\u0005i&lWM\u0003\u0002\u0002\f\u0006!!.\u0019<b\u0013\u0011\ty)!\"\u0003\u000f%s7\u000f^1oi\u000692\u000f^1si\u0006+H-\u001b;D_6\u0004\u0018m\u0019;j_:TuNY\u0001\u0013C\u0012$G+[3s\u0003V$\u0017\u000e^#se>\u00148\u000fF\u0002E\u0003/Ca!!'\u0015\u0001\u0004!\u0018!B2pk:$\u0018!H1eIRKWM]!vI&$XK\\6o_^tW\t_2faRLwN\\:\u0015\u0007\u0011\u000by\n\u0003\u0004\u0002\u001aV\u0001\r\u0001^\u0001\u001cC\u0012$G+[3s\u0003V$\u0017\u000e\u001e*fiJLX\t_2faRLwN\\:\u0015\u0007\u0011\u000b)\u000b\u0003\u0004\u0002\u001aZ\u0001\r\u0001^\u0001\u001dC\u0012$7i\\7qC\u000e$X\r\u001a)beRLG/[8o'.L\u0007\u000f]3e)\r!\u00151\u0016\u0005\u0007\u00033;\u0002\u0019\u0001;\u0002U\u0005$GmQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019,bY&$\u0017\r^5p]N[\u0017\u000e\u001d9fIR\u0019A)!-\t\r\u0005e\u0005\u00041\u0001u\u0003\t\nG\rZ\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:$\u0015\r^1WC2LG-\u0019;fIR\u0019A)a.\t\r\u0005e\u0015\u00041\u0001u\u0003Y\tG\r\u001a+jKJ\u001cVmZ7f]R\u001c\u0018)\u001e3ji\u0016$Gc\u0001#\u0002>\"1\u0011\u0011\u0014\u000eA\u0002Q\f\u0011$\u00193e\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|g.\u00133mKR\u0019A)a1\t\r\u0005e5\u00041\u0001u\u0003q\tG\rZ\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\fU\u000fZ5uK\u0012$2\u0001RAe\u0011\u0019\tI\n\ba\u0001i\u0006\tR\u000f\u001d3bi\u0016\fU\u000fZ5u\t\n\u001c\u0016N_3\u0015\u0007\u0011\u000by\r\u0003\u0004\u0002Rv\u0001\r\u0001^\u0001\u0005g&TX-A\tsKN,G/Q;eSRlU\r\u001e:jGN$\u0012\u0001R\u0001\te\u0016\u001cX\r\u001e&pER\u0019q(a7\t\r\u0005uw\u00041\u0001@\u0003!qWm\u001e&pE&#\u0017!D!vI&$(+\u001a9peR,'\u000f\u0005\u0002<CM\u0011\u0011%\f\u000b\u0003\u0003C\fQ!\u00199qYf$2AOAv\u0011\u0015\u00194\u00051\u00015\u0001")
public class AuditReporter {
    private final DurabilityMetricsManager metricManager;
    private int jobId;
    private final HashMap<TopicPartition, OffsetCount> scoringMap;
    private final SegmentOffsetMap segmentOffsetMap;

    public static AuditReporter apply(DurabilityMetricsManager durabilityMetricsManager) {
        return AuditReporter$.MODULE$.apply(durabilityMetricsManager);
    }

    private int jobId() {
        return this.jobId;
    }

    private void jobId_$eq(int x$1) {
        this.jobId = x$1;
    }

    private HashMap<TopicPartition, OffsetCount> scoringMap() {
        return this.scoringMap;
    }

    private SegmentOffsetMap segmentOffsetMap() {
        return this.segmentOffsetMap;
    }

    public HashMap<TopicPartition, OffsetCount> getScoringMap() {
        return this.scoringMap();
    }

    public OffsetCount getDurabilityCounters(TopicPartition id) {
        return (OffsetCount)this.scoringMap().getOrElse((Object)id, (Function0 & Serializable & scala.Serializable)() -> new OffsetCount(0L, 0L));
    }

    /*
     * WARNING - void declaration
     */
    public void reportDurabilityLapse(TopicPartition topicPartition, long startOffset, long lossCount, Enumeration.Value lapseType, String msg, boolean score, boolean isOnDemandAudit) {
        void var15_14;
        void var14_13;
        String customerFacing = score ? "Customer impacting" : "Non Customer impacting";
        String lapseMsg = new StringBuilder(13).append(customerFacing).append(" ").append(msg).append("\n").append("lapseType: ").append(lapseType).toString();
        Enumeration.Value value = lapseType;
        Enumeration.Value value2 = DurabilityLapseType$.MODULE$.ChecksumValidation();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            Kafka$ kafka$ = Kafka$.MODULE$;
            if (kafka$ == null) {
                throw null;
            }
            Kafka$ error_this = kafka$;
            if (error_this.logger().underlying().isErrorEnabled()) {
                error_this.logger().underlying().error(error_this.msgWithLogIdent(lapseMsg));
            }
            if (!isOnDemandAudit) {
                this.metricManager.reportDurabilityLoss(lapseType, lossCount);
            }
            return;
        }
        Tuple2<Object, Object> tuple2 = this.segmentOffsetMap().insert(topicPartition, new SegmentRange(startOffset, startOffset + lossCount - 1L, this.jobId(), SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean reportAlert = tuple2._1$mcZ$sp();
        boolean reportLapse = tuple2._2$mcZ$sp();
        if (var14_13 != false) {
            if (score) {
                Kafka$ kafka$ = Kafka$.MODULE$;
                if (kafka$ == null) {
                    throw null;
                }
                Kafka$ error_this = kafka$;
                if (error_this.logger().underlying().isErrorEnabled()) {
                    error_this.logger().underlying().error(error_this.msgWithLogIdent(lapseMsg));
                }
            } else {
                Kafka$ kafka$ = Kafka$.MODULE$;
                if (kafka$ == null) {
                    throw null;
                }
                Kafka$ warn_this = kafka$;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(lapseMsg));
                }
            }
            if (!isOnDemandAudit) {
                this.metricManager.reportDurabilityLoss(lapseType, lossCount);
            }
        }
        if (var15_14 != false) {
            if (var14_13 == false) {
                Kafka$ kafka$ = Kafka$.MODULE$;
                if (kafka$ == null) {
                    throw null;
                }
                Kafka$ warn_this = kafka$;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(AuditReporter.$anonfun$reportDurabilityLapse$4(lapseMsg)));
                }
            }
            if (score) {
                if (this.scoringMap().contains((Object)topicPartition)) {
                    OffsetCount offsetCount = (OffsetCount)this.scoringMap().apply((Object)topicPartition);
                    this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(offsetCount.total(), offsetCount.loss() + lossCount));
                    return;
                }
                this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(0L, lossCount));
                return;
            }
        }
    }

    public boolean reportDurabilityLapse$default$7() {
        return false;
    }

    public void resetTopicPartition(TopicPartition topicPartition) {
        if (this.scoringMap().contains((Object)topicPartition)) {
            this.scoringMap().remove((Object)topicPartition);
        }
        this.segmentOffsetMap().remove(topicPartition);
    }

    public void reportDurabilityAudit(int jobId, TopicPartition topicPartition, long totalMsg, long totalLapse) {
        long l;
        if (this.scoringMap().contains((Object)topicPartition)) {
            OffsetCount offsetCount = (OffsetCount)this.scoringMap().apply((Object)topicPartition);
            this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(totalMsg, offsetCount.loss() + totalLapse));
            l = offsetCount.loss() + totalLapse;
        } else {
            this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(totalMsg, totalLapse));
            l = totalLapse;
        }
        long l2 = l;
        this.metricManager.updateStats(topicPartition, new DurabilityStats(totalMsg, l2));
    }

    public long reportDurabilityAudit$default$4() {
        return 0L;
    }

    public void updateHealthCheck(String brokerSrc, long timeStamp) {
        this.metricManager.updateHealthCheck(brokerSrc, timeStamp);
    }

    public Instant startAuditJob() {
        return this.metricManager.startAuditJob();
    }

    public Instant startAuditCompactionJob() {
        return this.metricManager.startAuditCompactionJob();
    }

    public void addTierAuditErrors(long count) {
        this.metricManager.addTierAuditError(count);
    }

    public void addTierAuditUnknownExceptions(long count) {
        this.metricManager.addTierAuditUnknownExceptions(count);
    }

    public void addTierAuditRetryExceptions(long count) {
        this.metricManager.addTierAuditRetryExceptions(count);
    }

    public void addCompactedPartitionSkipped(long count) {
        this.metricManager.addCompactedPartitionSkipped(count);
    }

    public void addCompactedPartitionDataValidationSkipped(long count) {
        this.metricManager.addCompactedPartitionDataValidationSkipped(count);
    }

    public void addCompactedPartitionDataValidated(long count) {
        this.metricManager.addCompactedPartitionDataValidated(count);
    }

    public void addTierSegmentsAudited(long count) {
        this.metricManager.addTierSegmentsAudited(count);
    }

    public void addCompactedPartitionIdle(long count) {
        this.metricManager.addCompactedPartitionIdle(count);
    }

    public void addCompactedPartitionAudited(long count) {
        this.metricManager.addCompactedPartitionAudited(count);
    }

    public void updateAuditDbSize(long size) {
        this.metricManager.updateDurabilityAuditDbSize(size);
    }

    public void resetAuditMetrics() {
        this.metricManager.resetAuditMetrics();
    }

    /*
     * WARNING - void declaration
     */
    public int resetJob(int newJobId) {
        void var2_2;
        int old = this.jobId();
        this.jobId_$eq(newJobId);
        this.metricManager.resetDurabilityRunSpan(newJobId);
        this.scoringMap().clear();
        return (int)var2_2;
    }

    public static final /* synthetic */ String $anonfun$reportDurabilityLapse$4(String lapseMsg$1) {
        return new StringBuilder(10).append("Duplicate ").append(lapseMsg$1).toString();
    }

    public AuditReporter(DurabilityMetricsManager metricManager) {
        this.metricManager = metricManager;
        this.jobId = -1;
        this.scoringMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.segmentOffsetMap = new SegmentOffsetMap();
    }
}

