/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit.manager;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditJobSummary;
import kafka.durability.audit.AuditJobSummary$;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.job.BrokerAuditJob;
import kafka.durability.audit.job.BrokerAuditJob$;
import kafka.durability.audit.manager.AbstractAuditManager;
import kafka.durability.audit.manager.BrokerAuditManager$;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.audit.request.AuditManagerRequest;
import kafka.durability.audit.request.DeleteMessagesRequest;
import kafka.durability.audit.request.DeletePartitionRequest;
import kafka.durability.audit.request.EpochChangeRequest;
import kafka.durability.audit.request.HealthCheckRequest;
import kafka.durability.audit.request.HighWatermarkUpdateRequest;
import kafka.durability.audit.request.ISRExpandRequest;
import kafka.durability.audit.request.RegisterPartitionRequest;
import kafka.durability.audit.request.RetentionConfigChangeRequest;
import kafka.durability.audit.request.StartOffsetChangeRequest;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.HealthCheckEvent$;
import kafka.durability.events.broker.DeletePartitionEvent$;
import kafka.durability.events.broker.DeleteRecordsEvent$;
import kafka.durability.events.broker.EpochChangeEvent$;
import kafka.durability.events.broker.IsrExpandEvent$;
import kafka.durability.events.broker.OffsetChangeEvent$;
import kafka.durability.events.broker.RetentionChangeEvent$;
import kafka.durability.events.broker.StartOffsetChangeEvent$;
import kafka.durability.materialization.BrokerDurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.server.ReplicaManager;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t]b\u0001\u0002\u0017.\u0001YB\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0005\u0010\u0005\n\u0003\u0002\u0011\t\u0011)A\u0005{\tC\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000b\"AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005\\\u0001\t\u0015\r\u0011\"\u0011]\u0011%Q\u0007A!A!\u0002\u0013i6\u000eC\u0003m\u0001\u0011\u0005Q\u000e\u0003\u0005t\u0001\t\u0007I\u0011A\u0018u\u0011\u001d\t\u0019\u0002\u0001Q\u0001\nUD\u0011\"!\u0006\u0001\u0001\u0004%I!a\u0006\t\u0013\u0005}\u0001\u00011A\u0005\n\u0005\u0005\u0002\u0002CA\u0017\u0001\u0001\u0006K!!\u0007\t\u0013\u0005]\u0002\u00011A\u0005\u0002\u0005e\u0002\"CA!\u0001\u0001\u0007I\u0011AA\"\u0011!\t9\u0005\u0001Q!\n\u0005m\u0002\"CA%\u0001\t\u0007I\u0011IA&\u0011!\tI\u0006\u0001Q\u0001\n\u00055\u0003BCA.\u0001\t\u0007I\u0011I\u0018\u0002^!A\u00111\u000e\u0001!\u0002\u0013\ty\u0006C\u0004\u0002n\u0001!\t%a\u001c\t\u0011\u0005E\u0004\u0001\"\u00110\u0003gBq!!!\u0001\t\u0013\t\u0019\t\u0003\u0005\u0002\f\u0002!\taLAG\u0011)\tY\nAI\u0001\n\u0003y\u0013Q\u0014\u0005\u000b\u0003g\u0003\u0011\u0013!C\u0001_\u0005u\u0005BCA[\u0001E\u0005I\u0011A\u0018\u0002\u001e\"9\u0011q\u0017\u0001\u0005\n\u0005=\u0004\u0002CA]\u0001\u0011\u0005s&a/\t\u0015\u0005}\u0006!%A\u0005\u0002=\ni\nC\u0004\u0002B\u0002!I!a1\t\u0011\u0005=\u0007\u0001\"\u00010\u0003#Dq!!6\u0001\t\u0013\t9\u000eC\u0005\u0002l\u0002\t\n\u0011\"\u0003\u0002\u001e\"9\u0011Q\u001e\u0001\u0005\n\u0005=\b\u0002CA~\u0001\u0011\u0005q&!@\t\u0015\t%\u0001!%A\u0005\u0002=\ni\nC\u0004\u0003\f\u0001!IA!\u0004\t\u0011\t]\u0001\u0001\"\u00010\u0003_BqA!\u0007\u0001\t\u0003\u0011YbB\u0004\u0003$5B\tA!\n\u0007\r1j\u0003\u0012\u0001B\u0014\u0011\u0019a'\u0006\"\u0001\u00036\t\u0011\"I]8lKJ\fU\u000fZ5u\u001b\u0006t\u0017mZ3s\u0015\tqs&A\u0004nC:\fw-\u001a:\u000b\u0005A\n\u0014!B1vI&$(B\u0001\u001a4\u0003)!WO]1cS2LG/\u001f\u0006\u0002i\u0005)1.\u00194lC\u000e\u00011C\u0001\u00018!\tA\u0014(D\u0001.\u0013\tQTF\u0001\u000bBEN$(/Y2u\u0003V$\u0017\u000e^'b]\u0006<WM]\u0001\u0007G>tg-[4\u0016\u0003u\u0002\"AP \u000e\u0003=J!\u0001Q\u0018\u0003+\u0011+(/\u00192jY&$\u00180Q;eSR\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013BA\u001e:\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011N\naa]3sm\u0016\u0014\u0018B\u0001&H\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0013i&,'o\u00142kK\u000e$8\u000b^8sK>\u0003H\u000fE\u0002O#Nk\u0011a\u0014\u0006\u0002!\u0006)1oY1mC&\u0011!k\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016!B:u_J,'B\u0001-4\u0003\u0011!\u0018.\u001a:\n\u0005i+&a\u0004+jKJ|%M[3diN#xN]3\u0002\tQLW.Z\u000b\u0002;B\u0011a\f[\u0007\u0002?*\u0011\u0001-Y\u0001\u0006kRLGn\u001d\u0006\u0003E\u000e\faaY8n[>t'B\u0001\u001be\u0015\t)g-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0006\u0019qN]4\n\u0005%|&\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002J!aW\u001d\u0002\rqJg.\u001b;?)\u0015qw\u000e]9s!\tA\u0004\u0001C\u0003<\u0011\u0001\u0007Q\bC\u0003D\u0011\u0001\u0007Q\tC\u0003M\u0011\u0001\u0007Q\nC\u0003\\\u0011\u0001\u0007Q,A\u000eiS\u001eDw+\u0019;fe6\f'o[+qI\u0006$XMU3rk\u0016\u001cHo]\u000b\u0002kB)a/`@\u0002\b5\tqO\u0003\u0002ys\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005i\\\u0018\u0001B;uS2T\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fo\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\t\u0005\u0005\u00111A\u0007\u0002C&\u0019\u0011QA1\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e=\nqA]3rk\u0016\u001cH/\u0003\u0003\u0002\u0012\u0005-!A\u0007%jO\"<\u0016\r^3s[\u0006\u00148.\u00169eCR,'+Z9vKN$\u0018\u0001\b5jO\"<\u0016\r^3s[\u0006\u00148.\u00169eCR,'+Z9vKN$8\u000fI\u0001\u0013Y\u0006\u001cHOQ1uG\",e/\u001a8u)&lW-\u0006\u0002\u0002\u001aA\u0019a*a\u0007\n\u0007\u0005uqJ\u0001\u0003M_:<\u0017A\u00067bgR\u0014\u0015\r^2i\u000bZ,g\u000e\u001e+j[\u0016|F%Z9\u0015\t\u0005\r\u0012\u0011\u0006\t\u0004\u001d\u0006\u0015\u0012bAA\u0014\u001f\n!QK\\5u\u0011%\tY\u0003DA\u0001\u0002\u0004\tI\"A\u0002yIE\n1\u0003\\1ti\n\u000bGo\u00195Fm\u0016tG\u000fV5nK\u0002B3!DA\u0019!\rq\u00151G\u0005\u0004\u0003ky%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001f\u0005,H-\u001b;K_\n\u001cV/\\7bef,\"!a\u000f\u0011\u0007y\ni$C\u0002\u0002@=\u0012q\"Q;eSRTuNY*v[6\f'/_\u0001\u0014CV$\u0017\u000e\u001e&pEN+X.\\1ss~#S-\u001d\u000b\u0005\u0003G\t)\u0005C\u0005\u0002,=\t\t\u00111\u0001\u0002<\u0005\u0001\u0012-\u001e3ji*{'mU;n[\u0006\u0014\u0018\u0010I\u0001\f[\u0006$XM]5bY&TX-\u0006\u0002\u0002NA!\u0011qJA+\u001b\t\t\tFC\u0002\u0002TE\nq\"\\1uKJL\u0017\r\\5{CRLwN\\\u0005\u0005\u0003/\n\tFA\u0011Ce>\\WM\u001d#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;t\u001b\u0006$XM]5bY&TX-\u0001\u0007nCR,'/[1mSj,\u0007%\u0001\u0007u_BL7-T1oC\u001e,'/\u0006\u0002\u0002`A!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002fE\nQ\u0001^8qS\u000eLA!!\u001b\u0002d\t1B)\u001e:bE&d\u0017\u000e^=U_BL7-T1oC\u001e,'/A\u0007u_BL7-T1oC\u001e,'\u000fI\u0001\u0007I><vN]6\u0015\u0005\u0005\r\u0012AD2sK\u0006$X-Q;eSRTuN\u0019\u000b\u0003\u0003k\u0002B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003wz\u0013a\u00016pE&!\u0011qPA=\u00059\u0011%o\\6fe\u0006+H-\u001b;K_\n\fqc]3oI\u00163XM\u001c;CCR\u001c\u0007\u000eV5nK\u000eCWmY6\u0016\u0005\u0005\u0015\u0005c\u0001(\u0002\b&\u0019\u0011\u0011R(\u0003\u000f\t{w\u000e\\3b]\u0006aAm\\,pe.\f5\r^;bYRA\u00111EAH\u0003'\u000b9\nC\u0005\u0002\u0012b\u0001\n\u00111\u0001\u0002\u0006\u0006\u00012o\u00195fIVdW-Q;eSRTuN\u0019\u0005\n\u0003+C\u0002\u0013!a\u0001\u0003\u000b\u000b!B\u001a7vg\"\u0014\u0015\r^2i\u0011%\tI\n\u0007I\u0001\u0002\u0004\t))A\u0006vg\u0016dunY1m\u0019><\u0017A\u00063p/>\u00148.Q2uk\u0006dG\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}%\u0006BAC\u0003C[#!a)\u0011\t\u0005\u0015\u0016qV\u0007\u0003\u0003OSA!!+\u0002,\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[{\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011WAT\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017I><vN]6BGR,\u0018\r\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u00051Bm\\,pe.\f5\r^;bY\u0012\"WMZ1vYR$3'A\tqe>\u001cWm]:Fm\u0016tGOQ1uG\"\f\u0011C\u001a7vg\"\u0014VmY8sIN\fV/Z;f)\u0011\t\u0019#!0\t\u0013\u0005eU\u0004%AA\u0002\u0005\u0015\u0015a\u00074mkND'+Z2pe\u0012\u001c\u0018+^3vK\u0012\"WMZ1vYR$\u0013'A\u000bgKR\u001c\u0007.\u00129pG\"Le\rT3bI\u0016\u0014Hj\\4\u0015\t\u0005\u0015\u00171\u001a\t\u0004\u001d\u0006\u001d\u0017bAAe\u001f\n\u0019\u0011J\u001c;\t\r\u00055w\u00041\u0001\u0000\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0011#[:NSJ\u0014xN\u001d)beRLG/[8o)\u0011\t))a5\t\r\u00055\u0007\u00051\u0001\u0000\u00031I7OU3hSN$XM]3e)!\t))!7\u0002d\u0006\u001d\bbBAnC\u0001\u0007\u0011Q\\\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004B!!\u0001\u0002`&\u0019\u0011\u0011]1\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBAsC\u0001\u0007\u0011QY\u0001\u0006KB|7\r\u001b\u0005\n\u0003S\f\u0003\u0013!a\u0001\u0003\u000b\u000bQ\"[:Fa>\u001c\u0007n\u00115b]\u001e,\u0017AF5t%\u0016<\u0017n\u001d;fe\u0016$G\u0005Z3gCVdG\u000fJ\u001a\u00025%\u001c8\u000b^1mK\u0012+G.\u001a;f%\u0016\u001cwN\u001d3SKF,Xm\u001d;\u0015\t\u0005\u0015\u0015\u0011\u001f\u0005\b\u0003g\u001c\u0003\u0019AA{\u0003\u0019\u0011XmY8sIB!\u0011\u0011BA|\u0013\u0011\tI0a\u0003\u0003+\u0011+G.\u001a;f\u001b\u0016\u001c8/Y4fgJ+\u0017/^3ti\u0006I1/\u001a8e\u000bZ,g\u000e\u001e\u000b\u0007\u0003\u000b\u000byPa\u0002\t\u000f\u0005MH\u00051\u0001\u0003\u0002A!\u0011\u0011\u0002B\u0002\u0013\u0011\u0011)!a\u0003\u0003'\u0005+H-\u001b;NC:\fw-\u001a:SKF,Xm\u001d;\t\u0013\u0005eE\u0005%AA\u0002\u0005\u0015\u0015aE:f]\u0012,e/\u001a8uI\u0011,g-Y;mi\u0012\u0012\u0014!\u0005:fO&\u001cH/\u001a:QCJ$\u0018\u000e^5p]R!\u00111\u0005B\b\u0011\u001d\t\u0019P\na\u0001\u0005#\u0001B!!\u0003\u0003\u0014%!!QCA\u0006\u0005a\u0011VmZ5ti\u0016\u0014\b+\u0019:uSRLwN\u001c*fcV,7\u000f^\u0001\bG2,\u0017M\\;q\u0003=9W\r^)vKV,G-\u0012<f]R\u001cXC\u0001B\u000f!\u001dq%qDAc\u00033I1A!\tP\u0005\u0019!V\u000f\u001d7fe\u0005\u0011\"I]8lKJ\fU\u000fZ5u\u001b\u0006t\u0017mZ3s!\tA$fE\u0003+\u0005S\u0011y\u0003E\u0002O\u0005WI1A!\fP\u0005\u0019\te.\u001f*fMB\u0019\u0001H!\r\n\u0007\tMRFA\fCe>\\WM]!vI&$X*\u00198bO\u0016\u0014HK]1jiR\u0011!Q\u0005")
public class BrokerAuditManager
extends AbstractAuditManager {
    private final ReplicaManager replicaManager;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests;
    private volatile long lastBatchEventTime;
    private AuditJobSummary auditJobSummary;
    private final BrokerDurabilityEventsMaterialize materialize;
    private final DurabilityTopicManager topicManager;

    public static void submitAuditRequest(AuditManagerRequest auditManagerRequest) {
        BrokerAuditManager$.MODULE$.submitAuditRequest(auditManagerRequest);
    }

    public static boolean stopAuditManager$default$1() {
        return BrokerAuditManager$.MODULE$.stopAuditManager$default$1();
    }

    public static void stopAuditManager(boolean bl) {
        BrokerAuditManager$.MODULE$.stopAuditManager(bl);
    }

    public static Option<BrokerAuditManager> initialize(DurabilityAuditConfig durabilityAuditConfig, ReplicaManager replicaManager, Option<TierObjectStore> option, Time time) {
        return BrokerAuditManager$.MODULE$.initialize(durabilityAuditConfig, replicaManager, option, time);
    }

    public static ConcurrentHashMap<TopicIdPartition, RegisterPartitionRequest> pendingRegistration() {
        return BrokerAuditManager$.MODULE$.pendingRegistration();
    }

    public static void reconfigureConfigValues(String string, String string2, long l) {
        BrokerAuditManager$.MODULE$.reconfigureConfigValues(string, string2, l);
    }

    public static void startAuditManager() {
        BrokerAuditManager$.MODULE$.startAuditManager();
    }

    public static void instance_$eq(AbstractAuditManager abstractAuditManager) {
        BrokerAuditManager$.MODULE$.instance_$eq(abstractAuditManager);
    }

    public static AbstractAuditManager instance() {
        return BrokerAuditManager$.MODULE$.instance();
    }

    @Override
    public DurabilityAuditConfig config() {
        return super.config();
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public Time time() {
        return super.time();
    }

    public ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests() {
        return this.highWatermarkUpdateRequests;
    }

    private long lastBatchEventTime() {
        return this.lastBatchEventTime;
    }

    private void lastBatchEventTime_$eq(long x$1) {
        this.lastBatchEventTime = x$1;
    }

    public AuditJobSummary auditJobSummary() {
        return this.auditJobSummary;
    }

    public void auditJobSummary_$eq(AuditJobSummary x$1) {
        this.auditJobSummary = x$1;
    }

    @Override
    public BrokerDurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    @Override
    public DurabilityTopicManager topicManager() {
        return this.topicManager;
    }

    @Override
    public void doWork() {
        this.doWorkActual(true, this.doWorkActual$default$2(), this.doWorkActual$default$3());
        this.pause(DurabilityAuditConstants$.MODULE$.DURABILITY_JOB_LOOP_WAIT_MS(), TimeUnit.MILLISECONDS);
    }

    @Override
    public BrokerAuditJob createAuditJob() {
        return new BrokerAuditJob(this.db().getTopicPartitionsForAudit(), this.replicaManager().logManager(), this.auditJobCountdownLatch(), this.reporter(), this.auditJobSummary(), this.currentJobId(), this.tierObjectStoreOpt, this.time(), this.auditChecks(), this.auditConfig(), this.db(), (Option<ReplicaManager>)new Some((Object)this.replicaManager()), BrokerAuditJob$.MODULE$.$lessinit$greater$default$13(), BrokerAuditJob$.MODULE$.$lessinit$greater$default$14());
    }

    private boolean sendEventBatchTimeCheck() {
        long currentTimeMs = this.time().milliseconds();
        if (currentTimeMs - this.lastBatchEventTime() >= this.config().batchEventFlushFrequencyMs()) {
            this.lastBatchEventTime_$eq(currentTimeMs);
            return true;
        }
        return false;
    }

    public void doWorkActual(boolean scheduleAuditJob, boolean flushBatch, boolean useLocalLog) {
        if (scheduleAuditJob && this.shouldScheduleNewAuditJob() && this.config().auditChecks().contains((Object)DurabilityAuditCheck$.MODULE$.PeriodicalAudit())) {
            super.scheduleNewAuditJob();
        }
        if (this.sendEventHealthCheck()) {
            BrokerAuditManager$.MODULE$.submitAuditRequest(new HealthCheckRequest(this.healthCheckPartition(), -1, this.topicConfig().brokerId(), this.time().milliseconds()));
        }
        if (this.sendEventBatchTimeCheck() || flushBatch) {
            this.processEventBatch();
            this.db().checkpoint();
            return;
        }
        this.flushRecordsQueue(useLocalLog);
    }

    public boolean doWorkActual$default$1() {
        return false;
    }

    public boolean doWorkActual$default$2() {
        return false;
    }

    public boolean doWorkActual$default$3() {
        return true;
    }

    private void processEventBatch() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Process batchedRequest, auditRequest queue size is ").append(this.highWatermarkUpdateRequests().size()).toString());
        HashMap<TopicPartition, HighWatermarkUpdateRequest> snapshot = new HashMap<TopicPartition, HighWatermarkUpdateRequest>(this.highWatermarkUpdateRequests());
        AuditManagerRequest record = this.auditRequestsQueue().poll();
        for (int size = this.auditRequestsQueue().size(); size > 0 && record != null; --size) {
            if (this.sendEvent(record, this.sendEvent$default$2())) {
                snapshot.remove(record.topicIdPartition().topicPartition());
                this.highWatermarkUpdateRequests().remove(record.topicIdPartition().topicPartition());
            }
            record = this.auditRequestsQueue().poll();
        }
        snapshot.forEach((x0$1, x1$1) -> {
            TopicPartition topicPartition = x0$1;
            HighWatermarkUpdateRequest record = x1$1;
            if (this.isRegistered(record.topicIdPartition(), record.epoch(), this.isRegistered$default$3())) {
                this.topicManager().addDurabilityEvent(OffsetChangeEvent$.MODULE$.apply(record.topicIdPartition(), record.epoch(), record.hwm(), record.startOffset(), record.isr(), this.config().nodeId()));
            }
            this.highWatermarkUpdateRequests().remove(topicPartition);
        });
        snapshot.clear();
    }

    @Override
    public void flushRecordsQueue(boolean useLocalLog) {
        int count = 0;
        ObjectRef record = ObjectRef.create((Object)this.auditRequestsQueue().poll());
        while ((AuditManagerRequest)record.elem != null) {
            AuditManagerRequest auditManagerRequest = (AuditManagerRequest)record.elem;
            if (auditManagerRequest != null) {
                this.sendEvent(auditManagerRequest, useLocalLog);
            } else {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Unknown request ").append((AuditManagerRequest)record$1.elem).toString());
            }
            if (++count >= DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP()) {
                return;
            }
            record.elem = this.auditRequestsQueue().poll();
        }
    }

    @Override
    public boolean flushRecordsQueue$default$1() {
        return true;
    }

    private int fetchEpochIfLeaderLog(TopicPartition topicPartition) {
        return Utils$.MODULE$.getLocalReplicaEpochIfLeader(this.replicaManager(), topicPartition);
    }

    public boolean isMirrorPartition(TopicPartition topicPartition) {
        return Utils$.MODULE$.getMirrorState(this.replicaManager(), topicPartition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRegistered(TopicIdPartition topicIdPartition, int epoch, boolean isEpochChange) {
        int localEpoch;
        PartitionState state;
        boolean bl = false;
        Some some = null;
        Option<PartitionState> option = this.db().fetchPartitionState(topicIdPartition.topicPartition());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (((PartitionState)some.value()).isMirror()) {
                return false;
            }
        }
        if (bl && (state = (PartitionState)some.value()).isLeader()) {
            if (state.latestLocalEpoch() == epoch) return true;
            if (isEpochChange && epoch == -1) {
                return true;
            }
        }
        if ((localEpoch = this.fetchEpochIfLeaderLog(topicIdPartition.topicPartition())) == -1) return false;
        if (localEpoch > epoch) return false;
        if (epoch == -1) {
            return false;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Durability registration for ").append(topicIdPartition).append(" was found missing, recovering for epoch ").append(epoch).append(" ").append("localEpoch ").append(localEpoch).toString());
        this.registerPartition(new RegisterPartitionRequest(topicIdPartition, localEpoch, true));
        if (this.isMirrorPartition(topicIdPartition.topicPartition())) return false;
        return true;
    }

    private boolean isRegistered$default$3() {
        return false;
    }

    private boolean isStaleDeleteRecordRequest(DeleteMessagesRequest record) {
        Option<PartitionState> option = this.db().fetchPartitionState(record.topicIdPartition().topicPartition());
        boolean bl = !(option instanceof Some) || ((PartitionState)((Some)option).value()).committedStartOffset() >= record.trimOffset();
        return bl;
    }

    public boolean sendEvent(AuditManagerRequest record, boolean useLocalLog) {
        boolean bl;
        DeletePartitionRequest deletePartitionRequest;
        DeleteMessagesRequest deleteMessagesRequest;
        ISRExpandRequest iSRExpandRequest;
        RetentionConfigChangeRequest retentionConfigChangeRequest;
        EpochChangeRequest epochChangeRequest;
        StartOffsetChangeRequest startOffsetChangeRequest;
        None$ none$;
        if (record instanceof RegisterPartitionRequest) {
            RegisterPartitionRequest registerPartitionRequest = (RegisterPartitionRequest)record;
            this.registerPartition(registerPartitionRequest);
            this.highWatermarkUpdateRequests().remove(registerPartitionRequest.topicIdPartition().topicPartition());
            none$ = None$.MODULE$;
        } else if (record instanceof StartOffsetChangeRequest && this.isRegistered((startOffsetChangeRequest = (StartOffsetChangeRequest)record).topicIdPartition(), startOffsetChangeRequest.epoch(), this.isRegistered$default$3())) {
            Object object;
            Option<Set<Object>> option = Utils$.MODULE$.getIsrIfLeaderPartition(this.replicaManager(), startOffsetChangeRequest.topicIdPartition().topicPartition());
            if (option instanceof Some) {
                Set isr = (Set)((Some)option).value();
                object = new Some((Object)StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicIdPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), (Set<Object>)isr, this.config().nodeId()));
            } else {
                object = !useLocalLog ? new Some((Object)StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicIdPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), this.config().nodeId())) : None$.MODULE$;
            }
            none$ = object;
        } else if (record instanceof EpochChangeRequest && this.isRegistered((epochChangeRequest = (EpochChangeRequest)record).topicIdPartition(), -1, true)) {
            none$ = new Some((Object)EpochChangeEvent$.MODULE$.apply(epochChangeRequest.topicIdPartition(), epochChangeRequest.firstOffset(), epochChangeRequest.epoch(), epochChangeRequest.highWaterMark(), epochChangeRequest.startOffset(), epochChangeRequest.isr(), this.config().nodeId()));
        } else if (record instanceof RetentionConfigChangeRequest && this.isRegistered((retentionConfigChangeRequest = (RetentionConfigChangeRequest)record).topicIdPartition(), retentionConfigChangeRequest.epoch(), this.isRegistered$default$3())) {
            none$ = new Some((Object)RetentionChangeEvent$.MODULE$.apply(retentionConfigChangeRequest.topicIdPartition(), retentionConfigChangeRequest.retentionMs(), retentionConfigChangeRequest.retentionSz(), retentionConfigChangeRequest.epoch(), -1L, -1L, this.config().nodeId(), retentionConfigChangeRequest.isCompacted()));
        } else if (record instanceof ISRExpandRequest && this.isRegistered((iSRExpandRequest = (ISRExpandRequest)record).topicIdPartition(), iSRExpandRequest.epoch(), this.isRegistered$default$3())) {
            none$ = new Some((Object)IsrExpandEvent$.MODULE$.apply(iSRExpandRequest.topicIdPartition(), iSRExpandRequest.brokerId(), iSRExpandRequest.epoch(), -1L, -1L, this.config().nodeId()));
        } else if (record instanceof DeleteMessagesRequest && this.isRegistered((deleteMessagesRequest = (DeleteMessagesRequest)record).topicIdPartition(), deleteMessagesRequest.epoch(), this.isRegistered$default$3()) && !this.isStaleDeleteRecordRequest(deleteMessagesRequest)) {
            none$ = new Some((Object)DeleteRecordsEvent$.MODULE$.apply(deleteMessagesRequest.topicIdPartition(), deleteMessagesRequest.trimOffset(), deleteMessagesRequest.epoch(), deleteMessagesRequest.highWatermark(), deleteMessagesRequest.startOffset(), deleteMessagesRequest.isr(), this.config().nodeId()));
        } else if (record instanceof DeletePartitionRequest && this.isRegistered((deletePartitionRequest = (DeletePartitionRequest)record).topicIdPartition(), deletePartitionRequest.epoch(), this.isRegistered$default$3())) {
            none$ = new Some((Object)DeletePartitionEvent$.MODULE$.apply(deletePartitionRequest.topicIdPartition(), deletePartitionRequest.epoch(), this.config().nodeId()));
        } else if (record instanceof HealthCheckRequest) {
            HealthCheckRequest healthCheckRequest = (HealthCheckRequest)record;
            none$ = new Some((Object)HealthCheckEvent$.MODULE$.apply(healthCheckRequest.topicIdPartition(), healthCheckRequest.epoch(), -1L, -1L, healthCheckRequest.nodeId(), healthCheckRequest.timeStamp()));
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Rejected record for sending as event ").append(record).append(", ignoring").toString());
            none$ = None$.MODULE$;
        }
        if (none$ instanceof Some) {
            AbstractDurabilityEvent e = (AbstractDurabilityEvent)((Some)none$).value();
            this.topicManager().addDurabilityEvent(e);
            this.highWatermarkUpdateRequests().remove(record.topicIdPartition().topicPartition());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean sendEvent$default$2() {
        return true;
    }

    private void registerPartition(RegisterPartitionRequest record) {
        Option<PartitionState> option = this.db().fetchPartitionState(record.topicIdPartition().topicPartition());
        if (option instanceof Some) {
            PartitionState state = (PartitionState)((Some)option).value();
            if (state.latestLocalEpoch() >= record.epoch()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("Durability Registration event from stale/registered replica for ").append(record.topicIdPartition()).append(" for ").append(record.epoch()).append(" with leader flag set to ").append(record.isLeader()).append(". The existing db state is ").append(state).toString());
                return;
            }
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        ObjectRef state = ObjectRef.create((Object)((PartitionState)this.db().fetchPartitionState(record.topicIdPartition().topicPartition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> PartitionState$.MODULE$.apply(record.topicIdPartition().topicPartition().partition(), PartitionState$.MODULE$.apply$default$2()))));
        Uuid uuid = ((PartitionState)state.elem).topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            Uuid uuid3 = record.topicIdPartition().topicId();
            Uuid uuid4 = Uuid.ZERO_UUID;
            if (uuid3 == null ? uuid4 != null : !uuid3.equals(uuid4)) {
                Uuid uuid5 = record.topicIdPartition().topicId();
                Uuid uuid6 = ((PartitionState)state.elem).topicId();
                if (uuid5 == null ? uuid6 != null : !uuid5.equals(uuid6)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Durability partition reset for ").append(record.topicIdPartition()).append(" old topicID ").append(((PartitionState)state$2.elem).topicId()).append(" due to change ").append("in topicId likely due to missing partition deletion").toString());
                    state.elem = PartitionState$.MODULE$.apply(record.topicIdPartition().topicPartition().partition(), ((PartitionState)state.elem).config());
                }
            }
        }
        ((PartitionState)state.elem).latestLocalEpoch_$eq(record.epoch());
        ((PartitionState)state.elem).isLeader_$eq(record.isLeader());
        ((PartitionState)state.elem).isMirror_$eq(this.isMirrorPartition(record.topicIdPartition().topicPartition()));
        ((PartitionState)state.elem).topicId_$eq(record.topicIdPartition().topicId());
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), record.topicIdPartition().topicPartition())) {
            ((PartitionState)state.elem).config_$eq(ConfigFlag$.MODULE$.OnceCompacted().id());
        }
        this.db().addPartition(record.topicIdPartition().topicPartition(), (PartitionState)state.elem);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Durability registration for ").append(record.topicIdPartition()).append(" epoch: ").append(record.epoch()).append(" ").append("isLeader: ").append(record.isLeader()).append(" isMirror: ").append(((PartitionState)state$2.elem).isMirror()).append(" is done.").toString());
    }

    public void cleanup() {
        try {
            Instant cleanupStart = Instant.ofEpochMilli(this.time().milliseconds());
            this.stopExistingAuditJob();
            this.processEventBatch();
            this.flushRecordsQueue(this.flushRecordsQueue$default$1());
            this.db().checkpoint();
            this.topicManager().shutdown();
            this.metricsManager().shutdown();
            long cleanupDuration = Duration.between(cleanupStart, Instant.ofEpochMilli(this.time().milliseconds())).toMillis();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("BrokerAuditManager cleanup complete in ").append(cleanupDuration).append(" ms").toString());
            return;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received error while cleaning up BrokerAuditManager", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public Tuple2<Object, Object> getQueuedEvents() {
        return new Tuple2.mcIJ.sp(this.auditRequestsQueue().size(), (long)this.highWatermarkUpdateRequests().size());
    }

    public BrokerAuditManager(DurabilityAuditConfig config, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, Time time) {
        this.replicaManager = replicaManager;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        super(config, time);
        this.highWatermarkUpdateRequests = new ConcurrentHashMap();
        this.lastBatchEventTime = time.milliseconds();
        this.auditJobSummary = AuditJobSummary$.MODULE$.apply();
        this.materialize = new BrokerDurabilityEventsMaterialize(replicaManager, this.db(), this.reporter(), time);
        this.topicManager = this.getTopicManager();
    }
}

