/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.Serializable;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.kraft.KRaftPartitionState;
import kafka.durability.db.kraft.KRaftPartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.broker.AbstractBrokerDurabilityEvent;
import kafka.durability.events.controller.kraft.AbstractKRaftDurabilityEvent;
import kafka.durability.events.controller.kraft.KRaftHWMChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLeaderChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLogSnapshotGenerationEvent;
import kafka.durability.events.controller.kraft.KRaftLogStartOffsetChangeEvent;
import kafka.durability.events.controller.kraft.KRaftNodeStartUpEvent;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.materialization.validation.ControllerValidator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001\u0002\t\u0012\u0001aA\u0001\"\b\u0001\u0003\u0006\u0004%\tE\b\u0005\nI\u0001\u0011\t\u0011)A\u0005?\u0015B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)1\b\u0001C\u0001y!A\u0011\t\u0001b\u0001\n\u0003\n\"\t\u0003\u0004J\u0001\u0001\u0006Ia\u0011\u0005\u0006\u0015\u0002!\te\u0013\u0005\u00063\u0002!\tE\u0017\u0005\u0006_\u0002!I\u0001\u001d\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\n)3i\u001c8ue>dG.\u001a:EkJ\f'-\u001b7jif,e/\u001a8ug6\u000bG/\u001a:jC2L'0\u001a\u0006\u0003%M\tq\"\\1uKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003)U\t!\u0002Z;sC\nLG.\u001b;z\u0015\u00051\u0012!B6bM.\f7\u0001A\n\u0003\u0001e\u0001\"AG\u000e\u000e\u0003EI!\u0001H\t\u0003G\u0005\u00137\u000f\u001e:bGR$UO]1cS2LG/_#wK:$8/T1uKJL\u0017\r\\5{K\u0006\u0011AMY\u000b\u0002?A\u0011\u0001EI\u0007\u0002C)\u0011QdE\u0005\u0003G\u0005\u0012A\u0002R;sC\nLG.\u001b;z\t\n\u000b1\u0001\u001a2!\u0013\ti2$\u0001\u0005sKB|'\u000f^3s!\tA3&D\u0001*\u0015\tQ3#A\u0003bk\u0012LG/\u0003\u0002-S\ti\u0011)\u001e3jiJ+\u0007o\u001c:uKJ\fA\u0001^5nKB\u0011q&O\u0007\u0002a)\u0011\u0011GM\u0001\u0006kRLGn\u001d\u0006\u0003gQ\naaY8n[>t'B\u0001\f6\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\n\u0005i\u0002$\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003B\u001f?\u007f\u0001\u0003\"A\u0007\u0001\t\u000bu)\u0001\u0019A\u0010\t\u000b\u0019*\u0001\u0019A\u0014\t\u000b5*\u0001\u0019\u0001\u0018\u0002\u0013Y\fG.\u001b3bi>\u0014X#A\"\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019\u000b\u0012A\u0003<bY&$\u0017\r^5p]&\u0011\u0001*\u0012\u0002\u0014\u0007>tGO]8mY\u0016\u0014h+\u00197jI\u0006$xN]\u0001\u000bm\u0006d\u0017\u000eZ1u_J\u0004\u0013A\u00037pO\u001e,'OT1nKV\tA\n\u0005\u0002N-:\u0011a\n\u0016\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#^\ta\u0001\u0010:p_Rt$\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013\u0016A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!\u0016*\u0002\u00175\fG/\u001a:jC2L'0\u001a\u000b\u00037~\u0003\"\u0001X/\u000e\u0003IK!A\u0018*\u0003\u000f\t{w\u000e\\3b]\")\u0001-\u0003a\u0001C\u00061!/Z2pe\u0012\u0004BAY4jS6\t1M\u0003\u0002eK\u0006A1m\u001c8tk6,'O\u0003\u0002gi\u000591\r\\5f]R\u001c\u0018B\u00015d\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u00042\u0001\u00186m\u0013\tY'KA\u0003BeJ\f\u0017\u0010\u0005\u0002][&\u0011aN\u0015\u0002\u0005\u0005f$X-A\u0011nCR,'/[1mSj,7JU1gi2+\u0017\rZ3s\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\u0007ri\u0006\u0005\u0011qBA\n\u0003/\tY\u0002\u0005\u0002]e&\u00111O\u0015\u0002\u0005+:LG\u000fC\u0003v\u0015\u0001\u0007a/A\tmK\u0006$WM]\"iC:<W-\u0012<f]R\u0004\"a\u001e@\u000e\u0003aT!!\u001f>\u0002\u000b-\u0014\u0018M\u001a;\u000b\u0005md\u0018AC2p]R\u0014x\u000e\u001c7fe*\u0011QpE\u0001\u0007KZ,g\u000e^:\n\u0005}D(AF&SC\u001a$H*Z1eKJ\u001c\u0005.\u00198hK\u00163XM\u001c;\t\u000f\u0005\r!\u00021\u0001\u0002\u0006\u000592NU1giB\u000b'\u000f^5uS>t7\u000b^1uK&sGI\u0011\t\u0005\u0003\u000f\tY!\u0004\u0002\u0002\n)\u0011\u00110I\u0005\u0005\u0003\u001b\tIAA\nL%\u00064G\u000fU1si&$\u0018n\u001c8Ti\u0006$X\r\u0003\u0004\u0002\u0012)\u0001\raW\u0001\u0013KZ,g\u000e\u001e$s_6dunY1m\u001d>$W\r\u0003\u0004\u0002\u0016)\u0001\raW\u0001\u0017SN4%o\\7N_N$(+Z2f]RdU-\u00193fe\"1\u0011\u0011\u0004\u0006A\u00021\u000b\u0001\"\\3uC\u0012\fG/\u0019\u0005\u0007\u0003;Q\u0001\u0019A.\u0002\u000f%\u001c8\u000b^1mK\u0006qR.\u0019;fe&\fG.\u001b>f\u0017J\u000bg\r\u001e%X\u001b\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u000b\u000ec\u0006\r\u0012QFA\u0018\u0003c\t\u0019$!\u000e\t\u000f\u0005\u00152\u00021\u0001\u0002(\u0005q\u0001nV'DQ\u0006tw-Z#wK:$\bcA<\u0002*%\u0019\u00111\u0006=\u0003'-\u0013\u0016M\u001a;I/6\u001b\u0005.\u00198hK\u00163XM\u001c;\t\u000f\u0005\r1\u00021\u0001\u0002\u0006!1\u0011\u0011C\u0006A\u0002mCa!!\u0006\f\u0001\u0004Y\u0006BBA\r\u0017\u0001\u0007A\n\u0003\u0004\u0002\u001e-\u0001\raW\u0001*[\u0006$XM]5bY&TXm\u0013*bMRdunZ*uCJ$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\u001bE\fY$!\u0012\u0002H\u0005%\u00131JA'\u0011\u001d\ti\u0004\u0004a\u0001\u0003\u007f\t\u0011c\u001c4gg\u0016$8\t[1oO\u0016,e/\u001a8u!\r9\u0018\u0011I\u0005\u0004\u0003\u0007B(AH&SC\u001a$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u\u0011\u001d\t\u0019\u0001\u0004a\u0001\u0003\u000bAa!!\u0005\r\u0001\u0004Y\u0006BBA\u000b\u0019\u0001\u00071\f\u0003\u0004\u0002\u001a1\u0001\r\u0001\u0014\u0005\u0007\u0003;a\u0001\u0019A.\u0002U5\fG/\u001a:jC2L'0Z&SC\u001a$Hj\\4T]\u0006\u00048\u000f[8u\u000f\u0016tWM]1uS>tWI^3oiRi\u0011/a\u0015\u0002^\u0005}\u0013\u0011MA2\u0003KBq!!\u0016\u000e\u0001\u0004\t9&\u0001\tm_\u001e\u001cf.\u00199tQ>$XI^3oiB\u0019q/!\u0017\n\u0007\u0005m\u0003PA\u0010L%\u00064G\u000fT8h':\f\u0007o\u001d5pi\u001e+g.\u001a:bi&|g.\u0012<f]RDq!a\u0001\u000e\u0001\u0004\t)\u0001\u0003\u0004\u0002\u00125\u0001\ra\u0017\u0005\u0007\u0003+i\u0001\u0019A.\t\r\u0005eQ\u00021\u0001M\u0011\u0019\ti\"\u0004a\u00017\u0006\u0001S.\u0019;fe&\fG.\u001b>f\u0017J\u000bg\r\u001e(pI\u0016\u001cF/\u0019:u+B,e/\u001a8u)5\t\u00181NA;\u0003o\nI(a\u001f\u0002~!9\u0011Q\u000e\bA\u0002\u0005=\u0014\u0001\u00058pI\u0016\u001cF/\u0019:u+B,e/\u001a8u!\r9\u0018\u0011O\u0005\u0004\u0003gB(!F&SC\u001a$hj\u001c3f'R\f'\u000f^+q\u000bZ,g\u000e\u001e\u0005\b\u0003\u0007q\u0001\u0019AA\u0003\u0011\u0019\t\tB\u0004a\u00017\"1\u0011Q\u0003\bA\u0002mCa!!\u0007\u000f\u0001\u0004a\u0005BBA\u000f\u001d\u0001\u00071,A\u000ejg\u00163XM\u001c;Ge>lWj\\:u%\u0016\u001cWM\u001c;MK\u0006$WM\u001d\u000b\u00067\u0006\r\u0015Q\u0012\u0005\b\u0003\u000b{\u0001\u0019AAD\u0003\u0015)g/\u001a8u!\r9\u0018\u0011R\u0005\u0004\u0003\u0017C(\u0001H!cgR\u0014\u0018m\u0019;L%\u00064G\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e\u001e\u0005\u0007\u0003;y\u0001\u0019A.")
public class ControllerDurabilityEventsMaterialize
extends AbstractDurabilityEventsMaterialize {
    private final ControllerValidator validator;

    @Override
    public DurabilityDB db() {
        return super.db();
    }

    @Override
    public ControllerValidator validator() {
        return this.validator;
    }

    @Override
    public String loggerName() {
        return ControllerDurabilityEventsMaterialize.class.getName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized boolean materialize(ConsumerRecord<byte[], byte[]> record) {
        AbstractDurabilityEvent event = Deserializer$.MODULE$.deserialize((byte[])((byte[])record.key()).clone(), (byte[])((byte[])record.value()).clone());
        String metadata = new StringBuilder(35).append("Controller Durability audits topic ").append(Utils$.MODULE$.consumerRecordMetadata(record)).toString();
        if (event instanceof HealthCheckEvent) {
            HealthCheckEvent healthCheckEvent = (HealthCheckEvent)event;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("ControllerDurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).toString());
            if (!this.db().getKRaftLocalNodeId().contains((Object)BoxesRunTime.boxToInteger((int)healthCheckEvent.nodeId()))) return true;
            this.materializeHealthCheck(healthCheckEvent);
            return true;
        }
        Option<KRaftPartitionState> stateOpt = this.db().fetchKRaftPartitionState(event.topicIdPartition());
        if (stateOpt.isEmpty()) {
            return false;
        }
        KRaftPartitionState kRaftPartitionStateInDB = (KRaftPartitionState)stateOpt.get();
        Option<Object> currentEpoch = this.db().getKRaftLocalEpoch();
        boolean isStale = currentEpoch.isDefined() && BoxesRunTime.unboxToInt((Object)currentEpoch.get()) > event.epoch();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("ControllerDurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).append(" for state: ").append(this.db().kraftQuorumState()).toString());
        if (event instanceof AbstractKRaftDurabilityEvent) {
            AbstractKRaftDurabilityEvent abstractKRaftDurabilityEvent = (AbstractKRaftDurabilityEvent)event;
            boolean eventFromLocalNode = this.db().getKRaftLocalNodeId().contains((Object)BoxesRunTime.boxToInteger((int)abstractKRaftDurabilityEvent.nodeId()));
            boolean isFromMostRecentLeader = this.isEventFromMostRecentLeader(abstractKRaftDurabilityEvent, isStale);
            if (abstractKRaftDurabilityEvent instanceof KRaftLeaderChangeEvent) {
                KRaftLeaderChangeEvent kRaftLeaderChangeEvent = (KRaftLeaderChangeEvent)abstractKRaftDurabilityEvent;
                this.materializeKRaftLeaderChangeEvent(kRaftLeaderChangeEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            if (abstractKRaftDurabilityEvent instanceof KRaftHWMChangeEvent) {
                KRaftHWMChangeEvent kRaftHWMChangeEvent = (KRaftHWMChangeEvent)abstractKRaftDurabilityEvent;
                this.materializeKRaftHWMChangeEvent(kRaftHWMChangeEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            if (abstractKRaftDurabilityEvent instanceof KRaftLogStartOffsetChangeEvent) {
                KRaftLogStartOffsetChangeEvent kRaftLogStartOffsetChangeEvent = (KRaftLogStartOffsetChangeEvent)abstractKRaftDurabilityEvent;
                this.materializeKRaftLogStartOffsetChangeEvent(kRaftLogStartOffsetChangeEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            if (abstractKRaftDurabilityEvent instanceof KRaftLogSnapshotGenerationEvent) {
                KRaftLogSnapshotGenerationEvent kRaftLogSnapshotGenerationEvent = (KRaftLogSnapshotGenerationEvent)abstractKRaftDurabilityEvent;
                this.materializeKRaftLogSnapshotGenerationEvent(kRaftLogSnapshotGenerationEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            if (abstractKRaftDurabilityEvent instanceof KRaftNodeStartUpEvent) {
                KRaftNodeStartUpEvent kRaftNodeStartUpEvent = (KRaftNodeStartUpEvent)abstractKRaftDurabilityEvent;
                this.materializeKRaftNodeStartUpEvent(kRaftNodeStartUpEvent, kRaftPartitionStateInDB, eventFromLocalNode, isFromMostRecentLeader, metadata, isStale);
                return true;
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("ControllerDurabilityMaterialization: Ignoring unexpected KRaft durability event of type ").append(event.eventType()).append(": ").append(event).append(", ").append(metadata).toString());
            return false;
        }
        if (event instanceof AbstractBrokerDurabilityEvent) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Controller materialization rejected for BrokerDurabilityEvent ").append(event).toString());
            return false;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("ControllerDurabilityMaterialization: Ignoring unexpected durability event of type ").append(event.eventType()).append(": ").append(event).append(", ").append(metadata).toString());
        return false;
    }

    private void materializeKRaftLeaderChangeEvent(KRaftLeaderChangeEvent leaderChangeEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        if (isStale) {
            return;
        }
        int localNodeId = BoxesRunTime.unboxToInt((Object)this.db().getKRaftLocalNodeId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (eventFromLocalNode && isFromMostRecentLeader) {
            this.validator().validateKRaftLeaderChangeEventFromLeader(leaderChangeEvent, kRaftPartitionStateInDB, metadata);
        } else if (!eventFromLocalNode) {
            this.validator().validateKRaftLeaderChangeEventFromNonLeader(leaderChangeEvent, kRaftPartitionStateInDB, metadata);
        }
        this.db().addKRaftEpochLeader(leaderChangeEvent.epoch(), leaderChangeEvent.newLeaderId());
        this.db().truncateKRaftEpochLeaders(leaderChangeEvent.epoch() - 100);
        if (leaderChangeEvent.epochChainOpt().isDefined() && BoxesRunTime.unboxToLong((Object)leaderChangeEvent.highWatermarkOpt().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) < BoxesRunTime.unboxToLong((Object)((MapLike)leaderChangeEvent.epochChainOpt().get()).apply((Object)BoxesRunTime.boxToInteger((int)leaderChangeEvent.epoch())))) {
            ((scala.collection.mutable.MapLike)leaderChangeEvent.epochChainOpt().get()).remove((Object)BoxesRunTime.boxToInteger((int)leaderChangeEvent.epoch()));
        }
        boolean hasLogEndOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains((Object)BoxesRunTime.boxToInteger((int)leaderChangeEvent.epoch())) && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || leaderChangeEvent.logEndOffset() > kRaftPartitionStateInDB.lastKnownFetchOffset());
        boolean dbLocalEpochSet = false;
        if (eventFromLocalNode || leaderChangeEvent.yesVoters().contains((Object)BoxesRunTime.boxToInteger((int)localNodeId)) && leaderChangeEvent.epoch() > BoxesRunTime.unboxToInt((Object)currentLocalEpoch.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))) {
            dbLocalEpochSet = true;
            this.db().setKRaftLocalEpoch(leaderChangeEvent.epoch());
        }
        HashMap<Object, Object> mergedEpochChain = (HashMap<Object, Object>)kRaftPartitionStateInDB.epochChain().filter((Function1 & Serializable & scala.Serializable)epochAndStartOffset -> BoxesRunTime.boxToBoolean((boolean)ControllerDurabilityEventsMaterialize.$anonfun$materializeKRaftLeaderChangeEvent$4(leaderChangeEvent, epochAndStartOffset)));
        if (isFromMostRecentLeader && leaderChangeEvent.epochChainOpt().isDefined()) {
            ((IterableLike)((TraversableLike)leaderChangeEvent.epochChainOpt().get()).filter((Function1 & Serializable & scala.Serializable)epochAndStartOffset -> BoxesRunTime.boxToBoolean((boolean)ControllerDurabilityEventsMaterialize.$anonfun$materializeKRaftLeaderChangeEvent$5(leaderChangeEvent, epochAndStartOffset)))).foreach((Function1 & Serializable & scala.Serializable)epochAndStartOffset -> mergedEpochChain.put((Object)BoxesRunTime.boxToInteger((int)epochAndStartOffset._1$mcI$sp()), (Object)BoxesRunTime.boxToLong((long)epochAndStartOffset._2$mcJ$sp())));
        }
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(leaderChangeEvent.topicIdPartition(), kRaftPartitionStateInDB.leaderHighWatermark(), eventFromLocalNode && leaderChangeEvent.highWatermarkOpt().isDefined() ? leaderChangeEvent.highWatermarkOpt() : kRaftPartitionStateInDB.localHighWatermark(), isFromMostRecentLeader ? mergedEpochChain : kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? leaderChangeEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), eventFromLocalNode ? leaderChangeEvent.logEndOffset() : kRaftPartitionStateInDB.lastKnownFetchOffset(), eventFromLocalNode ? hasLogEndOffsetIncreasedInCurrentEpoch : kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() && !dbLocalEpochSet, kRaftPartitionStateInDB.localLatestSnapshotId());
        this.db().addKRaftPartitionState(newKRaftPartitionState);
    }

    private void materializeKRaftHWMChangeEvent(KRaftHWMChangeEvent hWMChangeEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        if (isStale) {
            return;
        }
        int localNodeId = BoxesRunTime.unboxToInt((Object)this.db().getKRaftLocalNodeId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (eventFromLocalNode && isFromMostRecentLeader) {
            this.validator().validateKRaftHWMChangeEventFromLeader(hWMChangeEvent, kRaftPartitionStateInDB, metadata);
        } else if (!eventFromLocalNode) {
            this.validator().validateKRaftHWMChangeEventFromNonLeader(hWMChangeEvent, kRaftPartitionStateInDB, metadata);
        }
        this.db().addKRaftEpochLeader(hWMChangeEvent.epoch(), hWMChangeEvent.nodeId());
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains((Object)BoxesRunTime.boxToInteger((int)hWMChangeEvent.epoch())) && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || BoxesRunTime.unboxToLong((Object)hWMChangeEvent.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)localNodeId), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) > kRaftPartitionStateInDB.lastKnownFetchOffset());
        if (eventFromLocalNode || BoxesRunTime.unboxToLong((Object)hWMChangeEvent.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)localNodeId), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) > -1L && hWMChangeEvent.epoch() > BoxesRunTime.unboxToInt((Object)currentLocalEpoch.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))) {
            this.db().setKRaftLocalEpoch(hWMChangeEvent.epoch());
        }
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(hWMChangeEvent.topicIdPartition(), (Option<Object>)(isFromMostRecentLeader ? new Some((Object)BoxesRunTime.boxToLong((long)hWMChangeEvent.highWatermark())) : kRaftPartitionStateInDB.leaderHighWatermark()), (Option<Object>)(eventFromLocalNode ? new Some((Object)BoxesRunTime.boxToLong((long)hWMChangeEvent.highWatermark())) : kRaftPartitionStateInDB.localHighWatermark()), kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? hWMChangeEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), BoxesRunTime.unboxToLong((Object)hWMChangeEvent.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)localNodeId), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) != -1L ? BoxesRunTime.unboxToLong((Object)hWMChangeEvent.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)localNodeId), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) : kRaftPartitionStateInDB.lastKnownFetchOffset(), hasFetchOffsetIncreasedInCurrentEpoch, kRaftPartitionStateInDB.localLatestSnapshotId());
        this.db().addKRaftPartitionState(newKRaftPartitionState);
    }

    private void materializeKRaftLogStartOffsetChangeEvent(KRaftLogStartOffsetChangeEvent offsetChangeEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        if (eventFromLocalNode) {
            this.validator().validateKRaftLogStartOffsetChangeEvent(offsetChangeEvent, kRaftPartitionStateInDB, metadata, isStale);
        }
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (isFromMostRecentLeader && this.db().fetchKRaftEpochLeader(offsetChangeEvent.epoch()).isEmpty()) {
            this.db().addKRaftEpochLeader(offsetChangeEvent.epoch(), BoxesRunTime.unboxToInt((Object)offsetChangeEvent.leaderIdOpt().get()));
        }
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains((Object)BoxesRunTime.boxToInteger((int)offsetChangeEvent.epoch())) && isFromMostRecentLeader && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || offsetChangeEvent.logEndOffset() > kRaftPartitionStateInDB.lastKnownFetchOffset());
        if (eventFromLocalNode && !isStale) {
            this.db().setKRaftLocalEpoch(offsetChangeEvent.epoch());
        }
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(offsetChangeEvent.topicIdPartition(), isFromMostRecentLeader ? offsetChangeEvent.highWatermarkOpt() : kRaftPartitionStateInDB.leaderHighWatermark(), eventFromLocalNode && offsetChangeEvent.highWatermarkOpt().isDefined() ? offsetChangeEvent.highWatermarkOpt() : kRaftPartitionStateInDB.localHighWatermark(), kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? offsetChangeEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), isFromMostRecentLeader && eventFromLocalNode ? offsetChangeEvent.logEndOffset() : kRaftPartitionStateInDB.lastKnownFetchOffset(), eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch(), eventFromLocalNode ? offsetChangeEvent.latestSnapshotId() : kRaftPartitionStateInDB.localLatestSnapshotId());
        this.db().addKRaftPartitionState(newKRaftPartitionState);
    }

    private void materializeKRaftLogSnapshotGenerationEvent(KRaftLogSnapshotGenerationEvent logSnapshotEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        if (eventFromLocalNode) {
            this.validator().validateKRaftLogSnapshotGenerationEvent(logSnapshotEvent, kRaftPartitionStateInDB, metadata, isStale);
        }
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (isFromMostRecentLeader && this.db().fetchKRaftEpochLeader(logSnapshotEvent.epoch()).isEmpty()) {
            this.db().addKRaftEpochLeader(logSnapshotEvent.epoch(), BoxesRunTime.unboxToInt((Object)logSnapshotEvent.leaderIdOpt().get()));
        }
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains((Object)BoxesRunTime.boxToInteger((int)logSnapshotEvent.epoch())) && isFromMostRecentLeader && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || logSnapshotEvent.logEndOffset() > kRaftPartitionStateInDB.lastKnownFetchOffset());
        if (eventFromLocalNode && !isStale) {
            this.db().setKRaftLocalEpoch(logSnapshotEvent.epoch());
        }
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(logSnapshotEvent.topicIdPartition(), isFromMostRecentLeader ? logSnapshotEvent.highWatermarkOpt() : kRaftPartitionStateInDB.leaderHighWatermark(), eventFromLocalNode && logSnapshotEvent.highWatermarkOpt().isDefined() ? logSnapshotEvent.highWatermarkOpt() : kRaftPartitionStateInDB.localHighWatermark(), kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? logSnapshotEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), isFromMostRecentLeader && eventFromLocalNode ? logSnapshotEvent.logEndOffset() : kRaftPartitionStateInDB.lastKnownFetchOffset(), eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch(), (Option<OffsetAndEpoch>)(eventFromLocalNode ? new Some((Object)logSnapshotEvent.newSnapshotId()) : kRaftPartitionStateInDB.localLatestSnapshotId()));
        this.db().addKRaftPartitionState(newKRaftPartitionState);
    }

    private void materializeKRaftNodeStartUpEvent(KRaftNodeStartUpEvent nodeStartUpEvent, KRaftPartitionState kRaftPartitionStateInDB, boolean eventFromLocalNode, boolean isFromMostRecentLeader, String metadata, boolean isStale) {
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        if (eventFromLocalNode) {
            this.validator().validateKRaftNodeStartUpEvent(nodeStartUpEvent, kRaftPartitionStateInDB, metadata, isStale);
        }
        Option<Object> currentLocalEpoch = this.db().getKRaftLocalEpoch();
        if (isFromMostRecentLeader && this.db().fetchKRaftEpochLeader(nodeStartUpEvent.epoch()).isEmpty()) {
            this.db().addKRaftEpochLeader(nodeStartUpEvent.epoch(), BoxesRunTime.unboxToInt((Object)nodeStartUpEvent.leaderIdOpt().get()));
        }
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = currentLocalEpoch.contains((Object)BoxesRunTime.boxToInteger((int)nodeStartUpEvent.epoch())) && isFromMostRecentLeader && (kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch() || nodeStartUpEvent.logEndOffset() > kRaftPartitionStateInDB.lastKnownFetchOffset());
        if (eventFromLocalNode && !isStale) {
            this.db().setKRaftLocalEpoch(nodeStartUpEvent.epoch());
        }
        KRaftPartitionState newKRaftPartitionState = KRaftPartitionState$.MODULE$.apply(nodeStartUpEvent.topicIdPartition(), isFromMostRecentLeader ? nodeStartUpEvent.highWatermarkOpt() : kRaftPartitionStateInDB.leaderHighWatermark(), eventFromLocalNode && nodeStartUpEvent.highWatermarkOpt().isDefined() ? nodeStartUpEvent.highWatermarkOpt() : kRaftPartitionStateInDB.localHighWatermark(), kRaftPartitionStateInDB.epochChain(), this.db().kraftQuorumState().epochLeaderIds(), eventFromLocalNode ? nodeStartUpEvent.logStartOffset() : kRaftPartitionStateInDB.localLogStartOffset(), isFromMostRecentLeader && eventFromLocalNode ? nodeStartUpEvent.logEndOffset() : kRaftPartitionStateInDB.lastKnownFetchOffset(), eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : kRaftPartitionStateInDB.hasFetchOffsetIncreasedInCurrentEpoch(), eventFromLocalNode ? nodeStartUpEvent.latestSnapshotId() : kRaftPartitionStateInDB.localLatestSnapshotId());
        this.db().addKRaftPartitionState(newKRaftPartitionState);
    }

    private boolean isEventFromMostRecentLeader(AbstractKRaftDurabilityEvent event, boolean isStale) {
        return event.isFromLeader() && !isStale && (this.db().kraftQuorumState().epochLeaderIds().isEmpty() || event.epoch() >= BoxesRunTime.unboxToInt((Object)this.db().kraftQuorumState().epochLeaderIds().keys().max((Ordering)Ordering.Int$.MODULE$)));
    }

    public static final /* synthetic */ boolean $anonfun$materializeKRaftLeaderChangeEvent$4(KRaftLeaderChangeEvent leaderChangeEvent$1, Tuple2 epochAndStartOffset) {
        return epochAndStartOffset._1$mcI$sp() >= leaderChangeEvent$1.epoch() - 100;
    }

    public static final /* synthetic */ boolean $anonfun$materializeKRaftLeaderChangeEvent$5(KRaftLeaderChangeEvent leaderChangeEvent$1, Tuple2 epochAndStartOffset) {
        return epochAndStartOffset._1$mcI$sp() >= leaderChangeEvent$1.epoch() - 100;
    }

    public ControllerDurabilityEventsMaterialize(DurabilityDB db, AuditReporter reporter, Time time) {
        super(db, reporter, time);
        this.validator = new ControllerValidator(reporter, db, time);
    }
}

