/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.tools;

import java.util.Properties;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.events.CurrentVersion$;
import kafka.durability.events.broker.InjectStateEvent;
import kafka.tier.tools.RecoveryUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class UpdateDB$ {
    public static UpdateDB$ MODULE$;

    static {
        new UpdateDB$();
    }

    public int partitioner(TopicPartition topicPartition, int numPartitions) {
        return Math.abs(topicPartition.hashCode()) % numPartitions;
    }

    /*
     * WARNING - void declaration
     */
    public Properties toProducerProperties(String clientId) {
        void var2_2;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", "localhost:9072");
        properties.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        properties.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        properties.put("acks", "all");
        properties.put("enable.idempotence", "false");
        properties.put("retry.backoff.ms", Integer.toString(2000));
        properties.put("delivery.timeout.ms", Integer.toString(Integer.MAX_VALUE));
        properties.put("client.id", clientId);
        properties.put("request.timeout.ms", Integer.toString(1000));
        properties.put("max.in.flight.requests.per.connection", "1");
        properties.remove("metric.reporters");
        return var2_2;
    }

    public void queueInjectStateEvent(TopicIdPartition topicIdPartition, InjectStateEvent event) {
        KafkaProducer producer = new KafkaProducer(this.toProducerProperties("DurabilityAuditToolClient"));
        int numPartitions = RecoveryUtils.getNumPartitions((Producer<byte[], byte[]>)producer, DurabilityAuditConstants$.MODULE$.TOPIC_NAME());
        int dbPartitionId = this.partitioner(topicIdPartition.topicPartition(), numPartitions);
        RecordMetadata injectedRecord = (RecordMetadata)producer.send(new ProducerRecord(DurabilityAuditConstants$.MODULE$.TOPIC_NAME(), Predef$.MODULE$.int2Integer(dbPartitionId), (Object)event.serializeKey(), (Object)event.serializeValue())).get();
        Predef$.MODULE$.println((Object)new StringBuilder(55).append("Record append for durability topic partition: ").append(Integer.toString(dbPartitionId)).append(" offset: ").append(Long.toString(injectedRecord.offset())).toString());
        producer.close();
    }

    public void deletePartition(String topic, String partition) {
        try {
            if (topic != null && !topic.trim().isEmpty() && partition != null && !partition.trim().isEmpty()) {
                String userTopic = topic.trim();
                int userPartition = new StringOps(Predef$.MODULE$.augmentString(partition.trim())).toInt();
                TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), userPartition, userTopic);
                InjectStateEvent event = new InjectStateEvent(topicIdPartition, CurrentVersion$.MODULE$.version(), -1, -1L, -1L, -1L, true, -1);
                this.queueInjectStateEvent(topicIdPartition, event);
                return;
            }
            Predef$.MODULE$.println((Object)"Cannot process: Empty topicPartition input");
        }
        catch (NumberFormatException e) {
            Predef$.MODULE$.println((Object)new StringBuilder(25).append("Invalid format of input: ").append(e).toString());
            return;
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(44).append("Caught the exception while injecting event: ").append(e).toString());
        }
    }

    public String deletePartition$default$1() {
        return "";
    }

    public String deletePartition$default$2() {
        return "";
    }

    public void updatePartition(String topic, String partition, String epoch, String hwm, String startOffset, String config) {
        try {
            if (topic != null && !topic.trim().isEmpty() && partition != null && !partition.trim().isEmpty()) {
                String userTopic = topic.trim();
                int userPartition = new StringOps(Predef$.MODULE$.augmentString(partition.trim())).toInt();
                int eventEpoch = epoch == null || epoch.trim().isEmpty() ? -1 : new StringOps(Predef$.MODULE$.augmentString(epoch.trim())).toInt();
                long eventHwm = hwm == null || hwm.trim().isEmpty() ? -1L : new StringOps(Predef$.MODULE$.augmentString(hwm.trim())).toLong();
                long eventStartOffset = startOffset == null || startOffset.trim().isEmpty() ? -1L : new StringOps(Predef$.MODULE$.augmentString(startOffset.trim())).toLong();
                long eventConfig = config == null || config.trim().isEmpty() ? -1L : new StringOps(Predef$.MODULE$.augmentString(config.trim())).toLong();
                TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), userPartition, userTopic);
                InjectStateEvent event = new InjectStateEvent(topicIdPartition, CurrentVersion$.MODULE$.version(), eventEpoch, eventHwm, eventStartOffset, eventConfig, false, -1);
                this.queueInjectStateEvent(topicIdPartition, event);
                return;
            }
            Predef$.MODULE$.println((Object)"Cannot process: Empty topicIdPartition input");
        }
        catch (NumberFormatException e) {
            Predef$.MODULE$.println((Object)new StringBuilder(25).append("Invalid format of input: ").append(e).toString());
            return;
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(44).append("Caught the exception while injecting event: ").append(e).toString());
        }
    }

    public String updatePartition$default$1() {
        return "";
    }

    public String updatePartition$default$2() {
        return "";
    }

    public String updatePartition$default$3() {
        return "";
    }

    public String updatePartition$default$4() {
        return "";
    }

    public String updatePartition$default$5() {
        return "";
    }

    public String updatePartition$default$6() {
        return "";
    }

    private UpdateDB$() {
        MODULE$ = this;
    }
}

