/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.topic;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.durability.Utils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicConsumer;
import kafka.durability.topic.DurabilityTopicManager$;
import kafka.durability.topic.DurabilityTopicProducer;
import kafka.server.InternalAdmin;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001\u0002\u0015*\u0001AB\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\u007f!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003G\u0011!i\u0005A!b\u0001\n\u0003q\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011Y\u0003!Q1A\u0005\u0002]C\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\tS\u0002\u0011\t\u0011)A\u0005U\"Aa\u000f\u0001B\u0001B\u0003%q\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0002\u0002CA\u0016\u0001\u0001\u0006I!!\n\t\u0017\u00055\u0002\u0001#b\u0001\n\u0003I\u0013q\u0006\u0005\f\u0003o\u0001\u0001R1A\u0005\u0002%\nI\u0004C\u0005\u0002B\u0001\u0001\r\u0011\"\u0001\u0002D!I\u0011Q\t\u0001A\u0002\u0013\u0005\u0011q\t\u0005\b\u0003'\u0002\u0001\u0015)\u0003x\u0011%\ti\u0006\u0001a\u0001\n\u0003\t\u0019\u0005C\u0005\u0002`\u0001\u0001\r\u0011\"\u0001\u0002b!9\u0011Q\r\u0001!B\u00139\b\"CA5\u0001\u0001\u0007I\u0011BA6\u0011%\t\u0019\t\u0001a\u0001\n\u0013\t)\t\u0003\u0005\u0002\n\u0002\u0001\u000b\u0015BA7\u0011%\tY\t\u0001b\u0001\n\u0003\ti\t\u0003\u0005\u0002,\u0002\u0001\u000b\u0011BAH\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!!-\u0001\t\u0003\t\u0019\fC\u0004\u00026\u0002!I!a-\t\u000f\u0005]\u0006\u0001\"\u0001\u00020\"9\u0011\u0011\u0018\u0001\u0005\n\u0005=\u0006bBA^\u0001\u0011%\u0011q\u0016\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\t)\r\u0001C\u0001\u0003\u000f<\u0011\"!4*\u0003\u0003E\t!a4\u0007\u0011!J\u0013\u0011!E\u0001\u0003#DaA_\u0013\u0005\u0002\u0005M\u0007\"CAkKE\u0005I\u0011AAl\u0005Y!UO]1cS2LG/\u001f+pa&\u001cW*\u00198bO\u0016\u0014(B\u0001\u0016,\u0003\u0015!x\u000e]5d\u0015\taS&\u0001\u0006ekJ\f'-\u001b7jifT\u0011AL\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aZT\"A\u001d\u000b\u0005ij\u0013!B;uS2\u001c\u0018B\u0001\u001f:\u0005\u001daunZ4j]\u001e\faaY8oM&<W#A \u0011\u0005\u0001\u000bU\"A\u0015\n\u0005\tK#!\u0006#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2D_:4\u0017nZ\u0001\bG>tg-[4!\u0003!!\u0017\r^1cCN,W#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%[\u0013A\u00013c\u0013\tY\u0005J\u0001\u0007EkJ\f'-\u001b7jif$%)A\u0005eCR\f'-Y:fA\u0005YQ.\u0019;fe&\fG.\u001b>f+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*,\u0003=i\u0017\r^3sS\u0006d\u0017N_1uS>t\u0017B\u0001+R\u0005\r\n%m\u001d;sC\u000e$H)\u001e:bE&d\u0017\u000e^=Fm\u0016tGo]'bi\u0016\u0014\u0018.\u00197ju\u0016\fA\"\\1uKJL\u0017\r\\5{K\u0002\nQ#\u001b8uKJt\u0017\r\\!e[&t7+\u001e9qY&,'/F\u0001Y!\rI\u0006MY\u0007\u00025*\u00111\fX\u0001\tMVt7\r^5p]*\u0011QLX\u0001\u0005kRLGNC\u0001`\u0003\u0011Q\u0017M^1\n\u0005\u0005T&\u0001C*vaBd\u0017.\u001a:\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015l\u0013AB:feZ,'/\u0003\u0002hI\ni\u0011J\u001c;fe:\fG.\u00113nS:\fa#\u001b8uKJt\u0017\r\\!e[&t7+\u001e9qY&,'\u000fI\u0001\u0005i&lW\r\u0005\u0002li6\tAN\u0003\u0002;[*\u0011an\\\u0001\u0007G>lWn\u001c8\u000b\u00059\u0002(BA9s\u0003\u0019\t\u0007/Y2iK*\t1/A\u0002pe\u001eL!!\u001e7\u0003\tQKW.Z\u0001\u0016GJ,\u0017\r^3EkJ\f'-\u001b7jif$v\u000e]5d!\t\u0011\u00040\u0003\u0002zg\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0006}{z|\u0018\u0011AA\u0002\u0003\u000b\u0001\"\u0001\u0011\u0001\t\u000buZ\u0001\u0019A \t\u000b\u0011[\u0001\u0019\u0001$\t\u000b5[\u0001\u0019A(\t\u000bY[\u0001\u0019\u0001-\t\u000f%\\\u0001\u0013!a\u0001U\")ao\u0003a\u0001o\u0006QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005-\u0001\u0003BA\u0007\u00037qA!a\u0004\u0002\u0018A\u0019\u0011\u0011C\u001a\u000e\u0005\u0005M!bAA\u000b_\u00051AH]8pizJ1!!\u00074\u0003\u0019\u0001&/\u001a3fM&!\u0011QDA\u0010\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011D\u001a\u0002=\u0011+&+\u0011\"J\u0019&#\u0016lX\"S\u000b\u0006#\u0016j\u0014(`\u0005\u0006\u001b5j\u0014$G?6\u001bVCAA\u0013!\r\u0011\u0014qE\u0005\u0004\u0003S\u0019$\u0001\u0002'p]\u001e\fq\u0004R+S\u0003\nKE*\u0013+Z?\u000e\u0013V)\u0011+J\u001f:{&)Q\"L\u001f\u001a3u,T*!\u0003A\u0019wN\\:v[\u0016\u0014\bK]8wS\u0012,'/\u0006\u0002\u00022A\u0019\u0001)a\r\n\u0007\u0005U\u0012FA\fEkJ\f'-\u001b7jif$v\u000e]5d\u0007>t7/^7fe\u0006\u0001\u0002O]8ek\u000e,'\u000f\u0015:pm&$WM]\u000b\u0003\u0003w\u00012\u0001QA\u001f\u0013\r\ty$\u000b\u0002\u0018\tV\u0014\u0018MY5mSRLHk\u001c9jGB\u0013x\u000eZ;dKJ\fQA]3bIf,\u0012a^\u0001\ne\u0016\fG-_0%KF$B!!\u0013\u0002PA\u0019!'a\u0013\n\u0007\u000553G\u0001\u0003V]&$\b\u0002CA)%\u0005\u0005\t\u0019A<\u0002\u0007a$\u0013'\u0001\u0004sK\u0006$\u0017\u0010\t\u0015\u0004'\u0005]\u0003c\u0001\u001a\u0002Z%\u0019\u00111L\u001a\u0003\u0011Y|G.\u0019;jY\u0016\f!\"[:TQV$Hm\\<o\u00039I7o\u00155vi\u0012|wO\\0%KF$B!!\u0013\u0002d!A\u0011\u0011K\u000b\u0002\u0002\u0003\u0007q/A\u0006jgNCW\u000f\u001e3po:\u0004\u0003f\u0001\f\u0002X\u0005A\u0011\rZ7j]>\u0003H/\u0006\u0002\u0002nA)!'a\u001c\u0002t%\u0019\u0011\u0011O\u001a\u0003\r=\u0003H/[8o!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\nQ!\u00193nS:T1!! p\u0003\u001d\u0019G.[3oiNLA!!!\u0002x\tq1i\u001c8gYV,g\u000e^!e[&t\u0017\u0001D1e[&tw\n\u001d;`I\u0015\fH\u0003BA%\u0003\u000fC\u0011\"!\u0015\u0019\u0003\u0003\u0005\r!!\u001c\u0002\u0013\u0005$W.\u001b8PaR\u0004\u0013\u0001D9vKV,G-\u0012<f]R\u001cXCAAH!\u0019\t\t*a'\u0002 6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*A\u0004nkR\f'\r\\3\u000b\u0007\u0005e5'\u0001\u0006d_2dWm\u0019;j_:LA!!(\u0002\u0014\n)\u0011+^3vKB!\u0011\u0011UAT\u001b\t\t\u0019KC\u0002\u0002&.\na!\u001a<f]R\u001c\u0018\u0002BAU\u0003G\u0013q#\u00112tiJ\f7\r\u001e#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;\u0002\u001bE,X-^3e\u000bZ,g\u000e^:!\u0003\u0015\u0019H/\u0019:u)\t\tI%A\u0004jgJ+\u0017\rZ=\u0015\u0003]\fa\u0002\u001e:z\u0005\u0016\u001cw.\\3SK\u0006$\u00170\u0001\u0005tQV$Hm\\<o\u00035\u0019H/\u0019:u\u0007>t7/^7fe\u000691\r\\3b]V\u0004\u0018aC3ogV\u0014X\rV8qS\u000e$B!!\u0013\u0002B\"1\u00111\u0019\u0012A\u0002\t\fQ\"\u001b8uKJt\u0017\r\\!e[&t\u0017AE1eI\u0012+(/\u00192jY&$\u00180\u0012<f]R$B!!\u0013\u0002J\"9\u00111Z\u0012A\u0002\u0005}\u0015!B3wK:$\u0018A\u0006#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2NC:\fw-\u001a:\u0011\u0005\u0001+3CA\u00132)\t\ty-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u00033T3A[AnW\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\u0013Ut7\r[3dW\u0016$'bAAtg\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0018\u0011\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class DurabilityTopicManager
implements Logging {
    private DurabilityTopicConsumer consumerProvider;
    private DurabilityTopicProducer producerProvider;
    private final DurabilityTopicConfig config;
    private final DurabilityDB database;
    private final AbstractDurabilityEventsMaterialize materialize;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final Time time;
    private final boolean createDurabilityTopic;
    private final long DURABILITY_CREATION_BACKOFF_MS;
    private volatile boolean ready;
    private volatile boolean isShutdown;
    private Option<ConfluentAdmin> adminOpt;
    private final Queue<AbstractDurabilityEvent> queuedEvents;
    private Logger logger;
    private String logIdent;
    private volatile byte bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return DurabilityTopicManager$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DurabilityTopicConfig config() {
        return this.config;
    }

    public DurabilityDB database() {
        return this.database;
    }

    public AbstractDurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    @Override
    public String loggerName() {
        return DurabilityTopicManager.class.getName();
    }

    private long DURABILITY_CREATION_BACKOFF_MS() {
        return this.DURABILITY_CREATION_BACKOFF_MS;
    }

    private DurabilityTopicConsumer consumerProvider$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.consumerProvider = new DurabilityTopicConsumer(this.config(), this.database(), this.materialize());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.consumerProvider;
    }

    public DurabilityTopicConsumer consumerProvider() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.consumerProvider$lzycompute();
        }
        return this.consumerProvider;
    }

    private DurabilityTopicProducer producerProvider$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.producerProvider = new DurabilityTopicProducer(this.config());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.producerProvider;
    }

    public DurabilityTopicProducer producerProvider() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.producerProvider$lzycompute();
        }
        return this.producerProvider;
    }

    public boolean ready() {
        return this.ready;
    }

    public void ready_$eq(boolean x$1) {
        this.ready = x$1;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public void isShutdown_$eq(boolean x$1) {
        this.isShutdown = x$1;
    }

    private Option<ConfluentAdmin> adminOpt() {
        return this.adminOpt;
    }

    private void adminOpt_$eq(Option<ConfluentAdmin> x$1) {
        this.adminOpt = x$1;
    }

    public Queue<AbstractDurabilityEvent> queuedEvents() {
        return this.queuedEvents;
    }

    public void start() {
        try {
            while (!this.ready() && !this.isShutdown()) {
                if (this.tryBecomeReady()) continue;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to become ready.");
                this.time.sleep(this.DURABILITY_CREATION_BACKOFF_MS());
            }
        }
        catch (Exception e) {
            if (this.isShutdown()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring exception caught during shutdown", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught exception while starting DurabilityTopicManager", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public boolean isReady() {
        return this.ready() && this.consumerProvider().isReady();
    }

    private boolean tryBecomeReady() {
        if (this.config().interBrokerClientConfigs().get().isEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Could not resolve bootstrap server. Will retry.");
            return false;
        }
        if (this.createDurabilityTopic) {
            try {
                this.ensureTopic(this.internalAdminSupplier().get());
            }
            catch (Exception e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught exception when ensuring durability topic is created. Will retry.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return false;
            }
        }
        Properties adminProps = new Properties();
        try {
            Object endpoint = this.config().interBrokerClientConfigs().get().get("bootstrap.servers");
            adminProps.put("bootstrap.servers", endpoint);
            this.adminOpt_$eq((Option<ConfluentAdmin>)new Some((Object)ConfluentAdmin.create((Properties)adminProps)));
            ((Admin)this.adminOpt().get()).describeTopics(Collections.singletonList(this.config().topicName())).allTopicNames().get();
        }
        catch (Exception e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught exception when checking if durability topic was created by some other node. Will retry.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return false;
        }
        Option<ConfluentAdmin> option = this.adminOpt();
        if (option instanceof Some) {
            ((ConfluentAdmin)((Some)option).value()).close();
            this.adminOpt_$eq((Option<ConfluentAdmin>)None$.MODULE$);
        }
        this.startConsumer();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started consumer for DurabilityTopicManager");
        return true;
    }

    public void shutdown() {
        this.isShutdown_$eq(true);
        this.cleanup();
    }

    private void startConsumer() {
        this.consumerProvider().startConsumer(this.consumerProvider().startConsumer$default$1());
        synchronized (this) {
            this.ready_$eq(true);
            this.queuedEvents().foreach((Function1 & Serializable & scala.Serializable)event -> {
                this.addDurabilityEvent(event);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private synchronized void cleanup() {
        try {
            this.ready_$eq(false);
            if (this.producerProvider() != null) {
                try {
                    this.producerProvider().get().close(Duration.ofSeconds(2L));
                }
                catch (InterruptException interruptException) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received interrupt while being blocked on producer, will close", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> interruptException);
                }
                catch (Exception e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received unknown error while closing producer", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        }
        finally {
            this.consumerProvider().shutdown();
        }
    }

    private void ensureTopic(InternalAdmin internalAdmin) {
        internalAdmin.ensureTopic(this.config().topicName(), this.config().configuredNumPartitions(), this.config().configuredReplicationFactor(), this.config().toTopicProperties());
    }

    public void addDurabilityEvent(AbstractDurabilityEvent event) {
        synchronized (this) {
            if (this.isShutdown()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Durability Topic Manager service shutting down, ignoring append request ").append(event).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("DurabilityEvent: Sending ").append(event).append(" to durability topic").toString());
                this.liftedTree1$1(event);
            }
            return;
        }
    }

    private final /* synthetic */ Object liftedTree1$1(AbstractDurabilityEvent event$1) {
        Object object;
        try {
            if (this.ready()) {
                return this.producerProvider().get().send(new ProducerRecord(this.config().topicName(), Predef$.MODULE$.int2Integer(Utils$.MODULE$.toPartition(event$1.topicIdPartition().topicPartition(), this.config().configuredNumPartitions())), (Object)event$1.serializeKey(), (Object)event$1.serializeValue()));
            }
            object = this.queuedEvents().$colon$plus((Object)event$1, Queue$.MODULE$.canBuildFrom());
        }
        catch (Exception ex) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Exception in addDurabilityEvent ").append(ex.getCause()).append(" ").append(ex.getMessage()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public DurabilityTopicManager(DurabilityTopicConfig config, DurabilityDB database, AbstractDurabilityEventsMaterialize materialize, Supplier<InternalAdmin> internalAdminSupplier, Time time, boolean createDurabilityTopic) {
        this.config = config;
        this.database = database;
        this.materialize = materialize;
        this.internalAdminSupplier = internalAdminSupplier;
        this.time = time;
        this.createDurabilityTopic = createDurabilityTopic;
        Logging.$init$(this);
        this.DURABILITY_CREATION_BACKOFF_MS = 5000L;
        this.ready = false;
        this.isShutdown = false;
        this.adminOpt = None$.MODULE$;
        this.queuedEvents = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

