/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.utils;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kafka.durability.utils.KeyAndVersionInfo;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.S3VersionInformation;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.NonLocalReturnControl;

public final class DurabilityObjectStoreUtils$
implements Logging {
    public static DurabilityObjectStoreUtils$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new DurabilityObjectStoreUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Set<String> stringFormatUUID(Set<UUID> segments) {
        return (Set)segments.map((Function1 & Serializable & scala.Serializable)x -> CoreUtils$.MODULE$.uuidToBase64((UUID)x), Set$.MODULE$.canBuildFrom());
    }

    public void putOffsetMapFile(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition, File file) {
        TierObjectStore.DurabilityAuditsOffsetMapMetadata metadata = new TierObjectStore.DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId);
        tierStore.putObject(metadata, file, TierObjectStore.FileType.DA_OFFSET_MAP);
    }

    public TierObjectStoreResponse getOffsetMapFile(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition) {
        TierObjectStore.DurabilityAuditsOffsetMapMetadata metadata = new TierObjectStore.DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId);
        return tierStore.getObject(metadata, TierObjectStore.FileType.DA_OFFSET_MAP);
    }

    public void deleteOffsetMapFile(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition) {
        TierObjectStore.DurabilityAuditsOffsetMapMetadata metadata = new TierObjectStore.DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId);
        tierStore.listObject(metadata.toPath("", TierObjectStore.FileType.DA_OFFSET_MAP), true).forEach((x0$1, x1$1) -> {
            String blobKey = x0$1;
            List versionList = x1$1;
            ArrayList<TierObjectStore.KeyAndVersion> deletionList = new ArrayList<TierObjectStore.KeyAndVersion>();
            versionList.forEach(versionInfo -> deletionList.add(new TierObjectStore.KeyAndVersion(blobKey, versionInfo.getVersionId())));
            if (!deletionList.isEmpty()) {
                tierStore.deleteVersions(deletionList);
                return;
            }
        });
    }

    public Map<String, List<VersionInformation>> listObjectWithRetries(TierObjectStore tierStore, TopicIdPartition topicIdPartition, String keyPrefix, boolean getVersionInfo, int count, int maxRetries) {
        while (true) {
            try {
                return tierStore.listObject(keyPrefix, true);
            }
            catch (TierObjectStoreRetriableException e) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(this.msgWithLogIdent(DurabilityObjectStoreUtils$.$anonfun$listObjectWithRetries$1(e, keyPrefix, topicIdPartition)));
                }
                if (count < maxRetries) {
                    ++count;
                    continue;
                }
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(DurabilityObjectStoreUtils$.$anonfun$listObjectWithRetries$2(e, keyPrefix, topicIdPartition)));
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(DurabilityObjectStoreUtils$.$anonfun$listObjectWithRetries$3(e, keyPrefix, topicIdPartition)));
                }
                throw e;
            }
            break;
        }
    }

    public Option<KeyAndVersionInfo> getVersion(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition, TierObjectStore.FileType fileType) {
        Object object = new Object();
        try {
            String keyPrefix = new StringBuilder(3).append(TierObjectStore.DataTypePathPrefix.TOPIC.prefix).append("/").append(CoreUtils$.MODULE$.uuidToBase64(objectId)).append("/").append(topicIdPartition.topicIdAsBase64()).append("/").append(topicIdPartition.partition()).toString();
            Map<String, List<VersionInformation>> allBlobsWithVersions = this.listObjectWithRetries(tierStore, topicIdPartition, keyPrefix, true, 0, 3);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(DurabilityObjectStoreUtils$.$anonfun$getVersion$1(keyPrefix, allBlobsWithVersions)));
            }
            allBlobsWithVersions.forEach((x0$1, x1$1) -> {
                String blobKey = x0$1;
                List versionList = x1$1;
                if (blobKey.contains(fileType.suffix())) {
                    versionList.forEach(versionInfo -> {
                        DurabilityObjectStoreUtils$ durabilityObjectStoreUtils$ = MODULE$;
                        if (durabilityObjectStoreUtils$ == null) {
                            throw null;
                        }
                        DurabilityObjectStoreUtils$ debug_this = durabilityObjectStoreUtils$;
                        if (debug_this.logger().underlying().isDebugEnabled()) {
                            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(DurabilityObjectStoreUtils$.$anonfun$getVersion$4(blobKey, versionInfo, topicIdPartition)));
                        }
                        TierObjectStore.Backend backend = tierStore.getBackend();
                        TierObjectStore.Backend backend2 = TierObjectStore.Backend.S3;
                        if (!(backend != null ? !((Object)((Object)backend)).equals((Object)backend2) : backend2 != null)) {
                            if (!((S3VersionInformation)versionInfo).isDeleteMarker()) {
                                throw new NonLocalReturnControl(object, (Object)Option$.MODULE$.apply((Object)new KeyAndVersionInfo(blobKey, (VersionInformation)versionInfo)));
                            }
                        } else {
                            TierObjectStore.Backend backend3 = tierStore.getBackend();
                            TierObjectStore.Backend backend4 = TierObjectStore.Backend.Mock;
                            if (!(backend3 != null ? !((Object)((Object)backend3)).equals((Object)backend4) : backend4 != null)) {
                                if (!versionInfo.getVersionId().equals("delete-marker")) {
                                    throw new NonLocalReturnControl(object, (Object)Option$.MODULE$.apply((Object)new KeyAndVersionInfo(blobKey, (VersionInformation)versionInfo)));
                                }
                            } else {
                                throw new NonLocalReturnControl(object, (Object)Option$.MODULE$.apply((Object)new KeyAndVersionInfo(blobKey, (VersionInformation)versionInfo)));
                            }
                        }
                    });
                    return;
                }
                DurabilityObjectStoreUtils$ durabilityObjectStoreUtils$ = MODULE$;
                if (durabilityObjectStoreUtils$ == null) {
                    throw null;
                }
                DurabilityObjectStoreUtils$ debug_this = durabilityObjectStoreUtils$;
                if (debug_this.logger().underlying().isDebugEnabled()) {
                    debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(DurabilityObjectStoreUtils$.$anonfun$getVersion$5(keyPrefix, topicIdPartition, blobKey, fileType)));
                    return;
                }
            });
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(DurabilityObjectStoreUtils$.$anonfun$getVersion$6(keyPrefix, topicIdPartition)));
            }
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public String versionListMapToString(Map<String, List<VersionInformation>> versionListMap) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        versionListMap.forEach((k, vList) -> DurabilityObjectStoreUtils$.keyVersions$1(k, vList, sb));
        return sb.toString();
    }

    public static final /* synthetic */ String $anonfun$listObjectWithRetries$1(TierObjectStoreRetriableException e$1, String keyPrefix$1, TopicIdPartition topicIdPartition$1) {
        return new StringBuilder(42).append("Running into ").append((Object)e$1).append(" get list for keyPrefix ").append(keyPrefix$1).append(" for ").append(topicIdPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$listObjectWithRetries$2(TierObjectStoreRetriableException e$1, String keyPrefix$1, TopicIdPartition topicIdPartition$1) {
        return new StringBuilder(51).append("Retries failed,  into ").append((Object)e$1).append(" get list for keyPrefix ").append(keyPrefix$1).append(" for ").append(topicIdPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$listObjectWithRetries$3(Exception e$2, String keyPrefix$1, TopicIdPartition topicIdPartition$1) {
        return new StringBuilder(42).append("Running into ").append(e$2).append(" get list for keyPrefix ").append(keyPrefix$1).append(" for ").append(topicIdPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$getVersion$1(String keyPrefix$2, Map allBlobsWithVersions$1) {
        return new StringBuilder(24).append("got version map for ").append(keyPrefix$2).append(": \n ").append(MODULE$.versionListMapToString(allBlobsWithVersions$1)).toString();
    }

    public static final /* synthetic */ String $anonfun$getVersion$4(String blobKey$2, VersionInformation versionInfo$1, TopicIdPartition topicIdPartition$2) {
        return new StringBuilder(60).append("Checking blob found with key ").append(blobKey$2).append(" version ").append(versionInfo$1).append(" for topicIdPartition ").append(topicIdPartition$2).toString();
    }

    public static final /* synthetic */ String $anonfun$getVersion$5(String keyPrefix$2, TopicIdPartition topicIdPartition$2, String blobKey$2, TierObjectStore.FileType fileType$1) {
        return new StringBuilder(101).append("File suffix not matching, found object: pattern = ").append(keyPrefix$2).append(", topicIdPartition = ").append(topicIdPartition$2).append(", key = ").append(blobKey$2).append("; expected file type: ").append(fileType$1.suffix()).toString();
    }

    public static final /* synthetic */ String $anonfun$getVersion$6(String keyPrefix$2, TopicIdPartition topicIdPartition$2) {
        return new StringBuilder(55).append("No versioned objects for pattern ").append(keyPrefix$2).append(" for topicIdPartition ").append(topicIdPartition$2).toString();
    }

    private static final scala.collection.mutable.StringBuilder versions$1(VersionInformation v, scala.collection.mutable.StringBuilder sb$1, String k$1) {
        sb$1.append(k$1).append(": ").append(v.getVersionId());
        if (v instanceof S3VersionInformation) {
            S3VersionInformation s3v = (S3VersionInformation)v;
            sb$1.append("(isDeleteMarker: ").append(s3v.isDeleteMarker()).append(")");
        }
        return sb$1.append("\n");
    }

    private static final void keyVersions$1(String k, List vList, scala.collection.mutable.StringBuilder sb$1) {
        vList.stream().forEach(v -> DurabilityObjectStoreUtils$.versions$1(v, sb$1, k));
    }

    private DurabilityObjectStoreUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

