/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.utils;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import kafka.durability.exception.MemoryLimitExceededException;
import kafka.durability.utils.OffsetInfo;
import kafka.durability.utils.OffsetMapEntry;
import kafka.durability.utils.OffsetMapEntryRecord;
import kafka.durability.utils.OffsetMapFile;
import kafka.log.CleanedTransactionMetadata;
import kafka.tier.TopicIdPartition;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

public final class DurabilityOffsetMapUtils$
implements Logging {
    public static DurabilityOffsetMapUtils$ MODULE$;
    private final BufferSupplier decompressionBufferSupplier;
    private final MessageDigest digest;
    private final int hashSize;
    private final byte[] hashBuffer;
    private final int OFFSET_MAP_MEMORY_USAGE_PER_ENTRY;
    private final long OFFSET_MAP_ENTRY_COUNT_LIMIT;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new DurabilityOffsetMapUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    private MessageDigest digest() {
        return this.digest;
    }

    private int hashSize() {
        return this.hashSize;
    }

    private byte[] hashBuffer() {
        return this.hashBuffer;
    }

    public ByteBuffer getHashedBuffer(ByteBuffer key) {
        key.mark();
        this.digest().reset();
        this.digest().update(key);
        int len = this.digest().digest(this.hashBuffer(), 0, this.hashSize());
        byte[] hashedKey = new byte[len];
        Array$.MODULE$.copy((Object)this.hashBuffer(), 0, (Object)hashedKey, 0, len);
        return ByteBuffer.wrap(hashedKey);
    }

    private int OFFSET_MAP_MEMORY_USAGE_PER_ENTRY() {
        return this.OFFSET_MAP_MEMORY_USAGE_PER_ENTRY;
    }

    private long OFFSET_MAP_ENTRY_COUNT_LIMIT() {
        return this.OFFSET_MAP_ENTRY_COUNT_LIMIT;
    }

    private void mayThrowMemoryLimitExceededException(long limit, long actual) {
        if (actual > limit) {
            throw new MemoryLimitExceededException("DA for compaction offset map generator", limit * (long)this.OFFSET_MAP_MEMORY_USAGE_PER_ENTRY(), actual * (long)this.OFFSET_MAP_MEMORY_USAGE_PER_ENTRY());
        }
    }

    public SortedMap<ByteBuffer, OffsetInfo> filterKeysAndOffset(Throttler throttler, InputStream inputStream, ByteBuffer readByteBuffer, CleanedTransactionMetadata transactionMetadata, long lastCleanOffset, long offsetMapEntryCountLimit) {
        SortedMap offsetMap = (SortedMap)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        readByteBuffer.clear();
        try {
            Utils.readFully((InputStream)inputStream, (ByteBuffer)readByteBuffer, (boolean)false);
            while (readByteBuffer.position() != 0) {
                readByteBuffer.flip();
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)readByteBuffer);
                throttler.maybeThrottle(records.sizeInBytes());
                for (MutableRecordBatch batch : records.batches()) {
                    if (batch.isControlBatch()) {
                        transactionMetadata.onControlBatchRead((RecordBatch)batch);
                        continue;
                    }
                    if (transactionMetadata.onBatchRead((RecordBatch)batch)) continue;
                    try (CloseableIterator recordsIterator = batch.streamingIterator(this.decompressionBufferSupplier());){
                        ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                            DurabilityOffsetMapUtils$.$anonfun$filterKeysAndOffset$1(lastCleanOffset, offsetMap, offsetMapEntryCountLimit, record);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                int bytesRead = records.validBytes();
                readByteBuffer.position(bytesRead);
                readByteBuffer.compact();
                Utils.readFully((InputStream)inputStream, (ByteBuffer)readByteBuffer, (boolean)false);
            }
        }
        catch (MemoryLimitExceededException memoryLimitExceededException) {
            throw memoryLimitExceededException;
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(this.msgWithLogIdent(DurabilityOffsetMapUtils$.$anonfun$filterKeysAndOffset$2(e)));
            }
            throw new IOException("Error reading input stream");
        }
        return offsetMap;
    }

    public long filterKeysAndOffset$default$6() {
        return this.OFFSET_MAP_ENTRY_COUNT_LIMIT();
    }

    public void storeOffsetMapInFile(scala.collection.SortedMap<ByteBuffer, OffsetInfo> offsetMap, File path, boolean exists) {
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(DurabilityOffsetMapUtils$.$anonfun$storeOffsetMapInFile$1(path)));
        }
        OffsetMapFile offsetMapFile = new OffsetMapFile(path, exists);
        offsetMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DurabilityOffsetMapUtils$.$anonfun$storeOffsetMapInFile$2(offsetMapFile, x0$1);
            return BoxedUnit.UNIT;
        });
        offsetMapFile.flush();
        offsetMapFile.close();
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.SortedMap<ByteBuffer, OffsetInfo> retrieveOffsetMapInFile(File path, String name) {
        void var3_3;
        SortedMap offsetMap = (SortedMap)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        Iterator<Option<OffsetMapEntryRecord>> fileIterate = new OffsetMapFile(new File(path, name), true).iterator();
        Option fileEntry = (Option)fileIterate.next();
        while (fileEntry.nonEmpty()) {
            offsetMap.put((Object)ByteBuffer.wrap(((OffsetMapEntryRecord)fileEntry.get()).entry().hashedKey()), (Object)new OffsetInfo(((OffsetMapEntryRecord)fileEntry.get()).entry().offsetValue(), ((OffsetMapEntryRecord)fileEntry.get()).entry().isTombStone()));
            fileEntry = (Option)fileIterate.next();
        }
        return var3_3;
    }

    public void mergeOffsetMapFile(File newerFile, File olderFile, File destination) {
        OffsetMapFile newerFileOffsetMap = new OffsetMapFile(newerFile, true);
        OffsetMapFile olderFileOffsetMap = new OffsetMapFile(olderFile, true);
        OffsetMapFile destinationOffsetMap = new OffsetMapFile(destination, false);
        try {
            try {
                Iterator<Option<OffsetMapEntryRecord>> newerFileIterate = newerFileOffsetMap.iterator();
                Iterator<Option<OffsetMapEntryRecord>> olderFileIterate = olderFileOffsetMap.iterator();
                Option newerFileEntry = (Option)newerFileIterate.next();
                Option olderFileEntry = (Option)olderFileIterate.next();
                while (newerFileEntry.nonEmpty() || olderFileEntry.nonEmpty()) {
                    if (newerFileEntry.nonEmpty() && olderFileEntry.nonEmpty()) {
                        int value = ByteBuffer.wrap(((OffsetMapEntryRecord)newerFileEntry.get()).entry().hashedKey()).compareTo(ByteBuffer.wrap(((OffsetMapEntryRecord)olderFileEntry.get()).entry().hashedKey()));
                        if (value == 0) {
                            if (((OffsetMapEntryRecord)newerFileEntry.get()).entry().offsetValue() > ((OffsetMapEntryRecord)olderFileEntry.get()).entry().offsetValue()) {
                                destinationOffsetMap.append(((OffsetMapEntryRecord)newerFileEntry.get()).entry());
                            } else {
                                destinationOffsetMap.append(((OffsetMapEntryRecord)olderFileEntry.get()).entry());
                            }
                            newerFileEntry = (Option)newerFileIterate.next();
                            olderFileEntry = (Option)olderFileIterate.next();
                        }
                        if (value < 0) {
                            destinationOffsetMap.append(((OffsetMapEntryRecord)newerFileEntry.get()).entry());
                            newerFileEntry = (Option)newerFileIterate.next();
                        }
                        if (value <= 0) continue;
                        destinationOffsetMap.append(((OffsetMapEntryRecord)olderFileEntry.get()).entry());
                        olderFileEntry = (Option)olderFileIterate.next();
                        continue;
                    }
                    if (newerFileEntry.nonEmpty()) {
                        destinationOffsetMap.append(((OffsetMapEntryRecord)newerFileEntry.get()).entry());
                        newerFileEntry = (Option)newerFileIterate.next();
                    }
                    if (!olderFileEntry.nonEmpty()) continue;
                    destinationOffsetMap.append(((OffsetMapEntryRecord)olderFileEntry.get()).entry());
                    olderFileEntry = (Option)olderFileIterate.next();
                }
                destinationOffsetMap.flush();
            }
            catch (Exception e) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(DurabilityOffsetMapUtils$.$anonfun$mergeOffsetMapFile$1(e)));
                }
                throw e;
            }
        }
        finally {
            destinationOffsetMap.close();
            newerFileOffsetMap.close();
            olderFileOffsetMap.close();
        }
    }

    public int checkCongruentOffsetMapFile(TopicIdPartition topicIdPartition, File sourceFile, File destinationFile) {
        OffsetMapFile sourceFileOffsetMap = new OffsetMapFile(sourceFile, true);
        OffsetMapFile destinationFileOffsetMap = new OffsetMapFile(destinationFile, true);
        IntRef mismatches = IntRef.create((int)0);
        try {
            Iterator<Option<OffsetMapEntryRecord>> sourceFileIterate = sourceFileOffsetMap.iterator();
            Iterator<Option<OffsetMapEntryRecord>> destinationFileIterate = destinationFileOffsetMap.iterator();
            ObjectRef sourceMessageEntry = ObjectRef.create((Object)((Option)sourceFileIterate.next()));
            ObjectRef destinationMessageEntry = ObjectRef.create((Object)((Option)destinationFileIterate.next()));
            while (((Option)sourceMessageEntry.elem).nonEmpty() || ((Option)destinationMessageEntry.elem).nonEmpty()) {
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (MODULE$.isTombStone((Option<OffsetMapEntryRecord>)((Option)sourceMessageEntry$1.elem))) {
                        if (MODULE$.isTombStone((Option<OffsetMapEntryRecord>)((Option)destinationMessageEntry$1.elem)) && MODULE$.isHashedKeyEqual((Option<OffsetMapEntryRecord>)((Option)sourceMessageEntry$1.elem), (Option<OffsetMapEntryRecord>)((Option)destinationMessageEntry$1.elem))) {
                            destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                        }
                        sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                        throw Breaks$.MODULE$.break();
                    }
                    if (((Option)sourceMessageEntry$1.elem).nonEmpty() && ((Option)destinationMessageEntry$1.elem).nonEmpty()) {
                        boolean isKeyEqual = MODULE$.isHashedKeyEqual((Option<OffsetMapEntryRecord>)((Option)sourceMessageEntry$1.elem), (Option<OffsetMapEntryRecord>)((Option)destinationMessageEntry$1.elem));
                        if (!isKeyEqual || ((OffsetMapEntryRecord)((Option)sourceMessageEntry$1.elem).get()).entry().offsetValue() != ((OffsetMapEntryRecord)((Option)destinationMessageEntry$1.elem).get()).entry().offsetValue()) {
                            DurabilityOffsetMapUtils$ durabilityOffsetMapUtils$ = MODULE$;
                            if (durabilityOffsetMapUtils$ == null) {
                                throw null;
                            }
                            DurabilityOffsetMapUtils$ error_this = durabilityOffsetMapUtils$;
                            if (error_this.logger().underlying().isErrorEnabled()) {
                                error_this.logger().underlying().error(error_this.msgWithLogIdent(DurabilityOffsetMapUtils$.$anonfun$checkCongruentOffsetMapFile$2(topicIdPartition, sourceMessageEntry, destinationMessageEntry)));
                            }
                            ++mismatches$1.elem;
                        }
                        if (!isKeyEqual) {
                            if (ByteBuffer.wrap(((OffsetMapEntryRecord)((Option)sourceMessageEntry$1.elem).get()).entry().hashedKey()).compareTo(ByteBuffer.wrap(((OffsetMapEntryRecord)((Option)destinationMessageEntry$1.elem).get()).entry().hashedKey())) < 0) {
                                sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                                return;
                            }
                            destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                            return;
                        }
                        sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                        destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                        return;
                    }
                    if (((Option)sourceMessageEntry$1.elem).nonEmpty()) {
                        DurabilityOffsetMapUtils$ durabilityOffsetMapUtils$ = MODULE$;
                        if (durabilityOffsetMapUtils$ == null) {
                            throw null;
                        }
                        DurabilityOffsetMapUtils$ error_this = durabilityOffsetMapUtils$;
                        if (error_this.logger().underlying().isErrorEnabled()) {
                            error_this.logger().underlying().error(error_this.msgWithLogIdent(DurabilityOffsetMapUtils$.$anonfun$checkCongruentOffsetMapFile$3(topicIdPartition, sourceMessageEntry)));
                        }
                        sourceMessageEntry$1.elem = (Option)sourceFileIterate.next();
                        ++mismatches$1.elem;
                    }
                    if (((Option)destinationMessageEntry$1.elem).nonEmpty()) {
                        DurabilityOffsetMapUtils$ durabilityOffsetMapUtils$ = MODULE$;
                        if (durabilityOffsetMapUtils$ == null) {
                            throw null;
                        }
                        DurabilityOffsetMapUtils$ error_this = durabilityOffsetMapUtils$;
                        if (error_this.logger().underlying().isErrorEnabled()) {
                            error_this.logger().underlying().error(error_this.msgWithLogIdent(DurabilityOffsetMapUtils$.$anonfun$checkCongruentOffsetMapFile$4(topicIdPartition, destinationMessageEntry)));
                        }
                        destinationMessageEntry$1.elem = (Option)destinationFileIterate.next();
                        ++mismatches$1.elem;
                    }
                });
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(DurabilityOffsetMapUtils$.$anonfun$checkCongruentOffsetMapFile$5(topicIdPartition, e)));
            }
            throw e;
        }
        return mismatches.elem;
    }

    private boolean isTombStone(Option<OffsetMapEntryRecord> messageEntry) {
        return messageEntry.nonEmpty() && ((OffsetMapEntryRecord)messageEntry.get()).entry().isTombStone();
    }

    private boolean isHashedKeyEqual(Option<OffsetMapEntryRecord> sourceMessageEntry, Option<OffsetMapEntryRecord> destinationMessageEntry) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(((OffsetMapEntryRecord)sourceMessageEntry.get()).entry().hashedKey())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(((OffsetMapEntryRecord)destinationMessageEntry.get()).entry().hashedKey()));
    }

    public static final /* synthetic */ void $anonfun$filterKeysAndOffset$1(long lastCleanOffset$1, SortedMap offsetMap$1, long offsetMapEntryCountLimit$1, Record record) {
        if (record.hasKey() && record.offset() <= lastCleanOffset$1) {
            offsetMap$1.put((Object)MODULE$.getHashedBuffer(record.key()), (Object)new OffsetInfo(record.offset(), !record.hasValue()));
        }
        MODULE$.mayThrowMemoryLimitExceededException(offsetMapEntryCountLimit$1, offsetMap$1.size());
    }

    public static final /* synthetic */ String $anonfun$filterKeysAndOffset$2(Exception e$1) {
        return new StringBuilder(46).append("Ran into the exception while reading the data ").append(e$1).toString();
    }

    public static final /* synthetic */ String $anonfun$storeOffsetMapInFile$1(File path$1) {
        return new StringBuilder(26).append("Creating offsetMapFile in ").append(path$1).toString();
    }

    public static final /* synthetic */ void $anonfun$storeOffsetMapInFile$2(OffsetMapFile offsetMapFile$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ByteBuffer k = (ByteBuffer)x0$1._1();
            OffsetInfo v = (OffsetInfo)x0$1._2();
            offsetMapFile$1.append(new OffsetMapEntry(v.isTombstone(), v.offset(), k.array()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$mergeOffsetMapFile$1(Exception e$2) {
        return new StringBuilder(47).append("Ran into exception to while merging the files. ").append(e$2).toString();
    }

    public static final /* synthetic */ String $anonfun$checkCongruentOffsetMapFile$2(TopicIdPartition topicIdPartition$1, ObjectRef sourceMessageEntry$1, ObjectRef destinationMessageEntry$1) {
        return new StringBuilder(50).append("KeyPair Mismatch, ").append(topicIdPartition$1).append(" ").append("source key: ").append(((Option)sourceMessageEntry$1.elem).get()).append("  destination key: ").append(((Option)destinationMessageEntry$1.elem).get()).toString();
    }

    public static final /* synthetic */ String $anonfun$checkCongruentOffsetMapFile$3(TopicIdPartition topicIdPartition$1, ObjectRef sourceMessageEntry$1) {
        return new StringBuilder(58).append("Key missing in destination offset map for ").append(topicIdPartition$1).append(" for source key ").append(((Option)sourceMessageEntry$1.elem).get()).toString();
    }

    public static final /* synthetic */ String $anonfun$checkCongruentOffsetMapFile$4(TopicIdPartition topicIdPartition$1, ObjectRef destinationMessageEntry$1) {
        return new StringBuilder(58).append("Key missing in source offset map for ").append(topicIdPartition$1).append(" for destination key ").append(((Option)destinationMessageEntry$1.elem).get()).toString();
    }

    public static final /* synthetic */ String $anonfun$checkCongruentOffsetMapFile$5(TopicIdPartition topicIdPartition$1, Exception e$3) {
        return new StringBuilder(51).append("Ran into exception to while merging the files for ").append(topicIdPartition$1).append(" ").append(e$3).toString();
    }

    private DurabilityOffsetMapUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.decompressionBufferSupplier = BufferSupplier.create();
        this.digest = MessageDigest.getInstance("MD5");
        this.hashSize = this.digest().getDigestLength();
        this.hashBuffer = new byte[this.hashSize()];
        this.OFFSET_MAP_MEMORY_USAGE_PER_ENTRY = 152;
        this.OFFSET_MAP_ENTRY_COUNT_LIMIT = 0x100000L;
    }
}

