/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.LocalLogSegmentReadAdapter;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogSegment;
import kafka.log.LogSegmentReadAdapter;
import kafka.log.MergedLog$;
import kafka.log.ValidateLogResult$;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.ExtendedOffsetMap;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rMa\u0001\u0002\u0015*\u00019B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005{!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003D\u0011!\u0011\u0006A!A!\u0002\u0013i\u0004\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003q\u0011\u0015!\b\u0001\"\u0001v\u0011\u001d\t\t\u0001\u0001C)\u0003\u0007A\u0011\"!\u0006\u0001\u0001\u0004%I!a\u0006\t\u0013\u0005\u0015\u0002\u00011A\u0005\n\u0005\u001d\u0002\u0002CA\u0017\u0001\u0001\u0006K!!\u0007\t\u0013\u0005=\u0002\u00011A\u0005\n\u0005]\u0001\"CA\u0019\u0001\u0001\u0007I\u0011BA\u001a\u0011!\t9\u0004\u0001Q!\n\u0005e\u0001\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005u\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\t\u0003K\u0002A\u0011A\u0015\u0002h!A\u0011q\u000e\u0001\u0005\u0002%\n\t\bC\u0004\u0002*\u0002!\t!a+\t\u000f\u0005%\b\u0001\"\u0003\u0002l\"9!Q\u0001\u0001\u0005\n\t\u001d\u0001b\u0002B\u000b\u0001\u0011%!q\u0003\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005oA\u0001B!\u000f\u0001\t\u0003I#1\b\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u0011)\b\u0001C\u0001\u0005oBqA!\u001e\u0001\t\u0013\u00119\tC\u0004\u0003\u0018\u0002!IA!'\t\u000f\t=\u0006\u0001\"\u0001\u00032\"9!1\u001c\u0001\u0005\n\tu\u0007b\u0002Bz\u0001\u0011\u0005!Q\u001f\u0005\b\u0007\u0003\u0001A\u0011AB\u0002\u0005\u001d\u0019E.Z1oKJT!AK\u0016\u0002\u00071|wMC\u0001-\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00186!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fMB\u0011a'O\u0007\u0002o)\u0011\u0001hK\u0001\u0006kRLGn]\u0005\u0003u]\u0012q\u0001T8hO&tw-\u0001\u0002jIV\tQ\b\u0005\u00021}%\u0011q(\r\u0002\u0004\u0013:$\u0018aA5eA\u0005IqN\u001a4tKRl\u0015\r]\u000b\u0002\u0007B\u0011AiT\u0007\u0002\u000b*\u0011!F\u0012\u0006\u0003\u000f\"\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005%S\u0015aB:u_J\fw-\u001a\u0006\u0003Y-S!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO&\u0011\u0001+\u0012\u0002\n\u001f\u001a47/\u001a;NCB\f!b\u001c4gg\u0016$X*\u00199!\u00031IwNQ;gM\u0016\u00148+\u001b>f\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0017a\u00053va\n+hMZ3s\u0019>\fGMR1di>\u0014\bC\u0001\u0019W\u0013\t9\u0016G\u0001\u0004E_V\u0014G.Z\u0001\ni\"\u0014x\u000e\u001e;mKJ\u0004\"A\u000e.\n\u0005m;$!\u0003+ie>$H\u000f\\3s\u0003\u0011!\u0018.\\3\u0011\u0005y\u0013W\"A0\u000b\u0005a\u0002'BA1K\u0003\u0019\u0019w.\\7p]&\u00111m\u0018\u0002\u0005)&lW-A\u0005dQ\u0016\u001c7\u000eR8oKB!\u0001G\u001a5m\u0013\t9\u0017GA\u0005Gk:\u001cG/[8ocA\u0011\u0011N[\u0007\u0002A&\u00111\u000e\u0019\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\t\u0001T.\u0003\u0002oc\t!QK\\5u\u00039\u0019G.Z1oKJlU\r\u001e:jGN\u0004\"!\u001d:\u000e\u0003%J!a]\u0015\u0003#1{wm\u00117fC:,'/T3ue&\u001c7/\u0001\u0004=S:LGO\u0010\u000b\u000bm^D\u0018P_>}{z|\bCA9\u0001\u0011\u0015YD\u00021\u0001>\u0011\u0015\tE\u00021\u0001D\u0011\u0015\u0011F\u00021\u0001>\u0011\u0015\u0019F\u00021\u0001>\u0011\u0015!F\u00021\u0001V\u0011\u0015AF\u00021\u0001Z\u0011\u0015aF\u00021\u0001^\u0011\u0015!G\u00021\u0001f\u0011\u0015yG\u00021\u0001q\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0003mC:<'BAA\b\u0003\u0011Q\u0017M^1\n\t\u0005M\u0011\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015I,\u0017\r\u001a\"vM\u001a,'/\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001b\t\tiB\u0003\u0003\u0002 \u00055\u0011a\u00018j_&!\u00111EA\u000f\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u000fe\u0016\fGMQ;gM\u0016\u0014x\fJ3r)\ra\u0017\u0011\u0006\u0005\n\u0003Wy\u0011\u0011!a\u0001\u00033\t1\u0001\u001f\u00132\u0003-\u0011X-\u00193Ck\u001a4WM\u001d\u0011\u0002\u0017]\u0014\u0018\u000e^3Ck\u001a4WM]\u0001\u0010oJLG/\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019A.!\u000e\t\u0013\u0005-\"#!AA\u0002\u0005e\u0011\u0001D<sSR,')\u001e4gKJ\u0004\u0013a\u00073fG>l\u0007O]3tg&|gNQ;gM\u0016\u00148+\u001e9qY&,'/\u0006\u0002\u0002>A\u0019a,a\u0010\n\u0007\u0005\u0005sL\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\u00029\u0011,7m\\7qe\u0016\u001c8/[8o\u0005V4g-\u001a:TkB\u0004H.[3sA\u0005)1\r\\3b]R!\u0011\u0011JA.!\u001d\u0001\u00141JA(\u0003+J1!!\u00142\u0005\u0019!V\u000f\u001d7feA\u0019\u0001'!\u0015\n\u0007\u0005M\u0013G\u0001\u0003M_:<\u0007cA9\u0002X%\u0019\u0011\u0011L\u0015\u0003\u0019\rcW-\u00198feN#\u0018\r^:\t\u000f\u0005uc\u00031\u0001\u0002`\u0005I1\r\\3b]\u0006\u0014G.\u001a\t\u0004c\u0006\u0005\u0014bAA2S\tY1\t\\3b]B\u000b'/Y7t\u0003\u001d!wn\u00117fC:$b!!\u0013\u0002j\u0005-\u0004bBA//\u0001\u0007\u0011q\f\u0005\b\u0003[:\u0002\u0019AA(\u0003-\u0019WO\u001d:f]R$\u0016.\\3\u0002\u001b\rdW-\u00198TK\u001elWM\u001c;t)=a\u00171OA>\u0003#\u000b)*a&\u0002\u001c\u0006\u0015\u0006B\u0002\u0016\u0019\u0001\u0004\t)\bE\u0002r\u0003oJ1!!\u001f*\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\u0005u\u0004\u00041\u0001\u0002\u0000\u0005A1/Z4nK:$8\u000f\u0005\u0004\u0002\u0002\u0006\u001d\u00151R\u0007\u0003\u0003\u0007S1!!\"2\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0013\u000b\u0019IA\u0002TKF\u00042!]AG\u0013\r\ty)\u000b\u0002\u000b\u0019><7+Z4nK:$\bBBAJ1\u0001\u00071)A\u0002nCBDq!!\u001c\u0019\u0001\u0004\ty\u0005C\u0004\u0002\u001ab\u0001\r!!\u0016\u0002\u000bM$\u0018\r^:\t\u000f\u0005u\u0005\u00041\u0001\u0002 \u0006\u0019BO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCB\u0019\u0011/!)\n\u0007\u0005\r\u0016F\u0001\u000eDY\u0016\fg.\u001a3Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rC\u0004\u0002(b\u0001\r!a\u0014\u0002+1,w-Y2z\t\u0016dW\r^3I_JL'p\u001c8Ng\u0006I1\r\\3b]&sGo\u001c\u000b\u0018Y\u00065\u0016\u0011WA^\u0003\u007f\u000b\t-a3\u0002P\u0006M\u0017Q[As\u0003ODa!a,\u001a\u0001\u0004A\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003gK\u0002\u0019AA[\u0003\u0019\u0019x.\u001e:dKB\u0019\u0011/a.\n\u0007\u0005e\u0016FA\u000bM_\u001e\u001cVmZ7f]R\u0014V-\u00193BI\u0006\u0004H/\u001a:\t\u000f\u0005u\u0016\u00041\u0001\u0002\f\u0006!A-Z:u\u0011\u0019\t\u0019*\u0007a\u0001\u0007\"9\u00111Y\rA\u0002\u0005\u0015\u0017\u0001\t:fi\u0006Lg\u000eT3hC\u000eLH)\u001a7fi\u0016\u001c\u0018I\u001c3Uq:l\u0015M]6feN\u00042\u0001MAd\u0013\r\tI-\r\u0002\b\u0005>|G.Z1o\u0011\u001d\ti-\u0007a\u0001\u0003\u001f\n\u0011\u0003Z3mKR,'+\u001a;f]RLwN\\'t\u0011\u0019\t\t.\u0007a\u0001{\u0005\tR.\u0019=M_\u001elUm]:bO\u0016\u001c\u0016N_3\t\u000f\u0005u\u0015\u00041\u0001\u0002 \"9\u0011q[\rA\u0002\u0005e\u0017\u0001\b7bgR\u0014VmY8sIN|e-Q2uSZ,\u0007K]8ek\u000e,'o\u001d\t\t\u0003\u0003\u000bY.a\u0014\u0002`&!\u0011Q\\AB\u0005\ri\u0015\r\u001d\t\u0004\t\u0006\u0005\u0018bAAr\u000b\nQA*Y:u%\u0016\u001cwN\u001d3\t\u000f\u0005e\u0015\u00041\u0001\u0002V!9\u0011QN\rA\u0002\u0005=\u0013!E4s_^\u0014UO\u001a4feN|%OR1jYRIA.!<\u0002p\u0006M\u0018Q\u001f\u0005\b\u0003gS\u0002\u0019AA[\u0011\u0019\t\tP\u0007a\u0001{\u0005A\u0001o\\:ji&|g\u000e\u0003\u0004\u0002Rj\u0001\r!\u0010\u0005\b\u0003oT\u0002\u0019AA}\u00035iW-\\8ssJ+7m\u001c:egB!\u00111 B\u0001\u001b\t\tiPC\u0002\u0002\u0000\u0002\faA]3d_J$\u0017\u0002\u0002B\u0002\u0003{\u0014Q\"T3n_JL(+Z2pe\u0012\u001c\u0018AE:i_VdG\rR5tG\u0006\u0014HMQ1uG\"$b!!2\u0003\n\tM\u0001b\u0002B\u00067\u0001\u0007!QB\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0003w\u0014y!\u0003\u0003\u0003\u0012\u0005u(a\u0003*fG>\u0014HMQ1uG\"Dq!!(\u001c\u0001\u0004\ty*\u0001\ntQ>,H\u000e\u001a*fi\u0006LgNU3d_J$G\u0003EAc\u00053\u0011YBa\b\u0003\"\t%\"1\u0006B\u0017\u0011\u0019\t\u0019\n\ba\u0001\u0007\"9!Q\u0004\u000fA\u0002\u0005\u0015\u0017!\b:fi\u0006Lg\u000eR3mKR,7OR8s\u0019\u0016<\u0017mY=SK\u000e|'\u000fZ:\t\u000f\t-A\u00041\u0001\u0003\u000e!9\u0011q \u000fA\u0002\t\r\u0002\u0003BA~\u0005KIAAa\n\u0002~\n1!+Z2pe\u0012Dq!!'\u001d\u0001\u0004\t)\u0006C\u0004\u0002nq\u0001\r!a\u0014\t\u000f\u00055G\u00041\u0001\u0002P\u0005YqM]8x\u0005V4g-\u001a:t)\ra'1\u0007\u0005\u0007\u0003#l\u0002\u0019A\u001f\u0002\u001dI,7\u000f^8sK\n+hMZ3sgR\tA.A\nhe>,\boU3h[\u0016tGo\u001d\"z'&TX\r\u0006\u0006\u0003>\tU#Q\fB1\u0005K\u0002bAa\u0010\u0003P\u0005}d\u0002\u0002B!\u0005\u0017rAAa\u0011\u0003J5\u0011!Q\t\u0006\u0004\u0005\u000fj\u0013A\u0002\u001fs_>$h(C\u00013\u0013\r\u0011i%M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tFa\u0015\u0003\t1K7\u000f\u001e\u0006\u0004\u0005\u001b\n\u0004bBA??\u0001\u0007!q\u000b\t\u0007\u0003\u0003\u0013I&a#\n\t\tm\u00131\u0011\u0002\t\u0013R,'/\u00192mK\"1!qL\u0010A\u0002u\nq!\\1y'&TX\r\u0003\u0004\u0003d}\u0001\r!P\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\b\u0005Oz\u0002\u0019AA(\u0003Y1\u0017N]:u+:\u001cG.Z1oC\ndWm\u00144gg\u0016$\u0018!\u00077bgR|eMZ:fi\u001a{'OR5sgR\u001cVmZ7f]R$b!a\u0014\u0003n\tM\u0004b\u0002B8A\u0001\u0007!\u0011O\u0001\u0005g\u0016<7\u000f\u0005\u0004\u0003@\t=\u00131\u0012\u0005\b\u0005O\u0002\u0003\u0019AA(\u00039\u0011W/\u001b7e\u001f\u001a47/\u001a;NCB$B\"!2\u0003z\tm$q\u0010BB\u0005\u000bCaAK\u0011A\u0002\u0005U\u0004b\u0002B?C\u0001\u0007\u0011qJ\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0005\u0003\u000b\u0003\u0019AA(\u0003\r)g\u000e\u001a\u0005\u0007\u0003'\u000b\u0003\u0019A\"\t\u000f\u0005e\u0015\u00051\u0001\u0002VQq\u0011Q\u0019BE\u0005\u0017\u0013yI!%\u0003\u0014\nU\u0005B\u0002\u0016#\u0001\u0004\t)\bC\u0004\u0002~\t\u0002\rA!$\u0011\r\u0005\u0005%\u0011LA[\u0011\u001d\u0011iH\ta\u0001\u0003\u001fBqA!!#\u0001\u0004\ty\u0005\u0003\u0004\u0002\u0014\n\u0002\ra\u0011\u0005\b\u00033\u0013\u0003\u0019AA+\u0003a\u0011W/\u001b7e\u001f\u001a47/\u001a;NCB4uN]*fO6,g\u000e\u001e\u000b\u0013\u0003\u000b\u0014YJ!(\u0003 \n\u0005&Q\u0015BU\u0005W\u0013i\u000b\u0003\u0004\u00020\u000e\u0002\r\u0001\u001b\u0005\b\u0003g\u001b\u0003\u0019AA[\u0011\u0019\t\u0019j\ta\u0001\u0007\"9!1U\u0012A\u0002\u0005=\u0013aC:uCJ$xJ\u001a4tKRDqAa*$\u0001\u0004\ty%\u0001\tvaB,'OQ8v]\u0012|eMZ:fi\"1\u0011\u0011[\u0012A\u0002uBq!!($\u0001\u0004\ty\nC\u0004\u0002\u001a\u000e\u0002\r!!\u0016\u0002\u0017Y\fG.\u001b3bi\u0016dun\u001a\u000b\r\u0005g\u0013IMa3\u0003N\n='\u0011\u001c\t\u0005\u0005k\u0013\u0019M\u0004\u0003\u00038\n}f\u0002\u0002B]\u0005{sAAa\u0011\u0003<&\tA&\u0003\u0002+W%\u0019!\u0011Y\u0015\u0002#Y\u000bG.\u001b3bi\u0016dun\u001a*fgVdG/\u0003\u0003\u0003F\n\u001d'!\u0005,bY&$\u0017\r^3M_\u001e\u0014Vm];mi*\u0019!\u0011Y\u0015\t\r)\"\u0003\u0019AA;\u0011\u001d\u0011i\b\na\u0001\u0003\u001fBqA!!%\u0001\u0004\ty\u0005C\u0004\u0003R\u0012\u0002\rAa5\u0002\u001b\t\f7/Z(gMN,G/T1q!\r!%Q[\u0005\u0004\u0005/,%!E#yi\u0016tG-\u001a3PM\u001a\u001cX\r^'ba\"9\u0011\u0011\u0014\u0013A\u0002\u0005U\u0013A\u0005<bY&$\u0017\r^3M_\u001e\u001cVmZ7f]R$\"#a\u0014\u0003`\n\u0005(1\u001dBt\u0005W\u0014iOa<\u0003r\"1\u0011qV\u0013A\u0002!Dq!a-&\u0001\u0004\t)\fC\u0004\u0003f\u0016\u0002\rAa5\u0002\u000f\t\f7/Z'ba\"9!\u0011^\u0013A\u0002\tM\u0017a\u00023jM\u001al\u0015\r\u001d\u0005\b\u0005G+\u0003\u0019AA(\u0011\u0019\t\t.\na\u0001{!9\u0011QT\u0013A\u0002\u0005}\u0005bBAMK\u0001\u0007\u0011QK\u0001\fY><7+Z4nK:$8\u000f\u0006\u0005\u0003\u000e\n](\u0011 B\u007f\u0011\u0019Qc\u00051\u0001\u0002v!9!1 \u0014A\u0002\u0005=\u0013\u0001\u00024s_6DqAa@'\u0001\u0004\ty%\u0001\u0002u_\u0006Q2m\u001c7mK\u000e$\u0018IY8si\u0016$GK]1og\u0006\u001cG/[8ogRA1QAB\u0007\u0007\u001f\u0019\t\u0002\u0005\u0004\u0003@\t=3q\u0001\t\u0004\t\u000e%\u0011bAB\u0006\u000b\nQ\u0011IY8si\u0016$G\u000b\u001f8\t\r):\u0003\u0019AA;\u0011\u001d\u0011ih\na\u0001\u0003\u001fBqA!!(\u0001\u0004\ty\u0005")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final LogCleanerMetrics cleanerMetrics;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, CleanerStats> clean(CleanParams cleanable) {
        void var3_3;
        void var5_4;
        if (cleanable.firstDirtyOffset() >= cleanable.firstUncleanableOffset()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Skip cleaning for log ").append(cleanable.log().name()).append(" because dirty range is not cleanable. ").append("firstDirtyOffset=").append(cleanable.firstDirtyOffset()).append(", firstUncleanableOffset=").append(cleanable.firstUncleanableOffset()).toString());
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)cleanable.firstDirtyOffset()), (Object)new CleanerStats(this.time, this.cleanerMetrics));
        }
        Tuple2<Object, CleanerStats> tuple2 = this.doClean(cleanable, this.time.milliseconds());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        CleanerStats cleanerStats = (CleanerStats)tuple2._2();
        double bytesShrinkageRatio = 1.0 - (double)var5_4.bytesWritten() / (double)var5_4.bytesRead();
        cleanable.log().updateLastShrinkageRatio(bytesShrinkageRatio);
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)var3_3), (Object)var5_4);
    }

    public Tuple2<Object, CleanerStats> doClean(CleanParams cleanable, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Option option = cleanable.log().localLogSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - cleanable.log().config().deleteRetentionMs;
        } else {
            throw new MatchError((Object)option);
        }
        AbstractLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(this.time, this.cleanerMetrics);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        boolean isOffsetMapFull = this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone(isOffsetMapFull);
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.localLogSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(l)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        this.groupSegmentsBySize(log.localLogSegments(cleanable.startOffset(), endOffset), log.config().segmentSize, log.config().maxIndexSize, cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), currentTime, stats, transactionMetadata, l);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(AbstractLog log, Seq<LogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs) {
        LogSegment cleaned = MergedLog$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((LogSegment)segments.head()).baseOffset());
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> currentSegment.readNextOffset()));
                List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainLegacyDeletesAndTxnMarkers = currentSegment.lastModified() > legacyDeleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").append("with an upper bound deletion horizon ").append(legacyDeleteHorizonMs).append(" computed from ").append("the segment last modified time of ").append(currentSegment.lastModified()).append(",").append((Object)(retainLegacyDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString());
                try {
                    LocalLogSegmentReadAdapter segmentAdapter = new LocalLogSegmentReadAdapter(log, currentSegment);
                    this.cleanInto(log.topicPartition(), segmentAdapter, cleaned, map, retainLegacyDeletesAndTxnMarkers, log.config().deleteRetentionMs, log.config().maxMessageSize(), transactionMetadata, lastOffsetOfActiveProducers, stats, currentTime);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments);
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, LogSegmentReadAdapter source, LogSegment dest, OffsetMap map, boolean retainLegacyDeletesAndTxnMarkers, long deleteRetentionMs, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, CleanerStats stats, long currentTime) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, currentTime, deleteRetentionMs, transactionMetadata, lastRecordsOfActiveProducers, map, retainLegacyDeletesAndTxnMarkers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final OffsetMap map$1;
            private final boolean retainLegacyDeletesAndTxnMarkers$2;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                boolean canDiscardBatch = this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2);
                if (batch.isControlBatch()) {
                    if (batch.deleteHorizonMs().isPresent()) {
                        this.discardBatchRecords_$eq(canDiscardBatch && batch.deleteHorizonMs().getAsLong() <= this.currentTime);
                    } else {
                        this.discardBatchRecords_$eq(canDiscardBatch && this.deleteRetentionMs == 0L);
                    }
                } else {
                    this.discardBatchRecords_$eq(canDiscardBatch);
                }
                MemoryRecords.RecordFilter.BatchRetention batchRetention = batch.hasProducerId() && this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).exists((Function1 & Serializable & scala.Serializable)lastRecord -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$checkBatchRetention$1(batch, lastRecord))) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
                return new MemoryRecords.RecordFilter.BatchRetentionResult(batchRetention, canDiscardBatch && batch.isControlBatch());
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                if (batch.isControlBatch()) {
                    return true;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$1, this.retainLegacyDeletesAndTxnMarkers$2, batch, record, this.stats$3, this.currentTime, this.deleteRetentionMs);
            }

            public void onBatchRetained(RecordBatch batch) {
                this.transactionMetadata$2.onBatchRetained(batch);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                if (lastRecord.lastDataOffset.isPresent()) {
                    return batch$1.lastOffset() == lastRecord.lastDataOffset.getAsLong();
                }
                return batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch && batch$1.maxTimestamp() >= lastRecord.lastTimestampMs;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.map$1 = map$1;
                this.retainLegacyDeletesAndTxnMarkers$2 = retainLegacyDeletesAndTxnMarkers$2;
                this.stats$3 = stats$3;
                super(currentTime$2, deleteRetentionMs$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch org.apache.kafka.storage.internals.log.LastRecord )}, serializedLambda);
            }
        };
        int position = source.startPosition();
        while (position < source.endPosition()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            source.readBytes(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            stats.recordThrottledTime(this.throttler.maybeThrottle(records.sizeInBytes()));
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead(), result.keyBytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), retained);
                stats.recordThrottledTime(this.throttler.maybeThrottle(outputBuffer.limit()));
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(source, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(LogSegmentReadAdapter source, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(13).append(source).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            int bytesLeft = source.endPosition() - position;
            if (Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch);
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletesForLegacyRecords, RecordBatch batch, Record record, CleanerStats stats, long currentTime, long deleteRetentionMs) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean legacyRecord = batch.magic() < 2;
            boolean bl = isRetainedValue = record.hasValue() || Cleaner.shouldRetainDeletes$1(legacyRecord, deleteRetentionMs, batch, currentTime, retainDeletesForLegacyRecords);
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && (((LogSegment)segs.head()).size() == 0 || this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE)) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public boolean buildOffsetMap(AbstractLog log, long start, long end, OffsetMap map, CleanerStats stats) {
        Iterable<LogSegmentReadAdapter> dirty = this.logSegments(log, start, end);
        return this.buildOffsetMap(log, dirty, start, end, map, stats);
    }

    private boolean buildOffsetMap(AbstractLog log, Iterable<LogSegmentReadAdapter> segments, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = segments.toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableLike)dirty.tail()).foreach((Function1 & Serializable & scala.Serializable)nextSegment -> {
                nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{nextSegment.baseOffset()}));
                return BoxedUnit.UNIT;
            });
            nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{end}));
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        IntRef mappedSegmentCount = IntRef.create((int)0);
        ((TraversableLike)dirty.zip((GenIterable)nextSegmentStartOffsets, Buffer$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).withFilter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$23))).foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, mappedSegmentCount, dirty, full, map, start, transactionMetadata, stats, x$24);
            return BoxedUnit.UNIT;
        });
        return full.elem;
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegmentReadAdapter source, OffsetMap map, long startOffset, long upperBoundOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = source.startPosition();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < source.endPosition() && map.latestOffset() < upperBoundOffset - 1L) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                source.readBytes(this.readBuffer(), position);
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                stats.recordThrottledTime(this.throttler.maybeThrottle(records.sizeInBytes()));
                int startPosition = position;
                java.util.Iterator batchIter = records.batches().iterator();
                while (batchIter.hasNext() && map.latestOffset() < upperBoundOffset - 1L) {
                    MutableRecordBatch batch = (MutableRecordBatch)batchIter.next();
                    if (batch.isControlBatch()) {
                        transactionMetadata.onControlBatchRead((RecordBatch)batch);
                        stats.indexMessagesRead(1);
                    } else if (transactionMetadata.onBatchRead((RecordBatch)batch)) {
                        stats.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                    } else {
                        try (CloseableIterator recordsIterator = batch.streamingIterator(this.decompressionBufferSupplier());){
                            ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                                Cleaner.$anonfun$buildOffsetMapForSegment$1(startOffset, map, maxDesiredMapSize, object, stats, record);
                                return BoxedUnit.UNIT;
                            });
                        }
                    }
                    if (batch.lastOffset() < startOffset) continue;
                    map.updateLatestOffset(batch.lastOffset());
                }
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(source, position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(upperBoundOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public Enumeration.Value validateLog(AbstractLog log, long start, long end, ExtendedOffsetMap baseOffsetMap, CleanerStats stats) {
        this.offsetMap().clear();
        ExtendedOffsetMap diffOffsetMap = new ExtendedOffsetMap(this.offsetMap());
        Iterable<LogSegmentReadAdapter> segments = this.logSegments(log, start, end);
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = this.collectAbortedTransactions(log, start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        LongRef totalValidatedCount = LongRef.create((long)0L);
        LongRef validatedCount = LongRef.create((long)0L);
        segments.withFilter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$validateLog$1(validatedCount, segment))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            Cleaner.$anonfun$validateLog$2(this, validatedCount, log, baseOffsetMap, diffOffsetMap, start, transactionMetadata, stats, totalValidatedCount, segment);
            return BoxedUnit.UNIT;
        });
        if (validatedCount.elem < 0L) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(166).append(log.topicPartition()).append(": log validation terminated prematurely because diff offset map is full.").append("baseOffsetMap.size: ").append(baseOffsetMap.size()).append(", diffOffsetMap.size=").append(diffOffsetMap.size()).append(", diffOffsetMap.tombstoneCount=").append(diffOffsetMap.tombstoneCount()).append(". ").append("found record count: ").append(totalValidatedCount$1.elem).toString());
            return ValidateLogResult$.MODULE$.Aborted();
        }
        if (totalValidatedCount.elem != (long)(baseOffsetMap.size() - baseOffsetMap.tombstoneCount()) || diffOffsetMap.size() != diffOffsetMap.tombstoneCount()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(215).append(log.topicPartition()).append(": log validation failed. Log data in offset range [").append(start).append(", ").append(end).append(") is inconsistent with baseOffsetMap.").append("baseOffsetMap.size: ").append(baseOffsetMap.size()).append(", baseOffsetMap.tombstoneCount=").append(baseOffsetMap.tombstoneCount()).append(". ").append("diffOffsetMap.size=").append(diffOffsetMap.size()).append(", diffOffsetMap.tombstoneCount=").append(diffOffsetMap.tombstoneCount()).append(". ").append("found record count: ").append(totalValidatedCount$1.elem).toString());
            return ValidateLogResult$.MODULE$.Failed();
        }
        return ValidateLogResult$.MODULE$.Passed();
    }

    private long validateLogSegment(TopicPartition topicPartition, LogSegmentReadAdapter source, ExtendedOffsetMap baseMap, ExtendedOffsetMap diffMap, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int diffMapMaxSize = (int)((double)diffMap.slots() * this.dupBufferLoadFactor);
            IntRef validatedRecordCount = IntRef.create((int)0);
            int position = source.startPosition();
            while (position < source.endPosition()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                source.readBytes(this.readBuffer(), position);
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                stats.recordThrottledTime(this.throttler.maybeThrottle(records.sizeInBytes()));
                int startPosition = position;
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    Cleaner.$anonfun$validateLogSegment$1(this, transactionMetadata, stats, startOffset, baseMap, diffMap, diffMapMaxSize, object, validatedRecordCount, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(source, position, maxLogMessageSize, records);
            }
            this.restoreBuffers();
            return validatedRecordCount.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcJ$sp();
            }
            throw ex;
        }
    }

    public Iterable<LogSegmentReadAdapter> logSegments(AbstractLog log, long from, long to) {
        return (Iterable)((TraversableLike)log.localLogSegments(from, to).map((Function1 & Serializable & scala.Serializable)x$25 -> new LocalLogSegmentReadAdapter(log, (LogSegment)x$25), Iterable$.MODULE$.canBuildFrom())).dropWhile((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$logSegments$2(from, x)));
    }

    public List<AbortedTxn> collectAbortedTransactions(AbstractLog log, long start, long end) {
        return log.collectAbortedTransactions(start, end);
    }

    private static final boolean shouldRetainDeletes$1(boolean legacyRecord$1, long deleteRetentionMs$2, RecordBatch batch$2, long currentTime$3, boolean retainDeletesForLegacyRecords$1) {
        if (!legacyRecord$1) {
            if (deleteRetentionMs$2 != 0L) {
                return !batch$2.deleteHorizonMs().isPresent() || currentTime$3 < batch$2.deleteHorizonMs().getAsLong();
            }
            return false;
        }
        return retainDeletesForLegacyRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$23) {
        if (x$23 == null) {
            throw new MatchError(null);
        }
        boolean bl = !full$1.elem;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, AbstractLog log$4, IntRef mappedSegmentCount$1, Buffer dirty$1, BooleanRef full$1, OffsetMap map$2, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Tuple2 x$24) {
        if (x$24 != null) {
            LogSegmentReadAdapter segment = (LogSegmentReadAdapter)x$24._1();
            long nextSegmentStartOffset = x$24._2$mcJ$sp();
            $this.checkDone.apply((Object)log$4.topicPartition());
            if (segment.endOffset() < log$4.logStartOffset() && segment.baseOffset() < log$4.logStartOffset()) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("End offset of segment: ").append(segment).append(" is smaller than log start offset ").append(log$4.logStartOffset()).append(". Abort current cleaning operation and will be retried").toString());
                throw new LogCleaningAbortedException();
            }
            ++mappedSegmentCount$1.elem;
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Building offset map for segment ").append(mappedSegmentCount$1.elem).append("/").append(dirty$1.size()).append(": ").append(segment).toString());
            full$1.elem = $this.buildOffsetMapForSegment(log$4.topicPartition(), segment, map$2, start$1, nextSegmentStartOffset, log$4.config().maxMessageSize(), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(mappedSegmentCount$1.elem - 1)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey2$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$3.size() < maxDesiredMapSize$1) {
                map$3.put(record.key(), record.offset(), !record.hasValue());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ boolean $anonfun$validateLog$1(LongRef validatedCount$1, LogSegmentReadAdapter segment) {
        return validatedCount$1.elem >= 0L;
    }

    public static final /* synthetic */ void $anonfun$validateLog$2(Cleaner $this, LongRef validatedCount$1, AbstractLog log$5, ExtendedOffsetMap baseOffsetMap$1, ExtendedOffsetMap diffOffsetMap$1, long start$2, CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$6, LongRef totalValidatedCount$1, LogSegmentReadAdapter segment) {
        validatedCount$1.elem = $this.validateLogSegment(log$5.topicPartition(), segment, baseOffsetMap$1, diffOffsetMap$1, start$2, 0, transactionMetadata$4, stats$6);
        if (validatedCount$1.elem > 0L) {
            totalValidatedCount$1.elem += validatedCount$1.elem;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$validateLogSegment$2(long startOffset$2, ExtendedOffsetMap baseMap$1, ExtendedOffsetMap diffMap$1, int diffMapMaxSize$1, Object nonLocalReturnKey3$1, IntRef validatedRecordCount$1, CleanerStats stats$7, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$2) {
            long off = baseMap$1.get(record.key());
            if (off == -1L) {
                if (diffMap$1.size() >= diffMapMaxSize$1) throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey3$1, -1L);
                diffMap$1.put(record.key(), record.offset(), !record.hasValue());
            } else if (record.offset() >= off) {
                if (record.offset() == off) {
                    if (record.hasValue()) {
                        ++validatedRecordCount$1.elem;
                    }
                } else {
                    if (diffMap$1.size() >= diffMapMaxSize$1) throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey3$1, -1L);
                    diffMap$1.put(record.key(), record.offset(), !record.hasValue());
                }
            }
        }
        stats$7.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$validateLogSegment$1(Cleaner $this, CleanedTransactionMetadata transactionMetadata$5, CleanerStats stats$7, long startOffset$2, ExtendedOffsetMap baseMap$1, ExtendedOffsetMap diffMap$1, int diffMapMaxSize$1, Object nonLocalReturnKey3$1, IntRef validatedRecordCount$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$5.onControlBatchRead((RecordBatch)batch);
            stats$7.indexMessagesRead(1);
            return;
        }
        if (transactionMetadata$5.onBatchRead((RecordBatch)batch)) {
            stats$7.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
            return;
        }
        try (CloseableIterator recordsIterator = batch.streamingIterator($this.decompressionBufferSupplier());){
            ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                Cleaner.$anonfun$validateLogSegment$2(startOffset$2, baseMap$1, diffMap$1, diffMapMaxSize$1, nonLocalReturnKey3$1, validatedRecordCount$1, stats$7, record);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$logSegments$2(long from$1, LocalLogSegmentReadAdapter x) {
        return x.endOffset() < from$1;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone, LogCleanerMetrics cleanerMetrics) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        this.cleanerMetrics = cleanerMetrics;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

