/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.OffsetsToClean;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class LogCleanerManager$
implements Logging {
    public static LogCleanerManager$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogCleanerManager$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isCompactAndDelete(AbstractLog log) {
        return log.config().compact() && log.config().delete();
    }

    public long localEarliestDirtyBatchTimestamp(AbstractLog log, long firstDirtyOffset) {
        Iterable<LogSegment> dirtyNonActiveSegments = log.localNonActiveLogSegmentsFrom(firstDirtyOffset);
        Iterable firstBatchTimes = (Iterable)log.getFirstBatchTimestampForSegments(dirtyNonActiveSegments).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$8 -> x$8 > 0L);
        if (firstBatchTimes.nonEmpty()) {
            return BoxesRunTime.unboxToLong((Object)firstBatchTimes.min((Ordering)Ordering.Long$.MODULE$));
        }
        return Long.MAX_VALUE;
    }

    public long maxCompactionDelay(AbstractLog log, Function0<Object> earliestDirtyTimestamp, long now) {
        long maxCompactionLagMs = package$.MODULE$.max(log.config().maxCompactionLagMs(), 0L);
        long cleanUntilTime = now - maxCompactionLagMs;
        if (cleanUntilTime < 0L) {
            return 0L;
        }
        long earliestDirtySegmentTimestamp = earliestDirtyTimestamp.apply$mcJ$sp();
        if (earliestDirtySegmentTimestamp < cleanUntilTime) {
            return cleanUntilTime - earliestDirtySegmentTimestamp;
        }
        return 0L;
    }

    public OffsetsToClean cleanableOffsets(AbstractLog log, Option<Object> lastCleanOffset, long now) {
        boolean bl;
        long l;
        long localLogStartOffset = log.localLogStartOffset();
        long checkpointDirtyOffset = BoxesRunTime.unboxToLong((Object)lastCleanOffset.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> localLogStartOffset));
        if (checkpointDirtyOffset < localLogStartOffset) {
            if (!this.isCompactAndDelete(log) && this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(LogCleanerManager$.$anonfun$cleanableOffsets$2(log, localLogStartOffset, checkpointDirtyOffset)));
            }
            l = localLogStartOffset;
            bl = true;
        } else if (checkpointDirtyOffset > log.logEndOffset()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(LogCleanerManager$.$anonfun$cleanableOffsets$3(log, checkpointDirtyOffset, localLogStartOffset)));
            }
            l = localLogStartOffset;
            bl = true;
        } else {
            l = checkpointDirtyOffset;
            bl = false;
        }
        boolean bl2 = bl;
        long l2 = l;
        long minCompactionLagMs = package$.MODULE$.max(log.config().compactionLagMs(), 0L);
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())), (List)new .colon.colon((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset())), (List)new .colon.colon(minCompactionLagMs > 0L ? log.localNonActiveLogSegmentsFrom(l2).find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager$.$anonfun$cleanableOffsets$4(now, minCompactionLagMs, log, s))).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.baseOffset())) : None$.MODULE$, (List)new .colon.colon(this.dualCompactionCleaningBound(log), (List)Nil$.MODULE$)))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).min((Ordering)Ordering.Long$.MODULE$));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(LogCleanerManager$.$anonfun$cleanableOffsets$8(log, lastCleanOffset, now, l2, firstUncleanableDirtyOffset)));
        }
        return new OffsetsToClean(l2, package$.MODULE$.max(l2, firstUncleanableDirtyOffset), bl2);
    }

    public Tuple2<Object, Object> calculateCleanableBytes(AbstractLog log, long firstDirtyOffset, long uncleanableOffset) {
        long firstUncleanableOffset = ((LogSegment)log.localNonActiveLogSegmentsFrom(uncleanableOffset).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> log.activeSegment())).baseOffset();
        long cleanableBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.localLogSegments(package$.MODULE$.min(firstDirtyOffset, firstUncleanableOffset), firstUncleanableOffset).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2.mcJJ.sp(firstUncleanableOffset, cleanableBytes);
    }

    public Option<Object> dualCompactionCleaningBound(AbstractLog log) {
        if (log.tierPartitionState().isTieringEnabled() && log.config().confluentLogConfig().tierCleanerDualCompaction) {
            return new Some((Object)BoxesRunTime.boxToLong((long)(log.tierPartitionState().committedEndOffset() + 1L)));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$2(AbstractLog log$3, long localLogStartOffset$1, long checkpointDirtyOffset$1) {
        return new StringBuilder(102).append("Resetting first dirty offset of ").append(log$3.name()).append(" to local log start offset ").append(localLogStartOffset$1).append(" ").append("since the checkpointed offset ").append(checkpointDirtyOffset$1).append(" is invalid.").toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$3(AbstractLog log$3, long checkpointDirtyOffset$1, long localLogStartOffset$1) {
        return new StringBuilder(136).append("The last checkpoint dirty offset for partition ").append(log$3.name()).append(" is ").append(checkpointDirtyOffset$1).append(", ").append("which is larger than the log end offset ").append(log$3.logEndOffset()).append(". Resetting to the local log start offset ").append(localLogStartOffset$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$5(AbstractLog log$3, LogSegment s$1, long now$3, long minCompactionLagMs$1, boolean isUncleanable$1) {
        return new StringBuilder(131).append("Checking if log segment may be cleaned: log='").append(log$3.name()).append("' segment.baseOffset=").append(s$1.baseOffset()).append(" ").append("segment.largestTimestamp=").append(s$1.largestTimestamp()).append("; now - compactionLag=").append(now$3 - minCompactionLagMs$1).append("; ").append("is uncleanable=").append(isUncleanable$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$4(long now$3, long minCompactionLagMs$1, AbstractLog log$3, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$3 - minCompactionLagMs$1;
        LogCleanerManager$ logCleanerManager$ = MODULE$;
        if (logCleanerManager$ == null) {
            throw null;
        }
        LogCleanerManager$ debug_this = logCleanerManager$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(LogCleanerManager$.$anonfun$cleanableOffsets$5(log$3, s, now$3, minCompactionLagMs$1, isUncleanable)));
        }
        return isUncleanable;
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$8(AbstractLog log$3, Option lastCleanOffset$1, long now$3, long firstDirtyOffset$1, long firstUncleanableDirtyOffset$1) {
        return new StringBuilder(139).append("Finding range of cleanable offsets for log=").append(log$3.name()).append(". Last clean offset=").append(lastCleanOffset$1).append(" ").append("now=").append(now$3).append(" => firstDirtyOffset=").append(firstDirtyOffset$1).append(" firstUncleanableOffset=").append(firstUncleanableDirtyOffset$1).append(" ").append("activeSegment.baseOffset=").append(log$3.activeSegment().baseOffset()).toString();
    }

    private LogCleanerManager$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

