/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FilesWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.LogLoader$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.MergedLog$;
import kafka.log.SplitSegmentResult;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mx!B\u000f\u001f\u0011\u0003\u0019c!B\u0013\u001f\u0011\u00031\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%\tA\u000e\u0005\u0007\u007f\u0005\u0001\u000b\u0011B\u001c\t\u000f\u0001\u000b\u0011\u0013!C\u0001\u0003\u001a!QE\b\u0001b\u0011!\u0011gA!A!\u0002\u0013\u0019\u0007\u0002C5\u0007\u0005\u0003\u0005\u000b\u0011\u00026\t\u0011U4!\u0011!Q\u0001\nYD\u0011b \u0004\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005=aA!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002\u001c\u0019\u0011\t\u0011)A\u0005\u0003;A!\"a\t\u0007\u0005\u0003\u0005\u000b\u0011BA\u0013\u0011)\tYC\u0002B\u0001B\u0003%\u0011Q\u0006\u0005\u000b\u0003g1!\u0011!Q\u0001\n\u0005U\u0002BCA\u001e\r\t\u0005\t\u0015!\u0003\u00026!Q\u0011Q\b\u0004\u0003\u0002\u0003\u0006I!a\u0010\t\u0015\u0005EcA!A!\u0002\u0013\t\u0019\u0006C\u0005\u0002Z\u0019\u0011\t\u0011)A\u0005\u0007\"11G\u0002C\u0001\u00037Bq!!\u001f\u0007\t\u0003\tY\bC\u0004\u0002\u0004\u001a!I!!\"\t\u000f\u0005Me\u0001\"\u0003\u0002\u0016\"9\u0011\u0011\u0018\u0004\u0005\n\u0005m\u0006bBAb\r\u0011%\u0011Q\u0019\u0005\t\u0003#4A\u0011\u0001\u0010\u0002T\"9\u00111\u001c\u0004\u0005\n\u0005u\u0007bBA{\r\u0011%\u0011q_\u0001\n\u0019><Gj\\1eKJT!a\b\u0011\u0002\u00071|wMC\u0001\"\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001J\u0001\u000e\u0003y\u0011\u0011\u0002T8h\u0019>\fG-\u001a:\u0014\u0007\u00059S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]Ej\u0011a\f\u0006\u0003a\u0001\nQ!\u001e;jYNL!AM\u0018\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012aI\u0001\u0012\u00072,\u0017M\\*ikR$wn\u001e8GS2,W#A\u001c\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00027b]\u001eT\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002?s\t11\u000b\u001e:j]\u001e\f!c\u00117fC:\u001c\u0006.\u001e;e_^tg)\u001b7fA\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u001aT#\u0001\"+\u0005\rC\u0006\u0003\u0002#J\u0017Vk\u0011!\u0012\u0006\u0003\r\u001e\u000b!bY8oGV\u0014(/\u001a8u\u0015\tA5(\u0001\u0003vi&d\u0017B\u0001&F\u00055\u0019uN\\2veJ,g\u000e^'baB\u0011Aj\u0015\b\u0003\u001bF\u0003\"AT\u0015\u000e\u0003=S!\u0001\u0015\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0016&\u0001\u0004Qe\u0016$WMZ\u0005\u0003}QS!AU\u0015\u0011\u0005!2\u0016BA,*\u0005\rIe\u000e^\u0016\u00023B\u0011!lX\u0007\u00027*\u0011A,X\u0001\nk:\u001c\u0007.Z2lK\u0012T!AX\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002a7\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0014\u0007\u00199S&A\u0002eSJ\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ\u001e\u0002\u0005%|\u0017B\u00015f\u0005\u00111\u0015\u000e\\3\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u00111n]\u0007\u0002Y*\u0011QN\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005z'B\u00019r\u0003\u0019\t\u0007/Y2iK*\t!/A\u0002pe\u001eL!\u0001\u001e7\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u000611m\u001c8gS\u001e\u0004\"a^?\u000e\u0003aT!aH=\u000b\u0005i\\\u0018!C5oi\u0016\u0014h.\u00197t\u0015\tah.A\u0004ti>\u0014\u0018mZ3\n\u0005yD(!\u0003'pO\u000e{gNZ5h\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002\u0004\u0005-QBAA\u0003\u0015\rA\u0015q\u0001\u0006\u0004\u0003\u0013q\u0017AB:feZ,'/\u0003\u0003\u0002\u000e\u0005\u0015!!C*dQ\u0016$W\u000f\\3s\u0003\u0011!\u0018.\\3\u0011\t\u0005M\u0011qC\u0007\u0003\u0003+Q!\u0001\r7\n\t\u0005e\u0011Q\u0003\u0002\u0005)&lW-\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\t\u0004o\u0006}\u0011bAA\u0011q\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\f\u0001\u0003[1e\u00072,\u0017M\\*ikR$wn\u001e8\u0011\u0007!\n9#C\u0002\u0002*%\u0012qAQ8pY\u0016\fg.\u0001\u0005tK\u001elWM\u001c;t!\r!\u0013qF\u0005\u0004\u0003cq\"a\u0003'pON+w-\\3oiN\f\u0001\u0004\\8h'R\f'\u000f^(gMN,Go\u00115fG.\u0004x.\u001b8u!\rA\u0013qG\u0005\u0004\u0003sI#\u0001\u0002'p]\u001e\fqC]3d_Z,'/\u001f)pS:$8\t[3dWB|\u0017N\u001c;\u0002!1,\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007#\u0002\u0015\u0002B\u0005\u0015\u0013bAA\"S\t1q\n\u001d;j_:\u0004B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017J\u0018!B3q_\u000eD\u0017\u0002BA(\u0003\u0013\u0012A\u0003T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",\u0017\u0001\u00069s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'\u000fE\u0002x\u0003+J1!a\u0016y\u0005Q\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u0006!b.^7SK6\f\u0017N\\5oON+w-\\3oiN$B$!\u0018\u0002`\u0005\u0005\u00141MA3\u0003O\nI'a\u001b\u0002n\u0005=\u0014\u0011OA:\u0003k\n9\b\u0005\u0002%\r!)!\r\u0006a\u0001G\")\u0011\u000e\u0006a\u0001U\")Q\u000f\u0006a\u0001m\"1q\u0010\u0006a\u0001\u0003\u0003Aq!a\u0004\u0015\u0001\u0004\t\t\u0002C\u0004\u0002\u001cQ\u0001\r!!\b\t\u000f\u0005\rB\u00031\u0001\u0002&!9\u00111\u0006\u000bA\u0002\u00055\u0002bBA\u001a)\u0001\u0007\u0011Q\u0007\u0005\b\u0003w!\u0002\u0019AA\u001b\u0011\u001d\ti\u0004\u0006a\u0001\u0003\u007fAq!!\u0015\u0015\u0001\u0004\t\u0019\u0006\u0003\u0005\u0002ZQ\u0001\n\u00111\u0001D\u0003\u0011aw.\u00193\u0015\u0005\u0005u\u0004cA<\u0002\u0000%\u0019\u0011\u0011\u0011=\u0003!1{\u0017\rZ3e\u0019><wJ\u001a4tKR\u001c\u0018A\t:f[>4X\rV3na\u001aKG.Z:B]\u0012\u001cu\u000e\u001c7fGR\u001cv/\u00199GS2,7\u000f\u0006\u0002\u0002\bB)\u0011\u0011RAHG6\u0011\u00111\u0012\u0006\u0004\u0003\u001bK\u0013AC2pY2,7\r^5p]&!\u0011\u0011SAF\u0005\r\u0019V\r^\u0001\u0016e\u0016$(/_(o\u001f\u001a47/\u001a;Pm\u0016\u0014h\r\\8x+\u0011\t9*!(\u0015\t\u0005e\u0015q\u0016\t\u0005\u00037\u000bi\n\u0004\u0001\u0005\u000f\u0005}uC1\u0001\u0002\"\n\tA+\u0005\u0003\u0002$\u0006%\u0006c\u0001\u0015\u0002&&\u0019\u0011qU\u0015\u0003\u000f9{G\u000f[5oOB\u0019\u0001&a+\n\u0007\u00055\u0016FA\u0002B]fDq!!-\u0018\u0001\u0004\t\u0019,\u0001\u0002g]B)\u0001&!.\u0002\u001a&\u0019\u0011qW\u0015\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014\u0001\u00057pC\u0012\u001cVmZ7f]R4\u0015\u000e\\3t)\t\ti\fE\u0002)\u0003\u007fK1!!1*\u0005\u0011)f.\u001b;\u0002\u001dI,7m\u001c<feN+w-\\3oiR\u0019Q+a2\t\u000f\u0005%\u0017\u00041\u0001\u0002L\u000691/Z4nK:$\bc\u0001\u0013\u0002N&\u0019\u0011q\u001a\u0010\u0003\u00151{wmU3h[\u0016tG/\u0001\u0006sK\u000e|g/\u001a:M_\u001e$\"!!6\u0011\u000f!\n9.!\u000e\u00026%\u0019\u0011\u0011\\\u0015\u0003\rQ+\b\u000f\\33\u0003q\u0011X-\\8wK\u0006sG\rR3mKR,7+Z4nK:$8/Q:z]\u000e$B!!0\u0002`\"9\u0011\u0011]\u000eA\u0002\u0005\r\u0018\u0001E:fO6,g\u000e^:U_\u0012+G.\u001a;f!\u0019\t)/a<\u0002L:!\u0011q]Av\u001d\rq\u0015\u0011^\u0005\u0002U%\u0019\u0011Q^\u0015\u0002\u000fA\f7m[1hK&!\u0011\u0011_Az\u0005!IE/\u001a:bE2,'bAAwS\u0005aB-\u001a7fi\u0016\u0004&o\u001c3vG\u0016\u00148K\\1qg\"|Go]!ts:\u001cG\u0003BA_\u0003sDq!a\u000b\u001d\u0001\u0004\t\u0019\u000f")
public class LogLoader
implements Logging {
    private final File dir;
    private final TopicPartition topicPartition;
    private final LogConfig config;
    private final Scheduler scheduler;
    private final Time time;
    private final LogDirFailureChannel logDirFailureChannel;
    private final boolean hadCleanShutdown;
    private final LogSegments segments;
    private final long logStartOffsetCheckpoint;
    private final long recoveryPointCheckpoint;
    private final Option<LeaderEpochFileCache> leaderEpochCache;
    private final ProducerStateManager producerStateManager;
    private final ConcurrentMap<String, Object> numRemainingSegments;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ConcurrentMap<String, Object> $lessinit$greater$default$13() {
        return LogLoader$.MODULE$.$lessinit$greater$default$13();
    }

    public static String CleanShutdownFile() {
        return LogLoader$.MODULE$.CleanShutdownFile();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load() {
        long l;
        long l2;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles();
        LongRef minSwapFileOffset = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxSwapFileOffset = LongRef.create((long)Long.MIN_VALUE);
        ((IterableLike)swapFiles.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MergedLog$.MODULE$.isLogFile(new File(Utils.replaceSuffix((String)f.getPath(), (String)MergedLog$.MODULE$.SwapFileSuffix(), (String)"")))))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            LogLoader.$anonfun$load$2(this, minSwapFileOffset, maxSwapFileOffset, f);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Object object;
            block6: {
                try {
                    if (!file.getName().endsWith(MergedLog$.MODULE$.SwapFileSuffix())) {
                        long offset = MergedLog$.MODULE$.offsetFromFile((File)file);
                        if (offset >= minSwapFileOffset$1.elem && offset < maxSwapFileOffset$1.elem) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Deleting segment files ").append(file.getName()).append(" that is compacted but has not been deleted yet.").toString());
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        break block6;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (file.getName().endsWith(MergedLog$.MODULE$.SwapFileSuffix())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Recovering file ").append(file.getName()).append(" by renaming from ").append(MergedLog$.MODULE$.SwapFileSuffix()).append(" files.").toString());
                return BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(Utils.replaceSuffix((String)file.getPath(), (String)MergedLog$.MODULE$.SwapFileSuffix(), (String)""))));
            }
            return BoxedUnit.UNIT;
        });
        while (true) {
            try {
                LogLoader.$anonfun$load$10(this);
            }
            catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                SplitSegmentResult retryOnOffsetOverflow_result = MergedLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_e.segment(), this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
                this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                continue;
            }
            break;
        }
        if (!this.dir.getAbsolutePath().endsWith(MergedLog$.MODULE$.DeleteDirSuffix())) {
            void var7_11;
            void var5_10;
            Tuple2 tuple2;
            while (true) {
                try {
                    tuple2 = this.recoverLog();
                }
                catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                    SplitSegmentResult retryOnOffsetOverflow_result = MergedLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_e.segment(), this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
                    this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                    continue;
                }
                break;
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            long newRecoveryPoint = tuple22._1$mcJ$sp();
            long nextOffset = tuple22._2$mcJ$sp();
            ((LogSegment)this.segments.lastSegment().get()).resizeIndexes(this.config.maxIndexSize);
            l2 = var5_10;
            l = var7_11;
        } else {
            if (this.segments.isEmpty()) {
                File x$9 = this.dir;
                long x$10 = 0L;
                LogConfig x$11 = this.config;
                Time x$12 = this.time;
                int x$13 = this.config.initFileSize();
                boolean x$14 = LogSegment$.MODULE$.open$default$5();
                boolean x$15 = LogSegment$.MODULE$.open$default$7();
                String x$16 = LogSegment$.MODULE$.open$default$8();
                this.segments.add(LogSegment$.MODULE$.open(x$9, x$10, x$11, x$12, x$14, x$13, x$15, x$16));
            }
            l2 = 0L;
            l = 0L;
        }
        long l3 = l;
        long l4 = l2;
        this.leaderEpochCache.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.truncateFromEnd(l3);
            return BoxedUnit.UNIT;
        });
        this.leaderEpochCache.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.truncateFromStart(this.logStartOffsetCheckpoint, true);
            return BoxedUnit.UNIT;
        });
        this.producerStateManager.removeStraySnapshots(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)this.segments.baseOffsets().map((Function1 & Serializable & scala.Serializable)x -> LogLoader.$anonfun$load$14(BoxesRunTime.unboxToLong((Object)x)), Iterable$.MODULE$.canBuildFrom())).asJavaCollection());
        LogSegment activeSegment = (LogSegment)this.segments.lastSegment().get();
        return new LoadedLogOffsets(l4, new LogOffsetMetadata(l3, activeSegment.baseOffset(), activeSegment.size()));
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> removeTempFilesAndCollectSwapFiles() {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Set swapFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set cleanedFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef minCleanedFileOffset = LongRef.create((long)Long.MAX_VALUE);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (!file.canRead()) {
                throw new IOException(new StringBuilder(20).append("Could not read file ").append(file).toString());
            }
            String filename = file.getName();
            if (filename.endsWith(".deleted") && !filename.endsWith(Snapshots.DELETE_SUFFIX)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deleting stray temporary file ").append(file.getAbsolutePath()).toString());
                return BoxesRunTime.boxToBoolean((boolean)FilesWrapper.deleteIfExists((Path)file.toPath()));
            }
            if (filename.endsWith(MergedLog$.MODULE$.CleanedFileSuffix())) {
                minCleanedFileOffset$1.elem = Math.min(MergedLog$.MODULE$.offsetFromFile((File)file), minCleanedFileOffset$1.elem);
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(MergedLog$.MODULE$.TierCleanedFileSuffix())) {
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(MergedLog$.MODULE$.SwapFileSuffix())) {
                return swapFiles.$plus$eq(file);
            }
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = swapFiles.partition((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$4(minCleanedFileOffset, file)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Set invalidSwapFiles = (scala.collection.mutable.Set)tuple2._1();
        scala.collection.mutable.Set validSwapFiles = (scala.collection.mutable.Set)tuple2._2();
        void invalidSwapFiles2 = var5_5;
        void validSwapFiles2 = var6_6;
        invalidSwapFiles2.foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$5(this, minCleanedFileOffset, file)));
        cleanedFiles.foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$7(this, file)));
        return validSwapFiles2;
    }

    private <T> T retryOnOffsetOverflow(Function0<T> fn) {
        while (true) {
            try {
                return (T)fn.apply();
            }
            catch (LogSegmentOffsetOverflowException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                SplitSegmentResult result = MergedLog$.MODULE$.splitOverflowedSegment(e.segment(), this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
                this.deleteProducerSnapshotsAsync(result.deletedSegments());
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName(), (Ordering)Ordering.String$.MODULE$))).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (MergedLog$.MODULE$.isIndexFile((File)file)) {
                long offset = MergedLog$.MODULE$.offsetFromFile((File)file);
                if (!MergedLog$.MODULE$.logFile($this.dir, offset, MergedLog$.MODULE$.logFile$default$3()).exists()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Found an orphaned index file ").append(file.getAbsolutePath()).append(", with no corresponding log file.").toString());
                    return BoxesRunTime.boxToBoolean((boolean)FilesWrapper.deleteIfExists((Path)file.toPath()));
                }
                return BoxedUnit.UNIT;
            }
            if (MergedLog$.MODULE$.isLogFile((File)file)) {
                long baseOffset = MergedLog$.MODULE$.offsetFromFile((File)file);
                boolean timeIndexFileNewlyCreated = !MergedLog$.MODULE$.timeIndexFile($this.dir, baseOffset, MergedLog$.MODULE$.timeIndexFile$default$3()).exists();
                LogSegment segment = LogSegment$.MODULE$.open($this.dir, baseOffset, $this.config, $this.time, true, LogSegment$.MODULE$.open$default$6(), LogSegment$.MODULE$.open$default$7(), LogSegment$.MODULE$.open$default$8());
                try {
                    segment.sanityCheck(timeIndexFileNewlyCreated);
                }
                catch (NoSuchFileException noSuchFileException) {
                    if ($this.hadCleanShutdown || segment.baseOffset() < $this.recoveryPointCheckpoint) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(109).append("Could not find offset index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(", recovering segment and rebuilding index files...").toString());
                    }
                    this.recoverSegment(segment);
                }
                catch (CorruptIndexException e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Found a corrupted index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(" due to ").append(e.getMessage()).append("}, recovering segment and").append(" rebuilding index files...").toString());
                    this.recoverSegment(segment);
                }
                return $this.segments.add(segment);
            }
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private int recoverSegment(LogSegment segment) {
        void var3_3;
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition, this.dir, this.producerStateManager.maxTransactionTimeoutMs(), this.producerStateManager.producerStateManagerConfig(), this.time, this.producerStateManager.producerIdQuotaRecorder());
        MergedLog$.MODULE$.rebuildProducerState(producerStateManager, this.segments, this.logStartOffsetCheckpoint, segment.baseOffset(), this.config.recordVersion(), this.time, false, this.logIdent());
        int bytesTruncated = segment.recover(producerStateManager, this.leaderEpochCache);
        producerStateManager.takeSnapshot();
        return (int)var3_3;
    }

    public Tuple2<Object, Object> recoverLog() {
        Tuple2.mcJJ.sp sp2;
        boolean bl;
        if (!this.hadCleanShutdown) {
            Iterable<LogSegment> unflushed = this.segments.values(this.recoveryPointCheckpoint, Long.MAX_VALUE);
            int numUnflushed = unflushed.size();
            Iterator unflushedIter = unflushed.iterator();
            boolean truncated = false;
            IntRef numFlushed = IntRef.create((int)0);
            String threadName = Thread.currentThread().getName();
            this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)numUnflushed));
            while (unflushedIter.hasNext() && !truncated) {
                int n;
                LogSegment segment = (LogSegment)unflushedIter.next();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Recovering unflushed segment ").append(segment.baseOffset()).append(". ").append(numFlushed$1.elem).append("/").append(numUnflushed).append(" recovered for ").append($this.topicPartition).append(".").toString());
                try {
                    n = this.recoverSegment(segment);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long startOffset = segment.baseOffset();
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Found invalid offset during recovery. Deleting the").append(" corrupt segment and creating an empty one with starting offset ").append(startOffset).toString());
                    n = segment.truncateTo(startOffset);
                }
                if (n > 0) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Corruption found in segment ").append(segment.baseOffset()).append(",").append(" truncating to offset ").append(segment.readNextOffset()).toString());
                    this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)unflushedIter.toList());
                    truncated = true;
                    this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)0));
                    continue;
                }
                ++numFlushed.elem;
                this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)(numUnflushed - numFlushed.elem)));
            }
        }
        Option logEndOffsetOption = this.deleteSegmentsIfLogStartGreaterThanLogEnd$1();
        if (this.segments.isEmpty()) {
            File x$1 = this.dir;
            long x$2 = this.logStartOffsetCheckpoint;
            LogConfig x$3 = this.config;
            Time x$4 = this.time;
            int x$5 = this.config.initFileSize();
            boolean x$6 = this.config.preallocate;
            boolean x$7 = LogSegment$.MODULE$.open$default$5();
            String x$8 = LogSegment$.MODULE$.open$default$8();
            this.segments.add(LogSegment$.MODULE$.open(x$1, x$2, x$3, x$4, x$7, x$5, x$6, x$8));
        }
        if ((bl = this.hadCleanShutdown) && logEndOffsetOption instanceof Some) {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)logEndOffsetOption).value());
            sp2 = new Tuple2.mcJJ.sp(logEndOffset, logEndOffset);
        } else {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)logEndOffsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((LogSegment)$this.segments.lastSegment().get()).readNextOffset()));
            sp2 = new Tuple2.mcJJ.sp(Math.min(this.recoveryPointCheckpoint, logEndOffset), logEndOffset);
        }
        return sp2;
    }

    private void removeAndDeleteSegmentsAsync(Iterable<LogSegment> segmentsToDelete) {
        if (segmentsToDelete.nonEmpty()) {
            List toDelete = segmentsToDelete.toList();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Deleting segments as part of log recovery: ").append(toDelete.mkString(",")).toString());
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                this.segments.remove(segment.baseOffset());
                return BoxedUnit.UNIT;
            });
            MergedLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)toDelete, true, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
            this.deleteProducerSnapshotsAsync(segmentsToDelete);
        }
    }

    private void deleteProducerSnapshotsAsync(Iterable<LogSegment> segments) {
        MergedLog$.MODULE$.deleteProducerSnapshots(segments, this.producerStateManager, true, this.scheduler, this.config, this.logDirFailureChannel, this.dir.getParent(), this.topicPartition);
    }

    public static final /* synthetic */ void $anonfun$load$2(LogLoader $this, LongRef minSwapFileOffset$1, LongRef maxSwapFileOffset$1, File f) {
        long baseOffset = MergedLog$.MODULE$.offsetFromFile(f);
        File x$1 = f.getParentFile();
        LogConfig x$3 = $this.config;
        Time x$4 = $this.time;
        boolean x$5 = true;
        String x$6 = MergedLog$.MODULE$.SwapFileSuffix();
        int x$7 = LogSegment$.MODULE$.open$default$6();
        boolean x$8 = LogSegment$.MODULE$.open$default$7();
        LogSegment segment = LogSegment$.MODULE$.open(x$1, baseOffset, x$3, x$4, x$5, x$7, x$8, x$6);
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Found log file ").append(f.getPath()).append(" from interrupted swap operation, which is recoverable from ").append(MergedLog$.MODULE$.SwapFileSuffix()).append(" files by renaming.").toString());
        minSwapFileOffset$1.elem = Math.min(segment.baseOffset(), minSwapFileOffset$1.elem);
        maxSwapFileOffset$1.elem = Math.max(segment.readNextOffset(), maxSwapFileOffset$1.elem);
    }

    public static final /* synthetic */ void $anonfun$load$10(LogLoader $this) {
        $this.segments.close();
        $this.segments.clear();
        $this.loadSegmentFiles();
    }

    public static final /* synthetic */ Long $anonfun$load$14(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$4(LongRef minCleanedFileOffset$1, File file) {
        return MergedLog$.MODULE$.offsetFromFile(file) >= minCleanedFileOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$5(LogLoader $this, LongRef minCleanedFileOffset$1, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Deleting invalid swap file ").append(file.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString());
        return FilesWrapper.deleteIfExists((Path)file.toPath());
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$7(LogLoader $this, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Deleting stray .clean file ").append(file.getAbsolutePath()).toString());
        return FilesWrapper.deleteIfExists((Path)file.toPath());
    }

    private final Option deleteSegmentsIfLogStartGreaterThanLogEnd$1() {
        if (this.segments.nonEmpty()) {
            long logEndOffset = ((LogSegment)this.segments.lastSegment().get()).readNextOffset();
            if (logEndOffset >= this.logStartOffsetCheckpoint) {
                return new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(148).append("Deleting all segments because logEndOffset (").append(logEndOffset).append(") ").append("is smaller than logStartOffset ").append($this.logStartOffsetCheckpoint).append(". ").append("This could happen if segment files were deleted from the file system.").toString());
            this.removeAndDeleteSegmentsAsync(this.segments.values());
            this.leaderEpochCache.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.clearAndFlush();
                return BoxedUnit.UNIT;
            });
            this.producerStateManager.truncateFullyAndStartAt(this.logStartOffsetCheckpoint);
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public LogLoader(File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, Time time, LogDirFailureChannel logDirFailureChannel, boolean hadCleanShutdown, LogSegments segments, long logStartOffsetCheckpoint, long recoveryPointCheckpoint, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, ConcurrentMap<String, Object> numRemainingSegments) {
        this.dir = dir;
        this.topicPartition = topicPartition;
        this.config = config;
        this.scheduler = scheduler;
        this.time = time;
        this.logDirFailureChannel = logDirFailureChannel;
        this.hadCleanShutdown = hadCleanShutdown;
        this.segments = segments;
        this.logStartOffsetCheckpoint = logStartOffsetCheckpoint;
        this.recoveryPointCheckpoint = recoveryPointCheckpoint;
        this.leaderEpochCache = leaderEpochCache;
        this.producerStateManager = producerStateManager;
        this.numRemainingSegments = numRemainingSegments;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(29).append("[LogLoader partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
    }
}

